/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.saga.engine.invoker.impl;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.seata.common.exception.FrameworkErrorCode;
import org.apache.seata.common.util.CollectionUtils;
import org.apache.seata.saga.engine.exception.EngineExecutionException;
import org.apache.seata.saga.engine.invoker.ServiceInvoker;
import org.apache.seata.saga.engine.pcext.handlers.ServiceTaskStateHandler;
import org.apache.seata.saga.engine.utils.ExceptionUtils;
import org.apache.seata.saga.statelang.domain.ServiceTaskState;
import org.apache.seata.saga.statelang.domain.TaskState;
import org.apache.seata.saga.statelang.domain.impl.ServiceTaskStateImpl;
import org.apache.seata.saga.statelang.parser.JsonParser;
import org.apache.seata.saga.statelang.parser.JsonParserFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class SpringBeanServiceInvoker
implements ServiceInvoker,
ApplicationContextAware {
    private static final Logger LOGGER = LoggerFactory.getLogger(SpringBeanServiceInvoker.class);
    private ApplicationContext applicationContext;
    private ThreadPoolExecutor threadPoolExecutor;
    private String sagaJsonParser;

    @Override
    public Object invoke(ServiceTaskState serviceTaskState, final Object ... input) throws Throwable {
        final ServiceTaskStateImpl state = (ServiceTaskStateImpl)serviceTaskState;
        if (state.isAsync()) {
            if (this.threadPoolExecutor == null) {
                if (LOGGER.isWarnEnabled()) {
                    LOGGER.warn("threadPoolExecutor is null, Service[{}.{}] cannot execute asynchronously, executing synchronously now. stateName: {}", new Object[]{state.getServiceName(), state.getServiceMethod(), state.getName()});
                }
                return this.doInvoke(state, input);
            }
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Submit Service[{}.{}] to asynchronously executing. stateName: {}", new Object[]{state.getServiceName(), state.getServiceMethod(), state.getName()});
            }
            this.threadPoolExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        SpringBeanServiceInvoker.this.doInvoke(state, input);
                    }
                    catch (Throwable e) {
                        LOGGER.error("Invoke Service[" + state.getServiceName() + "." + state.getServiceMethod() + "] failed.", e);
                    }
                }
            });
            return null;
        }
        return this.doInvoke(state, input);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object doInvoke(ServiceTaskStateImpl state, Object[] input) throws Throwable {
        Object bean = this.applicationContext.getBean(state.getServiceName());
        Method method = state.getMethod();
        if (method == null) {
            ServiceTaskStateImpl serviceTaskStateImpl = state;
            synchronized (serviceTaskStateImpl) {
                method = state.getMethod();
                if (method == null && (method = this.findMethod(bean.getClass(), state.getServiceMethod(), state.getParameterTypes())) != null) {
                    state.setMethod(method);
                }
            }
        }
        if (method == null) {
            throw new EngineExecutionException("No such method[" + state.getServiceMethod() + "] on BeanClass[" + bean.getClass() + "]", FrameworkErrorCode.NoSuchMethod);
        }
        Object[] args = new Object[method.getParameterCount()];
        try {
            Class<?>[] paramTypes = method.getParameterTypes();
            if (input != null && input.length > 0) {
                int len = input.length < paramTypes.length ? input.length : paramTypes.length;
                for (int i = 0; i < len; ++i) {
                    args[i] = this.toJavaObject(input[i], paramTypes[i]);
                }
            }
        }
        catch (Exception e) {
            throw new EngineExecutionException(e, "Input to java object error, Method[" + state.getServiceMethod() + "] on BeanClass[" + bean.getClass() + "]", FrameworkErrorCode.InvalidParameter);
        }
        if (!Modifier.isPublic(method.getModifiers())) {
            throw new EngineExecutionException("Method[" + method.getName() + "] must be public", FrameworkErrorCode.MethodNotPublic);
        }
        HashMap retryCountMap = new HashMap();
        while (true) {
            try {
                return this.invokeMethod(bean, method, args);
            }
            catch (Throwable e) {
                TaskState.Retry matchedRetryConfig = this.matchRetryConfig(state.getRetry(), e);
                if (matchedRetryConfig == null) {
                    throw e;
                }
                AtomicInteger retryCount = CollectionUtils.computeIfAbsent(retryCountMap, matchedRetryConfig, key -> new AtomicInteger(0));
                if (retryCount.intValue() >= matchedRetryConfig.getMaxAttempts()) {
                    throw e;
                }
                double intervalSeconds = matchedRetryConfig.getIntervalSeconds();
                double backoffRate = matchedRetryConfig.getBackoffRate();
                long currentInterval = (long)(retryCount.intValue() > 0 ? intervalSeconds * backoffRate * (double)retryCount.intValue() * 1000.0 : intervalSeconds * 1000.0);
                if (LOGGER.isWarnEnabled()) {
                    LOGGER.warn("Invoke Service[" + state.getServiceName() + "." + state.getServiceMethod() + "] failed, will retry after " + currentInterval + " millis, current retry count: " + retryCount.intValue(), e);
                }
                try {
                    Thread.sleep(currentInterval);
                }
                catch (InterruptedException e1) {
                    LOGGER.warn("Retry interval sleep error", (Throwable)e1);
                }
                retryCount.incrementAndGet();
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TaskState.Retry matchRetryConfig(List<TaskState.Retry> retryList, Throwable e) {
        if (CollectionUtils.isNotEmpty(retryList)) {
            for (TaskState.Retry retryConfig : retryList) {
                List<String> exceptions = retryConfig.getExceptions();
                if (CollectionUtils.isEmpty(exceptions)) {
                    if (!ExceptionUtils.isNetException(e)) continue;
                    return retryConfig;
                }
                List<Class<? extends Exception>> exceptionClasses = retryConfig.getExceptionClasses();
                if (exceptionClasses == null) {
                    TaskState.Retry retry = retryConfig;
                    synchronized (retry) {
                        exceptionClasses = retryConfig.getExceptionClasses();
                        if (exceptionClasses == null) {
                            exceptionClasses = new ArrayList<Class<? extends Exception>>(exceptions.size());
                            for (String expStr : exceptions) {
                                Class<?> expClass = null;
                                try {
                                    expClass = ServiceTaskStateHandler.class.getClassLoader().loadClass(expStr);
                                }
                                catch (Exception e1) {
                                    LOGGER.warn("Cannot Load Exception Class by getClass().getClassLoader()", (Throwable)e1);
                                    try {
                                        expClass = Thread.currentThread().getContextClassLoader().loadClass(expStr);
                                    }
                                    catch (Exception e2) {
                                        LOGGER.warn("Cannot Load Exception Class by Thread.currentThread().getContextClassLoader()", (Throwable)e2);
                                    }
                                }
                                if (expClass == null) continue;
                                exceptionClasses.add(expClass);
                            }
                            retryConfig.setExceptionClasses(exceptionClasses);
                        }
                    }
                }
                for (Class clazz : exceptionClasses) {
                    if (!clazz.isAssignableFrom(e.getClass())) continue;
                    return retryConfig;
                }
            }
        }
        return null;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public void setThreadPoolExecutor(ThreadPoolExecutor threadPoolExecutor) {
        this.threadPoolExecutor = threadPoolExecutor;
    }

    protected Method findMethod(Class<?> clazz, String methodName, List<String> parameterTypes) {
        if (CollectionUtils.isEmpty(parameterTypes)) {
            return BeanUtils.findDeclaredMethodWithMinimalParameters(clazz, (String)methodName);
        }
        Class[] paramClassTypes = new Class[parameterTypes.size()];
        for (int i = 0; i < parameterTypes.size(); ++i) {
            paramClassTypes[i] = this.classForName(parameterTypes.get(i));
        }
        return BeanUtils.findDeclaredMethod(clazz, (String)methodName, (Class[])paramClassTypes);
    }

    protected Class classForName(String className) {
        Class<?> clazz = this.getPrimitiveClass(className);
        if (clazz == null) {
            try {
                clazz = Class.forName(className);
            }
            catch (ClassNotFoundException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
        }
        if (clazz == null) {
            try {
                clazz = Class.forName(className, true, Thread.currentThread().getContextClassLoader());
            }
            catch (ClassNotFoundException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
        }
        if (clazz == null) {
            throw new EngineExecutionException("Parameter class not found [" + className + "]", FrameworkErrorCode.ObjectNotExists);
        }
        return clazz;
    }

    protected Object invokeMethod(Object serviceBean, Method method, Object ... input) throws Throwable {
        try {
            return method.invoke(serviceBean, input);
        }
        catch (InvocationTargetException e) {
            Throwable targetExp = e.getTargetException();
            if (targetExp == null) {
                throw new EngineExecutionException(e, e.getMessage(), FrameworkErrorCode.MethodInvokeError);
            }
            throw targetExp;
        }
    }

    protected Object toJavaObject(Object value, Class paramType) {
        String jsonValue;
        if (value == null) {
            return value;
        }
        if (paramType.isAssignableFrom(value.getClass())) {
            return value;
        }
        if (this.isPrimitive(paramType)) {
            return value;
        }
        JsonParser jsonParser = JsonParserFactory.getJsonParser(this.getSagaJsonParser());
        if (jsonParser == null) {
            throw new RuntimeException("Cannot get JsonParser by name : " + this.getSagaJsonParser());
        }
        boolean useAutoType = jsonParser.useAutoType(jsonValue = jsonParser.toJsonString(value, true, false));
        return jsonParser.parse(jsonValue, paramType, !useAutoType);
    }

    protected boolean isPrimitive(Class<?> clazz) {
        return clazz.isPrimitive() || clazz == Boolean.class || clazz == Character.class || clazz == Byte.class || clazz == Short.class || clazz == Integer.class || clazz == Long.class || clazz == Float.class || clazz == Double.class || clazz == BigInteger.class || clazz == BigDecimal.class || clazz == String.class || clazz == java.util.Date.class || clazz == Date.class || clazz == Time.class || clazz == Timestamp.class || clazz.isEnum();
    }

    protected Class getPrimitiveClass(String className) {
        if (Boolean.TYPE.getName().equals(className)) {
            return Boolean.TYPE;
        }
        if (Character.TYPE.getName().equals(className)) {
            return Character.TYPE;
        }
        if (Byte.TYPE.getName().equals(className)) {
            return Byte.TYPE;
        }
        if (Short.TYPE.getName().equals(className)) {
            return Short.TYPE;
        }
        if (Integer.TYPE.getName().equals(className)) {
            return Integer.TYPE;
        }
        if (Long.TYPE.getName().equals(className)) {
            return Long.TYPE;
        }
        if (Float.TYPE.getName().equals(className)) {
            return Float.TYPE;
        }
        if (Double.TYPE.getName().equals(className)) {
            return Double.TYPE;
        }
        return null;
    }

    public String getSagaJsonParser() {
        return this.sagaJsonParser;
    }

    public void setSagaJsonParser(String sagaJsonParser) {
        this.sagaJsonParser = sagaJsonParser;
    }
}

