/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.saga.statelang.parser;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.seata.saga.statelang.domain.StateType;
import org.apache.seata.saga.statelang.parser.StateParser;
import org.apache.seata.saga.statelang.parser.impl.ChoiceStateParser;
import org.apache.seata.saga.statelang.parser.impl.CompensateSubStateMachineStateParser;
import org.apache.seata.saga.statelang.parser.impl.CompensationTriggerStateParser;
import org.apache.seata.saga.statelang.parser.impl.FailEndStateParser;
import org.apache.seata.saga.statelang.parser.impl.ScriptTaskStateParser;
import org.apache.seata.saga.statelang.parser.impl.ServiceTaskStateParser;
import org.apache.seata.saga.statelang.parser.impl.SubStateMachineParser;
import org.apache.seata.saga.statelang.parser.impl.SucceedEndStateParser;

public class StateParserFactory {
    protected static Map<StateType, StateParser> stateParserMap = new ConcurrentHashMap<StateType, StateParser>();

    public static StateParser getStateParser(StateType stateType) {
        return stateParserMap.get((Object)stateType);
    }

    static {
        stateParserMap.put(StateType.SERVICE_TASK, new ServiceTaskStateParser());
        stateParserMap.put(StateType.CHOICE, new ChoiceStateParser());
        stateParserMap.put(StateType.COMPENSATION_TRIGGER, new CompensationTriggerStateParser());
        stateParserMap.put(StateType.FAIL, new FailEndStateParser());
        stateParserMap.put(StateType.SUCCEED, new SucceedEndStateParser());
        stateParserMap.put(StateType.SUB_STATE_MACHINE, new SubStateMachineParser());
        stateParserMap.put(StateType.SUB_MACHINE_COMPENSATION, new CompensateSubStateMachineStateParser());
        stateParserMap.put(StateType.SCRIPT_TASK, new ScriptTaskStateParser());
    }
}

