/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.serializer.fury;

import org.apache.fury.Fury;
import org.apache.fury.ThreadLocalFury;
import org.apache.fury.ThreadSafeFury;
import org.apache.fury.config.CompatibleMode;
import org.apache.fury.config.Language;
import org.apache.seata.core.serializer.SerializerSecurityRegistry;

public class FurySerializerFactory {
    private static final FurySerializerFactory FACTORY = new FurySerializerFactory();
    private static final ThreadSafeFury FURY = new ThreadLocalFury(classLoader -> {
        Fury f = Fury.builder().withLanguage(Language.JAVA).requireClassRegistration(false).withRefTracking(true).withClassLoader(classLoader).withCompatibleMode(CompatibleMode.COMPATIBLE).build();
        f.getClassResolver().setClassChecker((classResolver, className) -> SerializerSecurityRegistry.getAllowClassPattern().contains(className));
        return f;
    });

    public static FurySerializerFactory getInstance() {
        return FACTORY;
    }

    public ThreadSafeFury get() {
        return FURY;
    }
}

