/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.spring.annotation;

import java.lang.reflect.Method;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.seata.integration.tx.api.annotation.AspectTransactional;
import org.apache.seata.integration.tx.api.interceptor.DefaultInvocationWrapper;
import org.apache.seata.integration.tx.api.interceptor.handler.GlobalTransactionalInterceptorHandler;
import org.apache.seata.tm.api.FailureHandler;
import org.springframework.aop.support.AopUtils;
import org.springframework.util.ClassUtils;

public class AspectTransactionalInterceptor
implements MethodInterceptor {
    private final FailureHandler failureHandler;
    private final AspectTransactional aspectTransactional;
    private final GlobalTransactionalInterceptorHandler globalTransactionalInterceptorHandler;
    private static final AspectTransactional DEFAULT_ASPECT_TRANSACTIONAL = new AspectTransactional();

    public AspectTransactionalInterceptor() {
        this(DEFAULT_ASPECT_TRANSACTIONAL);
    }

    public AspectTransactionalInterceptor(AspectTransactional aspectTransactional) {
        this(null, aspectTransactional);
    }

    public AspectTransactionalInterceptor(FailureHandler failureHandler) {
        this(failureHandler, DEFAULT_ASPECT_TRANSACTIONAL);
    }

    public AspectTransactionalInterceptor(FailureHandler failureHandler, AspectTransactional aspectTransactional) {
        this.failureHandler = failureHandler;
        this.aspectTransactional = aspectTransactional;
        this.globalTransactionalInterceptorHandler = new GlobalTransactionalInterceptorHandler(this.failureHandler, null, this.aspectTransactional);
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        Class targetClass = invocation.getThis() != null ? AopUtils.getTargetClass((Object)invocation.getThis()) : null;
        Method specificMethod = ClassUtils.getMostSpecificMethod((Method)invocation.getMethod(), (Class)targetClass);
        DefaultInvocationWrapper invocationWrapper = new DefaultInvocationWrapper(null, invocation.getThis(), specificMethod, invocation.getArguments());
        return this.globalTransactionalInterceptorHandler.invoke(invocationWrapper);
    }
}

