/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.encrypt.distsql.handler.update;

import java.util.Collection;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.shardingsphere.encrypt.api.config.EncryptRuleConfiguration;
import org.apache.shardingsphere.encrypt.api.config.rule.EncryptTableRuleConfiguration;
import org.apache.shardingsphere.encrypt.distsql.parser.statement.DropEncryptRuleStatement;
import org.apache.shardingsphere.infra.config.RuleConfiguration;
import org.apache.shardingsphere.infra.config.algorithm.ShardingSphereAlgorithmConfiguration;
import org.apache.shardingsphere.infra.distsql.exception.DistSQLException;
import org.apache.shardingsphere.infra.distsql.exception.rule.RequiredRuleMissedException;
import org.apache.shardingsphere.infra.distsql.update.RuleDefinitionDropUpdater;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;

public final class DropEncryptRuleStatementUpdater
implements RuleDefinitionDropUpdater<DropEncryptRuleStatement, EncryptRuleConfiguration> {
    public void checkSQLStatement(ShardingSphereMetaData shardingSphereMetaData, DropEncryptRuleStatement sqlStatement, EncryptRuleConfiguration currentRuleConfig) throws DistSQLException {
        String schemaName = shardingSphereMetaData.getName();
        this.checkToBeDroppedEncryptTableNames(schemaName, sqlStatement, currentRuleConfig);
    }

    private void checkToBeDroppedEncryptTableNames(String schemaName, DropEncryptRuleStatement sqlStatement, EncryptRuleConfiguration currentRuleConfig) throws DistSQLException {
        if (sqlStatement.isContainsExistClause()) {
            return;
        }
        DistSQLException.predictionThrow((boolean)this.isExistRuleConfig((RuleConfiguration)currentRuleConfig), () -> new RequiredRuleMissedException("Encrypt", schemaName));
        Collection currentEncryptTableNames = currentRuleConfig.getTables().stream().map(EncryptTableRuleConfiguration::getName).collect(Collectors.toList());
        Collection notExistedTableNames = sqlStatement.getTables().stream().filter(each -> !currentEncryptTableNames.contains(each)).collect(Collectors.toList());
        DistSQLException.predictionThrow((boolean)notExistedTableNames.isEmpty(), () -> new RequiredRuleMissedException("Encrypt", schemaName, notExistedTableNames));
    }

    public boolean hasAnyOneToBeDropped(DropEncryptRuleStatement sqlStatement, EncryptRuleConfiguration currentRuleConfig) {
        return null != currentRuleConfig && !this.getIdenticalData(currentRuleConfig.getTables().stream().map(EncryptTableRuleConfiguration::getName).collect(Collectors.toSet()), sqlStatement.getTables()).isEmpty();
    }

    public boolean updateCurrentRuleConfiguration(DropEncryptRuleStatement sqlStatement, EncryptRuleConfiguration currentRuleConfig) {
        for (String each : sqlStatement.getTables()) {
            this.dropRule(currentRuleConfig, each);
        }
        return currentRuleConfig.getTables().isEmpty();
    }

    private void dropRule(EncryptRuleConfiguration currentRuleConfig, String ruleName) {
        Optional<EncryptTableRuleConfiguration> encryptTableRuleConfig = currentRuleConfig.getTables().stream().filter(tableRule -> tableRule.getName().equals(ruleName)).findAny();
        encryptTableRuleConfig.ifPresent(op -> {
            currentRuleConfig.getTables().remove(encryptTableRuleConfig.get());
            ((EncryptTableRuleConfiguration)encryptTableRuleConfig.get()).getColumns().stream().filter(column -> !this.isEncryptorInUse(currentRuleConfig, column.getEncryptorName())).forEach(column -> {
                ShardingSphereAlgorithmConfiguration cfr_ignored_0 = (ShardingSphereAlgorithmConfiguration)currentRuleConfig.getEncryptors().remove(column.getEncryptorName());
            });
        });
    }

    private boolean isEncryptorInUse(EncryptRuleConfiguration currentRuleConfig, String toBeDroppedEncryptorName) {
        for (EncryptTableRuleConfiguration each : currentRuleConfig.getTables()) {
            if (!each.getColumns().stream().anyMatch(column -> column.getEncryptorName().equals(toBeDroppedEncryptorName))) continue;
            return true;
        }
        return false;
    }

    public Class<EncryptRuleConfiguration> getRuleConfigurationClass() {
        return EncryptRuleConfiguration.class;
    }

    public String getType() {
        return DropEncryptRuleStatement.class.getName();
    }
}

