/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.binder.statement.dml;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.infra.binder.segment.select.groupby.GroupByContext;
import org.apache.shardingsphere.infra.binder.segment.select.groupby.engine.GroupByContextEngine;
import org.apache.shardingsphere.infra.binder.segment.select.orderby.OrderByContext;
import org.apache.shardingsphere.infra.binder.segment.select.orderby.OrderByItem;
import org.apache.shardingsphere.infra.binder.segment.select.orderby.engine.OrderByContextEngine;
import org.apache.shardingsphere.infra.binder.segment.select.pagination.PaginationContext;
import org.apache.shardingsphere.infra.binder.segment.select.pagination.engine.PaginationContextEngine;
import org.apache.shardingsphere.infra.binder.segment.select.projection.Projection;
import org.apache.shardingsphere.infra.binder.segment.select.projection.ProjectionsContext;
import org.apache.shardingsphere.infra.binder.segment.select.projection.engine.ProjectionsContextEngine;
import org.apache.shardingsphere.infra.binder.segment.select.projection.impl.AggregationDistinctProjection;
import org.apache.shardingsphere.infra.binder.segment.select.projection.impl.AggregationProjection;
import org.apache.shardingsphere.infra.binder.segment.select.projection.impl.ColumnProjection;
import org.apache.shardingsphere.infra.binder.segment.table.TablesContext;
import org.apache.shardingsphere.infra.binder.statement.CommonSQLStatementContext;
import org.apache.shardingsphere.infra.binder.type.SchemaAvailable;
import org.apache.shardingsphere.infra.binder.type.TableAvailable;
import org.apache.shardingsphere.infra.binder.type.WhereAvailable;
import org.apache.shardingsphere.infra.exception.SchemaNotExistedException;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.infra.metadata.schema.ShardingSphereSchema;
import org.apache.shardingsphere.sql.parser.sql.common.extractor.TableExtractor;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.subquery.SubquerySegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.order.item.ColumnOrderByItemSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.order.item.ExpressionOrderByItemSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.order.item.IndexOrderByItemSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.order.item.OrderByItemSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.order.item.TextOrderByItemSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.predicate.WhereSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.JoinTableSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dml.SelectStatement;
import org.apache.shardingsphere.sql.parser.sql.common.util.SQLUtil;
import org.apache.shardingsphere.sql.parser.sql.common.util.SubqueryExtractUtil;

public final class SelectStatementContext
extends CommonSQLStatementContext<SelectStatement>
implements TableAvailable,
WhereAvailable,
SchemaAvailable {
    private final TablesContext tablesContext = new TablesContext(this.getAllSimpleTableSegments());
    private final ProjectionsContext projectionsContext;
    private final GroupByContext groupByContext;
    private final OrderByContext orderByContext;
    private final PaginationContext paginationContext;
    private final Collection<SubquerySegment> subquerySegments;
    private final String schemaName;

    public SelectStatementContext(Map<String, ShardingSphereMetaData> metaDataMap, List<Object> parameters, SelectStatement sqlStatement, String defaultSchemaName) {
        super(sqlStatement);
        ShardingSphereSchema schema = this.getSchema(metaDataMap, defaultSchemaName);
        this.groupByContext = new GroupByContextEngine().createGroupByContext(sqlStatement);
        this.orderByContext = new OrderByContextEngine().createOrderBy(schema, sqlStatement, this.groupByContext);
        this.projectionsContext = new ProjectionsContextEngine(schema, this.getDatabaseType()).createProjectionsContext(((SelectStatement)this.getSqlStatement()).getFrom(), ((SelectStatement)this.getSqlStatement()).getProjections(), this.groupByContext, this.orderByContext);
        this.paginationContext = new PaginationContextEngine().createPaginationContext(sqlStatement, this.projectionsContext, parameters);
        this.subquerySegments = SubqueryExtractUtil.getSubquerySegments((SelectStatement)((SelectStatement)this.getSqlStatement()));
        this.schemaName = defaultSchemaName;
    }

    private ShardingSphereSchema getSchema(Map<String, ShardingSphereMetaData> metaDataMap, String defaultSchemaName) {
        String schemaName = this.tablesContext.getSchemaName().orElse(defaultSchemaName);
        ShardingSphereMetaData metaData = metaDataMap.get(schemaName);
        if (null == metaData) {
            throw new SchemaNotExistedException(schemaName);
        }
        return metaData.getSchema();
    }

    public boolean isContainsJoinQuery() {
        return ((SelectStatement)this.getSqlStatement()).getFrom() instanceof JoinTableSegment;
    }

    public boolean isContainsSubquery() {
        return !this.subquerySegments.isEmpty();
    }

    public boolean isContainsHaving() {
        return ((SelectStatement)this.getSqlStatement()).getHaving().isPresent();
    }

    public boolean isContainsPartialDistinctAggregation() {
        Collection aggregationProjections = this.projectionsContext.getProjections().stream().filter(each -> each instanceof AggregationProjection).collect(Collectors.toList());
        List<AggregationDistinctProjection> aggregationDistinctProjections = this.projectionsContext.getAggregationDistinctProjections();
        return aggregationProjections.size() > 1 && aggregationDistinctProjections.size() > 0 && aggregationProjections.size() != aggregationDistinctProjections.size();
    }

    public void setIndexes(Map<String, Integer> columnLabelIndexMap) {
        this.setIndexForAggregationProjection(columnLabelIndexMap);
        this.setIndexForOrderItem(columnLabelIndexMap, this.orderByContext.getItems());
        this.setIndexForOrderItem(columnLabelIndexMap, this.groupByContext.getItems());
    }

    private void setIndexForAggregationProjection(Map<String, Integer> columnLabelIndexMap) {
        for (AggregationProjection each : this.projectionsContext.getAggregationProjections()) {
            String columnLabel = SQLUtil.getExactlyValue((String)each.getColumnLabel());
            Preconditions.checkState((boolean)columnLabelIndexMap.containsKey(columnLabel), (String)"Can't find index: %s, please add alias for aggregate selections", (Object)each);
            each.setIndex(columnLabelIndexMap.get(columnLabel));
            for (AggregationProjection derived : each.getDerivedAggregationProjections()) {
                String derivedColumnLabel = SQLUtil.getExactlyValue((String)derived.getColumnLabel());
                Preconditions.checkState((boolean)columnLabelIndexMap.containsKey(derivedColumnLabel), (String)"Can't find index: %s", (Object)derived);
                derived.setIndex(columnLabelIndexMap.get(derivedColumnLabel));
            }
        }
    }

    private void setIndexForOrderItem(Map<String, Integer> columnLabelIndexMap, Collection<OrderByItem> orderByItems) {
        for (OrderByItem each : orderByItems) {
            Optional<Integer> itemIndex;
            if (each.getSegment() instanceof IndexOrderByItemSegment) {
                each.setIndex(((IndexOrderByItemSegment)each.getSegment()).getColumnIndex());
                continue;
            }
            if (each.getSegment() instanceof ColumnOrderByItemSegment && ((ColumnOrderByItemSegment)each.getSegment()).getColumn().getOwner().isPresent() && (itemIndex = this.projectionsContext.findProjectionIndex(((ColumnOrderByItemSegment)each.getSegment()).getText())).isPresent()) {
                each.setIndex(itemIndex.get());
                continue;
            }
            String columnLabel = this.getAlias(each.getSegment()).orElseGet(() -> this.getOrderItemText((TextOrderByItemSegment)each.getSegment()));
            Preconditions.checkState((boolean)columnLabelIndexMap.containsKey(columnLabel), (String)"Can't find index: %s", (Object)each);
            if (!columnLabelIndexMap.containsKey(columnLabel)) continue;
            each.setIndex(columnLabelIndexMap.get(columnLabel));
        }
    }

    private Optional<String> getAlias(OrderByItemSegment orderByItem) {
        if (this.projectionsContext.isUnqualifiedShorthandProjection()) {
            return Optional.empty();
        }
        String rawName = SQLUtil.getExactlyValue((String)((TextOrderByItemSegment)orderByItem).getText());
        for (Projection each : this.projectionsContext.getProjections()) {
            if (SQLUtil.getExactlyExpression((String)rawName).equalsIgnoreCase(SQLUtil.getExactlyExpression((String)SQLUtil.getExactlyValue((String)each.getExpression())))) {
                return each.getAlias();
            }
            if (rawName.equalsIgnoreCase(each.getAlias().orElse(null))) {
                return Optional.of(rawName);
            }
            if (!this.isSameColumnName(each, rawName)) continue;
            return each.getAlias();
        }
        return Optional.empty();
    }

    private boolean isSameColumnName(Projection projection, String name) {
        return projection instanceof ColumnProjection && name.equalsIgnoreCase(((ColumnProjection)projection).getName());
    }

    private String getOrderItemText(TextOrderByItemSegment orderByItemSegment) {
        return orderByItemSegment instanceof ColumnOrderByItemSegment ? ((ColumnOrderByItemSegment)orderByItemSegment).getColumn().getIdentifier().getValue() : ((ExpressionOrderByItemSegment)orderByItemSegment).getExpression();
    }

    public boolean isSameGroupByAndOrderByItems() {
        return !this.groupByContext.getItems().isEmpty() && this.groupByContext.getItems().equals(this.orderByContext.getItems());
    }

    @Override
    public Collection<SimpleTableSegment> getAllTables() {
        return this.tablesContext.getOriginalTables();
    }

    @Override
    public Optional<WhereSegment> getWhere() {
        return ((SelectStatement)this.getSqlStatement()).getWhere();
    }

    private Collection<SimpleTableSegment> getAllSimpleTableSegments() {
        TableExtractor tableExtractor = new TableExtractor();
        tableExtractor.extractTablesFromSelect((SelectStatement)this.getSqlStatement());
        return tableExtractor.getRewriteTables();
    }

    @Override
    @Generated
    public TablesContext getTablesContext() {
        return this.tablesContext;
    }

    @Generated
    public ProjectionsContext getProjectionsContext() {
        return this.projectionsContext;
    }

    @Generated
    public GroupByContext getGroupByContext() {
        return this.groupByContext;
    }

    @Generated
    public OrderByContext getOrderByContext() {
        return this.orderByContext;
    }

    @Generated
    public PaginationContext getPaginationContext() {
        return this.paginationContext;
    }

    @Generated
    public Collection<SubquerySegment> getSubquerySegments() {
        return this.subquerySegments;
    }

    @Override
    @Generated
    public String getSchemaName() {
        return this.schemaName;
    }
}

