/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.distsql.exception.rule;

import java.util.Collection;
import org.apache.shardingsphere.infra.distsql.exception.rule.RuleDefinitionViolationException;

public final class RequiredAlgorithmMissedException
extends RuleDefinitionViolationException {
    private static final long serialVersionUID = -1952698375135777585L;

    public RequiredAlgorithmMissedException() {
        super(1115, "No sharding algorithm definition in current statement");
    }

    public RequiredAlgorithmMissedException(String schemaName) {
        super(1115, String.format("Sharding algorithm does not exist in schema `%s`.", schemaName));
    }

    public RequiredAlgorithmMissedException(String schemaName, Collection<String> algorithmNames) {
        super(1115, String.format("Sharding algorithms `%s` do not exist in schema `%s`.", algorithmNames, schemaName));
    }

    public RequiredAlgorithmMissedException(String type, String schemaName, Collection<String> algorithmNames) {
        super(1115, String.format("%s algorithms `%s` do not exist in schema `%s`.", type, algorithmNames, schemaName));
    }
}

