/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.yaml.config.swapper;

import java.lang.reflect.ParameterizedType;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.shardingsphere.infra.config.RuleConfiguration;
import org.apache.shardingsphere.infra.yaml.config.pojo.YamlRuleConfiguration;
import org.apache.shardingsphere.infra.yaml.config.swapper.YamlRuleConfigurationSwapper;
import org.apache.shardingsphere.spi.ShardingSphereServiceLoader;
import org.apache.shardingsphere.spi.ordered.OrderedSPIRegistry;

public final class YamlRuleConfigurationSwapperEngine {
    public Collection<YamlRuleConfiguration> swapToYamlRuleConfigurations(Collection<RuleConfiguration> ruleConfigs) {
        return OrderedSPIRegistry.getRegisteredServices(YamlRuleConfigurationSwapper.class, ruleConfigs).entrySet().stream().map(entry -> (YamlRuleConfiguration)((YamlRuleConfigurationSwapper)entry.getValue()).swapToYamlConfiguration(entry.getKey())).collect(Collectors.toList());
    }

    public Collection<RuleConfiguration> swapToRuleConfigurations(Collection<YamlRuleConfiguration> yamlRuleConfigs) {
        LinkedList<RuleConfiguration> result = new LinkedList<RuleConfiguration>();
        Collection ruleConfigTypes = yamlRuleConfigs.stream().map(YamlRuleConfiguration::getRuleConfigurationType).collect(Collectors.toList());
        for (Map.Entry entry : OrderedSPIRegistry.getRegisteredServicesByClass(YamlRuleConfigurationSwapper.class, (Collection)ruleConfigTypes).entrySet()) {
            result.addAll(this.swapToRuleConfigurations(yamlRuleConfigs, (Class)entry.getKey(), (YamlRuleConfigurationSwapper)entry.getValue()));
        }
        return result;
    }

    private Collection<RuleConfiguration> swapToRuleConfigurations(Collection<YamlRuleConfiguration> yamlRuleConfigs, Class<?> ruleConfigType, YamlRuleConfigurationSwapper swapper) {
        return yamlRuleConfigs.stream().filter(each -> each.getRuleConfigurationType().equals(ruleConfigType)).map(each -> (RuleConfiguration)swapper.swapToObject(each)).collect(Collectors.toList());
    }

    public static Map<String, Class<?>> getYamlShortcuts() {
        Collection swappers = ShardingSphereServiceLoader.getSingletonServiceInstances(YamlRuleConfigurationSwapper.class);
        HashMap result = new HashMap(swappers.size(), 1.0f);
        for (YamlRuleConfigurationSwapper each : swappers) {
            Class<?> yamlRuleConfigurationClass = Class.forName(((ParameterizedType)each.getClass().getGenericInterfaces()[0]).getActualTypeArguments()[0].getTypeName());
            result.put(String.format("!%s", each.getRuleTagName()), yamlRuleConfigurationClass);
        }
        return result;
    }

    public RuleConfiguration swapToRuleConfiguration(YamlRuleConfiguration yamlRuleConfig) {
        List<Class<? extends RuleConfiguration>> types = Collections.singletonList(yamlRuleConfig.getRuleConfigurationType());
        Map typeSwapperMap = OrderedSPIRegistry.getRegisteredServicesByClass(YamlRuleConfigurationSwapper.class, types);
        YamlRuleConfigurationSwapper swapper = (YamlRuleConfigurationSwapper)typeSwapperMap.get(yamlRuleConfig.getRuleConfigurationType());
        return (RuleConfiguration)swapper.swapToObject(yamlRuleConfig);
    }

    static {
        ShardingSphereServiceLoader.register(YamlRuleConfigurationSwapper.class);
    }
}

