/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.yaml.schema.swapper;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.shardingsphere.infra.metadata.schema.model.ColumnMetaData;
import org.apache.shardingsphere.infra.metadata.schema.model.ConstraintMetaData;
import org.apache.shardingsphere.infra.metadata.schema.model.IndexMetaData;
import org.apache.shardingsphere.infra.metadata.schema.model.TableMetaData;
import org.apache.shardingsphere.infra.yaml.config.swapper.YamlConfigurationSwapper;
import org.apache.shardingsphere.infra.yaml.schema.pojo.YamlColumnMetaData;
import org.apache.shardingsphere.infra.yaml.schema.pojo.YamlConstraintMetaData;
import org.apache.shardingsphere.infra.yaml.schema.pojo.YamlIndexMetaData;
import org.apache.shardingsphere.infra.yaml.schema.pojo.YamlTableMetaData;

public final class TableMetaDataYamlSwapper
implements YamlConfigurationSwapper<YamlTableMetaData, TableMetaData> {
    @Override
    public YamlTableMetaData swapToYamlConfiguration(TableMetaData table) {
        YamlTableMetaData result = new YamlTableMetaData();
        result.setColumns(this.swapYamlColumns(table.getColumns()));
        result.setIndexes(this.swapYamlIndexes(table.getIndexes()));
        result.setConstraints(this.swapYamlConstraints(table.getConstrains()));
        result.setName(table.getName());
        return result;
    }

    @Override
    public TableMetaData swapToObject(YamlTableMetaData yamlConfig) {
        return new TableMetaData(yamlConfig.getName(), this.swapColumns(yamlConfig.getColumns()), this.swapIndexes(yamlConfig.getIndexes()), this.swapConstraints(yamlConfig.getConstraints()));
    }

    private Collection<ConstraintMetaData> swapConstraints(Map<String, YamlConstraintMetaData> constraints) {
        return null == constraints ? Collections.emptyList() : (Collection)constraints.values().stream().map(this::swapConstraint).collect(Collectors.toList());
    }

    private ConstraintMetaData swapConstraint(YamlConstraintMetaData constraint) {
        return new ConstraintMetaData(constraint.getName(), constraint.getReferencedTableName());
    }

    private Collection<IndexMetaData> swapIndexes(Map<String, YamlIndexMetaData> indexes) {
        return null == indexes ? Collections.emptyList() : (Collection)indexes.values().stream().map(this::swapIndex).collect(Collectors.toList());
    }

    private IndexMetaData swapIndex(YamlIndexMetaData index) {
        return new IndexMetaData(index.getName());
    }

    private Collection<ColumnMetaData> swapColumns(Map<String, YamlColumnMetaData> indexes) {
        return null == indexes ? Collections.emptyList() : (Collection)indexes.values().stream().map(this::swapColumn).collect(Collectors.toList());
    }

    private ColumnMetaData swapColumn(YamlColumnMetaData column) {
        return new ColumnMetaData(column.getName(), column.getDataType(), column.isPrimaryKey(), column.isGenerated(), column.isCaseSensitive());
    }

    private Map<String, YamlConstraintMetaData> swapYamlConstraints(Map<String, ConstraintMetaData> constrains) {
        return constrains.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> this.swapYamlConstraint((ConstraintMetaData)entry.getValue()), (oldValue, currentValue) -> oldValue, LinkedHashMap::new));
    }

    private YamlConstraintMetaData swapYamlConstraint(ConstraintMetaData constraint) {
        YamlConstraintMetaData result = new YamlConstraintMetaData();
        result.setName(constraint.getName());
        result.setReferencedTableName(constraint.getReferencedTableName());
        return result;
    }

    private Map<String, YamlIndexMetaData> swapYamlIndexes(Map<String, IndexMetaData> indexes) {
        return indexes.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> this.swapYamlIndex((IndexMetaData)entry.getValue()), (oldValue, currentValue) -> oldValue, LinkedHashMap::new));
    }

    private YamlIndexMetaData swapYamlIndex(IndexMetaData index) {
        YamlIndexMetaData result = new YamlIndexMetaData();
        result.setName(index.getName());
        return result;
    }

    private Map<String, YamlColumnMetaData> swapYamlColumns(Map<String, ColumnMetaData> columns) {
        return columns.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> this.swapYamlColumn((ColumnMetaData)entry.getValue()), (oldValue, currentValue) -> oldValue, LinkedHashMap::new));
    }

    private YamlColumnMetaData swapYamlColumn(ColumnMetaData column) {
        YamlColumnMetaData result = new YamlColumnMetaData();
        result.setName(column.getName());
        result.setCaseSensitive(column.isCaseSensitive());
        result.setGenerated(column.isGenerated());
        result.setPrimaryKey(column.isPrimaryKey());
        result.setDataType(column.getDataType());
        return result;
    }
}

