/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.underlying.rewrite.context;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.apache.shardingsphere.sql.parser.relation.metadata.RelationMetas;
import org.apache.shardingsphere.sql.parser.relation.statement.SQLStatementContext;
import org.apache.shardingsphere.sql.parser.relation.statement.impl.InsertSQLStatementContext;
import org.apache.shardingsphere.underlying.rewrite.parameter.builder.ParameterBuilder;
import org.apache.shardingsphere.underlying.rewrite.parameter.builder.impl.GroupedParameterBuilder;
import org.apache.shardingsphere.underlying.rewrite.parameter.builder.impl.StandardParameterBuilder;
import org.apache.shardingsphere.underlying.rewrite.sql.token.generator.SQLTokenGenerator;
import org.apache.shardingsphere.underlying.rewrite.sql.token.generator.SQLTokenGenerators;
import org.apache.shardingsphere.underlying.rewrite.sql.token.generator.builder.DefaultTokenGeneratorBuilder;
import org.apache.shardingsphere.underlying.rewrite.sql.token.pojo.SQLToken;

public final class SQLRewriteContext {
    private final RelationMetas relationMetas;
    private final SQLStatementContext sqlStatementContext;
    private final String sql;
    private final List<Object> parameters;
    private final List<SQLToken> sqlTokens = new LinkedList<SQLToken>();
    private final ParameterBuilder parameterBuilder;
    private final SQLTokenGenerators sqlTokenGenerators = new SQLTokenGenerators();

    public SQLRewriteContext(RelationMetas relationMetas, SQLStatementContext sqlStatementContext, String sql, List<Object> parameters) {
        this.relationMetas = relationMetas;
        this.sqlStatementContext = sqlStatementContext;
        this.sql = sql;
        this.parameters = parameters;
        this.addSQLTokenGenerators(new DefaultTokenGeneratorBuilder().getSQLTokenGenerators());
        this.parameterBuilder = sqlStatementContext instanceof InsertSQLStatementContext ? new GroupedParameterBuilder(((InsertSQLStatementContext)sqlStatementContext).getGroupedParameters()) : new StandardParameterBuilder(parameters);
    }

    public void addSQLTokenGenerators(Collection<SQLTokenGenerator> sqlTokenGenerators) {
        this.sqlTokenGenerators.addAll(sqlTokenGenerators);
    }

    public void generateSQLTokens() {
        this.sqlTokens.addAll(this.sqlTokenGenerators.generateSQLTokens(this.sqlStatementContext, this.parameters, this.relationMetas));
    }

    public RelationMetas getRelationMetas() {
        return this.relationMetas;
    }

    public SQLStatementContext getSqlStatementContext() {
        return this.sqlStatementContext;
    }

    public String getSql() {
        return this.sql;
    }

    public List<Object> getParameters() {
        return this.parameters;
    }

    public List<SQLToken> getSqlTokens() {
        return this.sqlTokens;
    }

    public ParameterBuilder getParameterBuilder() {
        return this.parameterBuilder;
    }
}

