/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shadow.distsql.handler.update;

import java.util.Collections;
import org.apache.shardingsphere.infra.config.RuleConfiguration;
import org.apache.shardingsphere.infra.config.scope.SchemaRuleConfiguration;
import org.apache.shardingsphere.infra.distsql.exception.DistSQLException;
import org.apache.shardingsphere.infra.distsql.exception.rule.RequiredAlgorithmMissedException;
import org.apache.shardingsphere.infra.distsql.update.RuleDefinitionDropUpdater;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.shadow.api.config.ShadowRuleConfiguration;
import org.apache.shardingsphere.shadow.distsql.handler.checker.ShadowRuleStatementChecker;
import org.apache.shardingsphere.shadow.distsql.parser.statement.DropDefaultShadowAlgorithmStatement;

public final class DropDefaultShadowAlgorithmStatementUpdater
implements RuleDefinitionDropUpdater<DropDefaultShadowAlgorithmStatement, ShadowRuleConfiguration> {
    private static final String SHADOW = "shadow";

    public void checkSQLStatement(ShardingSphereMetaData metaData, DropDefaultShadowAlgorithmStatement sqlStatement, ShadowRuleConfiguration currentRuleConfig) throws DistSQLException {
        String schemaName = metaData.getName();
        if (sqlStatement.isContainsExistClause() && !this.isExistRuleConfig((RuleConfiguration)currentRuleConfig)) {
            return;
        }
        this.checkConfigurationExist(schemaName, (SchemaRuleConfiguration)currentRuleConfig);
        this.checkAlgorithm(schemaName, sqlStatement, currentRuleConfig);
    }

    private void checkConfigurationExist(String schemaName, SchemaRuleConfiguration currentRuleConfig) throws DistSQLException {
        ShadowRuleStatementChecker.checkConfigurationExist(schemaName, currentRuleConfig);
    }

    private void checkAlgorithm(String schemaName, DropDefaultShadowAlgorithmStatement sqlStatement, ShadowRuleConfiguration currentRuleConfig) throws DistSQLException {
        if (!sqlStatement.isContainsExistClause()) {
            DistSQLException.predictionThrow((null != currentRuleConfig.getDefaultShadowAlgorithmName() ? 1 : 0) != 0, () -> new RequiredAlgorithmMissedException(SHADOW, schemaName, Collections.singleton("default")));
        }
    }

    public boolean hasAnyOneToBeDropped(DropDefaultShadowAlgorithmStatement sqlStatement, ShadowRuleConfiguration currentRuleConfig) {
        return null != currentRuleConfig && null != currentRuleConfig.getDefaultShadowAlgorithmName();
    }

    public boolean updateCurrentRuleConfiguration(DropDefaultShadowAlgorithmStatement sqlStatement, ShadowRuleConfiguration currentRuleConfig) {
        currentRuleConfig.setDefaultShadowAlgorithmName(null);
        return false;
    }

    public Class<ShadowRuleConfiguration> getRuleConfigurationClass() {
        return ShadowRuleConfiguration.class;
    }

    public String getType() {
        return DropDefaultShadowAlgorithmStatement.class.getName();
    }
}

