/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sql.parser.core.extractor.impl.dml;

import com.google.common.base.Optional;
import java.util.Collection;
import java.util.Map;
import org.antlr.v4.runtime.ParserRuleContext;
import org.apache.shardingsphere.sql.parser.core.extractor.api.OptionalSQLSegmentExtractor;
import org.apache.shardingsphere.sql.parser.core.extractor.impl.dml.PredicateExtractor;
import org.apache.shardingsphere.sql.parser.core.extractor.util.ExtractorUtils;
import org.apache.shardingsphere.sql.parser.core.extractor.util.RuleName;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.predicate.OrPredicateSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.predicate.WhereSegment;

public final class WhereExtractor
implements OptionalSQLSegmentExtractor {
    private final PredicateExtractor predicateExtractor = new PredicateExtractor();

    public Optional<WhereSegment> extract(ParserRuleContext ancestorNode, Map<ParserRuleContext, Integer> parameterMarkerIndexes) {
        Collection<ParserRuleContext> parameterMarkerNodes;
        Optional<ParserRuleContext> whereNode = ExtractorUtils.findFirstChildNode(ancestorNode, RuleName.WHERE_CLAUSE);
        if (!whereNode.isPresent()) {
            return Optional.absent();
        }
        WhereSegment result = new WhereSegment(((ParserRuleContext)whereNode.get()).getStart().getStartIndex(), ((ParserRuleContext)whereNode.get()).getStop().getStopIndex(), parameterMarkerIndexes.size());
        Optional<OrPredicateSegment> orPredicateSegment = this.predicateExtractor.extract((ParserRuleContext)whereNode.get(), parameterMarkerIndexes);
        if (orPredicateSegment.isPresent()) {
            result.getAndPredicates().addAll(((OrPredicateSegment)orPredicateSegment.get()).getAndPredicates());
        }
        if (!(parameterMarkerNodes = ExtractorUtils.getAllDescendantNodes((ParserRuleContext)whereNode.get(), RuleName.PARAMETER_MARKER)).isEmpty()) {
            result.setParameterStartIndex(parameterMarkerIndexes.get(parameterMarkerNodes.iterator().next()));
        }
        return Optional.of((Object)result);
    }
}

