/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sql.parser.core.extractor.impl.dml.select;

import com.google.common.base.Optional;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import org.antlr.v4.runtime.ParserRuleContext;
import org.apache.shardingsphere.sql.parser.core.extractor.api.CollectionSQLSegmentExtractor;
import org.apache.shardingsphere.sql.parser.core.extractor.impl.dml.PredicateExtractor;
import org.apache.shardingsphere.sql.parser.core.extractor.util.ExtractorUtils;
import org.apache.shardingsphere.sql.parser.core.extractor.util.RuleName;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.predicate.OrPredicateSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.predicate.SubqueryPredicateSegment;

public final class SubqueryPredicateExtractor
implements CollectionSQLSegmentExtractor {
    private final PredicateExtractor predicateExtractor = new PredicateExtractor();

    public Collection<SubqueryPredicateSegment> extract(ParserRuleContext ancestorNode, Map<ParserRuleContext, Integer> parameterMarkerIndexes) {
        Collection<ParserRuleContext> subqueryNodes = ExtractorUtils.getAllDescendantNodes(ancestorNode, RuleName.SUBQUERY);
        LinkedList<SubqueryPredicateSegment> result = new LinkedList<SubqueryPredicateSegment>();
        for (ParserRuleContext each : subqueryNodes) {
            Optional<OrPredicateSegment> orPredicateSegment = this.predicateExtractor.extract(each, parameterMarkerIndexes);
            if (!orPredicateSegment.isPresent()) continue;
            result.add(new SubqueryPredicateSegment(((OrPredicateSegment)orPredicateSegment.get()).getAndPredicates()));
        }
        return result;
    }
}

