/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sql.parser.core.rule.registry;

import com.google.common.base.Optional;
import java.util.HashMap;
import java.util.Map;
import org.apache.shardingsphere.spi.NewInstanceServiceLoader;
import org.apache.shardingsphere.sql.parser.core.filler.SQLSegmentFiller;
import org.apache.shardingsphere.sql.parser.core.rule.jaxb.entity.extractor.ExtractorRuleDefinitionEntity;
import org.apache.shardingsphere.sql.parser.core.rule.jaxb.entity.filler.FillerRuleDefinitionEntity;
import org.apache.shardingsphere.sql.parser.core.rule.jaxb.loader.RuleDefinitionFileConstant;
import org.apache.shardingsphere.sql.parser.core.rule.jaxb.loader.extractor.ExtractorRuleDefinitionEntityLoader;
import org.apache.shardingsphere.sql.parser.core.rule.jaxb.loader.filler.FillerRuleDefinitionEntityLoader;
import org.apache.shardingsphere.sql.parser.core.rule.jaxb.loader.statement.SQLStatementRuleDefinitionEntityLoader;
import org.apache.shardingsphere.sql.parser.core.rule.registry.extractor.ExtractorRuleDefinition;
import org.apache.shardingsphere.sql.parser.core.rule.registry.filler.FillerRuleDefinition;
import org.apache.shardingsphere.sql.parser.core.rule.registry.statement.SQLStatementRule;
import org.apache.shardingsphere.sql.parser.core.rule.registry.statement.SQLStatementRuleDefinition;
import org.apache.shardingsphere.sql.parser.spi.SQLParserEntry;
import org.apache.shardingsphere.sql.parser.sql.segment.SQLSegment;

public final class ParseRuleRegistry {
    private static volatile ParseRuleRegistry instance;
    private final ExtractorRuleDefinitionEntityLoader extractorRuleLoader = new ExtractorRuleDefinitionEntityLoader();
    private final FillerRuleDefinitionEntityLoader fillerRuleLoader = new FillerRuleDefinitionEntityLoader();
    private final SQLStatementRuleDefinitionEntityLoader statementRuleLoader = new SQLStatementRuleDefinitionEntityLoader();
    private final Map<String, FillerRuleDefinition> fillerRuleDefinitions = new HashMap<String, FillerRuleDefinition>();
    private final Map<String, SQLStatementRuleDefinition> sqlStatementRuleDefinitions = new HashMap<String, SQLStatementRuleDefinition>();

    private ParseRuleRegistry() {
        this.initParseRuleDefinition();
    }

    private void initParseRuleDefinition() {
        ExtractorRuleDefinitionEntity generalExtractorRuleEntity = this.extractorRuleLoader.load(RuleDefinitionFileConstant.getExtractorRuleDefinitionFile());
        FillerRuleDefinitionEntity generalFillerRuleEntity = this.fillerRuleLoader.load(RuleDefinitionFileConstant.getFillerRuleDefinitionFile());
        for (SQLParserEntry each : NewInstanceServiceLoader.newServiceInstances(SQLParserEntry.class)) {
            String databaseTypeName = each.getDatabaseTypeName();
            this.fillerRuleDefinitions.put(databaseTypeName, this.createFillerRuleDefinition(generalFillerRuleEntity, databaseTypeName));
            this.sqlStatementRuleDefinitions.put(databaseTypeName, this.createSQLStatementRuleDefinition(generalExtractorRuleEntity, databaseTypeName));
        }
    }

    private FillerRuleDefinition createFillerRuleDefinition(FillerRuleDefinitionEntity generalFillerRuleEntity, String databaseTypeName) {
        FillerRuleDefinitionEntity databaseDialectFillerRuleEntity = this.fillerRuleLoader.load(RuleDefinitionFileConstant.getFillerRuleDefinitionFile(databaseTypeName));
        return new FillerRuleDefinition(generalFillerRuleEntity, databaseDialectFillerRuleEntity);
    }

    private SQLStatementRuleDefinition createSQLStatementRuleDefinition(ExtractorRuleDefinitionEntity generalExtractorRuleEntity, String databaseTypeName) {
        ExtractorRuleDefinitionEntity databaseDialectExtractorRuleEntity = this.extractorRuleLoader.load(RuleDefinitionFileConstant.getExtractorRuleDefinitionFile(databaseTypeName));
        ExtractorRuleDefinition extractorRuleDefinition = new ExtractorRuleDefinition(generalExtractorRuleEntity, databaseDialectExtractorRuleEntity);
        return new SQLStatementRuleDefinition(this.statementRuleLoader.load(RuleDefinitionFileConstant.getSQLStatementRuleDefinitionFile(databaseTypeName)), extractorRuleDefinition);
    }

    public static ParseRuleRegistry getInstance() {
        return instance;
    }

    public SQLStatementRule getSQLStatementRule(String databaseTypeName, String contextClassName) {
        return this.sqlStatementRuleDefinitions.get(databaseTypeName).getSQLStatementRule(contextClassName);
    }

    public Optional<SQLSegmentFiller> findSQLSegmentFiller(String databaseTypeName, Class<? extends SQLSegment> sqlSegmentClass) {
        return Optional.fromNullable((Object)this.fillerRuleDefinitions.get(databaseTypeName).getFiller(sqlSegmentClass));
    }

    static {
        NewInstanceServiceLoader.register(SQLParserEntry.class);
        instance = new ParseRuleRegistry();
    }
}

