/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sql.parser.sql.statement.generic;

import com.google.common.base.Optional;
import java.util.Collection;
import java.util.LinkedList;
import org.apache.shardingsphere.sql.parser.sql.segment.SQLSegment;
import org.apache.shardingsphere.sql.parser.sql.statement.SQLStatement;

public abstract class AbstractSQLStatement
implements SQLStatement {
    private final Collection<SQLSegment> sqlSegments = new LinkedList<SQLSegment>();
    private int parametersCount;

    @Override
    public final Collection<SQLSegment> getAllSQLSegments() {
        return this.sqlSegments;
    }

    @Override
    public final <T extends SQLSegment> Optional<T> findSQLSegment(Class<T> sqlSegmentType) {
        for (SQLSegment each : this.sqlSegments) {
            if (!sqlSegmentType.isAssignableFrom(each.getClass())) continue;
            return Optional.of((Object)each);
        }
        return Optional.absent();
    }

    @Override
    public final <T extends SQLSegment> Collection<T> findSQLSegments(Class<T> sqlSegmentType) {
        LinkedList<SQLSegment> result = new LinkedList<SQLSegment>();
        for (SQLSegment each : this.sqlSegments) {
            if (!sqlSegmentType.isAssignableFrom(each.getClass())) continue;
            result.add(each);
        }
        return result;
    }

    @Override
    public int getParametersCount() {
        return this.parametersCount;
    }

    public void setParametersCount(int parametersCount) {
        this.parametersCount = parametersCount;
    }
}

