/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Optional;
import java.util.Properties;
import java.util.UUID;
import org.apache.spark.annotation.InterfaceStability;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.analysis.EliminateSubqueryAliases$;
import org.apache.spark.sql.catalyst.analysis.UnresolvedRelation;
import org.apache.spark.sql.catalyst.catalog.BucketSpec;
import org.apache.spark.sql.catalyst.catalog.CatalogStorageFormat;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.CatalogTable$;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType$;
import org.apache.spark.sql.catalyst.catalog.HiveTableRelation;
import org.apache.spark.sql.catalyst.catalog.SessionCatalog;
import org.apache.spark.sql.catalyst.plans.logical.InsertIntoTable;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.execution.QueryExecution;
import org.apache.spark.sql.execution.SQLExecution$;
import org.apache.spark.sql.execution.command.DDLUtils$;
import org.apache.spark.sql.execution.datasources.CreateTable;
import org.apache.spark.sql.execution.datasources.DataSource;
import org.apache.spark.sql.execution.datasources.DataSource$;
import org.apache.spark.sql.execution.datasources.LogicalRelation;
import org.apache.spark.sql.execution.datasources.v2.DataSourceV2Utils$;
import org.apache.spark.sql.execution.datasources.v2.WriteToDataSourceV2;
import org.apache.spark.sql.sources.BaseRelation;
import org.apache.spark.sql.sources.v2.DataSourceOptions;
import org.apache.spark.sql.sources.v2.DataSourceV2;
import org.apache.spark.sql.sources.v2.WriteSupport;
import org.apache.spark.sql.sources.v2.writer.DataSourceWriter;
import org.apache.spark.sql.types.StructType;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@InterfaceStability.Stable
@ScalaSignature(bytes="\u0006\u0001\t\rg\u0001B\u0001\u0003\u0005-\u0011q\u0002R1uC\u001a\u0013\u0018-\\3Xe&$XM\u001d\u0006\u0003\u0007\u0011\t1a]9m\u0015\t)a!A\u0003ta\u0006\u00148N\u0003\u0002\b\u0011\u00051\u0011\r]1dQ\u0016T\u0011!C\u0001\u0004_J<7\u0001A\u000b\u0003\u0019m\u0019\"\u0001A\u0007\u0011\u00059\tR\"A\b\u000b\u0003A\tQa]2bY\u0006L!AE\b\u0003\r\u0005s\u0017PU3g\u0011!!\u0002A!A!\u0002\u0013)\u0012A\u00013t!\r1r#G\u0007\u0002\u0005%\u0011\u0001D\u0001\u0002\b\t\u0006$\u0018m]3u!\tQ2\u0004\u0004\u0001\u0005\u000bq\u0001!\u0019A\u000f\u0003\u0003Q\u000b\"AH\u0011\u0011\u00059y\u0012B\u0001\u0011\u0010\u0005\u001dqu\u000e\u001e5j]\u001e\u0004\"A\u0004\u0012\n\u0005\rz!aA!os\"1Q\u0005\u0001C\u0001\u0005\u0019\na\u0001P5oSRtDCA\u0014)!\r1\u0002!\u0007\u0005\u0006)\u0011\u0002\r!\u0006\u0005\bU\u0001\u0011\r\u0011\"\u0003,\u0003\t!g-F\u0001-!\ti\u0003G\u0004\u0002\u0017]%\u0011qFA\u0001\ba\u0006\u001c7.Y4f\u0013\t\t$GA\u0005ECR\fgI]1nK*\u0011qF\u0001\u0005\u0007i\u0001\u0001\u000b\u0011\u0002\u0017\u0002\u0007\u00114\u0007\u0005C\u00037\u0001\u0011\u0005q'\u0001\u0003n_\u0012,GCA\u00149\u0011\u0015IT\u00071\u0001;\u0003!\u0019\u0018M^3N_\u0012,\u0007C\u0001\f<\u0013\ta$A\u0001\u0005TCZ,Wj\u001c3f\u0011\u00151\u0004\u0001\"\u0001?)\t9s\bC\u0003:{\u0001\u0007\u0001\t\u0005\u0002B\t:\u0011aBQ\u0005\u0003\u0007>\ta\u0001\u0015:fI\u00164\u0017BA#G\u0005\u0019\u0019FO]5oO*\u00111i\u0004\u0005\u0006\u0011\u0002!\t!S\u0001\u0007M>\u0014X.\u0019;\u0015\u0005\u001dR\u0005\"B&H\u0001\u0004\u0001\u0015AB:pkJ\u001cW\rC\u0003N\u0001\u0011\u0005a*\u0001\u0004paRLwN\u001c\u000b\u0004O=\u000b\u0006\"\u0002)M\u0001\u0004\u0001\u0015aA6fs\")!\u000b\u0014a\u0001\u0001\u0006)a/\u00197vK\")Q\n\u0001C\u0001)R\u0019q%\u0016,\t\u000bA\u001b\u0006\u0019\u0001!\t\u000bI\u001b\u0006\u0019A,\u0011\u00059A\u0016BA-\u0010\u0005\u001d\u0011un\u001c7fC:DQ!\u0014\u0001\u0005\u0002m#2a\n/^\u0011\u0015\u0001&\f1\u0001A\u0011\u0015\u0011&\f1\u0001_!\tqq,\u0003\u0002a\u001f\t!Aj\u001c8h\u0011\u0015i\u0005\u0001\"\u0001c)\r93\r\u001a\u0005\u0006!\u0006\u0004\r\u0001\u0011\u0005\u0006%\u0006\u0004\r!\u001a\t\u0003\u001d\u0019L!aZ\b\u0003\r\u0011{WO\u00197f\u0011\u0015I\u0007\u0001\"\u0001k\u0003\u001dy\u0007\u000f^5p]N$\"aJ6\t\u000b%D\u0007\u0019\u00017\u0011\t5\u0004\b\tQ\u0007\u0002]*\u0011qnD\u0001\u000bG>dG.Z2uS>t\u0017BA9o\u0005\ri\u0015\r\u001d\u0005\u0006S\u0002!\ta\u001d\u000b\u0003OQDQ!\u001b:A\u0002U\u0004BA^>A\u00016\tqO\u0003\u0002ys\u0006!Q\u000f^5m\u0015\u0005Q\u0018\u0001\u00026bm\u0006L!!]<\t\u000bu\u0004A\u0011\u0001@\u0002\u0017A\f'\u000f^5uS>t')\u001f\u000b\u0003O}Dq!!\u0001}\u0001\u0004\t\u0019!\u0001\u0005d_2t\u0015-\\3t!\u0011q\u0011Q\u0001!\n\u0007\u0005\u001dqB\u0001\u0006=e\u0016\u0004X-\u0019;fIzB3\u0001`A\u0006!\u0011\ti!a\u0005\u000e\u0005\u0005=!bAA\t\u001f\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005U\u0011q\u0002\u0002\bm\u0006\u0014\u0018M]4t\u0011\u001d\tI\u0002\u0001C\u0001\u00037\t\u0001BY;dW\u0016$()\u001f\u000b\bO\u0005u\u0011qEA\u0016\u0011!\ty\"a\u0006A\u0002\u0005\u0005\u0012A\u00038v[\n+8m[3ugB\u0019a\"a\t\n\u0007\u0005\u0015rBA\u0002J]RDq!!\u000b\u0002\u0018\u0001\u0007\u0001)A\u0004d_2t\u0015-\\3\t\u0011\u0005\u0005\u0011q\u0003a\u0001\u0003\u0007AC!a\u0006\u0002\f!9\u0011\u0011\u0007\u0001\u0005\u0002\u0005M\u0012AB:peR\u0014\u0015\u0010F\u0003(\u0003k\t9\u0004C\u0004\u0002*\u0005=\u0002\u0019\u0001!\t\u0011\u0005\u0005\u0011q\u0006a\u0001\u0003\u0007AC!a\f\u0002\f!9\u0011Q\b\u0001\u0005\u0002\u0005}\u0012\u0001B:bm\u0016$B!!\u0011\u0002HA\u0019a\"a\u0011\n\u0007\u0005\u0015sB\u0001\u0003V]&$\bbBA%\u0003w\u0001\r\u0001Q\u0001\u0005a\u0006$\b\u000eC\u0004\u0002>\u0001!\t!!\u0014\u0015\u0005\u0005\u0005\u0003bBA)\u0001\u0011%\u0011QJ\u0001\u000fg\u00064X\rV8WcM{WO]2f\u0011\u001d\t)\u0006\u0001C\u0001\u0003/\n!\"\u001b8tKJ$\u0018J\u001c;p)\u0011\t\t%!\u0017\t\u000f\u0005m\u00131\u000ba\u0001\u0001\u0006IA/\u00192mK:\u000bW.\u001a\u0005\b\u0003+\u0002A\u0011BA0)\u0011\t\t%!\u0019\t\u0011\u0005\r\u0014Q\fa\u0001\u0003K\n!\u0002^1cY\u0016LE-\u001a8u!\u0011\t9'!\u001c\u000e\u0005\u0005%$bAA6\u0005\u0005A1-\u0019;bYf\u001cH/\u0003\u0003\u0002p\u0005%$a\u0004+bE2,\u0017\nZ3oi&4\u0017.\u001a:\t\u000f\u0005M\u0004\u0001\"\u0003\u0002v\u0005iq-\u001a;Ck\u000e\\W\r^*qK\u000e,\"!a\u001e\u0011\u000b9\tI(! \n\u0007\u0005mtB\u0001\u0004PaRLwN\u001c\t\u0005\u0003\u007f\n))\u0004\u0002\u0002\u0002*!\u00111QA5\u0003\u001d\u0019\u0017\r^1m_\u001eLA!a\"\u0002\u0002\nQ!)^2lKR\u001c\u0006/Z2\t\u000f\u0005-\u0005\u0001\"\u0003\u0002\u000e\u0006\t\u0012m]:feRtu\u000e\u001e\"vG.,G/\u001a3\u0015\t\u0005\u0005\u0013q\u0012\u0005\b\u0003#\u000bI\t1\u0001A\u0003%y\u0007/\u001a:bi&|g\u000eC\u0004\u0002\u0016\u0002!I!a&\u0002)\u0005\u001c8/\u001a:u\u001d>$\b+\u0019:uSRLwN\\3e)\u0011\t\t%!'\t\u000f\u0005E\u00151\u0013a\u0001\u0001\"9\u0011Q\u0014\u0001\u0005\u0002\u0005}\u0015aC:bm\u0016\f5\u000fV1cY\u0016$B!!\u0011\u0002\"\"9\u00111LAN\u0001\u0004\u0001\u0005bBAO\u0001\u0011%\u0011Q\u0015\u000b\u0005\u0003\u0003\n9\u000b\u0003\u0005\u0002d\u0005\r\u0006\u0019AA3\u0011\u001d\tY\u000b\u0001C\u0005\u0003[\u000b1b\u0019:fCR,G+\u00192mKR!\u0011\u0011IAX\u0011!\t\u0019'!+A\u0002\u0005\u0015\u0004bBAZ\u0001\u0011\u0005\u0011QW\u0001\u0005U\u0012\u00147\r\u0006\u0005\u0002B\u0005]\u00161XA`\u0011\u001d\tI,!-A\u0002\u0001\u000b1!\u001e:m\u0011\u001d\ti,!-A\u0002\u0001\u000bQ\u0001^1cY\u0016D\u0001\"!1\u00022\u0002\u0007\u00111Y\u0001\u0015G>tg.Z2uS>t\u0007K]8qKJ$\u0018.Z:\u0011\u0007Y\f)-C\u0002\u0002H^\u0014!\u0002\u0015:pa\u0016\u0014H/[3t\u0011\u001d\tY\r\u0001C\u0001\u0003\u001b\fAA[:p]R!\u0011\u0011IAh\u0011\u001d\tI%!3A\u0002\u0001Cq!a5\u0001\t\u0003\t).A\u0004qCJ\fX/\u001a;\u0015\t\u0005\u0005\u0013q\u001b\u0005\b\u0003\u0013\n\t\u000e1\u0001A\u0011\u001d\tY\u000e\u0001C\u0001\u0003;\f1a\u001c:d)\u0011\t\t%a8\t\u000f\u0005%\u0013\u0011\u001ca\u0001\u0001\"9\u00111\u001d\u0001\u0005\u0002\u0005\u0015\u0018\u0001\u0002;fqR$B!!\u0011\u0002h\"9\u0011\u0011JAq\u0001\u0004\u0001\u0005bBAv\u0001\u0011\u0005\u0011Q^\u0001\u0004GN4H\u0003BA!\u0003_Dq!!\u0013\u0002j\u0002\u0007\u0001\tC\u0004\u0002t\u0002!I!!>\u0002\u0015I,hnQ8n[\u0006tG\r\u0006\u0004\u0002x\n5!q\u0003\u000b\u0005\u0003\u0003\nI\u0010\u0003\u0005\u0002|\u0006E\b\u0019AA\u007f\u0003\u001d\u0019w.\\7b]\u0012\u0004B!a@\u0003\n5\u0011!\u0011\u0001\u0006\u0005\u0005\u0007\u0011)!A\u0004m_\u001eL7-\u00197\u000b\t\t\u001d\u0011\u0011N\u0001\u0006a2\fgn]\u0005\u0005\u0005\u0017\u0011\tAA\u0006M_\u001eL7-\u00197QY\u0006t\u0007\u0002\u0003B\b\u0003c\u0004\rA!\u0005\u0002\u000fM,7o]5p]B\u0019aCa\u0005\n\u0007\tU!A\u0001\u0007Ta\u0006\u00148nU3tg&|g\u000eC\u0004\u0003\u001a\u0005E\b\u0019\u0001!\u0002\t9\fW.\u001a\u0005\t\u0017\u0002\u0001\r\u0011\"\u0003\u0003\u001eU\t\u0001\tC\u0005\u0003\"\u0001\u0001\r\u0011\"\u0003\u0003$\u0005Q1o\\;sG\u0016|F%Z9\u0015\t\u0005\u0005#Q\u0005\u0005\n\u0005O\u0011y\"!AA\u0002\u0001\u000b1\u0001\u001f\u00132\u0011\u001d\u0011Y\u0003\u0001Q!\n\u0001\u000bqa]8ve\u000e,\u0007\u0005\u0003\u00057\u0001\u0001\u0007I\u0011\u0002B\u0018+\u0005Q\u0004\"\u0003B\u001a\u0001\u0001\u0007I\u0011\u0002B\u001b\u0003!iw\u000eZ3`I\u0015\fH\u0003BA!\u0005oA\u0011Ba\n\u00032\u0005\u0005\t\u0019\u0001\u001e\t\u000f\tm\u0002\u0001)Q\u0005u\u0005)Qn\u001c3fA!I!q\b\u0001C\u0002\u0013%!\u0011I\u0001\rKb$(/Y(qi&|gn]\u000b\u0003\u0005\u0007\u0002bA!\u0012\u0003L\u0001\u0003UB\u0001B$\u0015\r\u0011IE\\\u0001\b[V$\u0018M\u00197f\u0013\u0011\u0011iEa\u0012\u0003\u000f!\u000b7\u000f['ba\"A!\u0011\u000b\u0001!\u0002\u0013\u0011\u0019%A\u0007fqR\u0014\u0018m\u00149uS>t7\u000f\t\u0005\n\u0005+\u0002\u0001\u0019!C\u0005\u0005/\n1\u0003]1si&$\u0018n\u001c8j]\u001e\u001cu\u000e\\;n]N,\"A!\u0017\u0011\u000b9\tIHa\u0017\u0011\u000b\tu#1\u000e!\u000f\t\t}#\u0011\u000e\b\u0005\u0005C\u00129'\u0004\u0002\u0003d)\u0019!Q\r\u0006\u0002\rq\u0012xn\u001c;?\u0013\u0005\u0001\u0012BA\u0018\u0010\u0013\u0011\u0011iGa\u001c\u0003\u0007M+\u0017O\u0003\u00020\u001f!I!1\u000f\u0001A\u0002\u0013%!QO\u0001\u0018a\u0006\u0014H/\u001b;j_:LgnZ\"pYVlgn]0%KF$B!!\u0011\u0003x!Q!q\u0005B9\u0003\u0003\u0005\rA!\u0017\t\u0011\tm\u0004\u0001)Q\u0005\u00053\nA\u0003]1si&$\u0018n\u001c8j]\u001e\u001cu\u000e\\;n]N\u0004\u0003\"\u0003B@\u0001\u0001\u0007I\u0011\u0002B,\u0003E\u0011WoY6fi\u000e{G.^7o\u001d\u0006lWm\u001d\u0005\n\u0005\u0007\u0003\u0001\u0019!C\u0005\u0005\u000b\u000bQCY;dW\u0016$8i\u001c7v[:t\u0015-\\3t?\u0012*\u0017\u000f\u0006\u0003\u0002B\t\u001d\u0005B\u0003B\u0014\u0005\u0003\u000b\t\u00111\u0001\u0003Z!A!1\u0012\u0001!B\u0013\u0011I&\u0001\nck\u000e\\W\r^\"pYVlgNT1nKN\u0004\u0003\"CA\u0010\u0001\u0001\u0007I\u0011\u0002BH+\t\u0011\t\nE\u0003\u000f\u0003s\n\t\u0003C\u0005\u0003\u0016\u0002\u0001\r\u0011\"\u0003\u0003\u0018\u0006qa.^7Ck\u000e\\W\r^:`I\u0015\fH\u0003BA!\u00053C!Ba\n\u0003\u0014\u0006\u0005\t\u0019\u0001BI\u0011!\u0011i\n\u0001Q!\n\tE\u0015a\u00038v[\n+8m[3ug\u0002B\u0011B!)\u0001\u0001\u0004%IAa\u0016\u0002\u001fM|'\u000f^\"pYVlgNT1nKND\u0011B!*\u0001\u0001\u0004%IAa*\u0002'M|'\u000f^\"pYVlgNT1nKN|F%Z9\u0015\t\u0005\u0005#\u0011\u0016\u0005\u000b\u0005O\u0011\u0019+!AA\u0002\te\u0003\u0002\u0003BW\u0001\u0001\u0006KA!\u0017\u0002!M|'\u000f^\"pYVlgNT1nKN\u0004\u0003f\u0001\u0001\u00032B!!1\u0017B_\u001d\u0011\u0011)L!/\u000e\u0005\t]&bAA\t\t%!!1\u0018B\\\u0003IIe\u000e^3sM\u0006\u001cWm\u0015;bE&d\u0017\u000e^=\n\t\t}&\u0011\u0019\u0002\u0007'R\f'\r\\3\u000b\t\tm&q\u0017")
public final class DataFrameWriter<T> {
    private final Dataset<Row> df;
    private String source;
    private SaveMode mode;
    private final HashMap<String, String> extraOptions;
    private Option<Seq<String>> partitioningColumns;
    private Option<Seq<String>> org$apache$spark$sql$DataFrameWriter$$bucketColumnNames;
    private Option<Object> numBuckets;
    private Option<Seq<String>> org$apache$spark$sql$DataFrameWriter$$sortColumnNames;

    public DataFrameWriter<T> partitionBy(String ... colNames) {
        return this.partitionBy((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])colNames));
    }

    public DataFrameWriter<T> bucketBy(int numBuckets, String colName, String ... colNames) {
        return this.bucketBy(numBuckets, colName, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])colNames));
    }

    public DataFrameWriter<T> sortBy(String colName, String ... colNames) {
        return this.sortBy(colName, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])colNames));
    }

    private Dataset<Row> df() {
        return this.df;
    }

    public DataFrameWriter<T> mode(SaveMode saveMode) {
        this.mode_$eq(saveMode);
        return this;
    }

    public DataFrameWriter<T> mode(String saveMode) {
        block6: {
            SaveMode saveMode2;
            block3: {
                String string;
                block5: {
                    block4: {
                        block2: {
                            string = saveMode.toLowerCase(Locale.ROOT);
                            if (!"overwrite".equals(string)) break block2;
                            saveMode2 = SaveMode.Overwrite;
                            break block3;
                        }
                        if (!"append".equals(string)) break block4;
                        saveMode2 = SaveMode.Append;
                        break block3;
                    }
                    if (!"ignore".equals(string)) break block5;
                    saveMode2 = SaveMode.Ignore;
                    break block3;
                }
                boolean bl = "error".equals(string) ? true : ("errorifexists".equals(string) ? true : "default".equals(string));
                if (!bl) break block6;
                saveMode2 = SaveMode.ErrorIfExists;
            }
            this.mode_$eq(saveMode2);
            return this;
        }
        throw new IllegalArgumentException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unknown save mode: ", ". "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{saveMode}))).append((Object)"Accepted save modes are 'overwrite', 'append', 'ignore', 'error', 'errorifexists'.").toString());
    }

    public DataFrameWriter<T> format(String source) {
        this.source_$eq(source);
        return this;
    }

    public DataFrameWriter<T> option(String key, String value) {
        this.extraOptions().$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)value));
        return this;
    }

    public DataFrameWriter<T> option(String key, boolean value) {
        return this.option(key, ((Object)BoxesRunTime.boxToBoolean((boolean)value)).toString());
    }

    public DataFrameWriter<T> option(String key, long value) {
        return this.option(key, ((Object)BoxesRunTime.boxToLong((long)value)).toString());
    }

    public DataFrameWriter<T> option(String key, double value) {
        return this.option(key, ((Object)BoxesRunTime.boxToDouble((double)value)).toString());
    }

    public DataFrameWriter<T> options(Map<String, String> options) {
        this.extraOptions().$plus$plus$eq(options);
        return this;
    }

    public DataFrameWriter<T> options(java.util.Map<String, String> options) {
        this.options((Map<String, String>)((Map)JavaConverters$.MODULE$.mapAsScalaMapConverter(options).asScala()));
        return this;
    }

    public DataFrameWriter<T> partitionBy(Seq<String> colNames) {
        this.partitioningColumns_$eq((Option<Seq<String>>)Option$.MODULE$.apply(colNames));
        return this;
    }

    public DataFrameWriter<T> bucketBy(int numBuckets, String colName, Seq<String> colNames) {
        this.numBuckets_$eq((Option<Object>)Option$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)numBuckets)));
        String string = colName;
        this.org$apache$spark$sql$DataFrameWriter$$bucketColumnNames_$eq((Option<Seq<String>>)Option$.MODULE$.apply(colNames.$plus$colon((Object)string, Seq$.MODULE$.canBuildFrom())));
        return this;
    }

    public DataFrameWriter<T> sortBy(String colName, Seq<String> colNames) {
        String string = colName;
        this.org$apache$spark$sql$DataFrameWriter$$sortColumnNames_$eq((Option<Seq<String>>)Option$.MODULE$.apply(colNames.$plus$colon((Object)string, Seq$.MODULE$.canBuildFrom())));
        return this;
    }

    public void save(String path) {
        this.extraOptions().$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"path"), (Object)path));
        this.save();
    }

    public void save() {
        String string = this.source().toLowerCase(Locale.ROOT);
        String string2 = DDLUtils$.MODULE$.HIVE_PROVIDER();
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            throw new AnalysisException("Hive data source can only be used with tables, you can not write files of Hive data source directly.", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
        this.assertNotBucketed("save");
        Class<?> cls = DataSource$.MODULE$.lookupDataSource(this.source(), this.df().sparkSession().sessionState().conf());
        if (DataSourceV2.class.isAssignableFrom(cls)) {
            Object ds = cls.newInstance();
            Object obj = ds;
            if (obj instanceof WriteSupport) {
                BoxedUnit boxedUnit;
                WriteSupport writeSupport = (WriteSupport)obj;
                scala.collection.immutable.Map<String, String> sessionOptions = DataSourceV2Utils$.MODULE$.extractSessionConfigs((DataSourceV2)ds, this.df().sparkSession().sessionState().conf());
                DataSourceOptions options = new DataSourceOptions((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)sessionOptions.$plus$plus(this.extraOptions())).asJava());
                String jobId = new StringBuilder().append((Object)new SimpleDateFormat("yyyyMMddHHmmss", Locale.US).format(new Date())).append((Object)"-").append((Object)UUID.randomUUID()).toString();
                Optional<DataSourceWriter> writer = writeSupport.createWriter(jobId, this.df().logicalPlan().schema(), this.mode(), options);
                if (writer.isPresent()) {
                    this.runCommand(this.df().sparkSession(), "save", new WriteToDataSourceV2(writer.get(), (LogicalPlan)this.df().planWithBarrier()));
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                BoxedUnit boxedUnit2 = boxedUnit;
            } else {
                this.saveToV1Source();
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            this.saveToV1Source();
        }
    }

    private void saveToV1Source() {
        SparkSession x$3 = this.df().sparkSession();
        String x$4 = this.source();
        Seq x$5 = (Seq)this.partitioningColumns().getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Nil$ apply() {
                return Nil$.MODULE$;
            }
        });
        scala.collection.immutable.Map x$6 = this.extraOptions().toMap(Predef$.MODULE$.$conforms());
        Seq<String> x$7 = DataSource$.MODULE$.apply$default$3();
        Option<StructType> x$8 = DataSource$.MODULE$.apply$default$4();
        Option<BucketSpec> x$9 = DataSource$.MODULE$.apply$default$6();
        Option<CatalogTable> x$10 = DataSource$.MODULE$.apply$default$8();
        this.runCommand(this.df().sparkSession(), "save", new DataSource(x$3, x$4, x$7, x$8, (Seq<String>)x$5, x$9, (scala.collection.immutable.Map<String, String>)x$6, x$10).planForWriting(this.mode(), (LogicalPlan)this.df().planWithBarrier()));
    }

    public void insertInto(String tableName) {
        this.insertInto(this.df().sparkSession().sessionState().sqlParser().parseTableIdentifier(tableName));
    }

    private void insertInto(TableIdentifier tableIdent) {
        this.assertNotBucketed("insertInto");
        if (this.partitioningColumns().isDefined()) {
            throw new AnalysisException("insertInto() can't be used together with partitionBy(). Partition columns have already been defined for the table. It is not necessary to use partitionBy().", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
        SaveMode saveMode = this.mode();
        SaveMode saveMode2 = SaveMode.Overwrite;
        this.runCommand(this.df().sparkSession(), "insertInto", (LogicalPlan)new InsertIntoTable((LogicalPlan)new UnresolvedRelation(tableIdent), Predef$.MODULE$.Map().empty(), (LogicalPlan)this.df().planWithBarrier(), !(saveMode != null ? !((Object)((Object)saveMode)).equals((Object)saveMode2) : saveMode2 != null), false));
    }

    private Option<BucketSpec> getBucketSpec() {
        if (this.org$apache$spark$sql$DataFrameWriter$$sortColumnNames().isDefined()) {
            Predef$.MODULE$.require(this.numBuckets().isDefined(), (Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "sortBy must be used together with bucketBy";
                }
            });
        }
        return this.numBuckets().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DataFrameWriter $outer;

            public final BucketSpec apply(int n) {
                return new BucketSpec(n, (Seq)this.$outer.org$apache$spark$sql$DataFrameWriter$$bucketColumnNames().get(), (Seq)this.$outer.org$apache$spark$sql$DataFrameWriter$$sortColumnNames().getOrElse((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Nil$ apply() {
                        return Nil$.MODULE$;
                    }
                }));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    private void assertNotBucketed(String operation) {
        if (this.numBuckets().isDefined() || this.org$apache$spark$sql$DataFrameWriter$$sortColumnNames().isDefined()) {
            throw new AnalysisException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"'", "' does not support bucketing right now"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{operation})), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
    }

    private void assertNotPartitioned(String operation) {
        if (this.partitioningColumns().isDefined()) {
            throw new AnalysisException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"'", "' does not support partitioning"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{operation})), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
    }

    public void saveAsTable(String tableName) {
        this.saveAsTable(this.df().sparkSession().sessionState().sqlParser().parseTableIdentifier(tableName));
    }

    /*
     * Enabled aggressive block sorting
     */
    private void saveAsTable(TableIdentifier tableIdent) {
        SessionCatalog catalog2 = this.df().sparkSession().sessionState().catalog();
        boolean tableExists2 = catalog2.tableExists(tableIdent);
        String db = (String)tableIdent.database().getOrElse((Function0)new Serializable(this, catalog2){
            public static final long serialVersionUID = 0L;
            private final SessionCatalog catalog$1;

            public final String apply() {
                return this.catalog$1.getCurrentDatabase();
            }
            {
                this.catalog$1 = catalog$1;
            }
        });
        Some x$11 = new Some((Object)db);
        String x$12 = tableIdent.copy$default$1();
        TableIdentifier tableIdentWithDB = tableIdent.copy(x$12, (Option)x$11);
        String tableName = tableIdentWithDB.unquotedString();
        Tuple2 tuple2 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)tableExists2), (Object)this.mode());
        if (tuple2 != null) {
            boolean bl = tuple2._1$mcZ$sp();
            SaveMode saveMode = (SaveMode)((Object)tuple2._2());
            if (bl && ((Object)((Object)SaveMode.Ignore)).equals((Object)saveMode)) {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            }
        }
        if (tuple2 != null) {
            boolean bl = tuple2._1$mcZ$sp();
            SaveMode saveMode = (SaveMode)((Object)tuple2._2());
            if (bl && ((Object)((Object)SaveMode.ErrorIfExists)).equals((Object)saveMode)) {
                throw new AnalysisException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Table ", " already exists."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableIdent})), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
            }
        }
        if (tuple2 != null) {
            boolean bl = tuple2._1$mcZ$sp();
            SaveMode saveMode = (SaveMode)((Object)tuple2._2());
            if (bl && ((Object)((Object)SaveMode.Overwrite)).equals((Object)saveMode)) {
                HiveTableRelation hiveTableRelation;
                BaseRelation baseRelation;
                LogicalRelation logicalRelation;
                BaseRelation dest;
                Seq srcRelations = this.df().logicalPlan().collect((PartialFunction)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                        Object object;
                        LogicalRelation logicalRelation;
                        BaseRelation src;
                        A1 A1 = x1;
                        if (A1 instanceof LogicalRelation && (src = (logicalRelation = (LogicalRelation)A1).relation()) != null) {
                            BaseRelation baseRelation = src;
                            object = baseRelation;
                        } else if (A1 instanceof HiveTableRelation) {
                            HiveTableRelation hiveTableRelation = (HiveTableRelation)A1;
                            object = hiveTableRelation.tableMeta().identifier();
                        } else {
                            object = function1.apply(x1);
                        }
                        return (B1)object;
                    }

                    public final boolean isDefinedAt(LogicalPlan x1) {
                        LogicalRelation logicalRelation;
                        BaseRelation src;
                        LogicalPlan logicalPlan2 = x1;
                        boolean bl = logicalPlan2 instanceof LogicalRelation && (src = (logicalRelation = (LogicalRelation)logicalPlan2).relation()) != null ? true : logicalPlan2 instanceof HiveTableRelation;
                        return bl;
                    }
                });
                LogicalPlan tableRelation = this.df().sparkSession().table(tableIdentWithDB).queryExecution().analyzed();
                LogicalPlan logicalPlan2 = EliminateSubqueryAliases$.MODULE$.apply(tableRelation);
                if (logicalPlan2 instanceof LogicalRelation && (dest = (logicalRelation = (LogicalRelation)logicalPlan2).relation()) != null && srcRelations.contains((Object)(baseRelation = dest))) {
                    throw new AnalysisException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot overwrite table ", " that is also being read from"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName})), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
                }
                if (logicalPlan2 instanceof HiveTableRelation && srcRelations.contains((Object)(hiveTableRelation = (HiveTableRelation)logicalPlan2).tableMeta().identifier())) {
                    throw new AnalysisException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot overwrite table ", " that is also being read from"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName})), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
                }
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                catalog2.dropTable(tableIdentWithDB, true, false);
                this.createTable(tableIdentWithDB);
                catalog2.refreshTable(tableIdentWithDB);
                BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
                return;
            }
        }
        this.createTable(tableIdent);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private void createTable(TableIdentifier tableIdent) {
        CatalogStorageFormat storage = DataSource$.MODULE$.buildStorageFormatFromOptions((scala.collection.immutable.Map<String, String>)this.extraOptions().toMap(Predef$.MODULE$.$conforms()));
        CatalogTableType tableType = storage.locationUri().isDefined() ? CatalogTableType$.MODULE$.EXTERNAL() : CatalogTableType$.MODULE$.MANAGED();
        CatalogTable tableDesc = new CatalogTable(tableIdent, tableType, storage, new StructType(), (Option)new Some((Object)this.source()), (Seq)this.partitioningColumns().getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Nil$ apply() {
                return Nil$.MODULE$;
            }
        }), this.getBucketSpec(), CatalogTable$.MODULE$.apply$default$8(), CatalogTable$.MODULE$.apply$default$9(), CatalogTable$.MODULE$.apply$default$10(), CatalogTable$.MODULE$.apply$default$11(), CatalogTable$.MODULE$.apply$default$12(), CatalogTable$.MODULE$.apply$default$13(), CatalogTable$.MODULE$.apply$default$14(), CatalogTable$.MODULE$.apply$default$15(), CatalogTable$.MODULE$.apply$default$16(), CatalogTable$.MODULE$.apply$default$17(), CatalogTable$.MODULE$.apply$default$18(), CatalogTable$.MODULE$.apply$default$19());
        this.runCommand(this.df().sparkSession(), "saveAsTable", new CreateTable(tableDesc, this.mode(), (Option<LogicalPlan>)new Some((Object)this.df().planWithBarrier())));
    }

    public void jdbc(String url, String table, Properties connectionProperties) {
        this.assertNotPartitioned("jdbc");
        this.assertNotBucketed("jdbc");
        this.extraOptions().$plus$plus$eq((TraversableOnce)JavaConverters$.MODULE$.propertiesAsScalaMapConverter(connectionProperties).asScala());
        this.extraOptions().$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"url"), (Object)url), (Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dbtable"), (Object)table), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
        this.format("jdbc").save();
    }

    public void json(String path) {
        this.format("json").save(path);
    }

    public void parquet(String path) {
        this.format("parquet").save(path);
    }

    public void orc(String path) {
        this.format("orc").save(path);
    }

    public void text(String path) {
        this.format("text").save(path);
    }

    public void csv(String path) {
        this.format("csv").save(path);
    }

    private void runCommand(SparkSession session, String name, LogicalPlan command) {
        QueryExecution qe = session.sessionState().executePlan(command);
        try {
            long start2 = System.nanoTime();
            SQLExecution$.MODULE$.withNewExecutionId(session, qe, new Serializable(this, qe){
                public static final long serialVersionUID = 0L;
                private final QueryExecution qe$1;

                public final RDD<InternalRow> apply() {
                    return this.qe$1.toRdd();
                }
                {
                    this.qe$1 = qe$1;
                }
            });
            long end = System.nanoTime();
            session.listenerManager().onSuccess(name, qe, end - start2);
            return;
        }
        catch (Exception exception) {
            session.listenerManager().onFailure(name, qe, exception);
            throw exception;
        }
    }

    private String source() {
        return this.source;
    }

    private void source_$eq(String x$1) {
        this.source = x$1;
    }

    private SaveMode mode() {
        return this.mode;
    }

    private void mode_$eq(SaveMode x$1) {
        this.mode = x$1;
    }

    private HashMap<String, String> extraOptions() {
        return this.extraOptions;
    }

    private Option<Seq<String>> partitioningColumns() {
        return this.partitioningColumns;
    }

    private void partitioningColumns_$eq(Option<Seq<String>> x$1) {
        this.partitioningColumns = x$1;
    }

    public Option<Seq<String>> org$apache$spark$sql$DataFrameWriter$$bucketColumnNames() {
        return this.org$apache$spark$sql$DataFrameWriter$$bucketColumnNames;
    }

    private void org$apache$spark$sql$DataFrameWriter$$bucketColumnNames_$eq(Option<Seq<String>> x$1) {
        this.org$apache$spark$sql$DataFrameWriter$$bucketColumnNames = x$1;
    }

    private Option<Object> numBuckets() {
        return this.numBuckets;
    }

    private void numBuckets_$eq(Option<Object> x$1) {
        this.numBuckets = x$1;
    }

    public Option<Seq<String>> org$apache$spark$sql$DataFrameWriter$$sortColumnNames() {
        return this.org$apache$spark$sql$DataFrameWriter$$sortColumnNames;
    }

    private void org$apache$spark$sql$DataFrameWriter$$sortColumnNames_$eq(Option<Seq<String>> x$1) {
        this.org$apache$spark$sql$DataFrameWriter$$sortColumnNames = x$1;
    }

    public DataFrameWriter(Dataset<T> ds) {
        this.df = ds.toDF();
        this.source = this.df().sparkSession().sessionState().conf().defaultDataSourceName();
        this.mode = SaveMode.ErrorIfExists;
        this.extraOptions = new HashMap();
        this.partitioningColumns = None$.MODULE$;
        this.org$apache$spark$sql$DataFrameWriter$$bucketColumnNames = None$.MODULE$;
        this.numBuckets = None$.MODULE$;
        this.org$apache$spark$sql$DataFrameWriter$$sortColumnNames = None$.MODULE$;
    }
}

