/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.v2;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.analysis.AnsiTypeCoercion$;
import org.apache.spark.sql.catalyst.analysis.TypeCoercion$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.SortOrder;
import org.apache.spark.sql.catalyst.expressions.TransformExpression;
import org.apache.spark.sql.catalyst.expressions.V2ExpressionUtils$;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.RebalancePartitions;
import org.apache.spark.sql.catalyst.plans.logical.RepartitionByExpression;
import org.apache.spark.sql.catalyst.plans.logical.Sort;
import org.apache.spark.sql.catalyst.rules.Rule;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.connector.catalog.FunctionCatalog;
import org.apache.spark.sql.connector.catalog.functions.BoundFunction;
import org.apache.spark.sql.connector.catalog.functions.ScalarFunction;
import org.apache.spark.sql.connector.distributions.ClusteredDistribution;
import org.apache.spark.sql.connector.distributions.Distribution;
import org.apache.spark.sql.connector.distributions.OrderedDistribution;
import org.apache.spark.sql.connector.distributions.UnspecifiedDistribution;
import org.apache.spark.sql.connector.write.RequiresDistributionAndOrdering;
import org.apache.spark.sql.connector.write.Write;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class DistributionAndOrderingUtils$ {
    public static DistributionAndOrderingUtils$ MODULE$;

    static {
        new DistributionAndOrderingUtils$();
    }

    public LogicalPlan prepareQuery(Write write, LogicalPlan query, Option<FunctionCatalog> funCatalogOpt) {
        Write write2 = write;
        if (write2 instanceof RequiresDistributionAndOrdering) {
            Object object;
            Seq seq;
            RequiresDistributionAndOrdering requiresDistributionAndOrdering = (RequiresDistributionAndOrdering)write2;
            int numPartitions = requiresDistributionAndOrdering.requiredNumPartitions();
            Distribution distribution = requiresDistributionAndOrdering.requiredDistribution();
            if (distribution instanceof OrderedDistribution) {
                OrderedDistribution orderedDistribution = (OrderedDistribution)distribution;
                seq = (Seq)V2ExpressionUtils$.MODULE$.toCatalystOrdering(orderedDistribution.ordering(), query, funCatalogOpt).map((Function1 & Serializable & scala.Serializable)e -> (SortOrder)MODULE$.resolveTransformExpression((Expression)e), Seq$.MODULE$.canBuildFrom());
            } else if (distribution instanceof ClusteredDistribution) {
                ClusteredDistribution clusteredDistribution = (ClusteredDistribution)distribution;
                seq = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])clusteredDistribution.clustering())).map((Function1 & Serializable & scala.Serializable)e -> V2ExpressionUtils$.MODULE$.toCatalyst(e, query, funCatalogOpt), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Expression.class))))).map((Function1 & Serializable & scala.Serializable)e -> MODULE$.resolveTransformExpression((Expression)e), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Expression.class))))).toSeq();
            } else if (distribution instanceof UnspecifiedDistribution) {
                seq = (Seq)Nil$.MODULE$;
            } else {
                throw new MatchError((Object)distribution);
            }
            Seq distribution2 = seq;
            if (distribution2.nonEmpty()) {
                None$ optNumPartitions;
                Object object2 = optNumPartitions = numPartitions > 0 ? new Some((Object)BoxesRunTime.boxToInteger((int)numPartitions)) : None$.MODULE$;
                object = requiresDistributionAndOrdering.distributionStrictlyRequired() ? new RepartitionByExpression(distribution2, query, (Option)optNumPartitions) : new RebalancePartitions(distribution2, query, (Option)optNumPartitions);
            } else {
                if (numPartitions > 0) {
                    throw QueryCompilationErrors$.MODULE$.numberOfPartitionsNotAllowedWithUnspecifiedDistributionError();
                }
                object = query;
            }
            LogicalPlan queryWithDistribution = object;
            Seq ordering2 = V2ExpressionUtils$.MODULE$.toCatalystOrdering(requiresDistributionAndOrdering.requiredOrdering(), query, funCatalogOpt);
            LogicalPlan queryWithDistributionAndOrdering = ordering2.nonEmpty() ? new Sort((Seq)ordering2.map((Function1 & Serializable & scala.Serializable)e -> (SortOrder)MODULE$.resolveTransformExpression((Expression)e), Seq$.MODULE$.canBuildFrom()), false, queryWithDistribution) : queryWithDistribution;
            return (LogicalPlan)this.typeCoercionRules().foldLeft((Object)queryWithDistributionAndOrdering, (Function2 & Serializable & scala.Serializable)(plan, rule) -> (LogicalPlan)rule.apply((TreeNode)plan));
        }
        return query;
    }

    private Expression resolveTransformExpression(Expression expr) {
        return (Expression)expr.transform((PartialFunction)new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Expression, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                boolean bl = false;
                TransformExpression transformExpression = null;
                A1 A1 = x1;
                if (A1 instanceof TransformExpression) {
                    bl = true;
                    transformExpression = (TransformExpression)A1;
                    BoundFunction scalarFunc = transformExpression.function();
                    Seq arguments = transformExpression.children();
                    Option option = transformExpression.numBucketsOpt();
                    if (scalarFunc instanceof ScalarFunction) {
                        ScalarFunction scalarFunction = (ScalarFunction)scalarFunc;
                        if (option instanceof Some) {
                            Some some = (Some)option;
                            int numBuckets = BoxesRunTime.unboxToInt((Object)some.value());
                            return (B1)V2ExpressionUtils$.MODULE$.resolveScalarFunction(scalarFunction, (Seq)((TraversableLike)new .colon.colon((Object)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)numBuckets)), (List)Nil$.MODULE$)).$plus$plus((GenTraversableOnce)arguments, Seq$.MODULE$.canBuildFrom()));
                        }
                    }
                }
                if (bl) {
                    BoundFunction scalarFunc = transformExpression.function();
                    Seq arguments = transformExpression.children();
                    Option option = transformExpression.numBucketsOpt();
                    if (scalarFunc instanceof ScalarFunction) {
                        ScalarFunction scalarFunction = (ScalarFunction)scalarFunc;
                        if (None$.MODULE$.equals(option)) {
                            return (B1)V2ExpressionUtils$.MODULE$.resolveScalarFunction(scalarFunction, arguments);
                        }
                    }
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Expression x1) {
                boolean bl = false;
                TransformExpression transformExpression = null;
                Expression expression = x1;
                if (expression instanceof TransformExpression) {
                    bl = true;
                    transformExpression = (TransformExpression)expression;
                    BoundFunction scalarFunc = transformExpression.function();
                    Option option = transformExpression.numBucketsOpt();
                    if (scalarFunc instanceof ScalarFunction && option instanceof Some) {
                        return true;
                    }
                }
                if (bl) {
                    BoundFunction scalarFunc = transformExpression.function();
                    Option option = transformExpression.numBucketsOpt();
                    if (scalarFunc instanceof ScalarFunction && None$.MODULE$.equals(option)) {
                        return true;
                    }
                }
                return false;
            }
        });
    }

    private List<Rule<LogicalPlan>> typeCoercionRules() {
        if (V2ExpressionUtils$.MODULE$.conf().ansiEnabled()) {
            return AnsiTypeCoercion$.MODULE$.typeCoercionRules();
        }
        return TypeCoercion$.MODULE$.typeCoercionRules();
    }

    private DistributionAndOrderingUtils$() {
        MODULE$ = this;
    }
}

