/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.jdbc;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.Date;
import java.sql.Driver;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.spark.QueryContext;
import org.apache.spark.annotation.DeveloperApi;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.catalyst.CatalystTypeConverters$;
import org.apache.spark.sql.catalyst.util.DateFormatter$;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.catalyst.util.TimestampFormatter;
import org.apache.spark.sql.catalyst.util.TimestampFormatter$;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.TableChange;
import org.apache.spark.sql.connector.catalog.functions.UnboundFunction;
import org.apache.spark.sql.connector.catalog.index.TableIndex;
import org.apache.spark.sql.connector.expressions.Expression;
import org.apache.spark.sql.connector.expressions.Literal;
import org.apache.spark.sql.connector.expressions.NamedReference;
import org.apache.spark.sql.connector.expressions.aggregate.AggregateFunc;
import org.apache.spark.sql.connector.util.V2ExpressionSQLBuilder;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.execution.datasources.jdbc.DriverRegistry$;
import org.apache.spark.sql.execution.datasources.jdbc.JDBCOptions;
import org.apache.spark.sql.execution.datasources.jdbc.JdbcUtils$;
import org.apache.spark.sql.execution.datasources.jdbc.connection.ConnectionProvider$;
import org.apache.spark.sql.execution.datasources.v2.TableSampleInfo;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.jdbc.JdbcType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.MetadataBuilder;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuilder;
import scala.collection.mutable.ArrayBuilder$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.control.NonFatal$;

@DeveloperApi
@ScalaSignature(bytes="\u0006\u0001\u0011eb!\u0002\u001c8\u0003\u0003\u0011\u0005\"\u0002*\u0001\t\u0003\u0019\u0006\"\u0002,\u0001\r\u00039\u0006\"\u00025\u0001\t\u0003I\u0007bBA\u0002\u0001\u0011\u0005\u0011Q\u0001\u0005\b\u0003'\u0001A\u0011AA\u000b\u0011\u001d\t\u0019\u0006\u0001C\u0001\u0003+Bq!a\u0017\u0001\t\u0003\ti\u0006C\u0004\u0002d\u0001!\t!!\u001a\t\u000f\u0005=\u0004\u0001\"\u0001\u0002r!9\u0011q\u000e\u0001\u0005\u0002\u0005m\u0004\"CAF\u0001E\u0005I\u0011AAG\u0011\u001d\t\t\u000b\u0001C\u0001\u0003GC\u0001\"!/\u0001\t#9\u00141\u0018\u0005\b\u0003\u0007\u0004A\u0011AAc\r\u001d\t\t\u000e\u0001\u00018\u0003'DaAU\b\u0005\u0002\u0005\u0015\bbBAv\u001f\u0011\u0005\u0013Q\u001e\u0005\b\u0005#yA\u0011\tB\n\u0011\u001d\u0011yb\u0004C!\u0005CAqAa\u000b\u0010\t\u0003\u0012i\u0003C\u0004\u0003>=!\tEa\u0010\t\u000f\t%s\u0002\"\u0005\u0003L!9!qJ\b\u0005B\tE\u0003b\u0002B+\u001f\u0011\u0005#q\u000b\u0005\u000f\u0005?z\u0001\u0013aA\u0001\u0002\u0013%!\u0011\rB>\u0011\u001d\u0011i\b\u0001C\u0001\u0005\u007fBqA!\"\u0001\t\u0003\u00119\tC\u0004\u0003\u0018\u0002!\tA!'\t\u000f\tu\u0006\u0001\"\u0001\u0003@\"9!q\u001d\u0001\u0005\u0002\t%\bb\u0002B\u007f\u0001\u0011\u0005!q \u0005\b\u0007\u0013\u0001A\u0011AB\u0006\u0011\u001d\u0019\u0019\u0002\u0001C\u0001\u0007+Aqaa\u0006\u0001\t\u0003\u0019I\u0002C\u0004\u0004$\u0001!\ta!\n\t\u000f\ru\u0002\u0001\"\u0001\u0004@!91\u0011\n\u0001\u0005\u0002\r-\u0003bBB,\u0001\u0011\u00051\u0011\f\u0005\b\u0007?\u0002A\u0011AB1\u0011\u001d\u0019Y\u0007\u0001C\u0001\u0007[Bqaa\u001e\u0001\t\u0003\u0019I\bC\u0004\u0004\u0000\u0001!\ta!!\t\u000f\r\u001d\u0005\u0001\"\u0001\u0004\n\"91Q\u0012\u0001\u0005\u0002\r=\u0005bBBK\u0001\u0011\u00051q\u0013\u0005\b\u0007{\u0003A\u0011AB`\u0011\u001d\u0019I\r\u0001C\u0001\u0007\u0017Dqa!5\u0001\t\u0003\u0019\u0019\u000eC\u0004\u0004j\u0002!\taa;\t\u000f\u0011\r\u0001\u0001\"\u0001\u0005\u0006!9A\u0011\u0003\u0001\u0005\u0002\u0011M\u0001b\u0002C\r\u0001\u0011\u0005A1\u0004\u0005\b\t;\u0001A\u0011\u0001C\u0010\u0005-QEMY2ES\u0006dWm\u0019;\u000b\u0005aJ\u0014\u0001\u00026eE\u000eT!AO\u001e\u0002\u0007M\fHN\u0003\u0002={\u0005)1\u000f]1sW*\u0011ahP\u0001\u0007CB\f7\r[3\u000b\u0003\u0001\u000b1a\u001c:h\u0007\u0001\u0019B\u0001A\"J\u0019B\u0011AiR\u0007\u0002\u000b*\ta)A\u0003tG\u0006d\u0017-\u0003\u0002I\u000b\n1\u0011I\\=SK\u001a\u0004\"\u0001\u0012&\n\u0005-+%\u0001D*fe&\fG.\u001b>bE2,\u0007CA'Q\u001b\u0005q%BA(<\u0003!Ig\u000e^3s]\u0006d\u0017BA)O\u0005\u001daunZ4j]\u001e\fa\u0001P5oSRtD#\u0001+\u0011\u0005U\u0003Q\"A\u001c\u0002\u0013\r\fg\u000eS1oI2,GC\u0001-\\!\t!\u0015,\u0003\u0002[\u000b\n9!i\\8mK\u0006t\u0007\"\u0002/\u0003\u0001\u0004i\u0016aA;sYB\u0011a,\u001a\b\u0003?\u000e\u0004\"\u0001Y#\u000e\u0003\u0005T!AY!\u0002\rq\u0012xn\u001c;?\u0013\t!W)\u0001\u0004Qe\u0016$WMZ\u0005\u0003M\u001e\u0014aa\u0015;sS:<'B\u00013F\u0003=9W\r^\"bi\u0006d\u0017p\u001d;UsB,G#\u00026tqjd\bc\u0001#l[&\u0011A.\u0012\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u00059\fX\"A8\u000b\u0005AL\u0014!\u0002;za\u0016\u001c\u0018B\u0001:p\u0005!!\u0015\r^1UsB,\u0007\"\u0002;\u0004\u0001\u0004)\u0018aB:rYRK\b/\u001a\t\u0003\tZL!a^#\u0003\u0007%sG\u000fC\u0003z\u0007\u0001\u0007Q,\u0001\u0005usB,g*Y7f\u0011\u0015Y8\u00011\u0001v\u0003\u0011\u0019\u0018N_3\t\u000bu\u001c\u0001\u0019\u0001@\u0002\u00055$\u0007C\u00018\u0000\u0013\r\t\ta\u001c\u0002\u0010\u001b\u0016$\u0018\rZ1uC\n+\u0018\u000e\u001c3fe\u0006Yq-\u001a;K\t\n\u001bE+\u001f9f)\u0011\t9!a\u0004\u0011\t\u0011[\u0017\u0011\u0002\t\u0004+\u0006-\u0011bAA\u0007o\tA!\n\u001a2d)f\u0004X\r\u0003\u0004\u0002\u0012\u0011\u0001\r!\\\u0001\u0003IR\fqc\u0019:fCR,7i\u001c8oK\u000e$\u0018n\u001c8GC\u000e$xN]=\u0015\t\u0005]\u00111\u0006\t\u0007\t\u0006eQ/!\b\n\u0007\u0005mQIA\u0005Gk:\u001cG/[8ocA!\u0011qDA\u0014\u001b\t\t\tCC\u0002;\u0003GQ!!!\n\u0002\t)\fg/Y\u0005\u0005\u0003S\t\tC\u0001\u0006D_:tWm\u0019;j_:Dq!!\f\u0006\u0001\u0004\ty#A\u0004paRLwN\\:\u0011\t\u0005E\u0012QH\u0007\u0003\u0003gQ1\u0001OA\u001b\u0015\u0011\t9$!\u000f\u0002\u0017\u0011\fG/Y:pkJ\u001cWm\u001d\u0006\u0004\u0003wI\u0014!C3yK\u000e,H/[8o\u0013\u0011\ty$a\r\u0003\u0017)#%iQ(qi&|gn\u001d\u0015\u0006\u000b\u0005\r\u0013q\n\t\u0005\u0003\u000b\nY%\u0004\u0002\u0002H)\u0019\u0011\u0011J\u001e\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002N\u0005\u001d#!B*j]\u000e,\u0017EAA)\u0003\u0015\u0019df\r\u00181\u0003=\tXo\u001c;f\u0013\u0012,g\u000e^5gS\u0016\u0014HcA/\u0002X!1\u0011\u0011\f\u0004A\u0002u\u000bqaY8m\u001d\u0006lW-A\nhKR$\u0016M\u00197f\u000bbL7\u000f^:Rk\u0016\u0014\u0018\u0010F\u0002^\u0003?Ba!!\u0019\b\u0001\u0004i\u0016!\u0002;bE2,\u0017AD4fiN\u001b\u0007.Z7b#V,'/\u001f\u000b\u0004;\u0006\u001d\u0004BBA1\u0011\u0001\u0007Q\fK\u0003\t\u0003\u0007\nY'\t\u0002\u0002n\u0005)!GL\u0019/a\u0005\u0001r-\u001a;UeVt7-\u0019;f#V,'/\u001f\u000b\u0004;\u0006M\u0004BBA1\u0013\u0001\u0007Q\fK\u0003\n\u0003\u0007\n9(\t\u0002\u0002z\u0005)!GL\u001a/aQ)Q,! \u0002\u0000!1\u0011\u0011\r\u0006A\u0002uC\u0011\"!!\u000b!\u0003\u0005\r!a!\u0002\u000f\r\f7oY1eKB\u0019Ai\u001b-)\u000b)\t\u0019%a\"\"\u0005\u0005%\u0015!\u0002\u001a/i9\u0002\u0014AG4fiR\u0013XO\\2bi\u0016\fV/\u001a:zI\u0011,g-Y;mi\u0012\u0012TCAAHU\u0011\t\u0019)!%,\u0005\u0005M\u0005\u0003BAK\u0003;k!!a&\u000b\t\u0005e\u00151T\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!\u0013F\u0013\u0011\ty*a&\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-A\u0006cK\u001a|'/\u001a$fi\u000eDGCBAS\u0003W\u000by\u000bE\u0002E\u0003OK1!!+F\u0005\u0011)f.\u001b;\t\u000f\u00055F\u00021\u0001\u0002\u001e\u0005Q1m\u001c8oK\u000e$\u0018n\u001c8\t\u000f\u0005EF\u00021\u0001\u00024\u0006Q\u0001O]8qKJ$\u0018.Z:\u0011\u000by\u000b),X/\n\u0007\u0005]vMA\u0002NCB\f\u0011\"Z:dCB,7+\u001d7\u0015\u0007u\u000bi\f\u0003\u0004\u0002@6\u0001\r!X\u0001\u0006m\u0006dW/\u001a\u0015\u0006\u001b\u0005\r\u0013qO\u0001\rG>l\u0007/\u001b7f-\u0006dW/\u001a\u000b\u0005\u0003\u000f\fi\rE\u0002E\u0003\u0013L1!a3F\u0005\r\te.\u001f\u0005\b\u0003\u007fs\u0001\u0019AAdQ\u0015q\u00111IA<\u00059QEIQ\"T#2\u0013U/\u001b7eKJ\u001c2aDAk!\u0011\t9.!9\u000e\u0005\u0005e'\u0002BAn\u0003;\fA!\u001e;jY*\u0019\u0011q\\\u001d\u0002\u0013\r|gN\\3di>\u0014\u0018\u0002BAr\u00033\u0014aC\u0016\u001aFqB\u0014Xm]:j_:\u001c\u0016\u000b\u0014\"vS2$WM\u001d\u000b\u0003\u0003O\u00042!!;\u0010\u001b\u0005\u0001\u0011\u0001\u0004<jg&$H*\u001b;fe\u0006dGcA/\u0002p\"9\u0011\u0011_\tA\u0002\u0005M\u0018a\u00027ji\u0016\u0014\u0018\r\u001c\u0019\u0005\u0003k\u0014)\u0001\u0005\u0004\u0002x\u0006u(\u0011A\u0007\u0003\u0003sTA!a?\u0002^\u0006YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0013\u0011\ty0!?\u0003\u000f1KG/\u001a:bYB!!1\u0001B\u0003\u0019\u0001!ABa\u0002\u0002p\u0006\u0005\t\u0011!B\u0001\u0005\u0013\u00111a\u0018\u00132#\u0011\u0011Y!a2\u0011\u0007\u0011\u0013i!C\u0002\u0003\u0010\u0015\u0013qAT8uQ&tw-A\nwSNLGOT1nK\u0012\u0014VMZ3sK:\u001cW\rF\u0002^\u0005+AqAa\u0006\u0013\u0001\u0004\u0011I\"\u0001\u0005oC6,GMU3g!\u0011\t9Pa\u0007\n\t\tu\u0011\u0011 \u0002\u000f\u001d\u0006lW\r\u001a*fM\u0016\u0014XM\\2f\u0003%1\u0018n]5u\u0007\u0006\u001cH\u000fF\u0003^\u0005G\u00119\u0003\u0003\u0004\u0003&M\u0001\r!X\u0001\u0002Y\"1!\u0011F\nA\u00025\f\u0001\u0002Z1uCRK\b/Z\u0001\u0011m&\u001c\u0018\u000e^*R\u0019\u001a+hn\u0019;j_:$R!\u0018B\u0018\u0005gAaA!\r\u0015\u0001\u0004i\u0016\u0001\u00034v]\u000et\u0015-\\3\t\u000f\tUB\u00031\u0001\u00038\u00051\u0011N\u001c9viN\u0004B\u0001\u0012B\u001d;&\u0019!1H#\u0003\u000b\u0005\u0013(/Y=\u0002-YL7/\u001b;BO\u001e\u0014XmZ1uK\u001a+hn\u0019;j_:$r!\u0018B!\u0005\u0007\u00129\u0005\u0003\u0004\u00032U\u0001\r!\u0018\u0005\u0007\u0005\u000b*\u0002\u0019\u0001-\u0002\u0015%\u001cH)[:uS:\u001cG\u000fC\u0004\u00036U\u0001\rAa\u000e\u0002'\u0011L\u0017\r\\3di\u001a+hn\u0019;j_:t\u0015-\\3\u0015\u0007u\u0013i\u0005\u0003\u0004\u00032Y\u0001\r!X\u0001\rm&\u001c\u0018\u000e^(wKJd\u0017-\u001f\u000b\u0004;\nM\u0003b\u0002B\u001b/\u0001\u0007!qG\u0001\nm&\u001c\u0018\u000e\u001e+sS6$R!\u0018B-\u0005;BaAa\u0017\u0019\u0001\u0004i\u0016!\u00033je\u0016\u001cG/[8o\u0011\u001d\u0011)\u0004\u0007a\u0001\u0005o\t!c];qKJ$c/[:ji2KG/\u001a:bYR!!1\rB7!\u0011\u0011)Ga\u001b\u000e\u0005\t\u001d$\u0002\u0002B5\u0003G\tA\u0001\\1oO&\u0019aMa\u001a\t\u0013\t=\u0014$!AA\u0002\tE\u0014a\u0001=%cA\"!1\u000fB<!\u0019\t90!@\u0003vA!!1\u0001B<\t1\u0011IH!\u001c\u0002\u0002\u0003\u0005)\u0011\u0001B\u0005\u0005\ty\u0004'\u0003\u0003\u0002l\u0006\u0005\u0018aE5t'V\u0004\bo\u001c:uK\u00124UO\\2uS>tGc\u0001-\u0003\u0002\"1!\u0011\u0007\u000eA\u0002uCSAGA\"\u0003\u001f\n\u0011cY8na&dW-\u0012=qe\u0016\u001c8/[8o)\u0011\u0011IIa#\u0011\u0007\u0011[W\fC\u0004\u0003\u000en\u0001\rAa$\u0002\t\u0015D\bO\u001d\t\u0005\u0003o\u0014\t*\u0003\u0003\u0003\u0014\u0006e(AC#yaJ,7o]5p]\"*1$a\u0011\u0002P\u0005\u00012m\\7qS2,\u0017iZ4sK\u001e\fG/\u001a\u000b\u0005\u0005\u0013\u0013Y\nC\u0004\u0003\u001er\u0001\rAa(\u0002\u0017\u0005<wMR;oGRLwN\u001c\t\u0005\u0005C\u00139+\u0004\u0002\u0003$*!!QUA}\u0003%\twm\u001a:fO\u0006$X-\u0003\u0003\u0003*\n\r&!D!hOJ,w-\u0019;f\rVt7\rK\u0004\u001d\u0005[\u0013\u0019La.\u0011\u0007\u0011\u0013y+C\u0002\u00032\u0016\u0013!\u0002Z3qe\u0016\u001c\u0017\r^3eC\t\u0011),\u0001#vg\u0016\u0004sN]4/CB\f7\r[3/gB\f'o\u001b\u0018tc2t#\u000e\u001a2d])#'m\u0019#jC2,7\r\u001e\u0018d_6\u0004\u0018\u000e\\3FqB\u0014Xm]:j_:\u0004\u0013N\\:uK\u0006$g&\t\u0002\u0003:\u0006)1G\f\u001b/a!*A$a\u0011\u0002P\u0005Ia-\u001e8di&|gn]\u000b\u0003\u0005\u0003\u0004bAa1\u0003N\nMg\u0002\u0002Bc\u0005\u0013t1\u0001\u0019Bd\u0013\u00051\u0015b\u0001Bf\u000b\u00069\u0001/Y2lC\u001e,\u0017\u0002\u0002Bh\u0005#\u00141aU3r\u0015\r\u0011Y-\u0012\t\u0007\t\nUWL!7\n\u0007\t]WI\u0001\u0004UkBdWM\r\t\u0005\u00057\u0014\u0019/\u0004\u0002\u0003^*!!Q\u0018Bp\u0015\u0011\u0011\t/!8\u0002\u000f\r\fG/\u00197pO&!!Q\u001dBo\u0005=)fNY8v]\u00124UO\\2uS>t\u0017\u0001D2sK\u0006$XmU2iK6\fG\u0003CAS\u0005W\u0014)P!?\t\u000f\t5h\u00041\u0001\u0003p\u0006I1\u000f^1uK6,g\u000e\u001e\t\u0005\u0003?\u0011\t0\u0003\u0003\u0003t\u0006\u0005\"!C*uCR,W.\u001a8u\u0011\u0019\u00119P\ba\u0001;\u000611o\u00195f[\u0006DaAa?\u001f\u0001\u0004i\u0016aB2p[6,g\u000e^\u0001\u000eg\u000eDW-\\1t\u000bbL7\u000f^:\u0015\u000fa\u001b\ta!\u0002\u0004\b!911A\u0010A\u0002\u0005u\u0011\u0001B2p]:Dq!!\f \u0001\u0004\ty\u0003\u0003\u0004\u0003x~\u0001\r!X\u0001\fY&\u001cHoU2iK6\f7\u000f\u0006\u0004\u0004\u000e\r=1\u0011\u0003\t\u0006\t\ne\"q\u0007\u0005\b\u0007\u0007\u0001\u0003\u0019AA\u000f\u0011\u001d\ti\u0003\ta\u0001\u0003_\t\u0001$[:DCN\u001c\u0017\rZ5oOR\u0013XO\\2bi\u0016$\u0016M\u00197f)\t\t\u0019)A\u0006sK:\fW.\u001a+bE2,G#B/\u0004\u001c\r}\u0001BBB\u000fE\u0001\u0007Q,\u0001\u0005pY\u0012$\u0016M\u00197f\u0011\u0019\u0019\tC\ta\u0001;\u0006Aa.Z<UC\ndW-\u0001\u0006bYR,'\u000fV1cY\u0016$\u0002Ba\u000e\u0004(\r-2\u0011\b\u0005\u0007\u0007S\u0019\u0003\u0019A/\u0002\u0013Q\f'\r\\3OC6,\u0007bBB\u0017G\u0001\u00071qF\u0001\bG\"\fgnZ3t!\u0019\u0011\u0019M!4\u00042A!11GB\u001b\u001b\t\u0011y.\u0003\u0003\u00048\t}'a\u0003+bE2,7\t[1oO\u0016Daaa\u000f$\u0001\u0004)\u0018A\u00043c\u001b\u0006TwN\u001d,feNLwN\\\u0001\u0012O\u0016$\u0018\t\u001a3D_2,XN\\)vKJLHcB/\u0004B\r\r3q\t\u0005\u0007\u0007S!\u0003\u0019A/\t\r\r\u0015C\u00051\u0001^\u0003)\u0019w\u000e\\;n]:\u000bW.\u001a\u0005\u0007\u0005S!\u0003\u0019A/\u0002)\u001d,GOU3oC6,7i\u001c7v[:\fV/\u001a:z)%i6QJB(\u0007#\u001a)\u0006\u0003\u0004\u0004*\u0015\u0002\r!\u0018\u0005\u0007\u0007\u000b*\u0003\u0019A/\t\r\rMS\u00051\u0001^\u0003\u001dqWm\u001e(b[\u0016Daaa\u000f&\u0001\u0004)\u0018\u0001F4fi\u0012+G.\u001a;f\u0007>dW/\u001c8Rk\u0016\u0014\u0018\u0010F\u0003^\u00077\u001ai\u0006\u0003\u0004\u0004*\u0019\u0002\r!\u0018\u0005\u0007\u0007\u000b2\u0003\u0019A/\u00021\u001d,G/\u00169eCR,7i\u001c7v[:$\u0016\u0010]3Rk\u0016\u0014\u0018\u0010F\u0004^\u0007G\u001a)ga\u001a\t\r\r%r\u00051\u0001^\u0011\u0019\u0019)e\na\u0001;\"11\u0011N\u0014A\u0002u\u000b1B\\3x\t\u0006$\u0018\rV=qK\u0006yr-\u001a;Va\u0012\fG/Z\"pYVlgNT;mY\u0006\u0014\u0017\u000e\\5usF+XM]=\u0015\u000fu\u001byg!\u001d\u0004t!11\u0011\u0006\u0015A\u0002uCaa!\u0012)\u0001\u0004i\u0006BBB;Q\u0001\u0007\u0001,\u0001\u0006jg:+H\u000e\\1cY\u0016\fAcZ3u)\u0006\u0014G.Z\"p[6,g\u000e^)vKJLH#B/\u0004|\ru\u0004BBA1S\u0001\u0007Q\f\u0003\u0004\u0003|&\u0002\r!X\u0001\u0016O\u0016$8k\u00195f[\u0006\u001cu.\\7f]R\fV/\u001a:z)\u0015i61QBC\u0011\u0019\u00119P\u000ba\u0001;\"1!1 \u0016A\u0002u\u000b\u0001D]3n_Z,7k\u00195f[\u0006\u001cu.\\7f]R\fV/\u001a:z)\ri61\u0012\u0005\u0007\u0005o\\\u0003\u0019A/\u0002\u0015\u0011\u0014x\u000e]*dQ\u0016l\u0017\rF\u0003^\u0007#\u001b\u0019\n\u0003\u0004\u0003x2\u0002\r!\u0018\u0005\u0007\u0003\u0003c\u0003\u0019\u0001-\u0002\u0017\r\u0014X-\u0019;f\u0013:$W\r\u001f\u000b\f;\u000ee5QTBT\u0007[\u001bY\f\u0003\u0004\u0004\u001c6\u0002\r!X\u0001\nS:$W\r\u001f(b[\u0016Dqaa(.\u0001\u0004\u0019\t+\u0001\u0006uC\ndW-\u00133f]R\u0004Baa\r\u0004$&!1Q\u0015Bp\u0005)IE-\u001a8uS\u001aLWM\u001d\u0005\b\u0007Sk\u0003\u0019ABV\u0003\u001d\u0019w\u000e\\;n]N\u0004R\u0001\u0012B\u001d\u00053Aqaa,.\u0001\u0004\u0019\t,A\td_2,XN\\:Qe>\u0004XM\u001d;jKN\u0004\u0002ba-\u00048\ne1\u0011X\u0007\u0003\u0007kSA!a7\u0002$%!\u0011qWB[!\u0019\u0019\u0019la.^;\"9\u0011\u0011W\u0017A\u0002\re\u0016aC5oI\u0016DX\t_5tiN$\u0012\u0002WBa\u0007\u0007\u001c)ma2\t\u000f\r\ra\u00061\u0001\u0002\u001e!111\u0014\u0018A\u0002uCqaa(/\u0001\u0004\u0019\t\u000bC\u0004\u0002.9\u0002\r!a\f\u0002\u0013\u0011\u0014x\u000e]%oI\u0016DH#B/\u0004N\u000e=\u0007BBBN_\u0001\u0007Q\fC\u0004\u0004 >\u0002\ra!)\u0002\u00171L7\u000f^%oI\u0016DXm\u001d\u000b\t\u0007+\u001c\u0019o!:\u0004hB)AI!\u000f\u0004XB!1\u0011\\Bp\u001b\t\u0019YN\u0003\u0003\u0004^\n}\u0017!B5oI\u0016D\u0018\u0002BBq\u00077\u0014!\u0002V1cY\u0016Le\u000eZ3y\u0011\u001d\u0019\u0019\u0001\ra\u0001\u0003;Aqaa(1\u0001\u0004\u0019\t\u000bC\u0004\u0002.A\u0002\r!a\f\u0002#\rd\u0017m]:jMf,\u0005pY3qi&|g\u000e\u0006\u0004\u0004n\u000eU8\u0011 \t\u0005\u0007_\u001c\t0D\u0001:\u0013\r\u0019\u00190\u000f\u0002\u0012\u0003:\fG._:jg\u0016C8-\u001a9uS>t\u0007BBB|c\u0001\u0007Q,A\u0004nKN\u001c\u0018mZ3\t\u000f\rm\u0018\u00071\u0001\u0004~\u0006\tQ\r\u0005\u0003\u0003D\u000e}\u0018\u0002\u0002C\u0001\u0005#\u0014\u0011\u0002\u00165s_^\f'\r\\3\u0002\u001d\u001d,G\u000fT5nSR\u001cE.Y;tKR\u0019Q\fb\u0002\t\u000f\u0011%!\u00071\u0001\u0005\f\u0005)A.[7jiB!!Q\rC\u0007\u0013\u0011!yAa\u001a\u0003\u000f%sG/Z4fe\u0006yq-\u001a;PM\u001a\u001cX\r^\"mCV\u001cX\rF\u0002^\t+Aq\u0001b\u00064\u0001\u0004!Y!\u0001\u0004pM\u001a\u001cX\r^\u0001\u0014gV\u0004\bo\u001c:ugR\u000b'\r\\3TC6\u0004H.Z\u000b\u00021\u0006qq-\u001a;UC\ndWmU1na2,GcA/\u0005\"!9A1E\u001bA\u0002\u0011\u0015\u0012AB:b[BdW\r\u0005\u0003\u0005(\u00115RB\u0001C\u0015\u0015\u0011!Y#!\u000e\u0002\u0005Y\u0014\u0014\u0002\u0002C\u0018\tS\u0011q\u0002V1cY\u0016\u001c\u0016-\u001c9mK&sgm\u001c\u0015\u0004\u0001\u0011M\u0002\u0003BA#\tkIA\u0001b\u000e\u0002H\taA)\u001a<fY>\u0004XM]!qS\u0002")
public abstract class JdbcDialect
implements scala.Serializable,
Logging {
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public abstract boolean canHandle(String var1);

    public Option<DataType> getCatalystType(int sqlType, String typeName, int size, MetadataBuilder md) {
        return None$.MODULE$;
    }

    public Option<JdbcType> getJDBCType(DataType dt) {
        return None$.MODULE$;
    }

    public Function1<Object, Connection> createConnectionFactory(JDBCOptions options) {
        String driverClass = options.driverClass();
        return (Function1 & Serializable & scala.Serializable)partitionId -> JdbcDialect.$anonfun$createConnectionFactory$1(driverClass, options, BoxesRunTime.unboxToInt((Object)partitionId));
    }

    public String quoteIdentifier(String colName) {
        return new StringBuilder(2).append("\"").append(colName).append("\"").toString();
    }

    public String getTableExistsQuery(String table) {
        return new StringBuilder(24).append("SELECT * FROM ").append(table).append(" WHERE 1=0").toString();
    }

    public String getSchemaQuery(String table) {
        return new StringBuilder(24).append("SELECT * FROM ").append(table).append(" WHERE 1=0").toString();
    }

    public String getTruncateQuery(String table) {
        return this.getTruncateQuery(table, this.isCascadingTruncateTable());
    }

    public String getTruncateQuery(String table, Option<Object> cascade) {
        return new StringBuilder(15).append("TRUNCATE TABLE ").append(table).toString();
    }

    public Option<Object> getTruncateQuery$default$2() {
        return this.isCascadingTruncateTable();
    }

    public void beforeFetch(Connection connection, scala.collection.immutable.Map<String, String> properties) {
    }

    public String escapeSql(String value) {
        if (value == null) {
            return null;
        }
        return StringUtils.replace((String)value, (String)"'", (String)"''");
    }

    public Object compileValue(Object value2) {
        Object object = value2;
        if (object instanceof String) {
            String string = (String)object;
            return new StringBuilder(2).append("'").append(this.escapeSql(string)).append("'").toString();
        }
        if (object instanceof Timestamp) {
            Timestamp timestamp = (Timestamp)object;
            return new StringBuilder(2).append("'").append(timestamp).append("'").toString();
        }
        if (object instanceof Instant) {
            Instant instant = (Instant)object;
            TimestampFormatter timestampFormatter = TimestampFormatter$.MODULE$.getFractionFormatter(DateTimeUtils$.MODULE$.getZoneId(SQLConf$.MODULE$.get().sessionLocalTimeZone()));
            return new StringBuilder(2).append("'").append(timestampFormatter.format(instant)).append("'").toString();
        }
        if (object instanceof Date) {
            Date date = (Date)object;
            return new StringBuilder(2).append("'").append(date).append("'").toString();
        }
        if (object instanceof LocalDate) {
            LocalDate localDate = (LocalDate)object;
            return new StringBuilder(2).append("'").append(DateFormatter$.MODULE$.apply().format(localDate)).append("'").toString();
        }
        if (object instanceof Object[]) {
            Object[] objectArray = (Object[])object;
            return Predef$.MODULE$.genericArrayOps(Predef$.MODULE$.genericArrayOps((Object)objectArray).map((Function1 & Serializable & scala.Serializable)value -> this.compileValue(value), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Any()))).mkString(", ");
        }
        return value2;
    }

    public boolean isSupportedFunction(String funcName) {
        return false;
    }

    public Option<String> compileExpression(Expression expr) {
        Some some;
        JDBCSQLBuilder jdbcSQLBuilder = new JDBCSQLBuilder();
        try {
            some = new Some((Object)jdbcSQLBuilder.build(expr));
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable e = (Throwable)option.get();
                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Error occurs while compiling V2 expression", e);
                some = None$.MODULE$;
            }
            throw throwable;
        }
        return some;
    }

    public Option<String> compileAggregate(AggregateFunc aggFunction) {
        return this.compileExpression((Expression)aggFunction);
    }

    public Seq<Tuple2<String, UnboundFunction>> functions() {
        return Nil$.MODULE$;
    }

    public void createSchema(Statement statement, String schema, String comment) {
        String schemaCommentQuery = new StringOps(Predef$.MODULE$.augmentString(comment)).nonEmpty() ? this.getSchemaCommentQuery(schema, comment) : comment;
        statement.executeUpdate(new StringBuilder(14).append("CREATE SCHEMA ").append(this.quoteIdentifier(schema)).toString());
        if (new StringOps(Predef$.MODULE$.augmentString(comment)).nonEmpty()) {
            statement.executeUpdate(schemaCommentQuery);
            return;
        }
    }

    public boolean schemasExists(Connection conn, JDBCOptions options, String schema) {
        ResultSet rs = conn.getMetaData().getSchemas(null, schema);
        while (rs.next()) {
            String string = rs.getString(1);
            String string2 = schema;
            if (string != null ? !string.equals(string2) : string2 != null) continue;
            return true;
        }
        return false;
    }

    public String[][] listSchemas(Connection conn, JDBCOptions options) {
        ArrayBuilder schemaBuilder = ArrayBuilder$.MODULE$.make(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(String.class)));
        ResultSet rs = conn.getMetaData().getSchemas();
        while (rs.next()) {
            schemaBuilder.$plus$eq((Object)new String[]{rs.getString(1)});
        }
        return (String[][])schemaBuilder.result();
    }

    public Option<Object> isCascadingTruncateTable() {
        return None$.MODULE$;
    }

    public String renameTable(String oldTable, String newTable) {
        return new StringBuilder(23).append("ALTER TABLE ").append(oldTable).append(" RENAME TO ").append(newTable).toString();
    }

    public String[] alterTable(String tableName, Seq<TableChange> changes, int dbMajorVersion) {
        ArrayBuilder updateClause = ArrayBuilder$.MODULE$.make(ClassTag$.MODULE$.apply(String.class));
        changes.foreach((Function1 & Serializable & scala.Serializable)change -> {
            TableChange.UpdateColumnNullability updateColumnNullability;
            TableChange.UpdateColumnType updateColumnType;
            TableChange.DeleteColumn deleteColumn;
            TableChange.RenameColumn renameColumn;
            TableChange.AddColumn addColumn;
            TableChange tableChange = change;
            if (tableChange instanceof TableChange.AddColumn && (addColumn = (TableChange.AddColumn)tableChange).fieldNames().length == 1) {
                String dataType = JdbcUtils$.MODULE$.getJdbcType(addColumn.dataType(), this).databaseTypeDefinition();
                String[] name = addColumn.fieldNames();
                return (ArrayBuilder)updateClause.$plus$eq((Object)this.getAddColumnQuery(tableName, name[0], dataType));
            }
            if (tableChange instanceof TableChange.RenameColumn && (renameColumn = (TableChange.RenameColumn)tableChange).fieldNames().length == 1) {
                String[] name = renameColumn.fieldNames();
                return (ArrayBuilder)updateClause.$plus$eq((Object)this.getRenameColumnQuery(tableName, name[0], renameColumn.newName(), dbMajorVersion));
            }
            if (tableChange instanceof TableChange.DeleteColumn && (deleteColumn = (TableChange.DeleteColumn)tableChange).fieldNames().length == 1) {
                String[] name = deleteColumn.fieldNames();
                return (ArrayBuilder)updateClause.$plus$eq((Object)this.getDeleteColumnQuery(tableName, name[0]));
            }
            if (tableChange instanceof TableChange.UpdateColumnType && (updateColumnType = (TableChange.UpdateColumnType)tableChange).fieldNames().length == 1) {
                String[] name = updateColumnType.fieldNames();
                String dataType = JdbcUtils$.MODULE$.getJdbcType(updateColumnType.newDataType(), this).databaseTypeDefinition();
                return (ArrayBuilder)updateClause.$plus$eq((Object)this.getUpdateColumnTypeQuery(tableName, name[0], dataType));
            }
            if (tableChange instanceof TableChange.UpdateColumnNullability && (updateColumnNullability = (TableChange.UpdateColumnNullability)tableChange).fieldNames().length == 1) {
                String[] name = updateColumnNullability.fieldNames();
                return (ArrayBuilder)updateClause.$plus$eq((Object)this.getUpdateColumnNullabilityQuery(tableName, name[0], updateColumnNullability.nullable()));
            }
            throw QueryCompilationErrors$.MODULE$.unsupportedTableChangeInJDBCCatalogError(change);
        });
        return (String[])updateClause.result();
    }

    public String getAddColumnQuery(String tableName, String columnName, String dataType) {
        return new StringBuilder(25).append("ALTER TABLE ").append(tableName).append(" ADD COLUMN ").append(this.quoteIdentifier(columnName)).append(" ").append(dataType).toString();
    }

    public String getRenameColumnQuery(String tableName, String columnName, String newName, int dbMajorVersion) {
        return new StringBuilder(31).append("ALTER TABLE ").append(tableName).append(" RENAME COLUMN ").append(this.quoteIdentifier(columnName)).append(" TO").append(" ").append(this.quoteIdentifier(newName)).toString();
    }

    public String getDeleteColumnQuery(String tableName, String columnName) {
        return new StringBuilder(25).append("ALTER TABLE ").append(tableName).append(" DROP COLUMN ").append(this.quoteIdentifier(columnName)).toString();
    }

    public String getUpdateColumnTypeQuery(String tableName, String columnName, String newDataType) {
        return new StringBuilder(27).append("ALTER TABLE ").append(tableName).append(" ALTER COLUMN ").append(this.quoteIdentifier(columnName)).append(" ").append(newDataType).toString();
    }

    public String getUpdateColumnNullabilityQuery(String tableName, String columnName, boolean isNullable) {
        String nullable = isNullable ? "NULL" : "NOT NULL";
        return new StringBuilder(31).append("ALTER TABLE ").append(tableName).append(" ALTER COLUMN ").append(this.quoteIdentifier(columnName)).append(" SET ").append(nullable).toString();
    }

    public String getTableCommentQuery(String table, String comment) {
        return new StringBuilder(23).append("COMMENT ON TABLE ").append(table).append(" IS '").append(comment).append("'").toString();
    }

    public String getSchemaCommentQuery(String schema, String comment) {
        return new StringBuilder(24).append("COMMENT ON SCHEMA ").append(this.quoteIdentifier(schema)).append(" IS '").append(comment).append("'").toString();
    }

    public String removeSchemaCommentQuery(String schema) {
        return new StringBuilder(26).append("COMMENT ON SCHEMA ").append(this.quoteIdentifier(schema)).append(" IS NULL").toString();
    }

    public String dropSchema(String schema, boolean cascade) {
        if (cascade) {
            return new StringBuilder(20).append("DROP SCHEMA ").append(this.quoteIdentifier(schema)).append(" CASCADE").toString();
        }
        return new StringBuilder(12).append("DROP SCHEMA ").append(this.quoteIdentifier(schema)).toString();
    }

    public String createIndex(String indexName, Identifier tableIdent, NamedReference[] columns, Map<NamedReference, Map<String, String>> columnsProperties, Map<String, String> properties) {
        throw new UnsupportedOperationException("createIndex is not supported");
    }

    public boolean indexExists(Connection conn, String indexName, Identifier tableIdent, JDBCOptions options) {
        throw new UnsupportedOperationException("indexExists is not supported");
    }

    public String dropIndex(String indexName, Identifier tableIdent) {
        throw new UnsupportedOperationException("dropIndex is not supported");
    }

    public TableIndex[] listIndexes(Connection conn, Identifier tableIdent, JDBCOptions options) {
        throw new UnsupportedOperationException("listIndexes is not supported");
    }

    public AnalysisException classifyException(String message, Throwable e) {
        String x$1 = message;
        Some x$2 = new Some((Object)e);
        Option x$3 = AnalysisException$.MODULE$.$lessinit$greater$default$2();
        Option x$4 = AnalysisException$.MODULE$.$lessinit$greater$default$3();
        Option x$5 = AnalysisException$.MODULE$.$lessinit$greater$default$4();
        Option x$6 = AnalysisException$.MODULE$.$lessinit$greater$default$6();
        scala.collection.immutable.Map x$7 = AnalysisException$.MODULE$.$lessinit$greater$default$7();
        QueryContext[] x$8 = AnalysisException$.MODULE$.$lessinit$greater$default$8();
        return new AnalysisException(x$1, x$3, x$4, x$5, (Option)x$2, x$6, x$7, x$8);
    }

    public String getLimitClause(Integer limit) {
        if (Predef$.MODULE$.Integer2int(limit) > 0) {
            return new StringBuilder(6).append("LIMIT ").append(limit).toString();
        }
        return "";
    }

    public String getOffsetClause(Integer offset) {
        if (Predef$.MODULE$.Integer2int(offset) > 0) {
            return new StringBuilder(7).append("OFFSET ").append(offset).toString();
        }
        return "";
    }

    public boolean supportsTableSample() {
        return false;
    }

    public String getTableSample(TableSampleInfo sample) {
        throw new UnsupportedOperationException("TableSample is not supported by this data source");
    }

    public static final /* synthetic */ Connection $anonfun$createConnectionFactory$1(String driverClass$1, JDBCOptions options$1, int partitionId) {
        DriverRegistry$.MODULE$.register(driverClass$1);
        Driver driver = DriverRegistry$.MODULE$.get(driverClass$1);
        Connection connection = ConnectionProvider$.MODULE$.create(driver, (scala.collection.immutable.Map<String, String>)options$1.parameters(), options$1.connectionProviderName());
        Predef$.MODULE$.require(connection != null, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(60).append("The driver could not open a JDBC connection. Check the URL: ").append(options$1.url()).toString());
        return connection;
    }

    public JdbcDialect() {
        Logging.$init$((Logging)this);
    }

    public class JDBCSQLBuilder
    extends V2ExpressionSQLBuilder {
        private /* synthetic */ String super$visitLiteral(Literal x$1) {
            return super.visitLiteral(x$1);
        }

        public String visitLiteral(Literal<?> literal) {
            return (String)Option$.MODULE$.apply(literal.value()).map((Function1 & Serializable & scala.Serializable)v -> this.org$apache$spark$sql$jdbc$JdbcDialect$JDBCSQLBuilder$$$outer().compileValue(CatalystTypeConverters$.MODULE$.convertToScala(v, literal.dataType())).toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> this.super$visitLiteral(literal));
        }

        public String visitNamedReference(NamedReference namedRef) {
            if (namedRef.fieldNames().length > 1) {
                throw QueryCompilationErrors$.MODULE$.commandNotSupportNestedColumnError("Filter push down", namedRef.toString());
            }
            return this.org$apache$spark$sql$jdbc$JdbcDialect$JDBCSQLBuilder$$$outer().quoteIdentifier((String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])namedRef.fieldNames())).head());
        }

        public String visitCast(String l, DataType dataType) {
            String databaseTypeDefinition = (String)this.org$apache$spark$sql$jdbc$JdbcDialect$JDBCSQLBuilder$$$outer().getJDBCType(dataType).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.databaseTypeDefinition()).getOrElse((Function0 & Serializable & scala.Serializable)() -> dataType.typeName());
            return new StringBuilder(10).append("CAST(").append(l).append(" AS ").append(databaseTypeDefinition).append(")").toString();
        }

        public String visitSQLFunction(String funcName, String[] inputs) {
            if (this.org$apache$spark$sql$jdbc$JdbcDialect$JDBCSQLBuilder$$$outer().isSupportedFunction(funcName)) {
                return new StringBuilder(2).append(this.dialectFunctionName(funcName)).append("(").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])inputs)).mkString(", ")).append(")").toString();
            }
            throw new UnsupportedOperationException(new StringBuilder(28).append(this.getClass().getSimpleName()).append(" does not support function: ").append(funcName).toString());
        }

        public String visitAggregateFunction(String funcName, boolean isDistinct, String[] inputs) {
            if (this.org$apache$spark$sql$jdbc$JdbcDialect$JDBCSQLBuilder$$$outer().isSupportedFunction(funcName)) {
                return super.visitAggregateFunction(this.dialectFunctionName(funcName), isDistinct, inputs);
            }
            throw new UnsupportedOperationException(new StringBuilder(38).append(this.getClass().getSimpleName()).append(" does not support aggregate function: ").append(funcName).toString());
        }

        public String dialectFunctionName(String funcName) {
            return funcName;
        }

        public String visitOverlay(String[] inputs) {
            if (this.org$apache$spark$sql$jdbc$JdbcDialect$JDBCSQLBuilder$$$outer().isSupportedFunction("OVERLAY")) {
                return super.visitOverlay(inputs);
            }
            throw new UnsupportedOperationException(new StringBuilder(35).append(this.getClass().getSimpleName()).append(" does not support function: OVERLAY").toString());
        }

        public String visitTrim(String direction, String[] inputs) {
            if (this.org$apache$spark$sql$jdbc$JdbcDialect$JDBCSQLBuilder$$$outer().isSupportedFunction("TRIM")) {
                return super.visitTrim(direction, inputs);
            }
            throw new UnsupportedOperationException(new StringBuilder(32).append(this.getClass().getSimpleName()).append(" does not support function: TRIM").toString());
        }

        public /* synthetic */ JdbcDialect org$apache$spark$sql$jdbc$JdbcDialect$JDBCSQLBuilder$$$outer() {
            return JdbcDialect.this;
        }

        public JDBCSQLBuilder() {
            if (JdbcDialect.this == null) {
                throw null;
            }
        }
    }
}

