/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming;

import java.io.Serializable;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkEnv$;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.rdd.BlockRDD;
import org.apache.spark.rdd.RDD;
import org.apache.spark.storage.BlockId;
import org.apache.spark.storage.StorageLevel$;
import org.apache.spark.storage.StreamBlockId;
import org.apache.spark.streaming.Duration;
import org.apache.spark.streaming.LocalStreamingContext;
import org.apache.spark.streaming.Seconds$;
import org.apache.spark.streaming.StreamingConf$;
import org.apache.spark.streaming.StreamingContext;
import org.apache.spark.streaming.TestServer;
import org.apache.spark.streaming.TestSuiteBase;
import org.apache.spark.streaming.Time;
import org.apache.spark.streaming.dstream.DStream;
import org.apache.spark.streaming.dstream.ReceiverInputDStream;
import org.apache.spark.streaming.rdd.WriteAheadLogBackedBlockRDD;
import org.apache.spark.streaming.receiver.BlockManagerBasedStoreResult;
import org.apache.spark.streaming.receiver.ReceivedBlockStoreResult;
import org.apache.spark.streaming.receiver.Receiver;
import org.apache.spark.streaming.receiver.WriteAheadLogBasedStoreResult;
import org.apache.spark.streaming.scheduler.ReceivedBlockInfo;
import org.apache.spark.streaming.util.WriteAheadLogRecordHandle;
import org.apache.spark.streaming.util.WriteAheadLogUtils$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.BeforeAndAfterEach;
import org.scalatest.Tag;
import org.scalatest.concurrent.PatienceConfiguration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Random$;

@ScalaSignature(bytes="\u0006\u0001y4Aa\u0002\u0005\u0001#!)Q\u0004\u0001C\u0001=!)\u0001\u0005\u0001C\u0005C!)Q\n\u0001C\u0005\u001d\")\u0001\f\u0001C\u00053\")a\r\u0001C\u0005O\"9!\u000fAI\u0001\n\u0013\u0019(!\u0007*fG\u0016Lg/\u001a:J]B,H\u000fR*ue\u0016\fWnU;ji\u0016T!!\u0003\u0006\u0002\u0013M$(/Z1nS:<'BA\u0006\r\u0003\u0015\u0019\b/\u0019:l\u0015\tia\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u001f\u0005\u0019qN]4\u0004\u0001M!\u0001A\u0005\f\u001b!\t\u0019B#D\u0001\u000b\u0013\t)\"BA\u0007Ta\u0006\u00148NR;o'VLG/\u001a\t\u0003/ai\u0011\u0001C\u0005\u00033!\u0011Q\u0002V3tiN+\u0018\u000e^3CCN,\u0007CA\f\u001c\u0013\ta\u0002BA\u000bM_\u000e\fGn\u0015;sK\u0006l\u0017N\\4D_:$X\r\u001f;\u0002\rqJg.\u001b;?)\u0005y\u0002CA\f\u0001\u00039!Xm\u001d;XSRDw.\u001e;X\u00032#\"A\t!\u0015\u0005\rJ\u0003C\u0001\u0013(\u001b\u0005)#\"\u0001\u0014\u0002\u000bM\u001c\u0017\r\\1\n\u0005!*#\u0001B+oSRDQA\u000b\u0002A\u0002-\nAAY8esB!A\u0005\f\u0018$\u0013\tiSEA\u0005Gk:\u001cG/[8ocA\u0012qf\u000e\t\u0004aM*T\"A\u0019\u000b\u0005IB\u0011a\u00023tiJ,\u0017-\\\u0005\u0003iE\u0012ACU3dK&4XM]%oaV$Hi\u0015;sK\u0006l\u0007C\u0001\u001c8\u0019\u0001!\u0011\u0002O\u0015\u0002\u0002\u0003\u0005)\u0011A\u001d\u0003\t}#\u0013gM\t\u0003uu\u0002\"\u0001J\u001e\n\u0005q*#a\u0002(pi\"Lgn\u001a\t\u0003IyJ!aP\u0013\u0003\u0007\u0005s\u0017\u0010C\u0003B\u0005\u0001\u0007!)A\u0002ng\u001e\u0004\"a\u0011&\u000f\u0005\u0011C\u0005CA#&\u001b\u00051%BA$\u0011\u0003\u0019a$o\\8u}%\u0011\u0011*J\u0001\u0007!J,G-\u001a4\n\u0005-c%AB*ue&twM\u0003\u0002JK\u0005YA/Z:u/&$\bnV!M)\tyu\u000b\u0006\u0002$!\")!f\u0001a\u0001#B!A\u0005\f*$a\t\u0019V\u000bE\u00021gQ\u0003\"AN+\u0005\u0013Y\u0003\u0016\u0011!A\u0001\u0006\u0003I$\u0001B0%cQBQ!Q\u0002A\u0002\t\u000bqA];o)\u0016\u001cH\u000fF\u0002$5~CQa\u0017\u0003A\u0002q\u000b\u0011\"\u001a8bE2,w+\u0011'\u0011\u0005\u0011j\u0016B\u00010&\u0005\u001d\u0011un\u001c7fC:DQA\u000b\u0003A\u0002\u0001\u0004B\u0001\n\u0017bGA\u0012!\r\u001a\t\u0004aM\u001a\u0007C\u0001\u001ce\t%)w,!A\u0001\u0002\u000b\u0005\u0011H\u0001\u0003`IE*\u0014aD2sK\u0006$XM\u00117pG.LeNZ8\u0015\u0007!t\u0007\u000f\u0005\u0002jY6\t!N\u0003\u0002l\u0011\u0005I1o\u00195fIVdWM]\u0005\u0003[*\u0014\u0011CU3dK&4X\r\u001a\"m_\u000e\\\u0017J\u001c4p\u0011\u0015yW\u00011\u0001]\u0003-9\u0018\u000e\u001e5X\u00032KeNZ8\t\u000fE,\u0001\u0013!a\u00019\u0006Y1M]3bi\u0016\u0014En\\2l\u0003e\u0019'/Z1uK\ncwnY6J]\u001a|G\u0005Z3gCVdG\u000f\n\u001a\u0016\u0003QT#\u0001X;,\u0003Y\u0004\"a\u001e?\u000e\u0003aT!!\u001f>\u0002\u0013Ut7\r[3dW\u0016$'BA>&\u0003)\tgN\\8uCRLwN\\\u0005\u0003{b\u0014\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0001")
public class ReceiverInputDStreamSuite
extends SparkFunSuite
implements TestSuiteBase,
LocalStreamingContext {
    private transient StreamingContext ssc;
    private transient boolean stopSparkContext;
    private String checkpointDir;
    private final SparkConf conf;
    private final PatienceConfiguration.Timeout eventuallyTimeout;
    private volatile boolean bitmap$0;

    @Override
    public /* synthetic */ void org$apache$spark$streaming$LocalStreamingContext$$super$afterEach() {
        TestSuiteBase.afterEach$(this);
    }

    @Override
    public void afterEach() {
        LocalStreamingContext.afterEach$(this);
    }

    @Override
    public void resetStreamingContext() {
        LocalStreamingContext.resetStreamingContext$(this);
    }

    @Override
    public /* synthetic */ void org$apache$spark$streaming$TestSuiteBase$$super$beforeEach() {
        BeforeAndAfterEach.beforeEach$((BeforeAndAfterEach)this);
    }

    @Override
    public /* synthetic */ void org$apache$spark$streaming$TestSuiteBase$$super$afterEach() {
        BeforeAndAfterEach.afterEach$((BeforeAndAfterEach)this);
    }

    @Override
    public String framework() {
        return TestSuiteBase.framework$(this);
    }

    @Override
    public String master() {
        return TestSuiteBase.master$(this);
    }

    @Override
    public Duration batchDuration() {
        return TestSuiteBase.batchDuration$(this);
    }

    @Override
    public int numInputPartitions() {
        return TestSuiteBase.numInputPartitions$(this);
    }

    @Override
    public int maxWaitTimeMillis() {
        return TestSuiteBase.maxWaitTimeMillis$(this);
    }

    @Override
    public boolean useManualClock() {
        return TestSuiteBase.useManualClock$(this);
    }

    @Override
    public boolean actuallyWait() {
        return TestSuiteBase.actuallyWait$(this);
    }

    @Override
    public void beforeFunction() {
        TestSuiteBase.beforeFunction$(this);
    }

    @Override
    public void afterFunction() {
        TestSuiteBase.afterFunction$(this);
    }

    @Override
    public void beforeEach() {
        TestSuiteBase.beforeEach$(this);
    }

    @Override
    public <R> R withStreamingContext(StreamingContext ssc, Function1<StreamingContext, R> block) {
        return (R)TestSuiteBase.withStreamingContext$(this, ssc, block);
    }

    @Override
    public <R> R withTestServer(TestServer testServer, Function1<TestServer, R> block) {
        return (R)TestSuiteBase.withTestServer$(this, testServer, block);
    }

    @Override
    public <U, V> StreamingContext setupStreams(Seq<Seq<U>> input, Function1<DStream<U>, DStream<V>> operation, int numPartitions, ClassTag<U> evidence$4, ClassTag<V> evidence$5) {
        return TestSuiteBase.setupStreams$(this, input, operation, numPartitions, evidence$4, evidence$5);
    }

    @Override
    public <U, V> int setupStreams$default$3() {
        return TestSuiteBase.setupStreams$default$3$(this);
    }

    @Override
    public <U, V, W> StreamingContext setupStreams(Seq<Seq<U>> input1, Seq<Seq<V>> input2, Function2<DStream<U>, DStream<V>, DStream<W>> operation, ClassTag<U> evidence$6, ClassTag<V> evidence$7, ClassTag<W> evidence$8) {
        return TestSuiteBase.setupStreams$(this, input1, input2, operation, evidence$6, evidence$7, evidence$8);
    }

    @Override
    public <V> Seq<Seq<V>> runStreams(StreamingContext ssc, int numBatches, int numExpectedOutput, Function0<BoxedUnit> preStop, ClassTag<V> evidence$9) {
        return TestSuiteBase.runStreams$(this, ssc, numBatches, numExpectedOutput, preStop, evidence$9);
    }

    @Override
    public <V> Function0<BoxedUnit> runStreams$default$4() {
        return TestSuiteBase.runStreams$default$4$(this);
    }

    @Override
    public <V> Seq<Seq<Seq<V>>> runStreamsWithPartitions(StreamingContext ssc, int numBatches, int numExpectedOutput, Function0<BoxedUnit> preStop, ClassTag<V> evidence$10) {
        return TestSuiteBase.runStreamsWithPartitions$(this, ssc, numBatches, numExpectedOutput, preStop, evidence$10);
    }

    @Override
    public <V> Function0<BoxedUnit> runStreamsWithPartitions$default$4() {
        return TestSuiteBase.runStreamsWithPartitions$default$4$(this);
    }

    @Override
    public <V> void verifyOutput(Seq<Seq<V>> output, Seq<Seq<V>> expectedOutput, boolean useSet, ClassTag<V> evidence$11) {
        TestSuiteBase.verifyOutput$(this, output, expectedOutput, useSet, evidence$11);
    }

    @Override
    public <U, V> void testOperation(Seq<Seq<U>> input, Function1<DStream<U>, DStream<V>> operation, Seq<Seq<V>> expectedOutput, boolean useSet, ClassTag<U> evidence$12, ClassTag<V> evidence$13) {
        TestSuiteBase.testOperation$(this, input, operation, expectedOutput, useSet, evidence$12, evidence$13);
    }

    @Override
    public <U, V> boolean testOperation$default$4() {
        return TestSuiteBase.testOperation$default$4$(this);
    }

    @Override
    public <U, V> void testOperation(Seq<Seq<U>> input, Function1<DStream<U>, DStream<V>> operation, Seq<Seq<V>> expectedOutput, int numBatches, boolean useSet, ClassTag<U> evidence$14, ClassTag<V> evidence$15) {
        TestSuiteBase.testOperation$(this, input, operation, expectedOutput, numBatches, useSet, evidence$14, evidence$15);
    }

    @Override
    public <U, V, W> void testOperation(Seq<Seq<U>> input1, Seq<Seq<V>> input2, Function2<DStream<U>, DStream<V>, DStream<W>> operation, Seq<Seq<W>> expectedOutput, boolean useSet, ClassTag<U> evidence$16, ClassTag<V> evidence$17, ClassTag<W> evidence$18) {
        TestSuiteBase.testOperation$(this, input1, input2, operation, expectedOutput, useSet, evidence$16, evidence$17, evidence$18);
    }

    @Override
    public <U, V, W> void testOperation(Seq<Seq<U>> input1, Seq<Seq<V>> input2, Function2<DStream<U>, DStream<V>, DStream<W>> operation, Seq<Seq<W>> expectedOutput, int numBatches, boolean useSet, ClassTag<U> evidence$19, ClassTag<V> evidence$20, ClassTag<W> evidence$21) {
        TestSuiteBase.testOperation$(this, input1, input2, operation, expectedOutput, numBatches, useSet, evidence$19, evidence$20, evidence$21);
    }

    @Override
    public StreamingContext ssc() {
        return this.ssc;
    }

    @Override
    public void ssc_$eq(StreamingContext x$1) {
        this.ssc = x$1;
    }

    @Override
    public boolean stopSparkContext() {
        return this.stopSparkContext;
    }

    @Override
    public void stopSparkContext_$eq(boolean x$1) {
        this.stopSparkContext = x$1;
    }

    private String checkpointDir$lzycompute() {
        ReceiverInputDStreamSuite receiverInputDStreamSuite = this;
        synchronized (receiverInputDStreamSuite) {
            if (!this.bitmap$0) {
                this.checkpointDir = TestSuiteBase.checkpointDir$(this);
                this.bitmap$0 = true;
            }
        }
        return this.checkpointDir;
    }

    @Override
    public String checkpointDir() {
        return !this.bitmap$0 ? this.checkpointDir$lzycompute() : this.checkpointDir;
    }

    @Override
    public SparkConf conf() {
        return this.conf;
    }

    @Override
    public PatienceConfiguration.Timeout eventuallyTimeout() {
        return this.eventuallyTimeout;
    }

    @Override
    public void org$apache$spark$streaming$TestSuiteBase$_setter_$conf_$eq(SparkConf x$1) {
        this.conf = x$1;
    }

    @Override
    public void org$apache$spark$streaming$TestSuiteBase$_setter_$eventuallyTimeout_$eq(PatienceConfiguration.Timeout x$1) {
        this.eventuallyTimeout = x$1;
    }

    private void testWithoutWAL(String msg, Function1<ReceiverInputDStream<?>, BoxedUnit> body) {
        this.test(new StringBuilder(21).append("Without WAL enabled: ").append(msg).toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.runTest(false, body), new Position("ReceiverInputDStreamSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 107));
    }

    private void testWithWAL(String msg, Function1<ReceiverInputDStream<?>, BoxedUnit> body) {
        this.test(new StringBuilder(18).append("With WAL enabled: ").append(msg).toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.runTest(true, body), new Position("ReceiverInputDStreamSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 113));
    }

    private void runTest(boolean enableWAL, Function1<ReceiverInputDStream<?>, BoxedUnit> body) {
        SparkConf conf = new SparkConf();
        conf.setMaster("local[4]").setAppName("ReceiverInputDStreamSuite");
        conf.set(StreamingConf$.MODULE$.RECEIVER_WAL_ENABLE_CONF_KEY().key(), ((Object)BoxesRunTime.boxToBoolean((boolean)enableWAL)).toString());
        Predef$.MODULE$.require(this.convertToEqualizer(BoxesRunTime.boxToBoolean((boolean)WriteAheadLogUtils$.MODULE$.enableReceiverLog(conf))).$eq$eq$eq((Object)BoxesRunTime.boxToBoolean((boolean)enableWAL), Equality$.MODULE$.default()));
        this.ssc_$eq(new StreamingContext(conf, Seconds$.MODULE$.apply(1L)));
        ReceiverInputDStream<Object> receiverStream = new ReceiverInputDStream<Object>(this){

            public Receiver<Object> getReceiver() {
                return null;
            }
        };
        this.withStreamingContext(this.ssc(), arg_0 -> ReceiverInputDStreamSuite.$anonfun$runTest$1$adapted(body, (ReceiverInputDStream)receiverStream, arg_0));
    }

    private ReceivedBlockInfo createBlockInfo(boolean withWALInfo, boolean createBlock) {
        StreamBlockId blockId = new StreamBlockId(0, Random$.MODULE$.nextLong());
        if (createBlock) {
            SparkEnv$.MODULE$.get().blockManager().putSingle((BlockId)blockId, (Object)BoxesRunTime.boxToInteger((int)1), StorageLevel$.MODULE$.MEMORY_ONLY(), true, ClassTag$.MODULE$.Int());
            Predef$.MODULE$.require(SparkEnv$.MODULE$.get().blockManager().master().contains((BlockId)blockId));
        }
        WriteAheadLogBasedStoreResult storeResult = withWALInfo ? new WriteAheadLogBasedStoreResult(blockId, (Option)None$.MODULE$, new WriteAheadLogRecordHandle(null){}) : new BlockManagerBasedStoreResult(blockId, (Option)None$.MODULE$);
        return new ReceivedBlockInfo(0, (Option)None$.MODULE$, (Option)None$.MODULE$, (ReceivedBlockStoreResult)storeResult);
    }

    private boolean createBlockInfo$default$2() {
        return true;
    }

    public static final /* synthetic */ void $anonfun$new$1(ReceiverInputDStreamSuite $this, ReceiverInputDStream receiverStream) {
        RDD rdd = receiverStream.createBlockRDD(new Time(0L), (Seq)Seq$.MODULE$.empty());
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(rdd instanceof BlockRDD, "rdd.isInstanceOf[org.apache.spark.rdd.BlockRDD[_]]", Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ReceiverInputDStreamSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 38));
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(rdd instanceof WriteAheadLogBackedBlockRDD, "rdd.isInstanceOf[org.apache.spark.streaming.rdd.WriteAheadLogBackedBlockRDD[_]]", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ReceiverInputDStreamSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 39));
        RDD $org_scalatest_assert_macro_left = rdd;
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty(), Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ReceiverInputDStreamSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 40));
    }

    public static final /* synthetic */ boolean $anonfun$new$5(StreamBlockId blockId) {
        return SparkEnv$.MODULE$.get().blockManager().master().contains((BlockId)blockId);
    }

    public static final /* synthetic */ void $anonfun$new$2(ReceiverInputDStreamSuite $this, ReceiverInputDStream receiverStream) {
        Seq blockInfos = (Seq)Seq$.MODULE$.fill(5, (Function0 & Serializable & scala.Serializable)() -> $this.createBlockInfo(false, $this.createBlockInfo$default$2()));
        Seq blockIds = (Seq)blockInfos.map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.blockId(), Seq$.MODULE$.canBuildFrom());
        Predef$.MODULE$.require(blockIds.forall((Function1 & Serializable & scala.Serializable)blockId -> BoxesRunTime.boxToBoolean((boolean)ReceiverInputDStreamSuite.$anonfun$new$5(blockId))));
        RDD rdd = receiverStream.createBlockRDD(new Time(0L), blockInfos);
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(rdd instanceof BlockRDD, "rdd.isInstanceOf[org.apache.spark.rdd.BlockRDD[_]]", Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ReceiverInputDStreamSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 51));
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(rdd instanceof WriteAheadLogBackedBlockRDD, "rdd.isInstanceOf[org.apache.spark.streaming.rdd.WriteAheadLogBackedBlockRDD[_]]", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ReceiverInputDStreamSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 52));
        BlockRDD blockRDD = (BlockRDD)rdd;
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])blockRDD.blockIds())).toSeq());
        Seq $org_scalatest_assert_macro_right = blockIds;
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ReceiverInputDStreamSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 54));
    }

    public static final /* synthetic */ boolean $anonfun$new$10(StreamBlockId blockId) {
        return SparkEnv$.MODULE$.get().blockManager().master().contains((BlockId)blockId);
    }

    public static final /* synthetic */ boolean $anonfun$new$11(StreamBlockId blockId) {
        return !SparkEnv$.MODULE$.get().blockManager().master().contains((BlockId)blockId);
    }

    public static final /* synthetic */ void $anonfun$new$6(ReceiverInputDStreamSuite $this, ReceiverInputDStream receiverStream) {
        Seq presentBlockInfos = (Seq)Seq$.MODULE$.fill(2, (Function0 & Serializable & scala.Serializable)() -> $this.createBlockInfo(false, true));
        Seq absentBlockInfos = (Seq)Seq$.MODULE$.fill(3, (Function0 & Serializable & scala.Serializable)() -> $this.createBlockInfo(false, false));
        Seq blockInfos = (Seq)presentBlockInfos.$plus$plus((GenTraversableOnce)absentBlockInfos, Seq$.MODULE$.canBuildFrom());
        Seq blockIds = (Seq)blockInfos.map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.blockId(), Seq$.MODULE$.canBuildFrom());
        Predef$.MODULE$.require(blockIds.exists((Function1 & Serializable & scala.Serializable)blockId -> BoxesRunTime.boxToBoolean((boolean)ReceiverInputDStreamSuite.$anonfun$new$10(blockId))));
        Predef$.MODULE$.require(blockIds.exists((Function1 & Serializable & scala.Serializable)blockId -> BoxesRunTime.boxToBoolean((boolean)ReceiverInputDStreamSuite.$anonfun$new$11(blockId))));
        RDD rdd = receiverStream.createBlockRDD(new Time(0L), blockInfos);
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(rdd instanceof BlockRDD, "rdd.isInstanceOf[org.apache.spark.rdd.BlockRDD[_]]", Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ReceiverInputDStreamSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 69));
        BlockRDD blockRDD = (BlockRDD)rdd;
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])blockRDD.blockIds())).toSeq());
        Seq $org_scalatest_assert_macro_right = (Seq)presentBlockInfos.map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.blockId(), Seq$.MODULE$.canBuildFrom());
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ReceiverInputDStreamSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 71));
    }

    public static final /* synthetic */ void $anonfun$new$13(ReceiverInputDStreamSuite $this, ReceiverInputDStream receiverStream) {
        RDD rdd = receiverStream.createBlockRDD(new Time(0L), (Seq)Seq$.MODULE$.empty());
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(rdd instanceof WriteAheadLogBackedBlockRDD, "rdd.isInstanceOf[org.apache.spark.streaming.rdd.WriteAheadLogBackedBlockRDD[_]]", Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ReceiverInputDStreamSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 77));
        RDD $org_scalatest_assert_macro_left = rdd;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty(), Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ReceiverInputDStreamSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 78));
    }

    public static final /* synthetic */ void $anonfun$new$14(ReceiverInputDStreamSuite $this, ReceiverInputDStream receiverStream) {
        Seq blockInfos = (Seq)Seq$.MODULE$.fill(5, (Function0 & Serializable & scala.Serializable)() -> $this.createBlockInfo(true, $this.createBlockInfo$default$2()));
        Seq blockIds = (Seq)blockInfos.map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.blockId(), Seq$.MODULE$.canBuildFrom());
        RDD rdd = receiverStream.createBlockRDD(new Time(0L), blockInfos);
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(rdd instanceof WriteAheadLogBackedBlockRDD, "rdd.isInstanceOf[org.apache.spark.streaming.rdd.WriteAheadLogBackedBlockRDD[_]]", Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ReceiverInputDStreamSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 87));
        WriteAheadLogBackedBlockRDD blockRDD = (WriteAheadLogBackedBlockRDD)rdd;
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])blockRDD.blockIds())).toSeq());
        Seq $org_scalatest_assert_macro_right = blockIds;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ReceiverInputDStreamSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 89));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = $this.convertToEqualizer(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])blockRDD.walRecordHandles())).toSeq());
        Seq $org_scalatest_assert_macro_right2 = (Seq)blockInfos.map((Function1 & Serializable & scala.Serializable)x$5 -> (WriteAheadLogRecordHandle)x$5.walRecordHandleOption().get(), Seq$.MODULE$.canBuildFrom());
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ReceiverInputDStreamSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 90));
    }

    public static final /* synthetic */ void $anonfun$new$18(ReceiverInputDStreamSuite $this, ReceiverInputDStream receiverStream) {
        Seq blockInfos1 = (Seq)Seq$.MODULE$.fill(2, (Function0 & Serializable & scala.Serializable)() -> $this.createBlockInfo(true, $this.createBlockInfo$default$2()));
        Seq blockInfos2 = (Seq)Seq$.MODULE$.fill(3, (Function0 & Serializable & scala.Serializable)() -> $this.createBlockInfo(false, $this.createBlockInfo$default$2()));
        Seq blockInfos = (Seq)blockInfos1.$plus$plus((GenTraversableOnce)blockInfos2, Seq$.MODULE$.canBuildFrom());
        Seq blockIds = (Seq)blockInfos.map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.blockId(), Seq$.MODULE$.canBuildFrom());
        RDD rdd = receiverStream.createBlockRDD(new Time(0L), blockInfos);
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(rdd instanceof BlockRDD, "rdd.isInstanceOf[org.apache.spark.rdd.BlockRDD[_]]", Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ReceiverInputDStreamSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 100));
        BlockRDD blockRDD = (BlockRDD)rdd;
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])blockRDD.blockIds())).toSeq());
        Seq $org_scalatest_assert_macro_right = blockIds;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ReceiverInputDStreamSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 102));
    }

    public ReceiverInputDStreamSuite() {
        TestSuiteBase.$init$(this);
        LocalStreamingContext.$init$(this);
        this.testWithoutWAL("createBlockRDD creates empty BlockRDD when no block info", (Function1 & Serializable & scala.Serializable)receiverStream -> {
            ReceiverInputDStreamSuite.$anonfun$new$1(this, receiverStream);
            return BoxedUnit.UNIT;
        });
        this.testWithoutWAL("createBlockRDD creates correct BlockRDD with block info", (Function1 & Serializable & scala.Serializable)receiverStream -> {
            ReceiverInputDStreamSuite.$anonfun$new$2(this, receiverStream);
            return BoxedUnit.UNIT;
        });
        this.testWithoutWAL("createBlockRDD filters non-existent blocks before creating BlockRDD", (Function1 & Serializable & scala.Serializable)receiverStream -> {
            ReceiverInputDStreamSuite.$anonfun$new$6(this, receiverStream);
            return BoxedUnit.UNIT;
        });
        this.testWithWAL("createBlockRDD creates empty WALBackedBlockRDD when no block info", (Function1 & Serializable & scala.Serializable)receiverStream -> {
            ReceiverInputDStreamSuite.$anonfun$new$13(this, receiverStream);
            return BoxedUnit.UNIT;
        });
        this.testWithWAL("createBlockRDD creates correct WALBackedBlockRDD with all block info having WAL info", (Function1 & Serializable & scala.Serializable)receiverStream -> {
            ReceiverInputDStreamSuite.$anonfun$new$14(this, receiverStream);
            return BoxedUnit.UNIT;
        });
        this.testWithWAL("createBlockRDD creates BlockRDD when some block info don't have WAL info", (Function1 & Serializable & scala.Serializable)receiverStream -> {
            ReceiverInputDStreamSuite.$anonfun$new$18(this, receiverStream);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ Object $anonfun$runTest$1$adapted(Function1 body$3, ReceiverInputDStream receiverStream$1, StreamingContext ssc) {
        body$3.apply((Object)receiverStream$1);
        return BoxedUnit.UNIT;
    }
}

