/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.rdd;

import java.io.File;
import java.io.Serializable;
import org.apache.spark.HashPartitioner;
import org.apache.spark.Partitioner;
import org.apache.spark.RDDCheckpointTester;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.apache.spark.streaming.State;
import org.apache.spark.streaming.Time;
import org.apache.spark.streaming.rdd.MapWithStateRDD;
import org.apache.spark.streaming.rdd.MapWithStateRDD$;
import org.apache.spark.streaming.rdd.MapWithStateRDDRecord;
import org.apache.spark.streaming.rdd.MapWithStateRDDRecord$;
import org.apache.spark.streaming.rdd.MapWithStateRDDSuite$;
import org.apache.spark.streaming.util.OpenHashMapBasedStateMap;
import org.apache.spark.streaming.util.StateMap;
import org.apache.spark.util.Utils$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.Function4;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Null$;
import scala.runtime.VolatileBooleanRef;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\tma\u0001\u0002\u000b\u0016\u0001\u0001BQA\f\u0001\u0005\u0002=BqA\r\u0001A\u0002\u0013%1\u0007C\u00048\u0001\u0001\u0007I\u0011\u0002\u001d\t\r\u0005\u0003\u0001\u0015)\u00035\u0011%\u0011\u0005\u00011AA\u0002\u0013%1\tC\u0005M\u0001\u0001\u0007\t\u0019!C\u0005\u001b\"Iq\n\u0001a\u0001\u0002\u0003\u0006K\u0001\u0012\u0005\u0006!\u0002!\t%\u0015\u0005\u0006%\u0002!\t%\u0015\u0005\u0006'\u0002!\te\r\u0005\u0006)\u0002!I!\u0016\u0005\n\u0003s\u0002\u0011\u0013!C\u0005\u0003wBq!a'\u0001\t\u0013\tijB\u0004\u0002\\VA\t!!8\u0007\rQ)\u0002\u0012AAp\u0011\u0019qs\u0002\"\u0001\u0002n\"I\u0011q^\bC\u0002\u0013%\u0011\u0011\u001f\u0005\t\u0005\u0013y\u0001\u0015!\u0003\u0002t\"I!1B\b\u0002\u0002\u0013%!Q\u0002\u0002\u0015\u001b\u0006\u0004x+\u001b;i'R\fG/\u001a*E\tN+\u0018\u000e^3\u000b\u0005Y9\u0012a\u0001:eI*\u0011\u0001$G\u0001\ngR\u0014X-Y7j]\u001eT!AG\u000e\u0002\u000bM\u0004\u0018M]6\u000b\u0005qi\u0012AB1qC\u000eDWMC\u0001\u001f\u0003\ry'oZ\u0002\u0001'\u0011\u0001\u0011%\n\u0015\u0011\u0005\t\u001aS\"A\r\n\u0005\u0011J\"!D*qCJ\\g)\u001e8Tk&$X\r\u0005\u0002#M%\u0011q%\u0007\u0002\u0014%\u0012#5\t[3dWB|\u0017N\u001c;UKN$XM\u001d\t\u0003S1j\u0011A\u000b\u0006\u0003Wu\t\u0011b]2bY\u0006$Xm\u001d;\n\u00055R#!\u0005\"fM>\u0014X-\u00118e\u0003\u001a$XM]!mY\u00061A(\u001b8jiz\"\u0012\u0001\r\t\u0003c\u0001i\u0011!F\u0001\u0003g\u000e,\u0012\u0001\u000e\t\u0003EUJ!AN\r\u0003\u0019M\u0003\u0018M]6D_:$X\r\u001f;\u0002\rM\u001cw\fJ3r)\tIt\b\u0005\u0002;{5\t1HC\u0001=\u0003\u0015\u00198-\u00197b\u0013\tq4H\u0001\u0003V]&$\bb\u0002!\u0004\u0003\u0003\u0005\r\u0001N\u0001\u0004q\u0012\n\u0014aA:dA\u0005i1\r[3dWB|\u0017N\u001c;ESJ,\u0012\u0001\u0012\t\u0003\u000b*k\u0011A\u0012\u0006\u0003\u000f\"\u000b!![8\u000b\u0003%\u000bAA[1wC&\u00111J\u0012\u0002\u0005\r&dW-A\tdQ\u0016\u001c7\u000e]8j]R$\u0015N]0%KF$\"!\u000f(\t\u000f\u00013\u0011\u0011!a\u0001\t\u0006q1\r[3dWB|\u0017N\u001c;ESJ\u0004\u0013!\u00032fM>\u0014X-\u00117m)\u0005I\u0014\u0001C1gi\u0016\u0014\u0018\t\u001c7\u0002\u0019M\u0004\u0018M]6D_:$X\r\u001f;\u0002\u001f\u0005\u001c8/\u001a:u\u001fB,'/\u0019;j_:,RAV/hU6$rbVA\u0001\u0003\u000b\tI\"!\u000f\u0002D\u0005%\u0014q\u000e\u000b\u00061><(0 \t\u0007ce[f-\u001b7\n\u0005i+\"aD'ba^KG\u000f[*uCR,'\u000b\u0012#\u0011\u0005qkF\u0002\u0001\u0003\u0006=.\u0011\ra\u0018\u0002\u0002\u0017F\u0011\u0001m\u0019\t\u0003u\u0005L!AY\u001e\u0003\u000f9{G\u000f[5oOB\u0011!\bZ\u0005\u0003Kn\u00121!\u00118z!\tav\rB\u0003i\u0017\t\u0007qLA\u0001W!\ta&\u000eB\u0003l\u0017\t\u0007qLA\u0001T!\taV\u000eB\u0003o\u0017\t\u0007qLA\u0001U\u0011\u001d\u00018\"!AA\u0004E\f!\"\u001a<jI\u0016t7-\u001a\u00132!\r\u0011XoW\u0007\u0002g*\u0011AoO\u0001\be\u00164G.Z2u\u0013\t18O\u0001\u0005DY\u0006\u001c8\u000fV1h\u0011\u001dA8\"!AA\u0004e\f!\"\u001a<jI\u0016t7-\u001a\u00133!\r\u0011XO\u001a\u0005\bw.\t\t\u0011q\u0001}\u0003))g/\u001b3f]\u000e,Ge\r\t\u0004eVL\u0007b\u0002@\f\u0003\u0003\u0005\u001da`\u0001\u000bKZLG-\u001a8dK\u0012\"\u0004c\u0001:vY\"1\u00111A\u0006A\u0002a\u000bA\u0002^3tiN#\u0018\r^3S\t\u0012Cq!a\u0002\f\u0001\u0004\tI!\u0001\u0006oK^$\u0015\r^1S\t\u0012\u0003b!a\u0003\u0002\u0010\u0005MQBAA\u0007\u0015\t1\u0012$\u0003\u0003\u0002\u0012\u00055!a\u0001*E\tB)!(!\u0006\\M&\u0019\u0011qC\u001e\u0003\rQ+\b\u000f\\33\u0011\u001d\tYb\u0003a\u0001\u0003;\tq\"\\1qa&twMR;oGRLwN\u001c\t\ru\u0005}\u00111E.\u0002,\u0005E\u0012qG\u0005\u0004\u0003CY$!\u0003$v]\u000e$\u0018n\u001c85!\u0011\t)#a\n\u000e\u0003]I1!!\u000b\u0018\u0005\u0011!\u0016.\\3\u0011\ti\niCZ\u0005\u0004\u0003_Y$AB(qi&|g\u000eE\u0003\u0002&\u0005M\u0012.C\u0002\u00026]\u0011Qa\u0015;bi\u0016\u0004BAOA\u0017Y\"9\u00111H\u0006A\u0002\u0005u\u0012aC2veJ,g\u000e\u001e+j[\u0016\u00042AOA \u0013\r\t\te\u000f\u0002\u0005\u0019>tw\rC\u0004\u0002F-\u0001\r!a\u0012\u0002\u001d\u0015D\b/Z2uK\u0012\u001cF/\u0019;fgB1\u0011\u0011JA,\u0003;rA!a\u0013\u0002TA\u0019\u0011QJ\u001e\u000e\u0005\u0005=#bAA)?\u00051AH]8pizJ1!!\u0016<\u0003\u0019\u0001&/\u001a3fM&!\u0011\u0011LA.\u0005\r\u0019V\r\u001e\u0006\u0004\u0003+Z\u0004c\u0002\u001e\u0002`mK\u00171M\u0005\u0004\u0003CZ$A\u0002+va2,7\u0007E\u0002;\u0003KJ1!a\u001a<\u0005\rIe\u000e\u001e\u0005\b\u0003WZ\u0001\u0019AA7\u0003I)\u0007\u0010]3di\u0016$W*\u00199qK\u0012$\u0015\r^1\u0011\u000b\u0005%\u0013q\u000b7\t\u0013\u0005E4\u0002%AA\u0002\u0005M\u0014A\u00033p\rVdGnU2b]B\u0019!(!\u001e\n\u0007\u0005]4HA\u0004C_>dW-\u00198\u00023\u0005\u001c8/\u001a:u\u001fB,'/\u0019;j_:$C-\u001a4bk2$HeN\u000b\u000b\u0003{\n\u0019*!&\u0002\u0018\u0006eUCAA@U\u0011\t\u0019(!!,\u0005\u0005\r\u0005\u0003BAC\u0003\u001fk!!a\"\u000b\t\u0005%\u00151R\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!$<\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003#\u000b9IA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016$QA\u0018\u0007C\u0002}#Q\u0001\u001b\u0007C\u0002}#Qa\u001b\u0007C\u0002}#QA\u001c\u0007C\u0002}\u000b\u0011\"Y:tKJ$(\u000b\u0012#\u0016\u0015\u0005}\u00151VA[\u0003\u007f\u000bI\r\u0006\u0005\u0002\"\u0006-\u0017\u0011[Al)%I\u00141UAW\u0003o\u000b\t\rC\u0005\u0002&6\t\t\u0011q\u0001\u0002(\u0006QQM^5eK:\u001cW\rJ\u001b\u0011\tI,\u0018\u0011\u0016\t\u00049\u0006-F!\u00020\u000e\u0005\u0004y\u0006\"CAX\u001b\u0005\u0005\t9AAY\u0003))g/\u001b3f]\u000e,GE\u000e\t\u0005eV\f\u0019\fE\u0002]\u0003k#Q\u0001[\u0007C\u0002}C\u0011\"!/\u000e\u0003\u0003\u0005\u001d!a/\u0002\u0015\u00154\u0018\u000eZ3oG\u0016$s\u0007\u0005\u0003sk\u0006u\u0006c\u0001/\u0002@\u0012)1.\u0004b\u0001?\"I\u00111Y\u0007\u0002\u0002\u0003\u000f\u0011QY\u0001\u000bKZLG-\u001a8dK\u0012B\u0004\u0003\u0002:v\u0003\u000f\u00042\u0001XAe\t\u0015qWB1\u0001`\u0011\u001d\ti-\u0004a\u0001\u0003\u001f\f\u0001b\u001d;bi\u0016\u0014F\t\u0012\t\u000bce\u000bI+a-\u0002>\u0006\u001d\u0007bBA#\u001b\u0001\u0007\u00111\u001b\t\u0007\u0003\u0013\n9&!6\u0011\u0013i\ny&!+\u0002>\u0006\r\u0004bBA6\u001b\u0001\u0007\u0011\u0011\u001c\t\u0007\u0003\u0013\n9&a2\u0002)5\u000b\u0007oV5uQN#\u0018\r^3S\t\u0012\u001bV/\u001b;f!\t\ttbE\u0003\u0010\u0003C\f9\u000fE\u0002;\u0003GL1!!:<\u0005\u0019\te.\u001f*fMB\u0019!(!;\n\u0007\u0005-8H\u0001\u0007TKJL\u0017\r\\5{C\ndW\r\u0006\u0002\u0002^\u0006\u0001Bo\\;dQ\u0016$7\u000b^1uK.+\u0017p]\u000b\u0003\u0003g\u0004b!!>\u0002\u0000\n\rQBAA|\u0015\u0011\tI0a?\u0002\u000f5,H/\u00192mK*\u0019\u0011Q`\u001e\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0003\u0002\u0005](aC!se\u0006L()\u001e4gKJ\u0004B!!\u0013\u0003\u0006%!!qAA.\u0005\u0019\u0019FO]5oO\u0006\tBo\\;dQ\u0016$7\u000b^1uK.+\u0017p\u001d\u0011\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0005\u001f\u0001BA!\u0005\u0003\u00185\u0011!1\u0003\u0006\u0004\u0005+A\u0015\u0001\u00027b]\u001eLAA!\u0007\u0003\u0014\t1qJ\u00196fGR\u0004")
public class MapWithStateRDDSuite
extends SparkFunSuite
implements RDDCheckpointTester {
    private SparkContext sc;
    private File checkpointDir;
    private final HashPartitioner partitioner;

    public <U> void testRDD(Function1<RDD<Object>, RDD<U>> op, boolean reliableCheckpoint, Function1<RDD<U>, Object> collectFunc, ClassTag<U> evidence$1) {
        RDDCheckpointTester.testRDD$((RDDCheckpointTester)this, op, (boolean)reliableCheckpoint, collectFunc, evidence$1);
    }

    public <U> Function1<RDD<U>, Object> testRDD$default$3() {
        return RDDCheckpointTester.testRDD$default$3$((RDDCheckpointTester)this);
    }

    public <U> void testRDDPartitions(Function1<RDD<Object>, RDD<U>> op, boolean reliableCheckpoint, Function1<RDD<U>, Object> collectFunc, ClassTag<U> evidence$2) {
        RDDCheckpointTester.testRDDPartitions$((RDDCheckpointTester)this, op, (boolean)reliableCheckpoint, collectFunc, evidence$2);
    }

    public <U> Function1<RDD<U>, Object> testRDDPartitions$default$3() {
        return RDDCheckpointTester.testRDDPartitions$default$3$((RDDCheckpointTester)this);
    }

    public <T> T serializeDeserialize(T obj) {
        return (T)RDDCheckpointTester.serializeDeserialize$((RDDCheckpointTester)this, obj);
    }

    public void checkpoint(RDD<?> rdd, boolean reliableCheckpoint) {
        RDDCheckpointTester.checkpoint$((RDDCheckpointTester)this, rdd, (boolean)reliableCheckpoint);
    }

    public void runTest(String name, boolean skipLocalCheckpoint, Function1<Object, BoxedUnit> body) {
        RDDCheckpointTester.runTest$((RDDCheckpointTester)this, (String)name, (boolean)skipLocalCheckpoint, body);
    }

    public boolean runTest$default$2() {
        return RDDCheckpointTester.runTest$default$2$((RDDCheckpointTester)this);
    }

    public RDD<Object> generateFatRDD() {
        return RDDCheckpointTester.generateFatRDD$((RDDCheckpointTester)this);
    }

    public RDD<Tuple2<Object, Object>> generateFatPairRDD() {
        return RDDCheckpointTester.generateFatPairRDD$((RDDCheckpointTester)this);
    }

    public HashPartitioner partitioner() {
        return this.partitioner;
    }

    public void org$apache$spark$RDDCheckpointTester$_setter_$partitioner_$eq(HashPartitioner x$1) {
        this.partitioner = x$1;
    }

    private SparkContext sc() {
        return this.sc;
    }

    private void sc_$eq(SparkContext x$1) {
        this.sc = x$1;
    }

    private File checkpointDir() {
        return this.checkpointDir;
    }

    private void checkpointDir_$eq(File x$1) {
        this.checkpointDir = x$1;
    }

    public void beforeAll() {
        super.beforeAll();
        this.sc_$eq(new SparkContext(new SparkConf().setMaster("local").setAppName("MapWithStateRDDSuite")));
        this.checkpointDir_$eq(Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2()));
        this.sc().setCheckpointDir(this.checkpointDir().toString());
    }

    public void afterAll() {
        try {
            if (this.sc() != null) {
                this.sc().stop();
            }
            Utils$.MODULE$.deleteRecursively(this.checkpointDir());
        }
        finally {
            super.afterAll();
        }
    }

    public SparkContext sparkContext() {
        return this.sc();
    }

    private <K, V, S, T> MapWithStateRDD<K, V, S, T> assertOperation(MapWithStateRDD<K, V, S, T> testStateRDD, RDD<Tuple2<K, V>> newDataRDD, Function4<Time, K, Option<V>, State<S>, Option<T>> mappingFunction, long currentTime, Set<Tuple3<K, S, Object>> expectedStates, Set<T> expectedMappedData, boolean doFullScan, ClassTag<K> evidence$1, ClassTag<V> evidence$2, ClassTag<S> evidence$3, ClassTag<T> evidence$4) {
        RDD rDD;
        Option option = newDataRDD.partitioner();
        Option option2 = testStateRDD.partitioner();
        if (option == null ? option2 != null : !option.equals(option2)) {
            RDD x$1 = newDataRDD;
            ClassTag<K> x$2 = evidence$1;
            ClassTag<V> x$3 = evidence$2;
            Null$ x$4 = RDD$.MODULE$.rddToPairRDDFunctions$default$4(x$1);
            rDD = RDD$.MODULE$.rddToPairRDDFunctions(x$1, x$2, x$3, null).partitionBy((Partitioner)testStateRDD.partitioner().get());
        } else {
            rDD = newDataRDD;
        }
        RDD partitionedNewDataRDD = rDD;
        MapWithStateRDD newStateRDD = new MapWithStateRDD(testStateRDD, newDataRDD, mappingFunction, new Time(currentTime), (Option)None$.MODULE$, evidence$1, evidence$2, evidence$3, evidence$4);
        if (doFullScan) {
            newStateRDD.setFullScan();
        }
        newStateRDD.persist().count();
        this.assertRDD(newStateRDD, expectedStates, expectedMappedData, evidence$1, evidence$2, evidence$3, evidence$4);
        return newStateRDD;
    }

    private <K, V, S, T> boolean assertOperation$default$7() {
        return false;
    }

    private <K, V, S, T> void assertRDD(MapWithStateRDD<K, V, S, T> stateRDD, Set<Tuple3<K, S, Object>> expectedStates, Set<T> expectedMappedData, ClassTag<K> evidence$5, ClassTag<V> evidence$6, ClassTag<S> evidence$7, ClassTag<T> evidence$8) {
        Set states = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])stateRDD.flatMap((Function1 & Serializable & scala.Serializable)x$4 -> x$4.stateMap().getAll(), ClassTag$.MODULE$.apply(Tuple3.class)).collect())).toSet();
        Set mappedData = Predef$.MODULE$.genericArrayOps(stateRDD.flatMap((Function1 & Serializable & scala.Serializable)x$5 -> x$5.mappedData(), evidence$8).collect()).toSet();
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(states);
        Set<Tuple3<K, S, Object>> $org_scalatest_assert_macro_right = expectedStates;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", $org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq($org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"states after mapWithState operation were not as expected", Prettifier$.MODULE$.default(), new Position("MapWithStateRDDSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 390));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(mappedData);
        Set<T> $org_scalatest_assert_macro_right2 = expectedMappedData;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", $org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq($org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"mapped data after mapWithState operation were not as expected", Prettifier$.MODULE$.default(), new Position("MapWithStateRDDSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 392));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final Option testFunc$1(Time t, String key, Option data, State state, VolatileBooleanRef functionCalled$1, long updatedTime$1, ArrayBuffer removedStates$1, ArrayBuffer timingOutStates$1) {
        String string;
        String string2;
        String string3;
        functionCalled$1.elem = true;
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToLong((long)t.milliseconds()));
        long $org_scalatest_assert_macro_right = updatedTime$1;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"mapping func called with wrong time", Prettifier$.MODULE$.default(), new Position("MapWithStateRDDSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 105));
        boolean bl = false;
        Some some = null;
        Option option = data;
        if (option instanceof Some) {
            bl = true;
            some = (Some)option;
            String string4 = (String)some.value();
            if ("noop".equals(string4)) {
                return None$.MODULE$;
            }
        }
        if (bl && "get-state".equals(string3 = (String)some.value())) {
            return new Some(state.getOption().getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> -1));
        }
        if (bl && "update-state".equals(string2 = (String)some.value())) {
            if (state.exists()) {
                state.update((Object)BoxesRunTime.boxToInteger((int)(BoxesRunTime.unboxToInt((Object)state.get()) + 1)));
                return None$.MODULE$;
            } else {
                state.update((Object)BoxesRunTime.boxToInteger((int)0));
            }
            return None$.MODULE$;
        }
        if (bl && "remove-state".equals(string = (String)some.value())) {
            removedStates$1.$plus$eq(state.get());
            state.remove();
            return None$.MODULE$;
        }
        if (!None$.MODULE$.equals(option)) throw this.fail("Unexpected test data", new Position("MapWithStateRDDSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 124));
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(state.isTimingOut(), "state.isTimingOut()", Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"State is not timing out when data = None", Prettifier$.MODULE$.default(), new Position("MapWithStateRDDSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 120));
        timingOutStates$1.$plus$eq(state.get());
        return None$.MODULE$;
    }

    private final void assertRecordUpdate$1(Iterable initStates, Iterable data2, Iterable expectedStates, Option timeoutThreshold, boolean removeTimedoutData, Iterable expectedOutput, Iterable expectedTimingOutStates, Iterable expectedRemovedStates, long initialTime$1, VolatileBooleanRef functionCalled$1, long updatedTime$1) {
        OpenHashMapBasedStateMap initialStateMap = new OpenHashMapBasedStateMap(ClassTag$.MODULE$.apply(String.class), ClassTag$.MODULE$.Int());
        initStates.foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)s -> initialStateMap.put((Object)"key", (Object)BoxesRunTime.boxToInteger((int)s), initialTime$1));
        functionCalled$1.elem = false;
        MapWithStateRDDRecord record = new MapWithStateRDDRecord((StateMap)initialStateMap, (Seq)Seq$.MODULE$.empty());
        Iterator dataIterator = ((IterableLike)data2.map((Function1 & Serializable & scala.Serializable)v -> new Tuple2((Object)"key", v), Iterable$.MODULE$.canBuildFrom())).iterator();
        ArrayBuffer removedStates = new ArrayBuffer();
        ArrayBuffer timingOutStates = new ArrayBuffer();
        MapWithStateRDDRecord updatedRecord = MapWithStateRDDRecord$.MODULE$.updateRecordWithData((Option)new Some((Object)record), dataIterator, (Function4 & Serializable & scala.Serializable)(t, key, data, state) -> this.testFunc$1((Time)t, (String)key, (Option)data, (State)state, functionCalled$1, updatedTime$1, removedStates, timingOutStates), new Time(updatedTime$1), timeoutThreshold, removeTimedoutData, ClassTag$.MODULE$.apply(String.class), ClassTag$.MODULE$.apply(String.class), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.Int());
        Iterator updatedStateData = updatedRecord.stateMap().getAll().map((Function1 & Serializable & scala.Serializable)x -> new Tuple2.mcIJ.sp(BoxesRunTime.unboxToInt((Object)x._2()), BoxesRunTime.unboxToLong((Object)x._3())));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(updatedStateData.toSet());
        Set $org_scalatest_assert_macro_right = expectedStates.toSet();
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"states do not match after updating the MapWithStateRDDRecord", Prettifier$.MODULE$.default(), new Position("MapWithStateRDDSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 133));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(updatedRecord.mappedData().toSet());
        Set $org_scalatest_assert_macro_right2 = expectedOutput.toSet();
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"mapped data do not match after updating the MapWithStateRDDRecord", Prettifier$.MODULE$.default(), new Position("MapWithStateRDDSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 136));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(timingOutStates.toSet());
        Set $org_scalatest_assert_macro_right3 = expectedTimingOutStates.toSet();
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"timing out states do not match those that were expected to do so while updating the MapWithStateRDDRecord", Prettifier$.MODULE$.default(), new Position("MapWithStateRDDSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 139));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(removedStates.toSet());
        Set $org_scalatest_assert_macro_right4 = expectedRemovedStates.toSet();
        Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"removed states do not match those that were expected to do so while updating the MapWithStateRDDRecord", Prettifier$.MODULE$.default(), new Position("MapWithStateRDDSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 142));
    }

    private static final Option assertRecordUpdate$default$4$1() {
        return None$.MODULE$;
    }

    private static final boolean assertRecordUpdate$default$5$1() {
        return false;
    }

    private static final Iterable assertRecordUpdate$default$6$1() {
        return Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
    }

    private static final Iterable assertRecordUpdate$default$7$1() {
        return Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
    }

    private static final Iterable assertRecordUpdate$default$8$1() {
        return Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
    }

    private final MapWithStateRDD testStateUpdates$1(MapWithStateRDD testStateRDD, Seq testData, Set expectedStates, int updateTime$1, MapWithStateRDD initStateRDD$1, Set initStateWthTime$1) {
        testStateRDD.persist().count();
        MapWithStateRDDSuite$.MODULE$.org$apache$spark$streaming$rdd$MapWithStateRDDSuite$$touchedStateKeys().clear();
        Function4 & Serializable & scala.Serializable mappingFunction = (Function4 & Serializable & scala.Serializable)(time, key, data, state) -> {
            int n;
            MapWithStateRDDSuite$.MODULE$.org$apache$spark$streaming$rdd$MapWithStateRDDSuite$$touchedStateKeys().$plus$eq(key);
            boolean bl = false;
            Some some = null;
            Option option = data;
            if (option instanceof Some) {
                bl = true;
                some = (Some)option;
                int n2 = BoxesRunTime.unboxToInt((Object)some.value());
                if (1 == n2) {
                    BoxedUnit boxedUnit;
                    if (state.exists()) {
                        state.update((Object)BoxesRunTime.boxToInteger((int)(BoxesRunTime.unboxToInt((Object)state.get()) + 1)));
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        state.update((Object)BoxesRunTime.boxToInteger((int)0));
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    BoxedUnit boxedUnit2 = boxedUnit;
                    return None$.MODULE$;
                }
            }
            if (bl && 2 == (n = BoxesRunTime.unboxToInt((Object)some.value()))) {
                state.remove();
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return None$.MODULE$;
            }
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return None$.MODULE$;
        };
        SparkContext qual$1 = this.sc();
        Seq x$1 = testData;
        int x$2 = qual$1.makeRDD$default$2();
        RDD newDataRDD = RDD$.MODULE$.rddToPairRDDFunctions(qual$1.makeRDD(x$1, x$2, ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.apply(String.class), ClassTag$.MODULE$.Int(), (Ordering)Ordering.String$.MODULE$).partitionBy((Partitioner)testStateRDD.partitioner().get());
        MapWithStateRDD newStateRDD = this.assertOperation(testStateRDD, newDataRDD, mappingFunction, updateTime$1, expectedStates, Predef$.MODULE$.Set().empty(), this.assertOperation$default$7(), ClassTag$.MODULE$.apply(String.class), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.Int());
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)MapWithStateRDDSuite$.MODULE$.org$apache$spark$streaming$rdd$MapWithStateRDDSuite$$touchedStateKeys().size()));
        int $org_scalatest_assert_macro_right = testData.size();
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"More number of keys are being touched than that is expected", Prettifier$.MODULE$.default(), new Position("MapWithStateRDDSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 252));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(MapWithStateRDDSuite$.MODULE$.org$apache$spark$streaming$rdd$MapWithStateRDDSuite$$touchedStateKeys().toSet());
        Iterable $org_scalatest_assert_macro_right2 = testData.toMap(Predef$.MODULE$.$conforms()).keys();
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"Keys not in the data are being touched unexpectedly", Prettifier$.MODULE$.default(), new Position("MapWithStateRDDSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 254));
        this.assertRDD(initStateRDD$1, initStateWthTime$1, Predef$.MODULE$.Set().empty(), ClassTag$.MODULE$.apply(String.class), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.Int());
        return newStateRDD;
    }

    private static final Set rddCollectFunc$1(RDD rdd) {
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])rdd.map((Function1 & Serializable & scala.Serializable)record -> new Tuple2((Object)record.stateMap().getAll().toList(), (Object)record.mappedData().toList()), ClassTag$.MODULE$.apply(Tuple2.class)).collect())).toSet();
    }

    private final MapWithStateRDD makeStateRDDWithLongLineageDataRDD$1(RDD longLineageRDD) {
        return MapWithStateRDD$.MODULE$.createFromPairRDD(longLineageRDD.map((Function1 & Serializable & scala.Serializable)x$1 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)x$1))), (Object)BoxesRunTime.boxToInteger((int)1)), ClassTag$.MODULE$.apply(Tuple2.class)), (Partitioner)this.partitioner(), new Time(0L), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.Int());
    }

    public static final /* synthetic */ None$ $anonfun$new$19(Time time, int key, Option value, State state) {
        return None$.MODULE$;
    }

    private final MapWithStateRDD makeStateRDDWithLongLineageParenttateRDD$1(RDD longLineageRDD) {
        MapWithStateRDD stateRDDWithLongLineage = this.makeStateRDDWithLongLineageDataRDD$1(longLineageRDD);
        return new MapWithStateRDD((RDD)stateRDDWithLongLineage, RDD$.MODULE$.rddToPairRDDFunctions(stateRDDWithLongLineage.sparkContext().emptyRDD(ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.Int(), (Ordering)Ordering.Int$.MODULE$).partitionBy((Partitioner)this.partitioner()), (Function4 & Serializable & scala.Serializable)(time, key, value, state) -> MapWithStateRDDSuite.$anonfun$new$19(time, BoxesRunTime.unboxToInt((Object)key), value, state), new Time(10L), (Option)None$.MODULE$, ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.Int());
    }

    public MapWithStateRDDSuite() {
        RDDCheckpointTester.$init$((RDDCheckpointTester)this);
        this.sc = null;
        this.test("creation from pair RDD", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Seq data = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)BoxesRunTime.boxToInteger((int)1), (Object)"1"), new Tuple2((Object)BoxesRunTime.boxToInteger((int)2), (Object)"2"), new Tuple2((Object)BoxesRunTime.boxToInteger((int)3), (Object)"3")}));
            HashPartitioner partitioner = new HashPartitioner(10);
            SparkContext qual$1 = this.sc();
            Seq x$1 = data;
            int x$2 = qual$1.parallelize$default$2();
            MapWithStateRDD rdd = MapWithStateRDD$.MODULE$.createFromPairRDD(qual$1.parallelize(x$1, x$2, ClassTag$.MODULE$.apply(Tuple2.class)), (Partitioner)partitioner, new Time(123L), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(String.class), ClassTag$.MODULE$.Int());
            this.assertRDD(rdd, ((TraversableOnce)data.map((Function1 & Serializable & scala.Serializable)x -> new Tuple3((Object)BoxesRunTime.boxToInteger((int)x._1$mcI$sp()), x._2(), (Object)BoxesRunTime.boxToInteger((int)123)), Seq$.MODULE$.canBuildFrom())).toSet(), Predef$.MODULE$.Set().empty(), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(String.class), ClassTag$.MODULE$.Int());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])rdd.partitions())).size()));
            int $org_scalatest_assert_macro_right = partitioner.numPartitions();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("MapWithStateRDDSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 65));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(rdd.partitioner());
            Some $org_scalatest_assert_macro_right2 = new Some((Object)partitioner);
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("MapWithStateRDDSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 67));
        }, new Position("MapWithStateRDDSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 59));
        this.test("updating state and generating mapped data in MapWithStateRDDRecord", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            long initialTime = 1000L;
            long updatedTime = 2000L;
            long thresholdTime = 1500L;
            VolatileBooleanRef functionCalled = VolatileBooleanRef.create((boolean)false);
            this.assertRecordUpdate$1((Iterable)Nil$.MODULE$, Option$.MODULE$.option2Iterable((Option)None$.MODULE$), (Iterable)Nil$.MODULE$, MapWithStateRDDSuite.assertRecordUpdate$default$4$1(), MapWithStateRDDSuite.assertRecordUpdate$default$5$1(), MapWithStateRDDSuite.assertRecordUpdate$default$6$1(), MapWithStateRDDSuite.assertRecordUpdate$default$7$1(), MapWithStateRDDSuite.assertRecordUpdate$default$8$1(), initialTime, functionCalled, updatedTime);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToBoolean((boolean)functionCalled.elem));
            boolean $org_scalatest_assert_macro_right = false;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("MapWithStateRDDSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 149));
            this.assertRecordUpdate$1((Iterable)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0})), Option$.MODULE$.option2Iterable((Option)None$.MODULE$), (Iterable)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcIJ.sp(0, initialTime)})), MapWithStateRDDSuite.assertRecordUpdate$default$4$1(), MapWithStateRDDSuite.assertRecordUpdate$default$5$1(), MapWithStateRDDSuite.assertRecordUpdate$default$6$1(), MapWithStateRDDSuite.assertRecordUpdate$default$7$1(), MapWithStateRDDSuite.assertRecordUpdate$default$8$1(), initialTime, functionCalled, updatedTime);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToBoolean((boolean)functionCalled.elem));
            boolean $org_scalatest_assert_macro_right2 = false;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("MapWithStateRDDSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 151));
            this.assertRecordUpdate$1((Iterable)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0})), (Iterable)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"noop"})), (Iterable)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcIJ.sp(0, initialTime)})), MapWithStateRDDSuite.assertRecordUpdate$default$4$1(), MapWithStateRDDSuite.assertRecordUpdate$default$5$1(), MapWithStateRDDSuite.assertRecordUpdate$default$6$1(), MapWithStateRDDSuite.assertRecordUpdate$default$7$1(), MapWithStateRDDSuite.assertRecordUpdate$default$8$1(), initialTime, functionCalled, updatedTime);
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(functionCalled.elem, "functionCalled", Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("MapWithStateRDDSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 156));
            this.assertRecordUpdate$1(Option$.MODULE$.option2Iterable((Option)None$.MODULE$), Option$.MODULE$.option2Iterable((Option)new Some((Object)"noop")), Option$.MODULE$.option2Iterable((Option)None$.MODULE$), MapWithStateRDDSuite.assertRecordUpdate$default$4$1(), MapWithStateRDDSuite.assertRecordUpdate$default$5$1(), MapWithStateRDDSuite.assertRecordUpdate$default$6$1(), MapWithStateRDDSuite.assertRecordUpdate$default$7$1(), MapWithStateRDDSuite.assertRecordUpdate$default$8$1(), initialTime, functionCalled, updatedTime);
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(functionCalled.elem, "functionCalled", Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("MapWithStateRDDSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 158));
            Iterable x$3 = Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
            Seq x$4 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"get-state"}));
            Iterable x$5 = Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
            Seq x$6 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{-1}));
            Option x$7 = MapWithStateRDDSuite.assertRecordUpdate$default$4$1();
            boolean x$8 = MapWithStateRDDSuite.assertRecordUpdate$default$5$1();
            Iterable x$9 = MapWithStateRDDSuite.assertRecordUpdate$default$7$1();
            Iterable x$10 = MapWithStateRDDSuite.assertRecordUpdate$default$8$1();
            this.assertRecordUpdate$1(x$3, (Iterable)x$4, x$5, x$7, x$8, (Iterable)x$6, x$9, x$10, initialTime, functionCalled, updatedTime);
            Seq x$11 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{123}));
            Seq x$12 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"get-state"}));
            Seq x$13 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcIJ.sp(123, initialTime)}));
            Seq x$14 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{123}));
            Option x$15 = MapWithStateRDDSuite.assertRecordUpdate$default$4$1();
            boolean x$16 = MapWithStateRDDSuite.assertRecordUpdate$default$5$1();
            Iterable x$17 = MapWithStateRDDSuite.assertRecordUpdate$default$7$1();
            Iterable x$18 = MapWithStateRDDSuite.assertRecordUpdate$default$8$1();
            this.assertRecordUpdate$1((Iterable)x$11, (Iterable)x$12, (Iterable)x$13, x$15, x$16, (Iterable)x$14, x$17, x$18, initialTime, functionCalled, updatedTime);
            this.assertRecordUpdate$1((Iterable)Nil$.MODULE$, (Iterable)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"update-state"})), (Iterable)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcIJ.sp(0, updatedTime)})), MapWithStateRDDSuite.assertRecordUpdate$default$4$1(), MapWithStateRDDSuite.assertRecordUpdate$default$5$1(), MapWithStateRDDSuite.assertRecordUpdate$default$6$1(), MapWithStateRDDSuite.assertRecordUpdate$default$7$1(), MapWithStateRDDSuite.assertRecordUpdate$default$8$1(), initialTime, functionCalled, updatedTime);
            this.assertRecordUpdate$1((Iterable)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0})), (Iterable)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"update-state"})), (Iterable)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcIJ.sp(1, updatedTime)})), MapWithStateRDDSuite.assertRecordUpdate$default$4$1(), MapWithStateRDDSuite.assertRecordUpdate$default$5$1(), MapWithStateRDDSuite.assertRecordUpdate$default$6$1(), MapWithStateRDDSuite.assertRecordUpdate$default$7$1(), MapWithStateRDDSuite.assertRecordUpdate$default$8$1(), initialTime, functionCalled, updatedTime);
            Seq x$19 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{345}));
            Seq x$20 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"remove-state"}));
            Nil$ x$21 = Nil$.MODULE$;
            Seq x$22 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{345}));
            Option x$23 = MapWithStateRDDSuite.assertRecordUpdate$default$4$1();
            boolean x$24 = MapWithStateRDDSuite.assertRecordUpdate$default$5$1();
            Iterable x$25 = MapWithStateRDDSuite.assertRecordUpdate$default$6$1();
            Iterable x$26 = MapWithStateRDDSuite.assertRecordUpdate$default$7$1();
            this.assertRecordUpdate$1((Iterable)x$19, (Iterable)x$20, (Iterable)x$21, x$23, x$24, x$25, x$26, (Iterable)x$22, initialTime, functionCalled, updatedTime);
            Seq x$27 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{123}));
            Nil$ x$28 = Nil$.MODULE$;
            Some x$29 = new Some((Object)BoxesRunTime.boxToLong((long)initialTime));
            boolean x$30 = true;
            Seq x$31 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcIJ.sp(123, initialTime)}));
            Nil$ x$32 = Nil$.MODULE$;
            Iterable x$33 = MapWithStateRDDSuite.assertRecordUpdate$default$6$1();
            Iterable x$34 = MapWithStateRDDSuite.assertRecordUpdate$default$8$1();
            this.assertRecordUpdate$1((Iterable)x$27, (Iterable)x$28, (Iterable)x$31, (Option)x$29, x$30, x$33, (Iterable)x$32, x$34, initialTime, functionCalled, updatedTime);
            Seq x$35 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{123}));
            Nil$ x$36 = Nil$.MODULE$;
            Some x$37 = new Some((Object)BoxesRunTime.boxToLong((long)(initialTime + 1L)));
            boolean x$38 = true;
            Nil$ x$39 = Nil$.MODULE$;
            Seq x$40 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{123}));
            Iterable x$41 = MapWithStateRDDSuite.assertRecordUpdate$default$6$1();
            Iterable x$42 = MapWithStateRDDSuite.assertRecordUpdate$default$8$1();
            this.assertRecordUpdate$1((Iterable)x$35, (Iterable)x$36, (Iterable)x$39, (Option)x$37, x$38, x$41, (Iterable)x$40, x$42, initialTime, functionCalled, updatedTime);
            Seq x$43 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{123}));
            Seq x$44 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"noop"}));
            Some x$45 = new Some((Object)BoxesRunTime.boxToLong((long)(initialTime + 1L)));
            boolean x$46 = true;
            Seq x$47 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcIJ.sp(123, updatedTime)}));
            Nil$ x$48 = Nil$.MODULE$;
            Iterable x$49 = MapWithStateRDDSuite.assertRecordUpdate$default$6$1();
            Iterable x$50 = MapWithStateRDDSuite.assertRecordUpdate$default$8$1();
            this.assertRecordUpdate$1((Iterable)x$43, (Iterable)x$44, (Iterable)x$47, (Option)x$45, x$46, x$49, (Iterable)x$48, x$50, initialTime, functionCalled, updatedTime);
            Seq x$51 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{123}));
            Seq x$52 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"remove-state"}));
            Some x$53 = new Some((Object)BoxesRunTime.boxToLong((long)(initialTime + 1L)));
            boolean x$54 = true;
            Nil$ x$55 = Nil$.MODULE$;
            Nil$ x$56 = Nil$.MODULE$;
            Seq x$57 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{123}));
            Iterable x$58 = MapWithStateRDDSuite.assertRecordUpdate$default$6$1();
            this.assertRecordUpdate$1((Iterable)x$51, (Iterable)x$52, (Iterable)x$55, (Option)x$53, x$54, x$58, (Iterable)x$56, (Iterable)x$57, initialTime, functionCalled, updatedTime);
            Seq x$59 = (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$);
            Seq x$60 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"noop"}));
            Some x$61 = new Some((Object)BoxesRunTime.boxToLong((long)(initialTime + 1L)));
            boolean x$62 = true;
            Nil$ x$63 = Nil$.MODULE$;
            Nil$ x$64 = Nil$.MODULE$;
            Iterable x$65 = MapWithStateRDDSuite.assertRecordUpdate$default$6$1();
            Iterable x$66 = MapWithStateRDDSuite.assertRecordUpdate$default$8$1();
            this.assertRecordUpdate$1((Iterable)x$59, (Iterable)x$60, (Iterable)x$63, (Option)x$61, x$62, x$65, (Iterable)x$64, x$66, initialTime, functionCalled, updatedTime);
        }, new Position("MapWithStateRDDSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 70));
        this.test("states generated by MapWithStateRDD", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Seq initStates = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"k1", (Object)BoxesRunTime.boxToInteger((int)0)), new Tuple2((Object)"k2", (Object)BoxesRunTime.boxToInteger((int)0))}));
            int initTime = 123;
            Set initStateWthTime = ((TraversableOnce)initStates.map((Function1 & Serializable & scala.Serializable)x -> new Tuple3(x._1(), (Object)BoxesRunTime.boxToInteger((int)x._2$mcI$sp()), (Object)BoxesRunTime.boxToInteger((int)initTime)), Seq$.MODULE$.canBuildFrom())).toSet();
            HashPartitioner partitioner = new HashPartitioner(2);
            SparkContext qual$2 = this.sc();
            Seq x$67 = initStates;
            int x$68 = qual$2.parallelize$default$2();
            MapWithStateRDD initStateRDD = (MapWithStateRDD)MapWithStateRDD$.MODULE$.createFromPairRDD(qual$2.parallelize(x$67, x$68, ClassTag$.MODULE$.apply(Tuple2.class)), (Partitioner)partitioner, new Time((long)initTime), ClassTag$.MODULE$.apply(String.class), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.Int()).persist();
            this.assertRDD(initStateRDD, initStateWthTime, Predef$.MODULE$.Set().empty(), ClassTag$.MODULE$.apply(String.class), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.Int());
            int updateTime = 345;
            this.testStateUpdates$1(initStateRDD, (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), initStateWthTime, updateTime, initStateRDD, initStateWthTime);
            this.testStateUpdates$1(initStateRDD, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"k1", (Object)BoxesRunTime.boxToInteger((int)0))})), initStateWthTime, updateTime, initStateRDD, initStateWthTime);
            this.testStateUpdates$1(initStateRDD, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"k3", (Object)BoxesRunTime.boxToInteger((int)0))})), initStateWthTime, updateTime, initStateRDD, initStateWthTime);
            MapWithStateRDD rdd1 = this.testStateUpdates$1(initStateRDD, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"k3", (Object)BoxesRunTime.boxToInteger((int)1))})), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)"k1", (Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToInteger((int)initTime)), new Tuple3((Object)"k2", (Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToInteger((int)initTime)), new Tuple3((Object)"k3", (Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToInteger((int)updateTime))})), updateTime, initStateRDD, initStateWthTime);
            MapWithStateRDD rdd2 = this.testStateUpdates$1(rdd1, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"k4", (Object)BoxesRunTime.boxToInteger((int)1))})), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)"k1", (Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToInteger((int)initTime)), new Tuple3((Object)"k2", (Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToInteger((int)initTime)), new Tuple3((Object)"k3", (Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToInteger((int)updateTime)), new Tuple3((Object)"k4", (Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToInteger((int)updateTime))})), updateTime, initStateRDD, initStateWthTime);
            MapWithStateRDD rdd3 = this.testStateUpdates$1(initStateRDD, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"k1", (Object)BoxesRunTime.boxToInteger((int)1))})), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)"k1", (Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)updateTime)), new Tuple3((Object)"k2", (Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToInteger((int)initTime))})), updateTime, initStateRDD, initStateWthTime);
            MapWithStateRDD rdd4 = this.testStateUpdates$1(rdd3, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"x", (Object)BoxesRunTime.boxToInteger((int)0)), new Tuple2((Object)"k2", (Object)BoxesRunTime.boxToInteger((int)1)), new Tuple2((Object)"k2", (Object)BoxesRunTime.boxToInteger((int)1)), new Tuple2((Object)"k3", (Object)BoxesRunTime.boxToInteger((int)1))})), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)"k1", (Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)updateTime)), new Tuple3((Object)"k2", (Object)BoxesRunTime.boxToInteger((int)2), (Object)BoxesRunTime.boxToInteger((int)updateTime)), new Tuple3((Object)"k3", (Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToInteger((int)updateTime))})), updateTime, initStateRDD, initStateWthTime);
            MapWithStateRDD rdd5 = this.testStateUpdates$1(rdd4, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"k3", (Object)BoxesRunTime.boxToInteger((int)1))})), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)"k1", (Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)updateTime)), new Tuple3((Object)"k2", (Object)BoxesRunTime.boxToInteger((int)2), (Object)BoxesRunTime.boxToInteger((int)updateTime)), new Tuple3((Object)"k3", (Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)updateTime))})), updateTime, initStateRDD, initStateWthTime);
            MapWithStateRDD rdd6 = this.testStateUpdates$1(initStateRDD, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"k1", (Object)BoxesRunTime.boxToInteger((int)2))})), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)"k2", (Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToInteger((int)initTime))})), updateTime, initStateRDD, initStateWthTime);
            MapWithStateRDD rdd7 = this.testStateUpdates$1(rdd6, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"k2", (Object)BoxesRunTime.boxToInteger((int)2)), new Tuple2((Object)"k0", (Object)BoxesRunTime.boxToInteger((int)2)), new Tuple2((Object)"k3", (Object)BoxesRunTime.boxToInteger((int)1))})), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)"k3", (Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToInteger((int)updateTime))})), updateTime, initStateRDD, initStateWthTime);
            MapWithStateRDD rdd8 = this.testStateUpdates$1(rdd7, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"k3", (Object)BoxesRunTime.boxToInteger((int)2))})), (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), updateTime, initStateRDD, initStateWthTime);
        }, new Position("MapWithStateRDDSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 200));
        this.test("checkpointing", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.testRDD((Function1 & Serializable & scala.Serializable)longLineageRDD -> this.makeStateRDDWithLongLineageDataRDD$1((RDD)longLineageRDD), true, (Function1 & Serializable & scala.Serializable)rdd -> MapWithStateRDDSuite.rddCollectFunc$1(rdd), ClassTag$.MODULE$.apply(MapWithStateRDDRecord.class));
            this.testRDDPartitions((Function1 & Serializable & scala.Serializable)longLineageRDD -> this.makeStateRDDWithLongLineageDataRDD$1((RDD)longLineageRDD), true, (Function1 & Serializable & scala.Serializable)rdd -> MapWithStateRDDSuite.rddCollectFunc$1(rdd), ClassTag$.MODULE$.apply(MapWithStateRDDRecord.class));
            this.testRDD((Function1 & Serializable & scala.Serializable)longLineageRDD -> this.makeStateRDDWithLongLineageParenttateRDD$1((RDD)longLineageRDD), true, (Function1 & Serializable & scala.Serializable)rdd -> MapWithStateRDDSuite.rddCollectFunc$1(rdd), ClassTag$.MODULE$.apply(MapWithStateRDDRecord.class));
            this.testRDDPartitions((Function1 & Serializable & scala.Serializable)longLineageRDD -> this.makeStateRDDWithLongLineageParenttateRDD$1((RDD)longLineageRDD), true, (Function1 & Serializable & scala.Serializable)rdd -> MapWithStateRDDSuite.rddCollectFunc$1(rdd), ClassTag$.MODULE$.apply(MapWithStateRDDRecord.class));
        }, new Position("MapWithStateRDDSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 300));
        this.test("checkpointing empty state RDD", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            MapWithStateRDD emptyStateRDD = MapWithStateRDD$.MODULE$.createFromPairRDD(this.sc().emptyRDD(ClassTag$.MODULE$.apply(Tuple2.class)), (Partitioner)new HashPartitioner(10), new Time(0L), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.Int());
            emptyStateRDD.checkpoint();
            Object[] $org_scalatest_assert_macro_left = Predef$.MODULE$.refArrayOps((Object[])emptyStateRDD.flatMap((Function1 & Serializable & scala.Serializable)x$2 -> x$2.stateMap().getAll(), ClassTag$.MODULE$.apply(Tuple3.class)).collect());
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)new ArrayOps.ofRef($org_scalatest_assert_macro_left), "isEmpty", new ArrayOps.ofRef($org_scalatest_assert_macro_left).isEmpty(), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("MapWithStateRDDSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 349));
            RDD cpRDD = this.sc().checkpointFile((String)emptyStateRDD.getCheckpointFile().get(), ClassTag$.MODULE$.apply(MapWithStateRDDRecord.class));
            Object[] $org_scalatest_assert_macro_left2 = Predef$.MODULE$.refArrayOps((Object[])cpRDD.flatMap((Function1 & Serializable & scala.Serializable)x$3 -> x$3.stateMap().getAll(), ClassTag$.MODULE$.apply(Tuple3.class)).collect());
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.unaryMacroBool((Object)new ArrayOps.ofRef($org_scalatest_assert_macro_left2), "isEmpty", new ArrayOps.ofRef($org_scalatest_assert_macro_left2).isEmpty(), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("MapWithStateRDDSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 352));
        }, new Position("MapWithStateRDDSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 345));
    }
}

