/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.http2;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.CompletionHandler;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import org.apache.coyote.Adapter;
import org.apache.coyote.ProtocolException;
import org.apache.coyote.Request;
import org.apache.coyote.http2.ByteUtil;
import org.apache.coyote.http2.FrameType;
import org.apache.coyote.http2.Http2UpgradeHandler;
import org.apache.coyote.http2.Stream;
import org.apache.coyote.http2.StreamException;
import org.apache.tomcat.util.http.MimeHeaders;
import org.apache.tomcat.util.net.SocketWrapperBase;

public class Http2AsyncUpgradeHandler
extends Http2UpgradeHandler {
    private static final ByteBuffer[] BYTEBUFFER_ARRAY = new ByteBuffer[0];
    private Throwable error = null;
    private IOException applicationIOE = null;
    private CompletionHandler<Long, Void> errorCompletion = new CompletionHandler<Long, Void>(){

        @Override
        public void completed(Long result, Void attachment) {
        }

        @Override
        public void failed(Throwable t, Void attachment) {
            Http2AsyncUpgradeHandler.this.error = t;
        }
    };
    private CompletionHandler<Long, Void> applicationErrorCompletion = new CompletionHandler<Long, Void>(){

        @Override
        public void completed(Long result, Void attachment) {
        }

        @Override
        public void failed(Throwable t, Void attachment) {
            if (t instanceof IOException) {
                Http2AsyncUpgradeHandler.this.applicationIOE = (IOException)t;
            }
            Http2AsyncUpgradeHandler.this.error = t;
        }
    };

    public Http2AsyncUpgradeHandler(Adapter adapter, Request coyoteRequest) {
        super(adapter, coyoteRequest);
    }

    @Override
    protected Http2UpgradeHandler.PingManager getPingManager() {
        return new AsyncPingManager();
    }

    @Override
    protected void writeSettings() {
        this.socketWrapper.write(SocketWrapperBase.BlockingMode.SEMI_BLOCK, this.getWriteTimeout(), TimeUnit.MILLISECONDS, null, SocketWrapperBase.COMPLETE_WRITE, this.errorCompletion, ByteBuffer.wrap(this.localSettings.getSettingsFrameForPending()));
        if (this.error != null) {
            String msg = sm.getString("upgradeHandler.sendPrefaceFail", new Object[]{this.connectionId});
            if (log.isDebugEnabled()) {
                log.debug((Object)msg);
            }
            throw new ProtocolException(msg, this.error);
        }
    }

    @Override
    void sendStreamReset(StreamException se) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)sm.getString("upgradeHandler.rst.debug", new Object[]{this.connectionId, Integer.toString(se.getStreamId()), se.getError()}));
        }
        byte[] rstFrame = new byte[13];
        ByteUtil.setThreeBytes(rstFrame, 0, 4);
        rstFrame[3] = FrameType.RST.getIdByte();
        ByteUtil.set31Bits(rstFrame, 5, se.getStreamId());
        ByteUtil.setFourBytes(rstFrame, 9, se.getError().getCode());
        this.socketWrapper.write(SocketWrapperBase.BlockingMode.SEMI_BLOCK, this.getWriteTimeout(), TimeUnit.MILLISECONDS, null, SocketWrapperBase.COMPLETE_WRITE, this.errorCompletion, ByteBuffer.wrap(rstFrame));
        this.handleAsyncException();
    }

    @Override
    protected void writeGoAwayFrame(int maxStreamId, long errorCode, byte[] debugMsg) throws IOException {
        byte[] fixedPayload = new byte[8];
        ByteUtil.set31Bits(fixedPayload, 0, maxStreamId);
        ByteUtil.setFourBytes(fixedPayload, 4, errorCode);
        int len = 8;
        if (debugMsg != null) {
            len += debugMsg.length;
        }
        byte[] payloadLength = new byte[3];
        ByteUtil.setThreeBytes(payloadLength, 0, len);
        if (debugMsg != null) {
            this.socketWrapper.write(SocketWrapperBase.BlockingMode.SEMI_BLOCK, this.getWriteTimeout(), TimeUnit.MILLISECONDS, null, SocketWrapperBase.COMPLETE_WRITE, this.errorCompletion, ByteBuffer.wrap(payloadLength), ByteBuffer.wrap(GOAWAY), ByteBuffer.wrap(fixedPayload), ByteBuffer.wrap(debugMsg));
        } else {
            this.socketWrapper.write(SocketWrapperBase.BlockingMode.SEMI_BLOCK, this.getWriteTimeout(), TimeUnit.MILLISECONDS, null, SocketWrapperBase.COMPLETE_WRITE, this.errorCompletion, ByteBuffer.wrap(payloadLength), ByteBuffer.wrap(GOAWAY), ByteBuffer.wrap(fixedPayload));
        }
        this.handleAsyncException();
    }

    @Override
    void writeHeaders(Stream stream, int pushedStreamId, MimeHeaders mimeHeaders, boolean endOfStream, int payloadSize) throws IOException {
        this.doWriteHeaders(stream, pushedStreamId, mimeHeaders, endOfStream, payloadSize);
    }

    @Override
    protected Http2UpgradeHandler.HeaderFrameBuffers getHeaderFrameBuffers(int initialPayloadSize) {
        return new AsyncHeaderFrameBuffers(initialPayloadSize);
    }

    @Override
    void writeBody(Stream stream, ByteBuffer data, int len, boolean finished) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)sm.getString("upgradeHandler.writeBody", new Object[]{this.connectionId, stream.getIdentifier(), Integer.toString(len)}));
        }
        boolean writeable = stream.canWrite();
        byte[] header = new byte[9];
        ByteUtil.setThreeBytes(header, 0, len);
        header[3] = FrameType.DATA.getIdByte();
        if (finished) {
            header[4] = 1;
            stream.sentEndOfStream();
            if (!stream.isActive()) {
                this.activeRemoteStreamCount.decrementAndGet();
            }
        }
        if (writeable) {
            ByteUtil.set31Bits(header, 5, stream.getIdentifier());
            int orgLimit = data.limit();
            data.limit(data.position() + len);
            this.socketWrapper.write(SocketWrapperBase.BlockingMode.BLOCK, this.getWriteTimeout(), TimeUnit.MILLISECONDS, null, SocketWrapperBase.COMPLETE_WRITE, this.applicationErrorCompletion, ByteBuffer.wrap(header), data);
            data.limit(orgLimit);
            this.handleAsyncException();
        }
    }

    @Override
    void writeWindowUpdate(Stream stream, int increment, boolean applicationInitiated) throws IOException {
        if (!stream.canWrite()) {
            return;
        }
        byte[] frame = new byte[13];
        ByteUtil.setThreeBytes(frame, 0, 4);
        frame[3] = FrameType.WINDOW_UPDATE.getIdByte();
        ByteUtil.set31Bits(frame, 9, increment);
        byte[] frame2 = new byte[13];
        ByteUtil.setThreeBytes(frame2, 0, 4);
        frame2[3] = FrameType.WINDOW_UPDATE.getIdByte();
        ByteUtil.set31Bits(frame2, 9, increment);
        ByteUtil.set31Bits(frame2, 5, stream.getIdentifier());
        this.socketWrapper.write(SocketWrapperBase.BlockingMode.SEMI_BLOCK, this.getWriteTimeout(), TimeUnit.MILLISECONDS, null, SocketWrapperBase.COMPLETE_WRITE, this.errorCompletion, ByteBuffer.wrap(frame), ByteBuffer.wrap(frame2));
        this.handleAsyncException();
    }

    @Override
    public void settingsEnd(boolean ack) throws IOException {
        if (ack) {
            if (!this.localSettings.ack()) {
                log.warn((Object)sm.getString("upgradeHandler.unexpectedAck", new Object[]{this.connectionId, this.getIdentifier()}));
            }
        } else {
            this.socketWrapper.write(SocketWrapperBase.BlockingMode.SEMI_BLOCK, this.getWriteTimeout(), TimeUnit.MILLISECONDS, null, SocketWrapperBase.COMPLETE_WRITE, this.errorCompletion, ByteBuffer.wrap(SETTINGS_ACK));
        }
        this.handleAsyncException();
    }

    protected void handleAsyncException() throws IOException {
        if (this.applicationIOE != null) {
            this.handleAppInitiatedIOException(this.applicationIOE);
        } else if (this.error != null) {
            throw new IOException(this.error);
        }
    }

    private class AsyncHeaderFrameBuffers
    implements Http2UpgradeHandler.HeaderFrameBuffers {
        int payloadSize;
        private byte[] header;
        private ByteBuffer payload;
        private final ArrayList<ByteBuffer> bufs = new ArrayList();

        public AsyncHeaderFrameBuffers(int initialPayloadSize) {
            this.payloadSize = initialPayloadSize;
        }

        @Override
        public void startFrame() {
            this.header = new byte[9];
            this.payload = ByteBuffer.allocate(this.payloadSize);
        }

        @Override
        public void endFrame() throws IOException {
            this.bufs.add(ByteBuffer.wrap(this.header));
            this.bufs.add(this.payload);
        }

        @Override
        public void endHeaders() throws IOException {
            Http2AsyncUpgradeHandler.this.socketWrapper.write(SocketWrapperBase.BlockingMode.SEMI_BLOCK, Http2AsyncUpgradeHandler.this.getWriteTimeout(), TimeUnit.MILLISECONDS, null, SocketWrapperBase.COMPLETE_WRITE, Http2AsyncUpgradeHandler.this.applicationErrorCompletion, this.bufs.toArray(BYTEBUFFER_ARRAY));
            Http2AsyncUpgradeHandler.this.handleAsyncException();
        }

        @Override
        public byte[] getHeader() {
            return this.header;
        }

        @Override
        public ByteBuffer getPayload() {
            return this.payload;
        }

        @Override
        public void expandPayload() {
            this.payloadSize *= 2;
        }
    }

    protected class AsyncPingManager
    extends Http2UpgradeHandler.PingManager {
        protected AsyncPingManager() {
            super(Http2AsyncUpgradeHandler.this);
        }

        @Override
        public void sendPing(boolean force) throws IOException {
            if (this.initiateDisabled) {
                return;
            }
            long now = System.nanoTime();
            if (force || now - this.lastPingNanoTime > 10000000000L) {
                this.lastPingNanoTime = now;
                byte[] payload = new byte[8];
                int sentSequence = ++this.sequence;
                Http2UpgradeHandler.PingRecord pingRecord = new Http2UpgradeHandler.PingRecord(sentSequence, now);
                this.inflightPings.add(pingRecord);
                ByteUtil.set31Bits(payload, 4, sentSequence);
                Http2AsyncUpgradeHandler.this.socketWrapper.write(SocketWrapperBase.BlockingMode.SEMI_BLOCK, Http2AsyncUpgradeHandler.this.getWriteTimeout(), TimeUnit.MILLISECONDS, null, SocketWrapperBase.COMPLETE_WRITE, Http2AsyncUpgradeHandler.this.errorCompletion, ByteBuffer.wrap(Http2UpgradeHandler.PING), ByteBuffer.wrap(payload));
                Http2AsyncUpgradeHandler.this.handleAsyncException();
            }
        }

        @Override
        public void receivePing(byte[] payload, boolean ack) throws IOException {
            if (ack) {
                super.receivePing(payload, ack);
            } else {
                Http2AsyncUpgradeHandler.this.socketWrapper.write(SocketWrapperBase.BlockingMode.SEMI_BLOCK, Http2AsyncUpgradeHandler.this.getWriteTimeout(), TimeUnit.MILLISECONDS, null, SocketWrapperBase.COMPLETE_WRITE, Http2AsyncUpgradeHandler.this.errorCompletion, ByteBuffer.wrap(Http2UpgradeHandler.PING_ACK), ByteBuffer.wrap(payload));
                Http2AsyncUpgradeHandler.this.handleAsyncException();
            }
        }
    }
}

