/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow;

import java.util.LinkedHashMap;
import java.util.stream.Stream;
import javax.servlet.http.HttpServletRequest;
import org.apereo.cas.util.EncodingUtils;
import org.springframework.webflow.context.servlet.DefaultFlowUrlHandler;
import org.springframework.webflow.core.collection.AttributeMap;

public class CasDefaultFlowUrlHandler
extends DefaultFlowUrlHandler {
    public static final String DEFAULT_FLOW_EXECUTION_KEY_PARAMETER = "execution";
    private String flowExecutionKeyParameter = "execution";

    public void setFlowExecutionKeyParameter(String parameterName) {
        this.flowExecutionKeyParameter = parameterName;
    }

    public String getFlowExecutionKey(HttpServletRequest request) {
        return request.getParameter(this.flowExecutionKeyParameter);
    }

    public String createFlowExecutionUrl(String flowId, String flowExecutionKey, HttpServletRequest request) {
        String encoding = this.getEncodingScheme(request);
        StringBuilder builder = new StringBuilder(request.getRequestURI()).append('?');
        LinkedHashMap<String, String[]> flowParams = new LinkedHashMap<String, String[]>(request.getParameterMap());
        flowParams.put(this.flowExecutionKeyParameter, new String[]{flowExecutionKey});
        String queryString = flowParams.entrySet().stream().flatMap(entry -> CasDefaultFlowUrlHandler.encodeMultiParameter((String)entry.getKey(), (String[])entry.getValue(), encoding)).reduce((param1, param2) -> param1 + '&' + param2).orElse("");
        builder.append(queryString);
        return builder.toString();
    }

    public String createFlowDefinitionUrl(String flowId, AttributeMap input, HttpServletRequest request) {
        return request.getRequestURI() + (request.getQueryString() != null ? '?' + request.getQueryString() : "");
    }

    private static Stream<String> encodeMultiParameter(String key, String[] values, String encoding) {
        return Stream.of(values).map(value -> CasDefaultFlowUrlHandler.encodeSingleParameter(key, value, encoding));
    }

    private static String encodeSingleParameter(String key, String value, String encoding) {
        return EncodingUtils.urlEncode((String)key, (String)encoding) + '=' + EncodingUtils.urlEncode((String)value, (String)encoding);
    }
}

