/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow;

import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.CentralAuthenticationService;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.web.support.CookieRetrievingCookieGenerator;
import org.apereo.cas.web.support.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.action.AbstractAction;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class SendTicketGrantingTicketAction
extends AbstractAction {
    private static final Logger LOGGER = LoggerFactory.getLogger(SendTicketGrantingTicketAction.class);
    private boolean createSsoSessionCookieOnRenewAuthentications = true;
    private CookieRetrievingCookieGenerator ticketGrantingTicketCookieGenerator;
    private CentralAuthenticationService centralAuthenticationService;
    private ServicesManager servicesManager;

    public SendTicketGrantingTicketAction(CentralAuthenticationService centralAuthenticationService, ServicesManager servicesManager, CookieRetrievingCookieGenerator ticketGrantingTicketCookieGenerator, boolean renewedAuthn) {
        this.centralAuthenticationService = centralAuthenticationService;
        this.servicesManager = servicesManager;
        this.ticketGrantingTicketCookieGenerator = ticketGrantingTicketCookieGenerator;
        this.createSsoSessionCookieOnRenewAuthentications = renewedAuthn;
    }

    protected Event doExecute(RequestContext context) {
        String ticketGrantingTicketId = WebUtils.getTicketGrantingTicketId((RequestContext)context);
        String ticketGrantingTicketValueFromCookie = (String)context.getFlowScope().get("ticketGrantingTicketId");
        if (StringUtils.isBlank((CharSequence)ticketGrantingTicketId)) {
            LOGGER.debug("No ticket-granting ticket is found in the context.");
            return this.success();
        }
        if (WebUtils.isAuthenticatingAtPublicWorkstation((RequestContext)context)) {
            LOGGER.info("Authentication is at a public workstation. SSO cookie will not be generated. Requests will be challenged for authentication.");
        } else if (!this.createSsoSessionCookieOnRenewAuthentications && this.isAuthenticationRenewed(context)) {
            LOGGER.info("Authentication session is renewed but CAS is not configured to create the SSO session. SSO cookie will not be generated. Subsequent requests will be challenged for credentials.");
        } else {
            LOGGER.debug("Setting TGC for current session linked to [{}].", (Object)ticketGrantingTicketId);
            this.ticketGrantingTicketCookieGenerator.addCookie(context, ticketGrantingTicketId);
        }
        if (ticketGrantingTicketValueFromCookie != null && !ticketGrantingTicketId.equals(ticketGrantingTicketValueFromCookie)) {
            LOGGER.debug("Ticket-granting ticket from TGC does not match the ticket-granting ticket from context");
            this.centralAuthenticationService.destroyTicketGrantingTicket(ticketGrantingTicketValueFromCookie);
        }
        return this.success();
    }

    private boolean isAuthenticationRenewed(RequestContext ctx) {
        RegisteredService registeredService;
        if (ctx.getRequestParameters().contains("renew")) {
            LOGGER.debug("[{}] is specified for the request. The authentication session will be considered renewed.", (Object)"renew");
            return true;
        }
        WebApplicationService service = WebUtils.getService((RequestContext)ctx);
        if (service != null && (registeredService = this.servicesManager.findServiceBy((Service)service)) != null) {
            boolean isAllowedForSso = registeredService.getAccessStrategy().isServiceAccessAllowedForSso();
            LOGGER.debug("Located [{}] in registry. Service access to participate in SSO is set to [{}]", (Object)registeredService.getServiceId(), (Object)isAllowedForSso);
            return !isAllowedForSso;
        }
        return false;
    }
}

