/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.oauth.util;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.services.UnauthorizedServiceException;
import org.apereo.cas.support.oauth.OAuth20GrantTypes;
import org.apereo.cas.support.oauth.OAuth20ResponseTypes;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.pac4j.core.context.J2EContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;

public final class OAuth20Utils {
    private static final Logger LOGGER = LoggerFactory.getLogger(OAuth20Utils.class);
    private static final ObjectWriter WRITER = new ObjectMapper().findAndRegisterModules().writer().withDefaultPrettyPrinter();

    private OAuth20Utils() {
    }

    public static ModelAndView writeTextError(HttpServletResponse response, String error) {
        return OAuth20Utils.writeText(response, "error=" + error, 400);
    }

    public static ModelAndView writeText(HttpServletResponse response, String text, int status) {
        try (PrintWriter printWriter = response.getWriter();){
            response.setStatus(status);
            printWriter.print(text);
        }
        catch (IOException e) {
            LOGGER.error("Failed to write to response", (Throwable)e);
        }
        return null;
    }

    public static ModelAndView redirectTo(String url) {
        return new ModelAndView((View)new RedirectView(url));
    }

    public static OAuthRegisteredService getRegisteredOAuthService(ServicesManager servicesManager, String clientId) {
        Collection services = servicesManager.getAllServices();
        return services.stream().filter(OAuthRegisteredService.class::isInstance).filter(s -> ((OAuthRegisteredService)OAuthRegisteredService.class.cast(s)).getClientId().equals(clientId)).findFirst().orElse(null);
    }

    public static Map<String, Object> getRequestParameters(Collection<String> attributes, HttpServletRequest context) {
        return attributes.stream().filter(a -> StringUtils.isNotBlank((CharSequence)context.getParameter(a))).map(m -> {
            String[] values = context.getParameterValues(m);
            LinkedHashSet valuesSet = new LinkedHashSet();
            if (values != null && values.length > 0) {
                Arrays.stream(values).forEach(v -> valuesSet.addAll(Arrays.stream(v.split(" ")).collect(Collectors.toSet())));
            }
            return Pair.of((Object)m, valuesSet);
        }).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
    }

    public static Collection<String> getRequestedScopes(J2EContext context) {
        return OAuth20Utils.getRequestedScopes(context.getRequest());
    }

    public static Collection<String> getRequestedScopes(HttpServletRequest context) {
        Map<String, Object> map = OAuth20Utils.getRequestParameters(Arrays.asList("scope"), context);
        if (map == null || map.isEmpty()) {
            return Collections.emptyList();
        }
        return (Collection)map.get("scope");
    }

    public static ModelAndView produceUnauthorizedErrorView() {
        return OAuth20Utils.produceErrorView((Exception)new UnauthorizedServiceException("screen.service.error.message", ""));
    }

    public static ModelAndView produceErrorView(Exception e) {
        HashMap<String, Exception> model = new HashMap<String, Exception>();
        model.put("rootCauseException", e);
        return new ModelAndView("casServiceErrorView", model);
    }

    public static String casOAuthCallbackUrl(String serverPrefixUrl) {
        return serverPrefixUrl.concat("/oauth2.0/callbackAuthorize");
    }

    public static String jsonify(Map map) {
        try {
            return WRITER.writeValueAsString((Object)map);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    public static boolean isGrantType(String type, OAuth20GrantTypes expectedType) {
        return expectedType.name().equalsIgnoreCase(type);
    }

    public static boolean isResponseType(String type, OAuth20ResponseTypes expectedType) {
        return expectedType.getType().equalsIgnoreCase(type);
    }
}

