/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.oauth.web.endpoints;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URIBuilder;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.PrincipalException;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.ServiceFactory;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceAccessStrategyUtils;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.services.UnauthorizedServiceException;
import org.apereo.cas.support.oauth.OAuth20ResponseTypes;
import org.apereo.cas.support.oauth.authenticator.OAuth20CasAuthenticationBuilder;
import org.apereo.cas.support.oauth.profile.OAuth20ProfileScopeToAttributesFilter;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.apereo.cas.support.oauth.util.OAuth20Utils;
import org.apereo.cas.support.oauth.validator.OAuth20Validator;
import org.apereo.cas.support.oauth.web.endpoints.BaseOAuth20Controller;
import org.apereo.cas.support.oauth.web.response.accesstoken.ext.AccessTokenRequestDataHolder;
import org.apereo.cas.support.oauth.web.views.ConsentApprovalViewResolver;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.ticket.TicketGrantingTicket;
import org.apereo.cas.ticket.accesstoken.AccessToken;
import org.apereo.cas.ticket.accesstoken.AccessTokenFactory;
import org.apereo.cas.ticket.code.OAuthCode;
import org.apereo.cas.ticket.code.OAuthCodeFactory;
import org.apereo.cas.ticket.registry.TicketRegistry;
import org.apereo.cas.util.EncodingUtils;
import org.apereo.cas.web.support.CookieRetrievingCookieGenerator;
import org.apereo.cas.web.support.CookieUtils;
import org.apereo.cas.web.support.WebUtils;
import org.pac4j.core.context.J2EContext;
import org.pac4j.core.profile.ProfileManager;
import org.pac4j.core.profile.UserProfile;
import org.pac4j.core.util.CommonHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.servlet.ModelAndView;

public class OAuth20AuthorizeEndpointController
extends BaseOAuth20Controller {
    private static final Logger LOGGER = LoggerFactory.getLogger(OAuth20AuthorizeEndpointController.class);
    protected OAuthCodeFactory oAuthCodeFactory;
    protected final ConsentApprovalViewResolver consentApprovalViewResolver;
    protected final OAuth20CasAuthenticationBuilder authenticationBuilder;

    public OAuth20AuthorizeEndpointController(ServicesManager servicesManager, TicketRegistry ticketRegistry, OAuth20Validator validator, AccessTokenFactory accessTokenFactory, PrincipalFactory principalFactory, ServiceFactory<WebApplicationService> webApplicationServiceServiceFactory, OAuthCodeFactory oAuthCodeFactory, ConsentApprovalViewResolver consentApprovalViewResolver, OAuth20ProfileScopeToAttributesFilter scopeToAttributesFilter, CasConfigurationProperties casProperties, CookieRetrievingCookieGenerator ticketGrantingTicketCookieGenerator, OAuth20CasAuthenticationBuilder authenticationBuilder) {
        super(servicesManager, ticketRegistry, validator, accessTokenFactory, principalFactory, webApplicationServiceServiceFactory, scopeToAttributesFilter, casProperties, ticketGrantingTicketCookieGenerator);
        this.oAuthCodeFactory = oAuthCodeFactory;
        this.consentApprovalViewResolver = consentApprovalViewResolver;
        this.authenticationBuilder = authenticationBuilder;
    }

    @GetMapping(path={"/oauth2.0/authorize"})
    public ModelAndView handleRequest(HttpServletRequest request, HttpServletResponse response) throws Exception {
        J2EContext context = WebUtils.getPac4jJ2EContext((HttpServletRequest)request, (HttpServletResponse)response);
        ProfileManager manager = WebUtils.getPac4jProfileManager((HttpServletRequest)request, (HttpServletResponse)response);
        if (!this.verifyAuthorizeRequest(request) || !OAuth20AuthorizeEndpointController.isRequestAuthenticated(manager, context)) {
            LOGGER.error("Authorize request verification failed");
            return OAuth20Utils.produceUnauthorizedErrorView();
        }
        String clientId = context.getRequestParameter("client_id");
        OAuthRegisteredService registeredService = this.getRegisteredServiceByClientId(clientId);
        try {
            RegisteredServiceAccessStrategyUtils.ensureServiceAccessIsAllowed((String)clientId, (RegisteredService)registeredService);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return OAuth20Utils.produceUnauthorizedErrorView();
        }
        ModelAndView mv = this.consentApprovalViewResolver.resolve(context, registeredService);
        if (!mv.isEmpty() && mv.hasView()) {
            return mv;
        }
        return this.redirectToCallbackRedirectUrl(manager, registeredService, context, clientId);
    }

    protected OAuthRegisteredService getRegisteredServiceByClientId(String clientId) {
        return OAuth20Utils.getRegisteredOAuthService(this.servicesManager, clientId);
    }

    private static boolean isRequestAuthenticated(ProfileManager manager, J2EContext context) {
        Optional opt = manager.get(true);
        return opt.isPresent();
    }

    protected ModelAndView redirectToCallbackRedirectUrl(ProfileManager manager, OAuthRegisteredService registeredService, J2EContext context, String clientId) throws Exception {
        String callbackUrl;
        Optional profile = manager.get(true);
        if (profile == null || !profile.isPresent()) {
            LOGGER.error("Unexpected null profile from profile manager. Request is not fully authenticated.");
            return OAuth20Utils.produceUnauthorizedErrorView();
        }
        Service service = this.authenticationBuilder.buildService(registeredService, context, false);
        LOGGER.debug("Created service [{}] based on registered service [{}]", (Object)service, (Object)registeredService);
        Authentication authentication = this.authenticationBuilder.build((UserProfile)profile.get(), registeredService, context, service);
        LOGGER.debug("Created OAuth authentication [{}] for service [{}]", (Object)service, (Object)authentication);
        try {
            RegisteredServiceAccessStrategyUtils.ensurePrincipalAccessIsAllowedForService((Service)service, (RegisteredService)registeredService, (Authentication)authentication);
        }
        catch (PrincipalException | UnauthorizedServiceException e) {
            LOGGER.error(e.getMessage(), e);
            return OAuth20Utils.produceUnauthorizedErrorView();
        }
        String redirectUri = context.getRequestParameter("redirect_uri");
        LOGGER.debug("Authorize request verification successful for client [{}] with redirect uri [{}]", (Object)clientId, (Object)redirectUri);
        String responseType = context.getRequestParameter("response_type");
        TicketGrantingTicket ticketGrantingTicket = CookieUtils.getTicketGrantingTicketFromRequest((CookieRetrievingCookieGenerator)this.ticketGrantingTicketCookieGenerator, (TicketRegistry)this.ticketRegistry, (HttpServletRequest)context.getRequest());
        if (OAuth20Utils.isResponseType(responseType, OAuth20ResponseTypes.CODE)) {
            callbackUrl = this.buildCallbackUrlForAuthorizationCodeResponseType(authentication, service, redirectUri, ticketGrantingTicket);
        } else if (OAuth20Utils.isResponseType(responseType, OAuth20ResponseTypes.TOKEN)) {
            AccessTokenRequestDataHolder holder = new AccessTokenRequestDataHolder(service, authentication, registeredService, ticketGrantingTicket);
            callbackUrl = this.buildCallbackUrlForImplicitTokenResponseType(holder, redirectUri);
        } else {
            callbackUrl = this.buildCallbackUrlForTokenResponseType(context, authentication, service, redirectUri, responseType, clientId);
        }
        LOGGER.debug("Callback URL to redirect: [{}]", (Object)callbackUrl);
        if (StringUtils.isBlank((CharSequence)callbackUrl)) {
            return OAuth20Utils.produceUnauthorizedErrorView();
        }
        return OAuth20Utils.redirectTo(callbackUrl);
    }

    protected String buildCallbackUrlForTokenResponseType(J2EContext context, Authentication authentication, Service service, String redirectUri, String responseType, String clientId) {
        return null;
    }

    private String buildCallbackUrlForImplicitTokenResponseType(AccessTokenRequestDataHolder holder, String redirectUri) throws Exception {
        AccessToken accessToken = this.generateAccessToken(holder);
        LOGGER.debug("Generated OAuth access token: [{}]", (Object)accessToken);
        return this.buildCallbackUrlResponseType(holder.getAuthentication(), holder.getService(), redirectUri, accessToken, Collections.emptyList());
    }

    protected String buildCallbackUrlResponseType(Authentication authentication, Service service, String redirectUri, AccessToken accessToken, List<NameValuePair> params) throws Exception {
        String state = authentication.getAttributes().get("state").toString();
        String nonce = authentication.getAttributes().get("nonce").toString();
        URIBuilder builder = new URIBuilder(redirectUri);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("access_token").append('=').append(accessToken.getId()).append('&').append("token_type").append('=').append("bearer").append('&').append("expires_in").append('=').append(this.casProperties.getTicket().getTgt().getTimeToKillInSeconds());
        params.forEach(p -> stringBuilder.append('&').append(p.getName()).append('=').append(p.getValue()));
        if (StringUtils.isNotBlank((CharSequence)state)) {
            stringBuilder.append('&').append("state").append('=').append(EncodingUtils.urlEncode((String)state));
        }
        if (StringUtils.isNotBlank((CharSequence)nonce)) {
            stringBuilder.append('&').append("nonce").append('=').append(EncodingUtils.urlEncode((String)nonce));
        }
        builder.setFragment(stringBuilder.toString());
        String url = builder.toString();
        return url;
    }

    private String buildCallbackUrlForAuthorizationCodeResponseType(Authentication authentication, Service service, String redirectUri, TicketGrantingTicket ticketGrantingTicket) {
        OAuthCode code = this.oAuthCodeFactory.create(service, authentication, ticketGrantingTicket);
        LOGGER.debug("Generated OAuth code: [{}]", (Object)code);
        this.ticketRegistry.addTicket((Ticket)code);
        String state = authentication.getAttributes().get("state").toString();
        String nonce = authentication.getAttributes().get("nonce").toString();
        String callbackUrl = redirectUri;
        callbackUrl = CommonHelper.addParameter((String)callbackUrl, (String)"code", (String)code.getId());
        if (StringUtils.isNotBlank((CharSequence)state)) {
            callbackUrl = CommonHelper.addParameter((String)callbackUrl, (String)"state", (String)state);
        }
        if (StringUtils.isNotBlank((CharSequence)nonce)) {
            callbackUrl = CommonHelper.addParameter((String)callbackUrl, (String)"nonce", (String)nonce);
        }
        return callbackUrl;
    }

    private boolean verifyAuthorizeRequest(HttpServletRequest request) {
        boolean checkParameterExist = this.validator.checkParameterExist(request, "client_id") && this.validator.checkParameterExist(request, "redirect_uri") && this.validator.checkParameterExist(request, "response_type");
        String responseType = request.getParameter("response_type");
        String clientId = request.getParameter("client_id");
        String redirectUri = request.getParameter("redirect_uri");
        OAuthRegisteredService registeredService = this.getRegisteredServiceByClientId(clientId);
        return checkParameterExist && OAuth20AuthorizeEndpointController.checkResponseTypes(responseType, OAuth20ResponseTypes.values()) && this.validator.checkServiceValid((RegisteredService)registeredService) && this.validator.checkCallbackValid((RegisteredService)registeredService, redirectUri);
    }

    private static boolean checkResponseTypes(String type, OAuth20ResponseTypes ... expectedTypes) {
        LOGGER.debug("Response type: [{}]", (Object)type);
        boolean checked = Stream.of(expectedTypes).anyMatch(t -> OAuth20Utils.isResponseType(type, t));
        if (!checked) {
            LOGGER.error("Unsupported response type: [{}]", (Object)type);
        }
        return checked;
    }
}

