/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.oauth.web.endpoints;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.authentication.principal.ServiceFactory;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.support.oauth.profile.OAuth20ProfileScopeToAttributesFilter;
import org.apereo.cas.support.oauth.validator.OAuth20Validator;
import org.apereo.cas.support.oauth.web.endpoints.BaseOAuth20Controller;
import org.apereo.cas.support.oauth.web.views.OAuth20CallbackAuthorizeViewResolver;
import org.apereo.cas.ticket.accesstoken.AccessTokenFactory;
import org.apereo.cas.ticket.registry.TicketRegistry;
import org.apereo.cas.web.support.CookieRetrievingCookieGenerator;
import org.apereo.cas.web.support.WebUtils;
import org.pac4j.core.config.Config;
import org.pac4j.core.context.J2EContext;
import org.pac4j.core.profile.ProfileManager;
import org.pac4j.springframework.web.CallbackController;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.servlet.ModelAndView;

public class OAuth20CallbackAuthorizeEndpointController
extends BaseOAuth20Controller {
    private final CallbackController callbackController;
    private final OAuth20CallbackAuthorizeViewResolver oAuth20CallbackAuthorizeViewResolver;

    public OAuth20CallbackAuthorizeEndpointController(ServicesManager servicesManager, TicketRegistry ticketRegistry, OAuth20Validator validator, AccessTokenFactory accessTokenFactory, PrincipalFactory principalFactory, ServiceFactory<WebApplicationService> webApplicationServiceServiceFactory, Config config, CallbackController callbackController, OAuth20CallbackAuthorizeViewResolver oAuth20CallbackAuthorizeViewResolver, OAuth20ProfileScopeToAttributesFilter scopeToAttributesFilter, CasConfigurationProperties casProperties, CookieRetrievingCookieGenerator cookieGenerator) {
        super(servicesManager, ticketRegistry, validator, accessTokenFactory, principalFactory, webApplicationServiceServiceFactory, scopeToAttributesFilter, casProperties, cookieGenerator);
        this.callbackController = callbackController;
        this.oAuth20CallbackAuthorizeViewResolver = oAuth20CallbackAuthorizeViewResolver;
        this.callbackController.setConfig(config);
    }

    @GetMapping(path={"/oauth2.0/callbackAuthorize"})
    public ModelAndView handleRequest(HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.callbackController.callback(request, response);
        String url = StringUtils.remove((String)response.getHeader("Location"), (String)"redirect:");
        J2EContext ctx = WebUtils.getPac4jJ2EContext((HttpServletRequest)request, (HttpServletResponse)response);
        ProfileManager manager = WebUtils.getPac4jProfileManager((HttpServletRequest)request, (HttpServletResponse)response);
        return this.oAuth20CallbackAuthorizeViewResolver.resolve(ctx, manager, url);
    }
}

