/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.oauth.web.response.accesstoken.ext;

import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apereo.cas.CentralAuthenticationService;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.AuthenticationResult;
import org.apereo.cas.authentication.DefaultAuthenticationResult;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.configuration.model.support.oauth.OAuthProperties;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceAccessStrategyUtils;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.services.UnauthorizedServiceException;
import org.apereo.cas.support.oauth.OAuth20GrantTypes;
import org.apereo.cas.support.oauth.authenticator.OAuth20CasAuthenticationBuilder;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.apereo.cas.support.oauth.util.OAuth20Utils;
import org.apereo.cas.support.oauth.web.response.accesstoken.ext.AccessTokenRequestDataHolder;
import org.apereo.cas.support.oauth.web.response.accesstoken.ext.BaseAccessTokenGrantRequestExtractor;
import org.apereo.cas.ticket.TicketGrantingTicket;
import org.apereo.cas.ticket.registry.TicketRegistry;
import org.apereo.cas.web.support.WebUtils;
import org.pac4j.core.context.J2EContext;
import org.pac4j.core.profile.ProfileManager;
import org.pac4j.core.profile.UserProfile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccessTokenPasswordGrantRequestExtractor
extends BaseAccessTokenGrantRequestExtractor {
    private static final Logger LOGGER = LoggerFactory.getLogger(AccessTokenPasswordGrantRequestExtractor.class);
    private final OAuth20CasAuthenticationBuilder authenticationBuilder;

    public AccessTokenPasswordGrantRequestExtractor(ServicesManager servicesManager, TicketRegistry ticketRegistry, HttpServletRequest request, HttpServletResponse response, OAuth20CasAuthenticationBuilder authenticationBuilder, CentralAuthenticationService centralAuthenticationService, OAuthProperties oAuthProperties) {
        super(servicesManager, ticketRegistry, request, response, centralAuthenticationService, oAuthProperties);
        this.authenticationBuilder = authenticationBuilder;
    }

    @Override
    public AccessTokenRequestDataHolder extract() {
        String clientId = this.request.getParameter("client_id");
        LOGGER.debug("Locating OAuth registered service by client id [{}]", (Object)clientId);
        OAuthRegisteredService registeredService = OAuth20Utils.getRegisteredOAuthService(this.servicesManager, clientId);
        LOGGER.debug("Located OAuth registered service [{}]", (Object)registeredService);
        J2EContext context = WebUtils.getPac4jJ2EContext((HttpServletRequest)this.request, (HttpServletResponse)this.response);
        ProfileManager manager = WebUtils.getPac4jProfileManager((HttpServletRequest)this.request, (HttpServletResponse)this.response);
        Optional profile = manager.get(true);
        if (!profile.isPresent()) {
            throw new UnauthorizedServiceException("OAuth user profile cannot be determined");
        }
        LOGGER.debug("Creating matching service request based on [{}]", (Object)registeredService);
        boolean requireServiceHeader = this.oAuthProperties.getGrants().getResourceOwner().isRequireServiceHeader();
        if (requireServiceHeader) {
            LOGGER.debug("Using request headers to identify and build the target service url");
        }
        Service service = this.authenticationBuilder.buildService(registeredService, context, requireServiceHeader);
        LOGGER.debug("Authenticating the OAuth request indicated by [{}]", (Object)service);
        Authentication authentication = this.authenticationBuilder.build((UserProfile)profile.get(), registeredService, context, service);
        RegisteredServiceAccessStrategyUtils.ensurePrincipalAccessIsAllowedForService((Service)service, (RegisteredService)registeredService, (Authentication)authentication);
        boolean generateRefreshToken = this.isAllowedToGenerateRefreshToken(registeredService);
        DefaultAuthenticationResult result = new DefaultAuthenticationResult(authentication, (Service)(requireServiceHeader ? service : null));
        TicketGrantingTicket ticketGrantingTicket = this.centralAuthenticationService.createTicketGrantingTicket((AuthenticationResult)result);
        return new AccessTokenRequestDataHolder(service, authentication, registeredService, ticketGrantingTicket, generateRefreshToken);
    }

    protected boolean isAllowedToGenerateRefreshToken(OAuthRegisteredService registeredService) {
        return registeredService != null && registeredService.isGenerateRefreshToken() != false;
    }

    @Override
    public boolean supports(HttpServletRequest context) {
        String grantType = context.getParameter("grant_type");
        return OAuth20Utils.isGrantType(grantType, OAuth20GrantTypes.PASSWORD);
    }
}

