/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.ticket.accesstoken;

import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.ticket.ExpirationPolicy;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.ticket.TicketFactory;
import org.apereo.cas.ticket.TicketGrantingTicket;
import org.apereo.cas.ticket.UniqueTicketIdGenerator;
import org.apereo.cas.ticket.accesstoken.AccessToken;
import org.apereo.cas.ticket.accesstoken.AccessTokenFactory;
import org.apereo.cas.ticket.accesstoken.AccessTokenImpl;
import org.apereo.cas.util.DefaultUniqueTicketIdGenerator;

public class DefaultAccessTokenFactory
implements AccessTokenFactory {
    protected final UniqueTicketIdGenerator accessTokenIdGenerator;
    protected final ExpirationPolicy expirationPolicy;

    public DefaultAccessTokenFactory(ExpirationPolicy expirationPolicy) {
        this((UniqueTicketIdGenerator)new DefaultUniqueTicketIdGenerator(), expirationPolicy);
    }

    public DefaultAccessTokenFactory(UniqueTicketIdGenerator refreshTokenIdGenerator, ExpirationPolicy expirationPolicy) {
        this.accessTokenIdGenerator = refreshTokenIdGenerator;
        this.expirationPolicy = expirationPolicy;
    }

    @Override
    public AccessToken create(Service service, Authentication authentication, TicketGrantingTicket ticketGrantingTicket) {
        String codeId = this.accessTokenIdGenerator.getNewTicketId("AT");
        AccessTokenImpl at = new AccessTokenImpl(codeId, service, authentication, this.expirationPolicy, ticketGrantingTicket);
        if (ticketGrantingTicket != null) {
            ticketGrantingTicket.getDescendantTickets().add(at.getId());
        }
        return at;
    }

    public <T extends TicketFactory> T get(Class<? extends Ticket> clazz) {
        return (T)this;
    }
}

