/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.oauth.web.endpoints;

import java.util.Collection;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apache.commons.lang3.tuple.Pair;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.authentication.principal.ServiceFactory;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.support.oauth.OAuth20ResponseTypes;
import org.apereo.cas.support.oauth.profile.OAuth20ProfileScopeToAttributesFilter;
import org.apereo.cas.support.oauth.util.OAuth20Utils;
import org.apereo.cas.support.oauth.validator.token.OAuth20TokenRequestValidator;
import org.apereo.cas.support.oauth.web.endpoints.BaseOAuth20Controller;
import org.apereo.cas.support.oauth.web.response.accesstoken.AccessTokenResponseGenerator;
import org.apereo.cas.support.oauth.web.response.accesstoken.OAuth20TokenGenerator;
import org.apereo.cas.support.oauth.web.response.accesstoken.ext.AccessTokenRequestDataHolder;
import org.apereo.cas.support.oauth.web.response.accesstoken.ext.BaseAccessTokenGrantRequestExtractor;
import org.apereo.cas.ticket.ExpirationPolicy;
import org.apereo.cas.ticket.accesstoken.AccessToken;
import org.apereo.cas.ticket.accesstoken.AccessTokenFactory;
import org.apereo.cas.ticket.refreshtoken.RefreshToken;
import org.apereo.cas.ticket.registry.TicketRegistry;
import org.apereo.cas.util.Pac4jUtils;
import org.apereo.cas.web.support.CookieRetrievingCookieGenerator;
import org.pac4j.core.context.J2EContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;

public class OAuth20AccessTokenEndpointController
extends BaseOAuth20Controller {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(OAuth20AccessTokenEndpointController.class);
    private final OAuth20TokenGenerator accessTokenGenerator;
    private final AccessTokenResponseGenerator accessTokenResponseGenerator;
    private final ExpirationPolicy accessTokenExpirationPolicy;
    private final Collection<BaseAccessTokenGrantRequestExtractor> accessTokenGrantRequestExtractors;
    private final Collection<OAuth20TokenRequestValidator> accessTokenGrantRequestValidators;

    public OAuth20AccessTokenEndpointController(ServicesManager servicesManager, TicketRegistry ticketRegistry, AccessTokenFactory accessTokenFactory, PrincipalFactory principalFactory, ServiceFactory<WebApplicationService> webApplicationServiceServiceFactory, OAuth20TokenGenerator accessTokenGenerator, AccessTokenResponseGenerator accessTokenResponseGenerator, OAuth20ProfileScopeToAttributesFilter scopeToAttributesFilter, CasConfigurationProperties casProperties, CookieRetrievingCookieGenerator ticketGrantingTicketCookieGenerator, ExpirationPolicy accessTokenExpirationPolicy, Collection<BaseAccessTokenGrantRequestExtractor> accessTokenGrantRequestExtractors, Collection<OAuth20TokenRequestValidator> accessTokenGrantRequestValidators) {
        super(servicesManager, ticketRegistry, accessTokenFactory, principalFactory, webApplicationServiceServiceFactory, scopeToAttributesFilter, casProperties, ticketGrantingTicketCookieGenerator);
        this.accessTokenGenerator = accessTokenGenerator;
        this.accessTokenResponseGenerator = accessTokenResponseGenerator;
        this.accessTokenExpirationPolicy = accessTokenExpirationPolicy;
        this.accessTokenGrantRequestExtractors = accessTokenGrantRequestExtractors;
        this.accessTokenGrantRequestValidators = accessTokenGrantRequestValidators;
    }

    @PostMapping(path={"/oauth2.0/accessToken", "/oauth2.0/token"})
    public void handleRequest(HttpServletRequest request, HttpServletResponse response) throws Exception {
        AccessTokenRequestDataHolder requestHolder;
        response.setContentType("text/plain");
        try {
            if (!this.verifyAccessTokenRequest(request, response)) {
                throw new IllegalArgumentException("Access token validation failed");
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            OAuth20Utils.writeTextError(response, "invalid_request");
            return;
        }
        try {
            requestHolder = this.examineAndExtractAccessTokenGrantRequest(request, response);
            LOGGER.debug("Creating access token for [{}]", (Object)requestHolder);
        }
        catch (Exception e) {
            LOGGER.error("Could not identify and extract access token request", (Throwable)e);
            OAuth20Utils.writeTextError(response, "invalid_grant");
            return;
        }
        J2EContext context = Pac4jUtils.getPac4jJ2EContext((HttpServletRequest)request, (HttpServletResponse)response);
        Pair<AccessToken, RefreshToken> accessToken = this.accessTokenGenerator.generate(requestHolder);
        LOGGER.debug("Access token generated is: [{}]. Refresh token generated is [{}]", accessToken.getKey(), accessToken.getValue());
        this.generateAccessTokenResponse(request, response, requestHolder, context, (AccessToken)accessToken.getKey(), (RefreshToken)accessToken.getValue());
        response.setStatus(200);
    }

    @GetMapping(path={"/oauth2.0/accessToken", "/oauth2.0/token"})
    public void handleGetRequest(HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.handleRequest(request, response);
    }

    private void generateAccessTokenResponse(HttpServletRequest request, HttpServletResponse response, AccessTokenRequestDataHolder requestHolder, J2EContext context, AccessToken accessToken, RefreshToken refreshToken) {
        LOGGER.debug("Generating access token response for [{}]", (Object)accessToken);
        OAuth20ResponseTypes type = OAuth20Utils.getResponseType(context);
        LOGGER.debug("Located response type as [{}]", (Object)type);
        this.accessTokenResponseGenerator.generate(request, response, requestHolder.getRegisteredService(), requestHolder.getService(), accessToken, refreshToken, this.accessTokenExpirationPolicy.getTimeToLive(), type);
    }

    private AccessTokenRequestDataHolder examineAndExtractAccessTokenGrantRequest(HttpServletRequest request, HttpServletResponse response) {
        return this.accessTokenGrantRequestExtractors.stream().filter(ext -> ext.supports(request)).findFirst().orElseThrow(() -> new UnsupportedOperationException("Access token request is not supported")).extract(request, response);
    }

    private boolean verifyAccessTokenRequest(HttpServletRequest request, HttpServletResponse response) {
        if (this.accessTokenGrantRequestValidators.isEmpty()) {
            LOGGER.warn("No validators are defined to examine the access token request for eligibility");
            return false;
        }
        J2EContext context = new J2EContext(request, response);
        return this.accessTokenGrantRequestValidators.stream().filter(ext -> ext.supports(context)).findFirst().orElseThrow(() -> new UnsupportedOperationException("Access token request is not supported")).validate(context);
    }
}

