/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow;

import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apereo.cas.util.Pac4jUtils;
import org.apereo.cas.web.support.WebUtils;
import org.pac4j.core.client.Client;
import org.pac4j.core.client.Clients;
import org.pac4j.core.context.J2EContext;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.exception.TechnicalException;
import org.pac4j.core.profile.CommonProfile;
import org.pac4j.core.profile.ProfileManager;
import org.pac4j.core.redirect.RedirectAction;
import org.pac4j.saml.client.SAML2Client;
import org.pac4j.saml.profile.SAML2Profile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.action.AbstractAction;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class DelegatedAuthenticationSAML2ClientLogoutAction
extends AbstractAction {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(DelegatedAuthenticationSAML2ClientLogoutAction.class);
    private final Clients clients;

    protected Event doExecute(RequestContext requestContext) {
        try {
            Client client;
            HttpServletRequest request = WebUtils.getHttpServletRequestFromExternalWebflowContext((RequestContext)requestContext);
            HttpServletResponse response = WebUtils.getHttpServletResponseFromExternalWebflowContext((RequestContext)requestContext);
            J2EContext context = Pac4jUtils.getPac4jJ2EContext((HttpServletRequest)request, (HttpServletResponse)response);
            CommonProfile profile = DelegatedAuthenticationSAML2ClientLogoutAction.findProfile((WebContext)context);
            try {
                client = profile == null ? null : this.clients.findClient(profile.getClientName());
            }
            catch (TechnicalException e) {
                LOGGER.debug("No SAML2 client found: " + e.getMessage(), (Throwable)e);
                client = null;
            }
            if (client instanceof SAML2Client) {
                SAML2Client saml2Client = (SAML2Client)client;
                SAML2Profile samlProfile = (SAML2Profile)profile;
                LOGGER.debug("Located SAML2 client [{}]", (Object)saml2Client);
                RedirectAction action = saml2Client.getLogoutAction((WebContext)context, (CommonProfile)samlProfile, null);
                LOGGER.debug("Preparing logout message to send is [{}]", (Object)action.getLocation());
                action.perform((WebContext)context);
            } else {
                LOGGER.debug("The current client is not a SAML2 client or it cannot be found at all, no logout action will be executed.");
            }
        }
        catch (Exception e) {
            LOGGER.warn(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    private static CommonProfile findProfile(WebContext webContext) {
        ProfileManager pm = Pac4jUtils.getPac4jProfileManager((WebContext)webContext);
        Optional profile = pm.get(true);
        return profile.orElse(null);
    }

    @Generated
    public DelegatedAuthenticationSAML2ClientLogoutAction(Clients clients) {
        this.clients = clients;
    }
}

