/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.apereo.cas.CentralAuthenticationService;
import org.apereo.cas.audit.AuditableContext;
import org.apereo.cas.audit.AuditableExecution;
import org.apereo.cas.audit.AuditableExecutionResult;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.AuthenticationServiceSelectionPlan;
import org.apereo.cas.authentication.AuthenticationSystemSupport;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.adaptive.AdaptiveAuthenticationPolicy;
import org.apereo.cas.authentication.principal.ClientCredential;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.services.UnauthorizedServiceException;
import org.apereo.cas.ticket.AbstractTicketException;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.ticket.TicketGrantingTicket;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.Pac4jUtils;
import org.apereo.cas.web.DelegatedClientWebflowManager;
import org.apereo.cas.web.flow.actions.AbstractAuthenticationAction;
import org.apereo.cas.web.flow.resolver.CasDelegatingWebflowEventResolver;
import org.apereo.cas.web.flow.resolver.CasWebflowEventResolver;
import org.apereo.cas.web.pac4j.DelegatedSessionCookieManager;
import org.apereo.cas.web.support.WebUtils;
import org.pac4j.core.client.BaseClient;
import org.pac4j.core.client.Client;
import org.pac4j.core.client.Clients;
import org.pac4j.core.client.IndirectClient;
import org.pac4j.core.context.J2EContext;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.credentials.Credentials;
import org.pac4j.core.profile.CommonProfile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.util.UriComponentsBuilder;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class DelegatedClientAuthenticationAction
extends AbstractAuthenticationAction {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(DelegatedClientAuthenticationAction.class);
    public static final String PAC4J_URLS = "pac4jUrls";
    private static final Pattern PAC4J_CLIENT_SUFFIX_PATTERN = Pattern.compile("Client\\d*");
    private static final Pattern PAC4J_CLIENT_CSS_CLASS_SUBSTITUTION_PATTERN = Pattern.compile("\\W");
    protected final Clients clients;
    protected final ServicesManager servicesManager;
    protected final AuditableExecution delegatedAuthenticationPolicyEnforcer;
    protected final DelegatedClientWebflowManager delegatedClientWebflowManager;
    protected final DelegatedSessionCookieManager delegatedSessionCookieManager;
    protected final AuthenticationSystemSupport authenticationSystemSupport;
    protected final String localeParamName;
    protected final String themeParamName;
    private final AuthenticationServiceSelectionPlan authenticationRequestServiceSelectionStrategies;
    private final CentralAuthenticationService centralAuthenticationService;

    public DelegatedClientAuthenticationAction(CasDelegatingWebflowEventResolver initialAuthenticationAttemptWebflowEventResolver, CasWebflowEventResolver serviceTicketRequestWebflowEventResolver, AdaptiveAuthenticationPolicy adaptiveAuthenticationPolicy, Clients clients, ServicesManager servicesManager, AuditableExecution delegatedAuthenticationPolicyEnforcer, DelegatedClientWebflowManager delegatedClientWebflowManager, DelegatedSessionCookieManager delegatedSessionCookieManager, AuthenticationSystemSupport authenticationSystemSupport, String localeParamName, String themeParamName, AuthenticationServiceSelectionPlan authenticationRequestServiceSelectionStrategies, CentralAuthenticationService centralAuthenticationService) {
        super(initialAuthenticationAttemptWebflowEventResolver, serviceTicketRequestWebflowEventResolver, adaptiveAuthenticationPolicy);
        this.clients = clients;
        this.servicesManager = servicesManager;
        this.delegatedAuthenticationPolicyEnforcer = delegatedAuthenticationPolicyEnforcer;
        this.delegatedClientWebflowManager = delegatedClientWebflowManager;
        this.delegatedSessionCookieManager = delegatedSessionCookieManager;
        this.authenticationSystemSupport = authenticationSystemSupport;
        this.localeParamName = localeParamName;
        this.themeParamName = themeParamName;
        this.authenticationRequestServiceSelectionStrategies = authenticationRequestServiceSelectionStrategies;
        this.centralAuthenticationService = centralAuthenticationService;
    }

    public static Optional<ModelAndView> hasDelegationRequestFailed(HttpServletRequest request, int status) {
        Map params = request.getParameterMap();
        if (params.containsKey("error") || params.containsKey("error_code") || params.containsKey("error_description") || params.containsKey("error_message")) {
            HashMap<String, Object> model = new HashMap<String, Object>();
            if (params.containsKey("error_code")) {
                model.put("code", StringEscapeUtils.escapeHtml4((String)request.getParameter("error_code")));
            } else {
                model.put("code", status);
            }
            model.put("error", StringEscapeUtils.escapeHtml4((String)request.getParameter("error")));
            model.put("reason", StringEscapeUtils.escapeHtml4((String)request.getParameter("error_reason")));
            if (params.containsKey("error_description")) {
                model.put("description", StringEscapeUtils.escapeHtml4((String)request.getParameter("error_description")));
            } else if (params.containsKey("error_message")) {
                model.put("description", StringEscapeUtils.escapeHtml4((String)request.getParameter("error_message")));
            }
            model.put("service", request.getAttribute("service"));
            model.put("client", StringEscapeUtils.escapeHtml4((String)request.getParameter("client_name")));
            LOGGER.debug("Delegation request has failed. Details are [{}]", model);
            return Optional.of(new ModelAndView("casPac4jStopWebflow", model));
        }
        return Optional.empty();
    }

    public Event doExecute(RequestContext context) {
        HttpServletRequest request = WebUtils.getHttpServletRequestFromExternalWebflowContext((RequestContext)context);
        HttpServletResponse response = WebUtils.getHttpServletResponseFromExternalWebflowContext((RequestContext)context);
        if (!this.isLogoutRequest(request) && this.singleSignOnSessionExists(context)) {
            Service service;
            Authentication authentication;
            ArrayList clientNames;
            String clientName;
            String tgt = WebUtils.getTicketGrantingTicketId((RequestContext)context);
            Optional<Authentication> authnResult = this.getSingleSignOnAuthenticationFrom(context);
            if (authnResult.isPresent() && this.isDelegatedClientAuthorizedFor(clientName = CollectionUtils.firstElement(clientNames = (authentication = authnResult.get()).getAttributes().getOrDefault("clientName", new ArrayList())).map(Object::toString).orElse(""), service = this.resolveServiceFromRequestContext(context))) {
                LOGGER.debug("An existing single sign-on session already exists. Skipping delegation and routing back to CAS authentication flow");
                this.prepareForLoginPage(context);
                return this.resumeWebflow();
            }
            Service resolvedService = this.resolveServiceFromRequestContext(context);
            LOGGER.debug("Single sign-on session in unauthorized for service [{}]", (Object)resolvedService);
            this.centralAuthenticationService.deleteTicket(tgt);
        }
        String clientName = request.getParameter("client_name");
        LOGGER.debug("Delegated authentication is handled by client name [{}]", (Object)clientName);
        if (DelegatedClientAuthenticationAction.hasDelegationRequestFailed(request, response.getStatus()).isPresent()) {
            throw new IllegalArgumentException("Delegated authentication has failed with client " + clientName);
        }
        String logoutEndpoint = request.getParameter("logoutendpoint");
        J2EContext webContext = Pac4jUtils.getPac4jJ2EContext((HttpServletRequest)request, (HttpServletResponse)response);
        if (StringUtils.isNotBlank((CharSequence)clientName)) {
            Credentials credentials;
            Service service = StringUtils.isBlank((CharSequence)logoutEndpoint) ? this.restoreAuthenticationRequestInContext(context, webContext, clientName) : null;
            BaseClient<Credentials, CommonProfile> client = this.findDelegatedClientByName(request, clientName, service);
            try {
                credentials = client.getCredentials((WebContext)webContext);
                LOGGER.debug("Retrieved credentials from client as [{}]", (Object)credentials);
                if (credentials == null) {
                    throw new IllegalArgumentException("Unable to determine credentials from the context with client " + client.getName());
                }
            }
            catch (Exception e) {
                return this.handleException(webContext, client, e);
            }
            ClientCredential clientCredential = new ClientCredential(credentials, client.getName());
            WebUtils.putCredential((RequestContext)context, (Credential)clientCredential);
            WebUtils.putService((RequestContext)context, (Service)service);
            Service resolvedService = this.authenticationRequestServiceSelectionStrategies.resolveService(service);
            RegisteredService registeredService = this.servicesManager.findServiceBy(resolvedService);
            WebUtils.putRegisteredService((RequestContext)context, (RegisteredService)registeredService);
            return super.doExecute(context);
        }
        this.prepareForLoginPage(context);
        if (response.getStatus() == HttpStatus.UNAUTHORIZED.value()) {
            return this.stopWebflow();
        }
        return this.error();
    }

    private Optional<Authentication> getSingleSignOnAuthenticationFrom(RequestContext requestContext) {
        String tgtId = WebUtils.getTicketGrantingTicketId((RequestContext)requestContext);
        if (StringUtils.isBlank((CharSequence)tgtId)) {
            LOGGER.trace("No ticket-granting ticket could be located in the webflow context");
            return Optional.empty();
        }
        TicketGrantingTicket ticket = (TicketGrantingTicket)this.centralAuthenticationService.getTicket(tgtId, TicketGrantingTicket.class);
        if (ticket != null && !ticket.isExpired()) {
            LOGGER.trace("Located a valid ticket-granting ticket. Examining existing single sign-on session strategies...");
            return Optional.of(ticket.getAuthentication());
        }
        return Optional.empty();
    }

    protected Event handleException(J2EContext webContext, BaseClient<Credentials, CommonProfile> client, Exception e) {
        LOGGER.info(e.getMessage(), (Throwable)e);
        throw new IllegalArgumentException("Delegated authentication has failed with client " + client.getName());
    }

    public boolean isDelegatedClientAuthorizedFor(String clientName, Service service) {
        if (service == null || StringUtils.isBlank((CharSequence)service.getId())) {
            LOGGER.debug("Can not evaluate delegated authentication policy without a service");
            return true;
        }
        if (StringUtils.isBlank((CharSequence)clientName)) {
            LOGGER.debug("No client is provided to execute authorization for [{}]. SSO session may have been established w/o delegation", (Object)service);
            return true;
        }
        RegisteredService registeredService = this.servicesManager.findServiceBy(service);
        if (registeredService == null || !registeredService.getAccessStrategy().isServiceAccessAllowed()) {
            LOGGER.warn("Service access for [{}] is denied", (Object)registeredService);
            return false;
        }
        LOGGER.trace("Located registered service definition [{}] matching [{}]", (Object)registeredService, (Object)service);
        AuditableContext context = AuditableContext.builder().registeredService(registeredService).properties(CollectionUtils.wrap((String)Client.class.getSimpleName(), (Object)clientName)).build();
        AuditableExecutionResult result = this.delegatedAuthenticationPolicyEnforcer.execute(context);
        if (!result.isExecutionFailure()) {
            LOGGER.debug("Delegated authentication policy for [{}] allows for using client [{}]", (Object)registeredService, (Object)clientName);
            return true;
        }
        LOGGER.warn("Delegated authentication policy for [{}] refuses access to client [{}]", (Object)registeredService.getServiceId(), (Object)clientName);
        return false;
    }

    protected BaseClient<Credentials, CommonProfile> findDelegatedClientByName(HttpServletRequest request, String clientName, Service service) {
        BaseClient client = (BaseClient)this.clients.findClient(clientName);
        LOGGER.debug("Delegated authentication client is [{}] with service [{}}", (Object)client, (Object)service);
        if (service != null) {
            request.setAttribute("service", (Object)service.getId());
            if (!this.isDelegatedClientAuthorizedForService((Client)client, service)) {
                LOGGER.warn("Delegated client [{}] is not authorized by service [{}]", (Object)client, (Object)service);
                throw new UnauthorizedServiceException("screen.service.error.message", "");
            }
        }
        return client;
    }

    protected void prepareForLoginPage(RequestContext context) {
        WebApplicationService currentService = WebUtils.getService((RequestContext)context);
        WebApplicationService service = (WebApplicationService)this.authenticationRequestServiceSelectionStrategies.resolveService((Service)currentService, WebApplicationService.class);
        HttpServletRequest request = WebUtils.getHttpServletRequestFromExternalWebflowContext((RequestContext)context);
        HttpServletResponse response = WebUtils.getHttpServletResponseFromExternalWebflowContext((RequestContext)context);
        J2EContext webContext = Pac4jUtils.getPac4jJ2EContext((HttpServletRequest)request, (HttpServletResponse)response);
        LinkedHashSet urls = new LinkedHashSet();
        this.clients.findAllClients().stream().filter(client -> client instanceof IndirectClient && this.isDelegatedClientAuthorizedForService((Client)client, (Service)service)).map(IndirectClient.class::cast).forEach(arg_0 -> this.lambda$prepareForLoginPage$1((WebContext)webContext, currentService, urls, arg_0));
        if (!urls.isEmpty()) {
            context.getFlowScope().put(PAC4J_URLS, urls);
        } else if (response.getStatus() != HttpStatus.UNAUTHORIZED.value()) {
            LOGGER.warn("No delegated authentication providers could be determined based on the provided configuration. Either no clients are configured, or the current access strategy rules prohibit CAS from using authentication providers for this request.");
        }
    }

    protected Optional<ProviderLoginPageConfiguration> buildProviderConfiguration(IndirectClient client, WebContext webContext, WebApplicationService service) {
        String themeParam;
        String localeParam;
        String methodParam;
        String name = client.getName();
        Matcher matcher = PAC4J_CLIENT_SUFFIX_PATTERN.matcher(client.getClass().getSimpleName());
        String type = matcher.replaceAll("").toLowerCase();
        UriComponentsBuilder uriBuilder = UriComponentsBuilder.fromUriString((String)"clientredirect").queryParam("client_name", new Object[]{name});
        if (service != null) {
            String sourceParam = service.getSource();
            String serviceParam = service.getOriginalUrl();
            if (StringUtils.isNotBlank((CharSequence)sourceParam) && StringUtils.isNotBlank((CharSequence)serviceParam)) {
                uriBuilder.queryParam(sourceParam, new Object[]{serviceParam});
            }
        }
        if (StringUtils.isNotBlank((CharSequence)(methodParam = webContext.getRequestParameter("method")))) {
            uriBuilder.queryParam("method", new Object[]{methodParam});
        }
        if (StringUtils.isNotBlank((CharSequence)(localeParam = webContext.getRequestParameter(this.localeParamName)))) {
            uriBuilder.queryParam(this.localeParamName, new Object[]{localeParam});
        }
        if (StringUtils.isNotBlank((CharSequence)(themeParam = webContext.getRequestParameter(this.themeParamName)))) {
            uriBuilder.queryParam(this.themeParamName, new Object[]{themeParam});
        }
        String redirectUrl = uriBuilder.toUriString();
        boolean autoRedirect = client.getCustomProperties().getOrDefault("autoRedirect", Boolean.FALSE);
        ProviderLoginPageConfiguration p = new ProviderLoginPageConfiguration(name, redirectUrl, type, this.getCssClass(name), autoRedirect);
        return Optional.of(p);
    }

    protected String getCssClass(String name) {
        String computedCssClass = "fa fa-lock";
        if (StringUtils.isNotBlank((CharSequence)name)) {
            computedCssClass = computedCssClass.concat(' ' + PAC4J_CLIENT_CSS_CLASS_SUBSTITUTION_PATTERN.matcher(name).replaceAll("-"));
        }
        LOGGER.debug("cssClass for [{}] is [{}]", (Object)name, (Object)computedCssClass);
        return computedCssClass;
    }

    protected Event stopWebflow() {
        return new Event((Object)this, "stop");
    }

    protected Event resumeWebflow() {
        return new Event((Object)this, "resume");
    }

    private Service resolveServiceFromRequestContext(RequestContext context) {
        WebApplicationService service = WebUtils.getService((RequestContext)context);
        return this.authenticationRequestServiceSelectionStrategies.resolveService((Service)service);
    }

    protected boolean isDelegatedClientAuthorizedForService(Client client, Service service) {
        if (service == null || StringUtils.isBlank((CharSequence)service.getId())) {
            LOGGER.debug("Can not evaluate delegated authentication policy since no service was provided in the request while processing client [{}]", (Object)client);
            return true;
        }
        RegisteredService registeredService = this.servicesManager.findServiceBy(service);
        if (registeredService == null || !registeredService.getAccessStrategy().isServiceAccessAllowed()) {
            LOGGER.warn("Service access for [{}] is denied", (Object)registeredService);
            return false;
        }
        LOGGER.debug("Located registered service definition [{}] matching [{}]", (Object)registeredService, (Object)service);
        AuditableContext context = AuditableContext.builder().registeredService(registeredService).properties(CollectionUtils.wrap((String)Client.class.getSimpleName(), (Object)client.getName())).build();
        AuditableExecutionResult result = this.delegatedAuthenticationPolicyEnforcer.execute(context);
        if (!result.isExecutionFailure()) {
            LOGGER.debug("Delegated authentication policy for [{}] allows for using client [{}]", (Object)registeredService, (Object)client);
            return true;
        }
        LOGGER.warn("Delegated authentication policy for [{}] refuses access to client [{}]", (Object)registeredService.getServiceId(), (Object)client);
        return false;
    }

    protected Service restoreAuthenticationRequestInContext(RequestContext requestContext, J2EContext webContext, String clientName) {
        try {
            this.delegatedSessionCookieManager.restore(webContext);
            BaseClient client = (BaseClient)this.clients.findClient(clientName);
            return this.delegatedClientWebflowManager.retrieve(requestContext, (WebContext)webContext, client);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new UnauthorizedServiceException("screen.service.error.message", "Service unauthorized");
        }
    }

    private boolean isLogoutRequest(HttpServletRequest request) {
        return request.getParameter("logoutendpoint") != null;
    }

    private boolean singleSignOnSessionExists(RequestContext requestContext) {
        String tgtId = WebUtils.getTicketGrantingTicketId((RequestContext)requestContext);
        if (StringUtils.isBlank((CharSequence)tgtId)) {
            LOGGER.trace("No ticket-granting ticket could be located in the webflow context");
            return false;
        }
        try {
            Ticket ticket = this.centralAuthenticationService.getTicket(tgtId, Ticket.class);
            if (ticket != null && !ticket.isExpired()) {
                LOGGER.trace("Located a valid ticket-granting ticket, honoring existing single sign-on session");
                return true;
            }
        }
        catch (AbstractTicketException e) {
            LOGGER.trace("Could not retrieve ticket id [{}] from registry.", (Object)e.getMessage());
        }
        LOGGER.trace("Ticket-granting ticket found in the webflow context is invalid or has expired");
        return false;
    }

    @Generated
    public Clients getClients() {
        return this.clients;
    }

    @Generated
    public ServicesManager getServicesManager() {
        return this.servicesManager;
    }

    @Generated
    public AuditableExecution getDelegatedAuthenticationPolicyEnforcer() {
        return this.delegatedAuthenticationPolicyEnforcer;
    }

    @Generated
    public DelegatedClientWebflowManager getDelegatedClientWebflowManager() {
        return this.delegatedClientWebflowManager;
    }

    @Generated
    public DelegatedSessionCookieManager getDelegatedSessionCookieManager() {
        return this.delegatedSessionCookieManager;
    }

    @Generated
    public AuthenticationSystemSupport getAuthenticationSystemSupport() {
        return this.authenticationSystemSupport;
    }

    @Generated
    public String getLocaleParamName() {
        return this.localeParamName;
    }

    @Generated
    public String getThemeParamName() {
        return this.themeParamName;
    }

    @Generated
    public AuthenticationServiceSelectionPlan getAuthenticationRequestServiceSelectionStrategies() {
        return this.authenticationRequestServiceSelectionStrategies;
    }

    @Generated
    public CentralAuthenticationService getCentralAuthenticationService() {
        return this.centralAuthenticationService;
    }

    private /* synthetic */ void lambda$prepareForLoginPage$1(WebContext webContext, WebApplicationService currentService, Set urls, IndirectClient client) {
        try {
            Optional<ProviderLoginPageConfiguration> provider = this.buildProviderConfiguration(client, webContext, currentService);
            provider.ifPresent(urls::add);
        }
        catch (Exception e) {
            LOGGER.error("Cannot process client [{}]", (Object)client, (Object)e);
        }
    }

    public static class ProviderLoginPageConfiguration
    implements Serializable {
        private static final long serialVersionUID = 6216882278086699364L;
        private final String name;
        private final String redirectUrl;
        private final String type;
        private final String cssClass;
        private final boolean autoRedirect;

        @Generated
        public ProviderLoginPageConfiguration(String name, String redirectUrl, String type, String cssClass, boolean autoRedirect) {
            this.name = name;
            this.redirectUrl = redirectUrl;
            this.type = type;
            this.cssClass = cssClass;
            this.autoRedirect = autoRedirect;
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public String getRedirectUrl() {
            return this.redirectUrl;
        }

        @Generated
        public String getType() {
            return this.type;
        }

        @Generated
        public String getCssClass() {
            return this.cssClass;
        }

        @Generated
        public boolean isAutoRedirect() {
            return this.autoRedirect;
        }

        @Generated
        public String toString() {
            return "DelegatedClientAuthenticationAction.ProviderLoginPageConfiguration(name=" + this.name + ", redirectUrl=" + this.redirectUrl + ", type=" + this.type + ", cssClass=" + this.cssClass + ", autoRedirect=" + this.autoRedirect + ")";
        }
    }
}

