/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.saml2;

import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import lombok.Generated;
import org.apache.commons.io.FileUtils;
import org.apereo.cas.support.saml.OpenSamlConfigBean;
import org.apereo.cas.support.saml.SamlUtils;
import org.opensaml.core.xml.XMLObject;
import org.pac4j.core.client.Clients;
import org.pac4j.saml.client.SAML2Client;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller(value="saml2ClientMetadataController")
@RequestMapping
public class Saml2ClientMetadataController {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(Saml2ClientMetadataController.class);
    private final Clients builtClients;
    private final OpenSamlConfigBean openSamlConfigBean;

    @GetMapping(value={"/sp/metadata"})
    public ResponseEntity<String> getFirstServiceProviderMetadata() {
        SAML2Client saml2Client = (SAML2Client)this.builtClients.findClient(SAML2Client.class);
        if (saml2Client != null) {
            return Saml2ClientMetadataController.getSaml2ClientServiceProviderMetadataResponseEntity(saml2Client);
        }
        return Saml2ClientMetadataController.getNotAcceptableResponseEntity();
    }

    @GetMapping(value={"/sp/idp/metadata"})
    public ResponseEntity<String> getFirstIdentityProviderMetadata() {
        SAML2Client saml2Client = (SAML2Client)this.builtClients.findClient(SAML2Client.class);
        if (saml2Client != null) {
            return this.getSaml2ClientIdentityProviderMetadataResponseEntity(saml2Client);
        }
        return Saml2ClientMetadataController.getNotAcceptableResponseEntity();
    }

    @GetMapping(value={"/sp/{client}/metadata"})
    public ResponseEntity<String> getServiceProviderMetadataByName(@PathVariable(value="client") String client) {
        SAML2Client saml2Client = (SAML2Client)this.builtClients.findClient(client);
        if (saml2Client != null) {
            return Saml2ClientMetadataController.getSaml2ClientServiceProviderMetadataResponseEntity(saml2Client);
        }
        return Saml2ClientMetadataController.getNotAcceptableResponseEntity();
    }

    @GetMapping(value={"/sp/{client}/idp/metadata"})
    public ResponseEntity<String> getIdentityProviderMetadataByName(@PathVariable(value="client") String client) {
        SAML2Client saml2Client = (SAML2Client)this.builtClients.findClient(client);
        if (saml2Client != null) {
            saml2Client.init();
            return this.getSaml2ClientIdentityProviderMetadataResponseEntity(saml2Client);
        }
        return Saml2ClientMetadataController.getNotAcceptableResponseEntity();
    }

    private static ResponseEntity<String> getSaml2ClientServiceProviderMetadataResponseEntity(SAML2Client saml2Client) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_XML);
        saml2Client.init();
        String md = FileUtils.readFileToString((File)saml2Client.getConfiguration().getServiceProviderMetadataResource().getFile(), (Charset)StandardCharsets.UTF_8);
        return new ResponseEntity((Object)md, (MultiValueMap)headers, HttpStatus.OK);
    }

    private ResponseEntity<String> getSaml2ClientIdentityProviderMetadataResponseEntity(SAML2Client saml2Client) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_XML);
        saml2Client.getIdentityProviderMetadataResolver().resolve();
        XMLObject entity = saml2Client.getIdentityProviderMetadataResolver().getEntityDescriptorElement();
        String metadata = SamlUtils.transformSamlObject((OpenSamlConfigBean)this.openSamlConfigBean, (XMLObject)entity).toString();
        return new ResponseEntity((Object)metadata, (MultiValueMap)headers, HttpStatus.OK);
    }

    private static ResponseEntity<String> getNotAcceptableResponseEntity() {
        return new ResponseEntity(HttpStatus.NOT_ACCEPTABLE);
    }

    @Generated
    public Saml2ClientMetadataController(Clients builtClients, OpenSamlConfigBean openSamlConfigBean) {
        this.builtClients = builtClients;
        this.openSamlConfigBean = openSamlConfigBean;
    }
}

