/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api;

import org.assertj.core.annotation.CanIgnoreReturnValue;
import org.assertj.core.internal.Failures;
import org.assertj.core.internal.annotation.Contract;

public final class Fail {
    public static void setRemoveAssertJRelatedElementsFromStackTrace(boolean removeAssertJRelatedElementsFromStackTrace) {
        Failures.instance().setRemoveAssertJRelatedElementsFromStackTrace(removeAssertJRelatedElementsFromStackTrace);
    }

    @CanIgnoreReturnValue
    @Contract(value="_ -> fail")
    public static <T> T fail(String failureMessage) {
        throw Failures.instance().failure(failureMessage);
    }

    @CanIgnoreReturnValue
    @Contract(value=" -> fail")
    public static <T> T fail() {
        return Fail.fail("");
    }

    @CanIgnoreReturnValue
    @Contract(value="_, _ -> fail")
    public static <T> T fail(String failureMessage, Object ... args) {
        return Fail.fail(String.format(failureMessage, args));
    }

    @CanIgnoreReturnValue
    @Contract(value="_, _ -> fail")
    public static <T> T fail(String failureMessage, Throwable realCause) {
        AssertionError error = Failures.instance().failure(failureMessage);
        ((Throwable)((Object)error)).initCause(realCause);
        throw error;
    }

    @CanIgnoreReturnValue
    @Contract(value="_ -> fail")
    public static <T> T fail(Throwable realCause) {
        return Fail.fail(null, realCause);
    }

    @CanIgnoreReturnValue
    @Contract(value="_ -> fail")
    public static <T> T failBecauseExceptionWasNotThrown(Class<? extends Throwable> throwableClass) {
        return Fail.shouldHaveThrown(throwableClass);
    }

    @CanIgnoreReturnValue
    @Contract(value="_ -> fail")
    public static <T> T shouldHaveThrown(Class<? extends Throwable> throwableClass) {
        throw Failures.instance().expectedThrowableNotThrown(throwableClass);
    }

    private Fail() {
    }
}

