/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api;

import java.util.function.Predicate;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.error.ShouldAccept;
import org.assertj.core.error.ShouldNotAccept;
import org.assertj.core.internal.Iterables;
import org.assertj.core.presentation.PredicateDescription;
import org.assertj.core.util.Lists;
import org.assertj.core.util.VisibleForTesting;

public abstract class AbstractPredicateAssert<SELF extends AbstractPredicateAssert<SELF, T>, T>
extends AbstractAssert<SELF, Predicate<T>> {
    @VisibleForTesting
    Iterables iterables = Iterables.instance();

    protected AbstractPredicateAssert(Predicate<T> actual, Class<?> selfType) {
        super(actual, selfType);
    }

    public SELF accepts(T ... values) {
        this.isNotNull();
        if (values.length == 1 && !((Predicate)this.actual).test(values[0])) {
            this.throwAssertionError(ShouldAccept.shouldAccept((Predicate)this.actual, values[0], PredicateDescription.GIVEN));
        } else {
            this.iterables.assertAllMatch(this.info, Lists.newArrayList(values), (Predicate)this.actual);
        }
        return (SELF)((AbstractPredicateAssert)this.myself);
    }

    public SELF rejects(T ... values) {
        this.isNotNull();
        if (values.length == 1 && ((Predicate)this.actual).test(values[0])) {
            this.throwAssertionError(ShouldNotAccept.shouldNotAccept((Predicate)this.actual, values[0], PredicateDescription.GIVEN));
        } else {
            this.iterables.assertNoneMatch(this.info, Lists.newArrayList(values), (Predicate)this.actual);
        }
        return (SELF)((AbstractPredicateAssert)this.myself);
    }

    public SELF acceptsAll(Iterable<? extends T> iterable) {
        this.isNotNull();
        this.iterables.assertAllMatch(this.info, iterable, (Predicate)this.actual);
        return (SELF)((AbstractPredicateAssert)this.myself);
    }

    public SELF rejectsAll(Iterable<? extends T> iterable) {
        this.isNotNull();
        this.iterables.assertNoneMatch(this.info, iterable, (Predicate)this.actual);
        return (SELF)((AbstractPredicateAssert)this.myself);
    }
}

