// Targeted by JavaCPP version 1.5.1: DO NOT EDIT THIS FILE

package org.bytedeco.openblas.global;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.openblas.global.openblas_nolapack.*;

public class openblas extends org.bytedeco.openblas.presets.openblas {
    static { Loader.load(); }

// Parsed from openblas_config.h

// #ifndef OPENBLAS_CONFIG_H
// #define OPENBLAS_CONFIG_H
public static final int OPENBLAS_OS_DARWIN = 1;
public static final int OPENBLAS_ARCH_X86_64 = 1;
public static final int OPENBLAS_C_GCC = 1;
public static final int OPENBLAS___64BIT__ = 1;
// #define OPENBLAS_FUNDERSCORE _
// #define OPENBLAS_PTHREAD_CREATE_FUNC pthread_create
// #define OPENBLAS_BUNDERSCORE _
public static final int OPENBLAS_NEEDBUNDERSCORE = 1;
// #define OPENBLAS_GENERIC 
public static final int OPENBLAS_L1_DATA_SIZE = 32768;
public static final int OPENBLAS_L1_DATA_LINESIZE = 128;
public static final int OPENBLAS_L2_SIZE = 512488;
public static final int OPENBLAS_L2_LINESIZE = 128;
public static final int OPENBLAS_DTB_DEFAULT_ENTRIES = 128;
public static final int OPENBLAS_DTB_SIZE = 4096;
public static final int OPENBLAS_L2_ASSOCIATIVE = 8;
// #define OPENBLAS_CORE_generic 
public static final String OPENBLAS_CHAR_CORENAME = "generic";
public static final int OPENBLAS_SLOCAL_BUFFER_SIZE = 4096;
public static final int OPENBLAS_DLOCAL_BUFFER_SIZE = 4096;
public static final int OPENBLAS_CLOCAL_BUFFER_SIZE = 8192;
public static final int OPENBLAS_ZLOCAL_BUFFER_SIZE = 8192;
public static final int OPENBLAS_GEMM_MULTITHREAD_THRESHOLD = 4;
public static final String OPENBLAS_VERSION = " OpenBLAS 0.3.6 ";
/*This is only for "make install" target.*/

// #if defined(OPENBLAS_OS_WINNT) || defined(OPENBLAS_OS_CYGWIN_NT) || defined(OPENBLAS_OS_INTERIX)
// #define OPENBLAS_WINDOWS_ABI
// #define OPENBLAS_OS_WINDOWS

// #ifdef DOUBLE
// #define DOUBLE_DEFINED DOUBLE
// #undef  DOUBLE
// #endif
// #endif

// #ifdef OPENBLAS_NEEDBUNDERSCORE
// #define BLASFUNC(FUNC) FUNC##_
// #else
// #endif

// #ifdef OPENBLAS_QUAD_PRECISION
// #elif defined OPENBLAS_EXPRECISION
// #else
// #define xdouble double
// #endif

// #if defined(OPENBLAS_OS_WINDOWS) && defined(OPENBLAS___64BIT__)
// #else
// #endif

// #ifdef OPENBLAS_USE64BITINT
// #else
// #endif

// #if defined(XDOUBLE) || defined(DOUBLE)
// #define FLOATRET	FLOAT
// #else
// #ifdef NEED_F2CCONV
// #define FLOATRET	double
// #else
// #define FLOATRET	float
// #endif
// #endif

/* Inclusion of a standard header file is needed for definition of __STDC_*
   predefined macros with some compilers (e.g. GCC 4.7 on Linux).  This occurs
   as a side effect of including either <features.h> or <stdc-predef.h>. */
// #include <stdio.h>

/* C99 supports complex floating numbers natively, which GCC also offers as an
   extension since version 3.0.  If neither are available, use a compatible
   structure as fallback (see Clause 6.2.5.13 of the C99 standard). */
// #if ((defined(__STDC_IEC_559_COMPLEX__) || __STDC_VERSION__ >= 199901L ||
//       (__GNUC__ >= 3 && !defined(__cplusplus))) && !(defined(FORCE_OPENBLAS_COMPLEX_STRUCT))) && !defined(_MSC_VER)
//   #define OPENBLAS_COMPLEX_C99
// #ifndef __cplusplus
//   #include <complex.h>
// #endif
//   #define openblas_make_complex_float(real, imag)    ((real) + ((imag) * _Complex_I))
//   #define openblas_make_complex_double(real, imag)   ((real) + ((imag) * _Complex_I))
//   #define openblas_make_complex_xdouble(real, imag)  ((real) + ((imag) * _Complex_I))
//   #define openblas_complex_float_real(z)             (creal(z))
//   #define openblas_complex_float_imag(z)             (cimag(z))
//   #define openblas_complex_double_real(z)            (creal(z))
//   #define openblas_complex_double_imag(z)            (cimag(z))
//   #define openblas_complex_xdouble_real(z)           (creal(z))
//   #define openblas_complex_xdouble_imag(z)           (cimag(z))
// #else
// #endif
// #endif /* OPENBLAS_CONFIG_H */


// Parsed from cblas.h

// #ifndef CBLAS_H
// #define CBLAS_H

// #include <stddef.h>
// #include "openblas_config.h"

// #ifdef __cplusplus
	/* Assume C declarations for C++ */
// #endif  /* __cplusplus */

/*Set the number of threads on runtime.*/



/*Get the number of threads on runtime.*/


/*Get the number of physical processors (cores).*/


/*Get the build configure on runtime.*/


/*Get the CPU corename on runtime.*/


/* Get the parallelization type which is used by OpenBLAS */

/* OpenBLAS is compiled for sequential use  */
public static final int OPENBLAS_SEQUENTIAL =  0;
/* OpenBLAS is compiled using normal threading model */
public static final int OPENBLAS_THREAD =  1;
/* OpenBLAS is compiled using OpenMP threading model */
public static final int OPENBLAS_OPENMP = 2;


/*
 * Since all of GotoBlas was written without const,
 * we disable it at build time.
 */
// #ifndef OPENBLAS_CONST
// # define OPENBLAS_CONST const
// #endif


// #define CBLAS_INDEX size_t

/** enum CBLAS_ORDER */
public static final int CblasRowMajor = 101, CblasColMajor = 102;
/** enum CBLAS_TRANSPOSE */
public static final int CblasNoTrans = 111, CblasTrans = 112, CblasConjTrans = 113, CblasConjNoTrans = 114;
/** enum CBLAS_UPLO */
public static final int CblasUpper = 121, CblasLower = 122;
/** enum CBLAS_DIAG */
public static final int CblasNonUnit = 131, CblasUnit = 132;
/** enum CBLAS_SIDE */
public static final int CblasLeft = 141, CblasRight = 142;
	
public static native float cblas_sdsdot(@Cast("const blasint") int n, float alpha, @Const FloatPointer x, @Cast("const blasint") int incx, @Const FloatPointer y, @Cast("const blasint") int incy);
public static native float cblas_sdsdot(@Cast("const blasint") int n, float alpha, @Const FloatBuffer x, @Cast("const blasint") int incx, @Const FloatBuffer y, @Cast("const blasint") int incy);
public static native float cblas_sdsdot(@Cast("const blasint") int n, float alpha, @Const float[] x, @Cast("const blasint") int incx, @Const float[] y, @Cast("const blasint") int incy);
public static native double cblas_dsdot(@Cast("const blasint") int n, @Const FloatPointer x, @Cast("const blasint") int incx, @Const FloatPointer y, @Cast("const blasint") int incy);
public static native double cblas_dsdot(@Cast("const blasint") int n, @Const FloatBuffer x, @Cast("const blasint") int incx, @Const FloatBuffer y, @Cast("const blasint") int incy);
public static native double cblas_dsdot(@Cast("const blasint") int n, @Const float[] x, @Cast("const blasint") int incx, @Const float[] y, @Cast("const blasint") int incy);
public static native float cblas_sdot(@Cast("const blasint") int n, @Const FloatPointer x, @Cast("const blasint") int incx, @Const FloatPointer y, @Cast("const blasint") int incy);
public static native float cblas_sdot(@Cast("const blasint") int n, @Const FloatBuffer x, @Cast("const blasint") int incx, @Const FloatBuffer y, @Cast("const blasint") int incy);
public static native float cblas_sdot(@Cast("const blasint") int n, @Const float[] x, @Cast("const blasint") int incx, @Const float[] y, @Cast("const blasint") int incy);
public static native double cblas_ddot(@Cast("const blasint") int n, @Const DoublePointer x, @Cast("const blasint") int incx, @Const DoublePointer y, @Cast("const blasint") int incy);
public static native double cblas_ddot(@Cast("const blasint") int n, @Const DoubleBuffer x, @Cast("const blasint") int incx, @Const DoubleBuffer y, @Cast("const blasint") int incy);
public static native double cblas_ddot(@Cast("const blasint") int n, @Const double[] x, @Cast("const blasint") int incx, @Const double[] y, @Cast("const blasint") int incy);






public static native void cblas_cdotu_sub(@Cast("const blasint") int n, @Const Pointer x, @Cast("const blasint") int incx, @Const Pointer y, @Cast("const blasint") int incy, Pointer ret);
public static native void cblas_cdotc_sub(@Cast("const blasint") int n, @Const Pointer x, @Cast("const blasint") int incx, @Const Pointer y, @Cast("const blasint") int incy, Pointer ret);
public static native void cblas_zdotu_sub(@Cast("const blasint") int n, @Const Pointer x, @Cast("const blasint") int incx, @Const Pointer y, @Cast("const blasint") int incy, Pointer ret);
public static native void cblas_zdotc_sub(@Cast("const blasint") int n, @Const Pointer x, @Cast("const blasint") int incx, @Const Pointer y, @Cast("const blasint") int incy, Pointer ret);

public static native float cblas_sasum(@Cast("const blasint") int n, @Const FloatPointer x, @Cast("const blasint") int incx);
public static native float cblas_sasum(@Cast("const blasint") int n, @Const FloatBuffer x, @Cast("const blasint") int incx);
public static native float cblas_sasum(@Cast("const blasint") int n, @Const float[] x, @Cast("const blasint") int incx);
public static native double cblas_dasum(@Cast("const blasint") int n, @Const DoublePointer x, @Cast("const blasint") int incx);
public static native double cblas_dasum(@Cast("const blasint") int n, @Const DoubleBuffer x, @Cast("const blasint") int incx);
public static native double cblas_dasum(@Cast("const blasint") int n, @Const double[] x, @Cast("const blasint") int incx);
public static native float cblas_scasum(@Cast("const blasint") int n, @Const Pointer x, @Cast("const blasint") int incx);
public static native double cblas_dzasum(@Cast("const blasint") int n, @Const Pointer x, @Cast("const blasint") int incx);






public static native float cblas_snrm2(@Cast("const blasint") int N, @Const FloatPointer X, @Cast("const blasint") int incX);
public static native float cblas_snrm2(@Cast("const blasint") int N, @Const FloatBuffer X, @Cast("const blasint") int incX);
public static native float cblas_snrm2(@Cast("const blasint") int N, @Const float[] X, @Cast("const blasint") int incX);
public static native double cblas_dnrm2(@Cast("const blasint") int N, @Const DoublePointer X, @Cast("const blasint") int incX);
public static native double cblas_dnrm2(@Cast("const blasint") int N, @Const DoubleBuffer X, @Cast("const blasint") int incX);
public static native double cblas_dnrm2(@Cast("const blasint") int N, @Const double[] X, @Cast("const blasint") int incX);
public static native float cblas_scnrm2(@Cast("const blasint") int N, @Const Pointer X, @Cast("const blasint") int incX);
public static native double cblas_dznrm2(@Cast("const blasint") int N, @Const Pointer X, @Cast("const blasint") int incX);

public static native @Cast("size_t") long cblas_isamax(@Cast("const blasint") int n, @Const FloatPointer x, @Cast("const blasint") int incx);
public static native @Cast("size_t") long cblas_isamax(@Cast("const blasint") int n, @Const FloatBuffer x, @Cast("const blasint") int incx);
public static native @Cast("size_t") long cblas_isamax(@Cast("const blasint") int n, @Const float[] x, @Cast("const blasint") int incx);
public static native @Cast("size_t") long cblas_idamax(@Cast("const blasint") int n, @Const DoublePointer x, @Cast("const blasint") int incx);
public static native @Cast("size_t") long cblas_idamax(@Cast("const blasint") int n, @Const DoubleBuffer x, @Cast("const blasint") int incx);
public static native @Cast("size_t") long cblas_idamax(@Cast("const blasint") int n, @Const double[] x, @Cast("const blasint") int incx);
public static native @Cast("size_t") long cblas_icamax(@Cast("const blasint") int n, @Const Pointer x, @Cast("const blasint") int incx);
public static native @Cast("size_t") long cblas_izamax(@Cast("const blasint") int n, @Const Pointer x, @Cast("const blasint") int incx);
















public static native void cblas_saxpy(@Cast("const blasint") int n, float alpha, @Const FloatPointer x, @Cast("const blasint") int incx, FloatPointer y, @Cast("const blasint") int incy);
public static native void cblas_saxpy(@Cast("const blasint") int n, float alpha, @Const FloatBuffer x, @Cast("const blasint") int incx, FloatBuffer y, @Cast("const blasint") int incy);
public static native void cblas_saxpy(@Cast("const blasint") int n, float alpha, @Const float[] x, @Cast("const blasint") int incx, float[] y, @Cast("const blasint") int incy);
public static native void cblas_daxpy(@Cast("const blasint") int n, double alpha, @Const DoublePointer x, @Cast("const blasint") int incx, DoublePointer y, @Cast("const blasint") int incy);
public static native void cblas_daxpy(@Cast("const blasint") int n, double alpha, @Const DoubleBuffer x, @Cast("const blasint") int incx, DoubleBuffer y, @Cast("const blasint") int incy);
public static native void cblas_daxpy(@Cast("const blasint") int n, double alpha, @Const double[] x, @Cast("const blasint") int incx, double[] y, @Cast("const blasint") int incy);
public static native void cblas_caxpy(@Cast("const blasint") int n, @Const Pointer alpha, @Const Pointer x, @Cast("const blasint") int incx, Pointer y, @Cast("const blasint") int incy);
public static native void cblas_zaxpy(@Cast("const blasint") int n, @Const Pointer alpha, @Const Pointer x, @Cast("const blasint") int incx, Pointer y, @Cast("const blasint") int incy);

public static native void cblas_scopy(@Cast("const blasint") int n, @Const FloatPointer x, @Cast("const blasint") int incx, FloatPointer y, @Cast("const blasint") int incy);
public static native void cblas_scopy(@Cast("const blasint") int n, @Const FloatBuffer x, @Cast("const blasint") int incx, FloatBuffer y, @Cast("const blasint") int incy);
public static native void cblas_scopy(@Cast("const blasint") int n, @Const float[] x, @Cast("const blasint") int incx, float[] y, @Cast("const blasint") int incy);
public static native void cblas_dcopy(@Cast("const blasint") int n, @Const DoublePointer x, @Cast("const blasint") int incx, DoublePointer y, @Cast("const blasint") int incy);
public static native void cblas_dcopy(@Cast("const blasint") int n, @Const DoubleBuffer x, @Cast("const blasint") int incx, DoubleBuffer y, @Cast("const blasint") int incy);
public static native void cblas_dcopy(@Cast("const blasint") int n, @Const double[] x, @Cast("const blasint") int incx, double[] y, @Cast("const blasint") int incy);
public static native void cblas_ccopy(@Cast("const blasint") int n, @Const Pointer x, @Cast("const blasint") int incx, Pointer y, @Cast("const blasint") int incy);
public static native void cblas_zcopy(@Cast("const blasint") int n, @Const Pointer x, @Cast("const blasint") int incx, Pointer y, @Cast("const blasint") int incy);

public static native void cblas_sswap(@Cast("const blasint") int n, FloatPointer x, @Cast("const blasint") int incx, FloatPointer y, @Cast("const blasint") int incy);
public static native void cblas_sswap(@Cast("const blasint") int n, FloatBuffer x, @Cast("const blasint") int incx, FloatBuffer y, @Cast("const blasint") int incy);
public static native void cblas_sswap(@Cast("const blasint") int n, float[] x, @Cast("const blasint") int incx, float[] y, @Cast("const blasint") int incy);
public static native void cblas_dswap(@Cast("const blasint") int n, DoublePointer x, @Cast("const blasint") int incx, DoublePointer y, @Cast("const blasint") int incy);
public static native void cblas_dswap(@Cast("const blasint") int n, DoubleBuffer x, @Cast("const blasint") int incx, DoubleBuffer y, @Cast("const blasint") int incy);
public static native void cblas_dswap(@Cast("const blasint") int n, double[] x, @Cast("const blasint") int incx, double[] y, @Cast("const blasint") int incy);
public static native void cblas_cswap(@Cast("const blasint") int n, Pointer x, @Cast("const blasint") int incx, Pointer y, @Cast("const blasint") int incy);
public static native void cblas_zswap(@Cast("const blasint") int n, Pointer x, @Cast("const blasint") int incx, Pointer y, @Cast("const blasint") int incy);

public static native void cblas_srot(@Cast("const blasint") int N, FloatPointer X, @Cast("const blasint") int incX, FloatPointer Y, @Cast("const blasint") int incY, float c, float s);
public static native void cblas_srot(@Cast("const blasint") int N, FloatBuffer X, @Cast("const blasint") int incX, FloatBuffer Y, @Cast("const blasint") int incY, float c, float s);
public static native void cblas_srot(@Cast("const blasint") int N, float[] X, @Cast("const blasint") int incX, float[] Y, @Cast("const blasint") int incY, float c, float s);
public static native void cblas_drot(@Cast("const blasint") int N, DoublePointer X, @Cast("const blasint") int incX, DoublePointer Y, @Cast("const blasint") int incY, double c, double s);
public static native void cblas_drot(@Cast("const blasint") int N, DoubleBuffer X, @Cast("const blasint") int incX, DoubleBuffer Y, @Cast("const blasint") int incY, double c, double s);
public static native void cblas_drot(@Cast("const blasint") int N, double[] X, @Cast("const blasint") int incX, double[] Y, @Cast("const blasint") int incY, double c, double s);

public static native void cblas_srotg(FloatPointer a, FloatPointer b, FloatPointer c, FloatPointer s);
public static native void cblas_srotg(FloatBuffer a, FloatBuffer b, FloatBuffer c, FloatBuffer s);
public static native void cblas_srotg(float[] a, float[] b, float[] c, float[] s);
public static native void cblas_drotg(DoublePointer a, DoublePointer b, DoublePointer c, DoublePointer s);
public static native void cblas_drotg(DoubleBuffer a, DoubleBuffer b, DoubleBuffer c, DoubleBuffer s);
public static native void cblas_drotg(double[] a, double[] b, double[] c, double[] s);

public static native void cblas_srotm(@Cast("const blasint") int N, FloatPointer X, @Cast("const blasint") int incX, FloatPointer Y, @Cast("const blasint") int incY, @Const FloatPointer P);
public static native void cblas_srotm(@Cast("const blasint") int N, FloatBuffer X, @Cast("const blasint") int incX, FloatBuffer Y, @Cast("const blasint") int incY, @Const FloatBuffer P);
public static native void cblas_srotm(@Cast("const blasint") int N, float[] X, @Cast("const blasint") int incX, float[] Y, @Cast("const blasint") int incY, @Const float[] P);
public static native void cblas_drotm(@Cast("const blasint") int N, DoublePointer X, @Cast("const blasint") int incX, DoublePointer Y, @Cast("const blasint") int incY, @Const DoublePointer P);
public static native void cblas_drotm(@Cast("const blasint") int N, DoubleBuffer X, @Cast("const blasint") int incX, DoubleBuffer Y, @Cast("const blasint") int incY, @Const DoubleBuffer P);
public static native void cblas_drotm(@Cast("const blasint") int N, double[] X, @Cast("const blasint") int incX, double[] Y, @Cast("const blasint") int incY, @Const double[] P);

public static native void cblas_srotmg(FloatPointer d1, FloatPointer d2, FloatPointer b1, float b2, FloatPointer P);
public static native void cblas_srotmg(FloatBuffer d1, FloatBuffer d2, FloatBuffer b1, float b2, FloatBuffer P);
public static native void cblas_srotmg(float[] d1, float[] d2, float[] b1, float b2, float[] P);
public static native void cblas_drotmg(DoublePointer d1, DoublePointer d2, DoublePointer b1, double b2, DoublePointer P);
public static native void cblas_drotmg(DoubleBuffer d1, DoubleBuffer d2, DoubleBuffer b1, double b2, DoubleBuffer P);
public static native void cblas_drotmg(double[] d1, double[] d2, double[] b1, double b2, double[] P);

public static native void cblas_sscal(@Cast("const blasint") int N, float alpha, FloatPointer X, @Cast("const blasint") int incX);
public static native void cblas_sscal(@Cast("const blasint") int N, float alpha, FloatBuffer X, @Cast("const blasint") int incX);
public static native void cblas_sscal(@Cast("const blasint") int N, float alpha, float[] X, @Cast("const blasint") int incX);
public static native void cblas_dscal(@Cast("const blasint") int N, double alpha, DoublePointer X, @Cast("const blasint") int incX);
public static native void cblas_dscal(@Cast("const blasint") int N, double alpha, DoubleBuffer X, @Cast("const blasint") int incX);
public static native void cblas_dscal(@Cast("const blasint") int N, double alpha, double[] X, @Cast("const blasint") int incX);
public static native void cblas_cscal(@Cast("const blasint") int N, @Const Pointer alpha, Pointer X, @Cast("const blasint") int incX);
public static native void cblas_zscal(@Cast("const blasint") int N, @Const Pointer alpha, Pointer X, @Cast("const blasint") int incX);
public static native void cblas_csscal(@Cast("const blasint") int N, float alpha, Pointer X, @Cast("const blasint") int incX);
public static native void cblas_zdscal(@Cast("const blasint") int N, double alpha, Pointer X, @Cast("const blasint") int incX);

public static native void cblas_sgemv(@Cast("const CBLAS_ORDER") int order,  @Cast("const CBLAS_TRANSPOSE") int trans,  @Cast("const blasint") int m, @Cast("const blasint") int n,
		 float alpha, @Const FloatPointer a, @Cast("const blasint") int lda,  @Const FloatPointer x, @Cast("const blasint") int incx,  float beta,  FloatPointer y, @Cast("const blasint") int incy);
public static native void cblas_sgemv(@Cast("const CBLAS_ORDER") int order,  @Cast("const CBLAS_TRANSPOSE") int trans,  @Cast("const blasint") int m, @Cast("const blasint") int n,
		 float alpha, @Const FloatBuffer a, @Cast("const blasint") int lda,  @Const FloatBuffer x, @Cast("const blasint") int incx,  float beta,  FloatBuffer y, @Cast("const blasint") int incy);
public static native void cblas_sgemv(@Cast("const CBLAS_ORDER") int order,  @Cast("const CBLAS_TRANSPOSE") int trans,  @Cast("const blasint") int m, @Cast("const blasint") int n,
		 float alpha, @Const float[] a, @Cast("const blasint") int lda,  @Const float[] x, @Cast("const blasint") int incx,  float beta,  float[] y, @Cast("const blasint") int incy);
public static native void cblas_dgemv(@Cast("const CBLAS_ORDER") int order,  @Cast("const CBLAS_TRANSPOSE") int trans,  @Cast("const blasint") int m, @Cast("const blasint") int n,
		 double alpha, @Const DoublePointer a, @Cast("const blasint") int lda,  @Const DoublePointer x, @Cast("const blasint") int incx,  double beta,  DoublePointer y, @Cast("const blasint") int incy);
public static native void cblas_dgemv(@Cast("const CBLAS_ORDER") int order,  @Cast("const CBLAS_TRANSPOSE") int trans,  @Cast("const blasint") int m, @Cast("const blasint") int n,
		 double alpha, @Const DoubleBuffer a, @Cast("const blasint") int lda,  @Const DoubleBuffer x, @Cast("const blasint") int incx,  double beta,  DoubleBuffer y, @Cast("const blasint") int incy);
public static native void cblas_dgemv(@Cast("const CBLAS_ORDER") int order,  @Cast("const CBLAS_TRANSPOSE") int trans,  @Cast("const blasint") int m, @Cast("const blasint") int n,
		 double alpha, @Const double[] a, @Cast("const blasint") int lda,  @Const double[] x, @Cast("const blasint") int incx,  double beta,  double[] y, @Cast("const blasint") int incy);
public static native void cblas_cgemv(@Cast("const CBLAS_ORDER") int order,  @Cast("const CBLAS_TRANSPOSE") int trans,  @Cast("const blasint") int m, @Cast("const blasint") int n,
		 @Const Pointer alpha, @Const Pointer a, @Cast("const blasint") int lda,  @Const Pointer x, @Cast("const blasint") int incx,  @Const Pointer beta,  Pointer y, @Cast("const blasint") int incy);
public static native void cblas_zgemv(@Cast("const CBLAS_ORDER") int order,  @Cast("const CBLAS_TRANSPOSE") int trans,  @Cast("const blasint") int m, @Cast("const blasint") int n,
		 @Const Pointer alpha, @Const Pointer a, @Cast("const blasint") int lda,  @Const Pointer x, @Cast("const blasint") int incx,  @Const Pointer beta,  Pointer y, @Cast("const blasint") int incy);

public static native void cblas_sger(@Cast("const CBLAS_ORDER") int order, @Cast("const blasint") int M, @Cast("const blasint") int N, float alpha, @Const FloatPointer X, @Cast("const blasint") int incX, @Const FloatPointer Y, @Cast("const blasint") int incY, FloatPointer A, @Cast("const blasint") int lda);
public static native void cblas_sger(@Cast("const CBLAS_ORDER") int order, @Cast("const blasint") int M, @Cast("const blasint") int N, float alpha, @Const FloatBuffer X, @Cast("const blasint") int incX, @Const FloatBuffer Y, @Cast("const blasint") int incY, FloatBuffer A, @Cast("const blasint") int lda);
public static native void cblas_sger(@Cast("const CBLAS_ORDER") int order, @Cast("const blasint") int M, @Cast("const blasint") int N, float alpha, @Const float[] X, @Cast("const blasint") int incX, @Const float[] Y, @Cast("const blasint") int incY, float[] A, @Cast("const blasint") int lda);
public static native void cblas_dger(@Cast("const CBLAS_ORDER") int order, @Cast("const blasint") int M, @Cast("const blasint") int N, double alpha, @Const DoublePointer X, @Cast("const blasint") int incX, @Const DoublePointer Y, @Cast("const blasint") int incY, DoublePointer A, @Cast("const blasint") int lda);
public static native void cblas_dger(@Cast("const CBLAS_ORDER") int order, @Cast("const blasint") int M, @Cast("const blasint") int N, double alpha, @Const DoubleBuffer X, @Cast("const blasint") int incX, @Const DoubleBuffer Y, @Cast("const blasint") int incY, DoubleBuffer A, @Cast("const blasint") int lda);
public static native void cblas_dger(@Cast("const CBLAS_ORDER") int order, @Cast("const blasint") int M, @Cast("const blasint") int N, double alpha, @Const double[] X, @Cast("const blasint") int incX, @Const double[] Y, @Cast("const blasint") int incY, double[] A, @Cast("const blasint") int lda);
public static native void cblas_cgeru(@Cast("const CBLAS_ORDER") int order, @Cast("const blasint") int M, @Cast("const blasint") int N, @Const Pointer alpha, @Const Pointer X, @Cast("const blasint") int incX, @Const Pointer Y, @Cast("const blasint") int incY, Pointer A, @Cast("const blasint") int lda);
public static native void cblas_cgerc(@Cast("const CBLAS_ORDER") int order, @Cast("const blasint") int M, @Cast("const blasint") int N, @Const Pointer alpha, @Const Pointer X, @Cast("const blasint") int incX, @Const Pointer Y, @Cast("const blasint") int incY, Pointer A, @Cast("const blasint") int lda);
public static native void cblas_zgeru(@Cast("const CBLAS_ORDER") int order, @Cast("const blasint") int M, @Cast("const blasint") int N, @Const Pointer alpha, @Const Pointer X, @Cast("const blasint") int incX, @Const Pointer Y, @Cast("const blasint") int incY, Pointer A, @Cast("const blasint") int lda);
public static native void cblas_zgerc(@Cast("const CBLAS_ORDER") int order, @Cast("const blasint") int M, @Cast("const blasint") int N, @Const Pointer alpha, @Const Pointer X, @Cast("const blasint") int incX, @Const Pointer Y, @Cast("const blasint") int incY, Pointer A, @Cast("const blasint") int lda);

public static native void cblas_strsv(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_DIAG") int Diag, @Cast("const blasint") int N, @Const FloatPointer A, @Cast("const blasint") int lda, FloatPointer X, @Cast("const blasint") int incX);
public static native void cblas_strsv(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_DIAG") int Diag, @Cast("const blasint") int N, @Const FloatBuffer A, @Cast("const blasint") int lda, FloatBuffer X, @Cast("const blasint") int incX);
public static native void cblas_strsv(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_DIAG") int Diag, @Cast("const blasint") int N, @Const float[] A, @Cast("const blasint") int lda, float[] X, @Cast("const blasint") int incX);
public static native void cblas_dtrsv(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_DIAG") int Diag, @Cast("const blasint") int N, @Const DoublePointer A, @Cast("const blasint") int lda, DoublePointer X, @Cast("const blasint") int incX);
public static native void cblas_dtrsv(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_DIAG") int Diag, @Cast("const blasint") int N, @Const DoubleBuffer A, @Cast("const blasint") int lda, DoubleBuffer X, @Cast("const blasint") int incX);
public static native void cblas_dtrsv(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_DIAG") int Diag, @Cast("const blasint") int N, @Const double[] A, @Cast("const blasint") int lda, double[] X, @Cast("const blasint") int incX);
public static native void cblas_ctrsv(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_DIAG") int Diag, @Cast("const blasint") int N, @Const Pointer A, @Cast("const blasint") int lda, Pointer X, @Cast("const blasint") int incX);
public static native void cblas_ztrsv(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_DIAG") int Diag, @Cast("const blasint") int N, @Const Pointer A, @Cast("const blasint") int lda, Pointer X, @Cast("const blasint") int incX);

public static native void cblas_strmv(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_DIAG") int Diag, @Cast("const blasint") int N, @Const FloatPointer A, @Cast("const blasint") int lda, FloatPointer X, @Cast("const blasint") int incX);
public static native void cblas_strmv(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_DIAG") int Diag, @Cast("const blasint") int N, @Const FloatBuffer A, @Cast("const blasint") int lda, FloatBuffer X, @Cast("const blasint") int incX);
public static native void cblas_strmv(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_DIAG") int Diag, @Cast("const blasint") int N, @Const float[] A, @Cast("const blasint") int lda, float[] X, @Cast("const blasint") int incX);
public static native void cblas_dtrmv(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_DIAG") int Diag, @Cast("const blasint") int N, @Const DoublePointer A, @Cast("const blasint") int lda, DoublePointer X, @Cast("const blasint") int incX);
public static native void cblas_dtrmv(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_DIAG") int Diag, @Cast("const blasint") int N, @Const DoubleBuffer A, @Cast("const blasint") int lda, DoubleBuffer X, @Cast("const blasint") int incX);
public static native void cblas_dtrmv(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_DIAG") int Diag, @Cast("const blasint") int N, @Const double[] A, @Cast("const blasint") int lda, double[] X, @Cast("const blasint") int incX);
public static native void cblas_ctrmv(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_DIAG") int Diag, @Cast("const blasint") int N, @Const Pointer A, @Cast("const blasint") int lda, Pointer X, @Cast("const blasint") int incX);
public static native void cblas_ztrmv(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_DIAG") int Diag, @Cast("const blasint") int N, @Const Pointer A, @Cast("const blasint") int lda, Pointer X, @Cast("const blasint") int incX);

public static native void cblas_ssyr(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const blasint") int N, float alpha, @Const FloatPointer X, @Cast("const blasint") int incX, FloatPointer A, @Cast("const blasint") int lda);
public static native void cblas_ssyr(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const blasint") int N, float alpha, @Const FloatBuffer X, @Cast("const blasint") int incX, FloatBuffer A, @Cast("const blasint") int lda);
public static native void cblas_ssyr(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const blasint") int N, float alpha, @Const float[] X, @Cast("const blasint") int incX, float[] A, @Cast("const blasint") int lda);
public static native void cblas_dsyr(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const blasint") int N, double alpha, @Const DoublePointer X, @Cast("const blasint") int incX, DoublePointer A, @Cast("const blasint") int lda);
public static native void cblas_dsyr(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const blasint") int N, double alpha, @Const DoubleBuffer X, @Cast("const blasint") int incX, DoubleBuffer A, @Cast("const blasint") int lda);
public static native void cblas_dsyr(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const blasint") int N, double alpha, @Const double[] X, @Cast("const blasint") int incX, double[] A, @Cast("const blasint") int lda);
public static native void cblas_cher(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const blasint") int N, float alpha, @Const Pointer X, @Cast("const blasint") int incX, Pointer A, @Cast("const blasint") int lda);
public static native void cblas_zher(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const blasint") int N, double alpha, @Const Pointer X, @Cast("const blasint") int incX, Pointer A, @Cast("const blasint") int lda);

public static native void cblas_ssyr2(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo,@Cast("const blasint") int N, float alpha, @Const FloatPointer X,
                @Cast("const blasint") int incX, @Const FloatPointer Y, @Cast("const blasint") int incY, FloatPointer A, @Cast("const blasint") int lda);
public static native void cblas_ssyr2(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo,@Cast("const blasint") int N, float alpha, @Const FloatBuffer X,
                @Cast("const blasint") int incX, @Const FloatBuffer Y, @Cast("const blasint") int incY, FloatBuffer A, @Cast("const blasint") int lda);
public static native void cblas_ssyr2(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo,@Cast("const blasint") int N, float alpha, @Const float[] X,
                @Cast("const blasint") int incX, @Const float[] Y, @Cast("const blasint") int incY, float[] A, @Cast("const blasint") int lda);
public static native void cblas_dsyr2(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const blasint") int N, double alpha, @Const DoublePointer X,
                @Cast("const blasint") int incX, @Const DoublePointer Y, @Cast("const blasint") int incY, DoublePointer A, @Cast("const blasint") int lda);
public static native void cblas_dsyr2(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const blasint") int N, double alpha, @Const DoubleBuffer X,
                @Cast("const blasint") int incX, @Const DoubleBuffer Y, @Cast("const blasint") int incY, DoubleBuffer A, @Cast("const blasint") int lda);
public static native void cblas_dsyr2(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const blasint") int N, double alpha, @Const double[] X,
                @Cast("const blasint") int incX, @Const double[] Y, @Cast("const blasint") int incY, double[] A, @Cast("const blasint") int lda);
public static native void cblas_cher2(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const blasint") int N, @Const Pointer alpha, @Const Pointer X, @Cast("const blasint") int incX,
                @Const Pointer Y, @Cast("const blasint") int incY, Pointer A, @Cast("const blasint") int lda);
public static native void cblas_zher2(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const blasint") int N, @Const Pointer alpha, @Const Pointer X, @Cast("const blasint") int incX,
                @Const Pointer Y, @Cast("const blasint") int incY, Pointer A, @Cast("const blasint") int lda);

public static native void cblas_sgbmv(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const blasint") int M, @Cast("const blasint") int N,
                 @Cast("const blasint") int KL, @Cast("const blasint") int KU, float alpha, @Const FloatPointer A, @Cast("const blasint") int lda, @Const FloatPointer X, @Cast("const blasint") int incX, float beta, FloatPointer Y, @Cast("const blasint") int incY);
public static native void cblas_sgbmv(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const blasint") int M, @Cast("const blasint") int N,
                 @Cast("const blasint") int KL, @Cast("const blasint") int KU, float alpha, @Const FloatBuffer A, @Cast("const blasint") int lda, @Const FloatBuffer X, @Cast("const blasint") int incX, float beta, FloatBuffer Y, @Cast("const blasint") int incY);
public static native void cblas_sgbmv(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const blasint") int M, @Cast("const blasint") int N,
                 @Cast("const blasint") int KL, @Cast("const blasint") int KU, float alpha, @Const float[] A, @Cast("const blasint") int lda, @Const float[] X, @Cast("const blasint") int incX, float beta, float[] Y, @Cast("const blasint") int incY);
public static native void cblas_dgbmv(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const blasint") int M, @Cast("const blasint") int N,
                 @Cast("const blasint") int KL, @Cast("const blasint") int KU, double alpha, @Const DoublePointer A, @Cast("const blasint") int lda, @Const DoublePointer X, @Cast("const blasint") int incX, double beta, DoublePointer Y, @Cast("const blasint") int incY);
public static native void cblas_dgbmv(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const blasint") int M, @Cast("const blasint") int N,
                 @Cast("const blasint") int KL, @Cast("const blasint") int KU, double alpha, @Const DoubleBuffer A, @Cast("const blasint") int lda, @Const DoubleBuffer X, @Cast("const blasint") int incX, double beta, DoubleBuffer Y, @Cast("const blasint") int incY);
public static native void cblas_dgbmv(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const blasint") int M, @Cast("const blasint") int N,
                 @Cast("const blasint") int KL, @Cast("const blasint") int KU, double alpha, @Const double[] A, @Cast("const blasint") int lda, @Const double[] X, @Cast("const blasint") int incX, double beta, double[] Y, @Cast("const blasint") int incY);
public static native void cblas_cgbmv(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const blasint") int M, @Cast("const blasint") int N,
                 @Cast("const blasint") int KL, @Cast("const blasint") int KU, @Const Pointer alpha, @Const Pointer A, @Cast("const blasint") int lda, @Const Pointer X, @Cast("const blasint") int incX, @Const Pointer beta, Pointer Y, @Cast("const blasint") int incY);
public static native void cblas_zgbmv(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const blasint") int M, @Cast("const blasint") int N,
                 @Cast("const blasint") int KL, @Cast("const blasint") int KU, @Const Pointer alpha, @Const Pointer A, @Cast("const blasint") int lda, @Const Pointer X, @Cast("const blasint") int incX, @Const Pointer beta, Pointer Y, @Cast("const blasint") int incY);

public static native void cblas_ssbmv(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const blasint") int N, @Cast("const blasint") int K, float alpha, @Const FloatPointer A,
                 @Cast("const blasint") int lda, @Const FloatPointer X, @Cast("const blasint") int incX, float beta, FloatPointer Y, @Cast("const blasint") int incY);
public static native void cblas_ssbmv(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const blasint") int N, @Cast("const blasint") int K, float alpha, @Const FloatBuffer A,
                 @Cast("const blasint") int lda, @Const FloatBuffer X, @Cast("const blasint") int incX, float beta, FloatBuffer Y, @Cast("const blasint") int incY);
public static native void cblas_ssbmv(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const blasint") int N, @Cast("const blasint") int K, float alpha, @Const float[] A,
                 @Cast("const blasint") int lda, @Const float[] X, @Cast("const blasint") int incX, float beta, float[] Y, @Cast("const blasint") int incY);
public static native void cblas_dsbmv(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const blasint") int N, @Cast("const blasint") int K, double alpha, @Const DoublePointer A,
                 @Cast("const blasint") int lda, @Const DoublePointer X, @Cast("const blasint") int incX, double beta, DoublePointer Y, @Cast("const blasint") int incY);
public static native void cblas_dsbmv(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const blasint") int N, @Cast("const blasint") int K, double alpha, @Const DoubleBuffer A,
                 @Cast("const blasint") int lda, @Const DoubleBuffer X, @Cast("const blasint") int incX, double beta, DoubleBuffer Y, @Cast("const blasint") int incY);
public static native void cblas_dsbmv(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const blasint") int N, @Cast("const blasint") int K, double alpha, @Const double[] A,
                 @Cast("const blasint") int lda, @Const double[] X, @Cast("const blasint") int incX, double beta, double[] Y, @Cast("const blasint") int incY);


public static native void cblas_stbmv(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_DIAG") int Diag,
                 @Cast("const blasint") int N, @Cast("const blasint") int K, @Const FloatPointer A, @Cast("const blasint") int lda, FloatPointer X, @Cast("const blasint") int incX);
public static native void cblas_stbmv(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_DIAG") int Diag,
                 @Cast("const blasint") int N, @Cast("const blasint") int K, @Const FloatBuffer A, @Cast("const blasint") int lda, FloatBuffer X, @Cast("const blasint") int incX);
public static native void cblas_stbmv(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_DIAG") int Diag,
                 @Cast("const blasint") int N, @Cast("const blasint") int K, @Const float[] A, @Cast("const blasint") int lda, float[] X, @Cast("const blasint") int incX);
public static native void cblas_dtbmv(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_DIAG") int Diag,
                 @Cast("const blasint") int N, @Cast("const blasint") int K, @Const DoublePointer A, @Cast("const blasint") int lda, DoublePointer X, @Cast("const blasint") int incX);
public static native void cblas_dtbmv(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_DIAG") int Diag,
                 @Cast("const blasint") int N, @Cast("const blasint") int K, @Const DoubleBuffer A, @Cast("const blasint") int lda, DoubleBuffer X, @Cast("const blasint") int incX);
public static native void cblas_dtbmv(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_DIAG") int Diag,
                 @Cast("const blasint") int N, @Cast("const blasint") int K, @Const double[] A, @Cast("const blasint") int lda, double[] X, @Cast("const blasint") int incX);
public static native void cblas_ctbmv(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_DIAG") int Diag,
                 @Cast("const blasint") int N, @Cast("const blasint") int K, @Const Pointer A, @Cast("const blasint") int lda, Pointer X, @Cast("const blasint") int incX);
public static native void cblas_ztbmv(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_DIAG") int Diag,
                 @Cast("const blasint") int N, @Cast("const blasint") int K, @Const Pointer A, @Cast("const blasint") int lda, Pointer X, @Cast("const blasint") int incX);

public static native void cblas_stbsv(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_DIAG") int Diag,
                 @Cast("const blasint") int N, @Cast("const blasint") int K, @Const FloatPointer A, @Cast("const blasint") int lda, FloatPointer X, @Cast("const blasint") int incX);
public static native void cblas_stbsv(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_DIAG") int Diag,
                 @Cast("const blasint") int N, @Cast("const blasint") int K, @Const FloatBuffer A, @Cast("const blasint") int lda, FloatBuffer X, @Cast("const blasint") int incX);
public static native void cblas_stbsv(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_DIAG") int Diag,
                 @Cast("const blasint") int N, @Cast("const blasint") int K, @Const float[] A, @Cast("const blasint") int lda, float[] X, @Cast("const blasint") int incX);
public static native void cblas_dtbsv(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_DIAG") int Diag,
                 @Cast("const blasint") int N, @Cast("const blasint") int K, @Const DoublePointer A, @Cast("const blasint") int lda, DoublePointer X, @Cast("const blasint") int incX);
public static native void cblas_dtbsv(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_DIAG") int Diag,
                 @Cast("const blasint") int N, @Cast("const blasint") int K, @Const DoubleBuffer A, @Cast("const blasint") int lda, DoubleBuffer X, @Cast("const blasint") int incX);
public static native void cblas_dtbsv(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_DIAG") int Diag,
                 @Cast("const blasint") int N, @Cast("const blasint") int K, @Const double[] A, @Cast("const blasint") int lda, double[] X, @Cast("const blasint") int incX);
public static native void cblas_ctbsv(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_DIAG") int Diag,
                 @Cast("const blasint") int N, @Cast("const blasint") int K, @Const Pointer A, @Cast("const blasint") int lda, Pointer X, @Cast("const blasint") int incX);
public static native void cblas_ztbsv(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_DIAG") int Diag,
                 @Cast("const blasint") int N, @Cast("const blasint") int K, @Const Pointer A, @Cast("const blasint") int lda, Pointer X, @Cast("const blasint") int incX);

public static native void cblas_stpmv(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_DIAG") int Diag,
                 @Cast("const blasint") int N, @Const FloatPointer Ap, FloatPointer X, @Cast("const blasint") int incX);
public static native void cblas_stpmv(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_DIAG") int Diag,
                 @Cast("const blasint") int N, @Const FloatBuffer Ap, FloatBuffer X, @Cast("const blasint") int incX);
public static native void cblas_stpmv(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_DIAG") int Diag,
                 @Cast("const blasint") int N, @Const float[] Ap, float[] X, @Cast("const blasint") int incX);
public static native void cblas_dtpmv(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_DIAG") int Diag,
                 @Cast("const blasint") int N, @Const DoublePointer Ap, DoublePointer X, @Cast("const blasint") int incX);
public static native void cblas_dtpmv(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_DIAG") int Diag,
                 @Cast("const blasint") int N, @Const DoubleBuffer Ap, DoubleBuffer X, @Cast("const blasint") int incX);
public static native void cblas_dtpmv(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_DIAG") int Diag,
                 @Cast("const blasint") int N, @Const double[] Ap, double[] X, @Cast("const blasint") int incX);
public static native void cblas_ctpmv(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_DIAG") int Diag,
                 @Cast("const blasint") int N, @Const Pointer Ap, Pointer X, @Cast("const blasint") int incX);
public static native void cblas_ztpmv(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_DIAG") int Diag,
                 @Cast("const blasint") int N, @Const Pointer Ap, Pointer X, @Cast("const blasint") int incX);

public static native void cblas_stpsv(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_DIAG") int Diag,
                 @Cast("const blasint") int N, @Const FloatPointer Ap, FloatPointer X, @Cast("const blasint") int incX);
public static native void cblas_stpsv(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_DIAG") int Diag,
                 @Cast("const blasint") int N, @Const FloatBuffer Ap, FloatBuffer X, @Cast("const blasint") int incX);
public static native void cblas_stpsv(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_DIAG") int Diag,
                 @Cast("const blasint") int N, @Const float[] Ap, float[] X, @Cast("const blasint") int incX);
public static native void cblas_dtpsv(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_DIAG") int Diag,
                 @Cast("const blasint") int N, @Const DoublePointer Ap, DoublePointer X, @Cast("const blasint") int incX);
public static native void cblas_dtpsv(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_DIAG") int Diag,
                 @Cast("const blasint") int N, @Const DoubleBuffer Ap, DoubleBuffer X, @Cast("const blasint") int incX);
public static native void cblas_dtpsv(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_DIAG") int Diag,
                 @Cast("const blasint") int N, @Const double[] Ap, double[] X, @Cast("const blasint") int incX);
public static native void cblas_ctpsv(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_DIAG") int Diag,
                 @Cast("const blasint") int N, @Const Pointer Ap, Pointer X, @Cast("const blasint") int incX);
public static native void cblas_ztpsv(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_DIAG") int Diag,
                 @Cast("const blasint") int N, @Const Pointer Ap, Pointer X, @Cast("const blasint") int incX);

public static native void cblas_ssymv(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const blasint") int N, float alpha, @Const FloatPointer A,
                 @Cast("const blasint") int lda, @Const FloatPointer X, @Cast("const blasint") int incX, float beta, FloatPointer Y, @Cast("const blasint") int incY);
public static native void cblas_ssymv(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const blasint") int N, float alpha, @Const FloatBuffer A,
                 @Cast("const blasint") int lda, @Const FloatBuffer X, @Cast("const blasint") int incX, float beta, FloatBuffer Y, @Cast("const blasint") int incY);
public static native void cblas_ssymv(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const blasint") int N, float alpha, @Const float[] A,
                 @Cast("const blasint") int lda, @Const float[] X, @Cast("const blasint") int incX, float beta, float[] Y, @Cast("const blasint") int incY);
public static native void cblas_dsymv(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const blasint") int N, double alpha, @Const DoublePointer A,
                 @Cast("const blasint") int lda, @Const DoublePointer X, @Cast("const blasint") int incX, double beta, DoublePointer Y, @Cast("const blasint") int incY);
public static native void cblas_dsymv(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const blasint") int N, double alpha, @Const DoubleBuffer A,
                 @Cast("const blasint") int lda, @Const DoubleBuffer X, @Cast("const blasint") int incX, double beta, DoubleBuffer Y, @Cast("const blasint") int incY);
public static native void cblas_dsymv(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const blasint") int N, double alpha, @Const double[] A,
                 @Cast("const blasint") int lda, @Const double[] X, @Cast("const blasint") int incX, double beta, double[] Y, @Cast("const blasint") int incY);
public static native void cblas_chemv(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const blasint") int N, @Const Pointer alpha, @Const Pointer A,
                 @Cast("const blasint") int lda, @Const Pointer X, @Cast("const blasint") int incX, @Const Pointer beta, Pointer Y, @Cast("const blasint") int incY);
public static native void cblas_zhemv(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const blasint") int N, @Const Pointer alpha, @Const Pointer A,
                 @Cast("const blasint") int lda, @Const Pointer X, @Cast("const blasint") int incX, @Const Pointer beta, Pointer Y, @Cast("const blasint") int incY);


public static native void cblas_sspmv(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const blasint") int N, float alpha, @Const FloatPointer Ap,
                 @Const FloatPointer X, @Cast("const blasint") int incX, float beta, FloatPointer Y, @Cast("const blasint") int incY);
public static native void cblas_sspmv(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const blasint") int N, float alpha, @Const FloatBuffer Ap,
                 @Const FloatBuffer X, @Cast("const blasint") int incX, float beta, FloatBuffer Y, @Cast("const blasint") int incY);
public static native void cblas_sspmv(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const blasint") int N, float alpha, @Const float[] Ap,
                 @Const float[] X, @Cast("const blasint") int incX, float beta, float[] Y, @Cast("const blasint") int incY);
public static native void cblas_dspmv(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const blasint") int N, double alpha, @Const DoublePointer Ap,
                 @Const DoublePointer X, @Cast("const blasint") int incX, double beta, DoublePointer Y, @Cast("const blasint") int incY);
public static native void cblas_dspmv(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const blasint") int N, double alpha, @Const DoubleBuffer Ap,
                 @Const DoubleBuffer X, @Cast("const blasint") int incX, double beta, DoubleBuffer Y, @Cast("const blasint") int incY);
public static native void cblas_dspmv(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const blasint") int N, double alpha, @Const double[] Ap,
                 @Const double[] X, @Cast("const blasint") int incX, double beta, double[] Y, @Cast("const blasint") int incY);

public static native void cblas_sspr(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const blasint") int N, float alpha, @Const FloatPointer X, @Cast("const blasint") int incX, FloatPointer Ap);
public static native void cblas_sspr(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const blasint") int N, float alpha, @Const FloatBuffer X, @Cast("const blasint") int incX, FloatBuffer Ap);
public static native void cblas_sspr(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const blasint") int N, float alpha, @Const float[] X, @Cast("const blasint") int incX, float[] Ap);
public static native void cblas_dspr(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const blasint") int N, double alpha, @Const DoublePointer X, @Cast("const blasint") int incX, DoublePointer Ap);
public static native void cblas_dspr(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const blasint") int N, double alpha, @Const DoubleBuffer X, @Cast("const blasint") int incX, DoubleBuffer Ap);
public static native void cblas_dspr(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const blasint") int N, double alpha, @Const double[] X, @Cast("const blasint") int incX, double[] Ap);

public static native void cblas_chpr(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const blasint") int N, float alpha, @Const Pointer X, @Cast("const blasint") int incX, Pointer A);
public static native void cblas_zhpr(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const blasint") int N, double alpha, @Const Pointer X,@Cast("const blasint") int incX, Pointer A);

public static native void cblas_sspr2(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const blasint") int N, float alpha, @Const FloatPointer X, @Cast("const blasint") int incX, @Const FloatPointer Y, @Cast("const blasint") int incY, FloatPointer A);
public static native void cblas_sspr2(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const blasint") int N, float alpha, @Const FloatBuffer X, @Cast("const blasint") int incX, @Const FloatBuffer Y, @Cast("const blasint") int incY, FloatBuffer A);
public static native void cblas_sspr2(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const blasint") int N, float alpha, @Const float[] X, @Cast("const blasint") int incX, @Const float[] Y, @Cast("const blasint") int incY, float[] A);
public static native void cblas_dspr2(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const blasint") int N, double alpha, @Const DoublePointer X, @Cast("const blasint") int incX, @Const DoublePointer Y, @Cast("const blasint") int incY, DoublePointer A);
public static native void cblas_dspr2(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const blasint") int N, double alpha, @Const DoubleBuffer X, @Cast("const blasint") int incX, @Const DoubleBuffer Y, @Cast("const blasint") int incY, DoubleBuffer A);
public static native void cblas_dspr2(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const blasint") int N, double alpha, @Const double[] X, @Cast("const blasint") int incX, @Const double[] Y, @Cast("const blasint") int incY, double[] A);
public static native void cblas_chpr2(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const blasint") int N, @Const Pointer alpha, @Const Pointer X, @Cast("const blasint") int incX, @Const Pointer Y, @Cast("const blasint") int incY, Pointer Ap);
public static native void cblas_zhpr2(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const blasint") int N, @Const Pointer alpha, @Const Pointer X, @Cast("const blasint") int incX, @Const Pointer Y, @Cast("const blasint") int incY, Pointer Ap);

public static native void cblas_chbmv(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const blasint") int N, @Cast("const blasint") int K,
		 @Const Pointer alpha, @Const Pointer A, @Cast("const blasint") int lda, @Const Pointer X, @Cast("const blasint") int incX, @Const Pointer beta, Pointer Y, @Cast("const blasint") int incY);
public static native void cblas_zhbmv(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const blasint") int N, @Cast("const blasint") int K,
		 @Const Pointer alpha, @Const Pointer A, @Cast("const blasint") int lda, @Const Pointer X, @Cast("const blasint") int incX, @Const Pointer beta, Pointer Y, @Cast("const blasint") int incY);

public static native void cblas_chpmv(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const blasint") int N,
		 @Const Pointer alpha, @Const Pointer Ap, @Const Pointer X, @Cast("const blasint") int incX, @Const Pointer beta, Pointer Y, @Cast("const blasint") int incY);
public static native void cblas_zhpmv(@Cast("const CBLAS_ORDER") int order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const blasint") int N,
		 @Const Pointer alpha, @Const Pointer Ap, @Const Pointer X, @Cast("const blasint") int incX, @Const Pointer beta, Pointer Y, @Cast("const blasint") int incY);

public static native void cblas_sgemm(@Cast("const CBLAS_ORDER") int Order, @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_TRANSPOSE") int TransB, @Cast("const blasint") int M, @Cast("const blasint") int N, @Cast("const blasint") int K,
		 float alpha, @Const FloatPointer A, @Cast("const blasint") int lda, @Const FloatPointer B, @Cast("const blasint") int ldb, float beta, FloatPointer C, @Cast("const blasint") int ldc);
public static native void cblas_sgemm(@Cast("const CBLAS_ORDER") int Order, @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_TRANSPOSE") int TransB, @Cast("const blasint") int M, @Cast("const blasint") int N, @Cast("const blasint") int K,
		 float alpha, @Const FloatBuffer A, @Cast("const blasint") int lda, @Const FloatBuffer B, @Cast("const blasint") int ldb, float beta, FloatBuffer C, @Cast("const blasint") int ldc);
public static native void cblas_sgemm(@Cast("const CBLAS_ORDER") int Order, @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_TRANSPOSE") int TransB, @Cast("const blasint") int M, @Cast("const blasint") int N, @Cast("const blasint") int K,
		 float alpha, @Const float[] A, @Cast("const blasint") int lda, @Const float[] B, @Cast("const blasint") int ldb, float beta, float[] C, @Cast("const blasint") int ldc);
public static native void cblas_dgemm(@Cast("const CBLAS_ORDER") int Order, @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_TRANSPOSE") int TransB, @Cast("const blasint") int M, @Cast("const blasint") int N, @Cast("const blasint") int K,
		 double alpha, @Const DoublePointer A, @Cast("const blasint") int lda, @Const DoublePointer B, @Cast("const blasint") int ldb, double beta, DoublePointer C, @Cast("const blasint") int ldc);
public static native void cblas_dgemm(@Cast("const CBLAS_ORDER") int Order, @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_TRANSPOSE") int TransB, @Cast("const blasint") int M, @Cast("const blasint") int N, @Cast("const blasint") int K,
		 double alpha, @Const DoubleBuffer A, @Cast("const blasint") int lda, @Const DoubleBuffer B, @Cast("const blasint") int ldb, double beta, DoubleBuffer C, @Cast("const blasint") int ldc);
public static native void cblas_dgemm(@Cast("const CBLAS_ORDER") int Order, @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_TRANSPOSE") int TransB, @Cast("const blasint") int M, @Cast("const blasint") int N, @Cast("const blasint") int K,
		 double alpha, @Const double[] A, @Cast("const blasint") int lda, @Const double[] B, @Cast("const blasint") int ldb, double beta, double[] C, @Cast("const blasint") int ldc);
public static native void cblas_cgemm(@Cast("const CBLAS_ORDER") int Order, @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_TRANSPOSE") int TransB, @Cast("const blasint") int M, @Cast("const blasint") int N, @Cast("const blasint") int K,
		 @Const Pointer alpha, @Const Pointer A, @Cast("const blasint") int lda, @Const Pointer B, @Cast("const blasint") int ldb, @Const Pointer beta, Pointer C, @Cast("const blasint") int ldc);

public static native void cblas_zgemm(@Cast("const CBLAS_ORDER") int Order, @Cast("const CBLAS_TRANSPOSE") int TransA, @Cast("const CBLAS_TRANSPOSE") int TransB, @Cast("const blasint") int M, @Cast("const blasint") int N, @Cast("const blasint") int K,
		 @Const Pointer alpha, @Const Pointer A, @Cast("const blasint") int lda, @Const Pointer B, @Cast("const blasint") int ldb, @Const Pointer beta, Pointer C, @Cast("const blasint") int ldc);



public static native void cblas_ssymm(@Cast("const CBLAS_ORDER") int Order, @Cast("const CBLAS_SIDE") int Side, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const blasint") int M, @Cast("const blasint") int N,
                 float alpha, @Const FloatPointer A, @Cast("const blasint") int lda, @Const FloatPointer B, @Cast("const blasint") int ldb, float beta, FloatPointer C, @Cast("const blasint") int ldc);
public static native void cblas_ssymm(@Cast("const CBLAS_ORDER") int Order, @Cast("const CBLAS_SIDE") int Side, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const blasint") int M, @Cast("const blasint") int N,
                 float alpha, @Const FloatBuffer A, @Cast("const blasint") int lda, @Const FloatBuffer B, @Cast("const blasint") int ldb, float beta, FloatBuffer C, @Cast("const blasint") int ldc);
public static native void cblas_ssymm(@Cast("const CBLAS_ORDER") int Order, @Cast("const CBLAS_SIDE") int Side, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const blasint") int M, @Cast("const blasint") int N,
                 float alpha, @Const float[] A, @Cast("const blasint") int lda, @Const float[] B, @Cast("const blasint") int ldb, float beta, float[] C, @Cast("const blasint") int ldc);
public static native void cblas_dsymm(@Cast("const CBLAS_ORDER") int Order, @Cast("const CBLAS_SIDE") int Side, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const blasint") int M, @Cast("const blasint") int N,
                 double alpha, @Const DoublePointer A, @Cast("const blasint") int lda, @Const DoublePointer B, @Cast("const blasint") int ldb, double beta, DoublePointer C, @Cast("const blasint") int ldc);
public static native void cblas_dsymm(@Cast("const CBLAS_ORDER") int Order, @Cast("const CBLAS_SIDE") int Side, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const blasint") int M, @Cast("const blasint") int N,
                 double alpha, @Const DoubleBuffer A, @Cast("const blasint") int lda, @Const DoubleBuffer B, @Cast("const blasint") int ldb, double beta, DoubleBuffer C, @Cast("const blasint") int ldc);
public static native void cblas_dsymm(@Cast("const CBLAS_ORDER") int Order, @Cast("const CBLAS_SIDE") int Side, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const blasint") int M, @Cast("const blasint") int N,
                 double alpha, @Const double[] A, @Cast("const blasint") int lda, @Const double[] B, @Cast("const blasint") int ldb, double beta, double[] C, @Cast("const blasint") int ldc);
public static native void cblas_csymm(@Cast("const CBLAS_ORDER") int Order, @Cast("const CBLAS_SIDE") int Side, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const blasint") int M, @Cast("const blasint") int N,
                 @Const Pointer alpha, @Const Pointer A, @Cast("const blasint") int lda, @Const Pointer B, @Cast("const blasint") int ldb, @Const Pointer beta, Pointer C, @Cast("const blasint") int ldc);
public static native void cblas_zsymm(@Cast("const CBLAS_ORDER") int Order, @Cast("const CBLAS_SIDE") int Side, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const blasint") int M, @Cast("const blasint") int N,
                 @Const Pointer alpha, @Const Pointer A, @Cast("const blasint") int lda, @Const Pointer B, @Cast("const blasint") int ldb, @Const Pointer beta, Pointer C, @Cast("const blasint") int ldc);

public static native void cblas_ssyrk(@Cast("const CBLAS_ORDER") int Order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int Trans,
		 @Cast("const blasint") int N, @Cast("const blasint") int K, float alpha, @Const FloatPointer A, @Cast("const blasint") int lda, float beta, FloatPointer C, @Cast("const blasint") int ldc);
public static native void cblas_ssyrk(@Cast("const CBLAS_ORDER") int Order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int Trans,
		 @Cast("const blasint") int N, @Cast("const blasint") int K, float alpha, @Const FloatBuffer A, @Cast("const blasint") int lda, float beta, FloatBuffer C, @Cast("const blasint") int ldc);
public static native void cblas_ssyrk(@Cast("const CBLAS_ORDER") int Order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int Trans,
		 @Cast("const blasint") int N, @Cast("const blasint") int K, float alpha, @Const float[] A, @Cast("const blasint") int lda, float beta, float[] C, @Cast("const blasint") int ldc);
public static native void cblas_dsyrk(@Cast("const CBLAS_ORDER") int Order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int Trans,
		 @Cast("const blasint") int N, @Cast("const blasint") int K, double alpha, @Const DoublePointer A, @Cast("const blasint") int lda, double beta, DoublePointer C, @Cast("const blasint") int ldc);
public static native void cblas_dsyrk(@Cast("const CBLAS_ORDER") int Order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int Trans,
		 @Cast("const blasint") int N, @Cast("const blasint") int K, double alpha, @Const DoubleBuffer A, @Cast("const blasint") int lda, double beta, DoubleBuffer C, @Cast("const blasint") int ldc);
public static native void cblas_dsyrk(@Cast("const CBLAS_ORDER") int Order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int Trans,
		 @Cast("const blasint") int N, @Cast("const blasint") int K, double alpha, @Const double[] A, @Cast("const blasint") int lda, double beta, double[] C, @Cast("const blasint") int ldc);
public static native void cblas_csyrk(@Cast("const CBLAS_ORDER") int Order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int Trans,
		 @Cast("const blasint") int N, @Cast("const blasint") int K, @Const Pointer alpha, @Const Pointer A, @Cast("const blasint") int lda, @Const Pointer beta, Pointer C, @Cast("const blasint") int ldc);
public static native void cblas_zsyrk(@Cast("const CBLAS_ORDER") int Order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int Trans,
		 @Cast("const blasint") int N, @Cast("const blasint") int K, @Const Pointer alpha, @Const Pointer A, @Cast("const blasint") int lda, @Const Pointer beta, Pointer C, @Cast("const blasint") int ldc);

public static native void cblas_ssyr2k(@Cast("const CBLAS_ORDER") int Order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int Trans,
		  @Cast("const blasint") int N, @Cast("const blasint") int K, float alpha, @Const FloatPointer A, @Cast("const blasint") int lda, @Const FloatPointer B, @Cast("const blasint") int ldb, float beta, FloatPointer C, @Cast("const blasint") int ldc);
public static native void cblas_ssyr2k(@Cast("const CBLAS_ORDER") int Order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int Trans,
		  @Cast("const blasint") int N, @Cast("const blasint") int K, float alpha, @Const FloatBuffer A, @Cast("const blasint") int lda, @Const FloatBuffer B, @Cast("const blasint") int ldb, float beta, FloatBuffer C, @Cast("const blasint") int ldc);
public static native void cblas_ssyr2k(@Cast("const CBLAS_ORDER") int Order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int Trans,
		  @Cast("const blasint") int N, @Cast("const blasint") int K, float alpha, @Const float[] A, @Cast("const blasint") int lda, @Const float[] B, @Cast("const blasint") int ldb, float beta, float[] C, @Cast("const blasint") int ldc);
public static native void cblas_dsyr2k(@Cast("const CBLAS_ORDER") int Order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int Trans,
		  @Cast("const blasint") int N, @Cast("const blasint") int K, double alpha, @Const DoublePointer A, @Cast("const blasint") int lda, @Const DoublePointer B, @Cast("const blasint") int ldb, double beta, DoublePointer C, @Cast("const blasint") int ldc);
public static native void cblas_dsyr2k(@Cast("const CBLAS_ORDER") int Order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int Trans,
		  @Cast("const blasint") int N, @Cast("const blasint") int K, double alpha, @Const DoubleBuffer A, @Cast("const blasint") int lda, @Const DoubleBuffer B, @Cast("const blasint") int ldb, double beta, DoubleBuffer C, @Cast("const blasint") int ldc);
public static native void cblas_dsyr2k(@Cast("const CBLAS_ORDER") int Order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int Trans,
		  @Cast("const blasint") int N, @Cast("const blasint") int K, double alpha, @Const double[] A, @Cast("const blasint") int lda, @Const double[] B, @Cast("const blasint") int ldb, double beta, double[] C, @Cast("const blasint") int ldc);
public static native void cblas_csyr2k(@Cast("const CBLAS_ORDER") int Order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int Trans,
		  @Cast("const blasint") int N, @Cast("const blasint") int K, @Const Pointer alpha, @Const Pointer A, @Cast("const blasint") int lda, @Const Pointer B, @Cast("const blasint") int ldb, @Const Pointer beta, Pointer C, @Cast("const blasint") int ldc);
public static native void cblas_zsyr2k(@Cast("const CBLAS_ORDER") int Order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int Trans,
		  @Cast("const blasint") int N, @Cast("const blasint") int K, @Const Pointer alpha, @Const Pointer A, @Cast("const blasint") int lda, @Const Pointer B, @Cast("const blasint") int ldb, @Const Pointer beta, Pointer C, @Cast("const blasint") int ldc);

public static native void cblas_strmm(@Cast("const CBLAS_ORDER") int Order, @Cast("const CBLAS_SIDE") int Side, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int TransA,
                 @Cast("const CBLAS_DIAG") int Diag, @Cast("const blasint") int M, @Cast("const blasint") int N, float alpha, @Const FloatPointer A, @Cast("const blasint") int lda, FloatPointer B, @Cast("const blasint") int ldb);
public static native void cblas_strmm(@Cast("const CBLAS_ORDER") int Order, @Cast("const CBLAS_SIDE") int Side, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int TransA,
                 @Cast("const CBLAS_DIAG") int Diag, @Cast("const blasint") int M, @Cast("const blasint") int N, float alpha, @Const FloatBuffer A, @Cast("const blasint") int lda, FloatBuffer B, @Cast("const blasint") int ldb);
public static native void cblas_strmm(@Cast("const CBLAS_ORDER") int Order, @Cast("const CBLAS_SIDE") int Side, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int TransA,
                 @Cast("const CBLAS_DIAG") int Diag, @Cast("const blasint") int M, @Cast("const blasint") int N, float alpha, @Const float[] A, @Cast("const blasint") int lda, float[] B, @Cast("const blasint") int ldb);
public static native void cblas_dtrmm(@Cast("const CBLAS_ORDER") int Order, @Cast("const CBLAS_SIDE") int Side, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int TransA,
                 @Cast("const CBLAS_DIAG") int Diag, @Cast("const blasint") int M, @Cast("const blasint") int N, double alpha, @Const DoublePointer A, @Cast("const blasint") int lda, DoublePointer B, @Cast("const blasint") int ldb);
public static native void cblas_dtrmm(@Cast("const CBLAS_ORDER") int Order, @Cast("const CBLAS_SIDE") int Side, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int TransA,
                 @Cast("const CBLAS_DIAG") int Diag, @Cast("const blasint") int M, @Cast("const blasint") int N, double alpha, @Const DoubleBuffer A, @Cast("const blasint") int lda, DoubleBuffer B, @Cast("const blasint") int ldb);
public static native void cblas_dtrmm(@Cast("const CBLAS_ORDER") int Order, @Cast("const CBLAS_SIDE") int Side, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int TransA,
                 @Cast("const CBLAS_DIAG") int Diag, @Cast("const blasint") int M, @Cast("const blasint") int N, double alpha, @Const double[] A, @Cast("const blasint") int lda, double[] B, @Cast("const blasint") int ldb);
public static native void cblas_ctrmm(@Cast("const CBLAS_ORDER") int Order, @Cast("const CBLAS_SIDE") int Side, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int TransA,
                 @Cast("const CBLAS_DIAG") int Diag, @Cast("const blasint") int M, @Cast("const blasint") int N, @Const Pointer alpha, @Const Pointer A, @Cast("const blasint") int lda, Pointer B, @Cast("const blasint") int ldb);
public static native void cblas_ztrmm(@Cast("const CBLAS_ORDER") int Order, @Cast("const CBLAS_SIDE") int Side, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int TransA,
                 @Cast("const CBLAS_DIAG") int Diag, @Cast("const blasint") int M, @Cast("const blasint") int N, @Const Pointer alpha, @Const Pointer A, @Cast("const blasint") int lda, Pointer B, @Cast("const blasint") int ldb);

public static native void cblas_strsm(@Cast("const CBLAS_ORDER") int Order, @Cast("const CBLAS_SIDE") int Side, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int TransA,
                 @Cast("const CBLAS_DIAG") int Diag, @Cast("const blasint") int M, @Cast("const blasint") int N, float alpha, @Const FloatPointer A, @Cast("const blasint") int lda, FloatPointer B, @Cast("const blasint") int ldb);
public static native void cblas_strsm(@Cast("const CBLAS_ORDER") int Order, @Cast("const CBLAS_SIDE") int Side, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int TransA,
                 @Cast("const CBLAS_DIAG") int Diag, @Cast("const blasint") int M, @Cast("const blasint") int N, float alpha, @Const FloatBuffer A, @Cast("const blasint") int lda, FloatBuffer B, @Cast("const blasint") int ldb);
public static native void cblas_strsm(@Cast("const CBLAS_ORDER") int Order, @Cast("const CBLAS_SIDE") int Side, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int TransA,
                 @Cast("const CBLAS_DIAG") int Diag, @Cast("const blasint") int M, @Cast("const blasint") int N, float alpha, @Const float[] A, @Cast("const blasint") int lda, float[] B, @Cast("const blasint") int ldb);
public static native void cblas_dtrsm(@Cast("const CBLAS_ORDER") int Order, @Cast("const CBLAS_SIDE") int Side, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int TransA,
                 @Cast("const CBLAS_DIAG") int Diag, @Cast("const blasint") int M, @Cast("const blasint") int N, double alpha, @Const DoublePointer A, @Cast("const blasint") int lda, DoublePointer B, @Cast("const blasint") int ldb);
public static native void cblas_dtrsm(@Cast("const CBLAS_ORDER") int Order, @Cast("const CBLAS_SIDE") int Side, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int TransA,
                 @Cast("const CBLAS_DIAG") int Diag, @Cast("const blasint") int M, @Cast("const blasint") int N, double alpha, @Const DoubleBuffer A, @Cast("const blasint") int lda, DoubleBuffer B, @Cast("const blasint") int ldb);
public static native void cblas_dtrsm(@Cast("const CBLAS_ORDER") int Order, @Cast("const CBLAS_SIDE") int Side, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int TransA,
                 @Cast("const CBLAS_DIAG") int Diag, @Cast("const blasint") int M, @Cast("const blasint") int N, double alpha, @Const double[] A, @Cast("const blasint") int lda, double[] B, @Cast("const blasint") int ldb);
public static native void cblas_ctrsm(@Cast("const CBLAS_ORDER") int Order, @Cast("const CBLAS_SIDE") int Side, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int TransA,
                 @Cast("const CBLAS_DIAG") int Diag, @Cast("const blasint") int M, @Cast("const blasint") int N, @Const Pointer alpha, @Const Pointer A, @Cast("const blasint") int lda, Pointer B, @Cast("const blasint") int ldb);
public static native void cblas_ztrsm(@Cast("const CBLAS_ORDER") int Order, @Cast("const CBLAS_SIDE") int Side, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int TransA,
                 @Cast("const CBLAS_DIAG") int Diag, @Cast("const blasint") int M, @Cast("const blasint") int N, @Const Pointer alpha, @Const Pointer A, @Cast("const blasint") int lda, Pointer B, @Cast("const blasint") int ldb);

public static native void cblas_chemm(@Cast("const CBLAS_ORDER") int Order, @Cast("const CBLAS_SIDE") int Side, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const blasint") int M, @Cast("const blasint") int N,
                 @Const Pointer alpha, @Const Pointer A, @Cast("const blasint") int lda, @Const Pointer B, @Cast("const blasint") int ldb, @Const Pointer beta, Pointer C, @Cast("const blasint") int ldc);
public static native void cblas_zhemm(@Cast("const CBLAS_ORDER") int Order, @Cast("const CBLAS_SIDE") int Side, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const blasint") int M, @Cast("const blasint") int N,
                 @Const Pointer alpha, @Const Pointer A, @Cast("const blasint") int lda, @Const Pointer B, @Cast("const blasint") int ldb, @Const Pointer beta, Pointer C, @Cast("const blasint") int ldc);

public static native void cblas_cherk(@Cast("const CBLAS_ORDER") int Order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int Trans, @Cast("const blasint") int N, @Cast("const blasint") int K,
                 float alpha, @Const Pointer A, @Cast("const blasint") int lda, float beta, Pointer C, @Cast("const blasint") int ldc);
public static native void cblas_zherk(@Cast("const CBLAS_ORDER") int Order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int Trans, @Cast("const blasint") int N, @Cast("const blasint") int K,
                 double alpha, @Const Pointer A, @Cast("const blasint") int lda, double beta, Pointer C, @Cast("const blasint") int ldc);

public static native void cblas_cher2k(@Cast("const CBLAS_ORDER") int Order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int Trans, @Cast("const blasint") int N, @Cast("const blasint") int K,
                  @Const Pointer alpha, @Const Pointer A, @Cast("const blasint") int lda, @Const Pointer B, @Cast("const blasint") int ldb, float beta, Pointer C, @Cast("const blasint") int ldc);
public static native void cblas_zher2k(@Cast("const CBLAS_ORDER") int Order, @Cast("const CBLAS_UPLO") int Uplo, @Cast("const CBLAS_TRANSPOSE") int Trans, @Cast("const blasint") int N, @Cast("const blasint") int K,
                  @Const Pointer alpha, @Const Pointer A, @Cast("const blasint") int lda, @Const Pointer B, @Cast("const blasint") int ldb, double beta, Pointer C, @Cast("const blasint") int ldc);



/*** BLAS extensions ***/









 
 
 
 

 
 
 
 

 
 
 
 


// #ifdef __cplusplus
// #endif  /* __cplusplus */

// #endif


// Parsed from lapacke_config.h

/*****************************************************************************
  Copyright (c) 2010, Intel Corp.
  All rights reserved.
  <p>
  Redistribution and use in source and binary forms, with or without
  modification, are permitted provided that the following conditions are met:
    <p>
    * Redistributions of source code must retain the above copyright notice,
      this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.
    * Neither the name of Intel Corporation nor the names of its contributors
      may be used to endorse or promote products derived from this software
      without specific prior written permission.
  <p>
  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
  AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
  ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
  LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
  CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
  SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
  INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
  CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
  THE POSSIBILITY OF SUCH DAMAGE.
******************************************************************************
* Contents: Native C interface to LAPACK
* Author: Intel Corporation
* Generated May, 2011
*****************************************************************************/

// #ifndef _LAPACKE_CONFIG_H_
// #define _LAPACKE_CONFIG_H_

// For Android prior to API 21 (no <complex> include)
// #if defined(__ANDROID__)
// #if __ANDROID_API__ < 21
// #define LAPACK_COMPLEX_STRUCTURE
// #endif
// #endif

// #ifdef __cplusplus
// #if defined(LAPACK_COMPLEX_CPP)
// #include <complex>
// #endif
// #endif /* __cplusplus */

// #include <stdlib.h>

// #ifndef lapack_int
// #if defined(LAPACK_ILP64)
// #define lapack_int              long
// #else
// #define lapack_int              int
// #endif
// #endif

// #ifndef lapack_logical
// #define lapack_logical          lapack_int
// #endif

// #ifndef LAPACK_COMPLEX_CUSTOM

// #endif

// #ifndef LAPACK_malloc
// #define LAPACK_malloc( size )   malloc( size )
// #endif

// #ifndef LAPACK_free
// #define LAPACK_free( p )        free( p )
// #endif

// #ifdef __cplusplus
// #endif /* __cplusplus */

// #endif /* _LAPACKE_CONFIG_H_ */


// Parsed from lapacke_mangling.h

// #ifndef LAPACK_HEADER_INCLUDED
// #define LAPACK_HEADER_INCLUDED

// #ifndef LAPACK_GLOBAL
// #if defined(LAPACK_GLOBAL_PATTERN_LC) || defined(ADD_)
// #define LAPACK_GLOBAL(lcname,UCNAME)  lcname##_
// #elif defined(LAPACK_GLOBAL_PATTERN_UC) || defined(UPPER)
// #define LAPACK_GLOBAL(lcname,UCNAME)  UCNAME
// #elif defined(LAPACK_GLOBAL_PATTERN_MC) || defined(NOCHANGE)
// #define LAPACK_GLOBAL(lcname,UCNAME)  lcname
// #else
// #define LAPACK_GLOBAL(lcname,UCNAME)  lcname##_
// #endif
// #endif

// #endif



// Parsed from lapacke.h

/*****************************************************************************
  Copyright (c) 2014, Intel Corp.
  All rights reserved.
  <p>
  Redistribution and use in source and binary forms, with or without
  modification, are permitted provided that the following conditions are met:
    <p>
    * Redistributions of source code must retain the above copyright notice,
      this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.
    * Neither the name of Intel Corporation nor the names of its contributors
      may be used to endorse or promote products derived from this software
      without specific prior written permission.
  <p>
  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
  AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
  ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
  LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
  CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
  SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
  INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
  CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
  THE POSSIBILITY OF SUCH DAMAGE.
******************************************************************************
* Contents: Native C interface to LAPACK
* Author: Intel Corporation
* Generated August, 2015
*****************************************************************************/

// #ifndef _LAPACKE_H_
// #define _LAPACKE_H_

/*
*  Turn on HAVE_LAPACK_CONFIG_H to redefine C-LAPACK datatypes
*/
// #ifdef HAVE_LAPACK_CONFIG_H
// #include "lapacke_config.h"
// #endif

// #include <stdlib.h>

// #ifndef lapack_int
// #define lapack_int     int
// #endif

// #ifndef lapack_logical
// #define lapack_logical lapack_int
// #endif

/* Complex types are structures equivalent to the
* Fortran complex types COMPLEX(4) and COMPLEX(8).
*
* One can also redefine the types with his own types
* for example by including in the code definitions like
*
* #define lapack_complex_float std::complex<float>
* #define lapack_complex_double std::complex<double>
*
* or define these types in the command line:
*
* -Dlapack_complex_float="std::complex<float>"
* -Dlapack_complex_double="std::complex<double>"
*/

// #ifndef LAPACK_COMPLEX_CUSTOM

// #endif

// #ifdef __cplusplus
// #endif /* __cplusplus */

// #ifndef LAPACKE_malloc
// #define LAPACKE_malloc( size ) malloc( size )
// #endif
// #ifndef LAPACKE_free
// #define LAPACKE_free( p )      free( p )
// #endif

// #define LAPACK_C2INT( x ) (lapack_int)(*((float*)&x ))
// #define LAPACK_Z2INT( x ) (lapack_int)(*((double*)&x ))

public static final int LAPACK_ROW_MAJOR =               101;
public static final int LAPACK_COL_MAJOR =               102;

public static final int LAPACK_WORK_MEMORY_ERROR =       -1010;
public static final int LAPACK_TRANSPOSE_MEMORY_ERROR =  -1011;

/* Callback logical functions of one, two, or three arguments are used
*  to select eigenvalues to sort to the top left of the Schur form.
*  The value is selected if function returns TRUE (non-zero). */

public static class LAPACK_S_SELECT2 extends FunctionPointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public    LAPACK_S_SELECT2(Pointer p) { super(p); }
    protected LAPACK_S_SELECT2() { allocate(); }
    private native void allocate();
    public native int call( @Const FloatPointer arg0, @Const FloatPointer arg1 );
}
public static class LAPACK_S_SELECT3 extends FunctionPointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public    LAPACK_S_SELECT3(Pointer p) { super(p); }
    protected LAPACK_S_SELECT3() { allocate(); }
    private native void allocate();
    public native int call( @Const FloatPointer arg0, @Const FloatPointer arg1, @Const FloatPointer arg2 );
}
public static class LAPACK_D_SELECT2 extends FunctionPointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public    LAPACK_D_SELECT2(Pointer p) { super(p); }
    protected LAPACK_D_SELECT2() { allocate(); }
    private native void allocate();
    public native int call( @Const DoublePointer arg0, @Const DoublePointer arg1 );
}
public static class LAPACK_D_SELECT3 extends FunctionPointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public    LAPACK_D_SELECT3(Pointer p) { super(p); }
    protected LAPACK_D_SELECT3() { allocate(); }
    private native void allocate();
    public native int call( @Const DoublePointer arg0, @Const DoublePointer arg1, @Const DoublePointer arg2 );
}

public static class LAPACK_C_SELECT1 extends FunctionPointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public    LAPACK_C_SELECT1(Pointer p) { super(p); }
    protected LAPACK_C_SELECT1() { allocate(); }
    private native void allocate();
    public native int call( @Cast("const lapack_complex_float*") FloatPointer arg0 );
}
public static class LAPACK_C_SELECT2 extends FunctionPointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public    LAPACK_C_SELECT2(Pointer p) { super(p); }
    protected LAPACK_C_SELECT2() { allocate(); }
    private native void allocate();
    public native int call( @Cast("const lapack_complex_float*") FloatPointer arg0, @Cast("const lapack_complex_float*") FloatPointer arg1 );
}
public static class LAPACK_Z_SELECT1 extends FunctionPointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public    LAPACK_Z_SELECT1(Pointer p) { super(p); }
    protected LAPACK_Z_SELECT1() { allocate(); }
    private native void allocate();
    public native int call( @Cast("const lapack_complex_double*") DoublePointer arg0 );
}
public static class LAPACK_Z_SELECT2 extends FunctionPointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public    LAPACK_Z_SELECT2(Pointer p) { super(p); }
    protected LAPACK_Z_SELECT2() { allocate(); }
    private native void allocate();
    public native int call( @Cast("const lapack_complex_double*") DoublePointer arg0, @Cast("const lapack_complex_double*") DoublePointer arg1 );
}

// #include "lapacke_mangling.h"

public static native int LAPACK_lsame( @Cast("char*") BytePointer ca,  @Cast("char*") BytePointer cb,
                              int lca, int lcb );
public static native int LAPACK_lsame( @Cast("char*") ByteBuffer ca,  @Cast("char*") ByteBuffer cb,
                              int lca, int lcb );
public static native int LAPACK_lsame( @Cast("char*") byte[] ca,  @Cast("char*") byte[] cb,
                              int lca, int lcb );

/* C-LAPACK function prototypes */

public static native int LAPACKE_sbdsdc( int matrix_layout, @Cast("char") byte uplo, @Cast("char") byte compq,
                           int n, FloatPointer d, FloatPointer e, FloatPointer u,
                           int ldu, FloatPointer vt, int ldvt, FloatPointer q,
                           IntPointer iq );
public static native int LAPACKE_sbdsdc( int matrix_layout, @Cast("char") byte uplo, @Cast("char") byte compq,
                           int n, FloatBuffer d, FloatBuffer e, FloatBuffer u,
                           int ldu, FloatBuffer vt, int ldvt, FloatBuffer q,
                           IntBuffer iq );
public static native int LAPACKE_sbdsdc( int matrix_layout, @Cast("char") byte uplo, @Cast("char") byte compq,
                           int n, float[] d, float[] e, float[] u,
                           int ldu, float[] vt, int ldvt, float[] q,
                           int[] iq );
public static native int LAPACKE_dbdsdc( int matrix_layout, @Cast("char") byte uplo, @Cast("char") byte compq,
                           int n, DoublePointer d, DoublePointer e, DoublePointer u,
                           int ldu, DoublePointer vt, int ldvt,
                           DoublePointer q, IntPointer iq );
public static native int LAPACKE_dbdsdc( int matrix_layout, @Cast("char") byte uplo, @Cast("char") byte compq,
                           int n, DoubleBuffer d, DoubleBuffer e, DoubleBuffer u,
                           int ldu, DoubleBuffer vt, int ldvt,
                           DoubleBuffer q, IntBuffer iq );
public static native int LAPACKE_dbdsdc( int matrix_layout, @Cast("char") byte uplo, @Cast("char") byte compq,
                           int n, double[] d, double[] e, double[] u,
                           int ldu, double[] vt, int ldvt,
                           double[] q, int[] iq );

public static native int LAPACKE_sbdsqr( int matrix_layout, @Cast("char") byte uplo, int n,
                           int ncvt, int nru, int ncc,
                           FloatPointer d, FloatPointer e, FloatPointer vt, int ldvt,
                           FloatPointer u, int ldu, FloatPointer c, int ldc );
public static native int LAPACKE_sbdsqr( int matrix_layout, @Cast("char") byte uplo, int n,
                           int ncvt, int nru, int ncc,
                           FloatBuffer d, FloatBuffer e, FloatBuffer vt, int ldvt,
                           FloatBuffer u, int ldu, FloatBuffer c, int ldc );
public static native int LAPACKE_sbdsqr( int matrix_layout, @Cast("char") byte uplo, int n,
                           int ncvt, int nru, int ncc,
                           float[] d, float[] e, float[] vt, int ldvt,
                           float[] u, int ldu, float[] c, int ldc );
public static native int LAPACKE_dbdsqr( int matrix_layout, @Cast("char") byte uplo, int n,
                           int ncvt, int nru, int ncc,
                           DoublePointer d, DoublePointer e, DoublePointer vt, int ldvt,
                           DoublePointer u, int ldu, DoublePointer c,
                           int ldc );
public static native int LAPACKE_dbdsqr( int matrix_layout, @Cast("char") byte uplo, int n,
                           int ncvt, int nru, int ncc,
                           DoubleBuffer d, DoubleBuffer e, DoubleBuffer vt, int ldvt,
                           DoubleBuffer u, int ldu, DoubleBuffer c,
                           int ldc );
public static native int LAPACKE_dbdsqr( int matrix_layout, @Cast("char") byte uplo, int n,
                           int ncvt, int nru, int ncc,
                           double[] d, double[] e, double[] vt, int ldvt,
                           double[] u, int ldu, double[] c,
                           int ldc );
public static native int LAPACKE_cbdsqr( int matrix_layout, @Cast("char") byte uplo, int n,
                           int ncvt, int nru, int ncc,
                           FloatPointer d, FloatPointer e, @Cast("lapack_complex_float*") FloatPointer vt,
                           int ldvt, @Cast("lapack_complex_float*") FloatPointer u,
                           int ldu, @Cast("lapack_complex_float*") FloatPointer c,
                           int ldc );
public static native int LAPACKE_cbdsqr( int matrix_layout, @Cast("char") byte uplo, int n,
                           int ncvt, int nru, int ncc,
                           FloatBuffer d, FloatBuffer e, @Cast("lapack_complex_float*") FloatBuffer vt,
                           int ldvt, @Cast("lapack_complex_float*") FloatBuffer u,
                           int ldu, @Cast("lapack_complex_float*") FloatBuffer c,
                           int ldc );
public static native int LAPACKE_cbdsqr( int matrix_layout, @Cast("char") byte uplo, int n,
                           int ncvt, int nru, int ncc,
                           float[] d, float[] e, @Cast("lapack_complex_float*") float[] vt,
                           int ldvt, @Cast("lapack_complex_float*") float[] u,
                           int ldu, @Cast("lapack_complex_float*") float[] c,
                           int ldc );
public static native int LAPACKE_zbdsqr( int matrix_layout, @Cast("char") byte uplo, int n,
                           int ncvt, int nru, int ncc,
                           DoublePointer d, DoublePointer e, @Cast("lapack_complex_double*") DoublePointer vt,
                           int ldvt, @Cast("lapack_complex_double*") DoublePointer u,
                           int ldu, @Cast("lapack_complex_double*") DoublePointer c,
                           int ldc );
public static native int LAPACKE_zbdsqr( int matrix_layout, @Cast("char") byte uplo, int n,
                           int ncvt, int nru, int ncc,
                           DoubleBuffer d, DoubleBuffer e, @Cast("lapack_complex_double*") DoubleBuffer vt,
                           int ldvt, @Cast("lapack_complex_double*") DoubleBuffer u,
                           int ldu, @Cast("lapack_complex_double*") DoubleBuffer c,
                           int ldc );
public static native int LAPACKE_zbdsqr( int matrix_layout, @Cast("char") byte uplo, int n,
                           int ncvt, int nru, int ncc,
                           double[] d, double[] e, @Cast("lapack_complex_double*") double[] vt,
                           int ldvt, @Cast("lapack_complex_double*") double[] u,
                           int ldu, @Cast("lapack_complex_double*") double[] c,
                           int ldc );
public static native int LAPACKE_sbdsvdx( int matrix_layout, @Cast("char") byte uplo, @Cast("char") byte jobz, @Cast("char") byte range,
                           int n, FloatPointer d, FloatPointer e,
                           float vl, float vu,
                           int il, int iu, IntPointer ns,
                           FloatPointer s, FloatPointer z, int ldz,
                           IntPointer superb );
public static native int LAPACKE_sbdsvdx( int matrix_layout, @Cast("char") byte uplo, @Cast("char") byte jobz, @Cast("char") byte range,
                           int n, FloatBuffer d, FloatBuffer e,
                           float vl, float vu,
                           int il, int iu, IntBuffer ns,
                           FloatBuffer s, FloatBuffer z, int ldz,
                           IntBuffer superb );
public static native int LAPACKE_sbdsvdx( int matrix_layout, @Cast("char") byte uplo, @Cast("char") byte jobz, @Cast("char") byte range,
                           int n, float[] d, float[] e,
                           float vl, float vu,
                           int il, int iu, int[] ns,
                           float[] s, float[] z, int ldz,
                           int[] superb );
public static native int LAPACKE_dbdsvdx( int matrix_layout, @Cast("char") byte uplo, @Cast("char") byte jobz, @Cast("char") byte range,
                           int n, DoublePointer d, DoublePointer e,
                           double vl, double vu,
                           int il, int iu, IntPointer ns,
                           DoublePointer s, DoublePointer z, int ldz,
                           IntPointer superb );
public static native int LAPACKE_dbdsvdx( int matrix_layout, @Cast("char") byte uplo, @Cast("char") byte jobz, @Cast("char") byte range,
                           int n, DoubleBuffer d, DoubleBuffer e,
                           double vl, double vu,
                           int il, int iu, IntBuffer ns,
                           DoubleBuffer s, DoubleBuffer z, int ldz,
                           IntBuffer superb );
public static native int LAPACKE_dbdsvdx( int matrix_layout, @Cast("char") byte uplo, @Cast("char") byte jobz, @Cast("char") byte range,
                           int n, double[] d, double[] e,
                           double vl, double vu,
                           int il, int iu, int[] ns,
                           double[] s, double[] z, int ldz,
                           int[] superb );
public static native int LAPACKE_sdisna( @Cast("char") byte job, int m, int n, @Const FloatPointer d,
                           FloatPointer sep );
public static native int LAPACKE_sdisna( @Cast("char") byte job, int m, int n, @Const FloatBuffer d,
                           FloatBuffer sep );
public static native int LAPACKE_sdisna( @Cast("char") byte job, int m, int n, @Const float[] d,
                           float[] sep );
public static native int LAPACKE_ddisna( @Cast("char") byte job, int m, int n,
                           @Const DoublePointer d, DoublePointer sep );
public static native int LAPACKE_ddisna( @Cast("char") byte job, int m, int n,
                           @Const DoubleBuffer d, DoubleBuffer sep );
public static native int LAPACKE_ddisna( @Cast("char") byte job, int m, int n,
                           @Const double[] d, double[] sep );

public static native int LAPACKE_sgbbrd( int matrix_layout, @Cast("char") byte vect, int m,
                           int n, int ncc, int kl,
                           int ku, FloatPointer ab, int ldab, FloatPointer d,
                           FloatPointer e, FloatPointer q, int ldq, FloatPointer pt,
                           int ldpt, FloatPointer c, int ldc );
public static native int LAPACKE_sgbbrd( int matrix_layout, @Cast("char") byte vect, int m,
                           int n, int ncc, int kl,
                           int ku, FloatBuffer ab, int ldab, FloatBuffer d,
                           FloatBuffer e, FloatBuffer q, int ldq, FloatBuffer pt,
                           int ldpt, FloatBuffer c, int ldc );
public static native int LAPACKE_sgbbrd( int matrix_layout, @Cast("char") byte vect, int m,
                           int n, int ncc, int kl,
                           int ku, float[] ab, int ldab, float[] d,
                           float[] e, float[] q, int ldq, float[] pt,
                           int ldpt, float[] c, int ldc );
public static native int LAPACKE_dgbbrd( int matrix_layout, @Cast("char") byte vect, int m,
                           int n, int ncc, int kl,
                           int ku, DoublePointer ab, int ldab,
                           DoublePointer d, DoublePointer e, DoublePointer q, int ldq,
                           DoublePointer pt, int ldpt, DoublePointer c,
                           int ldc );
public static native int LAPACKE_dgbbrd( int matrix_layout, @Cast("char") byte vect, int m,
                           int n, int ncc, int kl,
                           int ku, DoubleBuffer ab, int ldab,
                           DoubleBuffer d, DoubleBuffer e, DoubleBuffer q, int ldq,
                           DoubleBuffer pt, int ldpt, DoubleBuffer c,
                           int ldc );
public static native int LAPACKE_dgbbrd( int matrix_layout, @Cast("char") byte vect, int m,
                           int n, int ncc, int kl,
                           int ku, double[] ab, int ldab,
                           double[] d, double[] e, double[] q, int ldq,
                           double[] pt, int ldpt, double[] c,
                           int ldc );
public static native int LAPACKE_cgbbrd( int matrix_layout, @Cast("char") byte vect, int m,
                           int n, int ncc, int kl,
                           int ku, @Cast("lapack_complex_float*") FloatPointer ab,
                           int ldab, FloatPointer d, FloatPointer e,
                           @Cast("lapack_complex_float*") FloatPointer q, int ldq,
                           @Cast("lapack_complex_float*") FloatPointer pt, int ldpt,
                           @Cast("lapack_complex_float*") FloatPointer c, int ldc );
public static native int LAPACKE_cgbbrd( int matrix_layout, @Cast("char") byte vect, int m,
                           int n, int ncc, int kl,
                           int ku, @Cast("lapack_complex_float*") FloatBuffer ab,
                           int ldab, FloatBuffer d, FloatBuffer e,
                           @Cast("lapack_complex_float*") FloatBuffer q, int ldq,
                           @Cast("lapack_complex_float*") FloatBuffer pt, int ldpt,
                           @Cast("lapack_complex_float*") FloatBuffer c, int ldc );
public static native int LAPACKE_cgbbrd( int matrix_layout, @Cast("char") byte vect, int m,
                           int n, int ncc, int kl,
                           int ku, @Cast("lapack_complex_float*") float[] ab,
                           int ldab, float[] d, float[] e,
                           @Cast("lapack_complex_float*") float[] q, int ldq,
                           @Cast("lapack_complex_float*") float[] pt, int ldpt,
                           @Cast("lapack_complex_float*") float[] c, int ldc );
public static native int LAPACKE_zgbbrd( int matrix_layout, @Cast("char") byte vect, int m,
                           int n, int ncc, int kl,
                           int ku, @Cast("lapack_complex_double*") DoublePointer ab,
                           int ldab, DoublePointer d, DoublePointer e,
                           @Cast("lapack_complex_double*") DoublePointer q, int ldq,
                           @Cast("lapack_complex_double*") DoublePointer pt, int ldpt,
                           @Cast("lapack_complex_double*") DoublePointer c, int ldc );
public static native int LAPACKE_zgbbrd( int matrix_layout, @Cast("char") byte vect, int m,
                           int n, int ncc, int kl,
                           int ku, @Cast("lapack_complex_double*") DoubleBuffer ab,
                           int ldab, DoubleBuffer d, DoubleBuffer e,
                           @Cast("lapack_complex_double*") DoubleBuffer q, int ldq,
                           @Cast("lapack_complex_double*") DoubleBuffer pt, int ldpt,
                           @Cast("lapack_complex_double*") DoubleBuffer c, int ldc );
public static native int LAPACKE_zgbbrd( int matrix_layout, @Cast("char") byte vect, int m,
                           int n, int ncc, int kl,
                           int ku, @Cast("lapack_complex_double*") double[] ab,
                           int ldab, double[] d, double[] e,
                           @Cast("lapack_complex_double*") double[] q, int ldq,
                           @Cast("lapack_complex_double*") double[] pt, int ldpt,
                           @Cast("lapack_complex_double*") double[] c, int ldc );

public static native int LAPACKE_sgbcon( int matrix_layout, @Cast("char") byte norm, int n,
                           int kl, int ku, @Const FloatPointer ab,
                           int ldab, @Const IntPointer ipiv, float anorm,
                           FloatPointer rcond );
public static native int LAPACKE_sgbcon( int matrix_layout, @Cast("char") byte norm, int n,
                           int kl, int ku, @Const FloatBuffer ab,
                           int ldab, @Const IntBuffer ipiv, float anorm,
                           FloatBuffer rcond );
public static native int LAPACKE_sgbcon( int matrix_layout, @Cast("char") byte norm, int n,
                           int kl, int ku, @Const float[] ab,
                           int ldab, @Const int[] ipiv, float anorm,
                           float[] rcond );
public static native int LAPACKE_dgbcon( int matrix_layout, @Cast("char") byte norm, int n,
                           int kl, int ku, @Const DoublePointer ab,
                           int ldab, @Const IntPointer ipiv,
                           double anorm, DoublePointer rcond );
public static native int LAPACKE_dgbcon( int matrix_layout, @Cast("char") byte norm, int n,
                           int kl, int ku, @Const DoubleBuffer ab,
                           int ldab, @Const IntBuffer ipiv,
                           double anorm, DoubleBuffer rcond );
public static native int LAPACKE_dgbcon( int matrix_layout, @Cast("char") byte norm, int n,
                           int kl, int ku, @Const double[] ab,
                           int ldab, @Const int[] ipiv,
                           double anorm, double[] rcond );
public static native int LAPACKE_cgbcon( int matrix_layout, @Cast("char") byte norm, int n,
                           int kl, int ku,
                           @Cast("const lapack_complex_float*") FloatPointer ab, int ldab,
                           @Const IntPointer ipiv, float anorm, FloatPointer rcond );
public static native int LAPACKE_cgbcon( int matrix_layout, @Cast("char") byte norm, int n,
                           int kl, int ku,
                           @Cast("const lapack_complex_float*") FloatBuffer ab, int ldab,
                           @Const IntBuffer ipiv, float anorm, FloatBuffer rcond );
public static native int LAPACKE_cgbcon( int matrix_layout, @Cast("char") byte norm, int n,
                           int kl, int ku,
                           @Cast("const lapack_complex_float*") float[] ab, int ldab,
                           @Const int[] ipiv, float anorm, float[] rcond );
public static native int LAPACKE_zgbcon( int matrix_layout, @Cast("char") byte norm, int n,
                           int kl, int ku,
                           @Cast("const lapack_complex_double*") DoublePointer ab, int ldab,
                           @Const IntPointer ipiv, double anorm,
                           DoublePointer rcond );
public static native int LAPACKE_zgbcon( int matrix_layout, @Cast("char") byte norm, int n,
                           int kl, int ku,
                           @Cast("const lapack_complex_double*") DoubleBuffer ab, int ldab,
                           @Const IntBuffer ipiv, double anorm,
                           DoubleBuffer rcond );
public static native int LAPACKE_zgbcon( int matrix_layout, @Cast("char") byte norm, int n,
                           int kl, int ku,
                           @Cast("const lapack_complex_double*") double[] ab, int ldab,
                           @Const int[] ipiv, double anorm,
                           double[] rcond );

public static native int LAPACKE_sgbequ( int matrix_layout, int m, int n,
                           int kl, int ku, @Const FloatPointer ab,
                           int ldab, FloatPointer r, FloatPointer c, FloatPointer rowcnd,
                           FloatPointer colcnd, FloatPointer amax );
public static native int LAPACKE_sgbequ( int matrix_layout, int m, int n,
                           int kl, int ku, @Const FloatBuffer ab,
                           int ldab, FloatBuffer r, FloatBuffer c, FloatBuffer rowcnd,
                           FloatBuffer colcnd, FloatBuffer amax );
public static native int LAPACKE_sgbequ( int matrix_layout, int m, int n,
                           int kl, int ku, @Const float[] ab,
                           int ldab, float[] r, float[] c, float[] rowcnd,
                           float[] colcnd, float[] amax );
public static native int LAPACKE_dgbequ( int matrix_layout, int m, int n,
                           int kl, int ku, @Const DoublePointer ab,
                           int ldab, DoublePointer r, DoublePointer c,
                           DoublePointer rowcnd, DoublePointer colcnd, DoublePointer amax );
public static native int LAPACKE_dgbequ( int matrix_layout, int m, int n,
                           int kl, int ku, @Const DoubleBuffer ab,
                           int ldab, DoubleBuffer r, DoubleBuffer c,
                           DoubleBuffer rowcnd, DoubleBuffer colcnd, DoubleBuffer amax );
public static native int LAPACKE_dgbequ( int matrix_layout, int m, int n,
                           int kl, int ku, @Const double[] ab,
                           int ldab, double[] r, double[] c,
                           double[] rowcnd, double[] colcnd, double[] amax );
public static native int LAPACKE_cgbequ( int matrix_layout, int m, int n,
                           int kl, int ku,
                           @Cast("const lapack_complex_float*") FloatPointer ab, int ldab,
                           FloatPointer r, FloatPointer c, FloatPointer rowcnd, FloatPointer colcnd,
                           FloatPointer amax );
public static native int LAPACKE_cgbequ( int matrix_layout, int m, int n,
                           int kl, int ku,
                           @Cast("const lapack_complex_float*") FloatBuffer ab, int ldab,
                           FloatBuffer r, FloatBuffer c, FloatBuffer rowcnd, FloatBuffer colcnd,
                           FloatBuffer amax );
public static native int LAPACKE_cgbequ( int matrix_layout, int m, int n,
                           int kl, int ku,
                           @Cast("const lapack_complex_float*") float[] ab, int ldab,
                           float[] r, float[] c, float[] rowcnd, float[] colcnd,
                           float[] amax );
public static native int LAPACKE_zgbequ( int matrix_layout, int m, int n,
                           int kl, int ku,
                           @Cast("const lapack_complex_double*") DoublePointer ab, int ldab,
                           DoublePointer r, DoublePointer c, DoublePointer rowcnd, DoublePointer colcnd,
                           DoublePointer amax );
public static native int LAPACKE_zgbequ( int matrix_layout, int m, int n,
                           int kl, int ku,
                           @Cast("const lapack_complex_double*") DoubleBuffer ab, int ldab,
                           DoubleBuffer r, DoubleBuffer c, DoubleBuffer rowcnd, DoubleBuffer colcnd,
                           DoubleBuffer amax );
public static native int LAPACKE_zgbequ( int matrix_layout, int m, int n,
                           int kl, int ku,
                           @Cast("const lapack_complex_double*") double[] ab, int ldab,
                           double[] r, double[] c, double[] rowcnd, double[] colcnd,
                           double[] amax );

public static native int LAPACKE_sgbequb( int matrix_layout, int m, int n,
                            int kl, int ku, @Const FloatPointer ab,
                            int ldab, FloatPointer r, FloatPointer c, FloatPointer rowcnd,
                            FloatPointer colcnd, FloatPointer amax );
public static native int LAPACKE_sgbequb( int matrix_layout, int m, int n,
                            int kl, int ku, @Const FloatBuffer ab,
                            int ldab, FloatBuffer r, FloatBuffer c, FloatBuffer rowcnd,
                            FloatBuffer colcnd, FloatBuffer amax );
public static native int LAPACKE_sgbequb( int matrix_layout, int m, int n,
                            int kl, int ku, @Const float[] ab,
                            int ldab, float[] r, float[] c, float[] rowcnd,
                            float[] colcnd, float[] amax );
public static native int LAPACKE_dgbequb( int matrix_layout, int m, int n,
                            int kl, int ku, @Const DoublePointer ab,
                            int ldab, DoublePointer r, DoublePointer c,
                            DoublePointer rowcnd, DoublePointer colcnd, DoublePointer amax );
public static native int LAPACKE_dgbequb( int matrix_layout, int m, int n,
                            int kl, int ku, @Const DoubleBuffer ab,
                            int ldab, DoubleBuffer r, DoubleBuffer c,
                            DoubleBuffer rowcnd, DoubleBuffer colcnd, DoubleBuffer amax );
public static native int LAPACKE_dgbequb( int matrix_layout, int m, int n,
                            int kl, int ku, @Const double[] ab,
                            int ldab, double[] r, double[] c,
                            double[] rowcnd, double[] colcnd, double[] amax );
public static native int LAPACKE_cgbequb( int matrix_layout, int m, int n,
                            int kl, int ku,
                            @Cast("const lapack_complex_float*") FloatPointer ab, int ldab,
                            FloatPointer r, FloatPointer c, FloatPointer rowcnd, FloatPointer colcnd,
                            FloatPointer amax );
public static native int LAPACKE_cgbequb( int matrix_layout, int m, int n,
                            int kl, int ku,
                            @Cast("const lapack_complex_float*") FloatBuffer ab, int ldab,
                            FloatBuffer r, FloatBuffer c, FloatBuffer rowcnd, FloatBuffer colcnd,
                            FloatBuffer amax );
public static native int LAPACKE_cgbequb( int matrix_layout, int m, int n,
                            int kl, int ku,
                            @Cast("const lapack_complex_float*") float[] ab, int ldab,
                            float[] r, float[] c, float[] rowcnd, float[] colcnd,
                            float[] amax );
public static native int LAPACKE_zgbequb( int matrix_layout, int m, int n,
                            int kl, int ku,
                            @Cast("const lapack_complex_double*") DoublePointer ab, int ldab,
                            DoublePointer r, DoublePointer c, DoublePointer rowcnd,
                            DoublePointer colcnd, DoublePointer amax );
public static native int LAPACKE_zgbequb( int matrix_layout, int m, int n,
                            int kl, int ku,
                            @Cast("const lapack_complex_double*") DoubleBuffer ab, int ldab,
                            DoubleBuffer r, DoubleBuffer c, DoubleBuffer rowcnd,
                            DoubleBuffer colcnd, DoubleBuffer amax );
public static native int LAPACKE_zgbequb( int matrix_layout, int m, int n,
                            int kl, int ku,
                            @Cast("const lapack_complex_double*") double[] ab, int ldab,
                            double[] r, double[] c, double[] rowcnd,
                            double[] colcnd, double[] amax );

public static native int LAPACKE_sgbrfs( int matrix_layout, @Cast("char") byte trans, int n,
                           int kl, int ku, int nrhs,
                           @Const FloatPointer ab, int ldab, @Const FloatPointer afb,
                           int ldafb, @Const IntPointer ipiv,
                           @Const FloatPointer b, int ldb, FloatPointer x,
                           int ldx, FloatPointer ferr, FloatPointer berr );
public static native int LAPACKE_sgbrfs( int matrix_layout, @Cast("char") byte trans, int n,
                           int kl, int ku, int nrhs,
                           @Const FloatBuffer ab, int ldab, @Const FloatBuffer afb,
                           int ldafb, @Const IntBuffer ipiv,
                           @Const FloatBuffer b, int ldb, FloatBuffer x,
                           int ldx, FloatBuffer ferr, FloatBuffer berr );
public static native int LAPACKE_sgbrfs( int matrix_layout, @Cast("char") byte trans, int n,
                           int kl, int ku, int nrhs,
                           @Const float[] ab, int ldab, @Const float[] afb,
                           int ldafb, @Const int[] ipiv,
                           @Const float[] b, int ldb, float[] x,
                           int ldx, float[] ferr, float[] berr );
public static native int LAPACKE_dgbrfs( int matrix_layout, @Cast("char") byte trans, int n,
                           int kl, int ku, int nrhs,
                           @Const DoublePointer ab, int ldab, @Const DoublePointer afb,
                           int ldafb, @Const IntPointer ipiv,
                           @Const DoublePointer b, int ldb, DoublePointer x,
                           int ldx, DoublePointer ferr, DoublePointer berr );
public static native int LAPACKE_dgbrfs( int matrix_layout, @Cast("char") byte trans, int n,
                           int kl, int ku, int nrhs,
                           @Const DoubleBuffer ab, int ldab, @Const DoubleBuffer afb,
                           int ldafb, @Const IntBuffer ipiv,
                           @Const DoubleBuffer b, int ldb, DoubleBuffer x,
                           int ldx, DoubleBuffer ferr, DoubleBuffer berr );
public static native int LAPACKE_dgbrfs( int matrix_layout, @Cast("char") byte trans, int n,
                           int kl, int ku, int nrhs,
                           @Const double[] ab, int ldab, @Const double[] afb,
                           int ldafb, @Const int[] ipiv,
                           @Const double[] b, int ldb, double[] x,
                           int ldx, double[] ferr, double[] berr );
public static native int LAPACKE_cgbrfs( int matrix_layout, @Cast("char") byte trans, int n,
                           int kl, int ku, int nrhs,
                           @Cast("const lapack_complex_float*") FloatPointer ab, int ldab,
                           @Cast("const lapack_complex_float*") FloatPointer afb, int ldafb,
                           @Const IntPointer ipiv,
                           @Cast("const lapack_complex_float*") FloatPointer b, int ldb,
                           @Cast("lapack_complex_float*") FloatPointer x, int ldx, FloatPointer ferr,
                           FloatPointer berr );
public static native int LAPACKE_cgbrfs( int matrix_layout, @Cast("char") byte trans, int n,
                           int kl, int ku, int nrhs,
                           @Cast("const lapack_complex_float*") FloatBuffer ab, int ldab,
                           @Cast("const lapack_complex_float*") FloatBuffer afb, int ldafb,
                           @Const IntBuffer ipiv,
                           @Cast("const lapack_complex_float*") FloatBuffer b, int ldb,
                           @Cast("lapack_complex_float*") FloatBuffer x, int ldx, FloatBuffer ferr,
                           FloatBuffer berr );
public static native int LAPACKE_cgbrfs( int matrix_layout, @Cast("char") byte trans, int n,
                           int kl, int ku, int nrhs,
                           @Cast("const lapack_complex_float*") float[] ab, int ldab,
                           @Cast("const lapack_complex_float*") float[] afb, int ldafb,
                           @Const int[] ipiv,
                           @Cast("const lapack_complex_float*") float[] b, int ldb,
                           @Cast("lapack_complex_float*") float[] x, int ldx, float[] ferr,
                           float[] berr );
public static native int LAPACKE_zgbrfs( int matrix_layout, @Cast("char") byte trans, int n,
                           int kl, int ku, int nrhs,
                           @Cast("const lapack_complex_double*") DoublePointer ab, int ldab,
                           @Cast("const lapack_complex_double*") DoublePointer afb, int ldafb,
                           @Const IntPointer ipiv,
                           @Cast("const lapack_complex_double*") DoublePointer b, int ldb,
                           @Cast("lapack_complex_double*") DoublePointer x, int ldx,
                           DoublePointer ferr, DoublePointer berr );
public static native int LAPACKE_zgbrfs( int matrix_layout, @Cast("char") byte trans, int n,
                           int kl, int ku, int nrhs,
                           @Cast("const lapack_complex_double*") DoubleBuffer ab, int ldab,
                           @Cast("const lapack_complex_double*") DoubleBuffer afb, int ldafb,
                           @Const IntBuffer ipiv,
                           @Cast("const lapack_complex_double*") DoubleBuffer b, int ldb,
                           @Cast("lapack_complex_double*") DoubleBuffer x, int ldx,
                           DoubleBuffer ferr, DoubleBuffer berr );
public static native int LAPACKE_zgbrfs( int matrix_layout, @Cast("char") byte trans, int n,
                           int kl, int ku, int nrhs,
                           @Cast("const lapack_complex_double*") double[] ab, int ldab,
                           @Cast("const lapack_complex_double*") double[] afb, int ldafb,
                           @Const int[] ipiv,
                           @Cast("const lapack_complex_double*") double[] b, int ldb,
                           @Cast("lapack_complex_double*") double[] x, int ldx,
                           double[] ferr, double[] berr );






public static native int LAPACKE_sgbsv( int matrix_layout, int n, int kl,
                          int ku, int nrhs, FloatPointer ab,
                          int ldab, IntPointer ipiv, FloatPointer b,
                          int ldb );
public static native int LAPACKE_sgbsv( int matrix_layout, int n, int kl,
                          int ku, int nrhs, FloatBuffer ab,
                          int ldab, IntBuffer ipiv, FloatBuffer b,
                          int ldb );
public static native int LAPACKE_sgbsv( int matrix_layout, int n, int kl,
                          int ku, int nrhs, float[] ab,
                          int ldab, int[] ipiv, float[] b,
                          int ldb );
public static native int LAPACKE_dgbsv( int matrix_layout, int n, int kl,
                          int ku, int nrhs, DoublePointer ab,
                          int ldab, IntPointer ipiv, DoublePointer b,
                          int ldb );
public static native int LAPACKE_dgbsv( int matrix_layout, int n, int kl,
                          int ku, int nrhs, DoubleBuffer ab,
                          int ldab, IntBuffer ipiv, DoubleBuffer b,
                          int ldb );
public static native int LAPACKE_dgbsv( int matrix_layout, int n, int kl,
                          int ku, int nrhs, double[] ab,
                          int ldab, int[] ipiv, double[] b,
                          int ldb );
public static native int LAPACKE_cgbsv( int matrix_layout, int n, int kl,
                          int ku, int nrhs,
                          @Cast("lapack_complex_float*") FloatPointer ab, int ldab,
                          IntPointer ipiv, @Cast("lapack_complex_float*") FloatPointer b,
                          int ldb );
public static native int LAPACKE_cgbsv( int matrix_layout, int n, int kl,
                          int ku, int nrhs,
                          @Cast("lapack_complex_float*") FloatBuffer ab, int ldab,
                          IntBuffer ipiv, @Cast("lapack_complex_float*") FloatBuffer b,
                          int ldb );
public static native int LAPACKE_cgbsv( int matrix_layout, int n, int kl,
                          int ku, int nrhs,
                          @Cast("lapack_complex_float*") float[] ab, int ldab,
                          int[] ipiv, @Cast("lapack_complex_float*") float[] b,
                          int ldb );
public static native int LAPACKE_zgbsv( int matrix_layout, int n, int kl,
                          int ku, int nrhs,
                          @Cast("lapack_complex_double*") DoublePointer ab, int ldab,
                          IntPointer ipiv, @Cast("lapack_complex_double*") DoublePointer b,
                          int ldb );
public static native int LAPACKE_zgbsv( int matrix_layout, int n, int kl,
                          int ku, int nrhs,
                          @Cast("lapack_complex_double*") DoubleBuffer ab, int ldab,
                          IntBuffer ipiv, @Cast("lapack_complex_double*") DoubleBuffer b,
                          int ldb );
public static native int LAPACKE_zgbsv( int matrix_layout, int n, int kl,
                          int ku, int nrhs,
                          @Cast("lapack_complex_double*") double[] ab, int ldab,
                          int[] ipiv, @Cast("lapack_complex_double*") double[] b,
                          int ldb );

public static native int LAPACKE_sgbsvx( int matrix_layout, @Cast("char") byte fact, @Cast("char") byte trans,
                           int n, int kl, int ku,
                           int nrhs, FloatPointer ab, int ldab,
                           FloatPointer afb, int ldafb, IntPointer ipiv,
                           @Cast("char*") BytePointer equed, FloatPointer r, FloatPointer c, FloatPointer b,
                           int ldb, FloatPointer x, int ldx,
                           FloatPointer rcond, FloatPointer ferr, FloatPointer berr,
                           FloatPointer rpivot );
public static native int LAPACKE_sgbsvx( int matrix_layout, @Cast("char") byte fact, @Cast("char") byte trans,
                           int n, int kl, int ku,
                           int nrhs, FloatBuffer ab, int ldab,
                           FloatBuffer afb, int ldafb, IntBuffer ipiv,
                           @Cast("char*") ByteBuffer equed, FloatBuffer r, FloatBuffer c, FloatBuffer b,
                           int ldb, FloatBuffer x, int ldx,
                           FloatBuffer rcond, FloatBuffer ferr, FloatBuffer berr,
                           FloatBuffer rpivot );
public static native int LAPACKE_sgbsvx( int matrix_layout, @Cast("char") byte fact, @Cast("char") byte trans,
                           int n, int kl, int ku,
                           int nrhs, float[] ab, int ldab,
                           float[] afb, int ldafb, int[] ipiv,
                           @Cast("char*") byte[] equed, float[] r, float[] c, float[] b,
                           int ldb, float[] x, int ldx,
                           float[] rcond, float[] ferr, float[] berr,
                           float[] rpivot );
public static native int LAPACKE_dgbsvx( int matrix_layout, @Cast("char") byte fact, @Cast("char") byte trans,
                           int n, int kl, int ku,
                           int nrhs, DoublePointer ab, int ldab,
                           DoublePointer afb, int ldafb, IntPointer ipiv,
                           @Cast("char*") BytePointer equed, DoublePointer r, DoublePointer c, DoublePointer b,
                           int ldb, DoublePointer x, int ldx,
                           DoublePointer rcond, DoublePointer ferr, DoublePointer berr,
                           DoublePointer rpivot );
public static native int LAPACKE_dgbsvx( int matrix_layout, @Cast("char") byte fact, @Cast("char") byte trans,
                           int n, int kl, int ku,
                           int nrhs, DoubleBuffer ab, int ldab,
                           DoubleBuffer afb, int ldafb, IntBuffer ipiv,
                           @Cast("char*") ByteBuffer equed, DoubleBuffer r, DoubleBuffer c, DoubleBuffer b,
                           int ldb, DoubleBuffer x, int ldx,
                           DoubleBuffer rcond, DoubleBuffer ferr, DoubleBuffer berr,
                           DoubleBuffer rpivot );
public static native int LAPACKE_dgbsvx( int matrix_layout, @Cast("char") byte fact, @Cast("char") byte trans,
                           int n, int kl, int ku,
                           int nrhs, double[] ab, int ldab,
                           double[] afb, int ldafb, int[] ipiv,
                           @Cast("char*") byte[] equed, double[] r, double[] c, double[] b,
                           int ldb, double[] x, int ldx,
                           double[] rcond, double[] ferr, double[] berr,
                           double[] rpivot );
public static native int LAPACKE_cgbsvx( int matrix_layout, @Cast("char") byte fact, @Cast("char") byte trans,
                           int n, int kl, int ku,
                           int nrhs, @Cast("lapack_complex_float*") FloatPointer ab,
                           int ldab, @Cast("lapack_complex_float*") FloatPointer afb,
                           int ldafb, IntPointer ipiv, @Cast("char*") BytePointer equed,
                           FloatPointer r, FloatPointer c, @Cast("lapack_complex_float*") FloatPointer b,
                           int ldb, @Cast("lapack_complex_float*") FloatPointer x,
                           int ldx, FloatPointer rcond, FloatPointer ferr,
                           FloatPointer berr, FloatPointer rpivot );
public static native int LAPACKE_cgbsvx( int matrix_layout, @Cast("char") byte fact, @Cast("char") byte trans,
                           int n, int kl, int ku,
                           int nrhs, @Cast("lapack_complex_float*") FloatBuffer ab,
                           int ldab, @Cast("lapack_complex_float*") FloatBuffer afb,
                           int ldafb, IntBuffer ipiv, @Cast("char*") ByteBuffer equed,
                           FloatBuffer r, FloatBuffer c, @Cast("lapack_complex_float*") FloatBuffer b,
                           int ldb, @Cast("lapack_complex_float*") FloatBuffer x,
                           int ldx, FloatBuffer rcond, FloatBuffer ferr,
                           FloatBuffer berr, FloatBuffer rpivot );
public static native int LAPACKE_cgbsvx( int matrix_layout, @Cast("char") byte fact, @Cast("char") byte trans,
                           int n, int kl, int ku,
                           int nrhs, @Cast("lapack_complex_float*") float[] ab,
                           int ldab, @Cast("lapack_complex_float*") float[] afb,
                           int ldafb, int[] ipiv, @Cast("char*") byte[] equed,
                           float[] r, float[] c, @Cast("lapack_complex_float*") float[] b,
                           int ldb, @Cast("lapack_complex_float*") float[] x,
                           int ldx, float[] rcond, float[] ferr,
                           float[] berr, float[] rpivot );
public static native int LAPACKE_zgbsvx( int matrix_layout, @Cast("char") byte fact, @Cast("char") byte trans,
                           int n, int kl, int ku,
                           int nrhs, @Cast("lapack_complex_double*") DoublePointer ab,
                           int ldab, @Cast("lapack_complex_double*") DoublePointer afb,
                           int ldafb, IntPointer ipiv, @Cast("char*") BytePointer equed,
                           DoublePointer r, DoublePointer c, @Cast("lapack_complex_double*") DoublePointer b,
                           int ldb, @Cast("lapack_complex_double*") DoublePointer x,
                           int ldx, DoublePointer rcond, DoublePointer ferr,
                           DoublePointer berr, DoublePointer rpivot );
public static native int LAPACKE_zgbsvx( int matrix_layout, @Cast("char") byte fact, @Cast("char") byte trans,
                           int n, int kl, int ku,
                           int nrhs, @Cast("lapack_complex_double*") DoubleBuffer ab,
                           int ldab, @Cast("lapack_complex_double*") DoubleBuffer afb,
                           int ldafb, IntBuffer ipiv, @Cast("char*") ByteBuffer equed,
                           DoubleBuffer r, DoubleBuffer c, @Cast("lapack_complex_double*") DoubleBuffer b,
                           int ldb, @Cast("lapack_complex_double*") DoubleBuffer x,
                           int ldx, DoubleBuffer rcond, DoubleBuffer ferr,
                           DoubleBuffer berr, DoubleBuffer rpivot );
public static native int LAPACKE_zgbsvx( int matrix_layout, @Cast("char") byte fact, @Cast("char") byte trans,
                           int n, int kl, int ku,
                           int nrhs, @Cast("lapack_complex_double*") double[] ab,
                           int ldab, @Cast("lapack_complex_double*") double[] afb,
                           int ldafb, int[] ipiv, @Cast("char*") byte[] equed,
                           double[] r, double[] c, @Cast("lapack_complex_double*") double[] b,
                           int ldb, @Cast("lapack_complex_double*") double[] x,
                           int ldx, double[] rcond, double[] ferr,
                           double[] berr, double[] rpivot );






public static native int LAPACKE_sgbtrf( int matrix_layout, int m, int n,
                           int kl, int ku, FloatPointer ab,
                           int ldab, IntPointer ipiv );
public static native int LAPACKE_sgbtrf( int matrix_layout, int m, int n,
                           int kl, int ku, FloatBuffer ab,
                           int ldab, IntBuffer ipiv );
public static native int LAPACKE_sgbtrf( int matrix_layout, int m, int n,
                           int kl, int ku, float[] ab,
                           int ldab, int[] ipiv );
public static native int LAPACKE_dgbtrf( int matrix_layout, int m, int n,
                           int kl, int ku, DoublePointer ab,
                           int ldab, IntPointer ipiv );
public static native int LAPACKE_dgbtrf( int matrix_layout, int m, int n,
                           int kl, int ku, DoubleBuffer ab,
                           int ldab, IntBuffer ipiv );
public static native int LAPACKE_dgbtrf( int matrix_layout, int m, int n,
                           int kl, int ku, double[] ab,
                           int ldab, int[] ipiv );
public static native int LAPACKE_cgbtrf( int matrix_layout, int m, int n,
                           int kl, int ku,
                           @Cast("lapack_complex_float*") FloatPointer ab, int ldab,
                           IntPointer ipiv );
public static native int LAPACKE_cgbtrf( int matrix_layout, int m, int n,
                           int kl, int ku,
                           @Cast("lapack_complex_float*") FloatBuffer ab, int ldab,
                           IntBuffer ipiv );
public static native int LAPACKE_cgbtrf( int matrix_layout, int m, int n,
                           int kl, int ku,
                           @Cast("lapack_complex_float*") float[] ab, int ldab,
                           int[] ipiv );
public static native int LAPACKE_zgbtrf( int matrix_layout, int m, int n,
                           int kl, int ku,
                           @Cast("lapack_complex_double*") DoublePointer ab, int ldab,
                           IntPointer ipiv );
public static native int LAPACKE_zgbtrf( int matrix_layout, int m, int n,
                           int kl, int ku,
                           @Cast("lapack_complex_double*") DoubleBuffer ab, int ldab,
                           IntBuffer ipiv );
public static native int LAPACKE_zgbtrf( int matrix_layout, int m, int n,
                           int kl, int ku,
                           @Cast("lapack_complex_double*") double[] ab, int ldab,
                           int[] ipiv );

public static native int LAPACKE_sgbtrs( int matrix_layout, @Cast("char") byte trans, int n,
                           int kl, int ku, int nrhs,
                           @Const FloatPointer ab, int ldab,
                           @Const IntPointer ipiv, FloatPointer b, int ldb );
public static native int LAPACKE_sgbtrs( int matrix_layout, @Cast("char") byte trans, int n,
                           int kl, int ku, int nrhs,
                           @Const FloatBuffer ab, int ldab,
                           @Const IntBuffer ipiv, FloatBuffer b, int ldb );
public static native int LAPACKE_sgbtrs( int matrix_layout, @Cast("char") byte trans, int n,
                           int kl, int ku, int nrhs,
                           @Const float[] ab, int ldab,
                           @Const int[] ipiv, float[] b, int ldb );
public static native int LAPACKE_dgbtrs( int matrix_layout, @Cast("char") byte trans, int n,
                           int kl, int ku, int nrhs,
                           @Const DoublePointer ab, int ldab,
                           @Const IntPointer ipiv, DoublePointer b, int ldb );
public static native int LAPACKE_dgbtrs( int matrix_layout, @Cast("char") byte trans, int n,
                           int kl, int ku, int nrhs,
                           @Const DoubleBuffer ab, int ldab,
                           @Const IntBuffer ipiv, DoubleBuffer b, int ldb );
public static native int LAPACKE_dgbtrs( int matrix_layout, @Cast("char") byte trans, int n,
                           int kl, int ku, int nrhs,
                           @Const double[] ab, int ldab,
                           @Const int[] ipiv, double[] b, int ldb );
public static native int LAPACKE_cgbtrs( int matrix_layout, @Cast("char") byte trans, int n,
                           int kl, int ku, int nrhs,
                           @Cast("const lapack_complex_float*") FloatPointer ab, int ldab,
                           @Const IntPointer ipiv, @Cast("lapack_complex_float*") FloatPointer b,
                           int ldb );
public static native int LAPACKE_cgbtrs( int matrix_layout, @Cast("char") byte trans, int n,
                           int kl, int ku, int nrhs,
                           @Cast("const lapack_complex_float*") FloatBuffer ab, int ldab,
                           @Const IntBuffer ipiv, @Cast("lapack_complex_float*") FloatBuffer b,
                           int ldb );
public static native int LAPACKE_cgbtrs( int matrix_layout, @Cast("char") byte trans, int n,
                           int kl, int ku, int nrhs,
                           @Cast("const lapack_complex_float*") float[] ab, int ldab,
                           @Const int[] ipiv, @Cast("lapack_complex_float*") float[] b,
                           int ldb );
public static native int LAPACKE_zgbtrs( int matrix_layout, @Cast("char") byte trans, int n,
                           int kl, int ku, int nrhs,
                           @Cast("const lapack_complex_double*") DoublePointer ab, int ldab,
                           @Const IntPointer ipiv, @Cast("lapack_complex_double*") DoublePointer b,
                           int ldb );
public static native int LAPACKE_zgbtrs( int matrix_layout, @Cast("char") byte trans, int n,
                           int kl, int ku, int nrhs,
                           @Cast("const lapack_complex_double*") DoubleBuffer ab, int ldab,
                           @Const IntBuffer ipiv, @Cast("lapack_complex_double*") DoubleBuffer b,
                           int ldb );
public static native int LAPACKE_zgbtrs( int matrix_layout, @Cast("char") byte trans, int n,
                           int kl, int ku, int nrhs,
                           @Cast("const lapack_complex_double*") double[] ab, int ldab,
                           @Const int[] ipiv, @Cast("lapack_complex_double*") double[] b,
                           int ldb );

public static native int LAPACKE_sgebak( int matrix_layout, @Cast("char") byte job, @Cast("char") byte side, int n,
                           int ilo, int ihi, @Const FloatPointer scale,
                           int m, FloatPointer v, int ldv );
public static native int LAPACKE_sgebak( int matrix_layout, @Cast("char") byte job, @Cast("char") byte side, int n,
                           int ilo, int ihi, @Const FloatBuffer scale,
                           int m, FloatBuffer v, int ldv );
public static native int LAPACKE_sgebak( int matrix_layout, @Cast("char") byte job, @Cast("char") byte side, int n,
                           int ilo, int ihi, @Const float[] scale,
                           int m, float[] v, int ldv );
public static native int LAPACKE_dgebak( int matrix_layout, @Cast("char") byte job, @Cast("char") byte side, int n,
                           int ilo, int ihi, @Const DoublePointer scale,
                           int m, DoublePointer v, int ldv );
public static native int LAPACKE_dgebak( int matrix_layout, @Cast("char") byte job, @Cast("char") byte side, int n,
                           int ilo, int ihi, @Const DoubleBuffer scale,
                           int m, DoubleBuffer v, int ldv );
public static native int LAPACKE_dgebak( int matrix_layout, @Cast("char") byte job, @Cast("char") byte side, int n,
                           int ilo, int ihi, @Const double[] scale,
                           int m, double[] v, int ldv );
public static native int LAPACKE_cgebak( int matrix_layout, @Cast("char") byte job, @Cast("char") byte side, int n,
                           int ilo, int ihi, @Const FloatPointer scale,
                           int m, @Cast("lapack_complex_float*") FloatPointer v,
                           int ldv );
public static native int LAPACKE_cgebak( int matrix_layout, @Cast("char") byte job, @Cast("char") byte side, int n,
                           int ilo, int ihi, @Const FloatBuffer scale,
                           int m, @Cast("lapack_complex_float*") FloatBuffer v,
                           int ldv );
public static native int LAPACKE_cgebak( int matrix_layout, @Cast("char") byte job, @Cast("char") byte side, int n,
                           int ilo, int ihi, @Const float[] scale,
                           int m, @Cast("lapack_complex_float*") float[] v,
                           int ldv );
public static native int LAPACKE_zgebak( int matrix_layout, @Cast("char") byte job, @Cast("char") byte side, int n,
                           int ilo, int ihi, @Const DoublePointer scale,
                           int m, @Cast("lapack_complex_double*") DoublePointer v,
                           int ldv );
public static native int LAPACKE_zgebak( int matrix_layout, @Cast("char") byte job, @Cast("char") byte side, int n,
                           int ilo, int ihi, @Const DoubleBuffer scale,
                           int m, @Cast("lapack_complex_double*") DoubleBuffer v,
                           int ldv );
public static native int LAPACKE_zgebak( int matrix_layout, @Cast("char") byte job, @Cast("char") byte side, int n,
                           int ilo, int ihi, @Const double[] scale,
                           int m, @Cast("lapack_complex_double*") double[] v,
                           int ldv );

public static native int LAPACKE_sgebal( int matrix_layout, @Cast("char") byte job, int n, FloatPointer a,
                           int lda, IntPointer ilo, IntPointer ihi,
                           FloatPointer scale );
public static native int LAPACKE_sgebal( int matrix_layout, @Cast("char") byte job, int n, FloatBuffer a,
                           int lda, IntBuffer ilo, IntBuffer ihi,
                           FloatBuffer scale );
public static native int LAPACKE_sgebal( int matrix_layout, @Cast("char") byte job, int n, float[] a,
                           int lda, int[] ilo, int[] ihi,
                           float[] scale );
public static native int LAPACKE_dgebal( int matrix_layout, @Cast("char") byte job, int n, DoublePointer a,
                           int lda, IntPointer ilo, IntPointer ihi,
                           DoublePointer scale );
public static native int LAPACKE_dgebal( int matrix_layout, @Cast("char") byte job, int n, DoubleBuffer a,
                           int lda, IntBuffer ilo, IntBuffer ihi,
                           DoubleBuffer scale );
public static native int LAPACKE_dgebal( int matrix_layout, @Cast("char") byte job, int n, double[] a,
                           int lda, int[] ilo, int[] ihi,
                           double[] scale );
public static native int LAPACKE_cgebal( int matrix_layout, @Cast("char") byte job, int n,
                           @Cast("lapack_complex_float*") FloatPointer a, int lda,
                           IntPointer ilo, IntPointer ihi, FloatPointer scale );
public static native int LAPACKE_cgebal( int matrix_layout, @Cast("char") byte job, int n,
                           @Cast("lapack_complex_float*") FloatBuffer a, int lda,
                           IntBuffer ilo, IntBuffer ihi, FloatBuffer scale );
public static native int LAPACKE_cgebal( int matrix_layout, @Cast("char") byte job, int n,
                           @Cast("lapack_complex_float*") float[] a, int lda,
                           int[] ilo, int[] ihi, float[] scale );
public static native int LAPACKE_zgebal( int matrix_layout, @Cast("char") byte job, int n,
                           @Cast("lapack_complex_double*") DoublePointer a, int lda,
                           IntPointer ilo, IntPointer ihi, DoublePointer scale );
public static native int LAPACKE_zgebal( int matrix_layout, @Cast("char") byte job, int n,
                           @Cast("lapack_complex_double*") DoubleBuffer a, int lda,
                           IntBuffer ilo, IntBuffer ihi, DoubleBuffer scale );
public static native int LAPACKE_zgebal( int matrix_layout, @Cast("char") byte job, int n,
                           @Cast("lapack_complex_double*") double[] a, int lda,
                           int[] ilo, int[] ihi, double[] scale );

public static native int LAPACKE_sgebrd( int matrix_layout, int m, int n,
                           FloatPointer a, int lda, FloatPointer d, FloatPointer e,
                           FloatPointer tauq, FloatPointer taup );
public static native int LAPACKE_sgebrd( int matrix_layout, int m, int n,
                           FloatBuffer a, int lda, FloatBuffer d, FloatBuffer e,
                           FloatBuffer tauq, FloatBuffer taup );
public static native int LAPACKE_sgebrd( int matrix_layout, int m, int n,
                           float[] a, int lda, float[] d, float[] e,
                           float[] tauq, float[] taup );
public static native int LAPACKE_dgebrd( int matrix_layout, int m, int n,
                           DoublePointer a, int lda, DoublePointer d, DoublePointer e,
                           DoublePointer tauq, DoublePointer taup );
public static native int LAPACKE_dgebrd( int matrix_layout, int m, int n,
                           DoubleBuffer a, int lda, DoubleBuffer d, DoubleBuffer e,
                           DoubleBuffer tauq, DoubleBuffer taup );
public static native int LAPACKE_dgebrd( int matrix_layout, int m, int n,
                           double[] a, int lda, double[] d, double[] e,
                           double[] tauq, double[] taup );
public static native int LAPACKE_cgebrd( int matrix_layout, int m, int n,
                           @Cast("lapack_complex_float*") FloatPointer a, int lda, FloatPointer d,
                           FloatPointer e, @Cast("lapack_complex_float*") FloatPointer tauq,
                           @Cast("lapack_complex_float*") FloatPointer taup );
public static native int LAPACKE_cgebrd( int matrix_layout, int m, int n,
                           @Cast("lapack_complex_float*") FloatBuffer a, int lda, FloatBuffer d,
                           FloatBuffer e, @Cast("lapack_complex_float*") FloatBuffer tauq,
                           @Cast("lapack_complex_float*") FloatBuffer taup );
public static native int LAPACKE_cgebrd( int matrix_layout, int m, int n,
                           @Cast("lapack_complex_float*") float[] a, int lda, float[] d,
                           float[] e, @Cast("lapack_complex_float*") float[] tauq,
                           @Cast("lapack_complex_float*") float[] taup );
public static native int LAPACKE_zgebrd( int matrix_layout, int m, int n,
                           @Cast("lapack_complex_double*") DoublePointer a, int lda, DoublePointer d,
                           DoublePointer e, @Cast("lapack_complex_double*") DoublePointer tauq,
                           @Cast("lapack_complex_double*") DoublePointer taup );
public static native int LAPACKE_zgebrd( int matrix_layout, int m, int n,
                           @Cast("lapack_complex_double*") DoubleBuffer a, int lda, DoubleBuffer d,
                           DoubleBuffer e, @Cast("lapack_complex_double*") DoubleBuffer tauq,
                           @Cast("lapack_complex_double*") DoubleBuffer taup );
public static native int LAPACKE_zgebrd( int matrix_layout, int m, int n,
                           @Cast("lapack_complex_double*") double[] a, int lda, double[] d,
                           double[] e, @Cast("lapack_complex_double*") double[] tauq,
                           @Cast("lapack_complex_double*") double[] taup );

public static native int LAPACKE_sgecon( int matrix_layout, @Cast("char") byte norm, int n,
                           @Const FloatPointer a, int lda, float anorm,
                           FloatPointer rcond );
public static native int LAPACKE_sgecon( int matrix_layout, @Cast("char") byte norm, int n,
                           @Const FloatBuffer a, int lda, float anorm,
                           FloatBuffer rcond );
public static native int LAPACKE_sgecon( int matrix_layout, @Cast("char") byte norm, int n,
                           @Const float[] a, int lda, float anorm,
                           float[] rcond );
public static native int LAPACKE_dgecon( int matrix_layout, @Cast("char") byte norm, int n,
                           @Const DoublePointer a, int lda, double anorm,
                           DoublePointer rcond );
public static native int LAPACKE_dgecon( int matrix_layout, @Cast("char") byte norm, int n,
                           @Const DoubleBuffer a, int lda, double anorm,
                           DoubleBuffer rcond );
public static native int LAPACKE_dgecon( int matrix_layout, @Cast("char") byte norm, int n,
                           @Const double[] a, int lda, double anorm,
                           double[] rcond );
public static native int LAPACKE_cgecon( int matrix_layout, @Cast("char") byte norm, int n,
                           @Cast("const lapack_complex_float*") FloatPointer a, int lda,
                           float anorm, FloatPointer rcond );
public static native int LAPACKE_cgecon( int matrix_layout, @Cast("char") byte norm, int n,
                           @Cast("const lapack_complex_float*") FloatBuffer a, int lda,
                           float anorm, FloatBuffer rcond );
public static native int LAPACKE_cgecon( int matrix_layout, @Cast("char") byte norm, int n,
                           @Cast("const lapack_complex_float*") float[] a, int lda,
                           float anorm, float[] rcond );
public static native int LAPACKE_zgecon( int matrix_layout, @Cast("char") byte norm, int n,
                           @Cast("const lapack_complex_double*") DoublePointer a, int lda,
                           double anorm, DoublePointer rcond );
public static native int LAPACKE_zgecon( int matrix_layout, @Cast("char") byte norm, int n,
                           @Cast("const lapack_complex_double*") DoubleBuffer a, int lda,
                           double anorm, DoubleBuffer rcond );
public static native int LAPACKE_zgecon( int matrix_layout, @Cast("char") byte norm, int n,
                           @Cast("const lapack_complex_double*") double[] a, int lda,
                           double anorm, double[] rcond );

public static native int LAPACKE_sgeequ( int matrix_layout, int m, int n,
                           @Const FloatPointer a, int lda, FloatPointer r, FloatPointer c,
                           FloatPointer rowcnd, FloatPointer colcnd, FloatPointer amax );
public static native int LAPACKE_sgeequ( int matrix_layout, int m, int n,
                           @Const FloatBuffer a, int lda, FloatBuffer r, FloatBuffer c,
                           FloatBuffer rowcnd, FloatBuffer colcnd, FloatBuffer amax );
public static native int LAPACKE_sgeequ( int matrix_layout, int m, int n,
                           @Const float[] a, int lda, float[] r, float[] c,
                           float[] rowcnd, float[] colcnd, float[] amax );
public static native int LAPACKE_dgeequ( int matrix_layout, int m, int n,
                           @Const DoublePointer a, int lda, DoublePointer r,
                           DoublePointer c, DoublePointer rowcnd, DoublePointer colcnd,
                           DoublePointer amax );
public static native int LAPACKE_dgeequ( int matrix_layout, int m, int n,
                           @Const DoubleBuffer a, int lda, DoubleBuffer r,
                           DoubleBuffer c, DoubleBuffer rowcnd, DoubleBuffer colcnd,
                           DoubleBuffer amax );
public static native int LAPACKE_dgeequ( int matrix_layout, int m, int n,
                           @Const double[] a, int lda, double[] r,
                           double[] c, double[] rowcnd, double[] colcnd,
                           double[] amax );
public static native int LAPACKE_cgeequ( int matrix_layout, int m, int n,
                           @Cast("const lapack_complex_float*") FloatPointer a, int lda,
                           FloatPointer r, FloatPointer c, FloatPointer rowcnd, FloatPointer colcnd,
                           FloatPointer amax );
public static native int LAPACKE_cgeequ( int matrix_layout, int m, int n,
                           @Cast("const lapack_complex_float*") FloatBuffer a, int lda,
                           FloatBuffer r, FloatBuffer c, FloatBuffer rowcnd, FloatBuffer colcnd,
                           FloatBuffer amax );
public static native int LAPACKE_cgeequ( int matrix_layout, int m, int n,
                           @Cast("const lapack_complex_float*") float[] a, int lda,
                           float[] r, float[] c, float[] rowcnd, float[] colcnd,
                           float[] amax );
public static native int LAPACKE_zgeequ( int matrix_layout, int m, int n,
                           @Cast("const lapack_complex_double*") DoublePointer a, int lda,
                           DoublePointer r, DoublePointer c, DoublePointer rowcnd, DoublePointer colcnd,
                           DoublePointer amax );
public static native int LAPACKE_zgeequ( int matrix_layout, int m, int n,
                           @Cast("const lapack_complex_double*") DoubleBuffer a, int lda,
                           DoubleBuffer r, DoubleBuffer c, DoubleBuffer rowcnd, DoubleBuffer colcnd,
                           DoubleBuffer amax );
public static native int LAPACKE_zgeequ( int matrix_layout, int m, int n,
                           @Cast("const lapack_complex_double*") double[] a, int lda,
                           double[] r, double[] c, double[] rowcnd, double[] colcnd,
                           double[] amax );

public static native int LAPACKE_sgeequb( int matrix_layout, int m, int n,
                            @Const FloatPointer a, int lda, FloatPointer r, FloatPointer c,
                            FloatPointer rowcnd, FloatPointer colcnd, FloatPointer amax );
public static native int LAPACKE_sgeequb( int matrix_layout, int m, int n,
                            @Const FloatBuffer a, int lda, FloatBuffer r, FloatBuffer c,
                            FloatBuffer rowcnd, FloatBuffer colcnd, FloatBuffer amax );
public static native int LAPACKE_sgeequb( int matrix_layout, int m, int n,
                            @Const float[] a, int lda, float[] r, float[] c,
                            float[] rowcnd, float[] colcnd, float[] amax );
public static native int LAPACKE_dgeequb( int matrix_layout, int m, int n,
                            @Const DoublePointer a, int lda, DoublePointer r,
                            DoublePointer c, DoublePointer rowcnd, DoublePointer colcnd,
                            DoublePointer amax );
public static native int LAPACKE_dgeequb( int matrix_layout, int m, int n,
                            @Const DoubleBuffer a, int lda, DoubleBuffer r,
                            DoubleBuffer c, DoubleBuffer rowcnd, DoubleBuffer colcnd,
                            DoubleBuffer amax );
public static native int LAPACKE_dgeequb( int matrix_layout, int m, int n,
                            @Const double[] a, int lda, double[] r,
                            double[] c, double[] rowcnd, double[] colcnd,
                            double[] amax );
public static native int LAPACKE_cgeequb( int matrix_layout, int m, int n,
                            @Cast("const lapack_complex_float*") FloatPointer a, int lda,
                            FloatPointer r, FloatPointer c, FloatPointer rowcnd, FloatPointer colcnd,
                            FloatPointer amax );
public static native int LAPACKE_cgeequb( int matrix_layout, int m, int n,
                            @Cast("const lapack_complex_float*") FloatBuffer a, int lda,
                            FloatBuffer r, FloatBuffer c, FloatBuffer rowcnd, FloatBuffer colcnd,
                            FloatBuffer amax );
public static native int LAPACKE_cgeequb( int matrix_layout, int m, int n,
                            @Cast("const lapack_complex_float*") float[] a, int lda,
                            float[] r, float[] c, float[] rowcnd, float[] colcnd,
                            float[] amax );
public static native int LAPACKE_zgeequb( int matrix_layout, int m, int n,
                            @Cast("const lapack_complex_double*") DoublePointer a, int lda,
                            DoublePointer r, DoublePointer c, DoublePointer rowcnd,
                            DoublePointer colcnd, DoublePointer amax );
public static native int LAPACKE_zgeequb( int matrix_layout, int m, int n,
                            @Cast("const lapack_complex_double*") DoubleBuffer a, int lda,
                            DoubleBuffer r, DoubleBuffer c, DoubleBuffer rowcnd,
                            DoubleBuffer colcnd, DoubleBuffer amax );
public static native int LAPACKE_zgeequb( int matrix_layout, int m, int n,
                            @Cast("const lapack_complex_double*") double[] a, int lda,
                            double[] r, double[] c, double[] rowcnd,
                            double[] colcnd, double[] amax );

public static native int LAPACKE_sgees( int matrix_layout, @Cast("char") byte jobvs, @Cast("char") byte sort,
                          LAPACK_S_SELECT2 select, int n, FloatPointer a,
                          int lda, IntPointer sdim, FloatPointer wr,
                          FloatPointer wi, FloatPointer vs, int ldvs );
public static native int LAPACKE_sgees( int matrix_layout, @Cast("char") byte jobvs, @Cast("char") byte sort,
                          LAPACK_S_SELECT2 select, int n, FloatBuffer a,
                          int lda, IntBuffer sdim, FloatBuffer wr,
                          FloatBuffer wi, FloatBuffer vs, int ldvs );
public static native int LAPACKE_sgees( int matrix_layout, @Cast("char") byte jobvs, @Cast("char") byte sort,
                          LAPACK_S_SELECT2 select, int n, float[] a,
                          int lda, int[] sdim, float[] wr,
                          float[] wi, float[] vs, int ldvs );
public static native int LAPACKE_dgees( int matrix_layout, @Cast("char") byte jobvs, @Cast("char") byte sort,
                          LAPACK_D_SELECT2 select, int n, DoublePointer a,
                          int lda, IntPointer sdim, DoublePointer wr,
                          DoublePointer wi, DoublePointer vs, int ldvs );
public static native int LAPACKE_dgees( int matrix_layout, @Cast("char") byte jobvs, @Cast("char") byte sort,
                          LAPACK_D_SELECT2 select, int n, DoubleBuffer a,
                          int lda, IntBuffer sdim, DoubleBuffer wr,
                          DoubleBuffer wi, DoubleBuffer vs, int ldvs );
public static native int LAPACKE_dgees( int matrix_layout, @Cast("char") byte jobvs, @Cast("char") byte sort,
                          LAPACK_D_SELECT2 select, int n, double[] a,
                          int lda, int[] sdim, double[] wr,
                          double[] wi, double[] vs, int ldvs );
public static native int LAPACKE_cgees( int matrix_layout, @Cast("char") byte jobvs, @Cast("char") byte sort,
                          LAPACK_C_SELECT1 select, int n,
                          @Cast("lapack_complex_float*") FloatPointer a, int lda,
                          IntPointer sdim, @Cast("lapack_complex_float*") FloatPointer w,
                          @Cast("lapack_complex_float*") FloatPointer vs, int ldvs );
public static native int LAPACKE_cgees( int matrix_layout, @Cast("char") byte jobvs, @Cast("char") byte sort,
                          LAPACK_C_SELECT1 select, int n,
                          @Cast("lapack_complex_float*") FloatBuffer a, int lda,
                          IntBuffer sdim, @Cast("lapack_complex_float*") FloatBuffer w,
                          @Cast("lapack_complex_float*") FloatBuffer vs, int ldvs );
public static native int LAPACKE_cgees( int matrix_layout, @Cast("char") byte jobvs, @Cast("char") byte sort,
                          LAPACK_C_SELECT1 select, int n,
                          @Cast("lapack_complex_float*") float[] a, int lda,
                          int[] sdim, @Cast("lapack_complex_float*") float[] w,
                          @Cast("lapack_complex_float*") float[] vs, int ldvs );
public static native int LAPACKE_zgees( int matrix_layout, @Cast("char") byte jobvs, @Cast("char") byte sort,
                          LAPACK_Z_SELECT1 select, int n,
                          @Cast("lapack_complex_double*") DoublePointer a, int lda,
                          IntPointer sdim, @Cast("lapack_complex_double*") DoublePointer w,
                          @Cast("lapack_complex_double*") DoublePointer vs, int ldvs );
public static native int LAPACKE_zgees( int matrix_layout, @Cast("char") byte jobvs, @Cast("char") byte sort,
                          LAPACK_Z_SELECT1 select, int n,
                          @Cast("lapack_complex_double*") DoubleBuffer a, int lda,
                          IntBuffer sdim, @Cast("lapack_complex_double*") DoubleBuffer w,
                          @Cast("lapack_complex_double*") DoubleBuffer vs, int ldvs );
public static native int LAPACKE_zgees( int matrix_layout, @Cast("char") byte jobvs, @Cast("char") byte sort,
                          LAPACK_Z_SELECT1 select, int n,
                          @Cast("lapack_complex_double*") double[] a, int lda,
                          int[] sdim, @Cast("lapack_complex_double*") double[] w,
                          @Cast("lapack_complex_double*") double[] vs, int ldvs );

public static native int LAPACKE_sgeesx( int matrix_layout, @Cast("char") byte jobvs, @Cast("char") byte sort,
                           LAPACK_S_SELECT2 select, @Cast("char") byte sense, int n,
                           FloatPointer a, int lda, IntPointer sdim,
                           FloatPointer wr, FloatPointer wi, FloatPointer vs, int ldvs,
                           FloatPointer rconde, FloatPointer rcondv );
public static native int LAPACKE_sgeesx( int matrix_layout, @Cast("char") byte jobvs, @Cast("char") byte sort,
                           LAPACK_S_SELECT2 select, @Cast("char") byte sense, int n,
                           FloatBuffer a, int lda, IntBuffer sdim,
                           FloatBuffer wr, FloatBuffer wi, FloatBuffer vs, int ldvs,
                           FloatBuffer rconde, FloatBuffer rcondv );
public static native int LAPACKE_sgeesx( int matrix_layout, @Cast("char") byte jobvs, @Cast("char") byte sort,
                           LAPACK_S_SELECT2 select, @Cast("char") byte sense, int n,
                           float[] a, int lda, int[] sdim,
                           float[] wr, float[] wi, float[] vs, int ldvs,
                           float[] rconde, float[] rcondv );
public static native int LAPACKE_dgeesx( int matrix_layout, @Cast("char") byte jobvs, @Cast("char") byte sort,
                           LAPACK_D_SELECT2 select, @Cast("char") byte sense, int n,
                           DoublePointer a, int lda, IntPointer sdim,
                           DoublePointer wr, DoublePointer wi, DoublePointer vs, int ldvs,
                           DoublePointer rconde, DoublePointer rcondv );
public static native int LAPACKE_dgeesx( int matrix_layout, @Cast("char") byte jobvs, @Cast("char") byte sort,
                           LAPACK_D_SELECT2 select, @Cast("char") byte sense, int n,
                           DoubleBuffer a, int lda, IntBuffer sdim,
                           DoubleBuffer wr, DoubleBuffer wi, DoubleBuffer vs, int ldvs,
                           DoubleBuffer rconde, DoubleBuffer rcondv );
public static native int LAPACKE_dgeesx( int matrix_layout, @Cast("char") byte jobvs, @Cast("char") byte sort,
                           LAPACK_D_SELECT2 select, @Cast("char") byte sense, int n,
                           double[] a, int lda, int[] sdim,
                           double[] wr, double[] wi, double[] vs, int ldvs,
                           double[] rconde, double[] rcondv );
public static native int LAPACKE_cgeesx( int matrix_layout, @Cast("char") byte jobvs, @Cast("char") byte sort,
                           LAPACK_C_SELECT1 select, @Cast("char") byte sense, int n,
                           @Cast("lapack_complex_float*") FloatPointer a, int lda,
                           IntPointer sdim, @Cast("lapack_complex_float*") FloatPointer w,
                           @Cast("lapack_complex_float*") FloatPointer vs, int ldvs,
                           FloatPointer rconde, FloatPointer rcondv );
public static native int LAPACKE_cgeesx( int matrix_layout, @Cast("char") byte jobvs, @Cast("char") byte sort,
                           LAPACK_C_SELECT1 select, @Cast("char") byte sense, int n,
                           @Cast("lapack_complex_float*") FloatBuffer a, int lda,
                           IntBuffer sdim, @Cast("lapack_complex_float*") FloatBuffer w,
                           @Cast("lapack_complex_float*") FloatBuffer vs, int ldvs,
                           FloatBuffer rconde, FloatBuffer rcondv );
public static native int LAPACKE_cgeesx( int matrix_layout, @Cast("char") byte jobvs, @Cast("char") byte sort,
                           LAPACK_C_SELECT1 select, @Cast("char") byte sense, int n,
                           @Cast("lapack_complex_float*") float[] a, int lda,
                           int[] sdim, @Cast("lapack_complex_float*") float[] w,
                           @Cast("lapack_complex_float*") float[] vs, int ldvs,
                           float[] rconde, float[] rcondv );
public static native int LAPACKE_zgeesx( int matrix_layout, @Cast("char") byte jobvs, @Cast("char") byte sort,
                           LAPACK_Z_SELECT1 select, @Cast("char") byte sense, int n,
                           @Cast("lapack_complex_double*") DoublePointer a, int lda,
                           IntPointer sdim, @Cast("lapack_complex_double*") DoublePointer w,
                           @Cast("lapack_complex_double*") DoublePointer vs, int ldvs,
                           DoublePointer rconde, DoublePointer rcondv );
public static native int LAPACKE_zgeesx( int matrix_layout, @Cast("char") byte jobvs, @Cast("char") byte sort,
                           LAPACK_Z_SELECT1 select, @Cast("char") byte sense, int n,
                           @Cast("lapack_complex_double*") DoubleBuffer a, int lda,
                           IntBuffer sdim, @Cast("lapack_complex_double*") DoubleBuffer w,
                           @Cast("lapack_complex_double*") DoubleBuffer vs, int ldvs,
                           DoubleBuffer rconde, DoubleBuffer rcondv );
public static native int LAPACKE_zgeesx( int matrix_layout, @Cast("char") byte jobvs, @Cast("char") byte sort,
                           LAPACK_Z_SELECT1 select, @Cast("char") byte sense, int n,
                           @Cast("lapack_complex_double*") double[] a, int lda,
                           int[] sdim, @Cast("lapack_complex_double*") double[] w,
                           @Cast("lapack_complex_double*") double[] vs, int ldvs,
                           double[] rconde, double[] rcondv );

public static native int LAPACKE_sgeev( int matrix_layout, @Cast("char") byte jobvl, @Cast("char") byte jobvr,
                          int n, FloatPointer a, int lda, FloatPointer wr,
                          FloatPointer wi, FloatPointer vl, int ldvl, FloatPointer vr,
                          int ldvr );
public static native int LAPACKE_sgeev( int matrix_layout, @Cast("char") byte jobvl, @Cast("char") byte jobvr,
                          int n, FloatBuffer a, int lda, FloatBuffer wr,
                          FloatBuffer wi, FloatBuffer vl, int ldvl, FloatBuffer vr,
                          int ldvr );
public static native int LAPACKE_sgeev( int matrix_layout, @Cast("char") byte jobvl, @Cast("char") byte jobvr,
                          int n, float[] a, int lda, float[] wr,
                          float[] wi, float[] vl, int ldvl, float[] vr,
                          int ldvr );
public static native int LAPACKE_dgeev( int matrix_layout, @Cast("char") byte jobvl, @Cast("char") byte jobvr,
                          int n, DoublePointer a, int lda, DoublePointer wr,
                          DoublePointer wi, DoublePointer vl, int ldvl, DoublePointer vr,
                          int ldvr );
public static native int LAPACKE_dgeev( int matrix_layout, @Cast("char") byte jobvl, @Cast("char") byte jobvr,
                          int n, DoubleBuffer a, int lda, DoubleBuffer wr,
                          DoubleBuffer wi, DoubleBuffer vl, int ldvl, DoubleBuffer vr,
                          int ldvr );
public static native int LAPACKE_dgeev( int matrix_layout, @Cast("char") byte jobvl, @Cast("char") byte jobvr,
                          int n, double[] a, int lda, double[] wr,
                          double[] wi, double[] vl, int ldvl, double[] vr,
                          int ldvr );
public static native int LAPACKE_cgeev( int matrix_layout, @Cast("char") byte jobvl, @Cast("char") byte jobvr,
                          int n, @Cast("lapack_complex_float*") FloatPointer a, int lda,
                          @Cast("lapack_complex_float*") FloatPointer w, @Cast("lapack_complex_float*") FloatPointer vl,
                          int ldvl, @Cast("lapack_complex_float*") FloatPointer vr,
                          int ldvr );
public static native int LAPACKE_cgeev( int matrix_layout, @Cast("char") byte jobvl, @Cast("char") byte jobvr,
                          int n, @Cast("lapack_complex_float*") FloatBuffer a, int lda,
                          @Cast("lapack_complex_float*") FloatBuffer w, @Cast("lapack_complex_float*") FloatBuffer vl,
                          int ldvl, @Cast("lapack_complex_float*") FloatBuffer vr,
                          int ldvr );
public static native int LAPACKE_cgeev( int matrix_layout, @Cast("char") byte jobvl, @Cast("char") byte jobvr,
                          int n, @Cast("lapack_complex_float*") float[] a, int lda,
                          @Cast("lapack_complex_float*") float[] w, @Cast("lapack_complex_float*") float[] vl,
                          int ldvl, @Cast("lapack_complex_float*") float[] vr,
                          int ldvr );
public static native int LAPACKE_zgeev( int matrix_layout, @Cast("char") byte jobvl, @Cast("char") byte jobvr,
                          int n, @Cast("lapack_complex_double*") DoublePointer a,
                          int lda, @Cast("lapack_complex_double*") DoublePointer w,
                          @Cast("lapack_complex_double*") DoublePointer vl, int ldvl,
                          @Cast("lapack_complex_double*") DoublePointer vr, int ldvr );
public static native int LAPACKE_zgeev( int matrix_layout, @Cast("char") byte jobvl, @Cast("char") byte jobvr,
                          int n, @Cast("lapack_complex_double*") DoubleBuffer a,
                          int lda, @Cast("lapack_complex_double*") DoubleBuffer w,
                          @Cast("lapack_complex_double*") DoubleBuffer vl, int ldvl,
                          @Cast("lapack_complex_double*") DoubleBuffer vr, int ldvr );
public static native int LAPACKE_zgeev( int matrix_layout, @Cast("char") byte jobvl, @Cast("char") byte jobvr,
                          int n, @Cast("lapack_complex_double*") double[] a,
                          int lda, @Cast("lapack_complex_double*") double[] w,
                          @Cast("lapack_complex_double*") double[] vl, int ldvl,
                          @Cast("lapack_complex_double*") double[] vr, int ldvr );

public static native int LAPACKE_sgeevx( int matrix_layout, @Cast("char") byte balanc, @Cast("char") byte jobvl,
                           @Cast("char") byte jobvr, @Cast("char") byte sense, int n, FloatPointer a,
                           int lda, FloatPointer wr, FloatPointer wi, FloatPointer vl,
                           int ldvl, FloatPointer vr, int ldvr,
                           IntPointer ilo, IntPointer ihi, FloatPointer scale,
                           FloatPointer abnrm, FloatPointer rconde, FloatPointer rcondv );
public static native int LAPACKE_sgeevx( int matrix_layout, @Cast("char") byte balanc, @Cast("char") byte jobvl,
                           @Cast("char") byte jobvr, @Cast("char") byte sense, int n, FloatBuffer a,
                           int lda, FloatBuffer wr, FloatBuffer wi, FloatBuffer vl,
                           int ldvl, FloatBuffer vr, int ldvr,
                           IntBuffer ilo, IntBuffer ihi, FloatBuffer scale,
                           FloatBuffer abnrm, FloatBuffer rconde, FloatBuffer rcondv );
public static native int LAPACKE_sgeevx( int matrix_layout, @Cast("char") byte balanc, @Cast("char") byte jobvl,
                           @Cast("char") byte jobvr, @Cast("char") byte sense, int n, float[] a,
                           int lda, float[] wr, float[] wi, float[] vl,
                           int ldvl, float[] vr, int ldvr,
                           int[] ilo, int[] ihi, float[] scale,
                           float[] abnrm, float[] rconde, float[] rcondv );
public static native int LAPACKE_dgeevx( int matrix_layout, @Cast("char") byte balanc, @Cast("char") byte jobvl,
                           @Cast("char") byte jobvr, @Cast("char") byte sense, int n, DoublePointer a,
                           int lda, DoublePointer wr, DoublePointer wi, DoublePointer vl,
                           int ldvl, DoublePointer vr, int ldvr,
                           IntPointer ilo, IntPointer ihi, DoublePointer scale,
                           DoublePointer abnrm, DoublePointer rconde, DoublePointer rcondv );
public static native int LAPACKE_dgeevx( int matrix_layout, @Cast("char") byte balanc, @Cast("char") byte jobvl,
                           @Cast("char") byte jobvr, @Cast("char") byte sense, int n, DoubleBuffer a,
                           int lda, DoubleBuffer wr, DoubleBuffer wi, DoubleBuffer vl,
                           int ldvl, DoubleBuffer vr, int ldvr,
                           IntBuffer ilo, IntBuffer ihi, DoubleBuffer scale,
                           DoubleBuffer abnrm, DoubleBuffer rconde, DoubleBuffer rcondv );
public static native int LAPACKE_dgeevx( int matrix_layout, @Cast("char") byte balanc, @Cast("char") byte jobvl,
                           @Cast("char") byte jobvr, @Cast("char") byte sense, int n, double[] a,
                           int lda, double[] wr, double[] wi, double[] vl,
                           int ldvl, double[] vr, int ldvr,
                           int[] ilo, int[] ihi, double[] scale,
                           double[] abnrm, double[] rconde, double[] rcondv );
public static native int LAPACKE_cgeevx( int matrix_layout, @Cast("char") byte balanc, @Cast("char") byte jobvl,
                           @Cast("char") byte jobvr, @Cast("char") byte sense, int n,
                           @Cast("lapack_complex_float*") FloatPointer a, int lda,
                           @Cast("lapack_complex_float*") FloatPointer w, @Cast("lapack_complex_float*") FloatPointer vl,
                           int ldvl, @Cast("lapack_complex_float*") FloatPointer vr,
                           int ldvr, IntPointer ilo, IntPointer ihi,
                           FloatPointer scale, FloatPointer abnrm, FloatPointer rconde,
                           FloatPointer rcondv );
public static native int LAPACKE_cgeevx( int matrix_layout, @Cast("char") byte balanc, @Cast("char") byte jobvl,
                           @Cast("char") byte jobvr, @Cast("char") byte sense, int n,
                           @Cast("lapack_complex_float*") FloatBuffer a, int lda,
                           @Cast("lapack_complex_float*") FloatBuffer w, @Cast("lapack_complex_float*") FloatBuffer vl,
                           int ldvl, @Cast("lapack_complex_float*") FloatBuffer vr,
                           int ldvr, IntBuffer ilo, IntBuffer ihi,
                           FloatBuffer scale, FloatBuffer abnrm, FloatBuffer rconde,
                           FloatBuffer rcondv );
public static native int LAPACKE_cgeevx( int matrix_layout, @Cast("char") byte balanc, @Cast("char") byte jobvl,
                           @Cast("char") byte jobvr, @Cast("char") byte sense, int n,
                           @Cast("lapack_complex_float*") float[] a, int lda,
                           @Cast("lapack_complex_float*") float[] w, @Cast("lapack_complex_float*") float[] vl,
                           int ldvl, @Cast("lapack_complex_float*") float[] vr,
                           int ldvr, int[] ilo, int[] ihi,
                           float[] scale, float[] abnrm, float[] rconde,
                           float[] rcondv );
public static native int LAPACKE_zgeevx( int matrix_layout, @Cast("char") byte balanc, @Cast("char") byte jobvl,
                           @Cast("char") byte jobvr, @Cast("char") byte sense, int n,
                           @Cast("lapack_complex_double*") DoublePointer a, int lda,
                           @Cast("lapack_complex_double*") DoublePointer w, @Cast("lapack_complex_double*") DoublePointer vl,
                           int ldvl, @Cast("lapack_complex_double*") DoublePointer vr,
                           int ldvr, IntPointer ilo, IntPointer ihi,
                           DoublePointer scale, DoublePointer abnrm, DoublePointer rconde,
                           DoublePointer rcondv );
public static native int LAPACKE_zgeevx( int matrix_layout, @Cast("char") byte balanc, @Cast("char") byte jobvl,
                           @Cast("char") byte jobvr, @Cast("char") byte sense, int n,
                           @Cast("lapack_complex_double*") DoubleBuffer a, int lda,
                           @Cast("lapack_complex_double*") DoubleBuffer w, @Cast("lapack_complex_double*") DoubleBuffer vl,
                           int ldvl, @Cast("lapack_complex_double*") DoubleBuffer vr,
                           int ldvr, IntBuffer ilo, IntBuffer ihi,
                           DoubleBuffer scale, DoubleBuffer abnrm, DoubleBuffer rconde,
                           DoubleBuffer rcondv );
public static native int LAPACKE_zgeevx( int matrix_layout, @Cast("char") byte balanc, @Cast("char") byte jobvl,
                           @Cast("char") byte jobvr, @Cast("char") byte sense, int n,
                           @Cast("lapack_complex_double*") double[] a, int lda,
                           @Cast("lapack_complex_double*") double[] w, @Cast("lapack_complex_double*") double[] vl,
                           int ldvl, @Cast("lapack_complex_double*") double[] vr,
                           int ldvr, int[] ilo, int[] ihi,
                           double[] scale, double[] abnrm, double[] rconde,
                           double[] rcondv );

public static native int LAPACKE_sgehrd( int matrix_layout, int n, int ilo,
                           int ihi, FloatPointer a, int lda,
                           FloatPointer tau );
public static native int LAPACKE_sgehrd( int matrix_layout, int n, int ilo,
                           int ihi, FloatBuffer a, int lda,
                           FloatBuffer tau );
public static native int LAPACKE_sgehrd( int matrix_layout, int n, int ilo,
                           int ihi, float[] a, int lda,
                           float[] tau );
public static native int LAPACKE_dgehrd( int matrix_layout, int n, int ilo,
                           int ihi, DoublePointer a, int lda,
                           DoublePointer tau );
public static native int LAPACKE_dgehrd( int matrix_layout, int n, int ilo,
                           int ihi, DoubleBuffer a, int lda,
                           DoubleBuffer tau );
public static native int LAPACKE_dgehrd( int matrix_layout, int n, int ilo,
                           int ihi, double[] a, int lda,
                           double[] tau );
public static native int LAPACKE_cgehrd( int matrix_layout, int n, int ilo,
                           int ihi, @Cast("lapack_complex_float*") FloatPointer a,
                           int lda, @Cast("lapack_complex_float*") FloatPointer tau );
public static native int LAPACKE_cgehrd( int matrix_layout, int n, int ilo,
                           int ihi, @Cast("lapack_complex_float*") FloatBuffer a,
                           int lda, @Cast("lapack_complex_float*") FloatBuffer tau );
public static native int LAPACKE_cgehrd( int matrix_layout, int n, int ilo,
                           int ihi, @Cast("lapack_complex_float*") float[] a,
                           int lda, @Cast("lapack_complex_float*") float[] tau );
public static native int LAPACKE_zgehrd( int matrix_layout, int n, int ilo,
                           int ihi, @Cast("lapack_complex_double*") DoublePointer a,
                           int lda, @Cast("lapack_complex_double*") DoublePointer tau );
public static native int LAPACKE_zgehrd( int matrix_layout, int n, int ilo,
                           int ihi, @Cast("lapack_complex_double*") DoubleBuffer a,
                           int lda, @Cast("lapack_complex_double*") DoubleBuffer tau );
public static native int LAPACKE_zgehrd( int matrix_layout, int n, int ilo,
                           int ihi, @Cast("lapack_complex_double*") double[] a,
                           int lda, @Cast("lapack_complex_double*") double[] tau );

public static native int LAPACKE_sgejsv( int matrix_layout, @Cast("char") byte joba, @Cast("char") byte jobu, @Cast("char") byte jobv,
                           @Cast("char") byte jobr, @Cast("char") byte jobt, @Cast("char") byte jobp, int m,
                           int n, FloatPointer a, int lda, FloatPointer sva,
                           FloatPointer u, int ldu, FloatPointer v, int ldv,
                           FloatPointer stat, IntPointer istat );
public static native int LAPACKE_sgejsv( int matrix_layout, @Cast("char") byte joba, @Cast("char") byte jobu, @Cast("char") byte jobv,
                           @Cast("char") byte jobr, @Cast("char") byte jobt, @Cast("char") byte jobp, int m,
                           int n, FloatBuffer a, int lda, FloatBuffer sva,
                           FloatBuffer u, int ldu, FloatBuffer v, int ldv,
                           FloatBuffer stat, IntBuffer istat );
public static native int LAPACKE_sgejsv( int matrix_layout, @Cast("char") byte joba, @Cast("char") byte jobu, @Cast("char") byte jobv,
                           @Cast("char") byte jobr, @Cast("char") byte jobt, @Cast("char") byte jobp, int m,
                           int n, float[] a, int lda, float[] sva,
                           float[] u, int ldu, float[] v, int ldv,
                           float[] stat, int[] istat );
public static native int LAPACKE_dgejsv( int matrix_layout, @Cast("char") byte joba, @Cast("char") byte jobu, @Cast("char") byte jobv,
                           @Cast("char") byte jobr, @Cast("char") byte jobt, @Cast("char") byte jobp, int m,
                           int n, DoublePointer a, int lda, DoublePointer sva,
                           DoublePointer u, int ldu, DoublePointer v, int ldv,
                           DoublePointer stat, IntPointer istat );
public static native int LAPACKE_dgejsv( int matrix_layout, @Cast("char") byte joba, @Cast("char") byte jobu, @Cast("char") byte jobv,
                           @Cast("char") byte jobr, @Cast("char") byte jobt, @Cast("char") byte jobp, int m,
                           int n, DoubleBuffer a, int lda, DoubleBuffer sva,
                           DoubleBuffer u, int ldu, DoubleBuffer v, int ldv,
                           DoubleBuffer stat, IntBuffer istat );
public static native int LAPACKE_dgejsv( int matrix_layout, @Cast("char") byte joba, @Cast("char") byte jobu, @Cast("char") byte jobv,
                           @Cast("char") byte jobr, @Cast("char") byte jobt, @Cast("char") byte jobp, int m,
                           int n, double[] a, int lda, double[] sva,
                           double[] u, int ldu, double[] v, int ldv,
                           double[] stat, int[] istat );
public static native int LAPACKE_cgejsv( int matrix_layout, @Cast("char") byte joba, @Cast("char") byte jobu, @Cast("char") byte jobv,
                           @Cast("char") byte jobr, @Cast("char") byte jobt, @Cast("char") byte jobp, int m,
                           int n, @Cast("lapack_complex_float*") FloatPointer a, int lda, FloatPointer sva,
                           @Cast("lapack_complex_float*") FloatPointer u, int ldu, @Cast("lapack_complex_float*") FloatPointer v, int ldv,
                           FloatPointer stat, IntPointer istat );
public static native int LAPACKE_cgejsv( int matrix_layout, @Cast("char") byte joba, @Cast("char") byte jobu, @Cast("char") byte jobv,
                           @Cast("char") byte jobr, @Cast("char") byte jobt, @Cast("char") byte jobp, int m,
                           int n, @Cast("lapack_complex_float*") FloatBuffer a, int lda, FloatBuffer sva,
                           @Cast("lapack_complex_float*") FloatBuffer u, int ldu, @Cast("lapack_complex_float*") FloatBuffer v, int ldv,
                           FloatBuffer stat, IntBuffer istat );
public static native int LAPACKE_cgejsv( int matrix_layout, @Cast("char") byte joba, @Cast("char") byte jobu, @Cast("char") byte jobv,
                           @Cast("char") byte jobr, @Cast("char") byte jobt, @Cast("char") byte jobp, int m,
                           int n, @Cast("lapack_complex_float*") float[] a, int lda, float[] sva,
                           @Cast("lapack_complex_float*") float[] u, int ldu, @Cast("lapack_complex_float*") float[] v, int ldv,
                           float[] stat, int[] istat );
public static native int LAPACKE_zgejsv( int matrix_layout, @Cast("char") byte joba, @Cast("char") byte jobu, @Cast("char") byte jobv,
                           @Cast("char") byte jobr, @Cast("char") byte jobt, @Cast("char") byte jobp, int m,
                           int n, @Cast("lapack_complex_double*") DoublePointer a, int lda, DoublePointer sva,
                           @Cast("lapack_complex_double*") DoublePointer u, int ldu, @Cast("lapack_complex_double*") DoublePointer v, int ldv,
                           DoublePointer stat, IntPointer istat );
public static native int LAPACKE_zgejsv( int matrix_layout, @Cast("char") byte joba, @Cast("char") byte jobu, @Cast("char") byte jobv,
                           @Cast("char") byte jobr, @Cast("char") byte jobt, @Cast("char") byte jobp, int m,
                           int n, @Cast("lapack_complex_double*") DoubleBuffer a, int lda, DoubleBuffer sva,
                           @Cast("lapack_complex_double*") DoubleBuffer u, int ldu, @Cast("lapack_complex_double*") DoubleBuffer v, int ldv,
                           DoubleBuffer stat, IntBuffer istat );
public static native int LAPACKE_zgejsv( int matrix_layout, @Cast("char") byte joba, @Cast("char") byte jobu, @Cast("char") byte jobv,
                           @Cast("char") byte jobr, @Cast("char") byte jobt, @Cast("char") byte jobp, int m,
                           int n, @Cast("lapack_complex_double*") double[] a, int lda, double[] sva,
                           @Cast("lapack_complex_double*") double[] u, int ldu, @Cast("lapack_complex_double*") double[] v, int ldv,
                           double[] stat, int[] istat );

public static native int LAPACKE_sgelq2( int matrix_layout, int m, int n,
                           FloatPointer a, int lda, FloatPointer tau );
public static native int LAPACKE_sgelq2( int matrix_layout, int m, int n,
                           FloatBuffer a, int lda, FloatBuffer tau );
public static native int LAPACKE_sgelq2( int matrix_layout, int m, int n,
                           float[] a, int lda, float[] tau );
public static native int LAPACKE_dgelq2( int matrix_layout, int m, int n,
                           DoublePointer a, int lda, DoublePointer tau );
public static native int LAPACKE_dgelq2( int matrix_layout, int m, int n,
                           DoubleBuffer a, int lda, DoubleBuffer tau );
public static native int LAPACKE_dgelq2( int matrix_layout, int m, int n,
                           double[] a, int lda, double[] tau );
public static native int LAPACKE_cgelq2( int matrix_layout, int m, int n,
                           @Cast("lapack_complex_float*") FloatPointer a, int lda,
                           @Cast("lapack_complex_float*") FloatPointer tau );
public static native int LAPACKE_cgelq2( int matrix_layout, int m, int n,
                           @Cast("lapack_complex_float*") FloatBuffer a, int lda,
                           @Cast("lapack_complex_float*") FloatBuffer tau );
public static native int LAPACKE_cgelq2( int matrix_layout, int m, int n,
                           @Cast("lapack_complex_float*") float[] a, int lda,
                           @Cast("lapack_complex_float*") float[] tau );
public static native int LAPACKE_zgelq2( int matrix_layout, int m, int n,
                           @Cast("lapack_complex_double*") DoublePointer a, int lda,
                           @Cast("lapack_complex_double*") DoublePointer tau );
public static native int LAPACKE_zgelq2( int matrix_layout, int m, int n,
                           @Cast("lapack_complex_double*") DoubleBuffer a, int lda,
                           @Cast("lapack_complex_double*") DoubleBuffer tau );
public static native int LAPACKE_zgelq2( int matrix_layout, int m, int n,
                           @Cast("lapack_complex_double*") double[] a, int lda,
                           @Cast("lapack_complex_double*") double[] tau );

public static native int LAPACKE_sgelqf( int matrix_layout, int m, int n,
                           FloatPointer a, int lda, FloatPointer tau );
public static native int LAPACKE_sgelqf( int matrix_layout, int m, int n,
                           FloatBuffer a, int lda, FloatBuffer tau );
public static native int LAPACKE_sgelqf( int matrix_layout, int m, int n,
                           float[] a, int lda, float[] tau );
public static native int LAPACKE_dgelqf( int matrix_layout, int m, int n,
                           DoublePointer a, int lda, DoublePointer tau );
public static native int LAPACKE_dgelqf( int matrix_layout, int m, int n,
                           DoubleBuffer a, int lda, DoubleBuffer tau );
public static native int LAPACKE_dgelqf( int matrix_layout, int m, int n,
                           double[] a, int lda, double[] tau );
public static native int LAPACKE_cgelqf( int matrix_layout, int m, int n,
                           @Cast("lapack_complex_float*") FloatPointer a, int lda,
                           @Cast("lapack_complex_float*") FloatPointer tau );
public static native int LAPACKE_cgelqf( int matrix_layout, int m, int n,
                           @Cast("lapack_complex_float*") FloatBuffer a, int lda,
                           @Cast("lapack_complex_float*") FloatBuffer tau );
public static native int LAPACKE_cgelqf( int matrix_layout, int m, int n,
                           @Cast("lapack_complex_float*") float[] a, int lda,
                           @Cast("lapack_complex_float*") float[] tau );
public static native int LAPACKE_zgelqf( int matrix_layout, int m, int n,
                           @Cast("lapack_complex_double*") DoublePointer a, int lda,
                           @Cast("lapack_complex_double*") DoublePointer tau );
public static native int LAPACKE_zgelqf( int matrix_layout, int m, int n,
                           @Cast("lapack_complex_double*") DoubleBuffer a, int lda,
                           @Cast("lapack_complex_double*") DoubleBuffer tau );
public static native int LAPACKE_zgelqf( int matrix_layout, int m, int n,
                           @Cast("lapack_complex_double*") double[] a, int lda,
                           @Cast("lapack_complex_double*") double[] tau );

public static native int LAPACKE_sgels( int matrix_layout, @Cast("char") byte trans, int m,
                          int n, int nrhs, FloatPointer a,
                          int lda, FloatPointer b, int ldb );
public static native int LAPACKE_sgels( int matrix_layout, @Cast("char") byte trans, int m,
                          int n, int nrhs, FloatBuffer a,
                          int lda, FloatBuffer b, int ldb );
public static native int LAPACKE_sgels( int matrix_layout, @Cast("char") byte trans, int m,
                          int n, int nrhs, float[] a,
                          int lda, float[] b, int ldb );
public static native int LAPACKE_dgels( int matrix_layout, @Cast("char") byte trans, int m,
                          int n, int nrhs, DoublePointer a,
                          int lda, DoublePointer b, int ldb );
public static native int LAPACKE_dgels( int matrix_layout, @Cast("char") byte trans, int m,
                          int n, int nrhs, DoubleBuffer a,
                          int lda, DoubleBuffer b, int ldb );
public static native int LAPACKE_dgels( int matrix_layout, @Cast("char") byte trans, int m,
                          int n, int nrhs, double[] a,
                          int lda, double[] b, int ldb );
public static native int LAPACKE_cgels( int matrix_layout, @Cast("char") byte trans, int m,
                          int n, int nrhs,
                          @Cast("lapack_complex_float*") FloatPointer a, int lda,
                          @Cast("lapack_complex_float*") FloatPointer b, int ldb );
public static native int LAPACKE_cgels( int matrix_layout, @Cast("char") byte trans, int m,
                          int n, int nrhs,
                          @Cast("lapack_complex_float*") FloatBuffer a, int lda,
                          @Cast("lapack_complex_float*") FloatBuffer b, int ldb );
public static native int LAPACKE_cgels( int matrix_layout, @Cast("char") byte trans, int m,
                          int n, int nrhs,
                          @Cast("lapack_complex_float*") float[] a, int lda,
                          @Cast("lapack_complex_float*") float[] b, int ldb );
public static native int LAPACKE_zgels( int matrix_layout, @Cast("char") byte trans, int m,
                          int n, int nrhs,
                          @Cast("lapack_complex_double*") DoublePointer a, int lda,
                          @Cast("lapack_complex_double*") DoublePointer b, int ldb );
public static native int LAPACKE_zgels( int matrix_layout, @Cast("char") byte trans, int m,
                          int n, int nrhs,
                          @Cast("lapack_complex_double*") DoubleBuffer a, int lda,
                          @Cast("lapack_complex_double*") DoubleBuffer b, int ldb );
public static native int LAPACKE_zgels( int matrix_layout, @Cast("char") byte trans, int m,
                          int n, int nrhs,
                          @Cast("lapack_complex_double*") double[] a, int lda,
                          @Cast("lapack_complex_double*") double[] b, int ldb );

public static native int LAPACKE_sgelsd( int matrix_layout, int m, int n,
                           int nrhs, FloatPointer a, int lda, FloatPointer b,
                           int ldb, FloatPointer s, float rcond,
                           IntPointer rank );
public static native int LAPACKE_sgelsd( int matrix_layout, int m, int n,
                           int nrhs, FloatBuffer a, int lda, FloatBuffer b,
                           int ldb, FloatBuffer s, float rcond,
                           IntBuffer rank );
public static native int LAPACKE_sgelsd( int matrix_layout, int m, int n,
                           int nrhs, float[] a, int lda, float[] b,
                           int ldb, float[] s, float rcond,
                           int[] rank );
public static native int LAPACKE_dgelsd( int matrix_layout, int m, int n,
                           int nrhs, DoublePointer a, int lda,
                           DoublePointer b, int ldb, DoublePointer s, double rcond,
                           IntPointer rank );
public static native int LAPACKE_dgelsd( int matrix_layout, int m, int n,
                           int nrhs, DoubleBuffer a, int lda,
                           DoubleBuffer b, int ldb, DoubleBuffer s, double rcond,
                           IntBuffer rank );
public static native int LAPACKE_dgelsd( int matrix_layout, int m, int n,
                           int nrhs, double[] a, int lda,
                           double[] b, int ldb, double[] s, double rcond,
                           int[] rank );
public static native int LAPACKE_cgelsd( int matrix_layout, int m, int n,
                           int nrhs, @Cast("lapack_complex_float*") FloatPointer a,
                           int lda, @Cast("lapack_complex_float*") FloatPointer b,
                           int ldb, FloatPointer s, float rcond,
                           IntPointer rank );
public static native int LAPACKE_cgelsd( int matrix_layout, int m, int n,
                           int nrhs, @Cast("lapack_complex_float*") FloatBuffer a,
                           int lda, @Cast("lapack_complex_float*") FloatBuffer b,
                           int ldb, FloatBuffer s, float rcond,
                           IntBuffer rank );
public static native int LAPACKE_cgelsd( int matrix_layout, int m, int n,
                           int nrhs, @Cast("lapack_complex_float*") float[] a,
                           int lda, @Cast("lapack_complex_float*") float[] b,
                           int ldb, float[] s, float rcond,
                           int[] rank );
public static native int LAPACKE_zgelsd( int matrix_layout, int m, int n,
                           int nrhs, @Cast("lapack_complex_double*") DoublePointer a,
                           int lda, @Cast("lapack_complex_double*") DoublePointer b,
                           int ldb, DoublePointer s, double rcond,
                           IntPointer rank );
public static native int LAPACKE_zgelsd( int matrix_layout, int m, int n,
                           int nrhs, @Cast("lapack_complex_double*") DoubleBuffer a,
                           int lda, @Cast("lapack_complex_double*") DoubleBuffer b,
                           int ldb, DoubleBuffer s, double rcond,
                           IntBuffer rank );
public static native int LAPACKE_zgelsd( int matrix_layout, int m, int n,
                           int nrhs, @Cast("lapack_complex_double*") double[] a,
                           int lda, @Cast("lapack_complex_double*") double[] b,
                           int ldb, double[] s, double rcond,
                           int[] rank );

public static native int LAPACKE_sgelss( int matrix_layout, int m, int n,
                           int nrhs, FloatPointer a, int lda, FloatPointer b,
                           int ldb, FloatPointer s, float rcond,
                           IntPointer rank );
public static native int LAPACKE_sgelss( int matrix_layout, int m, int n,
                           int nrhs, FloatBuffer a, int lda, FloatBuffer b,
                           int ldb, FloatBuffer s, float rcond,
                           IntBuffer rank );
public static native int LAPACKE_sgelss( int matrix_layout, int m, int n,
                           int nrhs, float[] a, int lda, float[] b,
                           int ldb, float[] s, float rcond,
                           int[] rank );
public static native int LAPACKE_dgelss( int matrix_layout, int m, int n,
                           int nrhs, DoublePointer a, int lda,
                           DoublePointer b, int ldb, DoublePointer s, double rcond,
                           IntPointer rank );
public static native int LAPACKE_dgelss( int matrix_layout, int m, int n,
                           int nrhs, DoubleBuffer a, int lda,
                           DoubleBuffer b, int ldb, DoubleBuffer s, double rcond,
                           IntBuffer rank );
public static native int LAPACKE_dgelss( int matrix_layout, int m, int n,
                           int nrhs, double[] a, int lda,
                           double[] b, int ldb, double[] s, double rcond,
                           int[] rank );
public static native int LAPACKE_cgelss( int matrix_layout, int m, int n,
                           int nrhs, @Cast("lapack_complex_float*") FloatPointer a,
                           int lda, @Cast("lapack_complex_float*") FloatPointer b,
                           int ldb, FloatPointer s, float rcond,
                           IntPointer rank );
public static native int LAPACKE_cgelss( int matrix_layout, int m, int n,
                           int nrhs, @Cast("lapack_complex_float*") FloatBuffer a,
                           int lda, @Cast("lapack_complex_float*") FloatBuffer b,
                           int ldb, FloatBuffer s, float rcond,
                           IntBuffer rank );
public static native int LAPACKE_cgelss( int matrix_layout, int m, int n,
                           int nrhs, @Cast("lapack_complex_float*") float[] a,
                           int lda, @Cast("lapack_complex_float*") float[] b,
                           int ldb, float[] s, float rcond,
                           int[] rank );
public static native int LAPACKE_zgelss( int matrix_layout, int m, int n,
                           int nrhs, @Cast("lapack_complex_double*") DoublePointer a,
                           int lda, @Cast("lapack_complex_double*") DoublePointer b,
                           int ldb, DoublePointer s, double rcond,
                           IntPointer rank );
public static native int LAPACKE_zgelss( int matrix_layout, int m, int n,
                           int nrhs, @Cast("lapack_complex_double*") DoubleBuffer a,
                           int lda, @Cast("lapack_complex_double*") DoubleBuffer b,
                           int ldb, DoubleBuffer s, double rcond,
                           IntBuffer rank );
public static native int LAPACKE_zgelss( int matrix_layout, int m, int n,
                           int nrhs, @Cast("lapack_complex_double*") double[] a,
                           int lda, @Cast("lapack_complex_double*") double[] b,
                           int ldb, double[] s, double rcond,
                           int[] rank );

public static native int LAPACKE_sgelsy( int matrix_layout, int m, int n,
                           int nrhs, FloatPointer a, int lda, FloatPointer b,
                           int ldb, IntPointer jpvt, float rcond,
                           IntPointer rank );
public static native int LAPACKE_sgelsy( int matrix_layout, int m, int n,
                           int nrhs, FloatBuffer a, int lda, FloatBuffer b,
                           int ldb, IntBuffer jpvt, float rcond,
                           IntBuffer rank );
public static native int LAPACKE_sgelsy( int matrix_layout, int m, int n,
                           int nrhs, float[] a, int lda, float[] b,
                           int ldb, int[] jpvt, float rcond,
                           int[] rank );
public static native int LAPACKE_dgelsy( int matrix_layout, int m, int n,
                           int nrhs, DoublePointer a, int lda,
                           DoublePointer b, int ldb, IntPointer jpvt,
                           double rcond, IntPointer rank );
public static native int LAPACKE_dgelsy( int matrix_layout, int m, int n,
                           int nrhs, DoubleBuffer a, int lda,
                           DoubleBuffer b, int ldb, IntBuffer jpvt,
                           double rcond, IntBuffer rank );
public static native int LAPACKE_dgelsy( int matrix_layout, int m, int n,
                           int nrhs, double[] a, int lda,
                           double[] b, int ldb, int[] jpvt,
                           double rcond, int[] rank );
public static native int LAPACKE_cgelsy( int matrix_layout, int m, int n,
                           int nrhs, @Cast("lapack_complex_float*") FloatPointer a,
                           int lda, @Cast("lapack_complex_float*") FloatPointer b,
                           int ldb, IntPointer jpvt, float rcond,
                           IntPointer rank );
public static native int LAPACKE_cgelsy( int matrix_layout, int m, int n,
                           int nrhs, @Cast("lapack_complex_float*") FloatBuffer a,
                           int lda, @Cast("lapack_complex_float*") FloatBuffer b,
                           int ldb, IntBuffer jpvt, float rcond,
                           IntBuffer rank );
public static native int LAPACKE_cgelsy( int matrix_layout, int m, int n,
                           int nrhs, @Cast("lapack_complex_float*") float[] a,
                           int lda, @Cast("lapack_complex_float*") float[] b,
                           int ldb, int[] jpvt, float rcond,
                           int[] rank );
public static native int LAPACKE_zgelsy( int matrix_layout, int m, int n,
                           int nrhs, @Cast("lapack_complex_double*") DoublePointer a,
                           int lda, @Cast("lapack_complex_double*") DoublePointer b,
                           int ldb, IntPointer jpvt, double rcond,
                           IntPointer rank );
public static native int LAPACKE_zgelsy( int matrix_layout, int m, int n,
                           int nrhs, @Cast("lapack_complex_double*") DoubleBuffer a,
                           int lda, @Cast("lapack_complex_double*") DoubleBuffer b,
                           int ldb, IntBuffer jpvt, double rcond,
                           IntBuffer rank );
public static native int LAPACKE_zgelsy( int matrix_layout, int m, int n,
                           int nrhs, @Cast("lapack_complex_double*") double[] a,
                           int lda, @Cast("lapack_complex_double*") double[] b,
                           int ldb, int[] jpvt, double rcond,
                           int[] rank );

public static native int LAPACKE_sgeqlf( int matrix_layout, int m, int n,
                           FloatPointer a, int lda, FloatPointer tau );
public static native int LAPACKE_sgeqlf( int matrix_layout, int m, int n,
                           FloatBuffer a, int lda, FloatBuffer tau );
public static native int LAPACKE_sgeqlf( int matrix_layout, int m, int n,
                           float[] a, int lda, float[] tau );
public static native int LAPACKE_dgeqlf( int matrix_layout, int m, int n,
                           DoublePointer a, int lda, DoublePointer tau );
public static native int LAPACKE_dgeqlf( int matrix_layout, int m, int n,
                           DoubleBuffer a, int lda, DoubleBuffer tau );
public static native int LAPACKE_dgeqlf( int matrix_layout, int m, int n,
                           double[] a, int lda, double[] tau );
public static native int LAPACKE_cgeqlf( int matrix_layout, int m, int n,
                           @Cast("lapack_complex_float*") FloatPointer a, int lda,
                           @Cast("lapack_complex_float*") FloatPointer tau );
public static native int LAPACKE_cgeqlf( int matrix_layout, int m, int n,
                           @Cast("lapack_complex_float*") FloatBuffer a, int lda,
                           @Cast("lapack_complex_float*") FloatBuffer tau );
public static native int LAPACKE_cgeqlf( int matrix_layout, int m, int n,
                           @Cast("lapack_complex_float*") float[] a, int lda,
                           @Cast("lapack_complex_float*") float[] tau );
public static native int LAPACKE_zgeqlf( int matrix_layout, int m, int n,
                           @Cast("lapack_complex_double*") DoublePointer a, int lda,
                           @Cast("lapack_complex_double*") DoublePointer tau );
public static native int LAPACKE_zgeqlf( int matrix_layout, int m, int n,
                           @Cast("lapack_complex_double*") DoubleBuffer a, int lda,
                           @Cast("lapack_complex_double*") DoubleBuffer tau );
public static native int LAPACKE_zgeqlf( int matrix_layout, int m, int n,
                           @Cast("lapack_complex_double*") double[] a, int lda,
                           @Cast("lapack_complex_double*") double[] tau );

public static native int LAPACKE_sgeqp3( int matrix_layout, int m, int n,
                           FloatPointer a, int lda, IntPointer jpvt,
                           FloatPointer tau );
public static native int LAPACKE_sgeqp3( int matrix_layout, int m, int n,
                           FloatBuffer a, int lda, IntBuffer jpvt,
                           FloatBuffer tau );
public static native int LAPACKE_sgeqp3( int matrix_layout, int m, int n,
                           float[] a, int lda, int[] jpvt,
                           float[] tau );
public static native int LAPACKE_dgeqp3( int matrix_layout, int m, int n,
                           DoublePointer a, int lda, IntPointer jpvt,
                           DoublePointer tau );
public static native int LAPACKE_dgeqp3( int matrix_layout, int m, int n,
                           DoubleBuffer a, int lda, IntBuffer jpvt,
                           DoubleBuffer tau );
public static native int LAPACKE_dgeqp3( int matrix_layout, int m, int n,
                           double[] a, int lda, int[] jpvt,
                           double[] tau );
public static native int LAPACKE_cgeqp3( int matrix_layout, int m, int n,
                           @Cast("lapack_complex_float*") FloatPointer a, int lda,
                           IntPointer jpvt, @Cast("lapack_complex_float*") FloatPointer tau );
public static native int LAPACKE_cgeqp3( int matrix_layout, int m, int n,
                           @Cast("lapack_complex_float*") FloatBuffer a, int lda,
                           IntBuffer jpvt, @Cast("lapack_complex_float*") FloatBuffer tau );
public static native int LAPACKE_cgeqp3( int matrix_layout, int m, int n,
                           @Cast("lapack_complex_float*") float[] a, int lda,
                           int[] jpvt, @Cast("lapack_complex_float*") float[] tau );
public static native int LAPACKE_zgeqp3( int matrix_layout, int m, int n,
                           @Cast("lapack_complex_double*") DoublePointer a, int lda,
                           IntPointer jpvt, @Cast("lapack_complex_double*") DoublePointer tau );
public static native int LAPACKE_zgeqp3( int matrix_layout, int m, int n,
                           @Cast("lapack_complex_double*") DoubleBuffer a, int lda,
                           IntBuffer jpvt, @Cast("lapack_complex_double*") DoubleBuffer tau );
public static native int LAPACKE_zgeqp3( int matrix_layout, int m, int n,
                           @Cast("lapack_complex_double*") double[] a, int lda,
                           int[] jpvt, @Cast("lapack_complex_double*") double[] tau );






public static native int LAPACKE_sgeqr2( int matrix_layout, int m, int n,
                           FloatPointer a, int lda, FloatPointer tau );
public static native int LAPACKE_sgeqr2( int matrix_layout, int m, int n,
                           FloatBuffer a, int lda, FloatBuffer tau );
public static native int LAPACKE_sgeqr2( int matrix_layout, int m, int n,
                           float[] a, int lda, float[] tau );
public static native int LAPACKE_dgeqr2( int matrix_layout, int m, int n,
                           DoublePointer a, int lda, DoublePointer tau );
public static native int LAPACKE_dgeqr2( int matrix_layout, int m, int n,
                           DoubleBuffer a, int lda, DoubleBuffer tau );
public static native int LAPACKE_dgeqr2( int matrix_layout, int m, int n,
                           double[] a, int lda, double[] tau );
public static native int LAPACKE_cgeqr2( int matrix_layout, int m, int n,
                           @Cast("lapack_complex_float*") FloatPointer a, int lda,
                           @Cast("lapack_complex_float*") FloatPointer tau );
public static native int LAPACKE_cgeqr2( int matrix_layout, int m, int n,
                           @Cast("lapack_complex_float*") FloatBuffer a, int lda,
                           @Cast("lapack_complex_float*") FloatBuffer tau );
public static native int LAPACKE_cgeqr2( int matrix_layout, int m, int n,
                           @Cast("lapack_complex_float*") float[] a, int lda,
                           @Cast("lapack_complex_float*") float[] tau );
public static native int LAPACKE_zgeqr2( int matrix_layout, int m, int n,
                           @Cast("lapack_complex_double*") DoublePointer a, int lda,
                           @Cast("lapack_complex_double*") DoublePointer tau );
public static native int LAPACKE_zgeqr2( int matrix_layout, int m, int n,
                           @Cast("lapack_complex_double*") DoubleBuffer a, int lda,
                           @Cast("lapack_complex_double*") DoubleBuffer tau );
public static native int LAPACKE_zgeqr2( int matrix_layout, int m, int n,
                           @Cast("lapack_complex_double*") double[] a, int lda,
                           @Cast("lapack_complex_double*") double[] tau );

public static native int LAPACKE_sgeqrf( int matrix_layout, int m, int n,
                           FloatPointer a, int lda, FloatPointer tau );
public static native int LAPACKE_sgeqrf( int matrix_layout, int m, int n,
                           FloatBuffer a, int lda, FloatBuffer tau );
public static native int LAPACKE_sgeqrf( int matrix_layout, int m, int n,
                           float[] a, int lda, float[] tau );
public static native int LAPACKE_dgeqrf( int matrix_layout, int m, int n,
                           DoublePointer a, int lda, DoublePointer tau );
public static native int LAPACKE_dgeqrf( int matrix_layout, int m, int n,
                           DoubleBuffer a, int lda, DoubleBuffer tau );
public static native int LAPACKE_dgeqrf( int matrix_layout, int m, int n,
                           double[] a, int lda, double[] tau );
public static native int LAPACKE_cgeqrf( int matrix_layout, int m, int n,
                           @Cast("lapack_complex_float*") FloatPointer a, int lda,
                           @Cast("lapack_complex_float*") FloatPointer tau );
public static native int LAPACKE_cgeqrf( int matrix_layout, int m, int n,
                           @Cast("lapack_complex_float*") FloatBuffer a, int lda,
                           @Cast("lapack_complex_float*") FloatBuffer tau );
public static native int LAPACKE_cgeqrf( int matrix_layout, int m, int n,
                           @Cast("lapack_complex_float*") float[] a, int lda,
                           @Cast("lapack_complex_float*") float[] tau );
public static native int LAPACKE_zgeqrf( int matrix_layout, int m, int n,
                           @Cast("lapack_complex_double*") DoublePointer a, int lda,
                           @Cast("lapack_complex_double*") DoublePointer tau );
public static native int LAPACKE_zgeqrf( int matrix_layout, int m, int n,
                           @Cast("lapack_complex_double*") DoubleBuffer a, int lda,
                           @Cast("lapack_complex_double*") DoubleBuffer tau );
public static native int LAPACKE_zgeqrf( int matrix_layout, int m, int n,
                           @Cast("lapack_complex_double*") double[] a, int lda,
                           @Cast("lapack_complex_double*") double[] tau );

public static native int LAPACKE_sgeqrfp( int matrix_layout, int m, int n,
                            FloatPointer a, int lda, FloatPointer tau );
public static native int LAPACKE_sgeqrfp( int matrix_layout, int m, int n,
                            FloatBuffer a, int lda, FloatBuffer tau );
public static native int LAPACKE_sgeqrfp( int matrix_layout, int m, int n,
                            float[] a, int lda, float[] tau );
public static native int LAPACKE_dgeqrfp( int matrix_layout, int m, int n,
                            DoublePointer a, int lda, DoublePointer tau );
public static native int LAPACKE_dgeqrfp( int matrix_layout, int m, int n,
                            DoubleBuffer a, int lda, DoubleBuffer tau );
public static native int LAPACKE_dgeqrfp( int matrix_layout, int m, int n,
                            double[] a, int lda, double[] tau );
public static native int LAPACKE_cgeqrfp( int matrix_layout, int m, int n,
                            @Cast("lapack_complex_float*") FloatPointer a, int lda,
                            @Cast("lapack_complex_float*") FloatPointer tau );
public static native int LAPACKE_cgeqrfp( int matrix_layout, int m, int n,
                            @Cast("lapack_complex_float*") FloatBuffer a, int lda,
                            @Cast("lapack_complex_float*") FloatBuffer tau );
public static native int LAPACKE_cgeqrfp( int matrix_layout, int m, int n,
                            @Cast("lapack_complex_float*") float[] a, int lda,
                            @Cast("lapack_complex_float*") float[] tau );
public static native int LAPACKE_zgeqrfp( int matrix_layout, int m, int n,
                            @Cast("lapack_complex_double*") DoublePointer a, int lda,
                            @Cast("lapack_complex_double*") DoublePointer tau );
public static native int LAPACKE_zgeqrfp( int matrix_layout, int m, int n,
                            @Cast("lapack_complex_double*") DoubleBuffer a, int lda,
                            @Cast("lapack_complex_double*") DoubleBuffer tau );
public static native int LAPACKE_zgeqrfp( int matrix_layout, int m, int n,
                            @Cast("lapack_complex_double*") double[] a, int lda,
                            @Cast("lapack_complex_double*") double[] tau );

public static native int LAPACKE_sgerfs( int matrix_layout, @Cast("char") byte trans, int n,
                           int nrhs, @Const FloatPointer a, int lda,
                           @Const FloatPointer af, int ldaf,
                           @Const IntPointer ipiv, @Const FloatPointer b,
                           int ldb, FloatPointer x, int ldx,
                           FloatPointer ferr, FloatPointer berr );
public static native int LAPACKE_sgerfs( int matrix_layout, @Cast("char") byte trans, int n,
                           int nrhs, @Const FloatBuffer a, int lda,
                           @Const FloatBuffer af, int ldaf,
                           @Const IntBuffer ipiv, @Const FloatBuffer b,
                           int ldb, FloatBuffer x, int ldx,
                           FloatBuffer ferr, FloatBuffer berr );
public static native int LAPACKE_sgerfs( int matrix_layout, @Cast("char") byte trans, int n,
                           int nrhs, @Const float[] a, int lda,
                           @Const float[] af, int ldaf,
                           @Const int[] ipiv, @Const float[] b,
                           int ldb, float[] x, int ldx,
                           float[] ferr, float[] berr );
public static native int LAPACKE_dgerfs( int matrix_layout, @Cast("char") byte trans, int n,
                           int nrhs, @Const DoublePointer a, int lda,
                           @Const DoublePointer af, int ldaf,
                           @Const IntPointer ipiv, @Const DoublePointer b,
                           int ldb, DoublePointer x, int ldx,
                           DoublePointer ferr, DoublePointer berr );
public static native int LAPACKE_dgerfs( int matrix_layout, @Cast("char") byte trans, int n,
                           int nrhs, @Const DoubleBuffer a, int lda,
                           @Const DoubleBuffer af, int ldaf,
                           @Const IntBuffer ipiv, @Const DoubleBuffer b,
                           int ldb, DoubleBuffer x, int ldx,
                           DoubleBuffer ferr, DoubleBuffer berr );
public static native int LAPACKE_dgerfs( int matrix_layout, @Cast("char") byte trans, int n,
                           int nrhs, @Const double[] a, int lda,
                           @Const double[] af, int ldaf,
                           @Const int[] ipiv, @Const double[] b,
                           int ldb, double[] x, int ldx,
                           double[] ferr, double[] berr );
public static native int LAPACKE_cgerfs( int matrix_layout, @Cast("char") byte trans, int n,
                           int nrhs, @Cast("const lapack_complex_float*") FloatPointer a,
                           int lda, @Cast("const lapack_complex_float*") FloatPointer af,
                           int ldaf, @Const IntPointer ipiv,
                           @Cast("const lapack_complex_float*") FloatPointer b, int ldb,
                           @Cast("lapack_complex_float*") FloatPointer x, int ldx, FloatPointer ferr,
                           FloatPointer berr );
public static native int LAPACKE_cgerfs( int matrix_layout, @Cast("char") byte trans, int n,
                           int nrhs, @Cast("const lapack_complex_float*") FloatBuffer a,
                           int lda, @Cast("const lapack_complex_float*") FloatBuffer af,
                           int ldaf, @Const IntBuffer ipiv,
                           @Cast("const lapack_complex_float*") FloatBuffer b, int ldb,
                           @Cast("lapack_complex_float*") FloatBuffer x, int ldx, FloatBuffer ferr,
                           FloatBuffer berr );
public static native int LAPACKE_cgerfs( int matrix_layout, @Cast("char") byte trans, int n,
                           int nrhs, @Cast("const lapack_complex_float*") float[] a,
                           int lda, @Cast("const lapack_complex_float*") float[] af,
                           int ldaf, @Const int[] ipiv,
                           @Cast("const lapack_complex_float*") float[] b, int ldb,
                           @Cast("lapack_complex_float*") float[] x, int ldx, float[] ferr,
                           float[] berr );
public static native int LAPACKE_zgerfs( int matrix_layout, @Cast("char") byte trans, int n,
                           int nrhs, @Cast("const lapack_complex_double*") DoublePointer a,
                           int lda, @Cast("const lapack_complex_double*") DoublePointer af,
                           int ldaf, @Const IntPointer ipiv,
                           @Cast("const lapack_complex_double*") DoublePointer b, int ldb,
                           @Cast("lapack_complex_double*") DoublePointer x, int ldx,
                           DoublePointer ferr, DoublePointer berr );
public static native int LAPACKE_zgerfs( int matrix_layout, @Cast("char") byte trans, int n,
                           int nrhs, @Cast("const lapack_complex_double*") DoubleBuffer a,
                           int lda, @Cast("const lapack_complex_double*") DoubleBuffer af,
                           int ldaf, @Const IntBuffer ipiv,
                           @Cast("const lapack_complex_double*") DoubleBuffer b, int ldb,
                           @Cast("lapack_complex_double*") DoubleBuffer x, int ldx,
                           DoubleBuffer ferr, DoubleBuffer berr );
public static native int LAPACKE_zgerfs( int matrix_layout, @Cast("char") byte trans, int n,
                           int nrhs, @Cast("const lapack_complex_double*") double[] a,
                           int lda, @Cast("const lapack_complex_double*") double[] af,
                           int ldaf, @Const int[] ipiv,
                           @Cast("const lapack_complex_double*") double[] b, int ldb,
                           @Cast("lapack_complex_double*") double[] x, int ldx,
                           double[] ferr, double[] berr );






public static native int LAPACKE_sgerqf( int matrix_layout, int m, int n,
                           FloatPointer a, int lda, FloatPointer tau );
public static native int LAPACKE_sgerqf( int matrix_layout, int m, int n,
                           FloatBuffer a, int lda, FloatBuffer tau );
public static native int LAPACKE_sgerqf( int matrix_layout, int m, int n,
                           float[] a, int lda, float[] tau );
public static native int LAPACKE_dgerqf( int matrix_layout, int m, int n,
                           DoublePointer a, int lda, DoublePointer tau );
public static native int LAPACKE_dgerqf( int matrix_layout, int m, int n,
                           DoubleBuffer a, int lda, DoubleBuffer tau );
public static native int LAPACKE_dgerqf( int matrix_layout, int m, int n,
                           double[] a, int lda, double[] tau );
public static native int LAPACKE_cgerqf( int matrix_layout, int m, int n,
                           @Cast("lapack_complex_float*") FloatPointer a, int lda,
                           @Cast("lapack_complex_float*") FloatPointer tau );
public static native int LAPACKE_cgerqf( int matrix_layout, int m, int n,
                           @Cast("lapack_complex_float*") FloatBuffer a, int lda,
                           @Cast("lapack_complex_float*") FloatBuffer tau );
public static native int LAPACKE_cgerqf( int matrix_layout, int m, int n,
                           @Cast("lapack_complex_float*") float[] a, int lda,
                           @Cast("lapack_complex_float*") float[] tau );
public static native int LAPACKE_zgerqf( int matrix_layout, int m, int n,
                           @Cast("lapack_complex_double*") DoublePointer a, int lda,
                           @Cast("lapack_complex_double*") DoublePointer tau );
public static native int LAPACKE_zgerqf( int matrix_layout, int m, int n,
                           @Cast("lapack_complex_double*") DoubleBuffer a, int lda,
                           @Cast("lapack_complex_double*") DoubleBuffer tau );
public static native int LAPACKE_zgerqf( int matrix_layout, int m, int n,
                           @Cast("lapack_complex_double*") double[] a, int lda,
                           @Cast("lapack_complex_double*") double[] tau );

public static native int LAPACKE_sgesdd( int matrix_layout, @Cast("char") byte jobz, int m,
                           int n, FloatPointer a, int lda, FloatPointer s,
                           FloatPointer u, int ldu, FloatPointer vt,
                           int ldvt );
public static native int LAPACKE_sgesdd( int matrix_layout, @Cast("char") byte jobz, int m,
                           int n, FloatBuffer a, int lda, FloatBuffer s,
                           FloatBuffer u, int ldu, FloatBuffer vt,
                           int ldvt );
public static native int LAPACKE_sgesdd( int matrix_layout, @Cast("char") byte jobz, int m,
                           int n, float[] a, int lda, float[] s,
                           float[] u, int ldu, float[] vt,
                           int ldvt );
public static native int LAPACKE_dgesdd( int matrix_layout, @Cast("char") byte jobz, int m,
                           int n, DoublePointer a, int lda, DoublePointer s,
                           DoublePointer u, int ldu, DoublePointer vt,
                           int ldvt );
public static native int LAPACKE_dgesdd( int matrix_layout, @Cast("char") byte jobz, int m,
                           int n, DoubleBuffer a, int lda, DoubleBuffer s,
                           DoubleBuffer u, int ldu, DoubleBuffer vt,
                           int ldvt );
public static native int LAPACKE_dgesdd( int matrix_layout, @Cast("char") byte jobz, int m,
                           int n, double[] a, int lda, double[] s,
                           double[] u, int ldu, double[] vt,
                           int ldvt );
public static native int LAPACKE_cgesdd( int matrix_layout, @Cast("char") byte jobz, int m,
                           int n, @Cast("lapack_complex_float*") FloatPointer a,
                           int lda, FloatPointer s, @Cast("lapack_complex_float*") FloatPointer u,
                           int ldu, @Cast("lapack_complex_float*") FloatPointer vt,
                           int ldvt );
public static native int LAPACKE_cgesdd( int matrix_layout, @Cast("char") byte jobz, int m,
                           int n, @Cast("lapack_complex_float*") FloatBuffer a,
                           int lda, FloatBuffer s, @Cast("lapack_complex_float*") FloatBuffer u,
                           int ldu, @Cast("lapack_complex_float*") FloatBuffer vt,
                           int ldvt );
public static native int LAPACKE_cgesdd( int matrix_layout, @Cast("char") byte jobz, int m,
                           int n, @Cast("lapack_complex_float*") float[] a,
                           int lda, float[] s, @Cast("lapack_complex_float*") float[] u,
                           int ldu, @Cast("lapack_complex_float*") float[] vt,
                           int ldvt );
public static native int LAPACKE_zgesdd( int matrix_layout, @Cast("char") byte jobz, int m,
                           int n, @Cast("lapack_complex_double*") DoublePointer a,
                           int lda, DoublePointer s, @Cast("lapack_complex_double*") DoublePointer u,
                           int ldu, @Cast("lapack_complex_double*") DoublePointer vt,
                           int ldvt );
public static native int LAPACKE_zgesdd( int matrix_layout, @Cast("char") byte jobz, int m,
                           int n, @Cast("lapack_complex_double*") DoubleBuffer a,
                           int lda, DoubleBuffer s, @Cast("lapack_complex_double*") DoubleBuffer u,
                           int ldu, @Cast("lapack_complex_double*") DoubleBuffer vt,
                           int ldvt );
public static native int LAPACKE_zgesdd( int matrix_layout, @Cast("char") byte jobz, int m,
                           int n, @Cast("lapack_complex_double*") double[] a,
                           int lda, double[] s, @Cast("lapack_complex_double*") double[] u,
                           int ldu, @Cast("lapack_complex_double*") double[] vt,
                           int ldvt );

public static native int LAPACKE_sgesv( int matrix_layout, int n, int nrhs,
                          FloatPointer a, int lda, IntPointer ipiv, FloatPointer b,
                          int ldb );
public static native int LAPACKE_sgesv( int matrix_layout, int n, int nrhs,
                          FloatBuffer a, int lda, IntBuffer ipiv, FloatBuffer b,
                          int ldb );
public static native int LAPACKE_sgesv( int matrix_layout, int n, int nrhs,
                          float[] a, int lda, int[] ipiv, float[] b,
                          int ldb );
public static native int LAPACKE_dgesv( int matrix_layout, int n, int nrhs,
                          DoublePointer a, int lda, IntPointer ipiv,
                          DoublePointer b, int ldb );
public static native int LAPACKE_dgesv( int matrix_layout, int n, int nrhs,
                          DoubleBuffer a, int lda, IntBuffer ipiv,
                          DoubleBuffer b, int ldb );
public static native int LAPACKE_dgesv( int matrix_layout, int n, int nrhs,
                          double[] a, int lda, int[] ipiv,
                          double[] b, int ldb );
public static native int LAPACKE_cgesv( int matrix_layout, int n, int nrhs,
                          @Cast("lapack_complex_float*") FloatPointer a, int lda,
                          IntPointer ipiv, @Cast("lapack_complex_float*") FloatPointer b,
                          int ldb );
public static native int LAPACKE_cgesv( int matrix_layout, int n, int nrhs,
                          @Cast("lapack_complex_float*") FloatBuffer a, int lda,
                          IntBuffer ipiv, @Cast("lapack_complex_float*") FloatBuffer b,
                          int ldb );
public static native int LAPACKE_cgesv( int matrix_layout, int n, int nrhs,
                          @Cast("lapack_complex_float*") float[] a, int lda,
                          int[] ipiv, @Cast("lapack_complex_float*") float[] b,
                          int ldb );
public static native int LAPACKE_zgesv( int matrix_layout, int n, int nrhs,
                          @Cast("lapack_complex_double*") DoublePointer a, int lda,
                          IntPointer ipiv, @Cast("lapack_complex_double*") DoublePointer b,
                          int ldb );
public static native int LAPACKE_zgesv( int matrix_layout, int n, int nrhs,
                          @Cast("lapack_complex_double*") DoubleBuffer a, int lda,
                          IntBuffer ipiv, @Cast("lapack_complex_double*") DoubleBuffer b,
                          int ldb );
public static native int LAPACKE_zgesv( int matrix_layout, int n, int nrhs,
                          @Cast("lapack_complex_double*") double[] a, int lda,
                          int[] ipiv, @Cast("lapack_complex_double*") double[] b,
                          int ldb );
public static native int LAPACKE_dsgesv( int matrix_layout, int n, int nrhs,
                           DoublePointer a, int lda, IntPointer ipiv,
                           DoublePointer b, int ldb, DoublePointer x, int ldx,
                           IntPointer iter );
public static native int LAPACKE_dsgesv( int matrix_layout, int n, int nrhs,
                           DoubleBuffer a, int lda, IntBuffer ipiv,
                           DoubleBuffer b, int ldb, DoubleBuffer x, int ldx,
                           IntBuffer iter );
public static native int LAPACKE_dsgesv( int matrix_layout, int n, int nrhs,
                           double[] a, int lda, int[] ipiv,
                           double[] b, int ldb, double[] x, int ldx,
                           int[] iter );
public static native int LAPACKE_zcgesv( int matrix_layout, int n, int nrhs,
                           @Cast("lapack_complex_double*") DoublePointer a, int lda,
                           IntPointer ipiv, @Cast("lapack_complex_double*") DoublePointer b,
                           int ldb, @Cast("lapack_complex_double*") DoublePointer x,
                           int ldx, IntPointer iter );
public static native int LAPACKE_zcgesv( int matrix_layout, int n, int nrhs,
                           @Cast("lapack_complex_double*") DoubleBuffer a, int lda,
                           IntBuffer ipiv, @Cast("lapack_complex_double*") DoubleBuffer b,
                           int ldb, @Cast("lapack_complex_double*") DoubleBuffer x,
                           int ldx, IntBuffer iter );
public static native int LAPACKE_zcgesv( int matrix_layout, int n, int nrhs,
                           @Cast("lapack_complex_double*") double[] a, int lda,
                           int[] ipiv, @Cast("lapack_complex_double*") double[] b,
                           int ldb, @Cast("lapack_complex_double*") double[] x,
                           int ldx, int[] iter );

public static native int LAPACKE_sgesvd( int matrix_layout, @Cast("char") byte jobu, @Cast("char") byte jobvt,
                           int m, int n, FloatPointer a, int lda,
                           FloatPointer s, FloatPointer u, int ldu, FloatPointer vt,
                           int ldvt, FloatPointer superb );
public static native int LAPACKE_sgesvd( int matrix_layout, @Cast("char") byte jobu, @Cast("char") byte jobvt,
                           int m, int n, FloatBuffer a, int lda,
                           FloatBuffer s, FloatBuffer u, int ldu, FloatBuffer vt,
                           int ldvt, FloatBuffer superb );
public static native int LAPACKE_sgesvd( int matrix_layout, @Cast("char") byte jobu, @Cast("char") byte jobvt,
                           int m, int n, float[] a, int lda,
                           float[] s, float[] u, int ldu, float[] vt,
                           int ldvt, float[] superb );
public static native int LAPACKE_dgesvd( int matrix_layout, @Cast("char") byte jobu, @Cast("char") byte jobvt,
                           int m, int n, DoublePointer a,
                           int lda, DoublePointer s, DoublePointer u, int ldu,
                           DoublePointer vt, int ldvt, DoublePointer superb );
public static native int LAPACKE_dgesvd( int matrix_layout, @Cast("char") byte jobu, @Cast("char") byte jobvt,
                           int m, int n, DoubleBuffer a,
                           int lda, DoubleBuffer s, DoubleBuffer u, int ldu,
                           DoubleBuffer vt, int ldvt, DoubleBuffer superb );
public static native int LAPACKE_dgesvd( int matrix_layout, @Cast("char") byte jobu, @Cast("char") byte jobvt,
                           int m, int n, double[] a,
                           int lda, double[] s, double[] u, int ldu,
                           double[] vt, int ldvt, double[] superb );
public static native int LAPACKE_cgesvd( int matrix_layout, @Cast("char") byte jobu, @Cast("char") byte jobvt,
                           int m, int n, @Cast("lapack_complex_float*") FloatPointer a,
                           int lda, FloatPointer s, @Cast("lapack_complex_float*") FloatPointer u,
                           int ldu, @Cast("lapack_complex_float*") FloatPointer vt,
                           int ldvt, FloatPointer superb );
public static native int LAPACKE_cgesvd( int matrix_layout, @Cast("char") byte jobu, @Cast("char") byte jobvt,
                           int m, int n, @Cast("lapack_complex_float*") FloatBuffer a,
                           int lda, FloatBuffer s, @Cast("lapack_complex_float*") FloatBuffer u,
                           int ldu, @Cast("lapack_complex_float*") FloatBuffer vt,
                           int ldvt, FloatBuffer superb );
public static native int LAPACKE_cgesvd( int matrix_layout, @Cast("char") byte jobu, @Cast("char") byte jobvt,
                           int m, int n, @Cast("lapack_complex_float*") float[] a,
                           int lda, float[] s, @Cast("lapack_complex_float*") float[] u,
                           int ldu, @Cast("lapack_complex_float*") float[] vt,
                           int ldvt, float[] superb );
public static native int LAPACKE_zgesvd( int matrix_layout, @Cast("char") byte jobu, @Cast("char") byte jobvt,
                           int m, int n, @Cast("lapack_complex_double*") DoublePointer a,
                           int lda, DoublePointer s, @Cast("lapack_complex_double*") DoublePointer u,
                           int ldu, @Cast("lapack_complex_double*") DoublePointer vt,
                           int ldvt, DoublePointer superb );
public static native int LAPACKE_zgesvd( int matrix_layout, @Cast("char") byte jobu, @Cast("char") byte jobvt,
                           int m, int n, @Cast("lapack_complex_double*") DoubleBuffer a,
                           int lda, DoubleBuffer s, @Cast("lapack_complex_double*") DoubleBuffer u,
                           int ldu, @Cast("lapack_complex_double*") DoubleBuffer vt,
                           int ldvt, DoubleBuffer superb );
public static native int LAPACKE_zgesvd( int matrix_layout, @Cast("char") byte jobu, @Cast("char") byte jobvt,
                           int m, int n, @Cast("lapack_complex_double*") double[] a,
                           int lda, double[] s, @Cast("lapack_complex_double*") double[] u,
                           int ldu, @Cast("lapack_complex_double*") double[] vt,
                           int ldvt, double[] superb );

public static native int LAPACKE_sgesvdx( int matrix_layout, @Cast("char") byte jobu, @Cast("char") byte jobvt, @Cast("char") byte range,
                           int m, int n, FloatPointer a,
                           int lda, float vl, float vu,
                           int il, int iu, IntPointer ns,
                           FloatPointer s, FloatPointer u, int ldu,
                           FloatPointer vt, int ldvt,
                           IntPointer superb );
public static native int LAPACKE_sgesvdx( int matrix_layout, @Cast("char") byte jobu, @Cast("char") byte jobvt, @Cast("char") byte range,
                           int m, int n, FloatBuffer a,
                           int lda, float vl, float vu,
                           int il, int iu, IntBuffer ns,
                           FloatBuffer s, FloatBuffer u, int ldu,
                           FloatBuffer vt, int ldvt,
                           IntBuffer superb );
public static native int LAPACKE_sgesvdx( int matrix_layout, @Cast("char") byte jobu, @Cast("char") byte jobvt, @Cast("char") byte range,
                           int m, int n, float[] a,
                           int lda, float vl, float vu,
                           int il, int iu, int[] ns,
                           float[] s, float[] u, int ldu,
                           float[] vt, int ldvt,
                           int[] superb );
public static native int LAPACKE_dgesvdx( int matrix_layout, @Cast("char") byte jobu, @Cast("char") byte jobvt, @Cast("char") byte range,
                           int m, int n, DoublePointer a,
                           int lda, double vl, double vu,
                           int il, int iu, IntPointer ns,
                           DoublePointer s, DoublePointer u, int ldu,
                           DoublePointer vt, int ldvt,
                           IntPointer superb );
public static native int LAPACKE_dgesvdx( int matrix_layout, @Cast("char") byte jobu, @Cast("char") byte jobvt, @Cast("char") byte range,
                           int m, int n, DoubleBuffer a,
                           int lda, double vl, double vu,
                           int il, int iu, IntBuffer ns,
                           DoubleBuffer s, DoubleBuffer u, int ldu,
                           DoubleBuffer vt, int ldvt,
                           IntBuffer superb );
public static native int LAPACKE_dgesvdx( int matrix_layout, @Cast("char") byte jobu, @Cast("char") byte jobvt, @Cast("char") byte range,
                           int m, int n, double[] a,
                           int lda, double vl, double vu,
                           int il, int iu, int[] ns,
                           double[] s, double[] u, int ldu,
                           double[] vt, int ldvt,
                           int[] superb );
public static native int LAPACKE_cgesvdx( int matrix_layout, @Cast("char") byte jobu, @Cast("char") byte jobvt, @Cast("char") byte range,
                           int m, int n, @Cast("lapack_complex_float*") FloatPointer a,
                           int lda, float vl, float vu,
                           int il, int iu, IntPointer ns,
                           FloatPointer s, @Cast("lapack_complex_float*") FloatPointer u, int ldu,
                           @Cast("lapack_complex_float*") FloatPointer vt, int ldvt,
                           IntPointer superb );
public static native int LAPACKE_cgesvdx( int matrix_layout, @Cast("char") byte jobu, @Cast("char") byte jobvt, @Cast("char") byte range,
                           int m, int n, @Cast("lapack_complex_float*") FloatBuffer a,
                           int lda, float vl, float vu,
                           int il, int iu, IntBuffer ns,
                           FloatBuffer s, @Cast("lapack_complex_float*") FloatBuffer u, int ldu,
                           @Cast("lapack_complex_float*") FloatBuffer vt, int ldvt,
                           IntBuffer superb );
public static native int LAPACKE_cgesvdx( int matrix_layout, @Cast("char") byte jobu, @Cast("char") byte jobvt, @Cast("char") byte range,
                           int m, int n, @Cast("lapack_complex_float*") float[] a,
                           int lda, float vl, float vu,
                           int il, int iu, int[] ns,
                           float[] s, @Cast("lapack_complex_float*") float[] u, int ldu,
                           @Cast("lapack_complex_float*") float[] vt, int ldvt,
                           int[] superb );
public static native int LAPACKE_zgesvdx( int matrix_layout, @Cast("char") byte jobu, @Cast("char") byte jobvt, @Cast("char") byte range,
                           int m, int n, @Cast("lapack_complex_double*") DoublePointer a,
                           int lda, double vl, double vu,
                           int il, int iu, IntPointer ns,
                           DoublePointer s, @Cast("lapack_complex_double*") DoublePointer u, int ldu,
                           @Cast("lapack_complex_double*") DoublePointer vt, int ldvt,
                           IntPointer superb );
public static native int LAPACKE_zgesvdx( int matrix_layout, @Cast("char") byte jobu, @Cast("char") byte jobvt, @Cast("char") byte range,
                           int m, int n, @Cast("lapack_complex_double*") DoubleBuffer a,
                           int lda, double vl, double vu,
                           int il, int iu, IntBuffer ns,
                           DoubleBuffer s, @Cast("lapack_complex_double*") DoubleBuffer u, int ldu,
                           @Cast("lapack_complex_double*") DoubleBuffer vt, int ldvt,
                           IntBuffer superb );
public static native int LAPACKE_zgesvdx( int matrix_layout, @Cast("char") byte jobu, @Cast("char") byte jobvt, @Cast("char") byte range,
                           int m, int n, @Cast("lapack_complex_double*") double[] a,
                           int lda, double vl, double vu,
                           int il, int iu, int[] ns,
                           double[] s, @Cast("lapack_complex_double*") double[] u, int ldu,
                           @Cast("lapack_complex_double*") double[] vt, int ldvt,
                           int[] superb );

public static native int LAPACKE_sgesvj( int matrix_layout, @Cast("char") byte joba, @Cast("char") byte jobu, @Cast("char") byte jobv,
                           int m, int n, FloatPointer a, int lda,
                           FloatPointer sva, int mv, FloatPointer v, int ldv,
                           FloatPointer stat );
public static native int LAPACKE_sgesvj( int matrix_layout, @Cast("char") byte joba, @Cast("char") byte jobu, @Cast("char") byte jobv,
                           int m, int n, FloatBuffer a, int lda,
                           FloatBuffer sva, int mv, FloatBuffer v, int ldv,
                           FloatBuffer stat );
public static native int LAPACKE_sgesvj( int matrix_layout, @Cast("char") byte joba, @Cast("char") byte jobu, @Cast("char") byte jobv,
                           int m, int n, float[] a, int lda,
                           float[] sva, int mv, float[] v, int ldv,
                           float[] stat );
public static native int LAPACKE_dgesvj( int matrix_layout, @Cast("char") byte joba, @Cast("char") byte jobu, @Cast("char") byte jobv,
                           int m, int n, DoublePointer a,
                           int lda, DoublePointer sva, int mv,
                           DoublePointer v, int ldv, DoublePointer stat );
public static native int LAPACKE_dgesvj( int matrix_layout, @Cast("char") byte joba, @Cast("char") byte jobu, @Cast("char") byte jobv,
                           int m, int n, DoubleBuffer a,
                           int lda, DoubleBuffer sva, int mv,
                           DoubleBuffer v, int ldv, DoubleBuffer stat );
public static native int LAPACKE_dgesvj( int matrix_layout, @Cast("char") byte joba, @Cast("char") byte jobu, @Cast("char") byte jobv,
                           int m, int n, double[] a,
                           int lda, double[] sva, int mv,
                           double[] v, int ldv, double[] stat );
public static native int LAPACKE_cgesvj( int matrix_layout, @Cast("char") byte joba, @Cast("char") byte jobu, @Cast("char") byte jobv,
                           int m, int n, @Cast("lapack_complex_float*") FloatPointer a,
                           int lda, FloatPointer sva, int mv,
                           @Cast("lapack_complex_float*") FloatPointer v, int ldv, FloatPointer stat );
public static native int LAPACKE_cgesvj( int matrix_layout, @Cast("char") byte joba, @Cast("char") byte jobu, @Cast("char") byte jobv,
                           int m, int n, @Cast("lapack_complex_float*") FloatBuffer a,
                           int lda, FloatBuffer sva, int mv,
                           @Cast("lapack_complex_float*") FloatBuffer v, int ldv, FloatBuffer stat );
public static native int LAPACKE_cgesvj( int matrix_layout, @Cast("char") byte joba, @Cast("char") byte jobu, @Cast("char") byte jobv,
                           int m, int n, @Cast("lapack_complex_float*") float[] a,
                           int lda, float[] sva, int mv,
                           @Cast("lapack_complex_float*") float[] v, int ldv, float[] stat );
public static native int LAPACKE_zgesvj( int matrix_layout, @Cast("char") byte joba, @Cast("char") byte jobu, @Cast("char") byte jobv,
                           int m, int n, @Cast("lapack_complex_double*") DoublePointer a,
                           int lda, DoublePointer sva, int mv,
                           @Cast("lapack_complex_double*") DoublePointer v, int ldv, DoublePointer stat );
public static native int LAPACKE_zgesvj( int matrix_layout, @Cast("char") byte joba, @Cast("char") byte jobu, @Cast("char") byte jobv,
                           int m, int n, @Cast("lapack_complex_double*") DoubleBuffer a,
                           int lda, DoubleBuffer sva, int mv,
                           @Cast("lapack_complex_double*") DoubleBuffer v, int ldv, DoubleBuffer stat );
public static native int LAPACKE_zgesvj( int matrix_layout, @Cast("char") byte joba, @Cast("char") byte jobu, @Cast("char") byte jobv,
                           int m, int n, @Cast("lapack_complex_double*") double[] a,
                           int lda, double[] sva, int mv,
                           @Cast("lapack_complex_double*") double[] v, int ldv, double[] stat );

public static native int LAPACKE_sgesvx( int matrix_layout, @Cast("char") byte fact, @Cast("char") byte trans,
                           int n, int nrhs, FloatPointer a,
                           int lda, FloatPointer af, int ldaf,
                           IntPointer ipiv, @Cast("char*") BytePointer equed, FloatPointer r, FloatPointer c,
                           FloatPointer b, int ldb, FloatPointer x, int ldx,
                           FloatPointer rcond, FloatPointer ferr, FloatPointer berr,
                           FloatPointer rpivot );
public static native int LAPACKE_sgesvx( int matrix_layout, @Cast("char") byte fact, @Cast("char") byte trans,
                           int n, int nrhs, FloatBuffer a,
                           int lda, FloatBuffer af, int ldaf,
                           IntBuffer ipiv, @Cast("char*") ByteBuffer equed, FloatBuffer r, FloatBuffer c,
                           FloatBuffer b, int ldb, FloatBuffer x, int ldx,
                           FloatBuffer rcond, FloatBuffer ferr, FloatBuffer berr,
                           FloatBuffer rpivot );
public static native int LAPACKE_sgesvx( int matrix_layout, @Cast("char") byte fact, @Cast("char") byte trans,
                           int n, int nrhs, float[] a,
                           int lda, float[] af, int ldaf,
                           int[] ipiv, @Cast("char*") byte[] equed, float[] r, float[] c,
                           float[] b, int ldb, float[] x, int ldx,
                           float[] rcond, float[] ferr, float[] berr,
                           float[] rpivot );
public static native int LAPACKE_dgesvx( int matrix_layout, @Cast("char") byte fact, @Cast("char") byte trans,
                           int n, int nrhs, DoublePointer a,
                           int lda, DoublePointer af, int ldaf,
                           IntPointer ipiv, @Cast("char*") BytePointer equed, DoublePointer r, DoublePointer c,
                           DoublePointer b, int ldb, DoublePointer x, int ldx,
                           DoublePointer rcond, DoublePointer ferr, DoublePointer berr,
                           DoublePointer rpivot );
public static native int LAPACKE_dgesvx( int matrix_layout, @Cast("char") byte fact, @Cast("char") byte trans,
                           int n, int nrhs, DoubleBuffer a,
                           int lda, DoubleBuffer af, int ldaf,
                           IntBuffer ipiv, @Cast("char*") ByteBuffer equed, DoubleBuffer r, DoubleBuffer c,
                           DoubleBuffer b, int ldb, DoubleBuffer x, int ldx,
                           DoubleBuffer rcond, DoubleBuffer ferr, DoubleBuffer berr,
                           DoubleBuffer rpivot );
public static native int LAPACKE_dgesvx( int matrix_layout, @Cast("char") byte fact, @Cast("char") byte trans,
                           int n, int nrhs, double[] a,
                           int lda, double[] af, int ldaf,
                           int[] ipiv, @Cast("char*") byte[] equed, double[] r, double[] c,
                           double[] b, int ldb, double[] x, int ldx,
                           double[] rcond, double[] ferr, double[] berr,
                           double[] rpivot );
public static native int LAPACKE_cgesvx( int matrix_layout, @Cast("char") byte fact, @Cast("char") byte trans,
                           int n, int nrhs,
                           @Cast("lapack_complex_float*") FloatPointer a, int lda,
                           @Cast("lapack_complex_float*") FloatPointer af, int ldaf,
                           IntPointer ipiv, @Cast("char*") BytePointer equed, FloatPointer r, FloatPointer c,
                           @Cast("lapack_complex_float*") FloatPointer b, int ldb,
                           @Cast("lapack_complex_float*") FloatPointer x, int ldx,
                           FloatPointer rcond, FloatPointer ferr, FloatPointer berr,
                           FloatPointer rpivot );
public static native int LAPACKE_cgesvx( int matrix_layout, @Cast("char") byte fact, @Cast("char") byte trans,
                           int n, int nrhs,
                           @Cast("lapack_complex_float*") FloatBuffer a, int lda,
                           @Cast("lapack_complex_float*") FloatBuffer af, int ldaf,
                           IntBuffer ipiv, @Cast("char*") ByteBuffer equed, FloatBuffer r, FloatBuffer c,
                           @Cast("lapack_complex_float*") FloatBuffer b, int ldb,
                           @Cast("lapack_complex_float*") FloatBuffer x, int ldx,
                           FloatBuffer rcond, FloatBuffer ferr, FloatBuffer berr,
                           FloatBuffer rpivot );
public static native int LAPACKE_cgesvx( int matrix_layout, @Cast("char") byte fact, @Cast("char") byte trans,
                           int n, int nrhs,
                           @Cast("lapack_complex_float*") float[] a, int lda,
                           @Cast("lapack_complex_float*") float[] af, int ldaf,
                           int[] ipiv, @Cast("char*") byte[] equed, float[] r, float[] c,
                           @Cast("lapack_complex_float*") float[] b, int ldb,
                           @Cast("lapack_complex_float*") float[] x, int ldx,
                           float[] rcond, float[] ferr, float[] berr,
                           float[] rpivot );
public static native int LAPACKE_zgesvx( int matrix_layout, @Cast("char") byte fact, @Cast("char") byte trans,
                           int n, int nrhs,
                           @Cast("lapack_complex_double*") DoublePointer a, int lda,
                           @Cast("lapack_complex_double*") DoublePointer af, int ldaf,
                           IntPointer ipiv, @Cast("char*") BytePointer equed, DoublePointer r, DoublePointer c,
                           @Cast("lapack_complex_double*") DoublePointer b, int ldb,
                           @Cast("lapack_complex_double*") DoublePointer x, int ldx,
                           DoublePointer rcond, DoublePointer ferr, DoublePointer berr,
                           DoublePointer rpivot );
public static native int LAPACKE_zgesvx( int matrix_layout, @Cast("char") byte fact, @Cast("char") byte trans,
                           int n, int nrhs,
                           @Cast("lapack_complex_double*") DoubleBuffer a, int lda,
                           @Cast("lapack_complex_double*") DoubleBuffer af, int ldaf,
                           IntBuffer ipiv, @Cast("char*") ByteBuffer equed, DoubleBuffer r, DoubleBuffer c,
                           @Cast("lapack_complex_double*") DoubleBuffer b, int ldb,
                           @Cast("lapack_complex_double*") DoubleBuffer x, int ldx,
                           DoubleBuffer rcond, DoubleBuffer ferr, DoubleBuffer berr,
                           DoubleBuffer rpivot );
public static native int LAPACKE_zgesvx( int matrix_layout, @Cast("char") byte fact, @Cast("char") byte trans,
                           int n, int nrhs,
                           @Cast("lapack_complex_double*") double[] a, int lda,
                           @Cast("lapack_complex_double*") double[] af, int ldaf,
                           int[] ipiv, @Cast("char*") byte[] equed, double[] r, double[] c,
                           @Cast("lapack_complex_double*") double[] b, int ldb,
                           @Cast("lapack_complex_double*") double[] x, int ldx,
                           double[] rcond, double[] ferr, double[] berr,
                           double[] rpivot );






public static native int LAPACKE_sgetf2( int matrix_layout, int m, int n,
                           FloatPointer a, int lda, IntPointer ipiv );
public static native int LAPACKE_sgetf2( int matrix_layout, int m, int n,
                           FloatBuffer a, int lda, IntBuffer ipiv );
public static native int LAPACKE_sgetf2( int matrix_layout, int m, int n,
                           float[] a, int lda, int[] ipiv );
public static native int LAPACKE_dgetf2( int matrix_layout, int m, int n,
                           DoublePointer a, int lda, IntPointer ipiv );
public static native int LAPACKE_dgetf2( int matrix_layout, int m, int n,
                           DoubleBuffer a, int lda, IntBuffer ipiv );
public static native int LAPACKE_dgetf2( int matrix_layout, int m, int n,
                           double[] a, int lda, int[] ipiv );
public static native int LAPACKE_cgetf2( int matrix_layout, int m, int n,
                           @Cast("lapack_complex_float*") FloatPointer a, int lda,
                           IntPointer ipiv );
public static native int LAPACKE_cgetf2( int matrix_layout, int m, int n,
                           @Cast("lapack_complex_float*") FloatBuffer a, int lda,
                           IntBuffer ipiv );
public static native int LAPACKE_cgetf2( int matrix_layout, int m, int n,
                           @Cast("lapack_complex_float*") float[] a, int lda,
                           int[] ipiv );
public static native int LAPACKE_zgetf2( int matrix_layout, int m, int n,
                           @Cast("lapack_complex_double*") DoublePointer a, int lda,
                           IntPointer ipiv );
public static native int LAPACKE_zgetf2( int matrix_layout, int m, int n,
                           @Cast("lapack_complex_double*") DoubleBuffer a, int lda,
                           IntBuffer ipiv );
public static native int LAPACKE_zgetf2( int matrix_layout, int m, int n,
                           @Cast("lapack_complex_double*") double[] a, int lda,
                           int[] ipiv );

public static native int LAPACKE_sgetrf( int matrix_layout, int m, int n,
                           FloatPointer a, int lda, IntPointer ipiv );
public static native int LAPACKE_sgetrf( int matrix_layout, int m, int n,
                           FloatBuffer a, int lda, IntBuffer ipiv );
public static native int LAPACKE_sgetrf( int matrix_layout, int m, int n,
                           float[] a, int lda, int[] ipiv );
public static native int LAPACKE_dgetrf( int matrix_layout, int m, int n,
                           DoublePointer a, int lda, IntPointer ipiv );
public static native int LAPACKE_dgetrf( int matrix_layout, int m, int n,
                           DoubleBuffer a, int lda, IntBuffer ipiv );
public static native int LAPACKE_dgetrf( int matrix_layout, int m, int n,
                           double[] a, int lda, int[] ipiv );
public static native int LAPACKE_cgetrf( int matrix_layout, int m, int n,
                           @Cast("lapack_complex_float*") FloatPointer a, int lda,
                           IntPointer ipiv );
public static native int LAPACKE_cgetrf( int matrix_layout, int m, int n,
                           @Cast("lapack_complex_float*") FloatBuffer a, int lda,
                           IntBuffer ipiv );
public static native int LAPACKE_cgetrf( int matrix_layout, int m, int n,
                           @Cast("lapack_complex_float*") float[] a, int lda,
                           int[] ipiv );
public static native int LAPACKE_zgetrf( int matrix_layout, int m, int n,
                           @Cast("lapack_complex_double*") DoublePointer a, int lda,
                           IntPointer ipiv );
public static native int LAPACKE_zgetrf( int matrix_layout, int m, int n,
                           @Cast("lapack_complex_double*") DoubleBuffer a, int lda,
                           IntBuffer ipiv );
public static native int LAPACKE_zgetrf( int matrix_layout, int m, int n,
                           @Cast("lapack_complex_double*") double[] a, int lda,
                           int[] ipiv );

public static native int LAPACKE_sgetrf2( int matrix_layout, int m, int n,
                           FloatPointer a, int lda, IntPointer ipiv );
public static native int LAPACKE_sgetrf2( int matrix_layout, int m, int n,
                           FloatBuffer a, int lda, IntBuffer ipiv );
public static native int LAPACKE_sgetrf2( int matrix_layout, int m, int n,
                           float[] a, int lda, int[] ipiv );
public static native int LAPACKE_dgetrf2( int matrix_layout, int m, int n,
                           DoublePointer a, int lda, IntPointer ipiv );
public static native int LAPACKE_dgetrf2( int matrix_layout, int m, int n,
                           DoubleBuffer a, int lda, IntBuffer ipiv );
public static native int LAPACKE_dgetrf2( int matrix_layout, int m, int n,
                           double[] a, int lda, int[] ipiv );
public static native int LAPACKE_cgetrf2( int matrix_layout, int m, int n,
                           @Cast("lapack_complex_float*") FloatPointer a, int lda,
                           IntPointer ipiv );
public static native int LAPACKE_cgetrf2( int matrix_layout, int m, int n,
                           @Cast("lapack_complex_float*") FloatBuffer a, int lda,
                           IntBuffer ipiv );
public static native int LAPACKE_cgetrf2( int matrix_layout, int m, int n,
                           @Cast("lapack_complex_float*") float[] a, int lda,
                           int[] ipiv );
public static native int LAPACKE_zgetrf2( int matrix_layout, int m, int n,
                           @Cast("lapack_complex_double*") DoublePointer a, int lda,
                           IntPointer ipiv );
public static native int LAPACKE_zgetrf2( int matrix_layout, int m, int n,
                           @Cast("lapack_complex_double*") DoubleBuffer a, int lda,
                           IntBuffer ipiv );
public static native int LAPACKE_zgetrf2( int matrix_layout, int m, int n,
                           @Cast("lapack_complex_double*") double[] a, int lda,
                           int[] ipiv );

public static native int LAPACKE_sgetri( int matrix_layout, int n, FloatPointer a,
                           int lda, @Const IntPointer ipiv );
public static native int LAPACKE_sgetri( int matrix_layout, int n, FloatBuffer a,
                           int lda, @Const IntBuffer ipiv );
public static native int LAPACKE_sgetri( int matrix_layout, int n, float[] a,
                           int lda, @Const int[] ipiv );
public static native int LAPACKE_dgetri( int matrix_layout, int n, DoublePointer a,
                           int lda, @Const IntPointer ipiv );
public static native int LAPACKE_dgetri( int matrix_layout, int n, DoubleBuffer a,
                           int lda, @Const IntBuffer ipiv );
public static native int LAPACKE_dgetri( int matrix_layout, int n, double[] a,
                           int lda, @Const int[] ipiv );
public static native int LAPACKE_cgetri( int matrix_layout, int n,
                           @Cast("lapack_complex_float*") FloatPointer a, int lda,
                           @Const IntPointer ipiv );
public static native int LAPACKE_cgetri( int matrix_layout, int n,
                           @Cast("lapack_complex_float*") FloatBuffer a, int lda,
                           @Const IntBuffer ipiv );
public static native int LAPACKE_cgetri( int matrix_layout, int n,
                           @Cast("lapack_complex_float*") float[] a, int lda,
                           @Const int[] ipiv );
public static native int LAPACKE_zgetri( int matrix_layout, int n,
                           @Cast("lapack_complex_double*") DoublePointer a, int lda,
                           @Const IntPointer ipiv );
public static native int LAPACKE_zgetri( int matrix_layout, int n,
                           @Cast("lapack_complex_double*") DoubleBuffer a, int lda,
                           @Const IntBuffer ipiv );
public static native int LAPACKE_zgetri( int matrix_layout, int n,
                           @Cast("lapack_complex_double*") double[] a, int lda,
                           @Const int[] ipiv );

public static native int LAPACKE_sgetrs( int matrix_layout, @Cast("char") byte trans, int n,
                           int nrhs, @Const FloatPointer a, int lda,
                           @Const IntPointer ipiv, FloatPointer b, int ldb );
public static native int LAPACKE_sgetrs( int matrix_layout, @Cast("char") byte trans, int n,
                           int nrhs, @Const FloatBuffer a, int lda,
                           @Const IntBuffer ipiv, FloatBuffer b, int ldb );
public static native int LAPACKE_sgetrs( int matrix_layout, @Cast("char") byte trans, int n,
                           int nrhs, @Const float[] a, int lda,
                           @Const int[] ipiv, float[] b, int ldb );
public static native int LAPACKE_dgetrs( int matrix_layout, @Cast("char") byte trans, int n,
                           int nrhs, @Const DoublePointer a, int lda,
                           @Const IntPointer ipiv, DoublePointer b, int ldb );
public static native int LAPACKE_dgetrs( int matrix_layout, @Cast("char") byte trans, int n,
                           int nrhs, @Const DoubleBuffer a, int lda,
                           @Const IntBuffer ipiv, DoubleBuffer b, int ldb );
public static native int LAPACKE_dgetrs( int matrix_layout, @Cast("char") byte trans, int n,
                           int nrhs, @Const double[] a, int lda,
                           @Const int[] ipiv, double[] b, int ldb );
public static native int LAPACKE_cgetrs( int matrix_layout, @Cast("char") byte trans, int n,
                           int nrhs, @Cast("const lapack_complex_float*") FloatPointer a,
                           int lda, @Const IntPointer ipiv,
                           @Cast("lapack_complex_float*") FloatPointer b, int ldb );
public static native int LAPACKE_cgetrs( int matrix_layout, @Cast("char") byte trans, int n,
                           int nrhs, @Cast("const lapack_complex_float*") FloatBuffer a,
                           int lda, @Const IntBuffer ipiv,
                           @Cast("lapack_complex_float*") FloatBuffer b, int ldb );
public static native int LAPACKE_cgetrs( int matrix_layout, @Cast("char") byte trans, int n,
                           int nrhs, @Cast("const lapack_complex_float*") float[] a,
                           int lda, @Const int[] ipiv,
                           @Cast("lapack_complex_float*") float[] b, int ldb );
public static native int LAPACKE_zgetrs( int matrix_layout, @Cast("char") byte trans, int n,
                           int nrhs, @Cast("const lapack_complex_double*") DoublePointer a,
                           int lda, @Const IntPointer ipiv,
                           @Cast("lapack_complex_double*") DoublePointer b, int ldb );
public static native int LAPACKE_zgetrs( int matrix_layout, @Cast("char") byte trans, int n,
                           int nrhs, @Cast("const lapack_complex_double*") DoubleBuffer a,
                           int lda, @Const IntBuffer ipiv,
                           @Cast("lapack_complex_double*") DoubleBuffer b, int ldb );
public static native int LAPACKE_zgetrs( int matrix_layout, @Cast("char") byte trans, int n,
                           int nrhs, @Cast("const lapack_complex_double*") double[] a,
                           int lda, @Const int[] ipiv,
                           @Cast("lapack_complex_double*") double[] b, int ldb );

public static native int LAPACKE_sggbak( int matrix_layout, @Cast("char") byte job, @Cast("char") byte side, int n,
                           int ilo, int ihi, @Const FloatPointer lscale,
                           @Const FloatPointer rscale, int m, FloatPointer v,
                           int ldv );
public static native int LAPACKE_sggbak( int matrix_layout, @Cast("char") byte job, @Cast("char") byte side, int n,
                           int ilo, int ihi, @Const FloatBuffer lscale,
                           @Const FloatBuffer rscale, int m, FloatBuffer v,
                           int ldv );
public static native int LAPACKE_sggbak( int matrix_layout, @Cast("char") byte job, @Cast("char") byte side, int n,
                           int ilo, int ihi, @Const float[] lscale,
                           @Const float[] rscale, int m, float[] v,
                           int ldv );
public static native int LAPACKE_dggbak( int matrix_layout, @Cast("char") byte job, @Cast("char") byte side, int n,
                           int ilo, int ihi, @Const DoublePointer lscale,
                           @Const DoublePointer rscale, int m, DoublePointer v,
                           int ldv );
public static native int LAPACKE_dggbak( int matrix_layout, @Cast("char") byte job, @Cast("char") byte side, int n,
                           int ilo, int ihi, @Const DoubleBuffer lscale,
                           @Const DoubleBuffer rscale, int m, DoubleBuffer v,
                           int ldv );
public static native int LAPACKE_dggbak( int matrix_layout, @Cast("char") byte job, @Cast("char") byte side, int n,
                           int ilo, int ihi, @Const double[] lscale,
                           @Const double[] rscale, int m, double[] v,
                           int ldv );
public static native int LAPACKE_cggbak( int matrix_layout, @Cast("char") byte job, @Cast("char") byte side, int n,
                           int ilo, int ihi, @Const FloatPointer lscale,
                           @Const FloatPointer rscale, int m,
                           @Cast("lapack_complex_float*") FloatPointer v, int ldv );
public static native int LAPACKE_cggbak( int matrix_layout, @Cast("char") byte job, @Cast("char") byte side, int n,
                           int ilo, int ihi, @Const FloatBuffer lscale,
                           @Const FloatBuffer rscale, int m,
                           @Cast("lapack_complex_float*") FloatBuffer v, int ldv );
public static native int LAPACKE_cggbak( int matrix_layout, @Cast("char") byte job, @Cast("char") byte side, int n,
                           int ilo, int ihi, @Const float[] lscale,
                           @Const float[] rscale, int m,
                           @Cast("lapack_complex_float*") float[] v, int ldv );
public static native int LAPACKE_zggbak( int matrix_layout, @Cast("char") byte job, @Cast("char") byte side, int n,
                           int ilo, int ihi, @Const DoublePointer lscale,
                           @Const DoublePointer rscale, int m,
                           @Cast("lapack_complex_double*") DoublePointer v, int ldv );
public static native int LAPACKE_zggbak( int matrix_layout, @Cast("char") byte job, @Cast("char") byte side, int n,
                           int ilo, int ihi, @Const DoubleBuffer lscale,
                           @Const DoubleBuffer rscale, int m,
                           @Cast("lapack_complex_double*") DoubleBuffer v, int ldv );
public static native int LAPACKE_zggbak( int matrix_layout, @Cast("char") byte job, @Cast("char") byte side, int n,
                           int ilo, int ihi, @Const double[] lscale,
                           @Const double[] rscale, int m,
                           @Cast("lapack_complex_double*") double[] v, int ldv );

public static native int LAPACKE_sggbal( int matrix_layout, @Cast("char") byte job, int n, FloatPointer a,
                           int lda, FloatPointer b, int ldb,
                           IntPointer ilo, IntPointer ihi, FloatPointer lscale,
                           FloatPointer rscale );
public static native int LAPACKE_sggbal( int matrix_layout, @Cast("char") byte job, int n, FloatBuffer a,
                           int lda, FloatBuffer b, int ldb,
                           IntBuffer ilo, IntBuffer ihi, FloatBuffer lscale,
                           FloatBuffer rscale );
public static native int LAPACKE_sggbal( int matrix_layout, @Cast("char") byte job, int n, float[] a,
                           int lda, float[] b, int ldb,
                           int[] ilo, int[] ihi, float[] lscale,
                           float[] rscale );
public static native int LAPACKE_dggbal( int matrix_layout, @Cast("char") byte job, int n, DoublePointer a,
                           int lda, DoublePointer b, int ldb,
                           IntPointer ilo, IntPointer ihi, DoublePointer lscale,
                           DoublePointer rscale );
public static native int LAPACKE_dggbal( int matrix_layout, @Cast("char") byte job, int n, DoubleBuffer a,
                           int lda, DoubleBuffer b, int ldb,
                           IntBuffer ilo, IntBuffer ihi, DoubleBuffer lscale,
                           DoubleBuffer rscale );
public static native int LAPACKE_dggbal( int matrix_layout, @Cast("char") byte job, int n, double[] a,
                           int lda, double[] b, int ldb,
                           int[] ilo, int[] ihi, double[] lscale,
                           double[] rscale );
public static native int LAPACKE_cggbal( int matrix_layout, @Cast("char") byte job, int n,
                           @Cast("lapack_complex_float*") FloatPointer a, int lda,
                           @Cast("lapack_complex_float*") FloatPointer b, int ldb,
                           IntPointer ilo, IntPointer ihi, FloatPointer lscale,
                           FloatPointer rscale );
public static native int LAPACKE_cggbal( int matrix_layout, @Cast("char") byte job, int n,
                           @Cast("lapack_complex_float*") FloatBuffer a, int lda,
                           @Cast("lapack_complex_float*") FloatBuffer b, int ldb,
                           IntBuffer ilo, IntBuffer ihi, FloatBuffer lscale,
                           FloatBuffer rscale );
public static native int LAPACKE_cggbal( int matrix_layout, @Cast("char") byte job, int n,
                           @Cast("lapack_complex_float*") float[] a, int lda,
                           @Cast("lapack_complex_float*") float[] b, int ldb,
                           int[] ilo, int[] ihi, float[] lscale,
                           float[] rscale );
public static native int LAPACKE_zggbal( int matrix_layout, @Cast("char") byte job, int n,
                           @Cast("lapack_complex_double*") DoublePointer a, int lda,
                           @Cast("lapack_complex_double*") DoublePointer b, int ldb,
                           IntPointer ilo, IntPointer ihi, DoublePointer lscale,
                           DoublePointer rscale );
public static native int LAPACKE_zggbal( int matrix_layout, @Cast("char") byte job, int n,
                           @Cast("lapack_complex_double*") DoubleBuffer a, int lda,
                           @Cast("lapack_complex_double*") DoubleBuffer b, int ldb,
                           IntBuffer ilo, IntBuffer ihi, DoubleBuffer lscale,
                           DoubleBuffer rscale );
public static native int LAPACKE_zggbal( int matrix_layout, @Cast("char") byte job, int n,
                           @Cast("lapack_complex_double*") double[] a, int lda,
                           @Cast("lapack_complex_double*") double[] b, int ldb,
                           int[] ilo, int[] ihi, double[] lscale,
                           double[] rscale );

public static native int LAPACKE_sgges( int matrix_layout, @Cast("char") byte jobvsl, @Cast("char") byte jobvsr, @Cast("char") byte sort,
                          LAPACK_S_SELECT3 selctg, int n, FloatPointer a,
                          int lda, FloatPointer b, int ldb,
                          IntPointer sdim, FloatPointer alphar, FloatPointer alphai,
                          FloatPointer beta, FloatPointer vsl, int ldvsl, FloatPointer vsr,
                          int ldvsr );
public static native int LAPACKE_sgges( int matrix_layout, @Cast("char") byte jobvsl, @Cast("char") byte jobvsr, @Cast("char") byte sort,
                          LAPACK_S_SELECT3 selctg, int n, FloatBuffer a,
                          int lda, FloatBuffer b, int ldb,
                          IntBuffer sdim, FloatBuffer alphar, FloatBuffer alphai,
                          FloatBuffer beta, FloatBuffer vsl, int ldvsl, FloatBuffer vsr,
                          int ldvsr );
public static native int LAPACKE_sgges( int matrix_layout, @Cast("char") byte jobvsl, @Cast("char") byte jobvsr, @Cast("char") byte sort,
                          LAPACK_S_SELECT3 selctg, int n, float[] a,
                          int lda, float[] b, int ldb,
                          int[] sdim, float[] alphar, float[] alphai,
                          float[] beta, float[] vsl, int ldvsl, float[] vsr,
                          int ldvsr );
public static native int LAPACKE_dgges( int matrix_layout, @Cast("char") byte jobvsl, @Cast("char") byte jobvsr, @Cast("char") byte sort,
                          LAPACK_D_SELECT3 selctg, int n, DoublePointer a,
                          int lda, DoublePointer b, int ldb,
                          IntPointer sdim, DoublePointer alphar, DoublePointer alphai,
                          DoublePointer beta, DoublePointer vsl, int ldvsl,
                          DoublePointer vsr, int ldvsr );
public static native int LAPACKE_dgges( int matrix_layout, @Cast("char") byte jobvsl, @Cast("char") byte jobvsr, @Cast("char") byte sort,
                          LAPACK_D_SELECT3 selctg, int n, DoubleBuffer a,
                          int lda, DoubleBuffer b, int ldb,
                          IntBuffer sdim, DoubleBuffer alphar, DoubleBuffer alphai,
                          DoubleBuffer beta, DoubleBuffer vsl, int ldvsl,
                          DoubleBuffer vsr, int ldvsr );
public static native int LAPACKE_dgges( int matrix_layout, @Cast("char") byte jobvsl, @Cast("char") byte jobvsr, @Cast("char") byte sort,
                          LAPACK_D_SELECT3 selctg, int n, double[] a,
                          int lda, double[] b, int ldb,
                          int[] sdim, double[] alphar, double[] alphai,
                          double[] beta, double[] vsl, int ldvsl,
                          double[] vsr, int ldvsr );
public static native int LAPACKE_cgges( int matrix_layout, @Cast("char") byte jobvsl, @Cast("char") byte jobvsr, @Cast("char") byte sort,
                          LAPACK_C_SELECT2 selctg, int n,
                          @Cast("lapack_complex_float*") FloatPointer a, int lda,
                          @Cast("lapack_complex_float*") FloatPointer b, int ldb,
                          IntPointer sdim, @Cast("lapack_complex_float*") FloatPointer alpha,
                          @Cast("lapack_complex_float*") FloatPointer beta, @Cast("lapack_complex_float*") FloatPointer vsl,
                          int ldvsl, @Cast("lapack_complex_float*") FloatPointer vsr,
                          int ldvsr );
public static native int LAPACKE_cgges( int matrix_layout, @Cast("char") byte jobvsl, @Cast("char") byte jobvsr, @Cast("char") byte sort,
                          LAPACK_C_SELECT2 selctg, int n,
                          @Cast("lapack_complex_float*") FloatBuffer a, int lda,
                          @Cast("lapack_complex_float*") FloatBuffer b, int ldb,
                          IntBuffer sdim, @Cast("lapack_complex_float*") FloatBuffer alpha,
                          @Cast("lapack_complex_float*") FloatBuffer beta, @Cast("lapack_complex_float*") FloatBuffer vsl,
                          int ldvsl, @Cast("lapack_complex_float*") FloatBuffer vsr,
                          int ldvsr );
public static native int LAPACKE_cgges( int matrix_layout, @Cast("char") byte jobvsl, @Cast("char") byte jobvsr, @Cast("char") byte sort,
                          LAPACK_C_SELECT2 selctg, int n,
                          @Cast("lapack_complex_float*") float[] a, int lda,
                          @Cast("lapack_complex_float*") float[] b, int ldb,
                          int[] sdim, @Cast("lapack_complex_float*") float[] alpha,
                          @Cast("lapack_complex_float*") float[] beta, @Cast("lapack_complex_float*") float[] vsl,
                          int ldvsl, @Cast("lapack_complex_float*") float[] vsr,
                          int ldvsr );
public static native int LAPACKE_zgges( int matrix_layout, @Cast("char") byte jobvsl, @Cast("char") byte jobvsr, @Cast("char") byte sort,
                          LAPACK_Z_SELECT2 selctg, int n,
                          @Cast("lapack_complex_double*") DoublePointer a, int lda,
                          @Cast("lapack_complex_double*") DoublePointer b, int ldb,
                          IntPointer sdim, @Cast("lapack_complex_double*") DoublePointer alpha,
                          @Cast("lapack_complex_double*") DoublePointer beta,
                          @Cast("lapack_complex_double*") DoublePointer vsl, int ldvsl,
                          @Cast("lapack_complex_double*") DoublePointer vsr, int ldvsr );
public static native int LAPACKE_zgges( int matrix_layout, @Cast("char") byte jobvsl, @Cast("char") byte jobvsr, @Cast("char") byte sort,
                          LAPACK_Z_SELECT2 selctg, int n,
                          @Cast("lapack_complex_double*") DoubleBuffer a, int lda,
                          @Cast("lapack_complex_double*") DoubleBuffer b, int ldb,
                          IntBuffer sdim, @Cast("lapack_complex_double*") DoubleBuffer alpha,
                          @Cast("lapack_complex_double*") DoubleBuffer beta,
                          @Cast("lapack_complex_double*") DoubleBuffer vsl, int ldvsl,
                          @Cast("lapack_complex_double*") DoubleBuffer vsr, int ldvsr );
public static native int LAPACKE_zgges( int matrix_layout, @Cast("char") byte jobvsl, @Cast("char") byte jobvsr, @Cast("char") byte sort,
                          LAPACK_Z_SELECT2 selctg, int n,
                          @Cast("lapack_complex_double*") double[] a, int lda,
                          @Cast("lapack_complex_double*") double[] b, int ldb,
                          int[] sdim, @Cast("lapack_complex_double*") double[] alpha,
                          @Cast("lapack_complex_double*") double[] beta,
                          @Cast("lapack_complex_double*") double[] vsl, int ldvsl,
                          @Cast("lapack_complex_double*") double[] vsr, int ldvsr );

public static native int LAPACKE_sgges3( int matrix_layout, @Cast("char") byte jobvsl, @Cast("char") byte jobvsr,
                           @Cast("char") byte sort, LAPACK_S_SELECT3 selctg, int n,
                           FloatPointer a, int lda, FloatPointer b, int ldb,
                           IntPointer sdim, FloatPointer alphar, FloatPointer alphai,
                           FloatPointer beta, FloatPointer vsl, int ldvsl,
                           FloatPointer vsr, int ldvsr );
public static native int LAPACKE_sgges3( int matrix_layout, @Cast("char") byte jobvsl, @Cast("char") byte jobvsr,
                           @Cast("char") byte sort, LAPACK_S_SELECT3 selctg, int n,
                           FloatBuffer a, int lda, FloatBuffer b, int ldb,
                           IntBuffer sdim, FloatBuffer alphar, FloatBuffer alphai,
                           FloatBuffer beta, FloatBuffer vsl, int ldvsl,
                           FloatBuffer vsr, int ldvsr );
public static native int LAPACKE_sgges3( int matrix_layout, @Cast("char") byte jobvsl, @Cast("char") byte jobvsr,
                           @Cast("char") byte sort, LAPACK_S_SELECT3 selctg, int n,
                           float[] a, int lda, float[] b, int ldb,
                           int[] sdim, float[] alphar, float[] alphai,
                           float[] beta, float[] vsl, int ldvsl,
                           float[] vsr, int ldvsr );
public static native int LAPACKE_dgges3( int matrix_layout, @Cast("char") byte jobvsl, @Cast("char") byte jobvsr,
                           @Cast("char") byte sort, LAPACK_D_SELECT3 selctg, int n,
                           DoublePointer a, int lda, DoublePointer b, int ldb,
                           IntPointer sdim, DoublePointer alphar, DoublePointer alphai,
                           DoublePointer beta, DoublePointer vsl, int ldvsl,
                           DoublePointer vsr, int ldvsr );
public static native int LAPACKE_dgges3( int matrix_layout, @Cast("char") byte jobvsl, @Cast("char") byte jobvsr,
                           @Cast("char") byte sort, LAPACK_D_SELECT3 selctg, int n,
                           DoubleBuffer a, int lda, DoubleBuffer b, int ldb,
                           IntBuffer sdim, DoubleBuffer alphar, DoubleBuffer alphai,
                           DoubleBuffer beta, DoubleBuffer vsl, int ldvsl,
                           DoubleBuffer vsr, int ldvsr );
public static native int LAPACKE_dgges3( int matrix_layout, @Cast("char") byte jobvsl, @Cast("char") byte jobvsr,
                           @Cast("char") byte sort, LAPACK_D_SELECT3 selctg, int n,
                           double[] a, int lda, double[] b, int ldb,
                           int[] sdim, double[] alphar, double[] alphai,
                           double[] beta, double[] vsl, int ldvsl,
                           double[] vsr, int ldvsr );
public static native int LAPACKE_cgges3( int matrix_layout, @Cast("char") byte jobvsl, @Cast("char") byte jobvsr,
                           @Cast("char") byte sort, LAPACK_C_SELECT2 selctg, int n,
                           @Cast("lapack_complex_float*") FloatPointer a, int lda,
                           @Cast("lapack_complex_float*") FloatPointer b, int ldb,
                           IntPointer sdim, @Cast("lapack_complex_float*") FloatPointer alpha,
                           @Cast("lapack_complex_float*") FloatPointer beta,
                           @Cast("lapack_complex_float*") FloatPointer vsl, int ldvsl,
                           @Cast("lapack_complex_float*") FloatPointer vsr, int ldvsr );
public static native int LAPACKE_cgges3( int matrix_layout, @Cast("char") byte jobvsl, @Cast("char") byte jobvsr,
                           @Cast("char") byte sort, LAPACK_C_SELECT2 selctg, int n,
                           @Cast("lapack_complex_float*") FloatBuffer a, int lda,
                           @Cast("lapack_complex_float*") FloatBuffer b, int ldb,
                           IntBuffer sdim, @Cast("lapack_complex_float*") FloatBuffer alpha,
                           @Cast("lapack_complex_float*") FloatBuffer beta,
                           @Cast("lapack_complex_float*") FloatBuffer vsl, int ldvsl,
                           @Cast("lapack_complex_float*") FloatBuffer vsr, int ldvsr );
public static native int LAPACKE_cgges3( int matrix_layout, @Cast("char") byte jobvsl, @Cast("char") byte jobvsr,
                           @Cast("char") byte sort, LAPACK_C_SELECT2 selctg, int n,
                           @Cast("lapack_complex_float*") float[] a, int lda,
                           @Cast("lapack_complex_float*") float[] b, int ldb,
                           int[] sdim, @Cast("lapack_complex_float*") float[] alpha,
                           @Cast("lapack_complex_float*") float[] beta,
                           @Cast("lapack_complex_float*") float[] vsl, int ldvsl,
                           @Cast("lapack_complex_float*") float[] vsr, int ldvsr );
public static native int LAPACKE_zgges3( int matrix_layout, @Cast("char") byte jobvsl, @Cast("char") byte jobvsr,
                           @Cast("char") byte sort, LAPACK_Z_SELECT2 selctg, int n,
                           @Cast("lapack_complex_double*") DoublePointer a, int lda,
                           @Cast("lapack_complex_double*") DoublePointer b, int ldb,
                           IntPointer sdim, @Cast("lapack_complex_double*") DoublePointer alpha,
                           @Cast("lapack_complex_double*") DoublePointer beta,
                           @Cast("lapack_complex_double*") DoublePointer vsl, int ldvsl,
                           @Cast("lapack_complex_double*") DoublePointer vsr, int ldvsr );
public static native int LAPACKE_zgges3( int matrix_layout, @Cast("char") byte jobvsl, @Cast("char") byte jobvsr,
                           @Cast("char") byte sort, LAPACK_Z_SELECT2 selctg, int n,
                           @Cast("lapack_complex_double*") DoubleBuffer a, int lda,
                           @Cast("lapack_complex_double*") DoubleBuffer b, int ldb,
                           IntBuffer sdim, @Cast("lapack_complex_double*") DoubleBuffer alpha,
                           @Cast("lapack_complex_double*") DoubleBuffer beta,
                           @Cast("lapack_complex_double*") DoubleBuffer vsl, int ldvsl,
                           @Cast("lapack_complex_double*") DoubleBuffer vsr, int ldvsr );
public static native int LAPACKE_zgges3( int matrix_layout, @Cast("char") byte jobvsl, @Cast("char") byte jobvsr,
                           @Cast("char") byte sort, LAPACK_Z_SELECT2 selctg, int n,
                           @Cast("lapack_complex_double*") double[] a, int lda,
                           @Cast("lapack_complex_double*") double[] b, int ldb,
                           int[] sdim, @Cast("lapack_complex_double*") double[] alpha,
                           @Cast("lapack_complex_double*") double[] beta,
                           @Cast("lapack_complex_double*") double[] vsl, int ldvsl,
                           @Cast("lapack_complex_double*") double[] vsr, int ldvsr );

public static native int LAPACKE_sggesx( int matrix_layout, @Cast("char") byte jobvsl, @Cast("char") byte jobvsr,
                           @Cast("char") byte sort, LAPACK_S_SELECT3 selctg, @Cast("char") byte sense,
                           int n, FloatPointer a, int lda, FloatPointer b,
                           int ldb, IntPointer sdim, FloatPointer alphar,
                           FloatPointer alphai, FloatPointer beta, FloatPointer vsl,
                           int ldvsl, FloatPointer vsr, int ldvsr,
                           FloatPointer rconde, FloatPointer rcondv );
public static native int LAPACKE_sggesx( int matrix_layout, @Cast("char") byte jobvsl, @Cast("char") byte jobvsr,
                           @Cast("char") byte sort, LAPACK_S_SELECT3 selctg, @Cast("char") byte sense,
                           int n, FloatBuffer a, int lda, FloatBuffer b,
                           int ldb, IntBuffer sdim, FloatBuffer alphar,
                           FloatBuffer alphai, FloatBuffer beta, FloatBuffer vsl,
                           int ldvsl, FloatBuffer vsr, int ldvsr,
                           FloatBuffer rconde, FloatBuffer rcondv );
public static native int LAPACKE_sggesx( int matrix_layout, @Cast("char") byte jobvsl, @Cast("char") byte jobvsr,
                           @Cast("char") byte sort, LAPACK_S_SELECT3 selctg, @Cast("char") byte sense,
                           int n, float[] a, int lda, float[] b,
                           int ldb, int[] sdim, float[] alphar,
                           float[] alphai, float[] beta, float[] vsl,
                           int ldvsl, float[] vsr, int ldvsr,
                           float[] rconde, float[] rcondv );
public static native int LAPACKE_dggesx( int matrix_layout, @Cast("char") byte jobvsl, @Cast("char") byte jobvsr,
                           @Cast("char") byte sort, LAPACK_D_SELECT3 selctg, @Cast("char") byte sense,
                           int n, DoublePointer a, int lda, DoublePointer b,
                           int ldb, IntPointer sdim, DoublePointer alphar,
                           DoublePointer alphai, DoublePointer beta, DoublePointer vsl,
                           int ldvsl, DoublePointer vsr, int ldvsr,
                           DoublePointer rconde, DoublePointer rcondv );
public static native int LAPACKE_dggesx( int matrix_layout, @Cast("char") byte jobvsl, @Cast("char") byte jobvsr,
                           @Cast("char") byte sort, LAPACK_D_SELECT3 selctg, @Cast("char") byte sense,
                           int n, DoubleBuffer a, int lda, DoubleBuffer b,
                           int ldb, IntBuffer sdim, DoubleBuffer alphar,
                           DoubleBuffer alphai, DoubleBuffer beta, DoubleBuffer vsl,
                           int ldvsl, DoubleBuffer vsr, int ldvsr,
                           DoubleBuffer rconde, DoubleBuffer rcondv );
public static native int LAPACKE_dggesx( int matrix_layout, @Cast("char") byte jobvsl, @Cast("char") byte jobvsr,
                           @Cast("char") byte sort, LAPACK_D_SELECT3 selctg, @Cast("char") byte sense,
                           int n, double[] a, int lda, double[] b,
                           int ldb, int[] sdim, double[] alphar,
                           double[] alphai, double[] beta, double[] vsl,
                           int ldvsl, double[] vsr, int ldvsr,
                           double[] rconde, double[] rcondv );
public static native int LAPACKE_cggesx( int matrix_layout, @Cast("char") byte jobvsl, @Cast("char") byte jobvsr,
                           @Cast("char") byte sort, LAPACK_C_SELECT2 selctg, @Cast("char") byte sense,
                           int n, @Cast("lapack_complex_float*") FloatPointer a,
                           int lda, @Cast("lapack_complex_float*") FloatPointer b,
                           int ldb, IntPointer sdim,
                           @Cast("lapack_complex_float*") FloatPointer alpha,
                           @Cast("lapack_complex_float*") FloatPointer beta,
                           @Cast("lapack_complex_float*") FloatPointer vsl, int ldvsl,
                           @Cast("lapack_complex_float*") FloatPointer vsr, int ldvsr,
                           FloatPointer rconde, FloatPointer rcondv );
public static native int LAPACKE_cggesx( int matrix_layout, @Cast("char") byte jobvsl, @Cast("char") byte jobvsr,
                           @Cast("char") byte sort, LAPACK_C_SELECT2 selctg, @Cast("char") byte sense,
                           int n, @Cast("lapack_complex_float*") FloatBuffer a,
                           int lda, @Cast("lapack_complex_float*") FloatBuffer b,
                           int ldb, IntBuffer sdim,
                           @Cast("lapack_complex_float*") FloatBuffer alpha,
                           @Cast("lapack_complex_float*") FloatBuffer beta,
                           @Cast("lapack_complex_float*") FloatBuffer vsl, int ldvsl,
                           @Cast("lapack_complex_float*") FloatBuffer vsr, int ldvsr,
                           FloatBuffer rconde, FloatBuffer rcondv );
public static native int LAPACKE_cggesx( int matrix_layout, @Cast("char") byte jobvsl, @Cast("char") byte jobvsr,
                           @Cast("char") byte sort, LAPACK_C_SELECT2 selctg, @Cast("char") byte sense,
                           int n, @Cast("lapack_complex_float*") float[] a,
                           int lda, @Cast("lapack_complex_float*") float[] b,
                           int ldb, int[] sdim,
                           @Cast("lapack_complex_float*") float[] alpha,
                           @Cast("lapack_complex_float*") float[] beta,
                           @Cast("lapack_complex_float*") float[] vsl, int ldvsl,
                           @Cast("lapack_complex_float*") float[] vsr, int ldvsr,
                           float[] rconde, float[] rcondv );
public static native int LAPACKE_zggesx( int matrix_layout, @Cast("char") byte jobvsl, @Cast("char") byte jobvsr,
                           @Cast("char") byte sort, LAPACK_Z_SELECT2 selctg, @Cast("char") byte sense,
                           int n, @Cast("lapack_complex_double*") DoublePointer a,
                           int lda, @Cast("lapack_complex_double*") DoublePointer b,
                           int ldb, IntPointer sdim,
                           @Cast("lapack_complex_double*") DoublePointer alpha,
                           @Cast("lapack_complex_double*") DoublePointer beta,
                           @Cast("lapack_complex_double*") DoublePointer vsl, int ldvsl,
                           @Cast("lapack_complex_double*") DoublePointer vsr, int ldvsr,
                           DoublePointer rconde, DoublePointer rcondv );
public static native int LAPACKE_zggesx( int matrix_layout, @Cast("char") byte jobvsl, @Cast("char") byte jobvsr,
                           @Cast("char") byte sort, LAPACK_Z_SELECT2 selctg, @Cast("char") byte sense,
                           int n, @Cast("lapack_complex_double*") DoubleBuffer a,
                           int lda, @Cast("lapack_complex_double*") DoubleBuffer b,
                           int ldb, IntBuffer sdim,
                           @Cast("lapack_complex_double*") DoubleBuffer alpha,
                           @Cast("lapack_complex_double*") DoubleBuffer beta,
                           @Cast("lapack_complex_double*") DoubleBuffer vsl, int ldvsl,
                           @Cast("lapack_complex_double*") DoubleBuffer vsr, int ldvsr,
                           DoubleBuffer rconde, DoubleBuffer rcondv );
public static native int LAPACKE_zggesx( int matrix_layout, @Cast("char") byte jobvsl, @Cast("char") byte jobvsr,
                           @Cast("char") byte sort, LAPACK_Z_SELECT2 selctg, @Cast("char") byte sense,
                           int n, @Cast("lapack_complex_double*") double[] a,
                           int lda, @Cast("lapack_complex_double*") double[] b,
                           int ldb, int[] sdim,
                           @Cast("lapack_complex_double*") double[] alpha,
                           @Cast("lapack_complex_double*") double[] beta,
                           @Cast("lapack_complex_double*") double[] vsl, int ldvsl,
                           @Cast("lapack_complex_double*") double[] vsr, int ldvsr,
                           double[] rconde, double[] rcondv );

public static native int LAPACKE_sggev( int matrix_layout, @Cast("char") byte jobvl, @Cast("char") byte jobvr,
                          int n, FloatPointer a, int lda, FloatPointer b,
                          int ldb, FloatPointer alphar, FloatPointer alphai,
                          FloatPointer beta, FloatPointer vl, int ldvl, FloatPointer vr,
                          int ldvr );
public static native int LAPACKE_sggev( int matrix_layout, @Cast("char") byte jobvl, @Cast("char") byte jobvr,
                          int n, FloatBuffer a, int lda, FloatBuffer b,
                          int ldb, FloatBuffer alphar, FloatBuffer alphai,
                          FloatBuffer beta, FloatBuffer vl, int ldvl, FloatBuffer vr,
                          int ldvr );
public static native int LAPACKE_sggev( int matrix_layout, @Cast("char") byte jobvl, @Cast("char") byte jobvr,
                          int n, float[] a, int lda, float[] b,
                          int ldb, float[] alphar, float[] alphai,
                          float[] beta, float[] vl, int ldvl, float[] vr,
                          int ldvr );
public static native int LAPACKE_dggev( int matrix_layout, @Cast("char") byte jobvl, @Cast("char") byte jobvr,
                          int n, DoublePointer a, int lda, DoublePointer b,
                          int ldb, DoublePointer alphar, DoublePointer alphai,
                          DoublePointer beta, DoublePointer vl, int ldvl, DoublePointer vr,
                          int ldvr );
public static native int LAPACKE_dggev( int matrix_layout, @Cast("char") byte jobvl, @Cast("char") byte jobvr,
                          int n, DoubleBuffer a, int lda, DoubleBuffer b,
                          int ldb, DoubleBuffer alphar, DoubleBuffer alphai,
                          DoubleBuffer beta, DoubleBuffer vl, int ldvl, DoubleBuffer vr,
                          int ldvr );
public static native int LAPACKE_dggev( int matrix_layout, @Cast("char") byte jobvl, @Cast("char") byte jobvr,
                          int n, double[] a, int lda, double[] b,
                          int ldb, double[] alphar, double[] alphai,
                          double[] beta, double[] vl, int ldvl, double[] vr,
                          int ldvr );
public static native int LAPACKE_cggev( int matrix_layout, @Cast("char") byte jobvl, @Cast("char") byte jobvr,
                          int n, @Cast("lapack_complex_float*") FloatPointer a, int lda,
                          @Cast("lapack_complex_float*") FloatPointer b, int ldb,
                          @Cast("lapack_complex_float*") FloatPointer alpha,
                          @Cast("lapack_complex_float*") FloatPointer beta, @Cast("lapack_complex_float*") FloatPointer vl,
                          int ldvl, @Cast("lapack_complex_float*") FloatPointer vr,
                          int ldvr );
public static native int LAPACKE_cggev( int matrix_layout, @Cast("char") byte jobvl, @Cast("char") byte jobvr,
                          int n, @Cast("lapack_complex_float*") FloatBuffer a, int lda,
                          @Cast("lapack_complex_float*") FloatBuffer b, int ldb,
                          @Cast("lapack_complex_float*") FloatBuffer alpha,
                          @Cast("lapack_complex_float*") FloatBuffer beta, @Cast("lapack_complex_float*") FloatBuffer vl,
                          int ldvl, @Cast("lapack_complex_float*") FloatBuffer vr,
                          int ldvr );
public static native int LAPACKE_cggev( int matrix_layout, @Cast("char") byte jobvl, @Cast("char") byte jobvr,
                          int n, @Cast("lapack_complex_float*") float[] a, int lda,
                          @Cast("lapack_complex_float*") float[] b, int ldb,
                          @Cast("lapack_complex_float*") float[] alpha,
                          @Cast("lapack_complex_float*") float[] beta, @Cast("lapack_complex_float*") float[] vl,
                          int ldvl, @Cast("lapack_complex_float*") float[] vr,
                          int ldvr );
public static native int LAPACKE_zggev( int matrix_layout, @Cast("char") byte jobvl, @Cast("char") byte jobvr,
                          int n, @Cast("lapack_complex_double*") DoublePointer a,
                          int lda, @Cast("lapack_complex_double*") DoublePointer b,
                          int ldb, @Cast("lapack_complex_double*") DoublePointer alpha,
                          @Cast("lapack_complex_double*") DoublePointer beta,
                          @Cast("lapack_complex_double*") DoublePointer vl, int ldvl,
                          @Cast("lapack_complex_double*") DoublePointer vr, int ldvr );
public static native int LAPACKE_zggev( int matrix_layout, @Cast("char") byte jobvl, @Cast("char") byte jobvr,
                          int n, @Cast("lapack_complex_double*") DoubleBuffer a,
                          int lda, @Cast("lapack_complex_double*") DoubleBuffer b,
                          int ldb, @Cast("lapack_complex_double*") DoubleBuffer alpha,
                          @Cast("lapack_complex_double*") DoubleBuffer beta,
                          @Cast("lapack_complex_double*") DoubleBuffer vl, int ldvl,
                          @Cast("lapack_complex_double*") DoubleBuffer vr, int ldvr );
public static native int LAPACKE_zggev( int matrix_layout, @Cast("char") byte jobvl, @Cast("char") byte jobvr,
                          int n, @Cast("lapack_complex_double*") double[] a,
                          int lda, @Cast("lapack_complex_double*") double[] b,
                          int ldb, @Cast("lapack_complex_double*") double[] alpha,
                          @Cast("lapack_complex_double*") double[] beta,
                          @Cast("lapack_complex_double*") double[] vl, int ldvl,
                          @Cast("lapack_complex_double*") double[] vr, int ldvr );

public static native int LAPACKE_sggev3( int matrix_layout, @Cast("char") byte jobvl, @Cast("char") byte jobvr,
                           int n, FloatPointer a, int lda,
                           FloatPointer b, int ldb,
                           FloatPointer alphar, FloatPointer alphai, FloatPointer beta,
                           FloatPointer vl, int ldvl,
                           FloatPointer vr, int ldvr );
public static native int LAPACKE_sggev3( int matrix_layout, @Cast("char") byte jobvl, @Cast("char") byte jobvr,
                           int n, FloatBuffer a, int lda,
                           FloatBuffer b, int ldb,
                           FloatBuffer alphar, FloatBuffer alphai, FloatBuffer beta,
                           FloatBuffer vl, int ldvl,
                           FloatBuffer vr, int ldvr );
public static native int LAPACKE_sggev3( int matrix_layout, @Cast("char") byte jobvl, @Cast("char") byte jobvr,
                           int n, float[] a, int lda,
                           float[] b, int ldb,
                           float[] alphar, float[] alphai, float[] beta,
                           float[] vl, int ldvl,
                           float[] vr, int ldvr );
public static native int LAPACKE_dggev3( int matrix_layout, @Cast("char") byte jobvl, @Cast("char") byte jobvr,
                           int n, DoublePointer a, int lda,
                           DoublePointer b, int ldb,
                           DoublePointer alphar, DoublePointer alphai, DoublePointer beta,
                           DoublePointer vl, int ldvl,
                           DoublePointer vr, int ldvr );
public static native int LAPACKE_dggev3( int matrix_layout, @Cast("char") byte jobvl, @Cast("char") byte jobvr,
                           int n, DoubleBuffer a, int lda,
                           DoubleBuffer b, int ldb,
                           DoubleBuffer alphar, DoubleBuffer alphai, DoubleBuffer beta,
                           DoubleBuffer vl, int ldvl,
                           DoubleBuffer vr, int ldvr );
public static native int LAPACKE_dggev3( int matrix_layout, @Cast("char") byte jobvl, @Cast("char") byte jobvr,
                           int n, double[] a, int lda,
                           double[] b, int ldb,
                           double[] alphar, double[] alphai, double[] beta,
                           double[] vl, int ldvl,
                           double[] vr, int ldvr );
public static native int LAPACKE_cggev3( int matrix_layout, @Cast("char") byte jobvl, @Cast("char") byte jobvr,
                           int n,
                           @Cast("lapack_complex_float*") FloatPointer a, int lda,
                           @Cast("lapack_complex_float*") FloatPointer b, int ldb,
                           @Cast("lapack_complex_float*") FloatPointer alpha,
                           @Cast("lapack_complex_float*") FloatPointer beta,
                           @Cast("lapack_complex_float*") FloatPointer vl, int ldvl,
                           @Cast("lapack_complex_float*") FloatPointer vr, int ldvr );
public static native int LAPACKE_cggev3( int matrix_layout, @Cast("char") byte jobvl, @Cast("char") byte jobvr,
                           int n,
                           @Cast("lapack_complex_float*") FloatBuffer a, int lda,
                           @Cast("lapack_complex_float*") FloatBuffer b, int ldb,
                           @Cast("lapack_complex_float*") FloatBuffer alpha,
                           @Cast("lapack_complex_float*") FloatBuffer beta,
                           @Cast("lapack_complex_float*") FloatBuffer vl, int ldvl,
                           @Cast("lapack_complex_float*") FloatBuffer vr, int ldvr );
public static native int LAPACKE_cggev3( int matrix_layout, @Cast("char") byte jobvl, @Cast("char") byte jobvr,
                           int n,
                           @Cast("lapack_complex_float*") float[] a, int lda,
                           @Cast("lapack_complex_float*") float[] b, int ldb,
                           @Cast("lapack_complex_float*") float[] alpha,
                           @Cast("lapack_complex_float*") float[] beta,
                           @Cast("lapack_complex_float*") float[] vl, int ldvl,
                           @Cast("lapack_complex_float*") float[] vr, int ldvr );
public static native int LAPACKE_zggev3( int matrix_layout, @Cast("char") byte jobvl, @Cast("char") byte jobvr,
                           int n,
                           @Cast("lapack_complex_double*") DoublePointer a, int lda,
                           @Cast("lapack_complex_double*") DoublePointer b, int ldb,
                           @Cast("lapack_complex_double*") DoublePointer alpha,
                           @Cast("lapack_complex_double*") DoublePointer beta,
                           @Cast("lapack_complex_double*") DoublePointer vl, int ldvl,
                           @Cast("lapack_complex_double*") DoublePointer vr, int ldvr );
public static native int LAPACKE_zggev3( int matrix_layout, @Cast("char") byte jobvl, @Cast("char") byte jobvr,
                           int n,
                           @Cast("lapack_complex_double*") DoubleBuffer a, int lda,
                           @Cast("lapack_complex_double*") DoubleBuffer b, int ldb,
                           @Cast("lapack_complex_double*") DoubleBuffer alpha,
                           @Cast("lapack_complex_double*") DoubleBuffer beta,
                           @Cast("lapack_complex_double*") DoubleBuffer vl, int ldvl,
                           @Cast("lapack_complex_double*") DoubleBuffer vr, int ldvr );
public static native int LAPACKE_zggev3( int matrix_layout, @Cast("char") byte jobvl, @Cast("char") byte jobvr,
                           int n,
                           @Cast("lapack_complex_double*") double[] a, int lda,
                           @Cast("lapack_complex_double*") double[] b, int ldb,
                           @Cast("lapack_complex_double*") double[] alpha,
                           @Cast("lapack_complex_double*") double[] beta,
                           @Cast("lapack_complex_double*") double[] vl, int ldvl,
                           @Cast("lapack_complex_double*") double[] vr, int ldvr );

public static native int LAPACKE_sggevx( int matrix_layout, @Cast("char") byte balanc, @Cast("char") byte jobvl,
                           @Cast("char") byte jobvr, @Cast("char") byte sense, int n, FloatPointer a,
                           int lda, FloatPointer b, int ldb,
                           FloatPointer alphar, FloatPointer alphai, FloatPointer beta, FloatPointer vl,
                           int ldvl, FloatPointer vr, int ldvr,
                           IntPointer ilo, IntPointer ihi, FloatPointer lscale,
                           FloatPointer rscale, FloatPointer abnrm, FloatPointer bbnrm,
                           FloatPointer rconde, FloatPointer rcondv );
public static native int LAPACKE_sggevx( int matrix_layout, @Cast("char") byte balanc, @Cast("char") byte jobvl,
                           @Cast("char") byte jobvr, @Cast("char") byte sense, int n, FloatBuffer a,
                           int lda, FloatBuffer b, int ldb,
                           FloatBuffer alphar, FloatBuffer alphai, FloatBuffer beta, FloatBuffer vl,
                           int ldvl, FloatBuffer vr, int ldvr,
                           IntBuffer ilo, IntBuffer ihi, FloatBuffer lscale,
                           FloatBuffer rscale, FloatBuffer abnrm, FloatBuffer bbnrm,
                           FloatBuffer rconde, FloatBuffer rcondv );
public static native int LAPACKE_sggevx( int matrix_layout, @Cast("char") byte balanc, @Cast("char") byte jobvl,
                           @Cast("char") byte jobvr, @Cast("char") byte sense, int n, float[] a,
                           int lda, float[] b, int ldb,
                           float[] alphar, float[] alphai, float[] beta, float[] vl,
                           int ldvl, float[] vr, int ldvr,
                           int[] ilo, int[] ihi, float[] lscale,
                           float[] rscale, float[] abnrm, float[] bbnrm,
                           float[] rconde, float[] rcondv );
public static native int LAPACKE_dggevx( int matrix_layout, @Cast("char") byte balanc, @Cast("char") byte jobvl,
                           @Cast("char") byte jobvr, @Cast("char") byte sense, int n, DoublePointer a,
                           int lda, DoublePointer b, int ldb,
                           DoublePointer alphar, DoublePointer alphai, DoublePointer beta,
                           DoublePointer vl, int ldvl, DoublePointer vr,
                           int ldvr, IntPointer ilo, IntPointer ihi,
                           DoublePointer lscale, DoublePointer rscale, DoublePointer abnrm,
                           DoublePointer bbnrm, DoublePointer rconde, DoublePointer rcondv );
public static native int LAPACKE_dggevx( int matrix_layout, @Cast("char") byte balanc, @Cast("char") byte jobvl,
                           @Cast("char") byte jobvr, @Cast("char") byte sense, int n, DoubleBuffer a,
                           int lda, DoubleBuffer b, int ldb,
                           DoubleBuffer alphar, DoubleBuffer alphai, DoubleBuffer beta,
                           DoubleBuffer vl, int ldvl, DoubleBuffer vr,
                           int ldvr, IntBuffer ilo, IntBuffer ihi,
                           DoubleBuffer lscale, DoubleBuffer rscale, DoubleBuffer abnrm,
                           DoubleBuffer bbnrm, DoubleBuffer rconde, DoubleBuffer rcondv );
public static native int LAPACKE_dggevx( int matrix_layout, @Cast("char") byte balanc, @Cast("char") byte jobvl,
                           @Cast("char") byte jobvr, @Cast("char") byte sense, int n, double[] a,
                           int lda, double[] b, int ldb,
                           double[] alphar, double[] alphai, double[] beta,
                           double[] vl, int ldvl, double[] vr,
                           int ldvr, int[] ilo, int[] ihi,
                           double[] lscale, double[] rscale, double[] abnrm,
                           double[] bbnrm, double[] rconde, double[] rcondv );
public static native int LAPACKE_cggevx( int matrix_layout, @Cast("char") byte balanc, @Cast("char") byte jobvl,
                           @Cast("char") byte jobvr, @Cast("char") byte sense, int n,
                           @Cast("lapack_complex_float*") FloatPointer a, int lda,
                           @Cast("lapack_complex_float*") FloatPointer b, int ldb,
                           @Cast("lapack_complex_float*") FloatPointer alpha,
                           @Cast("lapack_complex_float*") FloatPointer beta, @Cast("lapack_complex_float*") FloatPointer vl,
                           int ldvl, @Cast("lapack_complex_float*") FloatPointer vr,
                           int ldvr, IntPointer ilo, IntPointer ihi,
                           FloatPointer lscale, FloatPointer rscale, FloatPointer abnrm,
                           FloatPointer bbnrm, FloatPointer rconde, FloatPointer rcondv );
public static native int LAPACKE_cggevx( int matrix_layout, @Cast("char") byte balanc, @Cast("char") byte jobvl,
                           @Cast("char") byte jobvr, @Cast("char") byte sense, int n,
                           @Cast("lapack_complex_float*") FloatBuffer a, int lda,
                           @Cast("lapack_complex_float*") FloatBuffer b, int ldb,
                           @Cast("lapack_complex_float*") FloatBuffer alpha,
                           @Cast("lapack_complex_float*") FloatBuffer beta, @Cast("lapack_complex_float*") FloatBuffer vl,
                           int ldvl, @Cast("lapack_complex_float*") FloatBuffer vr,
                           int ldvr, IntBuffer ilo, IntBuffer ihi,
                           FloatBuffer lscale, FloatBuffer rscale, FloatBuffer abnrm,
                           FloatBuffer bbnrm, FloatBuffer rconde, FloatBuffer rcondv );
public static native int LAPACKE_cggevx( int matrix_layout, @Cast("char") byte balanc, @Cast("char") byte jobvl,
                           @Cast("char") byte jobvr, @Cast("char") byte sense, int n,
                           @Cast("lapack_complex_float*") float[] a, int lda,
                           @Cast("lapack_complex_float*") float[] b, int ldb,
                           @Cast("lapack_complex_float*") float[] alpha,
                           @Cast("lapack_complex_float*") float[] beta, @Cast("lapack_complex_float*") float[] vl,
                           int ldvl, @Cast("lapack_complex_float*") float[] vr,
                           int ldvr, int[] ilo, int[] ihi,
                           float[] lscale, float[] rscale, float[] abnrm,
                           float[] bbnrm, float[] rconde, float[] rcondv );
public static native int LAPACKE_zggevx( int matrix_layout, @Cast("char") byte balanc, @Cast("char") byte jobvl,
                           @Cast("char") byte jobvr, @Cast("char") byte sense, int n,
                           @Cast("lapack_complex_double*") DoublePointer a, int lda,
                           @Cast("lapack_complex_double*") DoublePointer b, int ldb,
                           @Cast("lapack_complex_double*") DoublePointer alpha,
                           @Cast("lapack_complex_double*") DoublePointer beta,
                           @Cast("lapack_complex_double*") DoublePointer vl, int ldvl,
                           @Cast("lapack_complex_double*") DoublePointer vr, int ldvr,
                           IntPointer ilo, IntPointer ihi, DoublePointer lscale,
                           DoublePointer rscale, DoublePointer abnrm, DoublePointer bbnrm,
                           DoublePointer rconde, DoublePointer rcondv );
public static native int LAPACKE_zggevx( int matrix_layout, @Cast("char") byte balanc, @Cast("char") byte jobvl,
                           @Cast("char") byte jobvr, @Cast("char") byte sense, int n,
                           @Cast("lapack_complex_double*") DoubleBuffer a, int lda,
                           @Cast("lapack_complex_double*") DoubleBuffer b, int ldb,
                           @Cast("lapack_complex_double*") DoubleBuffer alpha,
                           @Cast("lapack_complex_double*") DoubleBuffer beta,
                           @Cast("lapack_complex_double*") DoubleBuffer vl, int ldvl,
                           @Cast("lapack_complex_double*") DoubleBuffer vr, int ldvr,
                           IntBuffer ilo, IntBuffer ihi, DoubleBuffer lscale,
                           DoubleBuffer rscale, DoubleBuffer abnrm, DoubleBuffer bbnrm,
                           DoubleBuffer rconde, DoubleBuffer rcondv );
public static native int LAPACKE_zggevx( int matrix_layout, @Cast("char") byte balanc, @Cast("char") byte jobvl,
                           @Cast("char") byte jobvr, @Cast("char") byte sense, int n,
                           @Cast("lapack_complex_double*") double[] a, int lda,
                           @Cast("lapack_complex_double*") double[] b, int ldb,
                           @Cast("lapack_complex_double*") double[] alpha,
                           @Cast("lapack_complex_double*") double[] beta,
                           @Cast("lapack_complex_double*") double[] vl, int ldvl,
                           @Cast("lapack_complex_double*") double[] vr, int ldvr,
                           int[] ilo, int[] ihi, double[] lscale,
                           double[] rscale, double[] abnrm, double[] bbnrm,
                           double[] rconde, double[] rcondv );

public static native int LAPACKE_sggglm( int matrix_layout, int n, int m,
                           int p, FloatPointer a, int lda, FloatPointer b,
                           int ldb, FloatPointer d, FloatPointer x, FloatPointer y );
public static native int LAPACKE_sggglm( int matrix_layout, int n, int m,
                           int p, FloatBuffer a, int lda, FloatBuffer b,
                           int ldb, FloatBuffer d, FloatBuffer x, FloatBuffer y );
public static native int LAPACKE_sggglm( int matrix_layout, int n, int m,
                           int p, float[] a, int lda, float[] b,
                           int ldb, float[] d, float[] x, float[] y );
public static native int LAPACKE_dggglm( int matrix_layout, int n, int m,
                           int p, DoublePointer a, int lda, DoublePointer b,
                           int ldb, DoublePointer d, DoublePointer x, DoublePointer y );
public static native int LAPACKE_dggglm( int matrix_layout, int n, int m,
                           int p, DoubleBuffer a, int lda, DoubleBuffer b,
                           int ldb, DoubleBuffer d, DoubleBuffer x, DoubleBuffer y );
public static native int LAPACKE_dggglm( int matrix_layout, int n, int m,
                           int p, double[] a, int lda, double[] b,
                           int ldb, double[] d, double[] x, double[] y );
public static native int LAPACKE_cggglm( int matrix_layout, int n, int m,
                           int p, @Cast("lapack_complex_float*") FloatPointer a,
                           int lda, @Cast("lapack_complex_float*") FloatPointer b,
                           int ldb, @Cast("lapack_complex_float*") FloatPointer d,
                           @Cast("lapack_complex_float*") FloatPointer x, @Cast("lapack_complex_float*") FloatPointer y );
public static native int LAPACKE_cggglm( int matrix_layout, int n, int m,
                           int p, @Cast("lapack_complex_float*") FloatBuffer a,
                           int lda, @Cast("lapack_complex_float*") FloatBuffer b,
                           int ldb, @Cast("lapack_complex_float*") FloatBuffer d,
                           @Cast("lapack_complex_float*") FloatBuffer x, @Cast("lapack_complex_float*") FloatBuffer y );
public static native int LAPACKE_cggglm( int matrix_layout, int n, int m,
                           int p, @Cast("lapack_complex_float*") float[] a,
                           int lda, @Cast("lapack_complex_float*") float[] b,
                           int ldb, @Cast("lapack_complex_float*") float[] d,
                           @Cast("lapack_complex_float*") float[] x, @Cast("lapack_complex_float*") float[] y );
public static native int LAPACKE_zggglm( int matrix_layout, int n, int m,
                           int p, @Cast("lapack_complex_double*") DoublePointer a,
                           int lda, @Cast("lapack_complex_double*") DoublePointer b,
                           int ldb, @Cast("lapack_complex_double*") DoublePointer d,
                           @Cast("lapack_complex_double*") DoublePointer x, @Cast("lapack_complex_double*") DoublePointer y );
public static native int LAPACKE_zggglm( int matrix_layout, int n, int m,
                           int p, @Cast("lapack_complex_double*") DoubleBuffer a,
                           int lda, @Cast("lapack_complex_double*") DoubleBuffer b,
                           int ldb, @Cast("lapack_complex_double*") DoubleBuffer d,
                           @Cast("lapack_complex_double*") DoubleBuffer x, @Cast("lapack_complex_double*") DoubleBuffer y );
public static native int LAPACKE_zggglm( int matrix_layout, int n, int m,
                           int p, @Cast("lapack_complex_double*") double[] a,
                           int lda, @Cast("lapack_complex_double*") double[] b,
                           int ldb, @Cast("lapack_complex_double*") double[] d,
                           @Cast("lapack_complex_double*") double[] x, @Cast("lapack_complex_double*") double[] y );

public static native int LAPACKE_sgghrd( int matrix_layout, @Cast("char") byte compq, @Cast("char") byte compz,
                           int n, int ilo, int ihi,
                           FloatPointer a, int lda, FloatPointer b, int ldb,
                           FloatPointer q, int ldq, FloatPointer z, int ldz );
public static native int LAPACKE_sgghrd( int matrix_layout, @Cast("char") byte compq, @Cast("char") byte compz,
                           int n, int ilo, int ihi,
                           FloatBuffer a, int lda, FloatBuffer b, int ldb,
                           FloatBuffer q, int ldq, FloatBuffer z, int ldz );
public static native int LAPACKE_sgghrd( int matrix_layout, @Cast("char") byte compq, @Cast("char") byte compz,
                           int n, int ilo, int ihi,
                           float[] a, int lda, float[] b, int ldb,
                           float[] q, int ldq, float[] z, int ldz );
public static native int LAPACKE_dgghrd( int matrix_layout, @Cast("char") byte compq, @Cast("char") byte compz,
                           int n, int ilo, int ihi,
                           DoublePointer a, int lda, DoublePointer b, int ldb,
                           DoublePointer q, int ldq, DoublePointer z,
                           int ldz );
public static native int LAPACKE_dgghrd( int matrix_layout, @Cast("char") byte compq, @Cast("char") byte compz,
                           int n, int ilo, int ihi,
                           DoubleBuffer a, int lda, DoubleBuffer b, int ldb,
                           DoubleBuffer q, int ldq, DoubleBuffer z,
                           int ldz );
public static native int LAPACKE_dgghrd( int matrix_layout, @Cast("char") byte compq, @Cast("char") byte compz,
                           int n, int ilo, int ihi,
                           double[] a, int lda, double[] b, int ldb,
                           double[] q, int ldq, double[] z,
                           int ldz );
public static native int LAPACKE_cgghrd( int matrix_layout, @Cast("char") byte compq, @Cast("char") byte compz,
                           int n, int ilo, int ihi,
                           @Cast("lapack_complex_float*") FloatPointer a, int lda,
                           @Cast("lapack_complex_float*") FloatPointer b, int ldb,
                           @Cast("lapack_complex_float*") FloatPointer q, int ldq,
                           @Cast("lapack_complex_float*") FloatPointer z, int ldz );
public static native int LAPACKE_cgghrd( int matrix_layout, @Cast("char") byte compq, @Cast("char") byte compz,
                           int n, int ilo, int ihi,
                           @Cast("lapack_complex_float*") FloatBuffer a, int lda,
                           @Cast("lapack_complex_float*") FloatBuffer b, int ldb,
                           @Cast("lapack_complex_float*") FloatBuffer q, int ldq,
                           @Cast("lapack_complex_float*") FloatBuffer z, int ldz );
public static native int LAPACKE_cgghrd( int matrix_layout, @Cast("char") byte compq, @Cast("char") byte compz,
                           int n, int ilo, int ihi,
                           @Cast("lapack_complex_float*") float[] a, int lda,
                           @Cast("lapack_complex_float*") float[] b, int ldb,
                           @Cast("lapack_complex_float*") float[] q, int ldq,
                           @Cast("lapack_complex_float*") float[] z, int ldz );
public static native int LAPACKE_zgghrd( int matrix_layout, @Cast("char") byte compq, @Cast("char") byte compz,
                           int n, int ilo, int ihi,
                           @Cast("lapack_complex_double*") DoublePointer a, int lda,
                           @Cast("lapack_complex_double*") DoublePointer b, int ldb,
                           @Cast("lapack_complex_double*") DoublePointer q, int ldq,
                           @Cast("lapack_complex_double*") DoublePointer z, int ldz );
public static native int LAPACKE_zgghrd( int matrix_layout, @Cast("char") byte compq, @Cast("char") byte compz,
                           int n, int ilo, int ihi,
                           @Cast("lapack_complex_double*") DoubleBuffer a, int lda,
                           @Cast("lapack_complex_double*") DoubleBuffer b, int ldb,
                           @Cast("lapack_complex_double*") DoubleBuffer q, int ldq,
                           @Cast("lapack_complex_double*") DoubleBuffer z, int ldz );
public static native int LAPACKE_zgghrd( int matrix_layout, @Cast("char") byte compq, @Cast("char") byte compz,
                           int n, int ilo, int ihi,
                           @Cast("lapack_complex_double*") double[] a, int lda,
                           @Cast("lapack_complex_double*") double[] b, int ldb,
                           @Cast("lapack_complex_double*") double[] q, int ldq,
                           @Cast("lapack_complex_double*") double[] z, int ldz );

public static native int LAPACKE_sgghd3( int matrix_layout, @Cast("char") byte compq, @Cast("char") byte compz,
                           int n, int ilo, int ihi,
                           FloatPointer a, int lda, FloatPointer b, int ldb,
                           FloatPointer q, int ldq, FloatPointer z, int ldz );
public static native int LAPACKE_sgghd3( int matrix_layout, @Cast("char") byte compq, @Cast("char") byte compz,
                           int n, int ilo, int ihi,
                           FloatBuffer a, int lda, FloatBuffer b, int ldb,
                           FloatBuffer q, int ldq, FloatBuffer z, int ldz );
public static native int LAPACKE_sgghd3( int matrix_layout, @Cast("char") byte compq, @Cast("char") byte compz,
                           int n, int ilo, int ihi,
                           float[] a, int lda, float[] b, int ldb,
                           float[] q, int ldq, float[] z, int ldz );
public static native int LAPACKE_dgghd3( int matrix_layout, @Cast("char") byte compq, @Cast("char") byte compz,
                           int n, int ilo, int ihi,
                           DoublePointer a, int lda, DoublePointer b, int ldb,
                           DoublePointer q, int ldq, DoublePointer z,
                           int ldz );
public static native int LAPACKE_dgghd3( int matrix_layout, @Cast("char") byte compq, @Cast("char") byte compz,
                           int n, int ilo, int ihi,
                           DoubleBuffer a, int lda, DoubleBuffer b, int ldb,
                           DoubleBuffer q, int ldq, DoubleBuffer z,
                           int ldz );
public static native int LAPACKE_dgghd3( int matrix_layout, @Cast("char") byte compq, @Cast("char") byte compz,
                           int n, int ilo, int ihi,
                           double[] a, int lda, double[] b, int ldb,
                           double[] q, int ldq, double[] z,
                           int ldz );
public static native int LAPACKE_cgghd3( int matrix_layout, @Cast("char") byte compq, @Cast("char") byte compz,
                           int n, int ilo, int ihi,
                           @Cast("lapack_complex_float*") FloatPointer a, int lda,
                           @Cast("lapack_complex_float*") FloatPointer b, int ldb,
                           @Cast("lapack_complex_float*") FloatPointer q, int ldq,
                           @Cast("lapack_complex_float*") FloatPointer z, int ldz );
public static native int LAPACKE_cgghd3( int matrix_layout, @Cast("char") byte compq, @Cast("char") byte compz,
                           int n, int ilo, int ihi,
                           @Cast("lapack_complex_float*") FloatBuffer a, int lda,
                           @Cast("lapack_complex_float*") FloatBuffer b, int ldb,
                           @Cast("lapack_complex_float*") FloatBuffer q, int ldq,
                           @Cast("lapack_complex_float*") FloatBuffer z, int ldz );
public static native int LAPACKE_cgghd3( int matrix_layout, @Cast("char") byte compq, @Cast("char") byte compz,
                           int n, int ilo, int ihi,
                           @Cast("lapack_complex_float*") float[] a, int lda,
                           @Cast("lapack_complex_float*") float[] b, int ldb,
                           @Cast("lapack_complex_float*") float[] q, int ldq,
                           @Cast("lapack_complex_float*") float[] z, int ldz );
public static native int LAPACKE_zgghd3( int matrix_layout, @Cast("char") byte compq, @Cast("char") byte compz,
                           int n, int ilo, int ihi,
                           @Cast("lapack_complex_double*") DoublePointer a, int lda,
                           @Cast("lapack_complex_double*") DoublePointer b, int ldb,
                           @Cast("lapack_complex_double*") DoublePointer q, int ldq,
                           @Cast("lapack_complex_double*") DoublePointer z, int ldz );
public static native int LAPACKE_zgghd3( int matrix_layout, @Cast("char") byte compq, @Cast("char") byte compz,
                           int n, int ilo, int ihi,
                           @Cast("lapack_complex_double*") DoubleBuffer a, int lda,
                           @Cast("lapack_complex_double*") DoubleBuffer b, int ldb,
                           @Cast("lapack_complex_double*") DoubleBuffer q, int ldq,
                           @Cast("lapack_complex_double*") DoubleBuffer z, int ldz );
public static native int LAPACKE_zgghd3( int matrix_layout, @Cast("char") byte compq, @Cast("char") byte compz,
                           int n, int ilo, int ihi,
                           @Cast("lapack_complex_double*") double[] a, int lda,
                           @Cast("lapack_complex_double*") double[] b, int ldb,
                           @Cast("lapack_complex_double*") double[] q, int ldq,
                           @Cast("lapack_complex_double*") double[] z, int ldz );

public static native int LAPACKE_sgglse( int matrix_layout, int m, int n,
                           int p, FloatPointer a, int lda, FloatPointer b,
                           int ldb, FloatPointer c, FloatPointer d, FloatPointer x );
public static native int LAPACKE_sgglse( int matrix_layout, int m, int n,
                           int p, FloatBuffer a, int lda, FloatBuffer b,
                           int ldb, FloatBuffer c, FloatBuffer d, FloatBuffer x );
public static native int LAPACKE_sgglse( int matrix_layout, int m, int n,
                           int p, float[] a, int lda, float[] b,
                           int ldb, float[] c, float[] d, float[] x );
public static native int LAPACKE_dgglse( int matrix_layout, int m, int n,
                           int p, DoublePointer a, int lda, DoublePointer b,
                           int ldb, DoublePointer c, DoublePointer d, DoublePointer x );
public static native int LAPACKE_dgglse( int matrix_layout, int m, int n,
                           int p, DoubleBuffer a, int lda, DoubleBuffer b,
                           int ldb, DoubleBuffer c, DoubleBuffer d, DoubleBuffer x );
public static native int LAPACKE_dgglse( int matrix_layout, int m, int n,
                           int p, double[] a, int lda, double[] b,
                           int ldb, double[] c, double[] d, double[] x );
public static native int LAPACKE_cgglse( int matrix_layout, int m, int n,
                           int p, @Cast("lapack_complex_float*") FloatPointer a,
                           int lda, @Cast("lapack_complex_float*") FloatPointer b,
                           int ldb, @Cast("lapack_complex_float*") FloatPointer c,
                           @Cast("lapack_complex_float*") FloatPointer d, @Cast("lapack_complex_float*") FloatPointer x );
public static native int LAPACKE_cgglse( int matrix_layout, int m, int n,
                           int p, @Cast("lapack_complex_float*") FloatBuffer a,
                           int lda, @Cast("lapack_complex_float*") FloatBuffer b,
                           int ldb, @Cast("lapack_complex_float*") FloatBuffer c,
                           @Cast("lapack_complex_float*") FloatBuffer d, @Cast("lapack_complex_float*") FloatBuffer x );
public static native int LAPACKE_cgglse( int matrix_layout, int m, int n,
                           int p, @Cast("lapack_complex_float*") float[] a,
                           int lda, @Cast("lapack_complex_float*") float[] b,
                           int ldb, @Cast("lapack_complex_float*") float[] c,
                           @Cast("lapack_complex_float*") float[] d, @Cast("lapack_complex_float*") float[] x );
public static native int LAPACKE_zgglse( int matrix_layout, int m, int n,
                           int p, @Cast("lapack_complex_double*") DoublePointer a,
                           int lda, @Cast("lapack_complex_double*") DoublePointer b,
                           int ldb, @Cast("lapack_complex_double*") DoublePointer c,
                           @Cast("lapack_complex_double*") DoublePointer d, @Cast("lapack_complex_double*") DoublePointer x );
public static native int LAPACKE_zgglse( int matrix_layout, int m, int n,
                           int p, @Cast("lapack_complex_double*") DoubleBuffer a,
                           int lda, @Cast("lapack_complex_double*") DoubleBuffer b,
                           int ldb, @Cast("lapack_complex_double*") DoubleBuffer c,
                           @Cast("lapack_complex_double*") DoubleBuffer d, @Cast("lapack_complex_double*") DoubleBuffer x );
public static native int LAPACKE_zgglse( int matrix_layout, int m, int n,
                           int p, @Cast("lapack_complex_double*") double[] a,
                           int lda, @Cast("lapack_complex_double*") double[] b,
                           int ldb, @Cast("lapack_complex_double*") double[] c,
                           @Cast("lapack_complex_double*") double[] d, @Cast("lapack_complex_double*") double[] x );

public static native int LAPACKE_sggqrf( int matrix_layout, int n, int m,
                           int p, FloatPointer a, int lda, FloatPointer taua,
                           FloatPointer b, int ldb, FloatPointer taub );
public static native int LAPACKE_sggqrf( int matrix_layout, int n, int m,
                           int p, FloatBuffer a, int lda, FloatBuffer taua,
                           FloatBuffer b, int ldb, FloatBuffer taub );
public static native int LAPACKE_sggqrf( int matrix_layout, int n, int m,
                           int p, float[] a, int lda, float[] taua,
                           float[] b, int ldb, float[] taub );
public static native int LAPACKE_dggqrf( int matrix_layout, int n, int m,
                           int p, DoublePointer a, int lda,
                           DoublePointer taua, DoublePointer b, int ldb,
                           DoublePointer taub );
public static native int LAPACKE_dggqrf( int matrix_layout, int n, int m,
                           int p, DoubleBuffer a, int lda,
                           DoubleBuffer taua, DoubleBuffer b, int ldb,
                           DoubleBuffer taub );
public static native int LAPACKE_dggqrf( int matrix_layout, int n, int m,
                           int p, double[] a, int lda,
                           double[] taua, double[] b, int ldb,
                           double[] taub );
public static native int LAPACKE_cggqrf( int matrix_layout, int n, int m,
                           int p, @Cast("lapack_complex_float*") FloatPointer a,
                           int lda, @Cast("lapack_complex_float*") FloatPointer taua,
                           @Cast("lapack_complex_float*") FloatPointer b, int ldb,
                           @Cast("lapack_complex_float*") FloatPointer taub );
public static native int LAPACKE_cggqrf( int matrix_layout, int n, int m,
                           int p, @Cast("lapack_complex_float*") FloatBuffer a,
                           int lda, @Cast("lapack_complex_float*") FloatBuffer taua,
                           @Cast("lapack_complex_float*") FloatBuffer b, int ldb,
                           @Cast("lapack_complex_float*") FloatBuffer taub );
public static native int LAPACKE_cggqrf( int matrix_layout, int n, int m,
                           int p, @Cast("lapack_complex_float*") float[] a,
                           int lda, @Cast("lapack_complex_float*") float[] taua,
                           @Cast("lapack_complex_float*") float[] b, int ldb,
                           @Cast("lapack_complex_float*") float[] taub );
public static native int LAPACKE_zggqrf( int matrix_layout, int n, int m,
                           int p, @Cast("lapack_complex_double*") DoublePointer a,
                           int lda, @Cast("lapack_complex_double*") DoublePointer taua,
                           @Cast("lapack_complex_double*") DoublePointer b, int ldb,
                           @Cast("lapack_complex_double*") DoublePointer taub );
public static native int LAPACKE_zggqrf( int matrix_layout, int n, int m,
                           int p, @Cast("lapack_complex_double*") DoubleBuffer a,
                           int lda, @Cast("lapack_complex_double*") DoubleBuffer taua,
                           @Cast("lapack_complex_double*") DoubleBuffer b, int ldb,
                           @Cast("lapack_complex_double*") DoubleBuffer taub );
public static native int LAPACKE_zggqrf( int matrix_layout, int n, int m,
                           int p, @Cast("lapack_complex_double*") double[] a,
                           int lda, @Cast("lapack_complex_double*") double[] taua,
                           @Cast("lapack_complex_double*") double[] b, int ldb,
                           @Cast("lapack_complex_double*") double[] taub );

public static native int LAPACKE_sggrqf( int matrix_layout, int m, int p,
                           int n, FloatPointer a, int lda, FloatPointer taua,
                           FloatPointer b, int ldb, FloatPointer taub );
public static native int LAPACKE_sggrqf( int matrix_layout, int m, int p,
                           int n, FloatBuffer a, int lda, FloatBuffer taua,
                           FloatBuffer b, int ldb, FloatBuffer taub );
public static native int LAPACKE_sggrqf( int matrix_layout, int m, int p,
                           int n, float[] a, int lda, float[] taua,
                           float[] b, int ldb, float[] taub );
public static native int LAPACKE_dggrqf( int matrix_layout, int m, int p,
                           int n, DoublePointer a, int lda,
                           DoublePointer taua, DoublePointer b, int ldb,
                           DoublePointer taub );
public static native int LAPACKE_dggrqf( int matrix_layout, int m, int p,
                           int n, DoubleBuffer a, int lda,
                           DoubleBuffer taua, DoubleBuffer b, int ldb,
                           DoubleBuffer taub );
public static native int LAPACKE_dggrqf( int matrix_layout, int m, int p,
                           int n, double[] a, int lda,
                           double[] taua, double[] b, int ldb,
                           double[] taub );
public static native int LAPACKE_cggrqf( int matrix_layout, int m, int p,
                           int n, @Cast("lapack_complex_float*") FloatPointer a,
                           int lda, @Cast("lapack_complex_float*") FloatPointer taua,
                           @Cast("lapack_complex_float*") FloatPointer b, int ldb,
                           @Cast("lapack_complex_float*") FloatPointer taub );
public static native int LAPACKE_cggrqf( int matrix_layout, int m, int p,
                           int n, @Cast("lapack_complex_float*") FloatBuffer a,
                           int lda, @Cast("lapack_complex_float*") FloatBuffer taua,
                           @Cast("lapack_complex_float*") FloatBuffer b, int ldb,
                           @Cast("lapack_complex_float*") FloatBuffer taub );
public static native int LAPACKE_cggrqf( int matrix_layout, int m, int p,
                           int n, @Cast("lapack_complex_float*") float[] a,
                           int lda, @Cast("lapack_complex_float*") float[] taua,
                           @Cast("lapack_complex_float*") float[] b, int ldb,
                           @Cast("lapack_complex_float*") float[] taub );
public static native int LAPACKE_zggrqf( int matrix_layout, int m, int p,
                           int n, @Cast("lapack_complex_double*") DoublePointer a,
                           int lda, @Cast("lapack_complex_double*") DoublePointer taua,
                           @Cast("lapack_complex_double*") DoublePointer b, int ldb,
                           @Cast("lapack_complex_double*") DoublePointer taub );
public static native int LAPACKE_zggrqf( int matrix_layout, int m, int p,
                           int n, @Cast("lapack_complex_double*") DoubleBuffer a,
                           int lda, @Cast("lapack_complex_double*") DoubleBuffer taua,
                           @Cast("lapack_complex_double*") DoubleBuffer b, int ldb,
                           @Cast("lapack_complex_double*") DoubleBuffer taub );
public static native int LAPACKE_zggrqf( int matrix_layout, int m, int p,
                           int n, @Cast("lapack_complex_double*") double[] a,
                           int lda, @Cast("lapack_complex_double*") double[] taua,
                           @Cast("lapack_complex_double*") double[] b, int ldb,
                           @Cast("lapack_complex_double*") double[] taub );






public static native int LAPACKE_sggsvd3( int matrix_layout, @Cast("char") byte jobu, @Cast("char") byte jobv, @Cast("char") byte jobq,
                            int m, int n, int p,
                            IntPointer k, IntPointer l, FloatPointer a,
                            int lda, FloatPointer b, int ldb,
                            FloatPointer alpha, FloatPointer beta, FloatPointer u, int ldu,
                            FloatPointer v, int ldv, FloatPointer q, int ldq,
                            IntPointer iwork );
public static native int LAPACKE_sggsvd3( int matrix_layout, @Cast("char") byte jobu, @Cast("char") byte jobv, @Cast("char") byte jobq,
                            int m, int n, int p,
                            IntBuffer k, IntBuffer l, FloatBuffer a,
                            int lda, FloatBuffer b, int ldb,
                            FloatBuffer alpha, FloatBuffer beta, FloatBuffer u, int ldu,
                            FloatBuffer v, int ldv, FloatBuffer q, int ldq,
                            IntBuffer iwork );
public static native int LAPACKE_sggsvd3( int matrix_layout, @Cast("char") byte jobu, @Cast("char") byte jobv, @Cast("char") byte jobq,
                            int m, int n, int p,
                            int[] k, int[] l, float[] a,
                            int lda, float[] b, int ldb,
                            float[] alpha, float[] beta, float[] u, int ldu,
                            float[] v, int ldv, float[] q, int ldq,
                            int[] iwork );
public static native int LAPACKE_dggsvd3( int matrix_layout, @Cast("char") byte jobu, @Cast("char") byte jobv, @Cast("char") byte jobq,
                            int m, int n, int p,
                            IntPointer k, IntPointer l, DoublePointer a,
                            int lda, DoublePointer b, int ldb,
                            DoublePointer alpha, DoublePointer beta, DoublePointer u,
                            int ldu, DoublePointer v, int ldv, DoublePointer q,
                            int ldq, IntPointer iwork );
public static native int LAPACKE_dggsvd3( int matrix_layout, @Cast("char") byte jobu, @Cast("char") byte jobv, @Cast("char") byte jobq,
                            int m, int n, int p,
                            IntBuffer k, IntBuffer l, DoubleBuffer a,
                            int lda, DoubleBuffer b, int ldb,
                            DoubleBuffer alpha, DoubleBuffer beta, DoubleBuffer u,
                            int ldu, DoubleBuffer v, int ldv, DoubleBuffer q,
                            int ldq, IntBuffer iwork );
public static native int LAPACKE_dggsvd3( int matrix_layout, @Cast("char") byte jobu, @Cast("char") byte jobv, @Cast("char") byte jobq,
                            int m, int n, int p,
                            int[] k, int[] l, double[] a,
                            int lda, double[] b, int ldb,
                            double[] alpha, double[] beta, double[] u,
                            int ldu, double[] v, int ldv, double[] q,
                            int ldq, int[] iwork );
public static native int LAPACKE_cggsvd3( int matrix_layout, @Cast("char") byte jobu, @Cast("char") byte jobv, @Cast("char") byte jobq,
                            int m, int n, int p,
                            IntPointer k, IntPointer l,
                            @Cast("lapack_complex_float*") FloatPointer a, int lda,
                            @Cast("lapack_complex_float*") FloatPointer b, int ldb,
                            FloatPointer alpha, FloatPointer beta, @Cast("lapack_complex_float*") FloatPointer u,
                            int ldu, @Cast("lapack_complex_float*") FloatPointer v,
                            int ldv, @Cast("lapack_complex_float*") FloatPointer q,
                            int ldq, IntPointer iwork );
public static native int LAPACKE_cggsvd3( int matrix_layout, @Cast("char") byte jobu, @Cast("char") byte jobv, @Cast("char") byte jobq,
                            int m, int n, int p,
                            IntBuffer k, IntBuffer l,
                            @Cast("lapack_complex_float*") FloatBuffer a, int lda,
                            @Cast("lapack_complex_float*") FloatBuffer b, int ldb,
                            FloatBuffer alpha, FloatBuffer beta, @Cast("lapack_complex_float*") FloatBuffer u,
                            int ldu, @Cast("lapack_complex_float*") FloatBuffer v,
                            int ldv, @Cast("lapack_complex_float*") FloatBuffer q,
                            int ldq, IntBuffer iwork );
public static native int LAPACKE_cggsvd3( int matrix_layout, @Cast("char") byte jobu, @Cast("char") byte jobv, @Cast("char") byte jobq,
                            int m, int n, int p,
                            int[] k, int[] l,
                            @Cast("lapack_complex_float*") float[] a, int lda,
                            @Cast("lapack_complex_float*") float[] b, int ldb,
                            float[] alpha, float[] beta, @Cast("lapack_complex_float*") float[] u,
                            int ldu, @Cast("lapack_complex_float*") float[] v,
                            int ldv, @Cast("lapack_complex_float*") float[] q,
                            int ldq, int[] iwork );
public static native int LAPACKE_zggsvd3( int matrix_layout, @Cast("char") byte jobu, @Cast("char") byte jobv, @Cast("char") byte jobq,
                            int m, int n, int p,
                            IntPointer k, IntPointer l,
                            @Cast("lapack_complex_double*") DoublePointer a, int lda,
                            @Cast("lapack_complex_double*") DoublePointer b, int ldb,
                            DoublePointer alpha, DoublePointer beta,
                            @Cast("lapack_complex_double*") DoublePointer u, int ldu,
                            @Cast("lapack_complex_double*") DoublePointer v, int ldv,
                            @Cast("lapack_complex_double*") DoublePointer q, int ldq,
                            IntPointer iwork );
public static native int LAPACKE_zggsvd3( int matrix_layout, @Cast("char") byte jobu, @Cast("char") byte jobv, @Cast("char") byte jobq,
                            int m, int n, int p,
                            IntBuffer k, IntBuffer l,
                            @Cast("lapack_complex_double*") DoubleBuffer a, int lda,
                            @Cast("lapack_complex_double*") DoubleBuffer b, int ldb,
                            DoubleBuffer alpha, DoubleBuffer beta,
                            @Cast("lapack_complex_double*") DoubleBuffer u, int ldu,
                            @Cast("lapack_complex_double*") DoubleBuffer v, int ldv,
                            @Cast("lapack_complex_double*") DoubleBuffer q, int ldq,
                            IntBuffer iwork );
public static native int LAPACKE_zggsvd3( int matrix_layout, @Cast("char") byte jobu, @Cast("char") byte jobv, @Cast("char") byte jobq,
                            int m, int n, int p,
                            int[] k, int[] l,
                            @Cast("lapack_complex_double*") double[] a, int lda,
                            @Cast("lapack_complex_double*") double[] b, int ldb,
                            double[] alpha, double[] beta,
                            @Cast("lapack_complex_double*") double[] u, int ldu,
                            @Cast("lapack_complex_double*") double[] v, int ldv,
                            @Cast("lapack_complex_double*") double[] q, int ldq,
                            int[] iwork );






public static native int LAPACKE_sggsvp3( int matrix_layout, @Cast("char") byte jobu, @Cast("char") byte jobv, @Cast("char") byte jobq,
                            int m, int p, int n, FloatPointer a,
                            int lda, FloatPointer b, int ldb, float tola,
                            float tolb, IntPointer k, IntPointer l, FloatPointer u,
                            int ldu, FloatPointer v, int ldv, FloatPointer q,
                            int ldq );
public static native int LAPACKE_sggsvp3( int matrix_layout, @Cast("char") byte jobu, @Cast("char") byte jobv, @Cast("char") byte jobq,
                            int m, int p, int n, FloatBuffer a,
                            int lda, FloatBuffer b, int ldb, float tola,
                            float tolb, IntBuffer k, IntBuffer l, FloatBuffer u,
                            int ldu, FloatBuffer v, int ldv, FloatBuffer q,
                            int ldq );
public static native int LAPACKE_sggsvp3( int matrix_layout, @Cast("char") byte jobu, @Cast("char") byte jobv, @Cast("char") byte jobq,
                            int m, int p, int n, float[] a,
                            int lda, float[] b, int ldb, float tola,
                            float tolb, int[] k, int[] l, float[] u,
                            int ldu, float[] v, int ldv, float[] q,
                            int ldq );
public static native int LAPACKE_dggsvp3( int matrix_layout, @Cast("char") byte jobu, @Cast("char") byte jobv, @Cast("char") byte jobq,
                            int m, int p, int n, DoublePointer a,
                            int lda, DoublePointer b, int ldb,
                            double tola, double tolb, IntPointer k,
                            IntPointer l, DoublePointer u, int ldu, DoublePointer v,
                            int ldv, DoublePointer q, int ldq );
public static native int LAPACKE_dggsvp3( int matrix_layout, @Cast("char") byte jobu, @Cast("char") byte jobv, @Cast("char") byte jobq,
                            int m, int p, int n, DoubleBuffer a,
                            int lda, DoubleBuffer b, int ldb,
                            double tola, double tolb, IntBuffer k,
                            IntBuffer l, DoubleBuffer u, int ldu, DoubleBuffer v,
                            int ldv, DoubleBuffer q, int ldq );
public static native int LAPACKE_dggsvp3( int matrix_layout, @Cast("char") byte jobu, @Cast("char") byte jobv, @Cast("char") byte jobq,
                            int m, int p, int n, double[] a,
                            int lda, double[] b, int ldb,
                            double tola, double tolb, int[] k,
                            int[] l, double[] u, int ldu, double[] v,
                            int ldv, double[] q, int ldq );
public static native int LAPACKE_cggsvp3( int matrix_layout, @Cast("char") byte jobu, @Cast("char") byte jobv, @Cast("char") byte jobq,
                            int m, int p, int n,
                            @Cast("lapack_complex_float*") FloatPointer a, int lda,
                            @Cast("lapack_complex_float*") FloatPointer b, int ldb, float tola,
                            float tolb, IntPointer k, IntPointer l,
                            @Cast("lapack_complex_float*") FloatPointer u, int ldu,
                            @Cast("lapack_complex_float*") FloatPointer v, int ldv,
                            @Cast("lapack_complex_float*") FloatPointer q, int ldq );
public static native int LAPACKE_cggsvp3( int matrix_layout, @Cast("char") byte jobu, @Cast("char") byte jobv, @Cast("char") byte jobq,
                            int m, int p, int n,
                            @Cast("lapack_complex_float*") FloatBuffer a, int lda,
                            @Cast("lapack_complex_float*") FloatBuffer b, int ldb, float tola,
                            float tolb, IntBuffer k, IntBuffer l,
                            @Cast("lapack_complex_float*") FloatBuffer u, int ldu,
                            @Cast("lapack_complex_float*") FloatBuffer v, int ldv,
                            @Cast("lapack_complex_float*") FloatBuffer q, int ldq );
public static native int LAPACKE_cggsvp3( int matrix_layout, @Cast("char") byte jobu, @Cast("char") byte jobv, @Cast("char") byte jobq,
                            int m, int p, int n,
                            @Cast("lapack_complex_float*") float[] a, int lda,
                            @Cast("lapack_complex_float*") float[] b, int ldb, float tola,
                            float tolb, int[] k, int[] l,
                            @Cast("lapack_complex_float*") float[] u, int ldu,
                            @Cast("lapack_complex_float*") float[] v, int ldv,
                            @Cast("lapack_complex_float*") float[] q, int ldq );
public static native int LAPACKE_zggsvp3( int matrix_layout, @Cast("char") byte jobu, @Cast("char") byte jobv, @Cast("char") byte jobq,
                            int m, int p, int n,
                            @Cast("lapack_complex_double*") DoublePointer a, int lda,
                            @Cast("lapack_complex_double*") DoublePointer b, int ldb,
                            double tola, double tolb, IntPointer k,
                            IntPointer l, @Cast("lapack_complex_double*") DoublePointer u,
                            int ldu, @Cast("lapack_complex_double*") DoublePointer v,
                            int ldv, @Cast("lapack_complex_double*") DoublePointer q,
                            int ldq );
public static native int LAPACKE_zggsvp3( int matrix_layout, @Cast("char") byte jobu, @Cast("char") byte jobv, @Cast("char") byte jobq,
                            int m, int p, int n,
                            @Cast("lapack_complex_double*") DoubleBuffer a, int lda,
                            @Cast("lapack_complex_double*") DoubleBuffer b, int ldb,
                            double tola, double tolb, IntBuffer k,
                            IntBuffer l, @Cast("lapack_complex_double*") DoubleBuffer u,
                            int ldu, @Cast("lapack_complex_double*") DoubleBuffer v,
                            int ldv, @Cast("lapack_complex_double*") DoubleBuffer q,
                            int ldq );
public static native int LAPACKE_zggsvp3( int matrix_layout, @Cast("char") byte jobu, @Cast("char") byte jobv, @Cast("char") byte jobq,
                            int m, int p, int n,
                            @Cast("lapack_complex_double*") double[] a, int lda,
                            @Cast("lapack_complex_double*") double[] b, int ldb,
                            double tola, double tolb, int[] k,
                            int[] l, @Cast("lapack_complex_double*") double[] u,
                            int ldu, @Cast("lapack_complex_double*") double[] v,
                            int ldv, @Cast("lapack_complex_double*") double[] q,
                            int ldq );

public static native int LAPACKE_sgtcon( @Cast("char") byte norm, int n, @Const FloatPointer dl,
                           @Const FloatPointer d, @Const FloatPointer du, @Const FloatPointer du2,
                           @Const IntPointer ipiv, float anorm, FloatPointer rcond );
public static native int LAPACKE_sgtcon( @Cast("char") byte norm, int n, @Const FloatBuffer dl,
                           @Const FloatBuffer d, @Const FloatBuffer du, @Const FloatBuffer du2,
                           @Const IntBuffer ipiv, float anorm, FloatBuffer rcond );
public static native int LAPACKE_sgtcon( @Cast("char") byte norm, int n, @Const float[] dl,
                           @Const float[] d, @Const float[] du, @Const float[] du2,
                           @Const int[] ipiv, float anorm, float[] rcond );
public static native int LAPACKE_dgtcon( @Cast("char") byte norm, int n, @Const DoublePointer dl,
                           @Const DoublePointer d, @Const DoublePointer du, @Const DoublePointer du2,
                           @Const IntPointer ipiv, double anorm,
                           DoublePointer rcond );
public static native int LAPACKE_dgtcon( @Cast("char") byte norm, int n, @Const DoubleBuffer dl,
                           @Const DoubleBuffer d, @Const DoubleBuffer du, @Const DoubleBuffer du2,
                           @Const IntBuffer ipiv, double anorm,
                           DoubleBuffer rcond );
public static native int LAPACKE_dgtcon( @Cast("char") byte norm, int n, @Const double[] dl,
                           @Const double[] d, @Const double[] du, @Const double[] du2,
                           @Const int[] ipiv, double anorm,
                           double[] rcond );
public static native int LAPACKE_cgtcon( @Cast("char") byte norm, int n,
                           @Cast("const lapack_complex_float*") FloatPointer dl,
                           @Cast("const lapack_complex_float*") FloatPointer d,
                           @Cast("const lapack_complex_float*") FloatPointer du,
                           @Cast("const lapack_complex_float*") FloatPointer du2,
                           @Const IntPointer ipiv, float anorm, FloatPointer rcond );
public static native int LAPACKE_cgtcon( @Cast("char") byte norm, int n,
                           @Cast("const lapack_complex_float*") FloatBuffer dl,
                           @Cast("const lapack_complex_float*") FloatBuffer d,
                           @Cast("const lapack_complex_float*") FloatBuffer du,
                           @Cast("const lapack_complex_float*") FloatBuffer du2,
                           @Const IntBuffer ipiv, float anorm, FloatBuffer rcond );
public static native int LAPACKE_cgtcon( @Cast("char") byte norm, int n,
                           @Cast("const lapack_complex_float*") float[] dl,
                           @Cast("const lapack_complex_float*") float[] d,
                           @Cast("const lapack_complex_float*") float[] du,
                           @Cast("const lapack_complex_float*") float[] du2,
                           @Const int[] ipiv, float anorm, float[] rcond );
public static native int LAPACKE_zgtcon( @Cast("char") byte norm, int n,
                           @Cast("const lapack_complex_double*") DoublePointer dl,
                           @Cast("const lapack_complex_double*") DoublePointer d,
                           @Cast("const lapack_complex_double*") DoublePointer du,
                           @Cast("const lapack_complex_double*") DoublePointer du2,
                           @Const IntPointer ipiv, double anorm,
                           DoublePointer rcond );
public static native int LAPACKE_zgtcon( @Cast("char") byte norm, int n,
                           @Cast("const lapack_complex_double*") DoubleBuffer dl,
                           @Cast("const lapack_complex_double*") DoubleBuffer d,
                           @Cast("const lapack_complex_double*") DoubleBuffer du,
                           @Cast("const lapack_complex_double*") DoubleBuffer du2,
                           @Const IntBuffer ipiv, double anorm,
                           DoubleBuffer rcond );
public static native int LAPACKE_zgtcon( @Cast("char") byte norm, int n,
                           @Cast("const lapack_complex_double*") double[] dl,
                           @Cast("const lapack_complex_double*") double[] d,
                           @Cast("const lapack_complex_double*") double[] du,
                           @Cast("const lapack_complex_double*") double[] du2,
                           @Const int[] ipiv, double anorm,
                           double[] rcond );

public static native int LAPACKE_sgtrfs( int matrix_layout, @Cast("char") byte trans, int n,
                           int nrhs, @Const FloatPointer dl, @Const FloatPointer d,
                           @Const FloatPointer du, @Const FloatPointer dlf, @Const FloatPointer df,
                           @Const FloatPointer duf, @Const FloatPointer du2,
                           @Const IntPointer ipiv, @Const FloatPointer b,
                           int ldb, FloatPointer x, int ldx,
                           FloatPointer ferr, FloatPointer berr );
public static native int LAPACKE_sgtrfs( int matrix_layout, @Cast("char") byte trans, int n,
                           int nrhs, @Const FloatBuffer dl, @Const FloatBuffer d,
                           @Const FloatBuffer du, @Const FloatBuffer dlf, @Const FloatBuffer df,
                           @Const FloatBuffer duf, @Const FloatBuffer du2,
                           @Const IntBuffer ipiv, @Const FloatBuffer b,
                           int ldb, FloatBuffer x, int ldx,
                           FloatBuffer ferr, FloatBuffer berr );
public static native int LAPACKE_sgtrfs( int matrix_layout, @Cast("char") byte trans, int n,
                           int nrhs, @Const float[] dl, @Const float[] d,
                           @Const float[] du, @Const float[] dlf, @Const float[] df,
                           @Const float[] duf, @Const float[] du2,
                           @Const int[] ipiv, @Const float[] b,
                           int ldb, float[] x, int ldx,
                           float[] ferr, float[] berr );
public static native int LAPACKE_dgtrfs( int matrix_layout, @Cast("char") byte trans, int n,
                           int nrhs, @Const DoublePointer dl, @Const DoublePointer d,
                           @Const DoublePointer du, @Const DoublePointer dlf,
                           @Const DoublePointer df, @Const DoublePointer duf,
                           @Const DoublePointer du2, @Const IntPointer ipiv,
                           @Const DoublePointer b, int ldb, DoublePointer x,
                           int ldx, DoublePointer ferr, DoublePointer berr );
public static native int LAPACKE_dgtrfs( int matrix_layout, @Cast("char") byte trans, int n,
                           int nrhs, @Const DoubleBuffer dl, @Const DoubleBuffer d,
                           @Const DoubleBuffer du, @Const DoubleBuffer dlf,
                           @Const DoubleBuffer df, @Const DoubleBuffer duf,
                           @Const DoubleBuffer du2, @Const IntBuffer ipiv,
                           @Const DoubleBuffer b, int ldb, DoubleBuffer x,
                           int ldx, DoubleBuffer ferr, DoubleBuffer berr );
public static native int LAPACKE_dgtrfs( int matrix_layout, @Cast("char") byte trans, int n,
                           int nrhs, @Const double[] dl, @Const double[] d,
                           @Const double[] du, @Const double[] dlf,
                           @Const double[] df, @Const double[] duf,
                           @Const double[] du2, @Const int[] ipiv,
                           @Const double[] b, int ldb, double[] x,
                           int ldx, double[] ferr, double[] berr );
public static native int LAPACKE_cgtrfs( int matrix_layout, @Cast("char") byte trans, int n,
                           int nrhs, @Cast("const lapack_complex_float*") FloatPointer dl,
                           @Cast("const lapack_complex_float*") FloatPointer d,
                           @Cast("const lapack_complex_float*") FloatPointer du,
                           @Cast("const lapack_complex_float*") FloatPointer dlf,
                           @Cast("const lapack_complex_float*") FloatPointer df,
                           @Cast("const lapack_complex_float*") FloatPointer duf,
                           @Cast("const lapack_complex_float*") FloatPointer du2,
                           @Const IntPointer ipiv,
                           @Cast("const lapack_complex_float*") FloatPointer b, int ldb,
                           @Cast("lapack_complex_float*") FloatPointer x, int ldx, FloatPointer ferr,
                           FloatPointer berr );
public static native int LAPACKE_cgtrfs( int matrix_layout, @Cast("char") byte trans, int n,
                           int nrhs, @Cast("const lapack_complex_float*") FloatBuffer dl,
                           @Cast("const lapack_complex_float*") FloatBuffer d,
                           @Cast("const lapack_complex_float*") FloatBuffer du,
                           @Cast("const lapack_complex_float*") FloatBuffer dlf,
                           @Cast("const lapack_complex_float*") FloatBuffer df,
                           @Cast("const lapack_complex_float*") FloatBuffer duf,
                           @Cast("const lapack_complex_float*") FloatBuffer du2,
                           @Const IntBuffer ipiv,
                           @Cast("const lapack_complex_float*") FloatBuffer b, int ldb,
                           @Cast("lapack_complex_float*") FloatBuffer x, int ldx, FloatBuffer ferr,
                           FloatBuffer berr );
public static native int LAPACKE_cgtrfs( int matrix_layout, @Cast("char") byte trans, int n,
                           int nrhs, @Cast("const lapack_complex_float*") float[] dl,
                           @Cast("const lapack_complex_float*") float[] d,
                           @Cast("const lapack_complex_float*") float[] du,
                           @Cast("const lapack_complex_float*") float[] dlf,
                           @Cast("const lapack_complex_float*") float[] df,
                           @Cast("const lapack_complex_float*") float[] duf,
                           @Cast("const lapack_complex_float*") float[] du2,
                           @Const int[] ipiv,
                           @Cast("const lapack_complex_float*") float[] b, int ldb,
                           @Cast("lapack_complex_float*") float[] x, int ldx, float[] ferr,
                           float[] berr );
public static native int LAPACKE_zgtrfs( int matrix_layout, @Cast("char") byte trans, int n,
                           int nrhs, @Cast("const lapack_complex_double*") DoublePointer dl,
                           @Cast("const lapack_complex_double*") DoublePointer d,
                           @Cast("const lapack_complex_double*") DoublePointer du,
                           @Cast("const lapack_complex_double*") DoublePointer dlf,
                           @Cast("const lapack_complex_double*") DoublePointer df,
                           @Cast("const lapack_complex_double*") DoublePointer duf,
                           @Cast("const lapack_complex_double*") DoublePointer du2,
                           @Const IntPointer ipiv,
                           @Cast("const lapack_complex_double*") DoublePointer b, int ldb,
                           @Cast("lapack_complex_double*") DoublePointer x, int ldx,
                           DoublePointer ferr, DoublePointer berr );
public static native int LAPACKE_zgtrfs( int matrix_layout, @Cast("char") byte trans, int n,
                           int nrhs, @Cast("const lapack_complex_double*") DoubleBuffer dl,
                           @Cast("const lapack_complex_double*") DoubleBuffer d,
                           @Cast("const lapack_complex_double*") DoubleBuffer du,
                           @Cast("const lapack_complex_double*") DoubleBuffer dlf,
                           @Cast("const lapack_complex_double*") DoubleBuffer df,
                           @Cast("const lapack_complex_double*") DoubleBuffer duf,
                           @Cast("const lapack_complex_double*") DoubleBuffer du2,
                           @Const IntBuffer ipiv,
                           @Cast("const lapack_complex_double*") DoubleBuffer b, int ldb,
                           @Cast("lapack_complex_double*") DoubleBuffer x, int ldx,
                           DoubleBuffer ferr, DoubleBuffer berr );
public static native int LAPACKE_zgtrfs( int matrix_layout, @Cast("char") byte trans, int n,
                           int nrhs, @Cast("const lapack_complex_double*") double[] dl,
                           @Cast("const lapack_complex_double*") double[] d,
                           @Cast("const lapack_complex_double*") double[] du,
                           @Cast("const lapack_complex_double*") double[] dlf,
                           @Cast("const lapack_complex_double*") double[] df,
                           @Cast("const lapack_complex_double*") double[] duf,
                           @Cast("const lapack_complex_double*") double[] du2,
                           @Const int[] ipiv,
                           @Cast("const lapack_complex_double*") double[] b, int ldb,
                           @Cast("lapack_complex_double*") double[] x, int ldx,
                           double[] ferr, double[] berr );

public static native int LAPACKE_sgtsv( int matrix_layout, int n, int nrhs,
                          FloatPointer dl, FloatPointer d, FloatPointer du, FloatPointer b,
                          int ldb );
public static native int LAPACKE_sgtsv( int matrix_layout, int n, int nrhs,
                          FloatBuffer dl, FloatBuffer d, FloatBuffer du, FloatBuffer b,
                          int ldb );
public static native int LAPACKE_sgtsv( int matrix_layout, int n, int nrhs,
                          float[] dl, float[] d, float[] du, float[] b,
                          int ldb );
public static native int LAPACKE_dgtsv( int matrix_layout, int n, int nrhs,
                          DoublePointer dl, DoublePointer d, DoublePointer du, DoublePointer b,
                          int ldb );
public static native int LAPACKE_dgtsv( int matrix_layout, int n, int nrhs,
                          DoubleBuffer dl, DoubleBuffer d, DoubleBuffer du, DoubleBuffer b,
                          int ldb );
public static native int LAPACKE_dgtsv( int matrix_layout, int n, int nrhs,
                          double[] dl, double[] d, double[] du, double[] b,
                          int ldb );
public static native int LAPACKE_cgtsv( int matrix_layout, int n, int nrhs,
                          @Cast("lapack_complex_float*") FloatPointer dl, @Cast("lapack_complex_float*") FloatPointer d,
                          @Cast("lapack_complex_float*") FloatPointer du, @Cast("lapack_complex_float*") FloatPointer b,
                          int ldb );
public static native int LAPACKE_cgtsv( int matrix_layout, int n, int nrhs,
                          @Cast("lapack_complex_float*") FloatBuffer dl, @Cast("lapack_complex_float*") FloatBuffer d,
                          @Cast("lapack_complex_float*") FloatBuffer du, @Cast("lapack_complex_float*") FloatBuffer b,
                          int ldb );
public static native int LAPACKE_cgtsv( int matrix_layout, int n, int nrhs,
                          @Cast("lapack_complex_float*") float[] dl, @Cast("lapack_complex_float*") float[] d,
                          @Cast("lapack_complex_float*") float[] du, @Cast("lapack_complex_float*") float[] b,
                          int ldb );
public static native int LAPACKE_zgtsv( int matrix_layout, int n, int nrhs,
                          @Cast("lapack_complex_double*") DoublePointer dl, @Cast("lapack_complex_double*") DoublePointer d,
                          @Cast("lapack_complex_double*") DoublePointer du, @Cast("lapack_complex_double*") DoublePointer b,
                          int ldb );
public static native int LAPACKE_zgtsv( int matrix_layout, int n, int nrhs,
                          @Cast("lapack_complex_double*") DoubleBuffer dl, @Cast("lapack_complex_double*") DoubleBuffer d,
                          @Cast("lapack_complex_double*") DoubleBuffer du, @Cast("lapack_complex_double*") DoubleBuffer b,
                          int ldb );
public static native int LAPACKE_zgtsv( int matrix_layout, int n, int nrhs,
                          @Cast("lapack_complex_double*") double[] dl, @Cast("lapack_complex_double*") double[] d,
                          @Cast("lapack_complex_double*") double[] du, @Cast("lapack_complex_double*") double[] b,
                          int ldb );

public static native int LAPACKE_sgtsvx( int matrix_layout, @Cast("char") byte fact, @Cast("char") byte trans,
                           int n, int nrhs, @Const FloatPointer dl,
                           @Const FloatPointer d, @Const FloatPointer du, FloatPointer dlf,
                           FloatPointer df, FloatPointer duf, FloatPointer du2, IntPointer ipiv,
                           @Const FloatPointer b, int ldb, FloatPointer x,
                           int ldx, FloatPointer rcond, FloatPointer ferr,
                           FloatPointer berr );
public static native int LAPACKE_sgtsvx( int matrix_layout, @Cast("char") byte fact, @Cast("char") byte trans,
                           int n, int nrhs, @Const FloatBuffer dl,
                           @Const FloatBuffer d, @Const FloatBuffer du, FloatBuffer dlf,
                           FloatBuffer df, FloatBuffer duf, FloatBuffer du2, IntBuffer ipiv,
                           @Const FloatBuffer b, int ldb, FloatBuffer x,
                           int ldx, FloatBuffer rcond, FloatBuffer ferr,
                           FloatBuffer berr );
public static native int LAPACKE_sgtsvx( int matrix_layout, @Cast("char") byte fact, @Cast("char") byte trans,
                           int n, int nrhs, @Const float[] dl,
                           @Const float[] d, @Const float[] du, float[] dlf,
                           float[] df, float[] duf, float[] du2, int[] ipiv,
                           @Const float[] b, int ldb, float[] x,
                           int ldx, float[] rcond, float[] ferr,
                           float[] berr );
public static native int LAPACKE_dgtsvx( int matrix_layout, @Cast("char") byte fact, @Cast("char") byte trans,
                           int n, int nrhs, @Const DoublePointer dl,
                           @Const DoublePointer d, @Const DoublePointer du, DoublePointer dlf,
                           DoublePointer df, DoublePointer duf, DoublePointer du2,
                           IntPointer ipiv, @Const DoublePointer b, int ldb,
                           DoublePointer x, int ldx, DoublePointer rcond,
                           DoublePointer ferr, DoublePointer berr );
public static native int LAPACKE_dgtsvx( int matrix_layout, @Cast("char") byte fact, @Cast("char") byte trans,
                           int n, int nrhs, @Const DoubleBuffer dl,
                           @Const DoubleBuffer d, @Const DoubleBuffer du, DoubleBuffer dlf,
                           DoubleBuffer df, DoubleBuffer duf, DoubleBuffer du2,
                           IntBuffer ipiv, @Const DoubleBuffer b, int ldb,
                           DoubleBuffer x, int ldx, DoubleBuffer rcond,
                           DoubleBuffer ferr, DoubleBuffer berr );
public static native int LAPACKE_dgtsvx( int matrix_layout, @Cast("char") byte fact, @Cast("char") byte trans,
                           int n, int nrhs, @Const double[] dl,
                           @Const double[] d, @Const double[] du, double[] dlf,
                           double[] df, double[] duf, double[] du2,
                           int[] ipiv, @Const double[] b, int ldb,
                           double[] x, int ldx, double[] rcond,
                           double[] ferr, double[] berr );
public static native int LAPACKE_cgtsvx( int matrix_layout, @Cast("char") byte fact, @Cast("char") byte trans,
                           int n, int nrhs,
                           @Cast("const lapack_complex_float*") FloatPointer dl,
                           @Cast("const lapack_complex_float*") FloatPointer d,
                           @Cast("const lapack_complex_float*") FloatPointer du,
                           @Cast("lapack_complex_float*") FloatPointer dlf, @Cast("lapack_complex_float*") FloatPointer df,
                           @Cast("lapack_complex_float*") FloatPointer duf, @Cast("lapack_complex_float*") FloatPointer du2,
                           IntPointer ipiv, @Cast("const lapack_complex_float*") FloatPointer b,
                           int ldb, @Cast("lapack_complex_float*") FloatPointer x,
                           int ldx, FloatPointer rcond, FloatPointer ferr,
                           FloatPointer berr );
public static native int LAPACKE_cgtsvx( int matrix_layout, @Cast("char") byte fact, @Cast("char") byte trans,
                           int n, int nrhs,
                           @Cast("const lapack_complex_float*") FloatBuffer dl,
                           @Cast("const lapack_complex_float*") FloatBuffer d,
                           @Cast("const lapack_complex_float*") FloatBuffer du,
                           @Cast("lapack_complex_float*") FloatBuffer dlf, @Cast("lapack_complex_float*") FloatBuffer df,
                           @Cast("lapack_complex_float*") FloatBuffer duf, @Cast("lapack_complex_float*") FloatBuffer du2,
                           IntBuffer ipiv, @Cast("const lapack_complex_float*") FloatBuffer b,
                           int ldb, @Cast("lapack_complex_float*") FloatBuffer x,
                           int ldx, FloatBuffer rcond, FloatBuffer ferr,
                           FloatBuffer berr );
public static native int LAPACKE_cgtsvx( int matrix_layout, @Cast("char") byte fact, @Cast("char") byte trans,
                           int n, int nrhs,
                           @Cast("const lapack_complex_float*") float[] dl,
                           @Cast("const lapack_complex_float*") float[] d,
                           @Cast("const lapack_complex_float*") float[] du,
                           @Cast("lapack_complex_float*") float[] dlf, @Cast("lapack_complex_float*") float[] df,
                           @Cast("lapack_complex_float*") float[] duf, @Cast("lapack_complex_float*") float[] du2,
                           int[] ipiv, @Cast("const lapack_complex_float*") float[] b,
                           int ldb, @Cast("lapack_complex_float*") float[] x,
                           int ldx, float[] rcond, float[] ferr,
                           float[] berr );
public static native int LAPACKE_zgtsvx( int matrix_layout, @Cast("char") byte fact, @Cast("char") byte trans,
                           int n, int nrhs,
                           @Cast("const lapack_complex_double*") DoublePointer dl,
                           @Cast("const lapack_complex_double*") DoublePointer d,
                           @Cast("const lapack_complex_double*") DoublePointer du,
                           @Cast("lapack_complex_double*") DoublePointer dlf,
                           @Cast("lapack_complex_double*") DoublePointer df,
                           @Cast("lapack_complex_double*") DoublePointer duf,
                           @Cast("lapack_complex_double*") DoublePointer du2, IntPointer ipiv,
                           @Cast("const lapack_complex_double*") DoublePointer b, int ldb,
                           @Cast("lapack_complex_double*") DoublePointer x, int ldx,
                           DoublePointer rcond, DoublePointer ferr, DoublePointer berr );
public static native int LAPACKE_zgtsvx( int matrix_layout, @Cast("char") byte fact, @Cast("char") byte trans,
                           int n, int nrhs,
                           @Cast("const lapack_complex_double*") DoubleBuffer dl,
                           @Cast("const lapack_complex_double*") DoubleBuffer d,
                           @Cast("const lapack_complex_double*") DoubleBuffer du,
                           @Cast("lapack_complex_double*") DoubleBuffer dlf,
                           @Cast("lapack_complex_double*") DoubleBuffer df,
                           @Cast("lapack_complex_double*") DoubleBuffer duf,
                           @Cast("lapack_complex_double*") DoubleBuffer du2, IntBuffer ipiv,
                           @Cast("const lapack_complex_double*") DoubleBuffer b, int ldb,
                           @Cast("lapack_complex_double*") DoubleBuffer x, int ldx,
                           DoubleBuffer rcond, DoubleBuffer ferr, DoubleBuffer berr );
public static native int LAPACKE_zgtsvx( int matrix_layout, @Cast("char") byte fact, @Cast("char") byte trans,
                           int n, int nrhs,
                           @Cast("const lapack_complex_double*") double[] dl,
                           @Cast("const lapack_complex_double*") double[] d,
                           @Cast("const lapack_complex_double*") double[] du,
                           @Cast("lapack_complex_double*") double[] dlf,
                           @Cast("lapack_complex_double*") double[] df,
                           @Cast("lapack_complex_double*") double[] duf,
                           @Cast("lapack_complex_double*") double[] du2, int[] ipiv,
                           @Cast("const lapack_complex_double*") double[] b, int ldb,
                           @Cast("lapack_complex_double*") double[] x, int ldx,
                           double[] rcond, double[] ferr, double[] berr );

public static native int LAPACKE_sgttrf( int n, FloatPointer dl, FloatPointer d, FloatPointer du,
                           FloatPointer du2, IntPointer ipiv );
public static native int LAPACKE_sgttrf( int n, FloatBuffer dl, FloatBuffer d, FloatBuffer du,
                           FloatBuffer du2, IntBuffer ipiv );
public static native int LAPACKE_sgttrf( int n, float[] dl, float[] d, float[] du,
                           float[] du2, int[] ipiv );
public static native int LAPACKE_dgttrf( int n, DoublePointer dl, DoublePointer d, DoublePointer du,
                           DoublePointer du2, IntPointer ipiv );
public static native int LAPACKE_dgttrf( int n, DoubleBuffer dl, DoubleBuffer d, DoubleBuffer du,
                           DoubleBuffer du2, IntBuffer ipiv );
public static native int LAPACKE_dgttrf( int n, double[] dl, double[] d, double[] du,
                           double[] du2, int[] ipiv );
public static native int LAPACKE_cgttrf( int n, @Cast("lapack_complex_float*") FloatPointer dl,
                           @Cast("lapack_complex_float*") FloatPointer d, @Cast("lapack_complex_float*") FloatPointer du,
                           @Cast("lapack_complex_float*") FloatPointer du2, IntPointer ipiv );
public static native int LAPACKE_cgttrf( int n, @Cast("lapack_complex_float*") FloatBuffer dl,
                           @Cast("lapack_complex_float*") FloatBuffer d, @Cast("lapack_complex_float*") FloatBuffer du,
                           @Cast("lapack_complex_float*") FloatBuffer du2, IntBuffer ipiv );
public static native int LAPACKE_cgttrf( int n, @Cast("lapack_complex_float*") float[] dl,
                           @Cast("lapack_complex_float*") float[] d, @Cast("lapack_complex_float*") float[] du,
                           @Cast("lapack_complex_float*") float[] du2, int[] ipiv );
public static native int LAPACKE_zgttrf( int n, @Cast("lapack_complex_double*") DoublePointer dl,
                           @Cast("lapack_complex_double*") DoublePointer d, @Cast("lapack_complex_double*") DoublePointer du,
                           @Cast("lapack_complex_double*") DoublePointer du2, IntPointer ipiv );
public static native int LAPACKE_zgttrf( int n, @Cast("lapack_complex_double*") DoubleBuffer dl,
                           @Cast("lapack_complex_double*") DoubleBuffer d, @Cast("lapack_complex_double*") DoubleBuffer du,
                           @Cast("lapack_complex_double*") DoubleBuffer du2, IntBuffer ipiv );
public static native int LAPACKE_zgttrf( int n, @Cast("lapack_complex_double*") double[] dl,
                           @Cast("lapack_complex_double*") double[] d, @Cast("lapack_complex_double*") double[] du,
                           @Cast("lapack_complex_double*") double[] du2, int[] ipiv );

public static native int LAPACKE_sgttrs( int matrix_layout, @Cast("char") byte trans, int n,
                           int nrhs, @Const FloatPointer dl, @Const FloatPointer d,
                           @Const FloatPointer du, @Const FloatPointer du2,
                           @Const IntPointer ipiv, FloatPointer b, int ldb );
public static native int LAPACKE_sgttrs( int matrix_layout, @Cast("char") byte trans, int n,
                           int nrhs, @Const FloatBuffer dl, @Const FloatBuffer d,
                           @Const FloatBuffer du, @Const FloatBuffer du2,
                           @Const IntBuffer ipiv, FloatBuffer b, int ldb );
public static native int LAPACKE_sgttrs( int matrix_layout, @Cast("char") byte trans, int n,
                           int nrhs, @Const float[] dl, @Const float[] d,
                           @Const float[] du, @Const float[] du2,
                           @Const int[] ipiv, float[] b, int ldb );
public static native int LAPACKE_dgttrs( int matrix_layout, @Cast("char") byte trans, int n,
                           int nrhs, @Const DoublePointer dl, @Const DoublePointer d,
                           @Const DoublePointer du, @Const DoublePointer du2,
                           @Const IntPointer ipiv, DoublePointer b, int ldb );
public static native int LAPACKE_dgttrs( int matrix_layout, @Cast("char") byte trans, int n,
                           int nrhs, @Const DoubleBuffer dl, @Const DoubleBuffer d,
                           @Const DoubleBuffer du, @Const DoubleBuffer du2,
                           @Const IntBuffer ipiv, DoubleBuffer b, int ldb );
public static native int LAPACKE_dgttrs( int matrix_layout, @Cast("char") byte trans, int n,
                           int nrhs, @Const double[] dl, @Const double[] d,
                           @Const double[] du, @Const double[] du2,
                           @Const int[] ipiv, double[] b, int ldb );
public static native int LAPACKE_cgttrs( int matrix_layout, @Cast("char") byte trans, int n,
                           int nrhs, @Cast("const lapack_complex_float*") FloatPointer dl,
                           @Cast("const lapack_complex_float*") FloatPointer d,
                           @Cast("const lapack_complex_float*") FloatPointer du,
                           @Cast("const lapack_complex_float*") FloatPointer du2,
                           @Const IntPointer ipiv, @Cast("lapack_complex_float*") FloatPointer b,
                           int ldb );
public static native int LAPACKE_cgttrs( int matrix_layout, @Cast("char") byte trans, int n,
                           int nrhs, @Cast("const lapack_complex_float*") FloatBuffer dl,
                           @Cast("const lapack_complex_float*") FloatBuffer d,
                           @Cast("const lapack_complex_float*") FloatBuffer du,
                           @Cast("const lapack_complex_float*") FloatBuffer du2,
                           @Const IntBuffer ipiv, @Cast("lapack_complex_float*") FloatBuffer b,
                           int ldb );
public static native int LAPACKE_cgttrs( int matrix_layout, @Cast("char") byte trans, int n,
                           int nrhs, @Cast("const lapack_complex_float*") float[] dl,
                           @Cast("const lapack_complex_float*") float[] d,
                           @Cast("const lapack_complex_float*") float[] du,
                           @Cast("const lapack_complex_float*") float[] du2,
                           @Const int[] ipiv, @Cast("lapack_complex_float*") float[] b,
                           int ldb );
public static native int LAPACKE_zgttrs( int matrix_layout, @Cast("char") byte trans, int n,
                           int nrhs, @Cast("const lapack_complex_double*") DoublePointer dl,
                           @Cast("const lapack_complex_double*") DoublePointer d,
                           @Cast("const lapack_complex_double*") DoublePointer du,
                           @Cast("const lapack_complex_double*") DoublePointer du2,
                           @Const IntPointer ipiv, @Cast("lapack_complex_double*") DoublePointer b,
                           int ldb );
public static native int LAPACKE_zgttrs( int matrix_layout, @Cast("char") byte trans, int n,
                           int nrhs, @Cast("const lapack_complex_double*") DoubleBuffer dl,
                           @Cast("const lapack_complex_double*") DoubleBuffer d,
                           @Cast("const lapack_complex_double*") DoubleBuffer du,
                           @Cast("const lapack_complex_double*") DoubleBuffer du2,
                           @Const IntBuffer ipiv, @Cast("lapack_complex_double*") DoubleBuffer b,
                           int ldb );
public static native int LAPACKE_zgttrs( int matrix_layout, @Cast("char") byte trans, int n,
                           int nrhs, @Cast("const lapack_complex_double*") double[] dl,
                           @Cast("const lapack_complex_double*") double[] d,
                           @Cast("const lapack_complex_double*") double[] du,
                           @Cast("const lapack_complex_double*") double[] du2,
                           @Const int[] ipiv, @Cast("lapack_complex_double*") double[] b,
                           int ldb );

public static native int LAPACKE_chbev( int matrix_layout, @Cast("char") byte jobz, @Cast("char") byte uplo, int n,
                          int kd, @Cast("lapack_complex_float*") FloatPointer ab,
                          int ldab, FloatPointer w, @Cast("lapack_complex_float*") FloatPointer z,
                          int ldz );
public static native int LAPACKE_chbev( int matrix_layout, @Cast("char") byte jobz, @Cast("char") byte uplo, int n,
                          int kd, @Cast("lapack_complex_float*") FloatBuffer ab,
                          int ldab, FloatBuffer w, @Cast("lapack_complex_float*") FloatBuffer z,
                          int ldz );
public static native int LAPACKE_chbev( int matrix_layout, @Cast("char") byte jobz, @Cast("char") byte uplo, int n,
                          int kd, @Cast("lapack_complex_float*") float[] ab,
                          int ldab, float[] w, @Cast("lapack_complex_float*") float[] z,
                          int ldz );
public static native int LAPACKE_zhbev( int matrix_layout, @Cast("char") byte jobz, @Cast("char") byte uplo, int n,
                          int kd, @Cast("lapack_complex_double*") DoublePointer ab,
                          int ldab, DoublePointer w, @Cast("lapack_complex_double*") DoublePointer z,
                          int ldz );
public static native int LAPACKE_zhbev( int matrix_layout, @Cast("char") byte jobz, @Cast("char") byte uplo, int n,
                          int kd, @Cast("lapack_complex_double*") DoubleBuffer ab,
                          int ldab, DoubleBuffer w, @Cast("lapack_complex_double*") DoubleBuffer z,
                          int ldz );
public static native int LAPACKE_zhbev( int matrix_layout, @Cast("char") byte jobz, @Cast("char") byte uplo, int n,
                          int kd, @Cast("lapack_complex_double*") double[] ab,
                          int ldab, double[] w, @Cast("lapack_complex_double*") double[] z,
                          int ldz );

public static native int LAPACKE_chbevd( int matrix_layout, @Cast("char") byte jobz, @Cast("char") byte uplo, int n,
                           int kd, @Cast("lapack_complex_float*") FloatPointer ab,
                           int ldab, FloatPointer w, @Cast("lapack_complex_float*") FloatPointer z,
                           int ldz );
public static native int LAPACKE_chbevd( int matrix_layout, @Cast("char") byte jobz, @Cast("char") byte uplo, int n,
                           int kd, @Cast("lapack_complex_float*") FloatBuffer ab,
                           int ldab, FloatBuffer w, @Cast("lapack_complex_float*") FloatBuffer z,
                           int ldz );
public static native int LAPACKE_chbevd( int matrix_layout, @Cast("char") byte jobz, @Cast("char") byte uplo, int n,
                           int kd, @Cast("lapack_complex_float*") float[] ab,
                           int ldab, float[] w, @Cast("lapack_complex_float*") float[] z,
                           int ldz );
public static native int LAPACKE_zhbevd( int matrix_layout, @Cast("char") byte jobz, @Cast("char") byte uplo, int n,
                           int kd, @Cast("lapack_complex_double*") DoublePointer ab,
                           int ldab, DoublePointer w, @Cast("lapack_complex_double*") DoublePointer z,
                           int ldz );
public static native int LAPACKE_zhbevd( int matrix_layout, @Cast("char") byte jobz, @Cast("char") byte uplo, int n,
                           int kd, @Cast("lapack_complex_double*") DoubleBuffer ab,
                           int ldab, DoubleBuffer w, @Cast("lapack_complex_double*") DoubleBuffer z,
                           int ldz );
public static native int LAPACKE_zhbevd( int matrix_layout, @Cast("char") byte jobz, @Cast("char") byte uplo, int n,
                           int kd, @Cast("lapack_complex_double*") double[] ab,
                           int ldab, double[] w, @Cast("lapack_complex_double*") double[] z,
                           int ldz );

public static native int LAPACKE_chbevx( int matrix_layout, @Cast("char") byte jobz, @Cast("char") byte range, @Cast("char") byte uplo,
                           int n, int kd,
                           @Cast("lapack_complex_float*") FloatPointer ab, int ldab,
                           @Cast("lapack_complex_float*") FloatPointer q, int ldq, float vl,
                           float vu, int il, int iu, float abstol,
                           IntPointer m, FloatPointer w, @Cast("lapack_complex_float*") FloatPointer z,
                           int ldz, IntPointer ifail );
public static native int LAPACKE_chbevx( int matrix_layout, @Cast("char") byte jobz, @Cast("char") byte range, @Cast("char") byte uplo,
                           int n, int kd,
                           @Cast("lapack_complex_float*") FloatBuffer ab, int ldab,
                           @Cast("lapack_complex_float*") FloatBuffer q, int ldq, float vl,
                           float vu, int il, int iu, float abstol,
                           IntBuffer m, FloatBuffer w, @Cast("lapack_complex_float*") FloatBuffer z,
                           int ldz, IntBuffer ifail );
public static native int LAPACKE_chbevx( int matrix_layout, @Cast("char") byte jobz, @Cast("char") byte range, @Cast("char") byte uplo,
                           int n, int kd,
                           @Cast("lapack_complex_float*") float[] ab, int ldab,
                           @Cast("lapack_complex_float*") float[] q, int ldq, float vl,
                           float vu, int il, int iu, float abstol,
                           int[] m, float[] w, @Cast("lapack_complex_float*") float[] z,
                           int ldz, int[] ifail );
public static native int LAPACKE_zhbevx( int matrix_layout, @Cast("char") byte jobz, @Cast("char") byte range, @Cast("char") byte uplo,
                           int n, int kd,
                           @Cast("lapack_complex_double*") DoublePointer ab, int ldab,
                           @Cast("lapack_complex_double*") DoublePointer q, int ldq, double vl,
                           double vu, int il, int iu,
                           double abstol, IntPointer m, DoublePointer w,
                           @Cast("lapack_complex_double*") DoublePointer z, int ldz,
                           IntPointer ifail );
public static native int LAPACKE_zhbevx( int matrix_layout, @Cast("char") byte jobz, @Cast("char") byte range, @Cast("char") byte uplo,
                           int n, int kd,
                           @Cast("lapack_complex_double*") DoubleBuffer ab, int ldab,
                           @Cast("lapack_complex_double*") DoubleBuffer q, int ldq, double vl,
                           double vu, int il, int iu,
                           double abstol, IntBuffer m, DoubleBuffer w,
                           @Cast("lapack_complex_double*") DoubleBuffer z, int ldz,
                           IntBuffer ifail );
public static native int LAPACKE_zhbevx( int matrix_layout, @Cast("char") byte jobz, @Cast("char") byte range, @Cast("char") byte uplo,
                           int n, int kd,
                           @Cast("lapack_complex_double*") double[] ab, int ldab,
                           @Cast("lapack_complex_double*") double[] q, int ldq, double vl,
                           double vu, int il, int iu,
                           double abstol, int[] m, double[] w,
                           @Cast("lapack_complex_double*") double[] z, int ldz,
                           int[] ifail );

public static native int LAPACKE_chbgst( int matrix_layout, @Cast("char") byte vect, @Cast("char") byte uplo, int n,
                           int ka, int kb,
                           @Cast("lapack_complex_float*") FloatPointer ab, int ldab,
                           @Cast("const lapack_complex_float*") FloatPointer bb, int ldbb,
                           @Cast("lapack_complex_float*") FloatPointer x, int ldx );
public static native int LAPACKE_chbgst( int matrix_layout, @Cast("char") byte vect, @Cast("char") byte uplo, int n,
                           int ka, int kb,
                           @Cast("lapack_complex_float*") FloatBuffer ab, int ldab,
                           @Cast("const lapack_complex_float*") FloatBuffer bb, int ldbb,
                           @Cast("lapack_complex_float*") FloatBuffer x, int ldx );
public static native int LAPACKE_chbgst( int matrix_layout, @Cast("char") byte vect, @Cast("char") byte uplo, int n,
                           int ka, int kb,
                           @Cast("lapack_complex_float*") float[] ab, int ldab,
                           @Cast("const lapack_complex_float*") float[] bb, int ldbb,
                           @Cast("lapack_complex_float*") float[] x, int ldx );
public static native int LAPACKE_zhbgst( int matrix_layout, @Cast("char") byte vect, @Cast("char") byte uplo, int n,
                           int ka, int kb,
                           @Cast("lapack_complex_double*") DoublePointer ab, int ldab,
                           @Cast("const lapack_complex_double*") DoublePointer bb, int ldbb,
                           @Cast("lapack_complex_double*") DoublePointer x, int ldx );
public static native int LAPACKE_zhbgst( int matrix_layout, @Cast("char") byte vect, @Cast("char") byte uplo, int n,
                           int ka, int kb,
                           @Cast("lapack_complex_double*") DoubleBuffer ab, int ldab,
                           @Cast("const lapack_complex_double*") DoubleBuffer bb, int ldbb,
                           @Cast("lapack_complex_double*") DoubleBuffer x, int ldx );
public static native int LAPACKE_zhbgst( int matrix_layout, @Cast("char") byte vect, @Cast("char") byte uplo, int n,
                           int ka, int kb,
                           @Cast("lapack_complex_double*") double[] ab, int ldab,
                           @Cast("const lapack_complex_double*") double[] bb, int ldbb,
                           @Cast("lapack_complex_double*") double[] x, int ldx );

public static native int LAPACKE_chbgv( int matrix_layout, @Cast("char") byte jobz, @Cast("char") byte uplo, int n,
                          int ka, int kb,
                          @Cast("lapack_complex_float*") FloatPointer ab, int ldab,
                          @Cast("lapack_complex_float*") FloatPointer bb, int ldbb, FloatPointer w,
                          @Cast("lapack_complex_float*") FloatPointer z, int ldz );
public static native int LAPACKE_chbgv( int matrix_layout, @Cast("char") byte jobz, @Cast("char") byte uplo, int n,
                          int ka, int kb,
                          @Cast("lapack_complex_float*") FloatBuffer ab, int ldab,
                          @Cast("lapack_complex_float*") FloatBuffer bb, int ldbb, FloatBuffer w,
                          @Cast("lapack_complex_float*") FloatBuffer z, int ldz );
public static native int LAPACKE_chbgv( int matrix_layout, @Cast("char") byte jobz, @Cast("char") byte uplo, int n,
                          int ka, int kb,
                          @Cast("lapack_complex_float*") float[] ab, int ldab,
                          @Cast("lapack_complex_float*") float[] bb, int ldbb, float[] w,
                          @Cast("lapack_complex_float*") float[] z, int ldz );
public static native int LAPACKE_zhbgv( int matrix_layout, @Cast("char") byte jobz, @Cast("char") byte uplo, int n,
                          int ka, int kb,
                          @Cast("lapack_complex_double*") DoublePointer ab, int ldab,
                          @Cast("lapack_complex_double*") DoublePointer bb, int ldbb, DoublePointer w,
                          @Cast("lapack_complex_double*") DoublePointer z, int ldz );
public static native int LAPACKE_zhbgv( int matrix_layout, @Cast("char") byte jobz, @Cast("char") byte uplo, int n,
                          int ka, int kb,
                          @Cast("lapack_complex_double*") DoubleBuffer ab, int ldab,
                          @Cast("lapack_complex_double*") DoubleBuffer bb, int ldbb, DoubleBuffer w,
                          @Cast("lapack_complex_double*") DoubleBuffer z, int ldz );
public static native int LAPACKE_zhbgv( int matrix_layout, @Cast("char") byte jobz, @Cast("char") byte uplo, int n,
                          int ka, int kb,
                          @Cast("lapack_complex_double*") double[] ab, int ldab,
                          @Cast("lapack_complex_double*") double[] bb, int ldbb, double[] w,
                          @Cast("lapack_complex_double*") double[] z, int ldz );

public static native int LAPACKE_chbgvd( int matrix_layout, @Cast("char") byte jobz, @Cast("char") byte uplo, int n,
                           int ka, int kb,
                           @Cast("lapack_complex_float*") FloatPointer ab, int ldab,
                           @Cast("lapack_complex_float*") FloatPointer bb, int ldbb, FloatPointer w,
                           @Cast("lapack_complex_float*") FloatPointer z, int ldz );
public static native int LAPACKE_chbgvd( int matrix_layout, @Cast("char") byte jobz, @Cast("char") byte uplo, int n,
                           int ka, int kb,
                           @Cast("lapack_complex_float*") FloatBuffer ab, int ldab,
                           @Cast("lapack_complex_float*") FloatBuffer bb, int ldbb, FloatBuffer w,
                           @Cast("lapack_complex_float*") FloatBuffer z, int ldz );
public static native int LAPACKE_chbgvd( int matrix_layout, @Cast("char") byte jobz, @Cast("char") byte uplo, int n,
                           int ka, int kb,
                           @Cast("lapack_complex_float*") float[] ab, int ldab,
                           @Cast("lapack_complex_float*") float[] bb, int ldbb, float[] w,
                           @Cast("lapack_complex_float*") float[] z, int ldz );
public static native int LAPACKE_zhbgvd( int matrix_layout, @Cast("char") byte jobz, @Cast("char") byte uplo, int n,
                           int ka, int kb,
                           @Cast("lapack_complex_double*") DoublePointer ab, int ldab,
                           @Cast("lapack_complex_double*") DoublePointer bb, int ldbb,
                           DoublePointer w, @Cast("lapack_complex_double*") DoublePointer z,
                           int ldz );
public static native int LAPACKE_zhbgvd( int matrix_layout, @Cast("char") byte jobz, @Cast("char") byte uplo, int n,
                           int ka, int kb,
                           @Cast("lapack_complex_double*") DoubleBuffer ab, int ldab,
                           @Cast("lapack_complex_double*") DoubleBuffer bb, int ldbb,
                           DoubleBuffer w, @Cast("lapack_complex_double*") DoubleBuffer z,
                           int ldz );
public static native int LAPACKE_zhbgvd( int matrix_layout, @Cast("char") byte jobz, @Cast("char") byte uplo, int n,
                           int ka, int kb,
                           @Cast("lapack_complex_double*") double[] ab, int ldab,
                           @Cast("lapack_complex_double*") double[] bb, int ldbb,
                           double[] w, @Cast("lapack_complex_double*") double[] z,
                           int ldz );

public static native int LAPACKE_chbgvx( int matrix_layout, @Cast("char") byte jobz, @Cast("char") byte range, @Cast("char") byte uplo,
                           int n, int ka, int kb,
                           @Cast("lapack_complex_float*") FloatPointer ab, int ldab,
                           @Cast("lapack_complex_float*") FloatPointer bb, int ldbb,
                           @Cast("lapack_complex_float*") FloatPointer q, int ldq, float vl,
                           float vu, int il, int iu, float abstol,
                           IntPointer m, FloatPointer w, @Cast("lapack_complex_float*") FloatPointer z,
                           int ldz, IntPointer ifail );
public static native int LAPACKE_chbgvx( int matrix_layout, @Cast("char") byte jobz, @Cast("char") byte range, @Cast("char") byte uplo,
                           int n, int ka, int kb,
                           @Cast("lapack_complex_float*") FloatBuffer ab, int ldab,
                           @Cast("lapack_complex_float*") FloatBuffer bb, int ldbb,
                           @Cast("lapack_complex_float*") FloatBuffer q, int ldq, float vl,
                           float vu, int il, int iu, float abstol,
                           IntBuffer m, FloatBuffer w, @Cast("lapack_complex_float*") FloatBuffer z,
                           int ldz, IntBuffer ifail );
public static native int LAPACKE_chbgvx( int matrix_layout, @Cast("char") byte jobz, @Cast("char") byte range, @Cast("char") byte uplo,
                           int n, int ka, int kb,
                           @Cast("lapack_complex_float*") float[] ab, int ldab,
                           @Cast("lapack_complex_float*") float[] bb, int ldbb,
                           @Cast("lapack_complex_float*") float[] q, int ldq, float vl,
                           float vu, int il, int iu, float abstol,
                           int[] m, float[] w, @Cast("lapack_complex_float*") float[] z,
                           int ldz, int[] ifail );
public static native int LAPACKE_zhbgvx( int matrix_layout, @Cast("char") byte jobz, @Cast("char") byte range, @Cast("char") byte uplo,
                           int n, int ka, int kb,
                           @Cast("lapack_complex_double*") DoublePointer ab, int ldab,
                           @Cast("lapack_complex_double*") DoublePointer bb, int ldbb,
                           @Cast("lapack_complex_double*") DoublePointer q, int ldq, double vl,
                           double vu, int il, int iu,
                           double abstol, IntPointer m, DoublePointer w,
                           @Cast("lapack_complex_double*") DoublePointer z, int ldz,
                           IntPointer ifail );
public static native int LAPACKE_zhbgvx( int matrix_layout, @Cast("char") byte jobz, @Cast("char") byte range, @Cast("char") byte uplo,
                           int n, int ka, int kb,
                           @Cast("lapack_complex_double*") DoubleBuffer ab, int ldab,
                           @Cast("lapack_complex_double*") DoubleBuffer bb, int ldbb,
                           @Cast("lapack_complex_double*") DoubleBuffer q, int ldq, double vl,
                           double vu, int il, int iu,
                           double abstol, IntBuffer m, DoubleBuffer w,
                           @Cast("lapack_complex_double*") DoubleBuffer z, int ldz,
                           IntBuffer ifail );
public static native int LAPACKE_zhbgvx( int matrix_layout, @Cast("char") byte jobz, @Cast("char") byte range, @Cast("char") byte uplo,
                           int n, int ka, int kb,
                           @Cast("lapack_complex_double*") double[] ab, int ldab,
                           @Cast("lapack_complex_double*") double[] bb, int ldbb,
                           @Cast("lapack_complex_double*") double[] q, int ldq, double vl,
                           double vu, int il, int iu,
                           double abstol, int[] m, double[] w,
                           @Cast("lapack_complex_double*") double[] z, int ldz,
                           int[] ifail );

public static native int LAPACKE_chbtrd( int matrix_layout, @Cast("char") byte vect, @Cast("char") byte uplo, int n,
                           int kd, @Cast("lapack_complex_float*") FloatPointer ab,
                           int ldab, FloatPointer d, FloatPointer e,
                           @Cast("lapack_complex_float*") FloatPointer q, int ldq );
public static native int LAPACKE_chbtrd( int matrix_layout, @Cast("char") byte vect, @Cast("char") byte uplo, int n,
                           int kd, @Cast("lapack_complex_float*") FloatBuffer ab,
                           int ldab, FloatBuffer d, FloatBuffer e,
                           @Cast("lapack_complex_float*") FloatBuffer q, int ldq );
public static native int LAPACKE_chbtrd( int matrix_layout, @Cast("char") byte vect, @Cast("char") byte uplo, int n,
                           int kd, @Cast("lapack_complex_float*") float[] ab,
                           int ldab, float[] d, float[] e,
                           @Cast("lapack_complex_float*") float[] q, int ldq );
public static native int LAPACKE_zhbtrd( int matrix_layout, @Cast("char") byte vect, @Cast("char") byte uplo, int n,
                           int kd, @Cast("lapack_complex_double*") DoublePointer ab,
                           int ldab, DoublePointer d, DoublePointer e,
                           @Cast("lapack_complex_double*") DoublePointer q, int ldq );
public static native int LAPACKE_zhbtrd( int matrix_layout, @Cast("char") byte vect, @Cast("char") byte uplo, int n,
                           int kd, @Cast("lapack_complex_double*") DoubleBuffer ab,
                           int ldab, DoubleBuffer d, DoubleBuffer e,
                           @Cast("lapack_complex_double*") DoubleBuffer q, int ldq );
public static native int LAPACKE_zhbtrd( int matrix_layout, @Cast("char") byte vect, @Cast("char") byte uplo, int n,
                           int kd, @Cast("lapack_complex_double*") double[] ab,
                           int ldab, double[] d, double[] e,
                           @Cast("lapack_complex_double*") double[] q, int ldq );

public static native int LAPACKE_checon( int matrix_layout, @Cast("char") byte uplo, int n,
                           @Cast("const lapack_complex_float*") FloatPointer a, int lda,
                           @Const IntPointer ipiv, float anorm, FloatPointer rcond );
public static native int LAPACKE_checon( int matrix_layout, @Cast("char") byte uplo, int n,
                           @Cast("const lapack_complex_float*") FloatBuffer a, int lda,
                           @Const IntBuffer ipiv, float anorm, FloatBuffer rcond );
public static native int LAPACKE_checon( int matrix_layout, @Cast("char") byte uplo, int n,
                           @Cast("const lapack_complex_float*") float[] a, int lda,
                           @Const int[] ipiv, float anorm, float[] rcond );
public static native int LAPACKE_zhecon( int matrix_layout, @Cast("char") byte uplo, int n,
                           @Cast("const lapack_complex_double*") DoublePointer a, int lda,
                           @Const IntPointer ipiv, double anorm,
                           DoublePointer rcond );
public static native int LAPACKE_zhecon( int matrix_layout, @Cast("char") byte uplo, int n,
                           @Cast("const lapack_complex_double*") DoubleBuffer a, int lda,
                           @Const IntBuffer ipiv, double anorm,
                           DoubleBuffer rcond );
public static native int LAPACKE_zhecon( int matrix_layout, @Cast("char") byte uplo, int n,
                           @Cast("const lapack_complex_double*") double[] a, int lda,
                           @Const int[] ipiv, double anorm,
                           double[] rcond );

public static native int LAPACKE_cheequb( int matrix_layout, @Cast("char") byte uplo, int n,
                            @Cast("const lapack_complex_float*") FloatPointer a, int lda,
                            FloatPointer s, FloatPointer scond, FloatPointer amax );
public static native int LAPACKE_cheequb( int matrix_layout, @Cast("char") byte uplo, int n,
                            @Cast("const lapack_complex_float*") FloatBuffer a, int lda,
                            FloatBuffer s, FloatBuffer scond, FloatBuffer amax );
public static native int LAPACKE_cheequb( int matrix_layout, @Cast("char") byte uplo, int n,
                            @Cast("const lapack_complex_float*") float[] a, int lda,
                            float[] s, float[] scond, float[] amax );
public static native int LAPACKE_zheequb( int matrix_layout, @Cast("char") byte uplo, int n,
                            @Cast("const lapack_complex_double*") DoublePointer a, int lda,
                            DoublePointer s, DoublePointer scond, DoublePointer amax );
public static native int LAPACKE_zheequb( int matrix_layout, @Cast("char") byte uplo, int n,
                            @Cast("const lapack_complex_double*") DoubleBuffer a, int lda,
                            DoubleBuffer s, DoubleBuffer scond, DoubleBuffer amax );
public static native int LAPACKE_zheequb( int matrix_layout, @Cast("char") byte uplo, int n,
                            @Cast("const lapack_complex_double*") double[] a, int lda,
                            double[] s, double[] scond, double[] amax );

public static native int LAPACKE_cheev( int matrix_layout, @Cast("char") byte jobz, @Cast("char") byte uplo, int n,
                          @Cast("lapack_complex_float*") FloatPointer a, int lda, FloatPointer w );
public static native int LAPACKE_cheev( int matrix_layout, @Cast("char") byte jobz, @Cast("char") byte uplo, int n,
                          @Cast("lapack_complex_float*") FloatBuffer a, int lda, FloatBuffer w );
public static native int LAPACKE_cheev( int matrix_layout, @Cast("char") byte jobz, @Cast("char") byte uplo, int n,
                          @Cast("lapack_complex_float*") float[] a, int lda, float[] w );
public static native int LAPACKE_zheev( int matrix_layout, @Cast("char") byte jobz, @Cast("char") byte uplo, int n,
                          @Cast("lapack_complex_double*") DoublePointer a, int lda, DoublePointer w );
public static native int LAPACKE_zheev( int matrix_layout, @Cast("char") byte jobz, @Cast("char") byte uplo, int n,
                          @Cast("lapack_complex_double*") DoubleBuffer a, int lda, DoubleBuffer w );
public static native int LAPACKE_zheev( int matrix_layout, @Cast("char") byte jobz, @Cast("char") byte uplo, int n,
                          @Cast("lapack_complex_double*") double[] a, int lda, double[] w );

public static native int LAPACKE_cheevd( int matrix_layout, @Cast("char") byte jobz, @Cast("char") byte uplo, int n,
                           @Cast("lapack_complex_float*") FloatPointer a, int lda, FloatPointer w );
public static native int LAPACKE_cheevd( int matrix_layout, @Cast("char") byte jobz, @Cast("char") byte uplo, int n,
                           @Cast("lapack_complex_float*") FloatBuffer a, int lda, FloatBuffer w );
public static native int LAPACKE_cheevd( int matrix_layout, @Cast("char") byte jobz, @Cast("char") byte uplo, int n,
                           @Cast("lapack_complex_float*") float[] a, int lda, float[] w );
public static native int LAPACKE_zheevd( int matrix_layout, @Cast("char") byte jobz, @Cast("char") byte uplo, int n,
                           @Cast("lapack_complex_double*") DoublePointer a, int lda,
                           DoublePointer w );
public static native int LAPACKE_zheevd( int matrix_layout, @Cast("char") byte jobz, @Cast("char") byte uplo, int n,
                           @Cast("lapack_complex_double*") DoubleBuffer a, int lda,
                           DoubleBuffer w );
public static native int LAPACKE_zheevd( int matrix_layout, @Cast("char") byte jobz, @Cast("char") byte uplo, int n,
                           @Cast("lapack_complex_double*") double[] a, int lda,
                           double[] w );

public static native int LAPACKE_cheevr( int matrix_layout, @Cast("char") byte jobz, @Cast("char") byte range, @Cast("char") byte uplo,
                           int n, @Cast("lapack_complex_float*") FloatPointer a,
                           int lda, float vl, float vu, int il,
                           int iu, float abstol, IntPointer m, FloatPointer w,
                           @Cast("lapack_complex_float*") FloatPointer z, int ldz,
                           IntPointer isuppz );
public static native int LAPACKE_cheevr( int matrix_layout, @Cast("char") byte jobz, @Cast("char") byte range, @Cast("char") byte uplo,
                           int n, @Cast("lapack_complex_float*") FloatBuffer a,
                           int lda, float vl, float vu, int il,
                           int iu, float abstol, IntBuffer m, FloatBuffer w,
                           @Cast("lapack_complex_float*") FloatBuffer z, int ldz,
                           IntBuffer isuppz );
public static native int LAPACKE_cheevr( int matrix_layout, @Cast("char") byte jobz, @Cast("char") byte range, @Cast("char") byte uplo,
                           int n, @Cast("lapack_complex_float*") float[] a,
                           int lda, float vl, float vu, int il,
                           int iu, float abstol, int[] m, float[] w,
                           @Cast("lapack_complex_float*") float[] z, int ldz,
                           int[] isuppz );
public static native int LAPACKE_zheevr( int matrix_layout, @Cast("char") byte jobz, @Cast("char") byte range, @Cast("char") byte uplo,
                           int n, @Cast("lapack_complex_double*") DoublePointer a,
                           int lda, double vl, double vu, int il,
                           int iu, double abstol, IntPointer m,
                           DoublePointer w, @Cast("lapack_complex_double*") DoublePointer z, int ldz,
                           IntPointer isuppz );
public static native int LAPACKE_zheevr( int matrix_layout, @Cast("char") byte jobz, @Cast("char") byte range, @Cast("char") byte uplo,
                           int n, @Cast("lapack_complex_double*") DoubleBuffer a,
                           int lda, double vl, double vu, int il,
                           int iu, double abstol, IntBuffer m,
                           DoubleBuffer w, @Cast("lapack_complex_double*") DoubleBuffer z, int ldz,
                           IntBuffer isuppz );
public static native int LAPACKE_zheevr( int matrix_layout, @Cast("char") byte jobz, @Cast("char") byte range, @Cast("char") byte uplo,
                           int n, @Cast("lapack_complex_double*") double[] a,
                           int lda, double vl, double vu, int il,
                           int iu, double abstol, int[] m,
                           double[] w, @Cast("lapack_complex_double*") double[] z, int ldz,
                           int[] isuppz );

public static native int LAPACKE_cheevx( int matrix_layout, @Cast("char") byte jobz, @Cast("char") byte range, @Cast("char") byte uplo,
                           int n, @Cast("lapack_complex_float*") FloatPointer a,
                           int lda, float vl, float vu, int il,
                           int iu, float abstol, IntPointer m, FloatPointer w,
                           @Cast("lapack_complex_float*") FloatPointer z, int ldz,
                           IntPointer ifail );
public static native int LAPACKE_cheevx( int matrix_layout, @Cast("char") byte jobz, @Cast("char") byte range, @Cast("char") byte uplo,
                           int n, @Cast("lapack_complex_float*") FloatBuffer a,
                           int lda, float vl, float vu, int il,
                           int iu, float abstol, IntBuffer m, FloatBuffer w,
                           @Cast("lapack_complex_float*") FloatBuffer z, int ldz,
                           IntBuffer ifail );
public static native int LAPACKE_cheevx( int matrix_layout, @Cast("char") byte jobz, @Cast("char") byte range, @Cast("char") byte uplo,
                           int n, @Cast("lapack_complex_float*") float[] a,
                           int lda, float vl, float vu, int il,
                           int iu, float abstol, int[] m, float[] w,
                           @Cast("lapack_complex_float*") float[] z, int ldz,
                           int[] ifail );
public static native int LAPACKE_zheevx( int matrix_layout, @Cast("char") byte jobz, @Cast("char") byte range, @Cast("char") byte uplo,
                           int n, @Cast("lapack_complex_double*") DoublePointer a,
                           int lda, double vl, double vu, int il,
                           int iu, double abstol, IntPointer m,
                           DoublePointer w, @Cast("lapack_complex_double*") DoublePointer z, int ldz,
                           IntPointer ifail );
public static native int LAPACKE_zheevx( int matrix_layout, @Cast("char") byte jobz, @Cast("char") byte range, @Cast("char") byte uplo,
                           int n, @Cast("lapack_complex_double*") DoubleBuffer a,
                           int lda, double vl, double vu, int il,
                           int iu, double abstol, IntBuffer m,
                           DoubleBuffer w, @Cast("lapack_complex_double*") DoubleBuffer z, int ldz,
                           IntBuffer ifail );
public static native int LAPACKE_zheevx( int matrix_layout, @Cast("char") byte jobz, @Cast("char") byte range, @Cast("char") byte uplo,
                           int n, @Cast("lapack_complex_double*") double[] a,
                           int lda, double vl, double vu, int il,
                           int iu, double abstol, int[] m,
                           double[] w, @Cast("lapack_complex_double*") double[] z, int ldz,
                           int[] ifail );

public static native int LAPACKE_chegst( int matrix_layout, int itype, @Cast("char") byte uplo,
                           int n, @Cast("lapack_complex_float*") FloatPointer a,
                           int lda, @Cast("const lapack_complex_float*") FloatPointer b,
                           int ldb );
public static native int LAPACKE_chegst( int matrix_layout, int itype, @Cast("char") byte uplo,
                           int n, @Cast("lapack_complex_float*") FloatBuffer a,
                           int lda, @Cast("const lapack_complex_float*") FloatBuffer b,
                           int ldb );
public static native int LAPACKE_chegst( int matrix_layout, int itype, @Cast("char") byte uplo,
                           int n, @Cast("lapack_complex_float*") float[] a,
                           int lda, @Cast("const lapack_complex_float*") float[] b,
                           int ldb );
public static native int LAPACKE_zhegst( int matrix_layout, int itype, @Cast("char") byte uplo,
                           int n, @Cast("lapack_complex_double*") DoublePointer a,
                           int lda, @Cast("const lapack_complex_double*") DoublePointer b,
                           int ldb );
public static native int LAPACKE_zhegst( int matrix_layout, int itype, @Cast("char") byte uplo,
                           int n, @Cast("lapack_complex_double*") DoubleBuffer a,
                           int lda, @Cast("const lapack_complex_double*") DoubleBuffer b,
                           int ldb );
public static native int LAPACKE_zhegst( int matrix_layout, int itype, @Cast("char") byte uplo,
                           int n, @Cast("lapack_complex_double*") double[] a,
                           int lda, @Cast("const lapack_complex_double*") double[] b,
                           int ldb );

public static native int LAPACKE_chegv( int matrix_layout, int itype, @Cast("char") byte jobz,
                          @Cast("char") byte uplo, int n, @Cast("lapack_complex_float*") FloatPointer a,
                          int lda, @Cast("lapack_complex_float*") FloatPointer b,
                          int ldb, FloatPointer w );
public static native int LAPACKE_chegv( int matrix_layout, int itype, @Cast("char") byte jobz,
                          @Cast("char") byte uplo, int n, @Cast("lapack_complex_float*") FloatBuffer a,
                          int lda, @Cast("lapack_complex_float*") FloatBuffer b,
                          int ldb, FloatBuffer w );
public static native int LAPACKE_chegv( int matrix_layout, int itype, @Cast("char") byte jobz,
                          @Cast("char") byte uplo, int n, @Cast("lapack_complex_float*") float[] a,
                          int lda, @Cast("lapack_complex_float*") float[] b,
                          int ldb, float[] w );
public static native int LAPACKE_zhegv( int matrix_layout, int itype, @Cast("char") byte jobz,
                          @Cast("char") byte uplo, int n, @Cast("lapack_complex_double*") DoublePointer a,
                          int lda, @Cast("lapack_complex_double*") DoublePointer b,
                          int ldb, DoublePointer w );
public static native int LAPACKE_zhegv( int matrix_layout, int itype, @Cast("char") byte jobz,
                          @Cast("char") byte uplo, int n, @Cast("lapack_complex_double*") DoubleBuffer a,
                          int lda, @Cast("lapack_complex_double*") DoubleBuffer b,
                          int ldb, DoubleBuffer w );
public static native int LAPACKE_zhegv( int matrix_layout, int itype, @Cast("char") byte jobz,
                          @Cast("char") byte uplo, int n, @Cast("lapack_complex_double*") double[] a,
                          int lda, @Cast("lapack_complex_double*") double[] b,
                          int ldb, double[] w );

public static native int LAPACKE_chegvd( int matrix_layout, int itype, @Cast("char") byte jobz,
                           @Cast("char") byte uplo, int n, @Cast("lapack_complex_float*") FloatPointer a,
                           int lda, @Cast("lapack_complex_float*") FloatPointer b,
                           int ldb, FloatPointer w );
public static native int LAPACKE_chegvd( int matrix_layout, int itype, @Cast("char") byte jobz,
                           @Cast("char") byte uplo, int n, @Cast("lapack_complex_float*") FloatBuffer a,
                           int lda, @Cast("lapack_complex_float*") FloatBuffer b,
                           int ldb, FloatBuffer w );
public static native int LAPACKE_chegvd( int matrix_layout, int itype, @Cast("char") byte jobz,
                           @Cast("char") byte uplo, int n, @Cast("lapack_complex_float*") float[] a,
                           int lda, @Cast("lapack_complex_float*") float[] b,
                           int ldb, float[] w );
public static native int LAPACKE_zhegvd( int matrix_layout, int itype, @Cast("char") byte jobz,
                           @Cast("char") byte uplo, int n, @Cast("lapack_complex_double*") DoublePointer a,
                           int lda, @Cast("lapack_complex_double*") DoublePointer b,
                           int ldb, DoublePointer w );
public static native int LAPACKE_zhegvd( int matrix_layout, int itype, @Cast("char") byte jobz,
                           @Cast("char") byte uplo, int n, @Cast("lapack_complex_double*") DoubleBuffer a,
                           int lda, @Cast("lapack_complex_double*") DoubleBuffer b,
                           int ldb, DoubleBuffer w );
public static native int LAPACKE_zhegvd( int matrix_layout, int itype, @Cast("char") byte jobz,
                           @Cast("char") byte uplo, int n, @Cast("lapack_complex_double*") double[] a,
                           int lda, @Cast("lapack_complex_double*") double[] b,
                           int ldb, double[] w );

public static native int LAPACKE_chegvx( int matrix_layout, int itype, @Cast("char") byte jobz,
                           @Cast("char") byte range, @Cast("char") byte uplo, int n,
                           @Cast("lapack_complex_float*") FloatPointer a, int lda,
                           @Cast("lapack_complex_float*") FloatPointer b, int ldb, float vl,
                           float vu, int il, int iu, float abstol,
                           IntPointer m, FloatPointer w, @Cast("lapack_complex_float*") FloatPointer z,
                           int ldz, IntPointer ifail );
public static native int LAPACKE_chegvx( int matrix_layout, int itype, @Cast("char") byte jobz,
                           @Cast("char") byte range, @Cast("char") byte uplo, int n,
                           @Cast("lapack_complex_float*") FloatBuffer a, int lda,
                           @Cast("lapack_complex_float*") FloatBuffer b, int ldb, float vl,
                           float vu, int il, int iu, float abstol,
                           IntBuffer m, FloatBuffer w, @Cast("lapack_complex_float*") FloatBuffer z,
                           int ldz, IntBuffer ifail );
public static native int LAPACKE_chegvx( int matrix_layout, int itype, @Cast("char") byte jobz,
                           @Cast("char") byte range, @Cast("char") byte uplo, int n,
                           @Cast("lapack_complex_float*") float[] a, int lda,
                           @Cast("lapack_complex_float*") float[] b, int ldb, float vl,
                           float vu, int il, int iu, float abstol,
                           int[] m, float[] w, @Cast("lapack_complex_float*") float[] z,
                           int ldz, int[] ifail );
public static native int LAPACKE_zhegvx( int matrix_layout, int itype, @Cast("char") byte jobz,
                           @Cast("char") byte range, @Cast("char") byte uplo, int n,
                           @Cast("lapack_complex_double*") DoublePointer a, int lda,
                           @Cast("lapack_complex_double*") DoublePointer b, int ldb, double vl,
                           double vu, int il, int iu,
                           double abstol, IntPointer m, DoublePointer w,
                           @Cast("lapack_complex_double*") DoublePointer z, int ldz,
                           IntPointer ifail );
public static native int LAPACKE_zhegvx( int matrix_layout, int itype, @Cast("char") byte jobz,
                           @Cast("char") byte range, @Cast("char") byte uplo, int n,
                           @Cast("lapack_complex_double*") DoubleBuffer a, int lda,
                           @Cast("lapack_complex_double*") DoubleBuffer b, int ldb, double vl,
                           double vu, int il, int iu,
                           double abstol, IntBuffer m, DoubleBuffer w,
                           @Cast("lapack_complex_double*") DoubleBuffer z, int ldz,
                           IntBuffer ifail );
public static native int LAPACKE_zhegvx( int matrix_layout, int itype, @Cast("char") byte jobz,
                           @Cast("char") byte range, @Cast("char") byte uplo, int n,
                           @Cast("lapack_complex_double*") double[] a, int lda,
                           @Cast("lapack_complex_double*") double[] b, int ldb, double vl,
                           double vu, int il, int iu,
                           double abstol, int[] m, double[] w,
                           @Cast("lapack_complex_double*") double[] z, int ldz,
                           int[] ifail );

public static native int LAPACKE_cherfs( int matrix_layout, @Cast("char") byte uplo, int n,
                           int nrhs, @Cast("const lapack_complex_float*") FloatPointer a,
                           int lda, @Cast("const lapack_complex_float*") FloatPointer af,
                           int ldaf, @Const IntPointer ipiv,
                           @Cast("const lapack_complex_float*") FloatPointer b, int ldb,
                           @Cast("lapack_complex_float*") FloatPointer x, int ldx, FloatPointer ferr,
                           FloatPointer berr );
public static native int LAPACKE_cherfs( int matrix_layout, @Cast("char") byte uplo, int n,
                           int nrhs, @Cast("const lapack_complex_float*") FloatBuffer a,
                           int lda, @Cast("const lapack_complex_float*") FloatBuffer af,
                           int ldaf, @Const IntBuffer ipiv,
                           @Cast("const lapack_complex_float*") FloatBuffer b, int ldb,
                           @Cast("lapack_complex_float*") FloatBuffer x, int ldx, FloatBuffer ferr,
                           FloatBuffer berr );
public static native int LAPACKE_cherfs( int matrix_layout, @Cast("char") byte uplo, int n,
                           int nrhs, @Cast("const lapack_complex_float*") float[] a,
                           int lda, @Cast("const lapack_complex_float*") float[] af,
                           int ldaf, @Const int[] ipiv,
                           @Cast("const lapack_complex_float*") float[] b, int ldb,
                           @Cast("lapack_complex_float*") float[] x, int ldx, float[] ferr,
                           float[] berr );
public static native int LAPACKE_zherfs( int matrix_layout, @Cast("char") byte uplo, int n,
                           int nrhs, @Cast("const lapack_complex_double*") DoublePointer a,
                           int lda, @Cast("const lapack_complex_double*") DoublePointer af,
                           int ldaf, @Const IntPointer ipiv,
                           @Cast("const lapack_complex_double*") DoublePointer b, int ldb,
                           @Cast("lapack_complex_double*") DoublePointer x, int ldx,
                           DoublePointer ferr, DoublePointer berr );
public static native int LAPACKE_zherfs( int matrix_layout, @Cast("char") byte uplo, int n,
                           int nrhs, @Cast("const lapack_complex_double*") DoubleBuffer a,
                           int lda, @Cast("const lapack_complex_double*") DoubleBuffer af,
                           int ldaf, @Const IntBuffer ipiv,
                           @Cast("const lapack_complex_double*") DoubleBuffer b, int ldb,
                           @Cast("lapack_complex_double*") DoubleBuffer x, int ldx,
                           DoubleBuffer ferr, DoubleBuffer berr );
public static native int LAPACKE_zherfs( int matrix_layout, @Cast("char") byte uplo, int n,
                           int nrhs, @Cast("const lapack_complex_double*") double[] a,
                           int lda, @Cast("const lapack_complex_double*") double[] af,
                           int ldaf, @Const int[] ipiv,
                           @Cast("const lapack_complex_double*") double[] b, int ldb,
                           @Cast("lapack_complex_double*") double[] x, int ldx,
                           double[] ferr, double[] berr );




public static native int LAPACKE_chesv( int matrix_layout, @Cast("char") byte uplo, int n,
                          int nrhs, @Cast("lapack_complex_float*") FloatPointer a,
                          int lda, IntPointer ipiv,
                          @Cast("lapack_complex_float*") FloatPointer b, int ldb );
public static native int LAPACKE_chesv( int matrix_layout, @Cast("char") byte uplo, int n,
                          int nrhs, @Cast("lapack_complex_float*") FloatBuffer a,
                          int lda, IntBuffer ipiv,
                          @Cast("lapack_complex_float*") FloatBuffer b, int ldb );
public static native int LAPACKE_chesv( int matrix_layout, @Cast("char") byte uplo, int n,
                          int nrhs, @Cast("lapack_complex_float*") float[] a,
                          int lda, int[] ipiv,
                          @Cast("lapack_complex_float*") float[] b, int ldb );
public static native int LAPACKE_zhesv( int matrix_layout, @Cast("char") byte uplo, int n,
                          int nrhs, @Cast("lapack_complex_double*") DoublePointer a,
                          int lda, IntPointer ipiv,
                          @Cast("lapack_complex_double*") DoublePointer b, int ldb );
public static native int LAPACKE_zhesv( int matrix_layout, @Cast("char") byte uplo, int n,
                          int nrhs, @Cast("lapack_complex_double*") DoubleBuffer a,
                          int lda, IntBuffer ipiv,
                          @Cast("lapack_complex_double*") DoubleBuffer b, int ldb );
public static native int LAPACKE_zhesv( int matrix_layout, @Cast("char") byte uplo, int n,
                          int nrhs, @Cast("lapack_complex_double*") double[] a,
                          int lda, int[] ipiv,
                          @Cast("lapack_complex_double*") double[] b, int ldb );

public static native int LAPACKE_chesvx( int matrix_layout, @Cast("char") byte fact, @Cast("char") byte uplo, int n,
                           int nrhs, @Cast("const lapack_complex_float*") FloatPointer a,
                           int lda, @Cast("lapack_complex_float*") FloatPointer af,
                           int ldaf, IntPointer ipiv,
                           @Cast("const lapack_complex_float*") FloatPointer b, int ldb,
                           @Cast("lapack_complex_float*") FloatPointer x, int ldx,
                           FloatPointer rcond, FloatPointer ferr, FloatPointer berr );
public static native int LAPACKE_chesvx( int matrix_layout, @Cast("char") byte fact, @Cast("char") byte uplo, int n,
                           int nrhs, @Cast("const lapack_complex_float*") FloatBuffer a,
                           int lda, @Cast("lapack_complex_float*") FloatBuffer af,
                           int ldaf, IntBuffer ipiv,
                           @Cast("const lapack_complex_float*") FloatBuffer b, int ldb,
                           @Cast("lapack_complex_float*") FloatBuffer x, int ldx,
                           FloatBuffer rcond, FloatBuffer ferr, FloatBuffer berr );
public static native int LAPACKE_chesvx( int matrix_layout, @Cast("char") byte fact, @Cast("char") byte uplo, int n,
                           int nrhs, @Cast("const lapack_complex_float*") float[] a,
                           int lda, @Cast("lapack_complex_float*") float[] af,
                           int ldaf, int[] ipiv,
                           @Cast("const lapack_complex_float*") float[] b, int ldb,
                           @Cast("lapack_complex_float*") float[] x, int ldx,
                           float[] rcond, float[] ferr, float[] berr );
public static native int LAPACKE_zhesvx( int matrix_layout, @Cast("char") byte fact, @Cast("char") byte uplo, int n,
                           int nrhs, @Cast("const lapack_complex_double*") DoublePointer a,
                           int lda, @Cast("lapack_complex_double*") DoublePointer af,
                           int ldaf, IntPointer ipiv,
                           @Cast("const lapack_complex_double*") DoublePointer b, int ldb,
                           @Cast("lapack_complex_double*") DoublePointer x, int ldx,
                           DoublePointer rcond, DoublePointer ferr, DoublePointer berr );
public static native int LAPACKE_zhesvx( int matrix_layout, @Cast("char") byte fact, @Cast("char") byte uplo, int n,
                           int nrhs, @Cast("const lapack_complex_double*") DoubleBuffer a,
                           int lda, @Cast("lapack_complex_double*") DoubleBuffer af,
                           int ldaf, IntBuffer ipiv,
                           @Cast("const lapack_complex_double*") DoubleBuffer b, int ldb,
                           @Cast("lapack_complex_double*") DoubleBuffer x, int ldx,
                           DoubleBuffer rcond, DoubleBuffer ferr, DoubleBuffer berr );
public static native int LAPACKE_zhesvx( int matrix_layout, @Cast("char") byte fact, @Cast("char") byte uplo, int n,
                           int nrhs, @Cast("const lapack_complex_double*") double[] a,
                           int lda, @Cast("lapack_complex_double*") double[] af,
                           int ldaf, int[] ipiv,
                           @Cast("const lapack_complex_double*") double[] b, int ldb,
                           @Cast("lapack_complex_double*") double[] x, int ldx,
                           double[] rcond, double[] ferr, double[] berr );




public static native int LAPACKE_chetrd( int matrix_layout, @Cast("char") byte uplo, int n,
                           @Cast("lapack_complex_float*") FloatPointer a, int lda, FloatPointer d,
                           FloatPointer e, @Cast("lapack_complex_float*") FloatPointer tau );
public static native int LAPACKE_chetrd( int matrix_layout, @Cast("char") byte uplo, int n,
                           @Cast("lapack_complex_float*") FloatBuffer a, int lda, FloatBuffer d,
                           FloatBuffer e, @Cast("lapack_complex_float*") FloatBuffer tau );
public static native int LAPACKE_chetrd( int matrix_layout, @Cast("char") byte uplo, int n,
                           @Cast("lapack_complex_float*") float[] a, int lda, float[] d,
                           float[] e, @Cast("lapack_complex_float*") float[] tau );
public static native int LAPACKE_zhetrd( int matrix_layout, @Cast("char") byte uplo, int n,
                           @Cast("lapack_complex_double*") DoublePointer a, int lda, DoublePointer d,
                           DoublePointer e, @Cast("lapack_complex_double*") DoublePointer tau );
public static native int LAPACKE_zhetrd( int matrix_layout, @Cast("char") byte uplo, int n,
                           @Cast("lapack_complex_double*") DoubleBuffer a, int lda, DoubleBuffer d,
                           DoubleBuffer e, @Cast("lapack_complex_double*") DoubleBuffer tau );
public static native int LAPACKE_zhetrd( int matrix_layout, @Cast("char") byte uplo, int n,
                           @Cast("lapack_complex_double*") double[] a, int lda, double[] d,
                           double[] e, @Cast("lapack_complex_double*") double[] tau );

public static native int LAPACKE_chetrf( int matrix_layout, @Cast("char") byte uplo, int n,
                           @Cast("lapack_complex_float*") FloatPointer a, int lda,
                           IntPointer ipiv );
public static native int LAPACKE_chetrf( int matrix_layout, @Cast("char") byte uplo, int n,
                           @Cast("lapack_complex_float*") FloatBuffer a, int lda,
                           IntBuffer ipiv );
public static native int LAPACKE_chetrf( int matrix_layout, @Cast("char") byte uplo, int n,
                           @Cast("lapack_complex_float*") float[] a, int lda,
                           int[] ipiv );
public static native int LAPACKE_zhetrf( int matrix_layout, @Cast("char") byte uplo, int n,
                           @Cast("lapack_complex_double*") DoublePointer a, int lda,
                           IntPointer ipiv );
public static native int LAPACKE_zhetrf( int matrix_layout, @Cast("char") byte uplo, int n,
                           @Cast("lapack_complex_double*") DoubleBuffer a, int lda,
                           IntBuffer ipiv );
public static native int LAPACKE_zhetrf( int matrix_layout, @Cast("char") byte uplo, int n,
                           @Cast("lapack_complex_double*") double[] a, int lda,
                           int[] ipiv );

public static native int LAPACKE_chetri( int matrix_layout, @Cast("char") byte uplo, int n,
                           @Cast("lapack_complex_float*") FloatPointer a, int lda,
                           @Const IntPointer ipiv );
public static native int LAPACKE_chetri( int matrix_layout, @Cast("char") byte uplo, int n,
                           @Cast("lapack_complex_float*") FloatBuffer a, int lda,
                           @Const IntBuffer ipiv );
public static native int LAPACKE_chetri( int matrix_layout, @Cast("char") byte uplo, int n,
                           @Cast("lapack_complex_float*") float[] a, int lda,
                           @Const int[] ipiv );
public static native int LAPACKE_zhetri( int matrix_layout, @Cast("char") byte uplo, int n,
                           @Cast("lapack_complex_double*") DoublePointer a, int lda,
                           @Const IntPointer ipiv );
public static native int LAPACKE_zhetri( int matrix_layout, @Cast("char") byte uplo, int n,
                           @Cast("lapack_complex_double*") DoubleBuffer a, int lda,
                           @Const IntBuffer ipiv );
public static native int LAPACKE_zhetri( int matrix_layout, @Cast("char") byte uplo, int n,
                           @Cast("lapack_complex_double*") double[] a, int lda,
                           @Const int[] ipiv );

public static native int LAPACKE_chetrs( int matrix_layout, @Cast("char") byte uplo, int n,
                           int nrhs, @Cast("const lapack_complex_float*") FloatPointer a,
                           int lda, @Const IntPointer ipiv,
                           @Cast("lapack_complex_float*") FloatPointer b, int ldb );
public static native int LAPACKE_chetrs( int matrix_layout, @Cast("char") byte uplo, int n,
                           int nrhs, @Cast("const lapack_complex_float*") FloatBuffer a,
                           int lda, @Const IntBuffer ipiv,
                           @Cast("lapack_complex_float*") FloatBuffer b, int ldb );
public static native int LAPACKE_chetrs( int matrix_layout, @Cast("char") byte uplo, int n,
                           int nrhs, @Cast("const lapack_complex_float*") float[] a,
                           int lda, @Const int[] ipiv,
                           @Cast("lapack_complex_float*") float[] b, int ldb );
public static native int LAPACKE_zhetrs( int matrix_layout, @Cast("char") byte uplo, int n,
                           int nrhs, @Cast("const lapack_complex_double*") DoublePointer a,
                           int lda, @Const IntPointer ipiv,
                           @Cast("lapack_complex_double*") DoublePointer b, int ldb );
public static native int LAPACKE_zhetrs( int matrix_layout, @Cast("char") byte uplo, int n,
                           int nrhs, @Cast("const lapack_complex_double*") DoubleBuffer a,
                           int lda, @Const IntBuffer ipiv,
                           @Cast("lapack_complex_double*") DoubleBuffer b, int ldb );
public static native int LAPACKE_zhetrs( int matrix_layout, @Cast("char") byte uplo, int n,
                           int nrhs, @Cast("const lapack_complex_double*") double[] a,
                           int lda, @Const int[] ipiv,
                           @Cast("lapack_complex_double*") double[] b, int ldb );

public static native int LAPACKE_chfrk( int matrix_layout, @Cast("char") byte transr, @Cast("char") byte uplo, @Cast("char") byte trans,
                          int n, int k, float alpha,
                          @Cast("const lapack_complex_float*") FloatPointer a, int lda,
                          float beta, @Cast("lapack_complex_float*") FloatPointer c );
public static native int LAPACKE_chfrk( int matrix_layout, @Cast("char") byte transr, @Cast("char") byte uplo, @Cast("char") byte trans,
                          int n, int k, float alpha,
                          @Cast("const lapack_complex_float*") FloatBuffer a, int lda,
                          float beta, @Cast("lapack_complex_float*") FloatBuffer c );
public static native int LAPACKE_chfrk( int matrix_layout, @Cast("char") byte transr, @Cast("char") byte uplo, @Cast("char") byte trans,
                          int n, int k, float alpha,
                          @Cast("const lapack_complex_float*") float[] a, int lda,
                          float beta, @Cast("lapack_complex_float*") float[] c );
public static native int LAPACKE_zhfrk( int matrix_layout, @Cast("char") byte transr, @Cast("char") byte uplo, @Cast("char") byte trans,
                          int n, int k, double alpha,
                          @Cast("const lapack_complex_double*") DoublePointer a, int lda,
                          double beta, @Cast("lapack_complex_double*") DoublePointer c );
public static native int LAPACKE_zhfrk( int matrix_layout, @Cast("char") byte transr, @Cast("char") byte uplo, @Cast("char") byte trans,
                          int n, int k, double alpha,
                          @Cast("const lapack_complex_double*") DoubleBuffer a, int lda,
                          double beta, @Cast("lapack_complex_double*") DoubleBuffer c );
public static native int LAPACKE_zhfrk( int matrix_layout, @Cast("char") byte transr, @Cast("char") byte uplo, @Cast("char") byte trans,
                          int n, int k, double alpha,
                          @Cast("const lapack_complex_double*") double[] a, int lda,
                          double beta, @Cast("lapack_complex_double*") double[] c );

public static native int LAPACKE_shgeqz( int matrix_layout, @Cast("char") byte job, @Cast("char") byte compq, @Cast("char") byte compz,
                           int n, int ilo, int ihi,
                           FloatPointer h, int ldh, FloatPointer t, int ldt,
                           FloatPointer alphar, FloatPointer alphai, FloatPointer beta, FloatPointer q,
                           int ldq, FloatPointer z, int ldz );
public static native int LAPACKE_shgeqz( int matrix_layout, @Cast("char") byte job, @Cast("char") byte compq, @Cast("char") byte compz,
                           int n, int ilo, int ihi,
                           FloatBuffer h, int ldh, FloatBuffer t, int ldt,
                           FloatBuffer alphar, FloatBuffer alphai, FloatBuffer beta, FloatBuffer q,
                           int ldq, FloatBuffer z, int ldz );
public static native int LAPACKE_shgeqz( int matrix_layout, @Cast("char") byte job, @Cast("char") byte compq, @Cast("char") byte compz,
                           int n, int ilo, int ihi,
                           float[] h, int ldh, float[] t, int ldt,
                           float[] alphar, float[] alphai, float[] beta, float[] q,
                           int ldq, float[] z, int ldz );
public static native int LAPACKE_dhgeqz( int matrix_layout, @Cast("char") byte job, @Cast("char") byte compq, @Cast("char") byte compz,
                           int n, int ilo, int ihi,
                           DoublePointer h, int ldh, DoublePointer t, int ldt,
                           DoublePointer alphar, DoublePointer alphai, DoublePointer beta,
                           DoublePointer q, int ldq, DoublePointer z,
                           int ldz );
public static native int LAPACKE_dhgeqz( int matrix_layout, @Cast("char") byte job, @Cast("char") byte compq, @Cast("char") byte compz,
                           int n, int ilo, int ihi,
                           DoubleBuffer h, int ldh, DoubleBuffer t, int ldt,
                           DoubleBuffer alphar, DoubleBuffer alphai, DoubleBuffer beta,
                           DoubleBuffer q, int ldq, DoubleBuffer z,
                           int ldz );
public static native int LAPACKE_dhgeqz( int matrix_layout, @Cast("char") byte job, @Cast("char") byte compq, @Cast("char") byte compz,
                           int n, int ilo, int ihi,
                           double[] h, int ldh, double[] t, int ldt,
                           double[] alphar, double[] alphai, double[] beta,
                           double[] q, int ldq, double[] z,
                           int ldz );
public static native int LAPACKE_chgeqz( int matrix_layout, @Cast("char") byte job, @Cast("char") byte compq, @Cast("char") byte compz,
                           int n, int ilo, int ihi,
                           @Cast("lapack_complex_float*") FloatPointer h, int ldh,
                           @Cast("lapack_complex_float*") FloatPointer t, int ldt,
                           @Cast("lapack_complex_float*") FloatPointer alpha,
                           @Cast("lapack_complex_float*") FloatPointer beta, @Cast("lapack_complex_float*") FloatPointer q,
                           int ldq, @Cast("lapack_complex_float*") FloatPointer z,
                           int ldz );
public static native int LAPACKE_chgeqz( int matrix_layout, @Cast("char") byte job, @Cast("char") byte compq, @Cast("char") byte compz,
                           int n, int ilo, int ihi,
                           @Cast("lapack_complex_float*") FloatBuffer h, int ldh,
                           @Cast("lapack_complex_float*") FloatBuffer t, int ldt,
                           @Cast("lapack_complex_float*") FloatBuffer alpha,
                           @Cast("lapack_complex_float*") FloatBuffer beta, @Cast("lapack_complex_float*") FloatBuffer q,
                           int ldq, @Cast("lapack_complex_float*") FloatBuffer z,
                           int ldz );
public static native int LAPACKE_chgeqz( int matrix_layout, @Cast("char") byte job, @Cast("char") byte compq, @Cast("char") byte compz,
                           int n, int ilo, int ihi,
                           @Cast("lapack_complex_float*") float[] h, int ldh,
                           @Cast("lapack_complex_float*") float[] t, int ldt,
                           @Cast("lapack_complex_float*") float[] alpha,
                           @Cast("lapack_complex_float*") float[] beta, @Cast("lapack_complex_float*") float[] q,
                           int ldq, @Cast("lapack_complex_float*") float[] z,
                           int ldz );
public static native int LAPACKE_zhgeqz( int matrix_layout, @Cast("char") byte job, @Cast("char") byte compq, @Cast("char") byte compz,
                           int n, int ilo, int ihi,
                           @Cast("lapack_complex_double*") DoublePointer h, int ldh,
                           @Cast("lapack_complex_double*") DoublePointer t, int ldt,
                           @Cast("lapack_complex_double*") DoublePointer alpha,
                           @Cast("lapack_complex_double*") DoublePointer beta,
                           @Cast("lapack_complex_double*") DoublePointer q, int ldq,
                           @Cast("lapack_complex_double*") DoublePointer z, int ldz );
public static native int LAPACKE_zhgeqz( int matrix_layout, @Cast("char") byte job, @Cast("char") byte compq, @Cast("char") byte compz,
                           int n, int ilo, int ihi,
                           @Cast("lapack_complex_double*") DoubleBuffer h, int ldh,
                           @Cast("lapack_complex_double*") DoubleBuffer t, int ldt,
                           @Cast("lapack_complex_double*") DoubleBuffer alpha,
                           @Cast("lapack_complex_double*") DoubleBuffer beta,
                           @Cast("lapack_complex_double*") DoubleBuffer q, int ldq,
                           @Cast("lapack_complex_double*") DoubleBuffer z, int ldz );
public static native int LAPACKE_zhgeqz( int matrix_layout, @Cast("char") byte job, @Cast("char") byte compq, @Cast("char") byte compz,
                           int n, int ilo, int ihi,
                           @Cast("lapack_complex_double*") double[] h, int ldh,
                           @Cast("lapack_complex_double*") double[] t, int ldt,
                           @Cast("lapack_complex_double*") double[] alpha,
                           @Cast("lapack_complex_double*") double[] beta,
                           @Cast("lapack_complex_double*") double[] q, int ldq,
                           @Cast("lapack_complex_double*") double[] z, int ldz );

public static native int LAPACKE_chpcon( int matrix_layout, @Cast("char") byte uplo, int n,
                           @Cast("const lapack_complex_float*") FloatPointer ap,
                           @Const IntPointer ipiv, float anorm, FloatPointer rcond );
public static native int LAPACKE_chpcon( int matrix_layout, @Cast("char") byte uplo, int n,
                           @Cast("const lapack_complex_float*") FloatBuffer ap,
                           @Const IntBuffer ipiv, float anorm, FloatBuffer rcond );
public static native int LAPACKE_chpcon( int matrix_layout, @Cast("char") byte uplo, int n,
                           @Cast("const lapack_complex_float*") float[] ap,
                           @Const int[] ipiv, float anorm, float[] rcond );
public static native int LAPACKE_zhpcon( int matrix_layout, @Cast("char") byte uplo, int n,
                           @Cast("const lapack_complex_double*") DoublePointer ap,
                           @Const IntPointer ipiv, double anorm,
                           DoublePointer rcond );
public static native int LAPACKE_zhpcon( int matrix_layout, @Cast("char") byte uplo, int n,
                           @Cast("const lapack_complex_double*") DoubleBuffer ap,
                           @Const IntBuffer ipiv, double anorm,
                           DoubleBuffer rcond );
public static native int LAPACKE_zhpcon( int matrix_layout, @Cast("char") byte uplo, int n,
                           @Cast("const lapack_complex_double*") double[] ap,
                           @Const int[] ipiv, double anorm,
                           double[] rcond );

public static native int LAPACKE_chpev( int matrix_layout, @Cast("char") byte jobz, @Cast("char") byte uplo, int n,
                          @Cast("lapack_complex_float*") FloatPointer ap, FloatPointer w,
                          @Cast("lapack_complex_float*") FloatPointer z, int ldz );
public static native int LAPACKE_chpev( int matrix_layout, @Cast("char") byte jobz, @Cast("char") byte uplo, int n,
                          @Cast("lapack_complex_float*") FloatBuffer ap, FloatBuffer w,
                          @Cast("lapack_complex_float*") FloatBuffer z, int ldz );
public static native int LAPACKE_chpev( int matrix_layout, @Cast("char") byte jobz, @Cast("char") byte uplo, int n,
                          @Cast("lapack_complex_float*") float[] ap, float[] w,
                          @Cast("lapack_complex_float*") float[] z, int ldz );
public static native int LAPACKE_zhpev( int matrix_layout, @Cast("char") byte jobz, @Cast("char") byte uplo, int n,
                          @Cast("lapack_complex_double*") DoublePointer ap, DoublePointer w,
                          @Cast("lapack_complex_double*") DoublePointer z, int ldz );
public static native int LAPACKE_zhpev( int matrix_layout, @Cast("char") byte jobz, @Cast("char") byte uplo, int n,
                          @Cast("lapack_complex_double*") DoubleBuffer ap, DoubleBuffer w,
                          @Cast("lapack_complex_double*") DoubleBuffer z, int ldz );
public static native int LAPACKE_zhpev( int matrix_layout, @Cast("char") byte jobz, @Cast("char") byte uplo, int n,
                          @Cast("lapack_complex_double*") double[] ap, double[] w,
                          @Cast("lapack_complex_double*") double[] z, int ldz );

public static native int LAPACKE_chpevd( int matrix_layout, @Cast("char") byte jobz, @Cast("char") byte uplo, int n,
                           @Cast("lapack_complex_float*") FloatPointer ap, FloatPointer w,
                           @Cast("lapack_complex_float*") FloatPointer z, int ldz );
public static native int LAPACKE_chpevd( int matrix_layout, @Cast("char") byte jobz, @Cast("char") byte uplo, int n,
                           @Cast("lapack_complex_float*") FloatBuffer ap, FloatBuffer w,
                           @Cast("lapack_complex_float*") FloatBuffer z, int ldz );
public static native int LAPACKE_chpevd( int matrix_layout, @Cast("char") byte jobz, @Cast("char") byte uplo, int n,
                           @Cast("lapack_complex_float*") float[] ap, float[] w,
                           @Cast("lapack_complex_float*") float[] z, int ldz );
public static native int LAPACKE_zhpevd( int matrix_layout, @Cast("char") byte jobz, @Cast("char") byte uplo, int n,
                           @Cast("lapack_complex_double*") DoublePointer ap, DoublePointer w,
                           @Cast("lapack_complex_double*") DoublePointer z, int ldz );
public static native int LAPACKE_zhpevd( int matrix_layout, @Cast("char") byte jobz, @Cast("char") byte uplo, int n,
                           @Cast("lapack_complex_double*") DoubleBuffer ap, DoubleBuffer w,
                           @Cast("lapack_complex_double*") DoubleBuffer z, int ldz );
public static native int LAPACKE_zhpevd( int matrix_layout, @Cast("char") byte jobz, @Cast("char") byte uplo, int n,
                           @Cast("lapack_complex_double*") double[] ap, double[] w,
                           @Cast("lapack_complex_double*") double[] z, int ldz );

public static native int LAPACKE_chpevx( int matrix_layout, @Cast("char") byte jobz, @Cast("char") byte range, @Cast("char") byte uplo,
                           int n, @Cast("lapack_complex_float*") FloatPointer ap, float vl,
                           float vu, int il, int iu, float abstol,
                           IntPointer m, FloatPointer w, @Cast("lapack_complex_float*") FloatPointer z,
                           int ldz, IntPointer ifail );
public static native int LAPACKE_chpevx( int matrix_layout, @Cast("char") byte jobz, @Cast("char") byte range, @Cast("char") byte uplo,
                           int n, @Cast("lapack_complex_float*") FloatBuffer ap, float vl,
                           float vu, int il, int iu, float abstol,
                           IntBuffer m, FloatBuffer w, @Cast("lapack_complex_float*") FloatBuffer z,
                           int ldz, IntBuffer ifail );
public static native int LAPACKE_chpevx( int matrix_layout, @Cast("char") byte jobz, @Cast("char") byte range, @Cast("char") byte uplo,
                           int n, @Cast("lapack_complex_float*") float[] ap, float vl,
                           float vu, int il, int iu, float abstol,
                           int[] m, float[] w, @Cast("lapack_complex_float*") float[] z,
                           int ldz, int[] ifail );
public static native int LAPACKE_zhpevx( int matrix_layout, @Cast("char") byte jobz, @Cast("char") byte range, @Cast("char") byte uplo,
                           int n, @Cast("lapack_complex_double*") DoublePointer ap, double vl,
                           double vu, int il, int iu,
                           double abstol, IntPointer m, DoublePointer w,
                           @Cast("lapack_complex_double*") DoublePointer z, int ldz,
                           IntPointer ifail );
public static native int LAPACKE_zhpevx( int matrix_layout, @Cast("char") byte jobz, @Cast("char") byte range, @Cast("char") byte uplo,
                           int n, @Cast("lapack_complex_double*") DoubleBuffer ap, double vl,
                           double vu, int il, int iu,
                           double abstol, IntBuffer m, DoubleBuffer w,
                           @Cast("lapack_complex_double*") DoubleBuffer z, int ldz,
                           IntBuffer ifail );
public static native int LAPACKE_zhpevx( int matrix_layout, @Cast("char") byte jobz, @Cast("char") byte range, @Cast("char") byte uplo,
                           int n, @Cast("lapack_complex_double*") double[] ap, double vl,
                           double vu, int il, int iu,
                           double abstol, int[] m, double[] w,
                           @Cast("lapack_complex_double*") double[] z, int ldz,
                           int[] ifail );

public static native int LAPACKE_chpgst( int matrix_layout, int itype, @Cast("char") byte uplo,
                           int n, @Cast("lapack_complex_float*") FloatPointer ap,
                           @Cast("const lapack_complex_float*") FloatPointer bp );
public static native int LAPACKE_chpgst( int matrix_layout, int itype, @Cast("char") byte uplo,
                           int n, @Cast("lapack_complex_float*") FloatBuffer ap,
                           @Cast("const lapack_complex_float*") FloatBuffer bp );
public static native int LAPACKE_chpgst( int matrix_layout, int itype, @Cast("char") byte uplo,
                           int n, @Cast("lapack_complex_float*") float[] ap,
                           @Cast("const lapack_complex_float*") float[] bp );
public static native int LAPACKE_zhpgst( int matrix_layout, int itype, @Cast("char") byte uplo,
                           int n, @Cast("lapack_complex_double*") DoublePointer ap,
                           @Cast("const lapack_complex_double*") DoublePointer bp );
public static native int LAPACKE_zhpgst( int matrix_layout, int itype, @Cast("char") byte uplo,
                           int n, @Cast("lapack_complex_double*") DoubleBuffer ap,
                           @Cast("const lapack_complex_double*") DoubleBuffer bp );
public static native int LAPACKE_zhpgst( int matrix_layout, int itype, @Cast("char") byte uplo,
                           int n, @Cast("lapack_complex_double*") double[] ap,
                           @Cast("const lapack_complex_double*") double[] bp );

public static native int LAPACKE_chpgv( int matrix_layout, int itype, @Cast("char") byte jobz,
                          @Cast("char") byte uplo, int n, @Cast("lapack_complex_float*") FloatPointer ap,
                          @Cast("lapack_complex_float*") FloatPointer bp, FloatPointer w,
                          @Cast("lapack_complex_float*") FloatPointer z, int ldz );
public static native int LAPACKE_chpgv( int matrix_layout, int itype, @Cast("char") byte jobz,
                          @Cast("char") byte uplo, int n, @Cast("lapack_complex_float*") FloatBuffer ap,
                          @Cast("lapack_complex_float*") FloatBuffer bp, FloatBuffer w,
                          @Cast("lapack_complex_float*") FloatBuffer z, int ldz );
public static native int LAPACKE_chpgv( int matrix_layout, int itype, @Cast("char") byte jobz,
                          @Cast("char") byte uplo, int n, @Cast("lapack_complex_float*") float[] ap,
                          @Cast("lapack_complex_float*") float[] bp, float[] w,
                          @Cast("lapack_complex_float*") float[] z, int ldz );
public static native int LAPACKE_zhpgv( int matrix_layout, int itype, @Cast("char") byte jobz,
                          @Cast("char") byte uplo, int n, @Cast("lapack_complex_double*") DoublePointer ap,
                          @Cast("lapack_complex_double*") DoublePointer bp, DoublePointer w,
                          @Cast("lapack_complex_double*") DoublePointer z, int ldz );
public static native int LAPACKE_zhpgv( int matrix_layout, int itype, @Cast("char") byte jobz,
                          @Cast("char") byte uplo, int n, @Cast("lapack_complex_double*") DoubleBuffer ap,
                          @Cast("lapack_complex_double*") DoubleBuffer bp, DoubleBuffer w,
                          @Cast("lapack_complex_double*") DoubleBuffer z, int ldz );
public static native int LAPACKE_zhpgv( int matrix_layout, int itype, @Cast("char") byte jobz,
                          @Cast("char") byte uplo, int n, @Cast("lapack_complex_double*") double[] ap,
                          @Cast("lapack_complex_double*") double[] bp, double[] w,
                          @Cast("lapack_complex_double*") double[] z, int ldz );

public static native int LAPACKE_chpgvd( int matrix_layout, int itype, @Cast("char") byte jobz,
                           @Cast("char") byte uplo, int n, @Cast("lapack_complex_float*") FloatPointer ap,
                           @Cast("lapack_complex_float*") FloatPointer bp, FloatPointer w,
                           @Cast("lapack_complex_float*") FloatPointer z, int ldz );
public static native int LAPACKE_chpgvd( int matrix_layout, int itype, @Cast("char") byte jobz,
                           @Cast("char") byte uplo, int n, @Cast("lapack_complex_float*") FloatBuffer ap,
                           @Cast("lapack_complex_float*") FloatBuffer bp, FloatBuffer w,
                           @Cast("lapack_complex_float*") FloatBuffer z, int ldz );
public static native int LAPACKE_chpgvd( int matrix_layout, int itype, @Cast("char") byte jobz,
                           @Cast("char") byte uplo, int n, @Cast("lapack_complex_float*") float[] ap,
                           @Cast("lapack_complex_float*") float[] bp, float[] w,
                           @Cast("lapack_complex_float*") float[] z, int ldz );
public static native int LAPACKE_zhpgvd( int matrix_layout, int itype, @Cast("char") byte jobz,
                           @Cast("char") byte uplo, int n, @Cast("lapack_complex_double*") DoublePointer ap,
                           @Cast("lapack_complex_double*") DoublePointer bp, DoublePointer w,
                           @Cast("lapack_complex_double*") DoublePointer z, int ldz );
public static native int LAPACKE_zhpgvd( int matrix_layout, int itype, @Cast("char") byte jobz,
                           @Cast("char") byte uplo, int n, @Cast("lapack_complex_double*") DoubleBuffer ap,
                           @Cast("lapack_complex_double*") DoubleBuffer bp, DoubleBuffer w,
                           @Cast("lapack_complex_double*") DoubleBuffer z, int ldz );
public static native int LAPACKE_zhpgvd( int matrix_layout, int itype, @Cast("char") byte jobz,
                           @Cast("char") byte uplo, int n, @Cast("lapack_complex_double*") double[] ap,
                           @Cast("lapack_complex_double*") double[] bp, double[] w,
                           @Cast("lapack_complex_double*") double[] z, int ldz );

public static native int LAPACKE_chpgvx( int matrix_layout, int itype, @Cast("char") byte jobz,
                           @Cast("char") byte range, @Cast("char") byte uplo, int n,
                           @Cast("lapack_complex_float*") FloatPointer ap, @Cast("lapack_complex_float*") FloatPointer bp,
                           float vl, float vu, int il, int iu,
                           float abstol, IntPointer m, FloatPointer w,
                           @Cast("lapack_complex_float*") FloatPointer z, int ldz,
                           IntPointer ifail );
public static native int LAPACKE_chpgvx( int matrix_layout, int itype, @Cast("char") byte jobz,
                           @Cast("char") byte range, @Cast("char") byte uplo, int n,
                           @Cast("lapack_complex_float*") FloatBuffer ap, @Cast("lapack_complex_float*") FloatBuffer bp,
                           float vl, float vu, int il, int iu,
                           float abstol, IntBuffer m, FloatBuffer w,
                           @Cast("lapack_complex_float*") FloatBuffer z, int ldz,
                           IntBuffer ifail );
public static native int LAPACKE_chpgvx( int matrix_layout, int itype, @Cast("char") byte jobz,
                           @Cast("char") byte range, @Cast("char") byte uplo, int n,
                           @Cast("lapack_complex_float*") float[] ap, @Cast("lapack_complex_float*") float[] bp,
                           float vl, float vu, int il, int iu,
                           float abstol, int[] m, float[] w,
                           @Cast("lapack_complex_float*") float[] z, int ldz,
                           int[] ifail );
public static native int LAPACKE_zhpgvx( int matrix_layout, int itype, @Cast("char") byte jobz,
                           @Cast("char") byte range, @Cast("char") byte uplo, int n,
                           @Cast("lapack_complex_double*") DoublePointer ap, @Cast("lapack_complex_double*") DoublePointer bp,
                           double vl, double vu, int il, int iu,
                           double abstol, IntPointer m, DoublePointer w,
                           @Cast("lapack_complex_double*") DoublePointer z, int ldz,
                           IntPointer ifail );
public static native int LAPACKE_zhpgvx( int matrix_layout, int itype, @Cast("char") byte jobz,
                           @Cast("char") byte range, @Cast("char") byte uplo, int n,
                           @Cast("lapack_complex_double*") DoubleBuffer ap, @Cast("lapack_complex_double*") DoubleBuffer bp,
                           double vl, double vu, int il, int iu,
                           double abstol, IntBuffer m, DoubleBuffer w,
                           @Cast("lapack_complex_double*") DoubleBuffer z, int ldz,
                           IntBuffer ifail );
public static native int LAPACKE_zhpgvx( int matrix_layout, int itype, @Cast("char") byte jobz,
                           @Cast("char") byte range, @Cast("char") byte uplo, int n,
                           @Cast("lapack_complex_double*") double[] ap, @Cast("lapack_complex_double*") double[] bp,
                           double vl, double vu, int il, int iu,
                           double abstol, int[] m, double[] w,
                           @Cast("lapack_complex_double*") double[] z, int ldz,
                           int[] ifail );

public static native int LAPACKE_chprfs( int matrix_layout, @Cast("char") byte uplo, int n,
                           int nrhs, @Cast("const lapack_complex_float*") FloatPointer ap,
                           @Cast("const lapack_complex_float*") FloatPointer afp,
                           @Const IntPointer ipiv,
                           @Cast("const lapack_complex_float*") FloatPointer b, int ldb,
                           @Cast("lapack_complex_float*") FloatPointer x, int ldx, FloatPointer ferr,
                           FloatPointer berr );
public static native int LAPACKE_chprfs( int matrix_layout, @Cast("char") byte uplo, int n,
                           int nrhs, @Cast("const lapack_complex_float*") FloatBuffer ap,
                           @Cast("const lapack_complex_float*") FloatBuffer afp,
                           @Const IntBuffer ipiv,
                           @Cast("const lapack_complex_float*") FloatBuffer b, int ldb,
                           @Cast("lapack_complex_float*") FloatBuffer x, int ldx, FloatBuffer ferr,
                           FloatBuffer berr );
public static native int LAPACKE_chprfs( int matrix_layout, @Cast("char") byte uplo, int n,
                           int nrhs, @Cast("const lapack_complex_float*") float[] ap,
                           @Cast("const lapack_complex_float*") float[] afp,
                           @Const int[] ipiv,
                           @Cast("const lapack_complex_float*") float[] b, int ldb,
                           @Cast("lapack_complex_float*") float[] x, int ldx, float[] ferr,
                           float[] berr );
public static native int LAPACKE_zhprfs( int matrix_layout, @Cast("char") byte uplo, int n,
                           int nrhs, @Cast("const lapack_complex_double*") DoublePointer ap,
                           @Cast("const lapack_complex_double*") DoublePointer afp,
                           @Const IntPointer ipiv,
                           @Cast("const lapack_complex_double*") DoublePointer b, int ldb,
                           @Cast("lapack_complex_double*") DoublePointer x, int ldx,
                           DoublePointer ferr, DoublePointer berr );
public static native int LAPACKE_zhprfs( int matrix_layout, @Cast("char") byte uplo, int n,
                           int nrhs, @Cast("const lapack_complex_double*") DoubleBuffer ap,
                           @Cast("const lapack_complex_double*") DoubleBuffer afp,
                           @Const IntBuffer ipiv,
                           @Cast("const lapack_complex_double*") DoubleBuffer b, int ldb,
                           @Cast("lapack_complex_double*") DoubleBuffer x, int ldx,
                           DoubleBuffer ferr, DoubleBuffer berr );
public static native int LAPACKE_zhprfs( int matrix_layout, @Cast("char") byte uplo, int n,
                           int nrhs, @Cast("const lapack_complex_double*") double[] ap,
                           @Cast("const lapack_complex_double*") double[] afp,
                           @Const int[] ipiv,
                           @Cast("const lapack_complex_double*") double[] b, int ldb,
                           @Cast("lapack_complex_double*") double[] x, int ldx,
                           double[] ferr, double[] berr );

public static native int LAPACKE_chpsv( int matrix_layout, @Cast("char") byte uplo, int n,
                          int nrhs, @Cast("lapack_complex_float*") FloatPointer ap,
                          IntPointer ipiv, @Cast("lapack_complex_float*") FloatPointer b,
                          int ldb );
public static native int LAPACKE_chpsv( int matrix_layout, @Cast("char") byte uplo, int n,
                          int nrhs, @Cast("lapack_complex_float*") FloatBuffer ap,
                          IntBuffer ipiv, @Cast("lapack_complex_float*") FloatBuffer b,
                          int ldb );
public static native int LAPACKE_chpsv( int matrix_layout, @Cast("char") byte uplo, int n,
                          int nrhs, @Cast("lapack_complex_float*") float[] ap,
                          int[] ipiv, @Cast("lapack_complex_float*") float[] b,
                          int ldb );
public static native int LAPACKE_zhpsv( int matrix_layout, @Cast("char") byte uplo, int n,
                          int nrhs, @Cast("lapack_complex_double*") DoublePointer ap,
                          IntPointer ipiv, @Cast("lapack_complex_double*") DoublePointer b,
                          int ldb );
public static native int LAPACKE_zhpsv( int matrix_layout, @Cast("char") byte uplo, int n,
                          int nrhs, @Cast("lapack_complex_double*") DoubleBuffer ap,
                          IntBuffer ipiv, @Cast("lapack_complex_double*") DoubleBuffer b,
                          int ldb );
public static native int LAPACKE_zhpsv( int matrix_layout, @Cast("char") byte uplo, int n,
                          int nrhs, @Cast("lapack_complex_double*") double[] ap,
                          int[] ipiv, @Cast("lapack_complex_double*") double[] b,
                          int ldb );

public static native int LAPACKE_chpsvx( int matrix_layout, @Cast("char") byte fact, @Cast("char") byte uplo, int n,
                           int nrhs, @Cast("const lapack_complex_float*") FloatPointer ap,
                           @Cast("lapack_complex_float*") FloatPointer afp, IntPointer ipiv,
                           @Cast("const lapack_complex_float*") FloatPointer b, int ldb,
                           @Cast("lapack_complex_float*") FloatPointer x, int ldx,
                           FloatPointer rcond, FloatPointer ferr, FloatPointer berr );
public static native int LAPACKE_chpsvx( int matrix_layout, @Cast("char") byte fact, @Cast("char") byte uplo, int n,
                           int nrhs, @Cast("const lapack_complex_float*") FloatBuffer ap,
                           @Cast("lapack_complex_float*") FloatBuffer afp, IntBuffer ipiv,
                           @Cast("const lapack_complex_float*") FloatBuffer b, int ldb,
                           @Cast("lapack_complex_float*") FloatBuffer x, int ldx,
                           FloatBuffer rcond, FloatBuffer ferr, FloatBuffer berr );
public static native int LAPACKE_chpsvx( int matrix_layout, @Cast("char") byte fact, @Cast("char") byte uplo, int n,
                           int nrhs, @Cast("const lapack_complex_float*") float[] ap,
                           @Cast("lapack_complex_float*") float[] afp, int[] ipiv,
                           @Cast("const lapack_complex_float*") float[] b, int ldb,
                           @Cast("lapack_complex_float*") float[] x, int ldx,
                           float[] rcond, float[] ferr, float[] berr );
public static native int LAPACKE_zhpsvx( int matrix_layout, @Cast("char") byte fact, @Cast("char") byte uplo, int n,
                           int nrhs, @Cast("const lapack_complex_double*") DoublePointer ap,
                           @Cast("lapack_complex_double*") DoublePointer afp, IntPointer ipiv,
                           @Cast("const lapack_complex_double*") DoublePointer b, int ldb,
                           @Cast("lapack_complex_double*") DoublePointer x, int ldx,
                           DoublePointer rcond, DoublePointer ferr, DoublePointer berr );
public static native int LAPACKE_zhpsvx( int matrix_layout, @Cast("char") byte fact, @Cast("char") byte uplo, int n,
                           int nrhs, @Cast("const lapack_complex_double*") DoubleBuffer ap,
                           @Cast("lapack_complex_double*") DoubleBuffer afp, IntBuffer ipiv,
                           @Cast("const lapack_complex_double*") DoubleBuffer b, int ldb,
                           @Cast("lapack_complex_double*") DoubleBuffer x, int ldx,
                           DoubleBuffer rcond, DoubleBuffer ferr, DoubleBuffer berr );
public static native int LAPACKE_zhpsvx( int matrix_layout, @Cast("char") byte fact, @Cast("char") byte uplo, int n,
                           int nrhs, @Cast("const lapack_complex_double*") double[] ap,
                           @Cast("lapack_complex_double*") double[] afp, int[] ipiv,
                           @Cast("const lapack_complex_double*") double[] b, int ldb,
                           @Cast("lapack_complex_double*") double[] x, int ldx,
                           double[] rcond, double[] ferr, double[] berr );

public static native int LAPACKE_chptrd( int matrix_layout, @Cast("char") byte uplo, int n,
                           @Cast("lapack_complex_float*") FloatPointer ap, FloatPointer d, FloatPointer e,
                           @Cast("lapack_complex_float*") FloatPointer tau );
public static native int LAPACKE_chptrd( int matrix_layout, @Cast("char") byte uplo, int n,
                           @Cast("lapack_complex_float*") FloatBuffer ap, FloatBuffer d, FloatBuffer e,
                           @Cast("lapack_complex_float*") FloatBuffer tau );
public static native int LAPACKE_chptrd( int matrix_layout, @Cast("char") byte uplo, int n,
                           @Cast("lapack_complex_float*") float[] ap, float[] d, float[] e,
                           @Cast("lapack_complex_float*") float[] tau );
public static native int LAPACKE_zhptrd( int matrix_layout, @Cast("char") byte uplo, int n,
                           @Cast("lapack_complex_double*") DoublePointer ap, DoublePointer d, DoublePointer e,
                           @Cast("lapack_complex_double*") DoublePointer tau );
public static native int LAPACKE_zhptrd( int matrix_layout, @Cast("char") byte uplo, int n,
                           @Cast("lapack_complex_double*") DoubleBuffer ap, DoubleBuffer d, DoubleBuffer e,
                           @Cast("lapack_complex_double*") DoubleBuffer tau );
public static native int LAPACKE_zhptrd( int matrix_layout, @Cast("char") byte uplo, int n,
                           @Cast("lapack_complex_double*") double[] ap, double[] d, double[] e,
                           @Cast("lapack_complex_double*") double[] tau );

public static native int LAPACKE_chptrf( int matrix_layout, @Cast("char") byte uplo, int n,
                           @Cast("lapack_complex_float*") FloatPointer ap, IntPointer ipiv );
public static native int LAPACKE_chptrf( int matrix_layout, @Cast("char") byte uplo, int n,
                           @Cast("lapack_complex_float*") FloatBuffer ap, IntBuffer ipiv );
public static native int LAPACKE_chptrf( int matrix_layout, @Cast("char") byte uplo, int n,
                           @Cast("lapack_complex_float*") float[] ap, int[] ipiv );
public static native int LAPACKE_zhptrf( int matrix_layout, @Cast("char") byte uplo, int n,
                           @Cast("lapack_complex_double*") DoublePointer ap, IntPointer ipiv );
public static native int LAPACKE_zhptrf( int matrix_layout, @Cast("char") byte uplo, int n,
                           @Cast("lapack_complex_double*") DoubleBuffer ap, IntBuffer ipiv );
public static native int LAPACKE_zhptrf( int matrix_layout, @Cast("char") byte uplo, int n,
                           @Cast("lapack_complex_double*") double[] ap, int[] ipiv );

public static native int LAPACKE_chptri( int matrix_layout, @Cast("char") byte uplo, int n,
                           @Cast("lapack_complex_float*") FloatPointer ap, @Const IntPointer ipiv );
public static native int LAPACKE_chptri( int matrix_layout, @Cast("char") byte uplo, int n,
                           @Cast("lapack_complex_float*") FloatBuffer ap, @Const IntBuffer ipiv );
public static native int LAPACKE_chptri( int matrix_layout, @Cast("char") byte uplo, int n,
                           @Cast("lapack_complex_float*") float[] ap, @Const int[] ipiv );
public static native int LAPACKE_zhptri( int matrix_layout, @Cast("char") byte uplo, int n,
                           @Cast("lapack_complex_double*") DoublePointer ap, @Const IntPointer ipiv );
public static native int LAPACKE_zhptri( int matrix_layout, @Cast("char") byte uplo, int n,
                           @Cast("lapack_complex_double*") DoubleBuffer ap, @Const IntBuffer ipiv );
public static native int LAPACKE_zhptri( int matrix_layout, @Cast("char") byte uplo, int n,
                           @Cast("lapack_complex_double*") double[] ap, @Const int[] ipiv );

public static native int LAPACKE_chptrs( int matrix_layout, @Cast("char") byte uplo, int n,
                           int nrhs, @Cast("const lapack_complex_float*") FloatPointer ap,
                           @Const IntPointer ipiv, @Cast("lapack_complex_float*") FloatPointer b,
                           int ldb );
public static native int LAPACKE_chptrs( int matrix_layout, @Cast("char") byte uplo, int n,
                           int nrhs, @Cast("const lapack_complex_float*") FloatBuffer ap,
                           @Const IntBuffer ipiv, @Cast("lapack_complex_float*") FloatBuffer b,
                           int ldb );
public static native int LAPACKE_chptrs( int matrix_layout, @Cast("char") byte uplo, int n,
                           int nrhs, @Cast("const lapack_complex_float*") float[] ap,
                           @Const int[] ipiv, @Cast("lapack_complex_float*") float[] b,
                           int ldb );
public static native int LAPACKE_zhptrs( int matrix_layout, @Cast("char") byte uplo, int n,
                           int nrhs, @Cast("const lapack_complex_double*") DoublePointer ap,
                           @Const IntPointer ipiv, @Cast("lapack_complex_double*") DoublePointer b,
                           int ldb );
public static native int LAPACKE_zhptrs( int matrix_layout, @Cast("char") byte uplo, int n,
                           int nrhs, @Cast("const lapack_complex_double*") DoubleBuffer ap,
                           @Const IntBuffer ipiv, @Cast("lapack_complex_double*") DoubleBuffer b,
                           int ldb );
public static native int LAPACKE_zhptrs( int matrix_layout, @Cast("char") byte uplo, int n,
                           int nrhs, @Cast("const lapack_complex_double*") double[] ap,
                           @Const int[] ipiv, @Cast("lapack_complex_double*") double[] b,
                           int ldb );

public static native int LAPACKE_shsein( int matrix_layout, @Cast("char") byte job, @Cast("char") byte eigsrc, @Cast("char") byte initv,
                           IntPointer select, int n, @Const FloatPointer h,
                           int ldh, FloatPointer wr, @Const FloatPointer wi,
                           FloatPointer vl, int ldvl, FloatPointer vr,
                           int ldvr, int mm, IntPointer m,
                           IntPointer ifaill, IntPointer ifailr );
public static native int LAPACKE_shsein( int matrix_layout, @Cast("char") byte job, @Cast("char") byte eigsrc, @Cast("char") byte initv,
                           IntBuffer select, int n, @Const FloatBuffer h,
                           int ldh, FloatBuffer wr, @Const FloatBuffer wi,
                           FloatBuffer vl, int ldvl, FloatBuffer vr,
                           int ldvr, int mm, IntBuffer m,
                           IntBuffer ifaill, IntBuffer ifailr );
public static native int LAPACKE_shsein( int matrix_layout, @Cast("char") byte job, @Cast("char") byte eigsrc, @Cast("char") byte initv,
                           int[] select, int n, @Const float[] h,
                           int ldh, float[] wr, @Const float[] wi,
                           float[] vl, int ldvl, float[] vr,
                           int ldvr, int mm, int[] m,
                           int[] ifaill, int[] ifailr );
public static native int LAPACKE_dhsein( int matrix_layout, @Cast("char") byte job, @Cast("char") byte eigsrc, @Cast("char") byte initv,
                           IntPointer select, int n,
                           @Const DoublePointer h, int ldh, DoublePointer wr,
                           @Const DoublePointer wi, DoublePointer vl, int ldvl,
                           DoublePointer vr, int ldvr, int mm,
                           IntPointer m, IntPointer ifaill,
                           IntPointer ifailr );
public static native int LAPACKE_dhsein( int matrix_layout, @Cast("char") byte job, @Cast("char") byte eigsrc, @Cast("char") byte initv,
                           IntBuffer select, int n,
                           @Const DoubleBuffer h, int ldh, DoubleBuffer wr,
                           @Const DoubleBuffer wi, DoubleBuffer vl, int ldvl,
                           DoubleBuffer vr, int ldvr, int mm,
                           IntBuffer m, IntBuffer ifaill,
                           IntBuffer ifailr );
public static native int LAPACKE_dhsein( int matrix_layout, @Cast("char") byte job, @Cast("char") byte eigsrc, @Cast("char") byte initv,
                           int[] select, int n,
                           @Const double[] h, int ldh, double[] wr,
                           @Const double[] wi, double[] vl, int ldvl,
                           double[] vr, int ldvr, int mm,
                           int[] m, int[] ifaill,
                           int[] ifailr );
public static native int LAPACKE_chsein( int matrix_layout, @Cast("char") byte job, @Cast("char") byte eigsrc, @Cast("char") byte initv,
                           @Const IntPointer select, int n,
                           @Cast("const lapack_complex_float*") FloatPointer h, int ldh,
                           @Cast("lapack_complex_float*") FloatPointer w, @Cast("lapack_complex_float*") FloatPointer vl,
                           int ldvl, @Cast("lapack_complex_float*") FloatPointer vr,
                           int ldvr, int mm, IntPointer m,
                           IntPointer ifaill, IntPointer ifailr );
public static native int LAPACKE_chsein( int matrix_layout, @Cast("char") byte job, @Cast("char") byte eigsrc, @Cast("char") byte initv,
                           @Const IntBuffer select, int n,
                           @Cast("const lapack_complex_float*") FloatBuffer h, int ldh,
                           @Cast("lapack_complex_float*") FloatBuffer w, @Cast("lapack_complex_float*") FloatBuffer vl,
                           int ldvl, @Cast("lapack_complex_float*") FloatBuffer vr,
                           int ldvr, int mm, IntBuffer m,
                           IntBuffer ifaill, IntBuffer ifailr );
public static native int LAPACKE_chsein( int matrix_layout, @Cast("char") byte job, @Cast("char") byte eigsrc, @Cast("char") byte initv,
                           @Const int[] select, int n,
                           @Cast("const lapack_complex_float*") float[] h, int ldh,
                           @Cast("lapack_complex_float*") float[] w, @Cast("lapack_complex_float*") float[] vl,
                           int ldvl, @Cast("lapack_complex_float*") float[] vr,
                           int ldvr, int mm, int[] m,
                           int[] ifaill, int[] ifailr );
public static native int LAPACKE_zhsein( int matrix_layout, @Cast("char") byte job, @Cast("char") byte eigsrc, @Cast("char") byte initv,
                           @Const IntPointer select, int n,
                           @Cast("const lapack_complex_double*") DoublePointer h, int ldh,
                           @Cast("lapack_complex_double*") DoublePointer w, @Cast("lapack_complex_double*") DoublePointer vl,
                           int ldvl, @Cast("lapack_complex_double*") DoublePointer vr,
                           int ldvr, int mm, IntPointer m,
                           IntPointer ifaill, IntPointer ifailr );
public static native int LAPACKE_zhsein( int matrix_layout, @Cast("char") byte job, @Cast("char") byte eigsrc, @Cast("char") byte initv,
                           @Const IntBuffer select, int n,
                           @Cast("const lapack_complex_double*") DoubleBuffer h, int ldh,
                           @Cast("lapack_complex_double*") DoubleBuffer w, @Cast("lapack_complex_double*") DoubleBuffer vl,
                           int ldvl, @Cast("lapack_complex_double*") DoubleBuffer vr,
                           int ldvr, int mm, IntBuffer m,
                           IntBuffer ifaill, IntBuffer ifailr );
public static native int LAPACKE_zhsein( int matrix_layout, @Cast("char") byte job, @Cast("char") byte eigsrc, @Cast("char") byte initv,
                           @Const int[] select, int n,
                           @Cast("const lapack_complex_double*") double[] h, int ldh,
                           @Cast("lapack_complex_double*") double[] w, @Cast("lapack_complex_double*") double[] vl,
                           int ldvl, @Cast("lapack_complex_double*") double[] vr,
                           int ldvr, int mm, int[] m,
                           int[] ifaill, int[] ifailr );

public static native int LAPACKE_shseqr( int matrix_layout, @Cast("char") byte job, @Cast("char") byte compz, int n,
                           int ilo, int ihi, FloatPointer h,
                           int ldh, FloatPointer wr, FloatPointer wi, FloatPointer z,
                           int ldz );
public static native int LAPACKE_shseqr( int matrix_layout, @Cast("char") byte job, @Cast("char") byte compz, int n,
                           int ilo, int ihi, FloatBuffer h,
                           int ldh, FloatBuffer wr, FloatBuffer wi, FloatBuffer z,
                           int ldz );
public static native int LAPACKE_shseqr( int matrix_layout, @Cast("char") byte job, @Cast("char") byte compz, int n,
                           int ilo, int ihi, float[] h,
                           int ldh, float[] wr, float[] wi, float[] z,
                           int ldz );
public static native int LAPACKE_dhseqr( int matrix_layout, @Cast("char") byte job, @Cast("char") byte compz, int n,
                           int ilo, int ihi, DoublePointer h,
                           int ldh, DoublePointer wr, DoublePointer wi, DoublePointer z,
                           int ldz );
public static native int LAPACKE_dhseqr( int matrix_layout, @Cast("char") byte job, @Cast("char") byte compz, int n,
                           int ilo, int ihi, DoubleBuffer h,
                           int ldh, DoubleBuffer wr, DoubleBuffer wi, DoubleBuffer z,
                           int ldz );
public static native int LAPACKE_dhseqr( int matrix_layout, @Cast("char") byte job, @Cast("char") byte compz, int n,
                           int ilo, int ihi, double[] h,
                           int ldh, double[] wr, double[] wi, double[] z,
                           int ldz );
public static native int LAPACKE_chseqr( int matrix_layout, @Cast("char") byte job, @Cast("char") byte compz, int n,
                           int ilo, int ihi,
                           @Cast("lapack_complex_float*") FloatPointer h, int ldh,
                           @Cast("lapack_complex_float*") FloatPointer w, @Cast("lapack_complex_float*") FloatPointer z,
                           int ldz );
public static native int LAPACKE_chseqr( int matrix_layout, @Cast("char") byte job, @Cast("char") byte compz, int n,
                           int ilo, int ihi,
                           @Cast("lapack_complex_float*") FloatBuffer h, int ldh,
                           @Cast("lapack_complex_float*") FloatBuffer w, @Cast("lapack_complex_float*") FloatBuffer z,
                           int ldz );
public static native int LAPACKE_chseqr( int matrix_layout, @Cast("char") byte job, @Cast("char") byte compz, int n,
                           int ilo, int ihi,
                           @Cast("lapack_complex_float*") float[] h, int ldh,
                           @Cast("lapack_complex_float*") float[] w, @Cast("lapack_complex_float*") float[] z,
                           int ldz );
public static native int LAPACKE_zhseqr( int matrix_layout, @Cast("char") byte job, @Cast("char") byte compz, int n,
                           int ilo, int ihi,
                           @Cast("lapack_complex_double*") DoublePointer h, int ldh,
                           @Cast("lapack_complex_double*") DoublePointer w, @Cast("lapack_complex_double*") DoublePointer z,
                           int ldz );
public static native int LAPACKE_zhseqr( int matrix_layout, @Cast("char") byte job, @Cast("char") byte compz, int n,
                           int ilo, int ihi,
                           @Cast("lapack_complex_double*") DoubleBuffer h, int ldh,
                           @Cast("lapack_complex_double*") DoubleBuffer w, @Cast("lapack_complex_double*") DoubleBuffer z,
                           int ldz );
public static native int LAPACKE_zhseqr( int matrix_layout, @Cast("char") byte job, @Cast("char") byte compz, int n,
                           int ilo, int ihi,
                           @Cast("lapack_complex_double*") double[] h, int ldh,
                           @Cast("lapack_complex_double*") double[] w, @Cast("lapack_complex_double*") double[] z,
                           int ldz );

public static native int LAPACKE_clacgv( int n, @Cast("lapack_complex_float*") FloatPointer x,
                           int incx );
public static native int LAPACKE_clacgv( int n, @Cast("lapack_complex_float*") FloatBuffer x,
                           int incx );
public static native int LAPACKE_clacgv( int n, @Cast("lapack_complex_float*") float[] x,
                           int incx );
public static native int LAPACKE_zlacgv( int n, @Cast("lapack_complex_double*") DoublePointer x,
                           int incx );
public static native int LAPACKE_zlacgv( int n, @Cast("lapack_complex_double*") DoubleBuffer x,
                           int incx );
public static native int LAPACKE_zlacgv( int n, @Cast("lapack_complex_double*") double[] x,
                           int incx );

public static native int LAPACKE_slacn2( int n, FloatPointer v, FloatPointer x, IntPointer isgn,
                           FloatPointer est, IntPointer kase, IntPointer isave );
public static native int LAPACKE_slacn2( int n, FloatBuffer v, FloatBuffer x, IntBuffer isgn,
                           FloatBuffer est, IntBuffer kase, IntBuffer isave );
public static native int LAPACKE_slacn2( int n, float[] v, float[] x, int[] isgn,
                           float[] est, int[] kase, int[] isave );
public static native int LAPACKE_dlacn2( int n, DoublePointer v, DoublePointer x, IntPointer isgn,
                           DoublePointer est, IntPointer kase, IntPointer isave );
public static native int LAPACKE_dlacn2( int n, DoubleBuffer v, DoubleBuffer x, IntBuffer isgn,
                           DoubleBuffer est, IntBuffer kase, IntBuffer isave );
public static native int LAPACKE_dlacn2( int n, double[] v, double[] x, int[] isgn,
                           double[] est, int[] kase, int[] isave );
public static native int LAPACKE_clacn2( int n, @Cast("lapack_complex_float*") FloatPointer v,
                           @Cast("lapack_complex_float*") FloatPointer x,
                           FloatPointer est, IntPointer kase, IntPointer isave );
public static native int LAPACKE_clacn2( int n, @Cast("lapack_complex_float*") FloatBuffer v,
                           @Cast("lapack_complex_float*") FloatBuffer x,
                           FloatBuffer est, IntBuffer kase, IntBuffer isave );
public static native int LAPACKE_clacn2( int n, @Cast("lapack_complex_float*") float[] v,
                           @Cast("lapack_complex_float*") float[] x,
                           float[] est, int[] kase, int[] isave );
public static native int LAPACKE_zlacn2( int n, @Cast("lapack_complex_double*") DoublePointer v,
                           @Cast("lapack_complex_double*") DoublePointer x,
                           DoublePointer est, IntPointer kase, IntPointer isave );
public static native int LAPACKE_zlacn2( int n, @Cast("lapack_complex_double*") DoubleBuffer v,
                           @Cast("lapack_complex_double*") DoubleBuffer x,
                           DoubleBuffer est, IntBuffer kase, IntBuffer isave );
public static native int LAPACKE_zlacn2( int n, @Cast("lapack_complex_double*") double[] v,
                           @Cast("lapack_complex_double*") double[] x,
                           double[] est, int[] kase, int[] isave );

public static native int LAPACKE_slacpy( int matrix_layout, @Cast("char") byte uplo, int m,
                           int n, @Const FloatPointer a, int lda, FloatPointer b,
                           int ldb );
public static native int LAPACKE_slacpy( int matrix_layout, @Cast("char") byte uplo, int m,
                           int n, @Const FloatBuffer a, int lda, FloatBuffer b,
                           int ldb );
public static native int LAPACKE_slacpy( int matrix_layout, @Cast("char") byte uplo, int m,
                           int n, @Const float[] a, int lda, float[] b,
                           int ldb );
public static native int LAPACKE_dlacpy( int matrix_layout, @Cast("char") byte uplo, int m,
                           int n, @Const DoublePointer a, int lda, DoublePointer b,
                           int ldb );
public static native int LAPACKE_dlacpy( int matrix_layout, @Cast("char") byte uplo, int m,
                           int n, @Const DoubleBuffer a, int lda, DoubleBuffer b,
                           int ldb );
public static native int LAPACKE_dlacpy( int matrix_layout, @Cast("char") byte uplo, int m,
                           int n, @Const double[] a, int lda, double[] b,
                           int ldb );
public static native int LAPACKE_clacpy( int matrix_layout, @Cast("char") byte uplo, int m,
                           int n, @Cast("const lapack_complex_float*") FloatPointer a,
                           int lda, @Cast("lapack_complex_float*") FloatPointer b,
                           int ldb );
public static native int LAPACKE_clacpy( int matrix_layout, @Cast("char") byte uplo, int m,
                           int n, @Cast("const lapack_complex_float*") FloatBuffer a,
                           int lda, @Cast("lapack_complex_float*") FloatBuffer b,
                           int ldb );
public static native int LAPACKE_clacpy( int matrix_layout, @Cast("char") byte uplo, int m,
                           int n, @Cast("const lapack_complex_float*") float[] a,
                           int lda, @Cast("lapack_complex_float*") float[] b,
                           int ldb );
public static native int LAPACKE_zlacpy( int matrix_layout, @Cast("char") byte uplo, int m,
                           int n, @Cast("const lapack_complex_double*") DoublePointer a,
                           int lda, @Cast("lapack_complex_double*") DoublePointer b,
                           int ldb );
public static native int LAPACKE_zlacpy( int matrix_layout, @Cast("char") byte uplo, int m,
                           int n, @Cast("const lapack_complex_double*") DoubleBuffer a,
                           int lda, @Cast("lapack_complex_double*") DoubleBuffer b,
                           int ldb );
public static native int LAPACKE_zlacpy( int matrix_layout, @Cast("char") byte uplo, int m,
                           int n, @Cast("const lapack_complex_double*") double[] a,
                           int lda, @Cast("lapack_complex_double*") double[] b,
                           int ldb );

public static native int LAPACKE_clacp2( int matrix_layout, @Cast("char") byte uplo, int m,
                           int n, @Const FloatPointer a, int lda,
                           @Cast("lapack_complex_float*") FloatPointer b, int ldb );
public static native int LAPACKE_clacp2( int matrix_layout, @Cast("char") byte uplo, int m,
                           int n, @Const FloatBuffer a, int lda,
                           @Cast("lapack_complex_float*") FloatBuffer b, int ldb );
public static native int LAPACKE_clacp2( int matrix_layout, @Cast("char") byte uplo, int m,
                           int n, @Const float[] a, int lda,
                           @Cast("lapack_complex_float*") float[] b, int ldb );
public static native int LAPACKE_zlacp2( int matrix_layout, @Cast("char") byte uplo, int m,
                           int n, @Const DoublePointer a, int lda,
                           @Cast("lapack_complex_double*") DoublePointer b, int ldb );
public static native int LAPACKE_zlacp2( int matrix_layout, @Cast("char") byte uplo, int m,
                           int n, @Const DoubleBuffer a, int lda,
                           @Cast("lapack_complex_double*") DoubleBuffer b, int ldb );
public static native int LAPACKE_zlacp2( int matrix_layout, @Cast("char") byte uplo, int m,
                           int n, @Const double[] a, int lda,
                           @Cast("lapack_complex_double*") double[] b, int ldb );

public static native int LAPACKE_zlag2c( int matrix_layout, int m, int n,
                           @Cast("const lapack_complex_double*") DoublePointer a, int lda,
                           @Cast("lapack_complex_float*") FloatPointer sa, int ldsa );
public static native int LAPACKE_zlag2c( int matrix_layout, int m, int n,
                           @Cast("const lapack_complex_double*") DoubleBuffer a, int lda,
                           @Cast("lapack_complex_float*") FloatBuffer sa, int ldsa );
public static native int LAPACKE_zlag2c( int matrix_layout, int m, int n,
                           @Cast("const lapack_complex_double*") double[] a, int lda,
                           @Cast("lapack_complex_float*") float[] sa, int ldsa );

public static native int LAPACKE_slag2d( int matrix_layout, int m, int n,
                           @Const FloatPointer sa, int ldsa, DoublePointer a,
                           int lda );
public static native int LAPACKE_slag2d( int matrix_layout, int m, int n,
                           @Const FloatBuffer sa, int ldsa, DoubleBuffer a,
                           int lda );
public static native int LAPACKE_slag2d( int matrix_layout, int m, int n,
                           @Const float[] sa, int ldsa, double[] a,
                           int lda );

public static native int LAPACKE_dlag2s( int matrix_layout, int m, int n,
                           @Const DoublePointer a, int lda, FloatPointer sa,
                           int ldsa );
public static native int LAPACKE_dlag2s( int matrix_layout, int m, int n,
                           @Const DoubleBuffer a, int lda, FloatBuffer sa,
                           int ldsa );
public static native int LAPACKE_dlag2s( int matrix_layout, int m, int n,
                           @Const double[] a, int lda, float[] sa,
                           int ldsa );

public static native int LAPACKE_clag2z( int matrix_layout, int m, int n,
                           @Cast("const lapack_complex_float*") FloatPointer sa, int ldsa,
                           @Cast("lapack_complex_double*") DoublePointer a, int lda );
public static native int LAPACKE_clag2z( int matrix_layout, int m, int n,
                           @Cast("const lapack_complex_float*") FloatBuffer sa, int ldsa,
                           @Cast("lapack_complex_double*") DoubleBuffer a, int lda );
public static native int LAPACKE_clag2z( int matrix_layout, int m, int n,
                           @Cast("const lapack_complex_float*") float[] sa, int ldsa,
                           @Cast("lapack_complex_double*") double[] a, int lda );

public static native int LAPACKE_slagge( int matrix_layout, int m, int n,
                           int kl, int ku, @Const FloatPointer d,
                           FloatPointer a, int lda, IntPointer iseed );
public static native int LAPACKE_slagge( int matrix_layout, int m, int n,
                           int kl, int ku, @Const FloatBuffer d,
                           FloatBuffer a, int lda, IntBuffer iseed );
public static native int LAPACKE_slagge( int matrix_layout, int m, int n,
                           int kl, int ku, @Const float[] d,
                           float[] a, int lda, int[] iseed );
public static native int LAPACKE_dlagge( int matrix_layout, int m, int n,
                           int kl, int ku, @Const DoublePointer d,
                           DoublePointer a, int lda, IntPointer iseed );
public static native int LAPACKE_dlagge( int matrix_layout, int m, int n,
                           int kl, int ku, @Const DoubleBuffer d,
                           DoubleBuffer a, int lda, IntBuffer iseed );
public static native int LAPACKE_dlagge( int matrix_layout, int m, int n,
                           int kl, int ku, @Const double[] d,
                           double[] a, int lda, int[] iseed );
public static native int LAPACKE_clagge( int matrix_layout, int m, int n,
                           int kl, int ku, @Const FloatPointer d,
                           @Cast("lapack_complex_float*") FloatPointer a, int lda,
                           IntPointer iseed );
public static native int LAPACKE_clagge( int matrix_layout, int m, int n,
                           int kl, int ku, @Const FloatBuffer d,
                           @Cast("lapack_complex_float*") FloatBuffer a, int lda,
                           IntBuffer iseed );
public static native int LAPACKE_clagge( int matrix_layout, int m, int n,
                           int kl, int ku, @Const float[] d,
                           @Cast("lapack_complex_float*") float[] a, int lda,
                           int[] iseed );
public static native int LAPACKE_zlagge( int matrix_layout, int m, int n,
                           int kl, int ku, @Const DoublePointer d,
                           @Cast("lapack_complex_double*") DoublePointer a, int lda,
                           IntPointer iseed );
public static native int LAPACKE_zlagge( int matrix_layout, int m, int n,
                           int kl, int ku, @Const DoubleBuffer d,
                           @Cast("lapack_complex_double*") DoubleBuffer a, int lda,
                           IntBuffer iseed );
public static native int LAPACKE_zlagge( int matrix_layout, int m, int n,
                           int kl, int ku, @Const double[] d,
                           @Cast("lapack_complex_double*") double[] a, int lda,
                           int[] iseed );

public static native float LAPACKE_slamch( @Cast("char") byte cmach );
public static native double LAPACKE_dlamch( @Cast("char") byte cmach );

public static native float LAPACKE_slange( int matrix_layout, @Cast("char") byte norm, int m,
                           int n, @Const FloatPointer a, int lda );
public static native float LAPACKE_slange( int matrix_layout, @Cast("char") byte norm, int m,
                           int n, @Const FloatBuffer a, int lda );
public static native float LAPACKE_slange( int matrix_layout, @Cast("char") byte norm, int m,
                           int n, @Const float[] a, int lda );
public static native double LAPACKE_dlange( int matrix_layout, @Cast("char") byte norm, int m,
                           int n, @Const DoublePointer a, int lda );
public static native double LAPACKE_dlange( int matrix_layout, @Cast("char") byte norm, int m,
                           int n, @Const DoubleBuffer a, int lda );
public static native double LAPACKE_dlange( int matrix_layout, @Cast("char") byte norm, int m,
                           int n, @Const double[] a, int lda );
public static native float LAPACKE_clange( int matrix_layout, @Cast("char") byte norm, int m,
                           int n, @Cast("const lapack_complex_float*") FloatPointer a,
                           int lda );
public static native float LAPACKE_clange( int matrix_layout, @Cast("char") byte norm, int m,
                           int n, @Cast("const lapack_complex_float*") FloatBuffer a,
                           int lda );
public static native float LAPACKE_clange( int matrix_layout, @Cast("char") byte norm, int m,
                           int n, @Cast("const lapack_complex_float*") float[] a,
                           int lda );
public static native double LAPACKE_zlange( int matrix_layout, @Cast("char") byte norm, int m,
                           int n, @Cast("const lapack_complex_double*") DoublePointer a,
                           int lda );
public static native double LAPACKE_zlange( int matrix_layout, @Cast("char") byte norm, int m,
                           int n, @Cast("const lapack_complex_double*") DoubleBuffer a,
                           int lda );
public static native double LAPACKE_zlange( int matrix_layout, @Cast("char") byte norm, int m,
                           int n, @Cast("const lapack_complex_double*") double[] a,
                           int lda );

public static native float LAPACKE_clanhe( int matrix_layout, @Cast("char") byte norm, @Cast("char") byte uplo, int n,
                           @Cast("const lapack_complex_float*") FloatPointer a, int lda );
public static native float LAPACKE_clanhe( int matrix_layout, @Cast("char") byte norm, @Cast("char") byte uplo, int n,
                           @Cast("const lapack_complex_float*") FloatBuffer a, int lda );
public static native float LAPACKE_clanhe( int matrix_layout, @Cast("char") byte norm, @Cast("char") byte uplo, int n,
                           @Cast("const lapack_complex_float*") float[] a, int lda );
public static native double LAPACKE_zlanhe( int matrix_layout, @Cast("char") byte norm, @Cast("char") byte uplo, int n,
                           @Cast("const lapack_complex_double*") DoublePointer a, int lda );
public static native double LAPACKE_zlanhe( int matrix_layout, @Cast("char") byte norm, @Cast("char") byte uplo, int n,
                           @Cast("const lapack_complex_double*") DoubleBuffer a, int lda );
public static native double LAPACKE_zlanhe( int matrix_layout, @Cast("char") byte norm, @Cast("char") byte uplo, int n,
                           @Cast("const lapack_complex_double*") double[] a, int lda );







public static native float LAPACKE_slansy( int matrix_layout, @Cast("char") byte norm, @Cast("char") byte uplo, int n,
                           @Const FloatPointer a, int lda );
public static native float LAPACKE_slansy( int matrix_layout, @Cast("char") byte norm, @Cast("char") byte uplo, int n,
                           @Const FloatBuffer a, int lda );
public static native float LAPACKE_slansy( int matrix_layout, @Cast("char") byte norm, @Cast("char") byte uplo, int n,
                           @Const float[] a, int lda );
public static native double LAPACKE_dlansy( int matrix_layout, @Cast("char") byte norm, @Cast("char") byte uplo, int n,
                           @Const DoublePointer a, int lda );
public static native double LAPACKE_dlansy( int matrix_layout, @Cast("char") byte norm, @Cast("char") byte uplo, int n,
                           @Const DoubleBuffer a, int lda );
public static native double LAPACKE_dlansy( int matrix_layout, @Cast("char") byte norm, @Cast("char") byte uplo, int n,
                           @Const double[] a, int lda );
public static native float LAPACKE_clansy( int matrix_layout, @Cast("char") byte norm, @Cast("char") byte uplo, int n,
                           @Cast("const lapack_complex_float*") FloatPointer a, int lda );
public static native float LAPACKE_clansy( int matrix_layout, @Cast("char") byte norm, @Cast("char") byte uplo, int n,
                           @Cast("const lapack_complex_float*") FloatBuffer a, int lda );
public static native float LAPACKE_clansy( int matrix_layout, @Cast("char") byte norm, @Cast("char") byte uplo, int n,
                           @Cast("const lapack_complex_float*") float[] a, int lda );
public static native double LAPACKE_zlansy( int matrix_layout, @Cast("char") byte norm, @Cast("char") byte uplo, int n,
                           @Cast("const lapack_complex_double*") DoublePointer a, int lda );
public static native double LAPACKE_zlansy( int matrix_layout, @Cast("char") byte norm, @Cast("char") byte uplo, int n,
                           @Cast("const lapack_complex_double*") DoubleBuffer a, int lda );
public static native double LAPACKE_zlansy( int matrix_layout, @Cast("char") byte norm, @Cast("char") byte uplo, int n,
                           @Cast("const lapack_complex_double*") double[] a, int lda );

public static native float LAPACKE_slantr( int matrix_layout, @Cast("char") byte norm, @Cast("char") byte uplo, @Cast("char") byte diag,
                           int m, int n, @Const FloatPointer a,
                           int lda );
public static native float LAPACKE_slantr( int matrix_layout, @Cast("char") byte norm, @Cast("char") byte uplo, @Cast("char") byte diag,
                           int m, int n, @Const FloatBuffer a,
                           int lda );
public static native float LAPACKE_slantr( int matrix_layout, @Cast("char") byte norm, @Cast("char") byte uplo, @Cast("char") byte diag,
                           int m, int n, @Const float[] a,
                           int lda );
public static native double LAPACKE_dlantr( int matrix_layout, @Cast("char") byte norm, @Cast("char") byte uplo, @Cast("char") byte diag,
                           int m, int n, @Const DoublePointer a,
                           int lda );
public static native double LAPACKE_dlantr( int matrix_layout, @Cast("char") byte norm, @Cast("char") byte uplo, @Cast("char") byte diag,
                           int m, int n, @Const DoubleBuffer a,
                           int lda );
public static native double LAPACKE_dlantr( int matrix_layout, @Cast("char") byte norm, @Cast("char") byte uplo, @Cast("char") byte diag,
                           int m, int n, @Const double[] a,
                           int lda );
public static native float LAPACKE_clantr( int matrix_layout, @Cast("char") byte norm, @Cast("char") byte uplo, @Cast("char") byte diag,
                           int m, int n, @Cast("const lapack_complex_float*") FloatPointer a,
                           int lda );
public static native float LAPACKE_clantr( int matrix_layout, @Cast("char") byte norm, @Cast("char") byte uplo, @Cast("char") byte diag,
                           int m, int n, @Cast("const lapack_complex_float*") FloatBuffer a,
                           int lda );
public static native float LAPACKE_clantr( int matrix_layout, @Cast("char") byte norm, @Cast("char") byte uplo, @Cast("char") byte diag,
                           int m, int n, @Cast("const lapack_complex_float*") float[] a,
                           int lda );
public static native double LAPACKE_zlantr( int matrix_layout, @Cast("char") byte norm, @Cast("char") byte uplo, @Cast("char") byte diag,
                           int m, int n, @Cast("const lapack_complex_double*") DoublePointer a,
                           int lda );
public static native double LAPACKE_zlantr( int matrix_layout, @Cast("char") byte norm, @Cast("char") byte uplo, @Cast("char") byte diag,
                           int m, int n, @Cast("const lapack_complex_double*") DoubleBuffer a,
                           int lda );
public static native double LAPACKE_zlantr( int matrix_layout, @Cast("char") byte norm, @Cast("char") byte uplo, @Cast("char") byte diag,
                           int m, int n, @Cast("const lapack_complex_double*") double[] a,
                           int lda );


public static native int LAPACKE_slarfb( int matrix_layout, @Cast("char") byte side, @Cast("char") byte trans, @Cast("char") byte direct,
                           @Cast("char") byte storev, int m, int n,
                           int k, @Const FloatPointer v, int ldv,
                           @Const FloatPointer t, int ldt, FloatPointer c,
                           int ldc );
public static native int LAPACKE_slarfb( int matrix_layout, @Cast("char") byte side, @Cast("char") byte trans, @Cast("char") byte direct,
                           @Cast("char") byte storev, int m, int n,
                           int k, @Const FloatBuffer v, int ldv,
                           @Const FloatBuffer t, int ldt, FloatBuffer c,
                           int ldc );
public static native int LAPACKE_slarfb( int matrix_layout, @Cast("char") byte side, @Cast("char") byte trans, @Cast("char") byte direct,
                           @Cast("char") byte storev, int m, int n,
                           int k, @Const float[] v, int ldv,
                           @Const float[] t, int ldt, float[] c,
                           int ldc );
public static native int LAPACKE_dlarfb( int matrix_layout, @Cast("char") byte side, @Cast("char") byte trans, @Cast("char") byte direct,
                           @Cast("char") byte storev, int m, int n,
                           int k, @Const DoublePointer v, int ldv,
                           @Const DoublePointer t, int ldt, DoublePointer c,
                           int ldc );
public static native int LAPACKE_dlarfb( int matrix_layout, @Cast("char") byte side, @Cast("char") byte trans, @Cast("char") byte direct,
                           @Cast("char") byte storev, int m, int n,
                           int k, @Const DoubleBuffer v, int ldv,
                           @Const DoubleBuffer t, int ldt, DoubleBuffer c,
                           int ldc );
public static native int LAPACKE_dlarfb( int matrix_layout, @Cast("char") byte side, @Cast("char") byte trans, @Cast("char") byte direct,
                           @Cast("char") byte storev, int m, int n,
                           int k, @Const double[] v, int ldv,
                           @Const double[] t, int ldt, double[] c,
                           int ldc );
public static native int LAPACKE_clarfb( int matrix_layout, @Cast("char") byte side, @Cast("char") byte trans, @Cast("char") byte direct,
                           @Cast("char") byte storev, int m, int n,
                           int k, @Cast("const lapack_complex_float*") FloatPointer v,
                           int ldv, @Cast("const lapack_complex_float*") FloatPointer t,
                           int ldt, @Cast("lapack_complex_float*") FloatPointer c,
                           int ldc );
public static native int LAPACKE_clarfb( int matrix_layout, @Cast("char") byte side, @Cast("char") byte trans, @Cast("char") byte direct,
                           @Cast("char") byte storev, int m, int n,
                           int k, @Cast("const lapack_complex_float*") FloatBuffer v,
                           int ldv, @Cast("const lapack_complex_float*") FloatBuffer t,
                           int ldt, @Cast("lapack_complex_float*") FloatBuffer c,
                           int ldc );
public static native int LAPACKE_clarfb( int matrix_layout, @Cast("char") byte side, @Cast("char") byte trans, @Cast("char") byte direct,
                           @Cast("char") byte storev, int m, int n,
                           int k, @Cast("const lapack_complex_float*") float[] v,
                           int ldv, @Cast("const lapack_complex_float*") float[] t,
                           int ldt, @Cast("lapack_complex_float*") float[] c,
                           int ldc );
public static native int LAPACKE_zlarfb( int matrix_layout, @Cast("char") byte side, @Cast("char") byte trans, @Cast("char") byte direct,
                           @Cast("char") byte storev, int m, int n,
                           int k, @Cast("const lapack_complex_double*") DoublePointer v,
                           int ldv, @Cast("const lapack_complex_double*") DoublePointer t,
                           int ldt, @Cast("lapack_complex_double*") DoublePointer c,
                           int ldc );
public static native int LAPACKE_zlarfb( int matrix_layout, @Cast("char") byte side, @Cast("char") byte trans, @Cast("char") byte direct,
                           @Cast("char") byte storev, int m, int n,
                           int k, @Cast("const lapack_complex_double*") DoubleBuffer v,
                           int ldv, @Cast("const lapack_complex_double*") DoubleBuffer t,
                           int ldt, @Cast("lapack_complex_double*") DoubleBuffer c,
                           int ldc );
public static native int LAPACKE_zlarfb( int matrix_layout, @Cast("char") byte side, @Cast("char") byte trans, @Cast("char") byte direct,
                           @Cast("char") byte storev, int m, int n,
                           int k, @Cast("const lapack_complex_double*") double[] v,
                           int ldv, @Cast("const lapack_complex_double*") double[] t,
                           int ldt, @Cast("lapack_complex_double*") double[] c,
                           int ldc );

public static native int LAPACKE_slarfg( int n, FloatPointer alpha, FloatPointer x,
                           int incx, FloatPointer tau );
public static native int LAPACKE_slarfg( int n, FloatBuffer alpha, FloatBuffer x,
                           int incx, FloatBuffer tau );
public static native int LAPACKE_slarfg( int n, float[] alpha, float[] x,
                           int incx, float[] tau );
public static native int LAPACKE_dlarfg( int n, DoublePointer alpha, DoublePointer x,
                           int incx, DoublePointer tau );
public static native int LAPACKE_dlarfg( int n, DoubleBuffer alpha, DoubleBuffer x,
                           int incx, DoubleBuffer tau );
public static native int LAPACKE_dlarfg( int n, double[] alpha, double[] x,
                           int incx, double[] tau );
public static native int LAPACKE_clarfg( int n, @Cast("lapack_complex_float*") FloatPointer alpha,
                           @Cast("lapack_complex_float*") FloatPointer x, int incx,
                           @Cast("lapack_complex_float*") FloatPointer tau );
public static native int LAPACKE_clarfg( int n, @Cast("lapack_complex_float*") FloatBuffer alpha,
                           @Cast("lapack_complex_float*") FloatBuffer x, int incx,
                           @Cast("lapack_complex_float*") FloatBuffer tau );
public static native int LAPACKE_clarfg( int n, @Cast("lapack_complex_float*") float[] alpha,
                           @Cast("lapack_complex_float*") float[] x, int incx,
                           @Cast("lapack_complex_float*") float[] tau );
public static native int LAPACKE_zlarfg( int n, @Cast("lapack_complex_double*") DoublePointer alpha,
                           @Cast("lapack_complex_double*") DoublePointer x, int incx,
                           @Cast("lapack_complex_double*") DoublePointer tau );
public static native int LAPACKE_zlarfg( int n, @Cast("lapack_complex_double*") DoubleBuffer alpha,
                           @Cast("lapack_complex_double*") DoubleBuffer x, int incx,
                           @Cast("lapack_complex_double*") DoubleBuffer tau );
public static native int LAPACKE_zlarfg( int n, @Cast("lapack_complex_double*") double[] alpha,
                           @Cast("lapack_complex_double*") double[] x, int incx,
                           @Cast("lapack_complex_double*") double[] tau );

public static native int LAPACKE_slarft( int matrix_layout, @Cast("char") byte direct, @Cast("char") byte storev,
                           int n, int k, @Const FloatPointer v,
                           int ldv, @Const FloatPointer tau, FloatPointer t,
                           int ldt );
public static native int LAPACKE_slarft( int matrix_layout, @Cast("char") byte direct, @Cast("char") byte storev,
                           int n, int k, @Const FloatBuffer v,
                           int ldv, @Const FloatBuffer tau, FloatBuffer t,
                           int ldt );
public static native int LAPACKE_slarft( int matrix_layout, @Cast("char") byte direct, @Cast("char") byte storev,
                           int n, int k, @Const float[] v,
                           int ldv, @Const float[] tau, float[] t,
                           int ldt );
public static native int LAPACKE_dlarft( int matrix_layout, @Cast("char") byte direct, @Cast("char") byte storev,
                           int n, int k, @Const DoublePointer v,
                           int ldv, @Const DoublePointer tau, DoublePointer t,
                           int ldt );
public static native int LAPACKE_dlarft( int matrix_layout, @Cast("char") byte direct, @Cast("char") byte storev,
                           int n, int k, @Const DoubleBuffer v,
                           int ldv, @Const DoubleBuffer tau, DoubleBuffer t,
                           int ldt );
public static native int LAPACKE_dlarft( int matrix_layout, @Cast("char") byte direct, @Cast("char") byte storev,
                           int n, int k, @Const double[] v,
                           int ldv, @Const double[] tau, double[] t,
                           int ldt );
public static native int LAPACKE_clarft( int matrix_layout, @Cast("char") byte direct, @Cast("char") byte storev,
                           int n, int k,
                           @Cast("const lapack_complex_float*") FloatPointer v, int ldv,
                           @Cast("const lapack_complex_float*") FloatPointer tau,
                           @Cast("lapack_complex_float*") FloatPointer t, int ldt );
public static native int LAPACKE_clarft( int matrix_layout, @Cast("char") byte direct, @Cast("char") byte storev,
                           int n, int k,
                           @Cast("const lapack_complex_float*") FloatBuffer v, int ldv,
                           @Cast("const lapack_complex_float*") FloatBuffer tau,
                           @Cast("lapack_complex_float*") FloatBuffer t, int ldt );
public static native int LAPACKE_clarft( int matrix_layout, @Cast("char") byte direct, @Cast("char") byte storev,
                           int n, int k,
                           @Cast("const lapack_complex_float*") float[] v, int ldv,
                           @Cast("const lapack_complex_float*") float[] tau,
                           @Cast("lapack_complex_float*") float[] t, int ldt );
public static native int LAPACKE_zlarft( int matrix_layout, @Cast("char") byte direct, @Cast("char") byte storev,
                           int n, int k,
                           @Cast("const lapack_complex_double*") DoublePointer v, int ldv,
                           @Cast("const lapack_complex_double*") DoublePointer tau,
                           @Cast("lapack_complex_double*") DoublePointer t, int ldt );
public static native int LAPACKE_zlarft( int matrix_layout, @Cast("char") byte direct, @Cast("char") byte storev,
                           int n, int k,
                           @Cast("const lapack_complex_double*") DoubleBuffer v, int ldv,
                           @Cast("const lapack_complex_double*") DoubleBuffer tau,
                           @Cast("lapack_complex_double*") DoubleBuffer t, int ldt );
public static native int LAPACKE_zlarft( int matrix_layout, @Cast("char") byte direct, @Cast("char") byte storev,
                           int n, int k,
                           @Cast("const lapack_complex_double*") double[] v, int ldv,
                           @Cast("const lapack_complex_double*") double[] tau,
                           @Cast("lapack_complex_double*") double[] t, int ldt );

public static native int LAPACKE_slarfx( int matrix_layout, @Cast("char") byte side, int m,
                           int n, @Const FloatPointer v, float tau, FloatPointer c,
                           int ldc, FloatPointer work );
public static native int LAPACKE_slarfx( int matrix_layout, @Cast("char") byte side, int m,
                           int n, @Const FloatBuffer v, float tau, FloatBuffer c,
                           int ldc, FloatBuffer work );
public static native int LAPACKE_slarfx( int matrix_layout, @Cast("char") byte side, int m,
                           int n, @Const float[] v, float tau, float[] c,
                           int ldc, float[] work );
public static native int LAPACKE_dlarfx( int matrix_layout, @Cast("char") byte side, int m,
                           int n, @Const DoublePointer v, double tau, DoublePointer c,
                           int ldc, DoublePointer work );
public static native int LAPACKE_dlarfx( int matrix_layout, @Cast("char") byte side, int m,
                           int n, @Const DoubleBuffer v, double tau, DoubleBuffer c,
                           int ldc, DoubleBuffer work );
public static native int LAPACKE_dlarfx( int matrix_layout, @Cast("char") byte side, int m,
                           int n, @Const double[] v, double tau, double[] c,
                           int ldc, double[] work );
public static native int LAPACKE_clarfx( int matrix_layout, @Cast("char") byte side, int m,
                           int n, @Cast("const lapack_complex_float*") FloatPointer v,
                           @ByVal @Cast("lapack_complex_float*") FloatPointer tau, @Cast("lapack_complex_float*") FloatPointer c,
                           int ldc, @Cast("lapack_complex_float*") FloatPointer work );
public static native int LAPACKE_clarfx( int matrix_layout, @Cast("char") byte side, int m,
                           int n, @Cast("const lapack_complex_float*") FloatBuffer v,
                           @ByVal @Cast("lapack_complex_float*") FloatBuffer tau, @Cast("lapack_complex_float*") FloatBuffer c,
                           int ldc, @Cast("lapack_complex_float*") FloatBuffer work );
public static native int LAPACKE_clarfx( int matrix_layout, @Cast("char") byte side, int m,
                           int n, @Cast("const lapack_complex_float*") float[] v,
                           @ByVal @Cast("lapack_complex_float*") float[] tau, @Cast("lapack_complex_float*") float[] c,
                           int ldc, @Cast("lapack_complex_float*") float[] work );
public static native int LAPACKE_zlarfx( int matrix_layout, @Cast("char") byte side, int m,
                           int n, @Cast("const lapack_complex_double*") DoublePointer v,
                           @ByVal @Cast("lapack_complex_double*") DoublePointer tau, @Cast("lapack_complex_double*") DoublePointer c,
                           int ldc, @Cast("lapack_complex_double*") DoublePointer work );
public static native int LAPACKE_zlarfx( int matrix_layout, @Cast("char") byte side, int m,
                           int n, @Cast("const lapack_complex_double*") DoubleBuffer v,
                           @ByVal @Cast("lapack_complex_double*") DoubleBuffer tau, @Cast("lapack_complex_double*") DoubleBuffer c,
                           int ldc, @Cast("lapack_complex_double*") DoubleBuffer work );
public static native int LAPACKE_zlarfx( int matrix_layout, @Cast("char") byte side, int m,
                           int n, @Cast("const lapack_complex_double*") double[] v,
                           @ByVal @Cast("lapack_complex_double*") double[] tau, @Cast("lapack_complex_double*") double[] c,
                           int ldc, @Cast("lapack_complex_double*") double[] work );

public static native int LAPACKE_slarnv( int idist, IntPointer iseed, int n,
                           FloatPointer x );
public static native int LAPACKE_slarnv( int idist, IntBuffer iseed, int n,
                           FloatBuffer x );
public static native int LAPACKE_slarnv( int idist, int[] iseed, int n,
                           float[] x );
public static native int LAPACKE_dlarnv( int idist, IntPointer iseed, int n,
                           DoublePointer x );
public static native int LAPACKE_dlarnv( int idist, IntBuffer iseed, int n,
                           DoubleBuffer x );
public static native int LAPACKE_dlarnv( int idist, int[] iseed, int n,
                           double[] x );
public static native int LAPACKE_clarnv( int idist, IntPointer iseed, int n,
                           @Cast("lapack_complex_float*") FloatPointer x );
public static native int LAPACKE_clarnv( int idist, IntBuffer iseed, int n,
                           @Cast("lapack_complex_float*") FloatBuffer x );
public static native int LAPACKE_clarnv( int idist, int[] iseed, int n,
                           @Cast("lapack_complex_float*") float[] x );
public static native int LAPACKE_zlarnv( int idist, IntPointer iseed, int n,
                           @Cast("lapack_complex_double*") DoublePointer x );
public static native int LAPACKE_zlarnv( int idist, IntBuffer iseed, int n,
                           @Cast("lapack_complex_double*") DoubleBuffer x );
public static native int LAPACKE_zlarnv( int idist, int[] iseed, int n,
                           @Cast("lapack_complex_double*") double[] x );

public static native int LAPACKE_slascl( int matrix_layout, @Cast("char") byte type, int kl,
                           int ku, float cfrom, float cto,
                           int m, int n, FloatPointer a,
                           int lda );
public static native int LAPACKE_slascl( int matrix_layout, @Cast("char") byte type, int kl,
                           int ku, float cfrom, float cto,
                           int m, int n, FloatBuffer a,
                           int lda );
public static native int LAPACKE_slascl( int matrix_layout, @Cast("char") byte type, int kl,
                           int ku, float cfrom, float cto,
                           int m, int n, float[] a,
                           int lda );
public static native int LAPACKE_dlascl( int matrix_layout, @Cast("char") byte type, int kl,
                           int ku, double cfrom, double cto,
                           int m, int n, DoublePointer a,
                           int lda );
public static native int LAPACKE_dlascl( int matrix_layout, @Cast("char") byte type, int kl,
                           int ku, double cfrom, double cto,
                           int m, int n, DoubleBuffer a,
                           int lda );
public static native int LAPACKE_dlascl( int matrix_layout, @Cast("char") byte type, int kl,
                           int ku, double cfrom, double cto,
                           int m, int n, double[] a,
                           int lda );
public static native int LAPACKE_clascl( int matrix_layout, @Cast("char") byte type, int kl,
                           int ku, float cfrom, float cto,
                           int m, int n, @Cast("lapack_complex_float*") FloatPointer a,
                           int lda );
public static native int LAPACKE_clascl( int matrix_layout, @Cast("char") byte type, int kl,
                           int ku, float cfrom, float cto,
                           int m, int n, @Cast("lapack_complex_float*") FloatBuffer a,
                           int lda );
public static native int LAPACKE_clascl( int matrix_layout, @Cast("char") byte type, int kl,
                           int ku, float cfrom, float cto,
                           int m, int n, @Cast("lapack_complex_float*") float[] a,
                           int lda );
public static native int LAPACKE_zlascl( int matrix_layout, @Cast("char") byte type, int kl,
                           int ku, double cfrom, double cto,
                           int m, int n, @Cast("lapack_complex_double*") DoublePointer a,
                           int lda );
public static native int LAPACKE_zlascl( int matrix_layout, @Cast("char") byte type, int kl,
                           int ku, double cfrom, double cto,
                           int m, int n, @Cast("lapack_complex_double*") DoubleBuffer a,
                           int lda );
public static native int LAPACKE_zlascl( int matrix_layout, @Cast("char") byte type, int kl,
                           int ku, double cfrom, double cto,
                           int m, int n, @Cast("lapack_complex_double*") double[] a,
                           int lda );

public static native int LAPACKE_slaset( int matrix_layout, @Cast("char") byte uplo, int m,
                           int n, float alpha, float beta, FloatPointer a,
                           int lda );
public static native int LAPACKE_slaset( int matrix_layout, @Cast("char") byte uplo, int m,
                           int n, float alpha, float beta, FloatBuffer a,
                           int lda );
public static native int LAPACKE_slaset( int matrix_layout, @Cast("char") byte uplo, int m,
                           int n, float alpha, float beta, float[] a,
                           int lda );
public static native int LAPACKE_dlaset( int matrix_layout, @Cast("char") byte uplo, int m,
                           int n, double alpha, double beta, DoublePointer a,
                           int lda );
public static native int LAPACKE_dlaset( int matrix_layout, @Cast("char") byte uplo, int m,
                           int n, double alpha, double beta, DoubleBuffer a,
                           int lda );
public static native int LAPACKE_dlaset( int matrix_layout, @Cast("char") byte uplo, int m,
                           int n, double alpha, double beta, double[] a,
                           int lda );
public static native int LAPACKE_claset( int matrix_layout, @Cast("char") byte uplo, int m,
                           int n, @ByVal @Cast("lapack_complex_float*") FloatPointer alpha,
                           @ByVal @Cast("lapack_complex_float*") FloatPointer beta, @Cast("lapack_complex_float*") FloatPointer a,
                           int lda );
public static native int LAPACKE_claset( int matrix_layout, @Cast("char") byte uplo, int m,
                           int n, @ByVal @Cast("lapack_complex_float*") FloatBuffer alpha,
                           @ByVal @Cast("lapack_complex_float*") FloatBuffer beta, @Cast("lapack_complex_float*") FloatBuffer a,
                           int lda );
public static native int LAPACKE_claset( int matrix_layout, @Cast("char") byte uplo, int m,
                           int n, @ByVal @Cast("lapack_complex_float*") float[] alpha,
                           @ByVal @Cast("lapack_complex_float*") float[] beta, @Cast("lapack_complex_float*") float[] a,
                           int lda );
public static native int LAPACKE_zlaset( int matrix_layout, @Cast("char") byte uplo, int m,
                           int n, @ByVal @Cast("lapack_complex_double*") DoublePointer alpha,
                           @ByVal @Cast("lapack_complex_double*") DoublePointer beta, @Cast("lapack_complex_double*") DoublePointer a,
                           int lda );
public static native int LAPACKE_zlaset( int matrix_layout, @Cast("char") byte uplo, int m,
                           int n, @ByVal @Cast("lapack_complex_double*") DoubleBuffer alpha,
                           @ByVal @Cast("lapack_complex_double*") DoubleBuffer beta, @Cast("lapack_complex_double*") DoubleBuffer a,
                           int lda );
public static native int LAPACKE_zlaset( int matrix_layout, @Cast("char") byte uplo, int m,
                           int n, @ByVal @Cast("lapack_complex_double*") double[] alpha,
                           @ByVal @Cast("lapack_complex_double*") double[] beta, @Cast("lapack_complex_double*") double[] a,
                           int lda );

public static native int LAPACKE_slasrt( @Cast("char") byte id, int n, FloatPointer d );
public static native int LAPACKE_slasrt( @Cast("char") byte id, int n, FloatBuffer d );
public static native int LAPACKE_slasrt( @Cast("char") byte id, int n, float[] d );
public static native int LAPACKE_dlasrt( @Cast("char") byte id, int n, DoublePointer d );
public static native int LAPACKE_dlasrt( @Cast("char") byte id, int n, DoubleBuffer d );
public static native int LAPACKE_dlasrt( @Cast("char") byte id, int n, double[] d );






public static native int LAPACKE_slaswp( int matrix_layout, int n, FloatPointer a,
                           int lda, int k1, int k2,
                           @Const IntPointer ipiv, int incx );
public static native int LAPACKE_slaswp( int matrix_layout, int n, FloatBuffer a,
                           int lda, int k1, int k2,
                           @Const IntBuffer ipiv, int incx );
public static native int LAPACKE_slaswp( int matrix_layout, int n, float[] a,
                           int lda, int k1, int k2,
                           @Const int[] ipiv, int incx );
public static native int LAPACKE_dlaswp( int matrix_layout, int n, DoublePointer a,
                           int lda, int k1, int k2,
                           @Const IntPointer ipiv, int incx );
public static native int LAPACKE_dlaswp( int matrix_layout, int n, DoubleBuffer a,
                           int lda, int k1, int k2,
                           @Const IntBuffer ipiv, int incx );
public static native int LAPACKE_dlaswp( int matrix_layout, int n, double[] a,
                           int lda, int k1, int k2,
                           @Const int[] ipiv, int incx );
public static native int LAPACKE_claswp( int matrix_layout, int n,
                           @Cast("lapack_complex_float*") FloatPointer a, int lda,
                           int k1, int k2, @Const IntPointer ipiv,
                           int incx );
public static native int LAPACKE_claswp( int matrix_layout, int n,
                           @Cast("lapack_complex_float*") FloatBuffer a, int lda,
                           int k1, int k2, @Const IntBuffer ipiv,
                           int incx );
public static native int LAPACKE_claswp( int matrix_layout, int n,
                           @Cast("lapack_complex_float*") float[] a, int lda,
                           int k1, int k2, @Const int[] ipiv,
                           int incx );
public static native int LAPACKE_zlaswp( int matrix_layout, int n,
                           @Cast("lapack_complex_double*") DoublePointer a, int lda,
                           int k1, int k2, @Const IntPointer ipiv,
                           int incx );
public static native int LAPACKE_zlaswp( int matrix_layout, int n,
                           @Cast("lapack_complex_double*") DoubleBuffer a, int lda,
                           int k1, int k2, @Const IntBuffer ipiv,
                           int incx );
public static native int LAPACKE_zlaswp( int matrix_layout, int n,
                           @Cast("lapack_complex_double*") double[] a, int lda,
                           int k1, int k2, @Const int[] ipiv,
                           int incx );

public static native int LAPACKE_slatms( int matrix_layout, int m, int n,
                           @Cast("char") byte dist, IntPointer iseed, @Cast("char") byte sym, FloatPointer d,
                           int mode, float cond, float dmax,
                           int kl, int ku, @Cast("char") byte pack, FloatPointer a,
                           int lda );
public static native int LAPACKE_slatms( int matrix_layout, int m, int n,
                           @Cast("char") byte dist, IntBuffer iseed, @Cast("char") byte sym, FloatBuffer d,
                           int mode, float cond, float dmax,
                           int kl, int ku, @Cast("char") byte pack, FloatBuffer a,
                           int lda );
public static native int LAPACKE_slatms( int matrix_layout, int m, int n,
                           @Cast("char") byte dist, int[] iseed, @Cast("char") byte sym, float[] d,
                           int mode, float cond, float dmax,
                           int kl, int ku, @Cast("char") byte pack, float[] a,
                           int lda );
public static native int LAPACKE_dlatms( int matrix_layout, int m, int n,
                           @Cast("char") byte dist, IntPointer iseed, @Cast("char") byte sym, DoublePointer d,
                           int mode, double cond, double dmax,
                           int kl, int ku, @Cast("char") byte pack, DoublePointer a,
                           int lda );
public static native int LAPACKE_dlatms( int matrix_layout, int m, int n,
                           @Cast("char") byte dist, IntBuffer iseed, @Cast("char") byte sym, DoubleBuffer d,
                           int mode, double cond, double dmax,
                           int kl, int ku, @Cast("char") byte pack, DoubleBuffer a,
                           int lda );
public static native int LAPACKE_dlatms( int matrix_layout, int m, int n,
                           @Cast("char") byte dist, int[] iseed, @Cast("char") byte sym, double[] d,
                           int mode, double cond, double dmax,
                           int kl, int ku, @Cast("char") byte pack, double[] a,
                           int lda );
public static native int LAPACKE_clatms( int matrix_layout, int m, int n,
                           @Cast("char") byte dist, IntPointer iseed, @Cast("char") byte sym, FloatPointer d,
                           int mode, float cond, float dmax,
                           int kl, int ku, @Cast("char") byte pack,
                           @Cast("lapack_complex_float*") FloatPointer a, int lda );
public static native int LAPACKE_clatms( int matrix_layout, int m, int n,
                           @Cast("char") byte dist, IntBuffer iseed, @Cast("char") byte sym, FloatBuffer d,
                           int mode, float cond, float dmax,
                           int kl, int ku, @Cast("char") byte pack,
                           @Cast("lapack_complex_float*") FloatBuffer a, int lda );
public static native int LAPACKE_clatms( int matrix_layout, int m, int n,
                           @Cast("char") byte dist, int[] iseed, @Cast("char") byte sym, float[] d,
                           int mode, float cond, float dmax,
                           int kl, int ku, @Cast("char") byte pack,
                           @Cast("lapack_complex_float*") float[] a, int lda );
public static native int LAPACKE_zlatms( int matrix_layout, int m, int n,
                           @Cast("char") byte dist, IntPointer iseed, @Cast("char") byte sym, DoublePointer d,
                           int mode, double cond, double dmax,
                           int kl, int ku, @Cast("char") byte pack,
                           @Cast("lapack_complex_double*") DoublePointer a, int lda );
public static native int LAPACKE_zlatms( int matrix_layout, int m, int n,
                           @Cast("char") byte dist, IntBuffer iseed, @Cast("char") byte sym, DoubleBuffer d,
                           int mode, double cond, double dmax,
                           int kl, int ku, @Cast("char") byte pack,
                           @Cast("lapack_complex_double*") DoubleBuffer a, int lda );
public static native int LAPACKE_zlatms( int matrix_layout, int m, int n,
                           @Cast("char") byte dist, int[] iseed, @Cast("char") byte sym, double[] d,
                           int mode, double cond, double dmax,
                           int kl, int ku, @Cast("char") byte pack,
                           @Cast("lapack_complex_double*") double[] a, int lda );

public static native int LAPACKE_slauum( int matrix_layout, @Cast("char") byte uplo, int n, FloatPointer a,
                           int lda );
public static native int LAPACKE_slauum( int matrix_layout, @Cast("char") byte uplo, int n, FloatBuffer a,
                           int lda );
public static native int LAPACKE_slauum( int matrix_layout, @Cast("char") byte uplo, int n, float[] a,
                           int lda );
public static native int LAPACKE_dlauum( int matrix_layout, @Cast("char") byte uplo, int n, DoublePointer a,
                           int lda );
public static native int LAPACKE_dlauum( int matrix_layout, @Cast("char") byte uplo, int n, DoubleBuffer a,
                           int lda );
public static native int LAPACKE_dlauum( int matrix_layout, @Cast("char") byte uplo, int n, double[] a,
                           int lda );
public static native int LAPACKE_clauum( int matrix_layout, @Cast("char") byte uplo, int n,
                           @Cast("lapack_complex_float*") FloatPointer a, int lda );
public static native int LAPACKE_clauum( int matrix_layout, @Cast("char") byte uplo, int n,
                           @Cast("lapack_complex_float*") FloatBuffer a, int lda );
public static native int LAPACKE_clauum( int matrix_layout, @Cast("char") byte uplo, int n,
                           @Cast("lapack_complex_float*") float[] a, int lda );
public static native int LAPACKE_zlauum( int matrix_layout, @Cast("char") byte uplo, int n,
                           @Cast("lapack_complex_double*") DoublePointer a, int lda );
public static native int LAPACKE_zlauum( int matrix_layout, @Cast("char") byte uplo, int n,
                           @Cast("lapack_complex_double*") DoubleBuffer a, int lda );
public static native int LAPACKE_zlauum( int matrix_layout, @Cast("char") byte uplo, int n,
                           @Cast("lapack_complex_double*") double[] a, int lda );

public static native int LAPACKE_sopgtr( int matrix_layout, @Cast("char") byte uplo, int n,
                           @Const FloatPointer ap, @Const FloatPointer tau, FloatPointer q,
                           int ldq );
public static native int LAPACKE_sopgtr( int matrix_layout, @Cast("char") byte uplo, int n,
                           @Const FloatBuffer ap, @Const FloatBuffer tau, FloatBuffer q,
                           int ldq );
public static native int LAPACKE_sopgtr( int matrix_layout, @Cast("char") byte uplo, int n,
                           @Const float[] ap, @Const float[] tau, float[] q,
                           int ldq );
public static native int LAPACKE_dopgtr( int matrix_layout, @Cast("char") byte uplo, int n,
                           @Const DoublePointer ap, @Const DoublePointer tau, DoublePointer q,
                           int ldq );
public static native int LAPACKE_dopgtr( int matrix_layout, @Cast("char") byte uplo, int n,
                           @Const DoubleBuffer ap, @Const DoubleBuffer tau, DoubleBuffer q,
                           int ldq );
public static native int LAPACKE_dopgtr( int matrix_layout, @Cast("char") byte uplo, int n,
                           @Const double[] ap, @Const double[] tau, double[] q,
                           int ldq );

public static native int LAPACKE_sopmtr( int matrix_layout, @Cast("char") byte side, @Cast("char") byte uplo, @Cast("char") byte trans,
                           int m, int n, @Const FloatPointer ap,
                           @Const FloatPointer tau, FloatPointer c, int ldc );
public static native int LAPACKE_sopmtr( int matrix_layout, @Cast("char") byte side, @Cast("char") byte uplo, @Cast("char") byte trans,
                           int m, int n, @Const FloatBuffer ap,
                           @Const FloatBuffer tau, FloatBuffer c, int ldc );
public static native int LAPACKE_sopmtr( int matrix_layout, @Cast("char") byte side, @Cast("char") byte uplo, @Cast("char") byte trans,
                           int m, int n, @Const float[] ap,
                           @Const float[] tau, float[] c, int ldc );
public static native int LAPACKE_dopmtr( int matrix_layout, @Cast("char") byte side, @Cast("char") byte uplo, @Cast("char") byte trans,
                           int m, int n, @Const DoublePointer ap,
                           @Const DoublePointer tau, DoublePointer c, int ldc );
public static native int LAPACKE_dopmtr( int matrix_layout, @Cast("char") byte side, @Cast("char") byte uplo, @Cast("char") byte trans,
                           int m, int n, @Const DoubleBuffer ap,
                           @Const DoubleBuffer tau, DoubleBuffer c, int ldc );
public static native int LAPACKE_dopmtr( int matrix_layout, @Cast("char") byte side, @Cast("char") byte uplo, @Cast("char") byte trans,
                           int m, int n, @Const double[] ap,
                           @Const double[] tau, double[] c, int ldc );

public static native int LAPACKE_sorgbr( int matrix_layout, @Cast("char") byte vect, int m,
                           int n, int k, FloatPointer a, int lda,
                           @Const FloatPointer tau );
public static native int LAPACKE_sorgbr( int matrix_layout, @Cast("char") byte vect, int m,
                           int n, int k, FloatBuffer a, int lda,
                           @Const FloatBuffer tau );
public static native int LAPACKE_sorgbr( int matrix_layout, @Cast("char") byte vect, int m,
                           int n, int k, float[] a, int lda,
                           @Const float[] tau );
public static native int LAPACKE_dorgbr( int matrix_layout, @Cast("char") byte vect, int m,
                           int n, int k, DoublePointer a,
                           int lda, @Const DoublePointer tau );
public static native int LAPACKE_dorgbr( int matrix_layout, @Cast("char") byte vect, int m,
                           int n, int k, DoubleBuffer a,
                           int lda, @Const DoubleBuffer tau );
public static native int LAPACKE_dorgbr( int matrix_layout, @Cast("char") byte vect, int m,
                           int n, int k, double[] a,
                           int lda, @Const double[] tau );

public static native int LAPACKE_sorghr( int matrix_layout, int n, int ilo,
                           int ihi, FloatPointer a, int lda,
                           @Const FloatPointer tau );
public static native int LAPACKE_sorghr( int matrix_layout, int n, int ilo,
                           int ihi, FloatBuffer a, int lda,
                           @Const FloatBuffer tau );
public static native int LAPACKE_sorghr( int matrix_layout, int n, int ilo,
                           int ihi, float[] a, int lda,
                           @Const float[] tau );
public static native int LAPACKE_dorghr( int matrix_layout, int n, int ilo,
                           int ihi, DoublePointer a, int lda,
                           @Const DoublePointer tau );
public static native int LAPACKE_dorghr( int matrix_layout, int n, int ilo,
                           int ihi, DoubleBuffer a, int lda,
                           @Const DoubleBuffer tau );
public static native int LAPACKE_dorghr( int matrix_layout, int n, int ilo,
                           int ihi, double[] a, int lda,
                           @Const double[] tau );

public static native int LAPACKE_sorglq( int matrix_layout, int m, int n,
                           int k, FloatPointer a, int lda,
                           @Const FloatPointer tau );
public static native int LAPACKE_sorglq( int matrix_layout, int m, int n,
                           int k, FloatBuffer a, int lda,
                           @Const FloatBuffer tau );
public static native int LAPACKE_sorglq( int matrix_layout, int m, int n,
                           int k, float[] a, int lda,
                           @Const float[] tau );
public static native int LAPACKE_dorglq( int matrix_layout, int m, int n,
                           int k, DoublePointer a, int lda,
                           @Const DoublePointer tau );
public static native int LAPACKE_dorglq( int matrix_layout, int m, int n,
                           int k, DoubleBuffer a, int lda,
                           @Const DoubleBuffer tau );
public static native int LAPACKE_dorglq( int matrix_layout, int m, int n,
                           int k, double[] a, int lda,
                           @Const double[] tau );

public static native int LAPACKE_sorgql( int matrix_layout, int m, int n,
                           int k, FloatPointer a, int lda,
                           @Const FloatPointer tau );
public static native int LAPACKE_sorgql( int matrix_layout, int m, int n,
                           int k, FloatBuffer a, int lda,
                           @Const FloatBuffer tau );
public static native int LAPACKE_sorgql( int matrix_layout, int m, int n,
                           int k, float[] a, int lda,
                           @Const float[] tau );
public static native int LAPACKE_dorgql( int matrix_layout, int m, int n,
                           int k, DoublePointer a, int lda,
                           @Const DoublePointer tau );
public static native int LAPACKE_dorgql( int matrix_layout, int m, int n,
                           int k, DoubleBuffer a, int lda,
                           @Const DoubleBuffer tau );
public static native int LAPACKE_dorgql( int matrix_layout, int m, int n,
                           int k, double[] a, int lda,
                           @Const double[] tau );

public static native int LAPACKE_sorgqr( int matrix_layout, int m, int n,
                           int k, FloatPointer a, int lda,
                           @Const FloatPointer tau );
public static native int LAPACKE_sorgqr( int matrix_layout, int m, int n,
                           int k, FloatBuffer a, int lda,
                           @Const FloatBuffer tau );
public static native int LAPACKE_sorgqr( int matrix_layout, int m, int n,
                           int k, float[] a, int lda,
                           @Const float[] tau );
public static native int LAPACKE_dorgqr( int matrix_layout, int m, int n,
                           int k, DoublePointer a, int lda,
                           @Const DoublePointer tau );
public static native int LAPACKE_dorgqr( int matrix_layout, int m, int n,
                           int k, DoubleBuffer a, int lda,
                           @Const DoubleBuffer tau );
public static native int LAPACKE_dorgqr( int matrix_layout, int m, int n,
                           int k, double[] a, int lda,
                           @Const double[] tau );

public static native int LAPACKE_sorgrq( int matrix_layout, int m, int n,
                           int k, FloatPointer a, int lda,
                           @Const FloatPointer tau );
public static native int LAPACKE_sorgrq( int matrix_layout, int m, int n,
                           int k, FloatBuffer a, int lda,
                           @Const FloatBuffer tau );
public static native int LAPACKE_sorgrq( int matrix_layout, int m, int n,
                           int k, float[] a, int lda,
                           @Const float[] tau );
public static native int LAPACKE_dorgrq( int matrix_layout, int m, int n,
                           int k, DoublePointer a, int lda,
                           @Const DoublePointer tau );
public static native int LAPACKE_dorgrq( int matrix_layout, int m, int n,
                           int k, DoubleBuffer a, int lda,
                           @Const DoubleBuffer tau );
public static native int LAPACKE_dorgrq( int matrix_layout, int m, int n,
                           int k, double[] a, int lda,
                           @Const double[] tau );

public static native int LAPACKE_sorgtr( int matrix_layout, @Cast("char") byte uplo, int n, FloatPointer a,
                           int lda, @Const FloatPointer tau );
public static native int LAPACKE_sorgtr( int matrix_layout, @Cast("char") byte uplo, int n, FloatBuffer a,
                           int lda, @Const FloatBuffer tau );
public static native int LAPACKE_sorgtr( int matrix_layout, @Cast("char") byte uplo, int n, float[] a,
                           int lda, @Const float[] tau );
public static native int LAPACKE_dorgtr( int matrix_layout, @Cast("char") byte uplo, int n, DoublePointer a,
                           int lda, @Const DoublePointer tau );
public static native int LAPACKE_dorgtr( int matrix_layout, @Cast("char") byte uplo, int n, DoubleBuffer a,
                           int lda, @Const DoubleBuffer tau );
public static native int LAPACKE_dorgtr( int matrix_layout, @Cast("char") byte uplo, int n, double[] a,
                           int lda, @Const double[] tau );

public static native int LAPACKE_sormbr( int matrix_layout, @Cast("char") byte vect, @Cast("char") byte side, @Cast("char") byte trans,
                           int m, int n, int k,
                           @Const FloatPointer a, int lda, @Const FloatPointer tau,
                           FloatPointer c, int ldc );
public static native int LAPACKE_sormbr( int matrix_layout, @Cast("char") byte vect, @Cast("char") byte side, @Cast("char") byte trans,
                           int m, int n, int k,
                           @Const FloatBuffer a, int lda, @Const FloatBuffer tau,
                           FloatBuffer c, int ldc );
public static native int LAPACKE_sormbr( int matrix_layout, @Cast("char") byte vect, @Cast("char") byte side, @Cast("char") byte trans,
                           int m, int n, int k,
                           @Const float[] a, int lda, @Const float[] tau,
                           float[] c, int ldc );
public static native int LAPACKE_dormbr( int matrix_layout, @Cast("char") byte vect, @Cast("char") byte side, @Cast("char") byte trans,
                           int m, int n, int k,
                           @Const DoublePointer a, int lda, @Const DoublePointer tau,
                           DoublePointer c, int ldc );
public static native int LAPACKE_dormbr( int matrix_layout, @Cast("char") byte vect, @Cast("char") byte side, @Cast("char") byte trans,
                           int m, int n, int k,
                           @Const DoubleBuffer a, int lda, @Const DoubleBuffer tau,
                           DoubleBuffer c, int ldc );
public static native int LAPACKE_dormbr( int matrix_layout, @Cast("char") byte vect, @Cast("char") byte side, @Cast("char") byte trans,
                           int m, int n, int k,
                           @Const double[] a, int lda, @Const double[] tau,
                           double[] c, int ldc );

public static native int LAPACKE_sormhr( int matrix_layout, @Cast("char") byte side, @Cast("char") byte trans,
                           int m, int n, int ilo,
                           int ihi, @Const FloatPointer a, int lda,
                           @Const FloatPointer tau, FloatPointer c, int ldc );
public static native int LAPACKE_sormhr( int matrix_layout, @Cast("char") byte side, @Cast("char") byte trans,
                           int m, int n, int ilo,
                           int ihi, @Const FloatBuffer a, int lda,
                           @Const FloatBuffer tau, FloatBuffer c, int ldc );
public static native int LAPACKE_sormhr( int matrix_layout, @Cast("char") byte side, @Cast("char") byte trans,
                           int m, int n, int ilo,
                           int ihi, @Const float[] a, int lda,
                           @Const float[] tau, float[] c, int ldc );
public static native int LAPACKE_dormhr( int matrix_layout, @Cast("char") byte side, @Cast("char") byte trans,
                           int m, int n, int ilo,
                           int ihi, @Const DoublePointer a, int lda,
                           @Const DoublePointer tau, DoublePointer c, int ldc );
public static native int LAPACKE_dormhr( int matrix_layout, @Cast("char") byte side, @Cast("char") byte trans,
                           int m, int n, int ilo,
                           int ihi, @Const DoubleBuffer a, int lda,
                           @Const DoubleBuffer tau, DoubleBuffer c, int ldc );
public static native int LAPACKE_dormhr( int matrix_layout, @Cast("char") byte side, @Cast("char") byte trans,
                           int m, int n, int ilo,
                           int ihi, @Const double[] a, int lda,
                           @Const double[] tau, double[] c, int ldc );

public static native int LAPACKE_sormlq( int matrix_layout, @Cast("char") byte side, @Cast("char") byte trans,
                           int m, int n, int k,
                           @Const FloatPointer a, int lda, @Const FloatPointer tau,
                           FloatPointer c, int ldc );
public static native int LAPACKE_sormlq( int matrix_layout, @Cast("char") byte side, @Cast("char") byte trans,
                           int m, int n, int k,
                           @Const FloatBuffer a, int lda, @Const FloatBuffer tau,
                           FloatBuffer c, int ldc );
public static native int LAPACKE_sormlq( int matrix_layout, @Cast("char") byte side, @Cast("char") byte trans,
                           int m, int n, int k,
                           @Const float[] a, int lda, @Const float[] tau,
                           float[] c, int ldc );
public static native int LAPACKE_dormlq( int matrix_layout, @Cast("char") byte side, @Cast("char") byte trans,
                           int m, int n, int k,
                           @Const DoublePointer a, int lda, @Const DoublePointer tau,
                           DoublePointer c, int ldc );
public static native int LAPACKE_dormlq( int matrix_layout, @Cast("char") byte side, @Cast("char") byte trans,
                           int m, int n, int k,
                           @Const DoubleBuffer a, int lda, @Const DoubleBuffer tau,
                           DoubleBuffer c, int ldc );
public static native int LAPACKE_dormlq( int matrix_layout, @Cast("char") byte side, @Cast("char") byte trans,
                           int m, int n, int k,
                           @Const double[] a, int lda, @Const double[] tau,
                           double[] c, int ldc );

public static native int LAPACKE_sormql( int matrix_layout, @Cast("char") byte side, @Cast("char") byte trans,
                           int m, int n, int k,
                           @Const FloatPointer a, int lda, @Const FloatPointer tau,
                           FloatPointer c, int ldc );
public static native int LAPACKE_sormql( int matrix_layout, @Cast("char") byte side, @Cast("char") byte trans,
                           int m, int n, int k,
                           @Const FloatBuffer a, int lda, @Const FloatBuffer tau,
                           FloatBuffer c, int ldc );
public static native int LAPACKE_sormql( int matrix_layout, @Cast("char") byte side, @Cast("char") byte trans,
                           int m, int n, int k,
                           @Const float[] a, int lda, @Const float[] tau,
                           float[] c, int ldc );
public static native int LAPACKE_dormql( int matrix_layout, @Cast("char") byte side, @Cast("char") byte trans,
                           int m, int n, int k,
                           @Const DoublePointer a, int lda, @Const DoublePointer tau,
                           DoublePointer c, int ldc );
public static native int LAPACKE_dormql( int matrix_layout, @Cast("char") byte side, @Cast("char") byte trans,
                           int m, int n, int k,
                           @Const DoubleBuffer a, int lda, @Const DoubleBuffer tau,
                           DoubleBuffer c, int ldc );
public static native int LAPACKE_dormql( int matrix_layout, @Cast("char") byte side, @Cast("char") byte trans,
                           int m, int n, int k,
                           @Const double[] a, int lda, @Const double[] tau,
                           double[] c, int ldc );

public static native int LAPACKE_sormqr( int matrix_layout, @Cast("char") byte side, @Cast("char") byte trans,
                           int m, int n, int k,
                           @Const FloatPointer a, int lda, @Const FloatPointer tau,
                           FloatPointer c, int ldc );
public static native int LAPACKE_sormqr( int matrix_layout, @Cast("char") byte side, @Cast("char") byte trans,
                           int m, int n, int k,
                           @Const FloatBuffer a, int lda, @Const FloatBuffer tau,
                           FloatBuffer c, int ldc );
public static native int LAPACKE_sormqr( int matrix_layout, @Cast("char") byte side, @Cast("char") byte trans,
                           int m, int n, int k,
                           @Const float[] a, int lda, @Const float[] tau,
                           float[] c, int ldc );
public static native int LAPACKE_dormqr( int matrix_layout, @Cast("char") byte side, @Cast("char") byte trans,
                           int m, int n, int k,
                           @Const DoublePointer a, int lda, @Const DoublePointer tau,
                           DoublePointer c, int ldc );
public static native int LAPACKE_dormqr( int matrix_layout, @Cast("char") byte side, @Cast("char") byte trans,
                           int m, int n, int k,
                           @Const DoubleBuffer a, int lda, @Const DoubleBuffer tau,
                           DoubleBuffer c, int ldc );
public static native int LAPACKE_dormqr( int matrix_layout, @Cast("char") byte side, @Cast("char") byte trans,
                           int m, int n, int k,
                           @Const double[] a, int lda, @Const double[] tau,
                           double[] c, int ldc );

public static native int LAPACKE_sormrq( int matrix_layout, @Cast("char") byte side, @Cast("char") byte trans,
                           int m, int n, int k,
                           @Const FloatPointer a, int lda, @Const FloatPointer tau,
                           FloatPointer c, int ldc );
public static native int LAPACKE_sormrq( int matrix_layout, @Cast("char") byte side, @Cast("char") byte trans,
                           int m, int n, int k,
                           @Const FloatBuffer a, int lda, @Const FloatBuffer tau,
                           FloatBuffer c, int ldc );
public static native int LAPACKE_sormrq( int matrix_layout, @Cast("char") byte side, @Cast("char") byte trans,
                           int m, int n, int k,
                           @Const float[] a, int lda, @Const float[] tau,
                           float[] c, int ldc );
public static native int LAPACKE_dormrq( int matrix_layout, @Cast("char") byte side, @Cast("char") byte trans,
                           int m, int n, int k,
                           @Const DoublePointer a, int lda, @Const DoublePointer tau,
                           DoublePointer c, int ldc );
public static native int LAPACKE_dormrq( int matrix_layout, @Cast("char") byte side, @Cast("char") byte trans,
                           int m, int n, int k,
                           @Const DoubleBuffer a, int lda, @Const DoubleBuffer tau,
                           DoubleBuffer c, int ldc );
public static native int LAPACKE_dormrq( int matrix_layout, @Cast("char") byte side, @Cast("char") byte trans,
                           int m, int n, int k,
                           @Const double[] a, int lda, @Const double[] tau,
                           double[] c, int ldc );

public static native int LAPACKE_sormrz( int matrix_layout, @Cast("char") byte side, @Cast("char") byte trans,
                           int m, int n, int k,
                           int l, @Const FloatPointer a, int lda,
                           @Const FloatPointer tau, FloatPointer c, int ldc );
public static native int LAPACKE_sormrz( int matrix_layout, @Cast("char") byte side, @Cast("char") byte trans,
                           int m, int n, int k,
                           int l, @Const FloatBuffer a, int lda,
                           @Const FloatBuffer tau, FloatBuffer c, int ldc );
public static native int LAPACKE_sormrz( int matrix_layout, @Cast("char") byte side, @Cast("char") byte trans,
                           int m, int n, int k,
                           int l, @Const float[] a, int lda,
                           @Const float[] tau, float[] c, int ldc );
public static native int LAPACKE_dormrz( int matrix_layout, @Cast("char") byte side, @Cast("char") byte trans,
                           int m, int n, int k,
                           int l, @Const DoublePointer a, int lda,
                           @Const DoublePointer tau, DoublePointer c, int ldc );
public static native int LAPACKE_dormrz( int matrix_layout, @Cast("char") byte side, @Cast("char") byte trans,
                           int m, int n, int k,
                           int l, @Const DoubleBuffer a, int lda,
                           @Const DoubleBuffer tau, DoubleBuffer c, int ldc );
public static native int LAPACKE_dormrz( int matrix_layout, @Cast("char") byte side, @Cast("char") byte trans,
                           int m, int n, int k,
                           int l, @Const double[] a, int lda,
                           @Const double[] tau, double[] c, int ldc );

public static native int LAPACKE_sormtr( int matrix_layout, @Cast("char") byte side, @Cast("char") byte uplo, @Cast("char") byte trans,
                           int m, int n, @Const FloatPointer a,
                           int lda, @Const FloatPointer tau, FloatPointer c,
                           int ldc );
public static native int LAPACKE_sormtr( int matrix_layout, @Cast("char") byte side, @Cast("char") byte uplo, @Cast("char") byte trans,
                           int m, int n, @Const FloatBuffer a,
                           int lda, @Const FloatBuffer tau, FloatBuffer c,
                           int ldc );
public static native int LAPACKE_sormtr( int matrix_layout, @Cast("char") byte side, @Cast("char") byte uplo, @Cast("char") byte trans,
                           int m, int n, @Const float[] a,
                           int lda, @Const float[] tau, float[] c,
                           int ldc );
public static native int LAPACKE_dormtr( int matrix_layout, @Cast("char") byte side, @Cast("char") byte uplo, @Cast("char") byte trans,
                           int m, int n, @Const DoublePointer a,
                           int lda, @Const DoublePointer tau, DoublePointer c,
                           int ldc );
public static native int LAPACKE_dormtr( int matrix_layout, @Cast("char") byte side, @Cast("char") byte uplo, @Cast("char") byte trans,
                           int m, int n, @Const DoubleBuffer a,
                           int lda, @Const DoubleBuffer tau, DoubleBuffer c,
                           int ldc );
public static native int LAPACKE_dormtr( int matrix_layout, @Cast("char") byte side, @Cast("char") byte uplo, @Cast("char") byte trans,
                           int m, int n, @Const double[] a,
                           int lda, @Const double[] tau, double[] c,
                           int ldc );

public static native int LAPACKE_spbcon( int matrix_layout, @Cast("char") byte uplo, int n,
                           int kd, @Const FloatPointer ab, int ldab,
                           float anorm, FloatPointer rcond );
public static native int LAPACKE_spbcon( int matrix_layout, @Cast("char") byte uplo, int n,
                           int kd, @Const FloatBuffer ab, int ldab,
                           float anorm, FloatBuffer rcond );
public static native int LAPACKE_spbcon( int matrix_layout, @Cast("char") byte uplo, int n,
                           int kd, @Const float[] ab, int ldab,
                           float anorm, float[] rcond );
public static native int LAPACKE_dpbcon( int matrix_layout, @Cast("char") byte uplo, int n,
                           int kd, @Const DoublePointer ab, int ldab,
                           double anorm, DoublePointer rcond );
public static native int LAPACKE_dpbcon( int matrix_layout, @Cast("char") byte uplo, int n,
                           int kd, @Const DoubleBuffer ab, int ldab,
                           double anorm, DoubleBuffer rcond );
public static native int LAPACKE_dpbcon( int matrix_layout, @Cast("char") byte uplo, int n,
                           int kd, @Const double[] ab, int ldab,
                           double anorm, double[] rcond );
public static native int LAPACKE_cpbcon( int matrix_layout, @Cast("char") byte uplo, int n,
                           int kd, @Cast("const lapack_complex_float*") FloatPointer ab,
                           int ldab, float anorm, FloatPointer rcond );
public static native int LAPACKE_cpbcon( int matrix_layout, @Cast("char") byte uplo, int n,
                           int kd, @Cast("const lapack_complex_float*") FloatBuffer ab,
                           int ldab, float anorm, FloatBuffer rcond );
public static native int LAPACKE_cpbcon( int matrix_layout, @Cast("char") byte uplo, int n,
                           int kd, @Cast("const lapack_complex_float*") float[] ab,
                           int ldab, float anorm, float[] rcond );
public static native int LAPACKE_zpbcon( int matrix_layout, @Cast("char") byte uplo, int n,
                           int kd, @Cast("const lapack_complex_double*") DoublePointer ab,
                           int ldab, double anorm, DoublePointer rcond );
public static native int LAPACKE_zpbcon( int matrix_layout, @Cast("char") byte uplo, int n,
                           int kd, @Cast("const lapack_complex_double*") DoubleBuffer ab,
                           int ldab, double anorm, DoubleBuffer rcond );
public static native int LAPACKE_zpbcon( int matrix_layout, @Cast("char") byte uplo, int n,
                           int kd, @Cast("const lapack_complex_double*") double[] ab,
                           int ldab, double anorm, double[] rcond );

public static native int LAPACKE_spbequ( int matrix_layout, @Cast("char") byte uplo, int n,
                           int kd, @Const FloatPointer ab, int ldab,
                           FloatPointer s, FloatPointer scond, FloatPointer amax );
public static native int LAPACKE_spbequ( int matrix_layout, @Cast("char") byte uplo, int n,
                           int kd, @Const FloatBuffer ab, int ldab,
                           FloatBuffer s, FloatBuffer scond, FloatBuffer amax );
public static native int LAPACKE_spbequ( int matrix_layout, @Cast("char") byte uplo, int n,
                           int kd, @Const float[] ab, int ldab,
                           float[] s, float[] scond, float[] amax );
public static native int LAPACKE_dpbequ( int matrix_layout, @Cast("char") byte uplo, int n,
                           int kd, @Const DoublePointer ab, int ldab,
                           DoublePointer s, DoublePointer scond, DoublePointer amax );
public static native int LAPACKE_dpbequ( int matrix_layout, @Cast("char") byte uplo, int n,
                           int kd, @Const DoubleBuffer ab, int ldab,
                           DoubleBuffer s, DoubleBuffer scond, DoubleBuffer amax );
public static native int LAPACKE_dpbequ( int matrix_layout, @Cast("char") byte uplo, int n,
                           int kd, @Const double[] ab, int ldab,
                           double[] s, double[] scond, double[] amax );
public static native int LAPACKE_cpbequ( int matrix_layout, @Cast("char") byte uplo, int n,
                           int kd, @Cast("const lapack_complex_float*") FloatPointer ab,
                           int ldab, FloatPointer s, FloatPointer scond,
                           FloatPointer amax );
public static native int LAPACKE_cpbequ( int matrix_layout, @Cast("char") byte uplo, int n,
                           int kd, @Cast("const lapack_complex_float*") FloatBuffer ab,
                           int ldab, FloatBuffer s, FloatBuffer scond,
                           FloatBuffer amax );
public static native int LAPACKE_cpbequ( int matrix_layout, @Cast("char") byte uplo, int n,
                           int kd, @Cast("const lapack_complex_float*") float[] ab,
                           int ldab, float[] s, float[] scond,
                           float[] amax );
public static native int LAPACKE_zpbequ( int matrix_layout, @Cast("char") byte uplo, int n,
                           int kd, @Cast("const lapack_complex_double*") DoublePointer ab,
                           int ldab, DoublePointer s, DoublePointer scond,
                           DoublePointer amax );
public static native int LAPACKE_zpbequ( int matrix_layout, @Cast("char") byte uplo, int n,
                           int kd, @Cast("const lapack_complex_double*") DoubleBuffer ab,
                           int ldab, DoubleBuffer s, DoubleBuffer scond,
                           DoubleBuffer amax );
public static native int LAPACKE_zpbequ( int matrix_layout, @Cast("char") byte uplo, int n,
                           int kd, @Cast("const lapack_complex_double*") double[] ab,
                           int ldab, double[] s, double[] scond,
                           double[] amax );

public static native int LAPACKE_spbrfs( int matrix_layout, @Cast("char") byte uplo, int n,
                           int kd, int nrhs, @Const FloatPointer ab,
                           int ldab, @Const FloatPointer afb, int ldafb,
                           @Const FloatPointer b, int ldb, FloatPointer x,
                           int ldx, FloatPointer ferr, FloatPointer berr );
public static native int LAPACKE_spbrfs( int matrix_layout, @Cast("char") byte uplo, int n,
                           int kd, int nrhs, @Const FloatBuffer ab,
                           int ldab, @Const FloatBuffer afb, int ldafb,
                           @Const FloatBuffer b, int ldb, FloatBuffer x,
                           int ldx, FloatBuffer ferr, FloatBuffer berr );
public static native int LAPACKE_spbrfs( int matrix_layout, @Cast("char") byte uplo, int n,
                           int kd, int nrhs, @Const float[] ab,
                           int ldab, @Const float[] afb, int ldafb,
                           @Const float[] b, int ldb, float[] x,
                           int ldx, float[] ferr, float[] berr );
public static native int LAPACKE_dpbrfs( int matrix_layout, @Cast("char") byte uplo, int n,
                           int kd, int nrhs, @Const DoublePointer ab,
                           int ldab, @Const DoublePointer afb, int ldafb,
                           @Const DoublePointer b, int ldb, DoublePointer x,
                           int ldx, DoublePointer ferr, DoublePointer berr );
public static native int LAPACKE_dpbrfs( int matrix_layout, @Cast("char") byte uplo, int n,
                           int kd, int nrhs, @Const DoubleBuffer ab,
                           int ldab, @Const DoubleBuffer afb, int ldafb,
                           @Const DoubleBuffer b, int ldb, DoubleBuffer x,
                           int ldx, DoubleBuffer ferr, DoubleBuffer berr );
public static native int LAPACKE_dpbrfs( int matrix_layout, @Cast("char") byte uplo, int n,
                           int kd, int nrhs, @Const double[] ab,
                           int ldab, @Const double[] afb, int ldafb,
                           @Const double[] b, int ldb, double[] x,
                           int ldx, double[] ferr, double[] berr );
public static native int LAPACKE_cpbrfs( int matrix_layout, @Cast("char") byte uplo, int n,
                           int kd, int nrhs,
                           @Cast("const lapack_complex_float*") FloatPointer ab, int ldab,
                           @Cast("const lapack_complex_float*") FloatPointer afb, int ldafb,
                           @Cast("const lapack_complex_float*") FloatPointer b, int ldb,
                           @Cast("lapack_complex_float*") FloatPointer x, int ldx, FloatPointer ferr,
                           FloatPointer berr );
public static native int LAPACKE_cpbrfs( int matrix_layout, @Cast("char") byte uplo, int n,
                           int kd, int nrhs,
                           @Cast("const lapack_complex_float*") FloatBuffer ab, int ldab,
                           @Cast("const lapack_complex_float*") FloatBuffer afb, int ldafb,
                           @Cast("const lapack_complex_float*") FloatBuffer b, int ldb,
                           @Cast("lapack_complex_float*") FloatBuffer x, int ldx, FloatBuffer ferr,
                           FloatBuffer berr );
public static native int LAPACKE_cpbrfs( int matrix_layout, @Cast("char") byte uplo, int n,
                           int kd, int nrhs,
                           @Cast("const lapack_complex_float*") float[] ab, int ldab,
                           @Cast("const lapack_complex_float*") float[] afb, int ldafb,
                           @Cast("const lapack_complex_float*") float[] b, int ldb,
                           @Cast("lapack_complex_float*") float[] x, int ldx, float[] ferr,
                           float[] berr );
public static native int LAPACKE_zpbrfs( int matrix_layout, @Cast("char") byte uplo, int n,
                           int kd, int nrhs,
                           @Cast("const lapack_complex_double*") DoublePointer ab, int ldab,
                           @Cast("const lapack_complex_double*") DoublePointer afb, int ldafb,
                           @Cast("const lapack_complex_double*") DoublePointer b, int ldb,
                           @Cast("lapack_complex_double*") DoublePointer x, int ldx,
                           DoublePointer ferr, DoublePointer berr );
public static native int LAPACKE_zpbrfs( int matrix_layout, @Cast("char") byte uplo, int n,
                           int kd, int nrhs,
                           @Cast("const lapack_complex_double*") DoubleBuffer ab, int ldab,
                           @Cast("const lapack_complex_double*") DoubleBuffer afb, int ldafb,
                           @Cast("const lapack_complex_double*") DoubleBuffer b, int ldb,
                           @Cast("lapack_complex_double*") DoubleBuffer x, int ldx,
                           DoubleBuffer ferr, DoubleBuffer berr );
public static native int LAPACKE_zpbrfs( int matrix_layout, @Cast("char") byte uplo, int n,
                           int kd, int nrhs,
                           @Cast("const lapack_complex_double*") double[] ab, int ldab,
                           @Cast("const lapack_complex_double*") double[] afb, int ldafb,
                           @Cast("const lapack_complex_double*") double[] b, int ldb,
                           @Cast("lapack_complex_double*") double[] x, int ldx,
                           double[] ferr, double[] berr );

public static native int LAPACKE_spbstf( int matrix_layout, @Cast("char") byte uplo, int n,
                           int kb, FloatPointer bb, int ldbb );
public static native int LAPACKE_spbstf( int matrix_layout, @Cast("char") byte uplo, int n,
                           int kb, FloatBuffer bb, int ldbb );
public static native int LAPACKE_spbstf( int matrix_layout, @Cast("char") byte uplo, int n,
                           int kb, float[] bb, int ldbb );
public static native int LAPACKE_dpbstf( int matrix_layout, @Cast("char") byte uplo, int n,
                           int kb, DoublePointer bb, int ldbb );
public static native int LAPACKE_dpbstf( int matrix_layout, @Cast("char") byte uplo, int n,
                           int kb, DoubleBuffer bb, int ldbb );
public static native int LAPACKE_dpbstf( int matrix_layout, @Cast("char") byte uplo, int n,
                           int kb, double[] bb, int ldbb );
public static native int LAPACKE_cpbstf( int matrix_layout, @Cast("char") byte uplo, int n,
                           int kb, @Cast("lapack_complex_float*") FloatPointer bb,
                           int ldbb );
public static native int LAPACKE_cpbstf( int matrix_layout, @Cast("char") byte uplo, int n,
                           int kb, @Cast("lapack_complex_float*") FloatBuffer bb,
                           int ldbb );
public static native int LAPACKE_cpbstf( int matrix_layout, @Cast("char") byte uplo, int n,
                           int kb, @Cast("lapack_complex_float*") float[] bb,
                           int ldbb );
public static native int LAPACKE_zpbstf( int matrix_layout, @Cast("char") byte uplo, int n,
                           int kb, @Cast("lapack_complex_double*") DoublePointer bb,
                           int ldbb );
public static native int LAPACKE_zpbstf( int matrix_layout, @Cast("char") byte uplo, int n,
                           int kb, @Cast("lapack_complex_double*") DoubleBuffer bb,
                           int ldbb );
public static native int LAPACKE_zpbstf( int matrix_layout, @Cast("char") byte uplo, int n,
                           int kb, @Cast("lapack_complex_double*") double[] bb,
                           int ldbb );

public static native int LAPACKE_spbsv( int matrix_layout, @Cast("char") byte uplo, int n,
                          int kd, int nrhs, FloatPointer ab,
                          int ldab, FloatPointer b, int ldb );
public static native int LAPACKE_spbsv( int matrix_layout, @Cast("char") byte uplo, int n,
                          int kd, int nrhs, FloatBuffer ab,
                          int ldab, FloatBuffer b, int ldb );
public static native int LAPACKE_spbsv( int matrix_layout, @Cast("char") byte uplo, int n,
                          int kd, int nrhs, float[] ab,
                          int ldab, float[] b, int ldb );
public static native int LAPACKE_dpbsv( int matrix_layout, @Cast("char") byte uplo, int n,
                          int kd, int nrhs, DoublePointer ab,
                          int ldab, DoublePointer b, int ldb );
public static native int LAPACKE_dpbsv( int matrix_layout, @Cast("char") byte uplo, int n,
                          int kd, int nrhs, DoubleBuffer ab,
                          int ldab, DoubleBuffer b, int ldb );
public static native int LAPACKE_dpbsv( int matrix_layout, @Cast("char") byte uplo, int n,
                          int kd, int nrhs, double[] ab,
                          int ldab, double[] b, int ldb );
public static native int LAPACKE_cpbsv( int matrix_layout, @Cast("char") byte uplo, int n,
                          int kd, int nrhs,
                          @Cast("lapack_complex_float*") FloatPointer ab, int ldab,
                          @Cast("lapack_complex_float*") FloatPointer b, int ldb );
public static native int LAPACKE_cpbsv( int matrix_layout, @Cast("char") byte uplo, int n,
                          int kd, int nrhs,
                          @Cast("lapack_complex_float*") FloatBuffer ab, int ldab,
                          @Cast("lapack_complex_float*") FloatBuffer b, int ldb );
public static native int LAPACKE_cpbsv( int matrix_layout, @Cast("char") byte uplo, int n,
                          int kd, int nrhs,
                          @Cast("lapack_complex_float*") float[] ab, int ldab,
                          @Cast("lapack_complex_float*") float[] b, int ldb );
public static native int LAPACKE_zpbsv( int matrix_layout, @Cast("char") byte uplo, int n,
                          int kd, int nrhs,
                          @Cast("lapack_complex_double*") DoublePointer ab, int ldab,
                          @Cast("lapack_complex_double*") DoublePointer b, int ldb );
public static native int LAPACKE_zpbsv( int matrix_layout, @Cast("char") byte uplo, int n,
                          int kd, int nrhs,
                          @Cast("lapack_complex_double*") DoubleBuffer ab, int ldab,
                          @Cast("lapack_complex_double*") DoubleBuffer b, int ldb );
public static native int LAPACKE_zpbsv( int matrix_layout, @Cast("char") byte uplo, int n,
                          int kd, int nrhs,
                          @Cast("lapack_complex_double*") double[] ab, int ldab,
                          @Cast("lapack_complex_double*") double[] b, int ldb );

public static native int LAPACKE_spbsvx( int matrix_layout, @Cast("char") byte fact, @Cast("char") byte uplo, int n,
                           int kd, int nrhs, FloatPointer ab,
                           int ldab, FloatPointer afb, int ldafb,
                           @Cast("char*") BytePointer equed, FloatPointer s, FloatPointer b, int ldb,
                           FloatPointer x, int ldx, FloatPointer rcond, FloatPointer ferr,
                           FloatPointer berr );
public static native int LAPACKE_spbsvx( int matrix_layout, @Cast("char") byte fact, @Cast("char") byte uplo, int n,
                           int kd, int nrhs, FloatBuffer ab,
                           int ldab, FloatBuffer afb, int ldafb,
                           @Cast("char*") ByteBuffer equed, FloatBuffer s, FloatBuffer b, int ldb,
                           FloatBuffer x, int ldx, FloatBuffer rcond, FloatBuffer ferr,
                           FloatBuffer berr );
public static native int LAPACKE_spbsvx( int matrix_layout, @Cast("char") byte fact, @Cast("char") byte uplo, int n,
                           int kd, int nrhs, float[] ab,
                           int ldab, float[] afb, int ldafb,
                           @Cast("char*") byte[] equed, float[] s, float[] b, int ldb,
                           float[] x, int ldx, float[] rcond, float[] ferr,
                           float[] berr );
public static native int LAPACKE_dpbsvx( int matrix_layout, @Cast("char") byte fact, @Cast("char") byte uplo, int n,
                           int kd, int nrhs, DoublePointer ab,
                           int ldab, DoublePointer afb, int ldafb,
                           @Cast("char*") BytePointer equed, DoublePointer s, DoublePointer b, int ldb,
                           DoublePointer x, int ldx, DoublePointer rcond,
                           DoublePointer ferr, DoublePointer berr );
public static native int LAPACKE_dpbsvx( int matrix_layout, @Cast("char") byte fact, @Cast("char") byte uplo, int n,
                           int kd, int nrhs, DoubleBuffer ab,
                           int ldab, DoubleBuffer afb, int ldafb,
                           @Cast("char*") ByteBuffer equed, DoubleBuffer s, DoubleBuffer b, int ldb,
                           DoubleBuffer x, int ldx, DoubleBuffer rcond,
                           DoubleBuffer ferr, DoubleBuffer berr );
public static native int LAPACKE_dpbsvx( int matrix_layout, @Cast("char") byte fact, @Cast("char") byte uplo, int n,
                           int kd, int nrhs, double[] ab,
                           int ldab, double[] afb, int ldafb,
                           @Cast("char*") byte[] equed, double[] s, double[] b, int ldb,
                           double[] x, int ldx, double[] rcond,
                           double[] ferr, double[] berr );
public static native int LAPACKE_cpbsvx( int matrix_layout, @Cast("char") byte fact, @Cast("char") byte uplo, int n,
                           int kd, int nrhs,
                           @Cast("lapack_complex_float*") FloatPointer ab, int ldab,
                           @Cast("lapack_complex_float*") FloatPointer afb, int ldafb,
                           @Cast("char*") BytePointer equed, FloatPointer s, @Cast("lapack_complex_float*") FloatPointer b,
                           int ldb, @Cast("lapack_complex_float*") FloatPointer x,
                           int ldx, FloatPointer rcond, FloatPointer ferr,
                           FloatPointer berr );
public static native int LAPACKE_cpbsvx( int matrix_layout, @Cast("char") byte fact, @Cast("char") byte uplo, int n,
                           int kd, int nrhs,
                           @Cast("lapack_complex_float*") FloatBuffer ab, int ldab,
                           @Cast("lapack_complex_float*") FloatBuffer afb, int ldafb,
                           @Cast("char*") ByteBuffer equed, FloatBuffer s, @Cast("lapack_complex_float*") FloatBuffer b,
                           int ldb, @Cast("lapack_complex_float*") FloatBuffer x,
                           int ldx, FloatBuffer rcond, FloatBuffer ferr,
                           FloatBuffer berr );
public static native int LAPACKE_cpbsvx( int matrix_layout, @Cast("char") byte fact, @Cast("char") byte uplo, int n,
                           int kd, int nrhs,
                           @Cast("lapack_complex_float*") float[] ab, int ldab,
                           @Cast("lapack_complex_float*") float[] afb, int ldafb,
                           @Cast("char*") byte[] equed, float[] s, @Cast("lapack_complex_float*") float[] b,
                           int ldb, @Cast("lapack_complex_float*") float[] x,
                           int ldx, float[] rcond, float[] ferr,
                           float[] berr );
public static native int LAPACKE_zpbsvx( int matrix_layout, @Cast("char") byte fact, @Cast("char") byte uplo, int n,
                           int kd, int nrhs,
                           @Cast("lapack_complex_double*") DoublePointer ab, int ldab,
                           @Cast("lapack_complex_double*") DoublePointer afb, int ldafb,
                           @Cast("char*") BytePointer equed, DoublePointer s, @Cast("lapack_complex_double*") DoublePointer b,
                           int ldb, @Cast("lapack_complex_double*") DoublePointer x,
                           int ldx, DoublePointer rcond, DoublePointer ferr,
                           DoublePointer berr );
public static native int LAPACKE_zpbsvx( int matrix_layout, @Cast("char") byte fact, @Cast("char") byte uplo, int n,
                           int kd, int nrhs,
                           @Cast("lapack_complex_double*") DoubleBuffer ab, int ldab,
                           @Cast("lapack_complex_double*") DoubleBuffer afb, int ldafb,
                           @Cast("char*") ByteBuffer equed, DoubleBuffer s, @Cast("lapack_complex_double*") DoubleBuffer b,
                           int ldb, @Cast("lapack_complex_double*") DoubleBuffer x,
                           int ldx, DoubleBuffer rcond, DoubleBuffer ferr,
                           DoubleBuffer berr );
public static native int LAPACKE_zpbsvx( int matrix_layout, @Cast("char") byte fact, @Cast("char") byte uplo, int n,
                           int kd, int nrhs,
                           @Cast("lapack_complex_double*") double[] ab, int ldab,
                           @Cast("lapack_complex_double*") double[] afb, int ldafb,
                           @Cast("char*") byte[] equed, double[] s, @Cast("lapack_complex_double*") double[] b,
                           int ldb, @Cast("lapack_complex_double*") double[] x,
                           int ldx, double[] rcond, double[] ferr,
                           double[] berr );

public static native int LAPACKE_spbtrf( int matrix_layout, @Cast("char") byte uplo, int n,
                           int kd, FloatPointer ab, int ldab );
public static native int LAPACKE_spbtrf( int matrix_layout, @Cast("char") byte uplo, int n,
                           int kd, FloatBuffer ab, int ldab );
public static native int LAPACKE_spbtrf( int matrix_layout, @Cast("char") byte uplo, int n,
                           int kd, float[] ab, int ldab );
public static native int LAPACKE_dpbtrf( int matrix_layout, @Cast("char") byte uplo, int n,
                           int kd, DoublePointer ab, int ldab );
public static native int LAPACKE_dpbtrf( int matrix_layout, @Cast("char") byte uplo, int n,
                           int kd, DoubleBuffer ab, int ldab );
public static native int LAPACKE_dpbtrf( int matrix_layout, @Cast("char") byte uplo, int n,
                           int kd, double[] ab, int ldab );
public static native int LAPACKE_cpbtrf( int matrix_layout, @Cast("char") byte uplo, int n,
                           int kd, @Cast("lapack_complex_float*") FloatPointer ab,
                           int ldab );
public static native int LAPACKE_cpbtrf( int matrix_layout, @Cast("char") byte uplo, int n,
                           int kd, @Cast("lapack_complex_float*") FloatBuffer ab,
                           int ldab );
public static native int LAPACKE_cpbtrf( int matrix_layout, @Cast("char") byte uplo, int n,
                           int kd, @Cast("lapack_complex_float*") float[] ab,
                           int ldab );
public static native int LAPACKE_zpbtrf( int matrix_layout, @Cast("char") byte uplo, int n,
                           int kd, @Cast("lapack_complex_double*") DoublePointer ab,
                           int ldab );
public static native int LAPACKE_zpbtrf( int matrix_layout, @Cast("char") byte uplo, int n,
                           int kd, @Cast("lapack_complex_double*") DoubleBuffer ab,
                           int ldab );
public static native int LAPACKE_zpbtrf( int matrix_layout, @Cast("char") byte uplo, int n,
                           int kd, @Cast("lapack_complex_double*") double[] ab,
                           int ldab );

public static native int LAPACKE_spbtrs( int matrix_layout, @Cast("char") byte uplo, int n,
                           int kd, int nrhs, @Const FloatPointer ab,
                           int ldab, FloatPointer b, int ldb );
public static native int LAPACKE_spbtrs( int matrix_layout, @Cast("char") byte uplo, int n,
                           int kd, int nrhs, @Const FloatBuffer ab,
                           int ldab, FloatBuffer b, int ldb );
public static native int LAPACKE_spbtrs( int matrix_layout, @Cast("char") byte uplo, int n,
                           int kd, int nrhs, @Const float[] ab,
                           int ldab, float[] b, int ldb );
public static native int LAPACKE_dpbtrs( int matrix_layout, @Cast("char") byte uplo, int n,
                           int kd, int nrhs, @Const DoublePointer ab,
                           int ldab, DoublePointer b, int ldb );
public static native int LAPACKE_dpbtrs( int matrix_layout, @Cast("char") byte uplo, int n,
                           int kd, int nrhs, @Const DoubleBuffer ab,
                           int ldab, DoubleBuffer b, int ldb );
public static native int LAPACKE_dpbtrs( int matrix_layout, @Cast("char") byte uplo, int n,
                           int kd, int nrhs, @Const double[] ab,
                           int ldab, double[] b, int ldb );
public static native int LAPACKE_cpbtrs( int matrix_layout, @Cast("char") byte uplo, int n,
                           int kd, int nrhs,
                           @Cast("const lapack_complex_float*") FloatPointer ab, int ldab,
                           @Cast("lapack_complex_float*") FloatPointer b, int ldb );
public static native int LAPACKE_cpbtrs( int matrix_layout, @Cast("char") byte uplo, int n,
                           int kd, int nrhs,
                           @Cast("const lapack_complex_float*") FloatBuffer ab, int ldab,
                           @Cast("lapack_complex_float*") FloatBuffer b, int ldb );
public static native int LAPACKE_cpbtrs( int matrix_layout, @Cast("char") byte uplo, int n,
                           int kd, int nrhs,
                           @Cast("const lapack_complex_float*") float[] ab, int ldab,
                           @Cast("lapack_complex_float*") float[] b, int ldb );
public static native int LAPACKE_zpbtrs( int matrix_layout, @Cast("char") byte uplo, int n,
                           int kd, int nrhs,
                           @Cast("const lapack_complex_double*") DoublePointer ab, int ldab,
                           @Cast("lapack_complex_double*") DoublePointer b, int ldb );
public static native int LAPACKE_zpbtrs( int matrix_layout, @Cast("char") byte uplo, int n,
                           int kd, int nrhs,
                           @Cast("const lapack_complex_double*") DoubleBuffer ab, int ldab,
                           @Cast("lapack_complex_double*") DoubleBuffer b, int ldb );
public static native int LAPACKE_zpbtrs( int matrix_layout, @Cast("char") byte uplo, int n,
                           int kd, int nrhs,
                           @Cast("const lapack_complex_double*") double[] ab, int ldab,
                           @Cast("lapack_complex_double*") double[] b, int ldb );

public static native int LAPACKE_spftrf( int matrix_layout, @Cast("char") byte transr, @Cast("char") byte uplo,
                           int n, FloatPointer a );
public static native int LAPACKE_spftrf( int matrix_layout, @Cast("char") byte transr, @Cast("char") byte uplo,
                           int n, FloatBuffer a );
public static native int LAPACKE_spftrf( int matrix_layout, @Cast("char") byte transr, @Cast("char") byte uplo,
                           int n, float[] a );
public static native int LAPACKE_dpftrf( int matrix_layout, @Cast("char") byte transr, @Cast("char") byte uplo,
                           int n, DoublePointer a );
public static native int LAPACKE_dpftrf( int matrix_layout, @Cast("char") byte transr, @Cast("char") byte uplo,
                           int n, DoubleBuffer a );
public static native int LAPACKE_dpftrf( int matrix_layout, @Cast("char") byte transr, @Cast("char") byte uplo,
                           int n, double[] a );
public static native int LAPACKE_cpftrf( int matrix_layout, @Cast("char") byte transr, @Cast("char") byte uplo,
                           int n, @Cast("lapack_complex_float*") FloatPointer a );
public static native int LAPACKE_cpftrf( int matrix_layout, @Cast("char") byte transr, @Cast("char") byte uplo,
                           int n, @Cast("lapack_complex_float*") FloatBuffer a );
public static native int LAPACKE_cpftrf( int matrix_layout, @Cast("char") byte transr, @Cast("char") byte uplo,
                           int n, @Cast("lapack_complex_float*") float[] a );
public static native int LAPACKE_zpftrf( int matrix_layout, @Cast("char") byte transr, @Cast("char") byte uplo,
                           int n, @Cast("lapack_complex_double*") DoublePointer a );
public static native int LAPACKE_zpftrf( int matrix_layout, @Cast("char") byte transr, @Cast("char") byte uplo,
                           int n, @Cast("lapack_complex_double*") DoubleBuffer a );
public static native int LAPACKE_zpftrf( int matrix_layout, @Cast("char") byte transr, @Cast("char") byte uplo,
                           int n, @Cast("lapack_complex_double*") double[] a );

public static native int LAPACKE_spftri( int matrix_layout, @Cast("char") byte transr, @Cast("char") byte uplo,
                           int n, FloatPointer a );
public static native int LAPACKE_spftri( int matrix_layout, @Cast("char") byte transr, @Cast("char") byte uplo,
                           int n, FloatBuffer a );
public static native int LAPACKE_spftri( int matrix_layout, @Cast("char") byte transr, @Cast("char") byte uplo,
                           int n, float[] a );
public static native int LAPACKE_dpftri( int matrix_layout, @Cast("char") byte transr, @Cast("char") byte uplo,
                           int n, DoublePointer a );
public static native int LAPACKE_dpftri( int matrix_layout, @Cast("char") byte transr, @Cast("char") byte uplo,
                           int n, DoubleBuffer a );
public static native int LAPACKE_dpftri( int matrix_layout, @Cast("char") byte transr, @Cast("char") byte uplo,
                           int n, double[] a );
public static native int LAPACKE_cpftri( int matrix_layout, @Cast("char") byte transr, @Cast("char") byte uplo,
                           int n, @Cast("lapack_complex_float*") FloatPointer a );
public static native int LAPACKE_cpftri( int matrix_layout, @Cast("char") byte transr, @Cast("char") byte uplo,
                           int n, @Cast("lapack_complex_float*") FloatBuffer a );
public static native int LAPACKE_cpftri( int matrix_layout, @Cast("char") byte transr, @Cast("char") byte uplo,
                           int n, @Cast("lapack_complex_float*") float[] a );
public static native int LAPACKE_zpftri( int matrix_layout, @Cast("char") byte transr, @Cast("char") byte uplo,
                           int n, @Cast("lapack_complex_double*") DoublePointer a );
public static native int LAPACKE_zpftri( int matrix_layout, @Cast("char") byte transr, @Cast("char") byte uplo,
                           int n, @Cast("lapack_complex_double*") DoubleBuffer a );
public static native int LAPACKE_zpftri( int matrix_layout, @Cast("char") byte transr, @Cast("char") byte uplo,
                           int n, @Cast("lapack_complex_double*") double[] a );

public static native int LAPACKE_spftrs( int matrix_layout, @Cast("char") byte transr, @Cast("char") byte uplo,
                           int n, int nrhs, @Const FloatPointer a,
                           FloatPointer b, int ldb );
public static native int LAPACKE_spftrs( int matrix_layout, @Cast("char") byte transr, @Cast("char") byte uplo,
                           int n, int nrhs, @Const FloatBuffer a,
                           FloatBuffer b, int ldb );
public static native int LAPACKE_spftrs( int matrix_layout, @Cast("char") byte transr, @Cast("char") byte uplo,
                           int n, int nrhs, @Const float[] a,
                           float[] b, int ldb );
public static native int LAPACKE_dpftrs( int matrix_layout, @Cast("char") byte transr, @Cast("char") byte uplo,
                           int n, int nrhs, @Const DoublePointer a,
                           DoublePointer b, int ldb );
public static native int LAPACKE_dpftrs( int matrix_layout, @Cast("char") byte transr, @Cast("char") byte uplo,
                           int n, int nrhs, @Const DoubleBuffer a,
                           DoubleBuffer b, int ldb );
public static native int LAPACKE_dpftrs( int matrix_layout, @Cast("char") byte transr, @Cast("char") byte uplo,
                           int n, int nrhs, @Const double[] a,
                           double[] b, int ldb );
public static native int LAPACKE_cpftrs( int matrix_layout, @Cast("char") byte transr, @Cast("char") byte uplo,
                           int n, int nrhs,
                           @Cast("const lapack_complex_float*") FloatPointer a,
                           @Cast("lapack_complex_float*") FloatPointer b, int ldb );
public static native int LAPACKE_cpftrs( int matrix_layout, @Cast("char") byte transr, @Cast("char") byte uplo,
                           int n, int nrhs,
                           @Cast("const lapack_complex_float*") FloatBuffer a,
                           @Cast("lapack_complex_float*") FloatBuffer b, int ldb );
public static native int LAPACKE_cpftrs( int matrix_layout, @Cast("char") byte transr, @Cast("char") byte uplo,
                           int n, int nrhs,
                           @Cast("const lapack_complex_float*") float[] a,
                           @Cast("lapack_complex_float*") float[] b, int ldb );
public static native int LAPACKE_zpftrs( int matrix_layout, @Cast("char") byte transr, @Cast("char") byte uplo,
                           int n, int nrhs,
                           @Cast("const lapack_complex_double*") DoublePointer a,
                           @Cast("lapack_complex_double*") DoublePointer b, int ldb );
public static native int LAPACKE_zpftrs( int matrix_layout, @Cast("char") byte transr, @Cast("char") byte uplo,
                           int n, int nrhs,
                           @Cast("const lapack_complex_double*") DoubleBuffer a,
                           @Cast("lapack_complex_double*") DoubleBuffer b, int ldb );
public static native int LAPACKE_zpftrs( int matrix_layout, @Cast("char") byte transr, @Cast("char") byte uplo,
                           int n, int nrhs,
                           @Cast("const lapack_complex_double*") double[] a,
                           @Cast("lapack_complex_double*") double[] b, int ldb );

public static native int LAPACKE_spocon( int matrix_layout, @Cast("char") byte uplo, int n,
                           @Const FloatPointer a, int lda, float anorm,
                           FloatPointer rcond );
public static native int LAPACKE_spocon( int matrix_layout, @Cast("char") byte uplo, int n,
                           @Const FloatBuffer a, int lda, float anorm,
                           FloatBuffer rcond );
public static native int LAPACKE_spocon( int matrix_layout, @Cast("char") byte uplo, int n,
                           @Const float[] a, int lda, float anorm,
                           float[] rcond );
public static native int LAPACKE_dpocon( int matrix_layout, @Cast("char") byte uplo, int n,
                           @Const DoublePointer a, int lda, double anorm,
                           DoublePointer rcond );
public static native int LAPACKE_dpocon( int matrix_layout, @Cast("char") byte uplo, int n,
                           @Const DoubleBuffer a, int lda, double anorm,
                           DoubleBuffer rcond );
public static native int LAPACKE_dpocon( int matrix_layout, @Cast("char") byte uplo, int n,
                           @Const double[] a, int lda, double anorm,
                           double[] rcond );
public static native int LAPACKE_cpocon( int matrix_layout, @Cast("char") byte uplo, int n,
                           @Cast("const lapack_complex_float*") FloatPointer a, int lda,
                           float anorm, FloatPointer rcond );
public static native int LAPACKE_cpocon( int matrix_layout, @Cast("char") byte uplo, int n,
                           @Cast("const lapack_complex_float*") FloatBuffer a, int lda,
                           float anorm, FloatBuffer rcond );
public static native int LAPACKE_cpocon( int matrix_layout, @Cast("char") byte uplo, int n,
                           @Cast("const lapack_complex_float*") float[] a, int lda,
                           float anorm, float[] rcond );
public static native int LAPACKE_zpocon( int matrix_layout, @Cast("char") byte uplo, int n,
                           @Cast("const lapack_complex_double*") DoublePointer a, int lda,
                           double anorm, DoublePointer rcond );
public static native int LAPACKE_zpocon( int matrix_layout, @Cast("char") byte uplo, int n,
                           @Cast("const lapack_complex_double*") DoubleBuffer a, int lda,
                           double anorm, DoubleBuffer rcond );
public static native int LAPACKE_zpocon( int matrix_layout, @Cast("char") byte uplo, int n,
                           @Cast("const lapack_complex_double*") double[] a, int lda,
                           double anorm, double[] rcond );

public static native int LAPACKE_spoequ( int matrix_layout, int n, @Const FloatPointer a,
                           int lda, FloatPointer s, FloatPointer scond,
                           FloatPointer amax );
public static native int LAPACKE_spoequ( int matrix_layout, int n, @Const FloatBuffer a,
                           int lda, FloatBuffer s, FloatBuffer scond,
                           FloatBuffer amax );
public static native int LAPACKE_spoequ( int matrix_layout, int n, @Const float[] a,
                           int lda, float[] s, float[] scond,
                           float[] amax );
public static native int LAPACKE_dpoequ( int matrix_layout, int n, @Const DoublePointer a,
                           int lda, DoublePointer s, DoublePointer scond,
                           DoublePointer amax );
public static native int LAPACKE_dpoequ( int matrix_layout, int n, @Const DoubleBuffer a,
                           int lda, DoubleBuffer s, DoubleBuffer scond,
                           DoubleBuffer amax );
public static native int LAPACKE_dpoequ( int matrix_layout, int n, @Const double[] a,
                           int lda, double[] s, double[] scond,
                           double[] amax );
public static native int LAPACKE_cpoequ( int matrix_layout, int n,
                           @Cast("const lapack_complex_float*") FloatPointer a, int lda,
                           FloatPointer s, FloatPointer scond, FloatPointer amax );
public static native int LAPACKE_cpoequ( int matrix_layout, int n,
                           @Cast("const lapack_complex_float*") FloatBuffer a, int lda,
                           FloatBuffer s, FloatBuffer scond, FloatBuffer amax );
public static native int LAPACKE_cpoequ( int matrix_layout, int n,
                           @Cast("const lapack_complex_float*") float[] a, int lda,
                           float[] s, float[] scond, float[] amax );
public static native int LAPACKE_zpoequ( int matrix_layout, int n,
                           @Cast("const lapack_complex_double*") DoublePointer a, int lda,
                           DoublePointer s, DoublePointer scond, DoublePointer amax );
public static native int LAPACKE_zpoequ( int matrix_layout, int n,
                           @Cast("const lapack_complex_double*") DoubleBuffer a, int lda,
                           DoubleBuffer s, DoubleBuffer scond, DoubleBuffer amax );
public static native int LAPACKE_zpoequ( int matrix_layout, int n,
                           @Cast("const lapack_complex_double*") double[] a, int lda,
                           double[] s, double[] scond, double[] amax );

public static native int LAPACKE_spoequb( int matrix_layout, int n, @Const FloatPointer a,
                            int lda, FloatPointer s, FloatPointer scond,
                            FloatPointer amax );
public static native int LAPACKE_spoequb( int matrix_layout, int n, @Const FloatBuffer a,
                            int lda, FloatBuffer s, FloatBuffer scond,
                            FloatBuffer amax );
public static native int LAPACKE_spoequb( int matrix_layout, int n, @Const float[] a,
                            int lda, float[] s, float[] scond,
                            float[] amax );
public static native int LAPACKE_dpoequb( int matrix_layout, int n, @Const DoublePointer a,
                            int lda, DoublePointer s, DoublePointer scond,
                            DoublePointer amax );
public static native int LAPACKE_dpoequb( int matrix_layout, int n, @Const DoubleBuffer a,
                            int lda, DoubleBuffer s, DoubleBuffer scond,
                            DoubleBuffer amax );
public static native int LAPACKE_dpoequb( int matrix_layout, int n, @Const double[] a,
                            int lda, double[] s, double[] scond,
                            double[] amax );
public static native int LAPACKE_cpoequb( int matrix_layout, int n,
                            @Cast("const lapack_complex_float*") FloatPointer a, int lda,
                            FloatPointer s, FloatPointer scond, FloatPointer amax );
public static native int LAPACKE_cpoequb( int matrix_layout, int n,
                            @Cast("const lapack_complex_float*") FloatBuffer a, int lda,
                            FloatBuffer s, FloatBuffer scond, FloatBuffer amax );
public static native int LAPACKE_cpoequb( int matrix_layout, int n,
                            @Cast("const lapack_complex_float*") float[] a, int lda,
                            float[] s, float[] scond, float[] amax );
public static native int LAPACKE_zpoequb( int matrix_layout, int n,
                            @Cast("const lapack_complex_double*") DoublePointer a, int lda,
                            DoublePointer s, DoublePointer scond, DoublePointer amax );
public static native int LAPACKE_zpoequb( int matrix_layout, int n,
                            @Cast("const lapack_complex_double*") DoubleBuffer a, int lda,
                            DoubleBuffer s, DoubleBuffer scond, DoubleBuffer amax );
public static native int LAPACKE_zpoequb( int matrix_layout, int n,
                            @Cast("const lapack_complex_double*") double[] a, int lda,
                            double[] s, double[] scond, double[] amax );

public static native int LAPACKE_sporfs( int matrix_layout, @Cast("char") byte uplo, int n,
                           int nrhs, @Const FloatPointer a, int lda,
                           @Const FloatPointer af, int ldaf, @Const FloatPointer b,
                           int ldb, FloatPointer x, int ldx,
                           FloatPointer ferr, FloatPointer berr );
public static native int LAPACKE_sporfs( int matrix_layout, @Cast("char") byte uplo, int n,
                           int nrhs, @Const FloatBuffer a, int lda,
                           @Const FloatBuffer af, int ldaf, @Const FloatBuffer b,
                           int ldb, FloatBuffer x, int ldx,
                           FloatBuffer ferr, FloatBuffer berr );
public static native int LAPACKE_sporfs( int matrix_layout, @Cast("char") byte uplo, int n,
                           int nrhs, @Const float[] a, int lda,
                           @Const float[] af, int ldaf, @Const float[] b,
                           int ldb, float[] x, int ldx,
                           float[] ferr, float[] berr );
public static native int LAPACKE_dporfs( int matrix_layout, @Cast("char") byte uplo, int n,
                           int nrhs, @Const DoublePointer a, int lda,
                           @Const DoublePointer af, int ldaf, @Const DoublePointer b,
                           int ldb, DoublePointer x, int ldx,
                           DoublePointer ferr, DoublePointer berr );
public static native int LAPACKE_dporfs( int matrix_layout, @Cast("char") byte uplo, int n,
                           int nrhs, @Const DoubleBuffer a, int lda,
                           @Const DoubleBuffer af, int ldaf, @Const DoubleBuffer b,
                           int ldb, DoubleBuffer x, int ldx,
                           DoubleBuffer ferr, DoubleBuffer berr );
public static native int LAPACKE_dporfs( int matrix_layout, @Cast("char") byte uplo, int n,
                           int nrhs, @Const double[] a, int lda,
                           @Const double[] af, int ldaf, @Const double[] b,
                           int ldb, double[] x, int ldx,
                           double[] ferr, double[] berr );
public static native int LAPACKE_cporfs( int matrix_layout, @Cast("char") byte uplo, int n,
                           int nrhs, @Cast("const lapack_complex_float*") FloatPointer a,
                           int lda, @Cast("const lapack_complex_float*") FloatPointer af,
                           int ldaf, @Cast("const lapack_complex_float*") FloatPointer b,
                           int ldb, @Cast("lapack_complex_float*") FloatPointer x,
                           int ldx, FloatPointer ferr, FloatPointer berr );
public static native int LAPACKE_cporfs( int matrix_layout, @Cast("char") byte uplo, int n,
                           int nrhs, @Cast("const lapack_complex_float*") FloatBuffer a,
                           int lda, @Cast("const lapack_complex_float*") FloatBuffer af,
                           int ldaf, @Cast("const lapack_complex_float*") FloatBuffer b,
                           int ldb, @Cast("lapack_complex_float*") FloatBuffer x,
                           int ldx, FloatBuffer ferr, FloatBuffer berr );
public static native int LAPACKE_cporfs( int matrix_layout, @Cast("char") byte uplo, int n,
                           int nrhs, @Cast("const lapack_complex_float*") float[] a,
                           int lda, @Cast("const lapack_complex_float*") float[] af,
                           int ldaf, @Cast("const lapack_complex_float*") float[] b,
                           int ldb, @Cast("lapack_complex_float*") float[] x,
                           int ldx, float[] ferr, float[] berr );
public static native int LAPACKE_zporfs( int matrix_layout, @Cast("char") byte uplo, int n,
                           int nrhs, @Cast("const lapack_complex_double*") DoublePointer a,
                           int lda, @Cast("const lapack_complex_double*") DoublePointer af,
                           int ldaf, @Cast("const lapack_complex_double*") DoublePointer b,
                           int ldb, @Cast("lapack_complex_double*") DoublePointer x,
                           int ldx, DoublePointer ferr, DoublePointer berr );
public static native int LAPACKE_zporfs( int matrix_layout, @Cast("char") byte uplo, int n,
                           int nrhs, @Cast("const lapack_complex_double*") DoubleBuffer a,
                           int lda, @Cast("const lapack_complex_double*") DoubleBuffer af,
                           int ldaf, @Cast("const lapack_complex_double*") DoubleBuffer b,
                           int ldb, @Cast("lapack_complex_double*") DoubleBuffer x,
                           int ldx, DoubleBuffer ferr, DoubleBuffer berr );
public static native int LAPACKE_zporfs( int matrix_layout, @Cast("char") byte uplo, int n,
                           int nrhs, @Cast("const lapack_complex_double*") double[] a,
                           int lda, @Cast("const lapack_complex_double*") double[] af,
                           int ldaf, @Cast("const lapack_complex_double*") double[] b,
                           int ldb, @Cast("lapack_complex_double*") double[] x,
                           int ldx, double[] ferr, double[] berr );






public static native int LAPACKE_sposv( int matrix_layout, @Cast("char") byte uplo, int n,
                          int nrhs, FloatPointer a, int lda, FloatPointer b,
                          int ldb );
public static native int LAPACKE_sposv( int matrix_layout, @Cast("char") byte uplo, int n,
                          int nrhs, FloatBuffer a, int lda, FloatBuffer b,
                          int ldb );
public static native int LAPACKE_sposv( int matrix_layout, @Cast("char") byte uplo, int n,
                          int nrhs, float[] a, int lda, float[] b,
                          int ldb );
public static native int LAPACKE_dposv( int matrix_layout, @Cast("char") byte uplo, int n,
                          int nrhs, DoublePointer a, int lda, DoublePointer b,
                          int ldb );
public static native int LAPACKE_dposv( int matrix_layout, @Cast("char") byte uplo, int n,
                          int nrhs, DoubleBuffer a, int lda, DoubleBuffer b,
                          int ldb );
public static native int LAPACKE_dposv( int matrix_layout, @Cast("char") byte uplo, int n,
                          int nrhs, double[] a, int lda, double[] b,
                          int ldb );
public static native int LAPACKE_cposv( int matrix_layout, @Cast("char") byte uplo, int n,
                          int nrhs, @Cast("lapack_complex_float*") FloatPointer a,
                          int lda, @Cast("lapack_complex_float*") FloatPointer b,
                          int ldb );
public static native int LAPACKE_cposv( int matrix_layout, @Cast("char") byte uplo, int n,
                          int nrhs, @Cast("lapack_complex_float*") FloatBuffer a,
                          int lda, @Cast("lapack_complex_float*") FloatBuffer b,
                          int ldb );
public static native int LAPACKE_cposv( int matrix_layout, @Cast("char") byte uplo, int n,
                          int nrhs, @Cast("lapack_complex_float*") float[] a,
                          int lda, @Cast("lapack_complex_float*") float[] b,
                          int ldb );
public static native int LAPACKE_zposv( int matrix_layout, @Cast("char") byte uplo, int n,
                          int nrhs, @Cast("lapack_complex_double*") DoublePointer a,
                          int lda, @Cast("lapack_complex_double*") DoublePointer b,
                          int ldb );
public static native int LAPACKE_zposv( int matrix_layout, @Cast("char") byte uplo, int n,
                          int nrhs, @Cast("lapack_complex_double*") DoubleBuffer a,
                          int lda, @Cast("lapack_complex_double*") DoubleBuffer b,
                          int ldb );
public static native int LAPACKE_zposv( int matrix_layout, @Cast("char") byte uplo, int n,
                          int nrhs, @Cast("lapack_complex_double*") double[] a,
                          int lda, @Cast("lapack_complex_double*") double[] b,
                          int ldb );
public static native int LAPACKE_dsposv( int matrix_layout, @Cast("char") byte uplo, int n,
                           int nrhs, DoublePointer a, int lda,
                           DoublePointer b, int ldb, DoublePointer x, int ldx,
                           IntPointer iter );
public static native int LAPACKE_dsposv( int matrix_layout, @Cast("char") byte uplo, int n,
                           int nrhs, DoubleBuffer a, int lda,
                           DoubleBuffer b, int ldb, DoubleBuffer x, int ldx,
                           IntBuffer iter );
public static native int LAPACKE_dsposv( int matrix_layout, @Cast("char") byte uplo, int n,
                           int nrhs, double[] a, int lda,
                           double[] b, int ldb, double[] x, int ldx,
                           int[] iter );
public static native int LAPACKE_zcposv( int matrix_layout, @Cast("char") byte uplo, int n,
                           int nrhs, @Cast("lapack_complex_double*") DoublePointer a,
                           int lda, @Cast("lapack_complex_double*") DoublePointer b,
                           int ldb, @Cast("lapack_complex_double*") DoublePointer x,
                           int ldx, IntPointer iter );
public static native int LAPACKE_zcposv( int matrix_layout, @Cast("char") byte uplo, int n,
                           int nrhs, @Cast("lapack_complex_double*") DoubleBuffer a,
                           int lda, @Cast("lapack_complex_double*") DoubleBuffer b,
                           int ldb, @Cast("lapack_complex_double*") DoubleBuffer x,
                           int ldx, IntBuffer iter );
public static native int LAPACKE_zcposv( int matrix_layout, @Cast("char") byte uplo, int n,
                           int nrhs, @Cast("lapack_complex_double*") double[] a,
                           int lda, @Cast("lapack_complex_double*") double[] b,
                           int ldb, @Cast("lapack_complex_double*") double[] x,
                           int ldx, int[] iter );

public static native int LAPACKE_sposvx( int matrix_layout, @Cast("char") byte fact, @Cast("char") byte uplo, int n,
                           int nrhs, FloatPointer a, int lda, FloatPointer af,
                           int ldaf, @Cast("char*") BytePointer equed, FloatPointer s, FloatPointer b,
                           int ldb, FloatPointer x, int ldx,
                           FloatPointer rcond, FloatPointer ferr, FloatPointer berr );
public static native int LAPACKE_sposvx( int matrix_layout, @Cast("char") byte fact, @Cast("char") byte uplo, int n,
                           int nrhs, FloatBuffer a, int lda, FloatBuffer af,
                           int ldaf, @Cast("char*") ByteBuffer equed, FloatBuffer s, FloatBuffer b,
                           int ldb, FloatBuffer x, int ldx,
                           FloatBuffer rcond, FloatBuffer ferr, FloatBuffer berr );
public static native int LAPACKE_sposvx( int matrix_layout, @Cast("char") byte fact, @Cast("char") byte uplo, int n,
                           int nrhs, float[] a, int lda, float[] af,
                           int ldaf, @Cast("char*") byte[] equed, float[] s, float[] b,
                           int ldb, float[] x, int ldx,
                           float[] rcond, float[] ferr, float[] berr );
public static native int LAPACKE_dposvx( int matrix_layout, @Cast("char") byte fact, @Cast("char") byte uplo, int n,
                           int nrhs, DoublePointer a, int lda,
                           DoublePointer af, int ldaf, @Cast("char*") BytePointer equed, DoublePointer s,
                           DoublePointer b, int ldb, DoublePointer x, int ldx,
                           DoublePointer rcond, DoublePointer ferr, DoublePointer berr );
public static native int LAPACKE_dposvx( int matrix_layout, @Cast("char") byte fact, @Cast("char") byte uplo, int n,
                           int nrhs, DoubleBuffer a, int lda,
                           DoubleBuffer af, int ldaf, @Cast("char*") ByteBuffer equed, DoubleBuffer s,
                           DoubleBuffer b, int ldb, DoubleBuffer x, int ldx,
                           DoubleBuffer rcond, DoubleBuffer ferr, DoubleBuffer berr );
public static native int LAPACKE_dposvx( int matrix_layout, @Cast("char") byte fact, @Cast("char") byte uplo, int n,
                           int nrhs, double[] a, int lda,
                           double[] af, int ldaf, @Cast("char*") byte[] equed, double[] s,
                           double[] b, int ldb, double[] x, int ldx,
                           double[] rcond, double[] ferr, double[] berr );
public static native int LAPACKE_cposvx( int matrix_layout, @Cast("char") byte fact, @Cast("char") byte uplo, int n,
                           int nrhs, @Cast("lapack_complex_float*") FloatPointer a,
                           int lda, @Cast("lapack_complex_float*") FloatPointer af,
                           int ldaf, @Cast("char*") BytePointer equed, FloatPointer s,
                           @Cast("lapack_complex_float*") FloatPointer b, int ldb,
                           @Cast("lapack_complex_float*") FloatPointer x, int ldx,
                           FloatPointer rcond, FloatPointer ferr, FloatPointer berr );
public static native int LAPACKE_cposvx( int matrix_layout, @Cast("char") byte fact, @Cast("char") byte uplo, int n,
                           int nrhs, @Cast("lapack_complex_float*") FloatBuffer a,
                           int lda, @Cast("lapack_complex_float*") FloatBuffer af,
                           int ldaf, @Cast("char*") ByteBuffer equed, FloatBuffer s,
                           @Cast("lapack_complex_float*") FloatBuffer b, int ldb,
                           @Cast("lapack_complex_float*") FloatBuffer x, int ldx,
                           FloatBuffer rcond, FloatBuffer ferr, FloatBuffer berr );
public static native int LAPACKE_cposvx( int matrix_layout, @Cast("char") byte fact, @Cast("char") byte uplo, int n,
                           int nrhs, @Cast("lapack_complex_float*") float[] a,
                           int lda, @Cast("lapack_complex_float*") float[] af,
                           int ldaf, @Cast("char*") byte[] equed, float[] s,
                           @Cast("lapack_complex_float*") float[] b, int ldb,
                           @Cast("lapack_complex_float*") float[] x, int ldx,
                           float[] rcond, float[] ferr, float[] berr );
public static native int LAPACKE_zposvx( int matrix_layout, @Cast("char") byte fact, @Cast("char") byte uplo, int n,
                           int nrhs, @Cast("lapack_complex_double*") DoublePointer a,
                           int lda, @Cast("lapack_complex_double*") DoublePointer af,
                           int ldaf, @Cast("char*") BytePointer equed, DoublePointer s,
                           @Cast("lapack_complex_double*") DoublePointer b, int ldb,
                           @Cast("lapack_complex_double*") DoublePointer x, int ldx,
                           DoublePointer rcond, DoublePointer ferr, DoublePointer berr );
public static native int LAPACKE_zposvx( int matrix_layout, @Cast("char") byte fact, @Cast("char") byte uplo, int n,
                           int nrhs, @Cast("lapack_complex_double*") DoubleBuffer a,
                           int lda, @Cast("lapack_complex_double*") DoubleBuffer af,
                           int ldaf, @Cast("char*") ByteBuffer equed, DoubleBuffer s,
                           @Cast("lapack_complex_double*") DoubleBuffer b, int ldb,
                           @Cast("lapack_complex_double*") DoubleBuffer x, int ldx,
                           DoubleBuffer rcond, DoubleBuffer ferr, DoubleBuffer berr );
public static native int LAPACKE_zposvx( int matrix_layout, @Cast("char") byte fact, @Cast("char") byte uplo, int n,
                           int nrhs, @Cast("lapack_complex_double*") double[] a,
                           int lda, @Cast("lapack_complex_double*") double[] af,
                           int ldaf, @Cast("char*") byte[] equed, double[] s,
                           @Cast("lapack_complex_double*") double[] b, int ldb,
                           @Cast("lapack_complex_double*") double[] x, int ldx,
                           double[] rcond, double[] ferr, double[] berr );






public static native int LAPACKE_spotrf2( int matrix_layout, @Cast("char") byte uplo, int n, FloatPointer a,
                           int lda );
public static native int LAPACKE_spotrf2( int matrix_layout, @Cast("char") byte uplo, int n, FloatBuffer a,
                           int lda );
public static native int LAPACKE_spotrf2( int matrix_layout, @Cast("char") byte uplo, int n, float[] a,
                           int lda );
public static native int LAPACKE_dpotrf2( int matrix_layout, @Cast("char") byte uplo, int n, DoublePointer a,
                           int lda );
public static native int LAPACKE_dpotrf2( int matrix_layout, @Cast("char") byte uplo, int n, DoubleBuffer a,
                           int lda );
public static native int LAPACKE_dpotrf2( int matrix_layout, @Cast("char") byte uplo, int n, double[] a,
                           int lda );
public static native int LAPACKE_cpotrf2( int matrix_layout, @Cast("char") byte uplo, int n,
                           @Cast("lapack_complex_float*") FloatPointer a, int lda );
public static native int LAPACKE_cpotrf2( int matrix_layout, @Cast("char") byte uplo, int n,
                           @Cast("lapack_complex_float*") FloatBuffer a, int lda );
public static native int LAPACKE_cpotrf2( int matrix_layout, @Cast("char") byte uplo, int n,
                           @Cast("lapack_complex_float*") float[] a, int lda );
public static native int LAPACKE_zpotrf2( int matrix_layout, @Cast("char") byte uplo, int n,
                           @Cast("lapack_complex_double*") DoublePointer a, int lda );
public static native int LAPACKE_zpotrf2( int matrix_layout, @Cast("char") byte uplo, int n,
                           @Cast("lapack_complex_double*") DoubleBuffer a, int lda );
public static native int LAPACKE_zpotrf2( int matrix_layout, @Cast("char") byte uplo, int n,
                           @Cast("lapack_complex_double*") double[] a, int lda );

public static native int LAPACKE_spotrf( int matrix_layout, @Cast("char") byte uplo, int n, FloatPointer a,
                           int lda );
public static native int LAPACKE_spotrf( int matrix_layout, @Cast("char") byte uplo, int n, FloatBuffer a,
                           int lda );
public static native int LAPACKE_spotrf( int matrix_layout, @Cast("char") byte uplo, int n, float[] a,
                           int lda );
public static native int LAPACKE_dpotrf( int matrix_layout, @Cast("char") byte uplo, int n, DoublePointer a,
                           int lda );
public static native int LAPACKE_dpotrf( int matrix_layout, @Cast("char") byte uplo, int n, DoubleBuffer a,
                           int lda );
public static native int LAPACKE_dpotrf( int matrix_layout, @Cast("char") byte uplo, int n, double[] a,
                           int lda );
public static native int LAPACKE_cpotrf( int matrix_layout, @Cast("char") byte uplo, int n,
                           @Cast("lapack_complex_float*") FloatPointer a, int lda );
public static native int LAPACKE_cpotrf( int matrix_layout, @Cast("char") byte uplo, int n,
                           @Cast("lapack_complex_float*") FloatBuffer a, int lda );
public static native int LAPACKE_cpotrf( int matrix_layout, @Cast("char") byte uplo, int n,
                           @Cast("lapack_complex_float*") float[] a, int lda );
public static native int LAPACKE_zpotrf( int matrix_layout, @Cast("char") byte uplo, int n,
                           @Cast("lapack_complex_double*") DoublePointer a, int lda );
public static native int LAPACKE_zpotrf( int matrix_layout, @Cast("char") byte uplo, int n,
                           @Cast("lapack_complex_double*") DoubleBuffer a, int lda );
public static native int LAPACKE_zpotrf( int matrix_layout, @Cast("char") byte uplo, int n,
                           @Cast("lapack_complex_double*") double[] a, int lda );

public static native int LAPACKE_spotri( int matrix_layout, @Cast("char") byte uplo, int n, FloatPointer a,
                           int lda );
public static native int LAPACKE_spotri( int matrix_layout, @Cast("char") byte uplo, int n, FloatBuffer a,
                           int lda );
public static native int LAPACKE_spotri( int matrix_layout, @Cast("char") byte uplo, int n, float[] a,
                           int lda );
public static native int LAPACKE_dpotri( int matrix_layout, @Cast("char") byte uplo, int n, DoublePointer a,
                           int lda );
public static native int LAPACKE_dpotri( int matrix_layout, @Cast("char") byte uplo, int n, DoubleBuffer a,
                           int lda );
public static native int LAPACKE_dpotri( int matrix_layout, @Cast("char") byte uplo, int n, double[] a,
                           int lda );
public static native int LAPACKE_cpotri( int matrix_layout, @Cast("char") byte uplo, int n,
                           @Cast("lapack_complex_float*") FloatPointer a, int lda );
public static native int LAPACKE_cpotri( int matrix_layout, @Cast("char") byte uplo, int n,
                           @Cast("lapack_complex_float*") FloatBuffer a, int lda );
public static native int LAPACKE_cpotri( int matrix_layout, @Cast("char") byte uplo, int n,
                           @Cast("lapack_complex_float*") float[] a, int lda );
public static native int LAPACKE_zpotri( int matrix_layout, @Cast("char") byte uplo, int n,
                           @Cast("lapack_complex_double*") DoublePointer a, int lda );
public static native int LAPACKE_zpotri( int matrix_layout, @Cast("char") byte uplo, int n,
                           @Cast("lapack_complex_double*") DoubleBuffer a, int lda );
public static native int LAPACKE_zpotri( int matrix_layout, @Cast("char") byte uplo, int n,
                           @Cast("lapack_complex_double*") double[] a, int lda );

public static native int LAPACKE_spotrs( int matrix_layout, @Cast("char") byte uplo, int n,
                           int nrhs, @Const FloatPointer a, int lda,
                           FloatPointer b, int ldb );
public static native int LAPACKE_spotrs( int matrix_layout, @Cast("char") byte uplo, int n,
                           int nrhs, @Const FloatBuffer a, int lda,
                           FloatBuffer b, int ldb );
public static native int LAPACKE_spotrs( int matrix_layout, @Cast("char") byte uplo, int n,
                           int nrhs, @Const float[] a, int lda,
                           float[] b, int ldb );
public static native int LAPACKE_dpotrs( int matrix_layout, @Cast("char") byte uplo, int n,
                           int nrhs, @Const DoublePointer a, int lda,
                           DoublePointer b, int ldb );
public static native int LAPACKE_dpotrs( int matrix_layout, @Cast("char") byte uplo, int n,
                           int nrhs, @Const DoubleBuffer a, int lda,
                           DoubleBuffer b, int ldb );
public static native int LAPACKE_dpotrs( int matrix_layout, @Cast("char") byte uplo, int n,
                           int nrhs, @Const double[] a, int lda,
                           double[] b, int ldb );
public static native int LAPACKE_cpotrs( int matrix_layout, @Cast("char") byte uplo, int n,
                           int nrhs, @Cast("const lapack_complex_float*") FloatPointer a,
                           int lda, @Cast("lapack_complex_float*") FloatPointer b,
                           int ldb );
public static native int LAPACKE_cpotrs( int matrix_layout, @Cast("char") byte uplo, int n,
                           int nrhs, @Cast("const lapack_complex_float*") FloatBuffer a,
                           int lda, @Cast("lapack_complex_float*") FloatBuffer b,
                           int ldb );
public static native int LAPACKE_cpotrs( int matrix_layout, @Cast("char") byte uplo, int n,
                           int nrhs, @Cast("const lapack_complex_float*") float[] a,
                           int lda, @Cast("lapack_complex_float*") float[] b,
                           int ldb );
public static native int LAPACKE_zpotrs( int matrix_layout, @Cast("char") byte uplo, int n,
                           int nrhs, @Cast("const lapack_complex_double*") DoublePointer a,
                           int lda, @Cast("lapack_complex_double*") DoublePointer b,
                           int ldb );
public static native int LAPACKE_zpotrs( int matrix_layout, @Cast("char") byte uplo, int n,
                           int nrhs, @Cast("const lapack_complex_double*") DoubleBuffer a,
                           int lda, @Cast("lapack_complex_double*") DoubleBuffer b,
                           int ldb );
public static native int LAPACKE_zpotrs( int matrix_layout, @Cast("char") byte uplo, int n,
                           int nrhs, @Cast("const lapack_complex_double*") double[] a,
                           int lda, @Cast("lapack_complex_double*") double[] b,
                           int ldb );

public static native int LAPACKE_sppcon( int matrix_layout, @Cast("char") byte uplo, int n,
                           @Const FloatPointer ap, float anorm, FloatPointer rcond );
public static native int LAPACKE_sppcon( int matrix_layout, @Cast("char") byte uplo, int n,
                           @Const FloatBuffer ap, float anorm, FloatBuffer rcond );
public static native int LAPACKE_sppcon( int matrix_layout, @Cast("char") byte uplo, int n,
                           @Const float[] ap, float anorm, float[] rcond );
public static native int LAPACKE_dppcon( int matrix_layout, @Cast("char") byte uplo, int n,
                           @Const DoublePointer ap, double anorm, DoublePointer rcond );
public static native int LAPACKE_dppcon( int matrix_layout, @Cast("char") byte uplo, int n,
                           @Const DoubleBuffer ap, double anorm, DoubleBuffer rcond );
public static native int LAPACKE_dppcon( int matrix_layout, @Cast("char") byte uplo, int n,
                           @Const double[] ap, double anorm, double[] rcond );
public static native int LAPACKE_cppcon( int matrix_layout, @Cast("char") byte uplo, int n,
                           @Cast("const lapack_complex_float*") FloatPointer ap, float anorm,
                           FloatPointer rcond );
public static native int LAPACKE_cppcon( int matrix_layout, @Cast("char") byte uplo, int n,
                           @Cast("const lapack_complex_float*") FloatBuffer ap, float anorm,
                           FloatBuffer rcond );
public static native int LAPACKE_cppcon( int matrix_layout, @Cast("char") byte uplo, int n,
                           @Cast("const lapack_complex_float*") float[] ap, float anorm,
                           float[] rcond );
public static native int LAPACKE_zppcon( int matrix_layout, @Cast("char") byte uplo, int n,
                           @Cast("const lapack_complex_double*") DoublePointer ap, double anorm,
                           DoublePointer rcond );
public static native int LAPACKE_zppcon( int matrix_layout, @Cast("char") byte uplo, int n,
                           @Cast("const lapack_complex_double*") DoubleBuffer ap, double anorm,
                           DoubleBuffer rcond );
public static native int LAPACKE_zppcon( int matrix_layout, @Cast("char") byte uplo, int n,
                           @Cast("const lapack_complex_double*") double[] ap, double anorm,
                           double[] rcond );

public static native int LAPACKE_sppequ( int matrix_layout, @Cast("char") byte uplo, int n,
                           @Const FloatPointer ap, FloatPointer s, FloatPointer scond,
                           FloatPointer amax );
public static native int LAPACKE_sppequ( int matrix_layout, @Cast("char") byte uplo, int n,
                           @Const FloatBuffer ap, FloatBuffer s, FloatBuffer scond,
                           FloatBuffer amax );
public static native int LAPACKE_sppequ( int matrix_layout, @Cast("char") byte uplo, int n,
                           @Const float[] ap, float[] s, float[] scond,
                           float[] amax );
public static native int LAPACKE_dppequ( int matrix_layout, @Cast("char") byte uplo, int n,
                           @Const DoublePointer ap, DoublePointer s, DoublePointer scond,
                           DoublePointer amax );
public static native int LAPACKE_dppequ( int matrix_layout, @Cast("char") byte uplo, int n,
                           @Const DoubleBuffer ap, DoubleBuffer s, DoubleBuffer scond,
                           DoubleBuffer amax );
public static native int LAPACKE_dppequ( int matrix_layout, @Cast("char") byte uplo, int n,
                           @Const double[] ap, double[] s, double[] scond,
                           double[] amax );
public static native int LAPACKE_cppequ( int matrix_layout, @Cast("char") byte uplo, int n,
                           @Cast("const lapack_complex_float*") FloatPointer ap, FloatPointer s,
                           FloatPointer scond, FloatPointer amax );
public static native int LAPACKE_cppequ( int matrix_layout, @Cast("char") byte uplo, int n,
                           @Cast("const lapack_complex_float*") FloatBuffer ap, FloatBuffer s,
                           FloatBuffer scond, FloatBuffer amax );
public static native int LAPACKE_cppequ( int matrix_layout, @Cast("char") byte uplo, int n,
                           @Cast("const lapack_complex_float*") float[] ap, float[] s,
                           float[] scond, float[] amax );
public static native int LAPACKE_zppequ( int matrix_layout, @Cast("char") byte uplo, int n,
                           @Cast("const lapack_complex_double*") DoublePointer ap, DoublePointer s,
                           DoublePointer scond, DoublePointer amax );
public static native int LAPACKE_zppequ( int matrix_layout, @Cast("char") byte uplo, int n,
                           @Cast("const lapack_complex_double*") DoubleBuffer ap, DoubleBuffer s,
                           DoubleBuffer scond, DoubleBuffer amax );
public static native int LAPACKE_zppequ( int matrix_layout, @Cast("char") byte uplo, int n,
                           @Cast("const lapack_complex_double*") double[] ap, double[] s,
                           double[] scond, double[] amax );

public static native int LAPACKE_spprfs( int matrix_layout, @Cast("char") byte uplo, int n,
                           int nrhs, @Const FloatPointer ap, @Const FloatPointer afp,
                           @Const FloatPointer b, int ldb, FloatPointer x,
                           int ldx, FloatPointer ferr, FloatPointer berr );
public static native int LAPACKE_spprfs( int matrix_layout, @Cast("char") byte uplo, int n,
                           int nrhs, @Const FloatBuffer ap, @Const FloatBuffer afp,
                           @Const FloatBuffer b, int ldb, FloatBuffer x,
                           int ldx, FloatBuffer ferr, FloatBuffer berr );
public static native int LAPACKE_spprfs( int matrix_layout, @Cast("char") byte uplo, int n,
                           int nrhs, @Const float[] ap, @Const float[] afp,
                           @Const float[] b, int ldb, float[] x,
                           int ldx, float[] ferr, float[] berr );
public static native int LAPACKE_dpprfs( int matrix_layout, @Cast("char") byte uplo, int n,
                           int nrhs, @Const DoublePointer ap, @Const DoublePointer afp,
                           @Const DoublePointer b, int ldb, DoublePointer x,
                           int ldx, DoublePointer ferr, DoublePointer berr );
public static native int LAPACKE_dpprfs( int matrix_layout, @Cast("char") byte uplo, int n,
                           int nrhs, @Const DoubleBuffer ap, @Const DoubleBuffer afp,
                           @Const DoubleBuffer b, int ldb, DoubleBuffer x,
                           int ldx, DoubleBuffer ferr, DoubleBuffer berr );
public static native int LAPACKE_dpprfs( int matrix_layout, @Cast("char") byte uplo, int n,
                           int nrhs, @Const double[] ap, @Const double[] afp,
                           @Const double[] b, int ldb, double[] x,
                           int ldx, double[] ferr, double[] berr );
public static native int LAPACKE_cpprfs( int matrix_layout, @Cast("char") byte uplo, int n,
                           int nrhs, @Cast("const lapack_complex_float*") FloatPointer ap,
                           @Cast("const lapack_complex_float*") FloatPointer afp,
                           @Cast("const lapack_complex_float*") FloatPointer b, int ldb,
                           @Cast("lapack_complex_float*") FloatPointer x, int ldx, FloatPointer ferr,
                           FloatPointer berr );
public static native int LAPACKE_cpprfs( int matrix_layout, @Cast("char") byte uplo, int n,
                           int nrhs, @Cast("const lapack_complex_float*") FloatBuffer ap,
                           @Cast("const lapack_complex_float*") FloatBuffer afp,
                           @Cast("const lapack_complex_float*") FloatBuffer b, int ldb,
                           @Cast("lapack_complex_float*") FloatBuffer x, int ldx, FloatBuffer ferr,
                           FloatBuffer berr );
public static native int LAPACKE_cpprfs( int matrix_layout, @Cast("char") byte uplo, int n,
                           int nrhs, @Cast("const lapack_complex_float*") float[] ap,
                           @Cast("const lapack_complex_float*") float[] afp,
                           @Cast("const lapack_complex_float*") float[] b, int ldb,
                           @Cast("lapack_complex_float*") float[] x, int ldx, float[] ferr,
                           float[] berr );
public static native int LAPACKE_zpprfs( int matrix_layout, @Cast("char") byte uplo, int n,
                           int nrhs, @Cast("const lapack_complex_double*") DoublePointer ap,
                           @Cast("const lapack_complex_double*") DoublePointer afp,
                           @Cast("const lapack_complex_double*") DoublePointer b, int ldb,
                           @Cast("lapack_complex_double*") DoublePointer x, int ldx,
                           DoublePointer ferr, DoublePointer berr );
public static native int LAPACKE_zpprfs( int matrix_layout, @Cast("char") byte uplo, int n,
                           int nrhs, @Cast("const lapack_complex_double*") DoubleBuffer ap,
                           @Cast("const lapack_complex_double*") DoubleBuffer afp,
                           @Cast("const lapack_complex_double*") DoubleBuffer b, int ldb,
                           @Cast("lapack_complex_double*") DoubleBuffer x, int ldx,
                           DoubleBuffer ferr, DoubleBuffer berr );
public static native int LAPACKE_zpprfs( int matrix_layout, @Cast("char") byte uplo, int n,
                           int nrhs, @Cast("const lapack_complex_double*") double[] ap,
                           @Cast("const lapack_complex_double*") double[] afp,
                           @Cast("const lapack_complex_double*") double[] b, int ldb,
                           @Cast("lapack_complex_double*") double[] x, int ldx,
                           double[] ferr, double[] berr );

public static native int LAPACKE_sppsv( int matrix_layout, @Cast("char") byte uplo, int n,
                          int nrhs, FloatPointer ap, FloatPointer b,
                          int ldb );
public static native int LAPACKE_sppsv( int matrix_layout, @Cast("char") byte uplo, int n,
                          int nrhs, FloatBuffer ap, FloatBuffer b,
                          int ldb );
public static native int LAPACKE_sppsv( int matrix_layout, @Cast("char") byte uplo, int n,
                          int nrhs, float[] ap, float[] b,
                          int ldb );
public static native int LAPACKE_dppsv( int matrix_layout, @Cast("char") byte uplo, int n,
                          int nrhs, DoublePointer ap, DoublePointer b,
                          int ldb );
public static native int LAPACKE_dppsv( int matrix_layout, @Cast("char") byte uplo, int n,
                          int nrhs, DoubleBuffer ap, DoubleBuffer b,
                          int ldb );
public static native int LAPACKE_dppsv( int matrix_layout, @Cast("char") byte uplo, int n,
                          int nrhs, double[] ap, double[] b,
                          int ldb );
public static native int LAPACKE_cppsv( int matrix_layout, @Cast("char") byte uplo, int n,
                          int nrhs, @Cast("lapack_complex_float*") FloatPointer ap,
                          @Cast("lapack_complex_float*") FloatPointer b, int ldb );
public static native int LAPACKE_cppsv( int matrix_layout, @Cast("char") byte uplo, int n,
                          int nrhs, @Cast("lapack_complex_float*") FloatBuffer ap,
                          @Cast("lapack_complex_float*") FloatBuffer b, int ldb );
public static native int LAPACKE_cppsv( int matrix_layout, @Cast("char") byte uplo, int n,
                          int nrhs, @Cast("lapack_complex_float*") float[] ap,
                          @Cast("lapack_complex_float*") float[] b, int ldb );
public static native int LAPACKE_zppsv( int matrix_layout, @Cast("char") byte uplo, int n,
                          int nrhs, @Cast("lapack_complex_double*") DoublePointer ap,
                          @Cast("lapack_complex_double*") DoublePointer b, int ldb );
public static native int LAPACKE_zppsv( int matrix_layout, @Cast("char") byte uplo, int n,
                          int nrhs, @Cast("lapack_complex_double*") DoubleBuffer ap,
                          @Cast("lapack_complex_double*") DoubleBuffer b, int ldb );
public static native int LAPACKE_zppsv( int matrix_layout, @Cast("char") byte uplo, int n,
                          int nrhs, @Cast("lapack_complex_double*") double[] ap,
                          @Cast("lapack_complex_double*") double[] b, int ldb );

public static native int LAPACKE_sppsvx( int matrix_layout, @Cast("char") byte fact, @Cast("char") byte uplo, int n,
                           int nrhs, FloatPointer ap, FloatPointer afp, @Cast("char*") BytePointer equed,
                           FloatPointer s, FloatPointer b, int ldb, FloatPointer x,
                           int ldx, FloatPointer rcond, FloatPointer ferr,
                           FloatPointer berr );
public static native int LAPACKE_sppsvx( int matrix_layout, @Cast("char") byte fact, @Cast("char") byte uplo, int n,
                           int nrhs, FloatBuffer ap, FloatBuffer afp, @Cast("char*") ByteBuffer equed,
                           FloatBuffer s, FloatBuffer b, int ldb, FloatBuffer x,
                           int ldx, FloatBuffer rcond, FloatBuffer ferr,
                           FloatBuffer berr );
public static native int LAPACKE_sppsvx( int matrix_layout, @Cast("char") byte fact, @Cast("char") byte uplo, int n,
                           int nrhs, float[] ap, float[] afp, @Cast("char*") byte[] equed,
                           float[] s, float[] b, int ldb, float[] x,
                           int ldx, float[] rcond, float[] ferr,
                           float[] berr );
public static native int LAPACKE_dppsvx( int matrix_layout, @Cast("char") byte fact, @Cast("char") byte uplo, int n,
                           int nrhs, DoublePointer ap, DoublePointer afp,
                           @Cast("char*") BytePointer equed, DoublePointer s, DoublePointer b, int ldb,
                           DoublePointer x, int ldx, DoublePointer rcond,
                           DoublePointer ferr, DoublePointer berr );
public static native int LAPACKE_dppsvx( int matrix_layout, @Cast("char") byte fact, @Cast("char") byte uplo, int n,
                           int nrhs, DoubleBuffer ap, DoubleBuffer afp,
                           @Cast("char*") ByteBuffer equed, DoubleBuffer s, DoubleBuffer b, int ldb,
                           DoubleBuffer x, int ldx, DoubleBuffer rcond,
                           DoubleBuffer ferr, DoubleBuffer berr );
public static native int LAPACKE_dppsvx( int matrix_layout, @Cast("char") byte fact, @Cast("char") byte uplo, int n,
                           int nrhs, double[] ap, double[] afp,
                           @Cast("char*") byte[] equed, double[] s, double[] b, int ldb,
                           double[] x, int ldx, double[] rcond,
                           double[] ferr, double[] berr );
public static native int LAPACKE_cppsvx( int matrix_layout, @Cast("char") byte fact, @Cast("char") byte uplo, int n,
                           int nrhs, @Cast("lapack_complex_float*") FloatPointer ap,
                           @Cast("lapack_complex_float*") FloatPointer afp, @Cast("char*") BytePointer equed, FloatPointer s,
                           @Cast("lapack_complex_float*") FloatPointer b, int ldb,
                           @Cast("lapack_complex_float*") FloatPointer x, int ldx,
                           FloatPointer rcond, FloatPointer ferr, FloatPointer berr );
public static native int LAPACKE_cppsvx( int matrix_layout, @Cast("char") byte fact, @Cast("char") byte uplo, int n,
                           int nrhs, @Cast("lapack_complex_float*") FloatBuffer ap,
                           @Cast("lapack_complex_float*") FloatBuffer afp, @Cast("char*") ByteBuffer equed, FloatBuffer s,
                           @Cast("lapack_complex_float*") FloatBuffer b, int ldb,
                           @Cast("lapack_complex_float*") FloatBuffer x, int ldx,
                           FloatBuffer rcond, FloatBuffer ferr, FloatBuffer berr );
public static native int LAPACKE_cppsvx( int matrix_layout, @Cast("char") byte fact, @Cast("char") byte uplo, int n,
                           int nrhs, @Cast("lapack_complex_float*") float[] ap,
                           @Cast("lapack_complex_float*") float[] afp, @Cast("char*") byte[] equed, float[] s,
                           @Cast("lapack_complex_float*") float[] b, int ldb,
                           @Cast("lapack_complex_float*") float[] x, int ldx,
                           float[] rcond, float[] ferr, float[] berr );
public static native int LAPACKE_zppsvx( int matrix_layout, @Cast("char") byte fact, @Cast("char") byte uplo, int n,
                           int nrhs, @Cast("lapack_complex_double*") DoublePointer ap,
                           @Cast("lapack_complex_double*") DoublePointer afp, @Cast("char*") BytePointer equed, DoublePointer s,
                           @Cast("lapack_complex_double*") DoublePointer b, int ldb,
                           @Cast("lapack_complex_double*") DoublePointer x, int ldx,
                           DoublePointer rcond, DoublePointer ferr, DoublePointer berr );
public static native int LAPACKE_zppsvx( int matrix_layout, @Cast("char") byte fact, @Cast("char") byte uplo, int n,
                           int nrhs, @Cast("lapack_complex_double*") DoubleBuffer ap,
                           @Cast("lapack_complex_double*") DoubleBuffer afp, @Cast("char*") ByteBuffer equed, DoubleBuffer s,
                           @Cast("lapack_complex_double*") DoubleBuffer b, int ldb,
                           @Cast("lapack_complex_double*") DoubleBuffer x, int ldx,
                           DoubleBuffer rcond, DoubleBuffer ferr, DoubleBuffer berr );
public static native int LAPACKE_zppsvx( int matrix_layout, @Cast("char") byte fact, @Cast("char") byte uplo, int n,
                           int nrhs, @Cast("lapack_complex_double*") double[] ap,
                           @Cast("lapack_complex_double*") double[] afp, @Cast("char*") byte[] equed, double[] s,
                           @Cast("lapack_complex_double*") double[] b, int ldb,
                           @Cast("lapack_complex_double*") double[] x, int ldx,
                           double[] rcond, double[] ferr, double[] berr );

public static native int LAPACKE_spptrf( int matrix_layout, @Cast("char") byte uplo, int n,
                           FloatPointer ap );
public static native int LAPACKE_spptrf( int matrix_layout, @Cast("char") byte uplo, int n,
                           FloatBuffer ap );
public static native int LAPACKE_spptrf( int matrix_layout, @Cast("char") byte uplo, int n,
                           float[] ap );
public static native int LAPACKE_dpptrf( int matrix_layout, @Cast("char") byte uplo, int n,
                           DoublePointer ap );
public static native int LAPACKE_dpptrf( int matrix_layout, @Cast("char") byte uplo, int n,
                           DoubleBuffer ap );
public static native int LAPACKE_dpptrf( int matrix_layout, @Cast("char") byte uplo, int n,
                           double[] ap );
public static native int LAPACKE_cpptrf( int matrix_layout, @Cast("char") byte uplo, int n,
                           @Cast("lapack_complex_float*") FloatPointer ap );
public static native int LAPACKE_cpptrf( int matrix_layout, @Cast("char") byte uplo, int n,
                           @Cast("lapack_complex_float*") FloatBuffer ap );
public static native int LAPACKE_cpptrf( int matrix_layout, @Cast("char") byte uplo, int n,
                           @Cast("lapack_complex_float*") float[] ap );
public static native int LAPACKE_zpptrf( int matrix_layout, @Cast("char") byte uplo, int n,
                           @Cast("lapack_complex_double*") DoublePointer ap );
public static native int LAPACKE_zpptrf( int matrix_layout, @Cast("char") byte uplo, int n,
                           @Cast("lapack_complex_double*") DoubleBuffer ap );
public static native int LAPACKE_zpptrf( int matrix_layout, @Cast("char") byte uplo, int n,
                           @Cast("lapack_complex_double*") double[] ap );

public static native int LAPACKE_spptri( int matrix_layout, @Cast("char") byte uplo, int n,
                           FloatPointer ap );
public static native int LAPACKE_spptri( int matrix_layout, @Cast("char") byte uplo, int n,
                           FloatBuffer ap );
public static native int LAPACKE_spptri( int matrix_layout, @Cast("char") byte uplo, int n,
                           float[] ap );
public static native int LAPACKE_dpptri( int matrix_layout, @Cast("char") byte uplo, int n,
                           DoublePointer ap );
public static native int LAPACKE_dpptri( int matrix_layout, @Cast("char") byte uplo, int n,
                           DoubleBuffer ap );
public static native int LAPACKE_dpptri( int matrix_layout, @Cast("char") byte uplo, int n,
                           double[] ap );
public static native int LAPACKE_cpptri( int matrix_layout, @Cast("char") byte uplo, int n,
                           @Cast("lapack_complex_float*") FloatPointer ap );
public static native int LAPACKE_cpptri( int matrix_layout, @Cast("char") byte uplo, int n,
                           @Cast("lapack_complex_float*") FloatBuffer ap );
public static native int LAPACKE_cpptri( int matrix_layout, @Cast("char") byte uplo, int n,
                           @Cast("lapack_complex_float*") float[] ap );
public static native int LAPACKE_zpptri( int matrix_layout, @Cast("char") byte uplo, int n,
                           @Cast("lapack_complex_double*") DoublePointer ap );
public static native int LAPACKE_zpptri( int matrix_layout, @Cast("char") byte uplo, int n,
                           @Cast("lapack_complex_double*") DoubleBuffer ap );
public static native int LAPACKE_zpptri( int matrix_layout, @Cast("char") byte uplo, int n,
                           @Cast("lapack_complex_double*") double[] ap );

public static native int LAPACKE_spptrs( int matrix_layout, @Cast("char") byte uplo, int n,
                           int nrhs, @Const FloatPointer ap, FloatPointer b,
                           int ldb );
public static native int LAPACKE_spptrs( int matrix_layout, @Cast("char") byte uplo, int n,
                           int nrhs, @Const FloatBuffer ap, FloatBuffer b,
                           int ldb );
public static native int LAPACKE_spptrs( int matrix_layout, @Cast("char") byte uplo, int n,
                           int nrhs, @Const float[] ap, float[] b,
                           int ldb );
public static native int LAPACKE_dpptrs( int matrix_layout, @Cast("char") byte uplo, int n,
                           int nrhs, @Const DoublePointer ap, DoublePointer b,
                           int ldb );
public static native int LAPACKE_dpptrs( int matrix_layout, @Cast("char") byte uplo, int n,
                           int nrhs, @Const DoubleBuffer ap, DoubleBuffer b,
                           int ldb );
public static native int LAPACKE_dpptrs( int matrix_layout, @Cast("char") byte uplo, int n,
                           int nrhs, @Const double[] ap, double[] b,
                           int ldb );
public static native int LAPACKE_cpptrs( int matrix_layout, @Cast("char") byte uplo, int n,
                           int nrhs, @Cast("const lapack_complex_float*") FloatPointer ap,
                           @Cast("lapack_complex_float*") FloatPointer b, int ldb );
public static native int LAPACKE_cpptrs( int matrix_layout, @Cast("char") byte uplo, int n,
                           int nrhs, @Cast("const lapack_complex_float*") FloatBuffer ap,
                           @Cast("lapack_complex_float*") FloatBuffer b, int ldb );
public static native int LAPACKE_cpptrs( int matrix_layout, @Cast("char") byte uplo, int n,
                           int nrhs, @Cast("const lapack_complex_float*") float[] ap,
                           @Cast("lapack_complex_float*") float[] b, int ldb );
public static native int LAPACKE_zpptrs( int matrix_layout, @Cast("char") byte uplo, int n,
                           int nrhs, @Cast("const lapack_complex_double*") DoublePointer ap,
                           @Cast("lapack_complex_double*") DoublePointer b, int ldb );
public static native int LAPACKE_zpptrs( int matrix_layout, @Cast("char") byte uplo, int n,
                           int nrhs, @Cast("const lapack_complex_double*") DoubleBuffer ap,
                           @Cast("lapack_complex_double*") DoubleBuffer b, int ldb );
public static native int LAPACKE_zpptrs( int matrix_layout, @Cast("char") byte uplo, int n,
                           int nrhs, @Cast("const lapack_complex_double*") double[] ap,
                           @Cast("lapack_complex_double*") double[] b, int ldb );

public static native int LAPACKE_spstrf( int matrix_layout, @Cast("char") byte uplo, int n, FloatPointer a,
                           int lda, IntPointer piv, IntPointer rank,
                           float tol );
public static native int LAPACKE_spstrf( int matrix_layout, @Cast("char") byte uplo, int n, FloatBuffer a,
                           int lda, IntBuffer piv, IntBuffer rank,
                           float tol );
public static native int LAPACKE_spstrf( int matrix_layout, @Cast("char") byte uplo, int n, float[] a,
                           int lda, int[] piv, int[] rank,
                           float tol );
public static native int LAPACKE_dpstrf( int matrix_layout, @Cast("char") byte uplo, int n, DoublePointer a,
                           int lda, IntPointer piv, IntPointer rank,
                           double tol );
public static native int LAPACKE_dpstrf( int matrix_layout, @Cast("char") byte uplo, int n, DoubleBuffer a,
                           int lda, IntBuffer piv, IntBuffer rank,
                           double tol );
public static native int LAPACKE_dpstrf( int matrix_layout, @Cast("char") byte uplo, int n, double[] a,
                           int lda, int[] piv, int[] rank,
                           double tol );
public static native int LAPACKE_cpstrf( int matrix_layout, @Cast("char") byte uplo, int n,
                           @Cast("lapack_complex_float*") FloatPointer a, int lda,
                           IntPointer piv, IntPointer rank, float tol );
public static native int LAPACKE_cpstrf( int matrix_layout, @Cast("char") byte uplo, int n,
                           @Cast("lapack_complex_float*") FloatBuffer a, int lda,
                           IntBuffer piv, IntBuffer rank, float tol );
public static native int LAPACKE_cpstrf( int matrix_layout, @Cast("char") byte uplo, int n,
                           @Cast("lapack_complex_float*") float[] a, int lda,
                           int[] piv, int[] rank, float tol );
public static native int LAPACKE_zpstrf( int matrix_layout, @Cast("char") byte uplo, int n,
                           @Cast("lapack_complex_double*") DoublePointer a, int lda,
                           IntPointer piv, IntPointer rank, double tol );
public static native int LAPACKE_zpstrf( int matrix_layout, @Cast("char") byte uplo, int n,
                           @Cast("lapack_complex_double*") DoubleBuffer a, int lda,
                           IntBuffer piv, IntBuffer rank, double tol );
public static native int LAPACKE_zpstrf( int matrix_layout, @Cast("char") byte uplo, int n,
                           @Cast("lapack_complex_double*") double[] a, int lda,
                           int[] piv, int[] rank, double tol );

public static native int LAPACKE_sptcon( int n, @Const FloatPointer d, @Const FloatPointer e,
                           float anorm, FloatPointer rcond );
public static native int LAPACKE_sptcon( int n, @Const FloatBuffer d, @Const FloatBuffer e,
                           float anorm, FloatBuffer rcond );
public static native int LAPACKE_sptcon( int n, @Const float[] d, @Const float[] e,
                           float anorm, float[] rcond );
public static native int LAPACKE_dptcon( int n, @Const DoublePointer d, @Const DoublePointer e,
                           double anorm, DoublePointer rcond );
public static native int LAPACKE_dptcon( int n, @Const DoubleBuffer d, @Const DoubleBuffer e,
                           double anorm, DoubleBuffer rcond );
public static native int LAPACKE_dptcon( int n, @Const double[] d, @Const double[] e,
                           double anorm, double[] rcond );
public static native int LAPACKE_cptcon( int n, @Const FloatPointer d,
                           @Cast("const lapack_complex_float*") FloatPointer e, float anorm,
                           FloatPointer rcond );
public static native int LAPACKE_cptcon( int n, @Const FloatBuffer d,
                           @Cast("const lapack_complex_float*") FloatBuffer e, float anorm,
                           FloatBuffer rcond );
public static native int LAPACKE_cptcon( int n, @Const float[] d,
                           @Cast("const lapack_complex_float*") float[] e, float anorm,
                           float[] rcond );
public static native int LAPACKE_zptcon( int n, @Const DoublePointer d,
                           @Cast("const lapack_complex_double*") DoublePointer e, double anorm,
                           DoublePointer rcond );
public static native int LAPACKE_zptcon( int n, @Const DoubleBuffer d,
                           @Cast("const lapack_complex_double*") DoubleBuffer e, double anorm,
                           DoubleBuffer rcond );
public static native int LAPACKE_zptcon( int n, @Const double[] d,
                           @Cast("const lapack_complex_double*") double[] e, double anorm,
                           double[] rcond );

public static native int LAPACKE_spteqr( int matrix_layout, @Cast("char") byte compz, int n, FloatPointer d,
                           FloatPointer e, FloatPointer z, int ldz );
public static native int LAPACKE_spteqr( int matrix_layout, @Cast("char") byte compz, int n, FloatBuffer d,
                           FloatBuffer e, FloatBuffer z, int ldz );
public static native int LAPACKE_spteqr( int matrix_layout, @Cast("char") byte compz, int n, float[] d,
                           float[] e, float[] z, int ldz );
public static native int LAPACKE_dpteqr( int matrix_layout, @Cast("char") byte compz, int n,
                           DoublePointer d, DoublePointer e, DoublePointer z, int ldz );
public static native int LAPACKE_dpteqr( int matrix_layout, @Cast("char") byte compz, int n,
                           DoubleBuffer d, DoubleBuffer e, DoubleBuffer z, int ldz );
public static native int LAPACKE_dpteqr( int matrix_layout, @Cast("char") byte compz, int n,
                           double[] d, double[] e, double[] z, int ldz );
public static native int LAPACKE_cpteqr( int matrix_layout, @Cast("char") byte compz, int n, FloatPointer d,
                           FloatPointer e, @Cast("lapack_complex_float*") FloatPointer z, int ldz );
public static native int LAPACKE_cpteqr( int matrix_layout, @Cast("char") byte compz, int n, FloatBuffer d,
                           FloatBuffer e, @Cast("lapack_complex_float*") FloatBuffer z, int ldz );
public static native int LAPACKE_cpteqr( int matrix_layout, @Cast("char") byte compz, int n, float[] d,
                           float[] e, @Cast("lapack_complex_float*") float[] z, int ldz );
public static native int LAPACKE_zpteqr( int matrix_layout, @Cast("char") byte compz, int n,
                           DoublePointer d, DoublePointer e, @Cast("lapack_complex_double*") DoublePointer z,
                           int ldz );
public static native int LAPACKE_zpteqr( int matrix_layout, @Cast("char") byte compz, int n,
                           DoubleBuffer d, DoubleBuffer e, @Cast("lapack_complex_double*") DoubleBuffer z,
                           int ldz );
public static native int LAPACKE_zpteqr( int matrix_layout, @Cast("char") byte compz, int n,
                           double[] d, double[] e, @Cast("lapack_complex_double*") double[] z,
                           int ldz );

public static native int LAPACKE_sptrfs( int matrix_layout, int n, int nrhs,
                           @Const FloatPointer d, @Const FloatPointer e, @Const FloatPointer df,
                           @Const FloatPointer ef, @Const FloatPointer b, int ldb,
                           FloatPointer x, int ldx, FloatPointer ferr, FloatPointer berr );
public static native int LAPACKE_sptrfs( int matrix_layout, int n, int nrhs,
                           @Const FloatBuffer d, @Const FloatBuffer e, @Const FloatBuffer df,
                           @Const FloatBuffer ef, @Const FloatBuffer b, int ldb,
                           FloatBuffer x, int ldx, FloatBuffer ferr, FloatBuffer berr );
public static native int LAPACKE_sptrfs( int matrix_layout, int n, int nrhs,
                           @Const float[] d, @Const float[] e, @Const float[] df,
                           @Const float[] ef, @Const float[] b, int ldb,
                           float[] x, int ldx, float[] ferr, float[] berr );
public static native int LAPACKE_dptrfs( int matrix_layout, int n, int nrhs,
                           @Const DoublePointer d, @Const DoublePointer e, @Const DoublePointer df,
                           @Const DoublePointer ef, @Const DoublePointer b, int ldb,
                           DoublePointer x, int ldx, DoublePointer ferr,
                           DoublePointer berr );
public static native int LAPACKE_dptrfs( int matrix_layout, int n, int nrhs,
                           @Const DoubleBuffer d, @Const DoubleBuffer e, @Const DoubleBuffer df,
                           @Const DoubleBuffer ef, @Const DoubleBuffer b, int ldb,
                           DoubleBuffer x, int ldx, DoubleBuffer ferr,
                           DoubleBuffer berr );
public static native int LAPACKE_dptrfs( int matrix_layout, int n, int nrhs,
                           @Const double[] d, @Const double[] e, @Const double[] df,
                           @Const double[] ef, @Const double[] b, int ldb,
                           double[] x, int ldx, double[] ferr,
                           double[] berr );
public static native int LAPACKE_cptrfs( int matrix_layout, @Cast("char") byte uplo, int n,
                           int nrhs, @Const FloatPointer d,
                           @Cast("const lapack_complex_float*") FloatPointer e, @Const FloatPointer df,
                           @Cast("const lapack_complex_float*") FloatPointer ef,
                           @Cast("const lapack_complex_float*") FloatPointer b, int ldb,
                           @Cast("lapack_complex_float*") FloatPointer x, int ldx, FloatPointer ferr,
                           FloatPointer berr );
public static native int LAPACKE_cptrfs( int matrix_layout, @Cast("char") byte uplo, int n,
                           int nrhs, @Const FloatBuffer d,
                           @Cast("const lapack_complex_float*") FloatBuffer e, @Const FloatBuffer df,
                           @Cast("const lapack_complex_float*") FloatBuffer ef,
                           @Cast("const lapack_complex_float*") FloatBuffer b, int ldb,
                           @Cast("lapack_complex_float*") FloatBuffer x, int ldx, FloatBuffer ferr,
                           FloatBuffer berr );
public static native int LAPACKE_cptrfs( int matrix_layout, @Cast("char") byte uplo, int n,
                           int nrhs, @Const float[] d,
                           @Cast("const lapack_complex_float*") float[] e, @Const float[] df,
                           @Cast("const lapack_complex_float*") float[] ef,
                           @Cast("const lapack_complex_float*") float[] b, int ldb,
                           @Cast("lapack_complex_float*") float[] x, int ldx, float[] ferr,
                           float[] berr );
public static native int LAPACKE_zptrfs( int matrix_layout, @Cast("char") byte uplo, int n,
                           int nrhs, @Const DoublePointer d,
                           @Cast("const lapack_complex_double*") DoublePointer e, @Const DoublePointer df,
                           @Cast("const lapack_complex_double*") DoublePointer ef,
                           @Cast("const lapack_complex_double*") DoublePointer b, int ldb,
                           @Cast("lapack_complex_double*") DoublePointer x, int ldx,
                           DoublePointer ferr, DoublePointer berr );
public static native int LAPACKE_zptrfs( int matrix_layout, @Cast("char") byte uplo, int n,
                           int nrhs, @Const DoubleBuffer d,
                           @Cast("const lapack_complex_double*") DoubleBuffer e, @Const DoubleBuffer df,
                           @Cast("const lapack_complex_double*") DoubleBuffer ef,
                           @Cast("const lapack_complex_double*") DoubleBuffer b, int ldb,
                           @Cast("lapack_complex_double*") DoubleBuffer x, int ldx,
                           DoubleBuffer ferr, DoubleBuffer berr );
public static native int LAPACKE_zptrfs( int matrix_layout, @Cast("char") byte uplo, int n,
                           int nrhs, @Const double[] d,
                           @Cast("const lapack_complex_double*") double[] e, @Const double[] df,
                           @Cast("const lapack_complex_double*") double[] ef,
                           @Cast("const lapack_complex_double*") double[] b, int ldb,
                           @Cast("lapack_complex_double*") double[] x, int ldx,
                           double[] ferr, double[] berr );

public static native int LAPACKE_sptsv( int matrix_layout, int n, int nrhs,
                          FloatPointer d, FloatPointer e, FloatPointer b, int ldb );
public static native int LAPACKE_sptsv( int matrix_layout, int n, int nrhs,
                          FloatBuffer d, FloatBuffer e, FloatBuffer b, int ldb );
public static native int LAPACKE_sptsv( int matrix_layout, int n, int nrhs,
                          float[] d, float[] e, float[] b, int ldb );
public static native int LAPACKE_dptsv( int matrix_layout, int n, int nrhs,
                          DoublePointer d, DoublePointer e, DoublePointer b, int ldb );
public static native int LAPACKE_dptsv( int matrix_layout, int n, int nrhs,
                          DoubleBuffer d, DoubleBuffer e, DoubleBuffer b, int ldb );
public static native int LAPACKE_dptsv( int matrix_layout, int n, int nrhs,
                          double[] d, double[] e, double[] b, int ldb );
public static native int LAPACKE_cptsv( int matrix_layout, int n, int nrhs,
                          FloatPointer d, @Cast("lapack_complex_float*") FloatPointer e,
                          @Cast("lapack_complex_float*") FloatPointer b, int ldb );
public static native int LAPACKE_cptsv( int matrix_layout, int n, int nrhs,
                          FloatBuffer d, @Cast("lapack_complex_float*") FloatBuffer e,
                          @Cast("lapack_complex_float*") FloatBuffer b, int ldb );
public static native int LAPACKE_cptsv( int matrix_layout, int n, int nrhs,
                          float[] d, @Cast("lapack_complex_float*") float[] e,
                          @Cast("lapack_complex_float*") float[] b, int ldb );
public static native int LAPACKE_zptsv( int matrix_layout, int n, int nrhs,
                          DoublePointer d, @Cast("lapack_complex_double*") DoublePointer e,
                          @Cast("lapack_complex_double*") DoublePointer b, int ldb );
public static native int LAPACKE_zptsv( int matrix_layout, int n, int nrhs,
                          DoubleBuffer d, @Cast("lapack_complex_double*") DoubleBuffer e,
                          @Cast("lapack_complex_double*") DoubleBuffer b, int ldb );
public static native int LAPACKE_zptsv( int matrix_layout, int n, int nrhs,
                          double[] d, @Cast("lapack_complex_double*") double[] e,
                          @Cast("lapack_complex_double*") double[] b, int ldb );

public static native int LAPACKE_sptsvx( int matrix_layout, @Cast("char") byte fact, int n,
                           int nrhs, @Const FloatPointer d, @Const FloatPointer e,
                           FloatPointer df, FloatPointer ef, @Const FloatPointer b, int ldb,
                           FloatPointer x, int ldx, FloatPointer rcond, FloatPointer ferr,
                           FloatPointer berr );
public static native int LAPACKE_sptsvx( int matrix_layout, @Cast("char") byte fact, int n,
                           int nrhs, @Const FloatBuffer d, @Const FloatBuffer e,
                           FloatBuffer df, FloatBuffer ef, @Const FloatBuffer b, int ldb,
                           FloatBuffer x, int ldx, FloatBuffer rcond, FloatBuffer ferr,
                           FloatBuffer berr );
public static native int LAPACKE_sptsvx( int matrix_layout, @Cast("char") byte fact, int n,
                           int nrhs, @Const float[] d, @Const float[] e,
                           float[] df, float[] ef, @Const float[] b, int ldb,
                           float[] x, int ldx, float[] rcond, float[] ferr,
                           float[] berr );
public static native int LAPACKE_dptsvx( int matrix_layout, @Cast("char") byte fact, int n,
                           int nrhs, @Const DoublePointer d, @Const DoublePointer e,
                           DoublePointer df, DoublePointer ef, @Const DoublePointer b,
                           int ldb, DoublePointer x, int ldx,
                           DoublePointer rcond, DoublePointer ferr, DoublePointer berr );
public static native int LAPACKE_dptsvx( int matrix_layout, @Cast("char") byte fact, int n,
                           int nrhs, @Const DoubleBuffer d, @Const DoubleBuffer e,
                           DoubleBuffer df, DoubleBuffer ef, @Const DoubleBuffer b,
                           int ldb, DoubleBuffer x, int ldx,
                           DoubleBuffer rcond, DoubleBuffer ferr, DoubleBuffer berr );
public static native int LAPACKE_dptsvx( int matrix_layout, @Cast("char") byte fact, int n,
                           int nrhs, @Const double[] d, @Const double[] e,
                           double[] df, double[] ef, @Const double[] b,
                           int ldb, double[] x, int ldx,
                           double[] rcond, double[] ferr, double[] berr );
public static native int LAPACKE_cptsvx( int matrix_layout, @Cast("char") byte fact, int n,
                           int nrhs, @Const FloatPointer d,
                           @Cast("const lapack_complex_float*") FloatPointer e, FloatPointer df,
                           @Cast("lapack_complex_float*") FloatPointer ef,
                           @Cast("const lapack_complex_float*") FloatPointer b, int ldb,
                           @Cast("lapack_complex_float*") FloatPointer x, int ldx,
                           FloatPointer rcond, FloatPointer ferr, FloatPointer berr );
public static native int LAPACKE_cptsvx( int matrix_layout, @Cast("char") byte fact, int n,
                           int nrhs, @Const FloatBuffer d,
                           @Cast("const lapack_complex_float*") FloatBuffer e, FloatBuffer df,
                           @Cast("lapack_complex_float*") FloatBuffer ef,
                           @Cast("const lapack_complex_float*") FloatBuffer b, int ldb,
                           @Cast("lapack_complex_float*") FloatBuffer x, int ldx,
                           FloatBuffer rcond, FloatBuffer ferr, FloatBuffer berr );
public static native int LAPACKE_cptsvx( int matrix_layout, @Cast("char") byte fact, int n,
                           int nrhs, @Const float[] d,
                           @Cast("const lapack_complex_float*") float[] e, float[] df,
                           @Cast("lapack_complex_float*") float[] ef,
                           @Cast("const lapack_complex_float*") float[] b, int ldb,
                           @Cast("lapack_complex_float*") float[] x, int ldx,
                           float[] rcond, float[] ferr, float[] berr );
public static native int LAPACKE_zptsvx( int matrix_layout, @Cast("char") byte fact, int n,
                           int nrhs, @Const DoublePointer d,
                           @Cast("const lapack_complex_double*") DoublePointer e, DoublePointer df,
                           @Cast("lapack_complex_double*") DoublePointer ef,
                           @Cast("const lapack_complex_double*") DoublePointer b, int ldb,
                           @Cast("lapack_complex_double*") DoublePointer x, int ldx,
                           DoublePointer rcond, DoublePointer ferr, DoublePointer berr );
public static native int LAPACKE_zptsvx( int matrix_layout, @Cast("char") byte fact, int n,
                           int nrhs, @Const DoubleBuffer d,
                           @Cast("const lapack_complex_double*") DoubleBuffer e, DoubleBuffer df,
                           @Cast("lapack_complex_double*") DoubleBuffer ef,
                           @Cast("const lapack_complex_double*") DoubleBuffer b, int ldb,
                           @Cast("lapack_complex_double*") DoubleBuffer x, int ldx,
                           DoubleBuffer rcond, DoubleBuffer ferr, DoubleBuffer berr );
public static native int LAPACKE_zptsvx( int matrix_layout, @Cast("char") byte fact, int n,
                           int nrhs, @Const double[] d,
                           @Cast("const lapack_complex_double*") double[] e, double[] df,
                           @Cast("lapack_complex_double*") double[] ef,
                           @Cast("const lapack_complex_double*") double[] b, int ldb,
                           @Cast("lapack_complex_double*") double[] x, int ldx,
                           double[] rcond, double[] ferr, double[] berr );

public static native int LAPACKE_spttrf( int n, FloatPointer d, FloatPointer e );
public static native int LAPACKE_spttrf( int n, FloatBuffer d, FloatBuffer e );
public static native int LAPACKE_spttrf( int n, float[] d, float[] e );
public static native int LAPACKE_dpttrf( int n, DoublePointer d, DoublePointer e );
public static native int LAPACKE_dpttrf( int n, DoubleBuffer d, DoubleBuffer e );
public static native int LAPACKE_dpttrf( int n, double[] d, double[] e );
public static native int LAPACKE_cpttrf( int n, FloatPointer d, @Cast("lapack_complex_float*") FloatPointer e );
public static native int LAPACKE_cpttrf( int n, FloatBuffer d, @Cast("lapack_complex_float*") FloatBuffer e );
public static native int LAPACKE_cpttrf( int n, float[] d, @Cast("lapack_complex_float*") float[] e );
public static native int LAPACKE_zpttrf( int n, DoublePointer d, @Cast("lapack_complex_double*") DoublePointer e );
public static native int LAPACKE_zpttrf( int n, DoubleBuffer d, @Cast("lapack_complex_double*") DoubleBuffer e );
public static native int LAPACKE_zpttrf( int n, double[] d, @Cast("lapack_complex_double*") double[] e );

public static native int LAPACKE_spttrs( int matrix_layout, int n, int nrhs,
                           @Const FloatPointer d, @Const FloatPointer e, FloatPointer b,
                           int ldb );
public static native int LAPACKE_spttrs( int matrix_layout, int n, int nrhs,
                           @Const FloatBuffer d, @Const FloatBuffer e, FloatBuffer b,
                           int ldb );
public static native int LAPACKE_spttrs( int matrix_layout, int n, int nrhs,
                           @Const float[] d, @Const float[] e, float[] b,
                           int ldb );
public static native int LAPACKE_dpttrs( int matrix_layout, int n, int nrhs,
                           @Const DoublePointer d, @Const DoublePointer e, DoublePointer b,
                           int ldb );
public static native int LAPACKE_dpttrs( int matrix_layout, int n, int nrhs,
                           @Const DoubleBuffer d, @Const DoubleBuffer e, DoubleBuffer b,
                           int ldb );
public static native int LAPACKE_dpttrs( int matrix_layout, int n, int nrhs,
                           @Const double[] d, @Const double[] e, double[] b,
                           int ldb );
public static native int LAPACKE_cpttrs( int matrix_layout, @Cast("char") byte uplo, int n,
                           int nrhs, @Const FloatPointer d,
                           @Cast("const lapack_complex_float*") FloatPointer e,
                           @Cast("lapack_complex_float*") FloatPointer b, int ldb );
public static native int LAPACKE_cpttrs( int matrix_layout, @Cast("char") byte uplo, int n,
                           int nrhs, @Const FloatBuffer d,
                           @Cast("const lapack_complex_float*") FloatBuffer e,
                           @Cast("lapack_complex_float*") FloatBuffer b, int ldb );
public static native int LAPACKE_cpttrs( int matrix_layout, @Cast("char") byte uplo, int n,
                           int nrhs, @Const float[] d,
                           @Cast("const lapack_complex_float*") float[] e,
                           @Cast("lapack_complex_float*") float[] b, int ldb );
public static native int LAPACKE_zpttrs( int matrix_layout, @Cast("char") byte uplo, int n,
                           int nrhs, @Const DoublePointer d,
                           @Cast("const lapack_complex_double*") DoublePointer e,
                           @Cast("lapack_complex_double*") DoublePointer b, int ldb );
public static native int LAPACKE_zpttrs( int matrix_layout, @Cast("char") byte uplo, int n,
                           int nrhs, @Const DoubleBuffer d,
                           @Cast("const lapack_complex_double*") DoubleBuffer e,
                           @Cast("lapack_complex_double*") DoubleBuffer b, int ldb );
public static native int LAPACKE_zpttrs( int matrix_layout, @Cast("char") byte uplo, int n,
                           int nrhs, @Const double[] d,
                           @Cast("const lapack_complex_double*") double[] e,
                           @Cast("lapack_complex_double*") double[] b, int ldb );

public static native int LAPACKE_ssbev( int matrix_layout, @Cast("char") byte jobz, @Cast("char") byte uplo, int n,
                          int kd, FloatPointer ab, int ldab, FloatPointer w,
                          FloatPointer z, int ldz );
public static native int LAPACKE_ssbev( int matrix_layout, @Cast("char") byte jobz, @Cast("char") byte uplo, int n,
                          int kd, FloatBuffer ab, int ldab, FloatBuffer w,
                          FloatBuffer z, int ldz );
public static native int LAPACKE_ssbev( int matrix_layout, @Cast("char") byte jobz, @Cast("char") byte uplo, int n,
                          int kd, float[] ab, int ldab, float[] w,
                          float[] z, int ldz );
public static native int LAPACKE_dsbev( int matrix_layout, @Cast("char") byte jobz, @Cast("char") byte uplo, int n,
                          int kd, DoublePointer ab, int ldab, DoublePointer w,
                          DoublePointer z, int ldz );
public static native int LAPACKE_dsbev( int matrix_layout, @Cast("char") byte jobz, @Cast("char") byte uplo, int n,
                          int kd, DoubleBuffer ab, int ldab, DoubleBuffer w,
                          DoubleBuffer z, int ldz );
public static native int LAPACKE_dsbev( int matrix_layout, @Cast("char") byte jobz, @Cast("char") byte uplo, int n,
                          int kd, double[] ab, int ldab, double[] w,
                          double[] z, int ldz );

public static native int LAPACKE_ssbevd( int matrix_layout, @Cast("char") byte jobz, @Cast("char") byte uplo, int n,
                           int kd, FloatPointer ab, int ldab, FloatPointer w,
                           FloatPointer z, int ldz );
public static native int LAPACKE_ssbevd( int matrix_layout, @Cast("char") byte jobz, @Cast("char") byte uplo, int n,
                           int kd, FloatBuffer ab, int ldab, FloatBuffer w,
                           FloatBuffer z, int ldz );
public static native int LAPACKE_ssbevd( int matrix_layout, @Cast("char") byte jobz, @Cast("char") byte uplo, int n,
                           int kd, float[] ab, int ldab, float[] w,
                           float[] z, int ldz );
public static native int LAPACKE_dsbevd( int matrix_layout, @Cast("char") byte jobz, @Cast("char") byte uplo, int n,
                           int kd, DoublePointer ab, int ldab,
                           DoublePointer w, DoublePointer z, int ldz );
public static native int LAPACKE_dsbevd( int matrix_layout, @Cast("char") byte jobz, @Cast("char") byte uplo, int n,
                           int kd, DoubleBuffer ab, int ldab,
                           DoubleBuffer w, DoubleBuffer z, int ldz );
public static native int LAPACKE_dsbevd( int matrix_layout, @Cast("char") byte jobz, @Cast("char") byte uplo, int n,
                           int kd, double[] ab, int ldab,
                           double[] w, double[] z, int ldz );

public static native int LAPACKE_ssbevx( int matrix_layout, @Cast("char") byte jobz, @Cast("char") byte range, @Cast("char") byte uplo,
                           int n, int kd, FloatPointer ab,
                           int ldab, FloatPointer q, int ldq, float vl,
                           float vu, int il, int iu, float abstol,
                           IntPointer m, FloatPointer w, FloatPointer z, int ldz,
                           IntPointer ifail );
public static native int LAPACKE_ssbevx( int matrix_layout, @Cast("char") byte jobz, @Cast("char") byte range, @Cast("char") byte uplo,
                           int n, int kd, FloatBuffer ab,
                           int ldab, FloatBuffer q, int ldq, float vl,
                           float vu, int il, int iu, float abstol,
                           IntBuffer m, FloatBuffer w, FloatBuffer z, int ldz,
                           IntBuffer ifail );
public static native int LAPACKE_ssbevx( int matrix_layout, @Cast("char") byte jobz, @Cast("char") byte range, @Cast("char") byte uplo,
                           int n, int kd, float[] ab,
                           int ldab, float[] q, int ldq, float vl,
                           float vu, int il, int iu, float abstol,
                           int[] m, float[] w, float[] z, int ldz,
                           int[] ifail );
public static native int LAPACKE_dsbevx( int matrix_layout, @Cast("char") byte jobz, @Cast("char") byte range, @Cast("char") byte uplo,
                           int n, int kd, DoublePointer ab,
                           int ldab, DoublePointer q, int ldq,
                           double vl, double vu, int il, int iu,
                           double abstol, IntPointer m, DoublePointer w, DoublePointer z,
                           int ldz, IntPointer ifail );
public static native int LAPACKE_dsbevx( int matrix_layout, @Cast("char") byte jobz, @Cast("char") byte range, @Cast("char") byte uplo,
                           int n, int kd, DoubleBuffer ab,
                           int ldab, DoubleBuffer q, int ldq,
                           double vl, double vu, int il, int iu,
                           double abstol, IntBuffer m, DoubleBuffer w, DoubleBuffer z,
                           int ldz, IntBuffer ifail );
public static native int LAPACKE_dsbevx( int matrix_layout, @Cast("char") byte jobz, @Cast("char") byte range, @Cast("char") byte uplo,
                           int n, int kd, double[] ab,
                           int ldab, double[] q, int ldq,
                           double vl, double vu, int il, int iu,
                           double abstol, int[] m, double[] w, double[] z,
                           int ldz, int[] ifail );

public static native int LAPACKE_ssbgst( int matrix_layout, @Cast("char") byte vect, @Cast("char") byte uplo, int n,
                           int ka, int kb, FloatPointer ab,
                           int ldab, @Const FloatPointer bb, int ldbb,
                           FloatPointer x, int ldx );
public static native int LAPACKE_ssbgst( int matrix_layout, @Cast("char") byte vect, @Cast("char") byte uplo, int n,
                           int ka, int kb, FloatBuffer ab,
                           int ldab, @Const FloatBuffer bb, int ldbb,
                           FloatBuffer x, int ldx );
public static native int LAPACKE_ssbgst( int matrix_layout, @Cast("char") byte vect, @Cast("char") byte uplo, int n,
                           int ka, int kb, float[] ab,
                           int ldab, @Const float[] bb, int ldbb,
                           float[] x, int ldx );
public static native int LAPACKE_dsbgst( int matrix_layout, @Cast("char") byte vect, @Cast("char") byte uplo, int n,
                           int ka, int kb, DoublePointer ab,
                           int ldab, @Const DoublePointer bb, int ldbb,
                           DoublePointer x, int ldx );
public static native int LAPACKE_dsbgst( int matrix_layout, @Cast("char") byte vect, @Cast("char") byte uplo, int n,
                           int ka, int kb, DoubleBuffer ab,
                           int ldab, @Const DoubleBuffer bb, int ldbb,
                           DoubleBuffer x, int ldx );
public static native int LAPACKE_dsbgst( int matrix_layout, @Cast("char") byte vect, @Cast("char") byte uplo, int n,
                           int ka, int kb, double[] ab,
                           int ldab, @Const double[] bb, int ldbb,
                           double[] x, int ldx );

public static native int LAPACKE_ssbgv( int matrix_layout, @Cast("char") byte jobz, @Cast("char") byte uplo, int n,
                          int ka, int kb, FloatPointer ab,
                          int ldab, FloatPointer bb, int ldbb, FloatPointer w,
                          FloatPointer z, int ldz );
public static native int LAPACKE_ssbgv( int matrix_layout, @Cast("char") byte jobz, @Cast("char") byte uplo, int n,
                          int ka, int kb, FloatBuffer ab,
                          int ldab, FloatBuffer bb, int ldbb, FloatBuffer w,
                          FloatBuffer z, int ldz );
public static native int LAPACKE_ssbgv( int matrix_layout, @Cast("char") byte jobz, @Cast("char") byte uplo, int n,
                          int ka, int kb, float[] ab,
                          int ldab, float[] bb, int ldbb, float[] w,
                          float[] z, int ldz );
public static native int LAPACKE_dsbgv( int matrix_layout, @Cast("char") byte jobz, @Cast("char") byte uplo, int n,
                          int ka, int kb, DoublePointer ab,
                          int ldab, DoublePointer bb, int ldbb,
                          DoublePointer w, DoublePointer z, int ldz );
public static native int LAPACKE_dsbgv( int matrix_layout, @Cast("char") byte jobz, @Cast("char") byte uplo, int n,
                          int ka, int kb, DoubleBuffer ab,
                          int ldab, DoubleBuffer bb, int ldbb,
                          DoubleBuffer w, DoubleBuffer z, int ldz );
public static native int LAPACKE_dsbgv( int matrix_layout, @Cast("char") byte jobz, @Cast("char") byte uplo, int n,
                          int ka, int kb, double[] ab,
                          int ldab, double[] bb, int ldbb,
                          double[] w, double[] z, int ldz );

public static native int LAPACKE_ssbgvd( int matrix_layout, @Cast("char") byte jobz, @Cast("char") byte uplo, int n,
                           int ka, int kb, FloatPointer ab,
                           int ldab, FloatPointer bb, int ldbb,
                           FloatPointer w, FloatPointer z, int ldz );
public static native int LAPACKE_ssbgvd( int matrix_layout, @Cast("char") byte jobz, @Cast("char") byte uplo, int n,
                           int ka, int kb, FloatBuffer ab,
                           int ldab, FloatBuffer bb, int ldbb,
                           FloatBuffer w, FloatBuffer z, int ldz );
public static native int LAPACKE_ssbgvd( int matrix_layout, @Cast("char") byte jobz, @Cast("char") byte uplo, int n,
                           int ka, int kb, float[] ab,
                           int ldab, float[] bb, int ldbb,
                           float[] w, float[] z, int ldz );
public static native int LAPACKE_dsbgvd( int matrix_layout, @Cast("char") byte jobz, @Cast("char") byte uplo, int n,
                           int ka, int kb, DoublePointer ab,
                           int ldab, DoublePointer bb, int ldbb,
                           DoublePointer w, DoublePointer z, int ldz );
public static native int LAPACKE_dsbgvd( int matrix_layout, @Cast("char") byte jobz, @Cast("char") byte uplo, int n,
                           int ka, int kb, DoubleBuffer ab,
                           int ldab, DoubleBuffer bb, int ldbb,
                           DoubleBuffer w, DoubleBuffer z, int ldz );
public static native int LAPACKE_dsbgvd( int matrix_layout, @Cast("char") byte jobz, @Cast("char") byte uplo, int n,
                           int ka, int kb, double[] ab,
                           int ldab, double[] bb, int ldbb,
                           double[] w, double[] z, int ldz );

public static native int LAPACKE_ssbgvx( int matrix_layout, @Cast("char") byte jobz, @Cast("char") byte range, @Cast("char") byte uplo,
                           int n, int ka, int kb,
                           FloatPointer ab, int ldab, FloatPointer bb,
                           int ldbb, FloatPointer q, int ldq, float vl,
                           float vu, int il, int iu, float abstol,
                           IntPointer m, FloatPointer w, FloatPointer z, int ldz,
                           IntPointer ifail );
public static native int LAPACKE_ssbgvx( int matrix_layout, @Cast("char") byte jobz, @Cast("char") byte range, @Cast("char") byte uplo,
                           int n, int ka, int kb,
                           FloatBuffer ab, int ldab, FloatBuffer bb,
                           int ldbb, FloatBuffer q, int ldq, float vl,
                           float vu, int il, int iu, float abstol,
                           IntBuffer m, FloatBuffer w, FloatBuffer z, int ldz,
                           IntBuffer ifail );
public static native int LAPACKE_ssbgvx( int matrix_layout, @Cast("char") byte jobz, @Cast("char") byte range, @Cast("char") byte uplo,
                           int n, int ka, int kb,
                           float[] ab, int ldab, float[] bb,
                           int ldbb, float[] q, int ldq, float vl,
                           float vu, int il, int iu, float abstol,
                           int[] m, float[] w, float[] z, int ldz,
                           int[] ifail );
public static native int LAPACKE_dsbgvx( int matrix_layout, @Cast("char") byte jobz, @Cast("char") byte range, @Cast("char") byte uplo,
                           int n, int ka, int kb,
                           DoublePointer ab, int ldab, DoublePointer bb,
                           int ldbb, DoublePointer q, int ldq,
                           double vl, double vu, int il, int iu,
                           double abstol, IntPointer m, DoublePointer w, DoublePointer z,
                           int ldz, IntPointer ifail );
public static native int LAPACKE_dsbgvx( int matrix_layout, @Cast("char") byte jobz, @Cast("char") byte range, @Cast("char") byte uplo,
                           int n, int ka, int kb,
                           DoubleBuffer ab, int ldab, DoubleBuffer bb,
                           int ldbb, DoubleBuffer q, int ldq,
                           double vl, double vu, int il, int iu,
                           double abstol, IntBuffer m, DoubleBuffer w, DoubleBuffer z,
                           int ldz, IntBuffer ifail );
public static native int LAPACKE_dsbgvx( int matrix_layout, @Cast("char") byte jobz, @Cast("char") byte range, @Cast("char") byte uplo,
                           int n, int ka, int kb,
                           double[] ab, int ldab, double[] bb,
                           int ldbb, double[] q, int ldq,
                           double vl, double vu, int il, int iu,
                           double abstol, int[] m, double[] w, double[] z,
                           int ldz, int[] ifail );

public static native int LAPACKE_ssbtrd( int matrix_layout, @Cast("char") byte vect, @Cast("char") byte uplo, int n,
                           int kd, FloatPointer ab, int ldab, FloatPointer d,
                           FloatPointer e, FloatPointer q, int ldq );
public static native int LAPACKE_ssbtrd( int matrix_layout, @Cast("char") byte vect, @Cast("char") byte uplo, int n,
                           int kd, FloatBuffer ab, int ldab, FloatBuffer d,
                           FloatBuffer e, FloatBuffer q, int ldq );
public static native int LAPACKE_ssbtrd( int matrix_layout, @Cast("char") byte vect, @Cast("char") byte uplo, int n,
                           int kd, float[] ab, int ldab, float[] d,
                           float[] e, float[] q, int ldq );
public static native int LAPACKE_dsbtrd( int matrix_layout, @Cast("char") byte vect, @Cast("char") byte uplo, int n,
                           int kd, DoublePointer ab, int ldab,
                           DoublePointer d, DoublePointer e, DoublePointer q, int ldq );
public static native int LAPACKE_dsbtrd( int matrix_layout, @Cast("char") byte vect, @Cast("char") byte uplo, int n,
                           int kd, DoubleBuffer ab, int ldab,
                           DoubleBuffer d, DoubleBuffer e, DoubleBuffer q, int ldq );
public static native int LAPACKE_dsbtrd( int matrix_layout, @Cast("char") byte vect, @Cast("char") byte uplo, int n,
                           int kd, double[] ab, int ldab,
                           double[] d, double[] e, double[] q, int ldq );

public static native int LAPACKE_ssfrk( int matrix_layout, @Cast("char") byte transr, @Cast("char") byte uplo, @Cast("char") byte trans,
                          int n, int k, float alpha,
                          @Const FloatPointer a, int lda, float beta,
                          FloatPointer c );
public static native int LAPACKE_ssfrk( int matrix_layout, @Cast("char") byte transr, @Cast("char") byte uplo, @Cast("char") byte trans,
                          int n, int k, float alpha,
                          @Const FloatBuffer a, int lda, float beta,
                          FloatBuffer c );
public static native int LAPACKE_ssfrk( int matrix_layout, @Cast("char") byte transr, @Cast("char") byte uplo, @Cast("char") byte trans,
                          int n, int k, float alpha,
                          @Const float[] a, int lda, float beta,
                          float[] c );
public static native int LAPACKE_dsfrk( int matrix_layout, @Cast("char") byte transr, @Cast("char") byte uplo, @Cast("char") byte trans,
                          int n, int k, double alpha,
                          @Const DoublePointer a, int lda, double beta,
                          DoublePointer c );
public static native int LAPACKE_dsfrk( int matrix_layout, @Cast("char") byte transr, @Cast("char") byte uplo, @Cast("char") byte trans,
                          int n, int k, double alpha,
                          @Const DoubleBuffer a, int lda, double beta,
                          DoubleBuffer c );
public static native int LAPACKE_dsfrk( int matrix_layout, @Cast("char") byte transr, @Cast("char") byte uplo, @Cast("char") byte trans,
                          int n, int k, double alpha,
                          @Const double[] a, int lda, double beta,
                          double[] c );

public static native int LAPACKE_sspcon( int matrix_layout, @Cast("char") byte uplo, int n,
                           @Const FloatPointer ap, @Const IntPointer ipiv, float anorm,
                           FloatPointer rcond );
public static native int LAPACKE_sspcon( int matrix_layout, @Cast("char") byte uplo, int n,
                           @Const FloatBuffer ap, @Const IntBuffer ipiv, float anorm,
                           FloatBuffer rcond );
public static native int LAPACKE_sspcon( int matrix_layout, @Cast("char") byte uplo, int n,
                           @Const float[] ap, @Const int[] ipiv, float anorm,
                           float[] rcond );
public static native int LAPACKE_dspcon( int matrix_layout, @Cast("char") byte uplo, int n,
                           @Const DoublePointer ap, @Const IntPointer ipiv,
                           double anorm, DoublePointer rcond );
public static native int LAPACKE_dspcon( int matrix_layout, @Cast("char") byte uplo, int n,
                           @Const DoubleBuffer ap, @Const IntBuffer ipiv,
                           double anorm, DoubleBuffer rcond );
public static native int LAPACKE_dspcon( int matrix_layout, @Cast("char") byte uplo, int n,
                           @Const double[] ap, @Const int[] ipiv,
                           double anorm, double[] rcond );
public static native int LAPACKE_cspcon( int matrix_layout, @Cast("char") byte uplo, int n,
                           @Cast("const lapack_complex_float*") FloatPointer ap,
                           @Const IntPointer ipiv, float anorm, FloatPointer rcond );
public static native int LAPACKE_cspcon( int matrix_layout, @Cast("char") byte uplo, int n,
                           @Cast("const lapack_complex_float*") FloatBuffer ap,
                           @Const IntBuffer ipiv, float anorm, FloatBuffer rcond );
public static native int LAPACKE_cspcon( int matrix_layout, @Cast("char") byte uplo, int n,
                           @Cast("const lapack_complex_float*") float[] ap,
                           @Const int[] ipiv, float anorm, float[] rcond );
public static native int LAPACKE_zspcon( int matrix_layout, @Cast("char") byte uplo, int n,
                           @Cast("const lapack_complex_double*") DoublePointer ap,
                           @Const IntPointer ipiv, double anorm,
                           DoublePointer rcond );
public static native int LAPACKE_zspcon( int matrix_layout, @Cast("char") byte uplo, int n,
                           @Cast("const lapack_complex_double*") DoubleBuffer ap,
                           @Const IntBuffer ipiv, double anorm,
                           DoubleBuffer rcond );
public static native int LAPACKE_zspcon( int matrix_layout, @Cast("char") byte uplo, int n,
                           @Cast("const lapack_complex_double*") double[] ap,
                           @Const int[] ipiv, double anorm,
                           double[] rcond );

public static native int LAPACKE_sspev( int matrix_layout, @Cast("char") byte jobz, @Cast("char") byte uplo, int n,
                          FloatPointer ap, FloatPointer w, FloatPointer z, int ldz );
public static native int LAPACKE_sspev( int matrix_layout, @Cast("char") byte jobz, @Cast("char") byte uplo, int n,
                          FloatBuffer ap, FloatBuffer w, FloatBuffer z, int ldz );
public static native int LAPACKE_sspev( int matrix_layout, @Cast("char") byte jobz, @Cast("char") byte uplo, int n,
                          float[] ap, float[] w, float[] z, int ldz );
public static native int LAPACKE_dspev( int matrix_layout, @Cast("char") byte jobz, @Cast("char") byte uplo, int n,
                          DoublePointer ap, DoublePointer w, DoublePointer z, int ldz );
public static native int LAPACKE_dspev( int matrix_layout, @Cast("char") byte jobz, @Cast("char") byte uplo, int n,
                          DoubleBuffer ap, DoubleBuffer w, DoubleBuffer z, int ldz );
public static native int LAPACKE_dspev( int matrix_layout, @Cast("char") byte jobz, @Cast("char") byte uplo, int n,
                          double[] ap, double[] w, double[] z, int ldz );

public static native int LAPACKE_sspevd( int matrix_layout, @Cast("char") byte jobz, @Cast("char") byte uplo, int n,
                           FloatPointer ap, FloatPointer w, FloatPointer z, int ldz );
public static native int LAPACKE_sspevd( int matrix_layout, @Cast("char") byte jobz, @Cast("char") byte uplo, int n,
                           FloatBuffer ap, FloatBuffer w, FloatBuffer z, int ldz );
public static native int LAPACKE_sspevd( int matrix_layout, @Cast("char") byte jobz, @Cast("char") byte uplo, int n,
                           float[] ap, float[] w, float[] z, int ldz );
public static native int LAPACKE_dspevd( int matrix_layout, @Cast("char") byte jobz, @Cast("char") byte uplo, int n,
                           DoublePointer ap, DoublePointer w, DoublePointer z, int ldz );
public static native int LAPACKE_dspevd( int matrix_layout, @Cast("char") byte jobz, @Cast("char") byte uplo, int n,
                           DoubleBuffer ap, DoubleBuffer w, DoubleBuffer z, int ldz );
public static native int LAPACKE_dspevd( int matrix_layout, @Cast("char") byte jobz, @Cast("char") byte uplo, int n,
                           double[] ap, double[] w, double[] z, int ldz );

public static native int LAPACKE_sspevx( int matrix_layout, @Cast("char") byte jobz, @Cast("char") byte range, @Cast("char") byte uplo,
                           int n, FloatPointer ap, float vl, float vu,
                           int il, int iu, float abstol,
                           IntPointer m, FloatPointer w, FloatPointer z, int ldz,
                           IntPointer ifail );
public static native int LAPACKE_sspevx( int matrix_layout, @Cast("char") byte jobz, @Cast("char") byte range, @Cast("char") byte uplo,
                           int n, FloatBuffer ap, float vl, float vu,
                           int il, int iu, float abstol,
                           IntBuffer m, FloatBuffer w, FloatBuffer z, int ldz,
                           IntBuffer ifail );
public static native int LAPACKE_sspevx( int matrix_layout, @Cast("char") byte jobz, @Cast("char") byte range, @Cast("char") byte uplo,
                           int n, float[] ap, float vl, float vu,
                           int il, int iu, float abstol,
                           int[] m, float[] w, float[] z, int ldz,
                           int[] ifail );
public static native int LAPACKE_dspevx( int matrix_layout, @Cast("char") byte jobz, @Cast("char") byte range, @Cast("char") byte uplo,
                           int n, DoublePointer ap, double vl, double vu,
                           int il, int iu, double abstol,
                           IntPointer m, DoublePointer w, DoublePointer z, int ldz,
                           IntPointer ifail );
public static native int LAPACKE_dspevx( int matrix_layout, @Cast("char") byte jobz, @Cast("char") byte range, @Cast("char") byte uplo,
                           int n, DoubleBuffer ap, double vl, double vu,
                           int il, int iu, double abstol,
                           IntBuffer m, DoubleBuffer w, DoubleBuffer z, int ldz,
                           IntBuffer ifail );
public static native int LAPACKE_dspevx( int matrix_layout, @Cast("char") byte jobz, @Cast("char") byte range, @Cast("char") byte uplo,
                           int n, double[] ap, double vl, double vu,
                           int il, int iu, double abstol,
                           int[] m, double[] w, double[] z, int ldz,
                           int[] ifail );

public static native int LAPACKE_sspgst( int matrix_layout, int itype, @Cast("char") byte uplo,
                           int n, FloatPointer ap, @Const FloatPointer bp );
public static native int LAPACKE_sspgst( int matrix_layout, int itype, @Cast("char") byte uplo,
                           int n, FloatBuffer ap, @Const FloatBuffer bp );
public static native int LAPACKE_sspgst( int matrix_layout, int itype, @Cast("char") byte uplo,
                           int n, float[] ap, @Const float[] bp );
public static native int LAPACKE_dspgst( int matrix_layout, int itype, @Cast("char") byte uplo,
                           int n, DoublePointer ap, @Const DoublePointer bp );
public static native int LAPACKE_dspgst( int matrix_layout, int itype, @Cast("char") byte uplo,
                           int n, DoubleBuffer ap, @Const DoubleBuffer bp );
public static native int LAPACKE_dspgst( int matrix_layout, int itype, @Cast("char") byte uplo,
                           int n, double[] ap, @Const double[] bp );

public static native int LAPACKE_sspgv( int matrix_layout, int itype, @Cast("char") byte jobz,
                          @Cast("char") byte uplo, int n, FloatPointer ap, FloatPointer bp,
                          FloatPointer w, FloatPointer z, int ldz );
public static native int LAPACKE_sspgv( int matrix_layout, int itype, @Cast("char") byte jobz,
                          @Cast("char") byte uplo, int n, FloatBuffer ap, FloatBuffer bp,
                          FloatBuffer w, FloatBuffer z, int ldz );
public static native int LAPACKE_sspgv( int matrix_layout, int itype, @Cast("char") byte jobz,
                          @Cast("char") byte uplo, int n, float[] ap, float[] bp,
                          float[] w, float[] z, int ldz );
public static native int LAPACKE_dspgv( int matrix_layout, int itype, @Cast("char") byte jobz,
                          @Cast("char") byte uplo, int n, DoublePointer ap, DoublePointer bp,
                          DoublePointer w, DoublePointer z, int ldz );
public static native int LAPACKE_dspgv( int matrix_layout, int itype, @Cast("char") byte jobz,
                          @Cast("char") byte uplo, int n, DoubleBuffer ap, DoubleBuffer bp,
                          DoubleBuffer w, DoubleBuffer z, int ldz );
public static native int LAPACKE_dspgv( int matrix_layout, int itype, @Cast("char") byte jobz,
                          @Cast("char") byte uplo, int n, double[] ap, double[] bp,
                          double[] w, double[] z, int ldz );

public static native int LAPACKE_sspgvd( int matrix_layout, int itype, @Cast("char") byte jobz,
                           @Cast("char") byte uplo, int n, FloatPointer ap, FloatPointer bp,
                           FloatPointer w, FloatPointer z, int ldz );
public static native int LAPACKE_sspgvd( int matrix_layout, int itype, @Cast("char") byte jobz,
                           @Cast("char") byte uplo, int n, FloatBuffer ap, FloatBuffer bp,
                           FloatBuffer w, FloatBuffer z, int ldz );
public static native int LAPACKE_sspgvd( int matrix_layout, int itype, @Cast("char") byte jobz,
                           @Cast("char") byte uplo, int n, float[] ap, float[] bp,
                           float[] w, float[] z, int ldz );
public static native int LAPACKE_dspgvd( int matrix_layout, int itype, @Cast("char") byte jobz,
                           @Cast("char") byte uplo, int n, DoublePointer ap, DoublePointer bp,
                           DoublePointer w, DoublePointer z, int ldz );
public static native int LAPACKE_dspgvd( int matrix_layout, int itype, @Cast("char") byte jobz,
                           @Cast("char") byte uplo, int n, DoubleBuffer ap, DoubleBuffer bp,
                           DoubleBuffer w, DoubleBuffer z, int ldz );
public static native int LAPACKE_dspgvd( int matrix_layout, int itype, @Cast("char") byte jobz,
                           @Cast("char") byte uplo, int n, double[] ap, double[] bp,
                           double[] w, double[] z, int ldz );

public static native int LAPACKE_sspgvx( int matrix_layout, int itype, @Cast("char") byte jobz,
                           @Cast("char") byte range, @Cast("char") byte uplo, int n, FloatPointer ap,
                           FloatPointer bp, float vl, float vu, int il,
                           int iu, float abstol, IntPointer m, FloatPointer w,
                           FloatPointer z, int ldz, IntPointer ifail );
public static native int LAPACKE_sspgvx( int matrix_layout, int itype, @Cast("char") byte jobz,
                           @Cast("char") byte range, @Cast("char") byte uplo, int n, FloatBuffer ap,
                           FloatBuffer bp, float vl, float vu, int il,
                           int iu, float abstol, IntBuffer m, FloatBuffer w,
                           FloatBuffer z, int ldz, IntBuffer ifail );
public static native int LAPACKE_sspgvx( int matrix_layout, int itype, @Cast("char") byte jobz,
                           @Cast("char") byte range, @Cast("char") byte uplo, int n, float[] ap,
                           float[] bp, float vl, float vu, int il,
                           int iu, float abstol, int[] m, float[] w,
                           float[] z, int ldz, int[] ifail );
public static native int LAPACKE_dspgvx( int matrix_layout, int itype, @Cast("char") byte jobz,
                           @Cast("char") byte range, @Cast("char") byte uplo, int n, DoublePointer ap,
                           DoublePointer bp, double vl, double vu, int il,
                           int iu, double abstol, IntPointer m,
                           DoublePointer w, DoublePointer z, int ldz,
                           IntPointer ifail );
public static native int LAPACKE_dspgvx( int matrix_layout, int itype, @Cast("char") byte jobz,
                           @Cast("char") byte range, @Cast("char") byte uplo, int n, DoubleBuffer ap,
                           DoubleBuffer bp, double vl, double vu, int il,
                           int iu, double abstol, IntBuffer m,
                           DoubleBuffer w, DoubleBuffer z, int ldz,
                           IntBuffer ifail );
public static native int LAPACKE_dspgvx( int matrix_layout, int itype, @Cast("char") byte jobz,
                           @Cast("char") byte range, @Cast("char") byte uplo, int n, double[] ap,
                           double[] bp, double vl, double vu, int il,
                           int iu, double abstol, int[] m,
                           double[] w, double[] z, int ldz,
                           int[] ifail );

public static native int LAPACKE_ssprfs( int matrix_layout, @Cast("char") byte uplo, int n,
                           int nrhs, @Const FloatPointer ap, @Const FloatPointer afp,
                           @Const IntPointer ipiv, @Const FloatPointer b,
                           int ldb, FloatPointer x, int ldx,
                           FloatPointer ferr, FloatPointer berr );
public static native int LAPACKE_ssprfs( int matrix_layout, @Cast("char") byte uplo, int n,
                           int nrhs, @Const FloatBuffer ap, @Const FloatBuffer afp,
                           @Const IntBuffer ipiv, @Const FloatBuffer b,
                           int ldb, FloatBuffer x, int ldx,
                           FloatBuffer ferr, FloatBuffer berr );
public static native int LAPACKE_ssprfs( int matrix_layout, @Cast("char") byte uplo, int n,
                           int nrhs, @Const float[] ap, @Const float[] afp,
                           @Const int[] ipiv, @Const float[] b,
                           int ldb, float[] x, int ldx,
                           float[] ferr, float[] berr );
public static native int LAPACKE_dsprfs( int matrix_layout, @Cast("char") byte uplo, int n,
                           int nrhs, @Const DoublePointer ap, @Const DoublePointer afp,
                           @Const IntPointer ipiv, @Const DoublePointer b,
                           int ldb, DoublePointer x, int ldx,
                           DoublePointer ferr, DoublePointer berr );
public static native int LAPACKE_dsprfs( int matrix_layout, @Cast("char") byte uplo, int n,
                           int nrhs, @Const DoubleBuffer ap, @Const DoubleBuffer afp,
                           @Const IntBuffer ipiv, @Const DoubleBuffer b,
                           int ldb, DoubleBuffer x, int ldx,
                           DoubleBuffer ferr, DoubleBuffer berr );
public static native int LAPACKE_dsprfs( int matrix_layout, @Cast("char") byte uplo, int n,
                           int nrhs, @Const double[] ap, @Const double[] afp,
                           @Const int[] ipiv, @Const double[] b,
                           int ldb, double[] x, int ldx,
                           double[] ferr, double[] berr );
public static native int LAPACKE_csprfs( int matrix_layout, @Cast("char") byte uplo, int n,
                           int nrhs, @Cast("const lapack_complex_float*") FloatPointer ap,
                           @Cast("const lapack_complex_float*") FloatPointer afp,
                           @Const IntPointer ipiv,
                           @Cast("const lapack_complex_float*") FloatPointer b, int ldb,
                           @Cast("lapack_complex_float*") FloatPointer x, int ldx, FloatPointer ferr,
                           FloatPointer berr );
public static native int LAPACKE_csprfs( int matrix_layout, @Cast("char") byte uplo, int n,
                           int nrhs, @Cast("const lapack_complex_float*") FloatBuffer ap,
                           @Cast("const lapack_complex_float*") FloatBuffer afp,
                           @Const IntBuffer ipiv,
                           @Cast("const lapack_complex_float*") FloatBuffer b, int ldb,
                           @Cast("lapack_complex_float*") FloatBuffer x, int ldx, FloatBuffer ferr,
                           FloatBuffer berr );
public static native int LAPACKE_csprfs( int matrix_layout, @Cast("char") byte uplo, int n,
                           int nrhs, @Cast("const lapack_complex_float*") float[] ap,
                           @Cast("const lapack_complex_float*") float[] afp,
                           @Const int[] ipiv,
                           @Cast("const lapack_complex_float*") float[] b, int ldb,
                           @Cast("lapack_complex_float*") float[] x, int ldx, float[] ferr,
                           float[] berr );
public static native int LAPACKE_zsprfs( int matrix_layout, @Cast("char") byte uplo, int n,
                           int nrhs, @Cast("const lapack_complex_double*") DoublePointer ap,
                           @Cast("const lapack_complex_double*") DoublePointer afp,
                           @Const IntPointer ipiv,
                           @Cast("const lapack_complex_double*") DoublePointer b, int ldb,
                           @Cast("lapack_complex_double*") DoublePointer x, int ldx,
                           DoublePointer ferr, DoublePointer berr );
public static native int LAPACKE_zsprfs( int matrix_layout, @Cast("char") byte uplo, int n,
                           int nrhs, @Cast("const lapack_complex_double*") DoubleBuffer ap,
                           @Cast("const lapack_complex_double*") DoubleBuffer afp,
                           @Const IntBuffer ipiv,
                           @Cast("const lapack_complex_double*") DoubleBuffer b, int ldb,
                           @Cast("lapack_complex_double*") DoubleBuffer x, int ldx,
                           DoubleBuffer ferr, DoubleBuffer berr );
public static native int LAPACKE_zsprfs( int matrix_layout, @Cast("char") byte uplo, int n,
                           int nrhs, @Cast("const lapack_complex_double*") double[] ap,
                           @Cast("const lapack_complex_double*") double[] afp,
                           @Const int[] ipiv,
                           @Cast("const lapack_complex_double*") double[] b, int ldb,
                           @Cast("lapack_complex_double*") double[] x, int ldx,
                           double[] ferr, double[] berr );

public static native int LAPACKE_sspsv( int matrix_layout, @Cast("char") byte uplo, int n,
                          int nrhs, FloatPointer ap, IntPointer ipiv,
                          FloatPointer b, int ldb );
public static native int LAPACKE_sspsv( int matrix_layout, @Cast("char") byte uplo, int n,
                          int nrhs, FloatBuffer ap, IntBuffer ipiv,
                          FloatBuffer b, int ldb );
public static native int LAPACKE_sspsv( int matrix_layout, @Cast("char") byte uplo, int n,
                          int nrhs, float[] ap, int[] ipiv,
                          float[] b, int ldb );
public static native int LAPACKE_dspsv( int matrix_layout, @Cast("char") byte uplo, int n,
                          int nrhs, DoublePointer ap, IntPointer ipiv,
                          DoublePointer b, int ldb );
public static native int LAPACKE_dspsv( int matrix_layout, @Cast("char") byte uplo, int n,
                          int nrhs, DoubleBuffer ap, IntBuffer ipiv,
                          DoubleBuffer b, int ldb );
public static native int LAPACKE_dspsv( int matrix_layout, @Cast("char") byte uplo, int n,
                          int nrhs, double[] ap, int[] ipiv,
                          double[] b, int ldb );
public static native int LAPACKE_cspsv( int matrix_layout, @Cast("char") byte uplo, int n,
                          int nrhs, @Cast("lapack_complex_float*") FloatPointer ap,
                          IntPointer ipiv, @Cast("lapack_complex_float*") FloatPointer b,
                          int ldb );
public static native int LAPACKE_cspsv( int matrix_layout, @Cast("char") byte uplo, int n,
                          int nrhs, @Cast("lapack_complex_float*") FloatBuffer ap,
                          IntBuffer ipiv, @Cast("lapack_complex_float*") FloatBuffer b,
                          int ldb );
public static native int LAPACKE_cspsv( int matrix_layout, @Cast("char") byte uplo, int n,
                          int nrhs, @Cast("lapack_complex_float*") float[] ap,
                          int[] ipiv, @Cast("lapack_complex_float*") float[] b,
                          int ldb );
public static native int LAPACKE_zspsv( int matrix_layout, @Cast("char") byte uplo, int n,
                          int nrhs, @Cast("lapack_complex_double*") DoublePointer ap,
                          IntPointer ipiv, @Cast("lapack_complex_double*") DoublePointer b,
                          int ldb );
public static native int LAPACKE_zspsv( int matrix_layout, @Cast("char") byte uplo, int n,
                          int nrhs, @Cast("lapack_complex_double*") DoubleBuffer ap,
                          IntBuffer ipiv, @Cast("lapack_complex_double*") DoubleBuffer b,
                          int ldb );
public static native int LAPACKE_zspsv( int matrix_layout, @Cast("char") byte uplo, int n,
                          int nrhs, @Cast("lapack_complex_double*") double[] ap,
                          int[] ipiv, @Cast("lapack_complex_double*") double[] b,
                          int ldb );

public static native int LAPACKE_sspsvx( int matrix_layout, @Cast("char") byte fact, @Cast("char") byte uplo, int n,
                           int nrhs, @Const FloatPointer ap, FloatPointer afp,
                           IntPointer ipiv, @Const FloatPointer b, int ldb,
                           FloatPointer x, int ldx, FloatPointer rcond, FloatPointer ferr,
                           FloatPointer berr );
public static native int LAPACKE_sspsvx( int matrix_layout, @Cast("char") byte fact, @Cast("char") byte uplo, int n,
                           int nrhs, @Const FloatBuffer ap, FloatBuffer afp,
                           IntBuffer ipiv, @Const FloatBuffer b, int ldb,
                           FloatBuffer x, int ldx, FloatBuffer rcond, FloatBuffer ferr,
                           FloatBuffer berr );
public static native int LAPACKE_sspsvx( int matrix_layout, @Cast("char") byte fact, @Cast("char") byte uplo, int n,
                           int nrhs, @Const float[] ap, float[] afp,
                           int[] ipiv, @Const float[] b, int ldb,
                           float[] x, int ldx, float[] rcond, float[] ferr,
                           float[] berr );
public static native int LAPACKE_dspsvx( int matrix_layout, @Cast("char") byte fact, @Cast("char") byte uplo, int n,
                           int nrhs, @Const DoublePointer ap, DoublePointer afp,
                           IntPointer ipiv, @Const DoublePointer b, int ldb,
                           DoublePointer x, int ldx, DoublePointer rcond,
                           DoublePointer ferr, DoublePointer berr );
public static native int LAPACKE_dspsvx( int matrix_layout, @Cast("char") byte fact, @Cast("char") byte uplo, int n,
                           int nrhs, @Const DoubleBuffer ap, DoubleBuffer afp,
                           IntBuffer ipiv, @Const DoubleBuffer b, int ldb,
                           DoubleBuffer x, int ldx, DoubleBuffer rcond,
                           DoubleBuffer ferr, DoubleBuffer berr );
public static native int LAPACKE_dspsvx( int matrix_layout, @Cast("char") byte fact, @Cast("char") byte uplo, int n,
                           int nrhs, @Const double[] ap, double[] afp,
                           int[] ipiv, @Const double[] b, int ldb,
                           double[] x, int ldx, double[] rcond,
                           double[] ferr, double[] berr );
public static native int LAPACKE_cspsvx( int matrix_layout, @Cast("char") byte fact, @Cast("char") byte uplo, int n,
                           int nrhs, @Cast("const lapack_complex_float*") FloatPointer ap,
                           @Cast("lapack_complex_float*") FloatPointer afp, IntPointer ipiv,
                           @Cast("const lapack_complex_float*") FloatPointer b, int ldb,
                           @Cast("lapack_complex_float*") FloatPointer x, int ldx,
                           FloatPointer rcond, FloatPointer ferr, FloatPointer berr );
public static native int LAPACKE_cspsvx( int matrix_layout, @Cast("char") byte fact, @Cast("char") byte uplo, int n,
                           int nrhs, @Cast("const lapack_complex_float*") FloatBuffer ap,
                           @Cast("lapack_complex_float*") FloatBuffer afp, IntBuffer ipiv,
                           @Cast("const lapack_complex_float*") FloatBuffer b, int ldb,
                           @Cast("lapack_complex_float*") FloatBuffer x, int ldx,
                           FloatBuffer rcond, FloatBuffer ferr, FloatBuffer berr );
public static native int LAPACKE_cspsvx( int matrix_layout, @Cast("char") byte fact, @Cast("char") byte uplo, int n,
                           int nrhs, @Cast("const lapack_complex_float*") float[] ap,
                           @Cast("lapack_complex_float*") float[] afp, int[] ipiv,
                           @Cast("const lapack_complex_float*") float[] b, int ldb,
                           @Cast("lapack_complex_float*") float[] x, int ldx,
                           float[] rcond, float[] ferr, float[] berr );
public static native int LAPACKE_zspsvx( int matrix_layout, @Cast("char") byte fact, @Cast("char") byte uplo, int n,
                           int nrhs, @Cast("const lapack_complex_double*") DoublePointer ap,
                           @Cast("lapack_complex_double*") DoublePointer afp, IntPointer ipiv,
                           @Cast("const lapack_complex_double*") DoublePointer b, int ldb,
                           @Cast("lapack_complex_double*") DoublePointer x, int ldx,
                           DoublePointer rcond, DoublePointer ferr, DoublePointer berr );
public static native int LAPACKE_zspsvx( int matrix_layout, @Cast("char") byte fact, @Cast("char") byte uplo, int n,
                           int nrhs, @Cast("const lapack_complex_double*") DoubleBuffer ap,
                           @Cast("lapack_complex_double*") DoubleBuffer afp, IntBuffer ipiv,
                           @Cast("const lapack_complex_double*") DoubleBuffer b, int ldb,
                           @Cast("lapack_complex_double*") DoubleBuffer x, int ldx,
                           DoubleBuffer rcond, DoubleBuffer ferr, DoubleBuffer berr );
public static native int LAPACKE_zspsvx( int matrix_layout, @Cast("char") byte fact, @Cast("char") byte uplo, int n,
                           int nrhs, @Cast("const lapack_complex_double*") double[] ap,
                           @Cast("lapack_complex_double*") double[] afp, int[] ipiv,
                           @Cast("const lapack_complex_double*") double[] b, int ldb,
                           @Cast("lapack_complex_double*") double[] x, int ldx,
                           double[] rcond, double[] ferr, double[] berr );

public static native int LAPACKE_ssptrd( int matrix_layout, @Cast("char") byte uplo, int n, FloatPointer ap,
                           FloatPointer d, FloatPointer e, FloatPointer tau );
public static native int LAPACKE_ssptrd( int matrix_layout, @Cast("char") byte uplo, int n, FloatBuffer ap,
                           FloatBuffer d, FloatBuffer e, FloatBuffer tau );
public static native int LAPACKE_ssptrd( int matrix_layout, @Cast("char") byte uplo, int n, float[] ap,
                           float[] d, float[] e, float[] tau );
public static native int LAPACKE_dsptrd( int matrix_layout, @Cast("char") byte uplo, int n,
                           DoublePointer ap, DoublePointer d, DoublePointer e, DoublePointer tau );
public static native int LAPACKE_dsptrd( int matrix_layout, @Cast("char") byte uplo, int n,
                           DoubleBuffer ap, DoubleBuffer d, DoubleBuffer e, DoubleBuffer tau );
public static native int LAPACKE_dsptrd( int matrix_layout, @Cast("char") byte uplo, int n,
                           double[] ap, double[] d, double[] e, double[] tau );

public static native int LAPACKE_ssptrf( int matrix_layout, @Cast("char") byte uplo, int n, FloatPointer ap,
                           IntPointer ipiv );
public static native int LAPACKE_ssptrf( int matrix_layout, @Cast("char") byte uplo, int n, FloatBuffer ap,
                           IntBuffer ipiv );
public static native int LAPACKE_ssptrf( int matrix_layout, @Cast("char") byte uplo, int n, float[] ap,
                           int[] ipiv );
public static native int LAPACKE_dsptrf( int matrix_layout, @Cast("char") byte uplo, int n,
                           DoublePointer ap, IntPointer ipiv );
public static native int LAPACKE_dsptrf( int matrix_layout, @Cast("char") byte uplo, int n,
                           DoubleBuffer ap, IntBuffer ipiv );
public static native int LAPACKE_dsptrf( int matrix_layout, @Cast("char") byte uplo, int n,
                           double[] ap, int[] ipiv );
public static native int LAPACKE_csptrf( int matrix_layout, @Cast("char") byte uplo, int n,
                           @Cast("lapack_complex_float*") FloatPointer ap, IntPointer ipiv );
public static native int LAPACKE_csptrf( int matrix_layout, @Cast("char") byte uplo, int n,
                           @Cast("lapack_complex_float*") FloatBuffer ap, IntBuffer ipiv );
public static native int LAPACKE_csptrf( int matrix_layout, @Cast("char") byte uplo, int n,
                           @Cast("lapack_complex_float*") float[] ap, int[] ipiv );
public static native int LAPACKE_zsptrf( int matrix_layout, @Cast("char") byte uplo, int n,
                           @Cast("lapack_complex_double*") DoublePointer ap, IntPointer ipiv );
public static native int LAPACKE_zsptrf( int matrix_layout, @Cast("char") byte uplo, int n,
                           @Cast("lapack_complex_double*") DoubleBuffer ap, IntBuffer ipiv );
public static native int LAPACKE_zsptrf( int matrix_layout, @Cast("char") byte uplo, int n,
                           @Cast("lapack_complex_double*") double[] ap, int[] ipiv );

public static native int LAPACKE_ssptri( int matrix_layout, @Cast("char") byte uplo, int n, FloatPointer ap,
                           @Const IntPointer ipiv );
public static native int LAPACKE_ssptri( int matrix_layout, @Cast("char") byte uplo, int n, FloatBuffer ap,
                           @Const IntBuffer ipiv );
public static native int LAPACKE_ssptri( int matrix_layout, @Cast("char") byte uplo, int n, float[] ap,
                           @Const int[] ipiv );
public static native int LAPACKE_dsptri( int matrix_layout, @Cast("char") byte uplo, int n,
                           DoublePointer ap, @Const IntPointer ipiv );
public static native int LAPACKE_dsptri( int matrix_layout, @Cast("char") byte uplo, int n,
                           DoubleBuffer ap, @Const IntBuffer ipiv );
public static native int LAPACKE_dsptri( int matrix_layout, @Cast("char") byte uplo, int n,
                           double[] ap, @Const int[] ipiv );
public static native int LAPACKE_csptri( int matrix_layout, @Cast("char") byte uplo, int n,
                           @Cast("lapack_complex_float*") FloatPointer ap, @Const IntPointer ipiv );
public static native int LAPACKE_csptri( int matrix_layout, @Cast("char") byte uplo, int n,
                           @Cast("lapack_complex_float*") FloatBuffer ap, @Const IntBuffer ipiv );
public static native int LAPACKE_csptri( int matrix_layout, @Cast("char") byte uplo, int n,
                           @Cast("lapack_complex_float*") float[] ap, @Const int[] ipiv );
public static native int LAPACKE_zsptri( int matrix_layout, @Cast("char") byte uplo, int n,
                           @Cast("lapack_complex_double*") DoublePointer ap, @Const IntPointer ipiv );
public static native int LAPACKE_zsptri( int matrix_layout, @Cast("char") byte uplo, int n,
                           @Cast("lapack_complex_double*") DoubleBuffer ap, @Const IntBuffer ipiv );
public static native int LAPACKE_zsptri( int matrix_layout, @Cast("char") byte uplo, int n,
                           @Cast("lapack_complex_double*") double[] ap, @Const int[] ipiv );

public static native int LAPACKE_ssptrs( int matrix_layout, @Cast("char") byte uplo, int n,
                           int nrhs, @Const FloatPointer ap,
                           @Const IntPointer ipiv, FloatPointer b, int ldb );
public static native int LAPACKE_ssptrs( int matrix_layout, @Cast("char") byte uplo, int n,
                           int nrhs, @Const FloatBuffer ap,
                           @Const IntBuffer ipiv, FloatBuffer b, int ldb );
public static native int LAPACKE_ssptrs( int matrix_layout, @Cast("char") byte uplo, int n,
                           int nrhs, @Const float[] ap,
                           @Const int[] ipiv, float[] b, int ldb );
public static native int LAPACKE_dsptrs( int matrix_layout, @Cast("char") byte uplo, int n,
                           int nrhs, @Const DoublePointer ap,
                           @Const IntPointer ipiv, DoublePointer b, int ldb );
public static native int LAPACKE_dsptrs( int matrix_layout, @Cast("char") byte uplo, int n,
                           int nrhs, @Const DoubleBuffer ap,
                           @Const IntBuffer ipiv, DoubleBuffer b, int ldb );
public static native int LAPACKE_dsptrs( int matrix_layout, @Cast("char") byte uplo, int n,
                           int nrhs, @Const double[] ap,
                           @Const int[] ipiv, double[] b, int ldb );
public static native int LAPACKE_csptrs( int matrix_layout, @Cast("char") byte uplo, int n,
                           int nrhs, @Cast("const lapack_complex_float*") FloatPointer ap,
                           @Const IntPointer ipiv, @Cast("lapack_complex_float*") FloatPointer b,
                           int ldb );
public static native int LAPACKE_csptrs( int matrix_layout, @Cast("char") byte uplo, int n,
                           int nrhs, @Cast("const lapack_complex_float*") FloatBuffer ap,
                           @Const IntBuffer ipiv, @Cast("lapack_complex_float*") FloatBuffer b,
                           int ldb );
public static native int LAPACKE_csptrs( int matrix_layout, @Cast("char") byte uplo, int n,
                           int nrhs, @Cast("const lapack_complex_float*") float[] ap,
                           @Const int[] ipiv, @Cast("lapack_complex_float*") float[] b,
                           int ldb );
public static native int LAPACKE_zsptrs( int matrix_layout, @Cast("char") byte uplo, int n,
                           int nrhs, @Cast("const lapack_complex_double*") DoublePointer ap,
                           @Const IntPointer ipiv, @Cast("lapack_complex_double*") DoublePointer b,
                           int ldb );
public static native int LAPACKE_zsptrs( int matrix_layout, @Cast("char") byte uplo, int n,
                           int nrhs, @Cast("const lapack_complex_double*") DoubleBuffer ap,
                           @Const IntBuffer ipiv, @Cast("lapack_complex_double*") DoubleBuffer b,
                           int ldb );
public static native int LAPACKE_zsptrs( int matrix_layout, @Cast("char") byte uplo, int n,
                           int nrhs, @Cast("const lapack_complex_double*") double[] ap,
                           @Const int[] ipiv, @Cast("lapack_complex_double*") double[] b,
                           int ldb );

public static native int LAPACKE_sstebz( @Cast("char") byte range, @Cast("char") byte order, int n, float vl,
                           float vu, int il, int iu, float abstol,
                           @Const FloatPointer d, @Const FloatPointer e, IntPointer m,
                           IntPointer nsplit, FloatPointer w, IntPointer iblock,
                           IntPointer isplit );
public static native int LAPACKE_sstebz( @Cast("char") byte range, @Cast("char") byte order, int n, float vl,
                           float vu, int il, int iu, float abstol,
                           @Const FloatBuffer d, @Const FloatBuffer e, IntBuffer m,
                           IntBuffer nsplit, FloatBuffer w, IntBuffer iblock,
                           IntBuffer isplit );
public static native int LAPACKE_sstebz( @Cast("char") byte range, @Cast("char") byte order, int n, float vl,
                           float vu, int il, int iu, float abstol,
                           @Const float[] d, @Const float[] e, int[] m,
                           int[] nsplit, float[] w, int[] iblock,
                           int[] isplit );
public static native int LAPACKE_dstebz( @Cast("char") byte range, @Cast("char") byte order, int n, double vl,
                           double vu, int il, int iu,
                           double abstol, @Const DoublePointer d, @Const DoublePointer e,
                           IntPointer m, IntPointer nsplit, DoublePointer w,
                           IntPointer iblock, IntPointer isplit );
public static native int LAPACKE_dstebz( @Cast("char") byte range, @Cast("char") byte order, int n, double vl,
                           double vu, int il, int iu,
                           double abstol, @Const DoubleBuffer d, @Const DoubleBuffer e,
                           IntBuffer m, IntBuffer nsplit, DoubleBuffer w,
                           IntBuffer iblock, IntBuffer isplit );
public static native int LAPACKE_dstebz( @Cast("char") byte range, @Cast("char") byte order, int n, double vl,
                           double vu, int il, int iu,
                           double abstol, @Const double[] d, @Const double[] e,
                           int[] m, int[] nsplit, double[] w,
                           int[] iblock, int[] isplit );

public static native int LAPACKE_sstedc( int matrix_layout, @Cast("char") byte compz, int n, FloatPointer d,
                           FloatPointer e, FloatPointer z, int ldz );
public static native int LAPACKE_sstedc( int matrix_layout, @Cast("char") byte compz, int n, FloatBuffer d,
                           FloatBuffer e, FloatBuffer z, int ldz );
public static native int LAPACKE_sstedc( int matrix_layout, @Cast("char") byte compz, int n, float[] d,
                           float[] e, float[] z, int ldz );
public static native int LAPACKE_dstedc( int matrix_layout, @Cast("char") byte compz, int n,
                           DoublePointer d, DoublePointer e, DoublePointer z, int ldz );
public static native int LAPACKE_dstedc( int matrix_layout, @Cast("char") byte compz, int n,
                           DoubleBuffer d, DoubleBuffer e, DoubleBuffer z, int ldz );
public static native int LAPACKE_dstedc( int matrix_layout, @Cast("char") byte compz, int n,
                           double[] d, double[] e, double[] z, int ldz );
public static native int LAPACKE_cstedc( int matrix_layout, @Cast("char") byte compz, int n, FloatPointer d,
                           FloatPointer e, @Cast("lapack_complex_float*") FloatPointer z, int ldz );
public static native int LAPACKE_cstedc( int matrix_layout, @Cast("char") byte compz, int n, FloatBuffer d,
                           FloatBuffer e, @Cast("lapack_complex_float*") FloatBuffer z, int ldz );
public static native int LAPACKE_cstedc( int matrix_layout, @Cast("char") byte compz, int n, float[] d,
                           float[] e, @Cast("lapack_complex_float*") float[] z, int ldz );
public static native int LAPACKE_zstedc( int matrix_layout, @Cast("char") byte compz, int n,
                           DoublePointer d, DoublePointer e, @Cast("lapack_complex_double*") DoublePointer z,
                           int ldz );
public static native int LAPACKE_zstedc( int matrix_layout, @Cast("char") byte compz, int n,
                           DoubleBuffer d, DoubleBuffer e, @Cast("lapack_complex_double*") DoubleBuffer z,
                           int ldz );
public static native int LAPACKE_zstedc( int matrix_layout, @Cast("char") byte compz, int n,
                           double[] d, double[] e, @Cast("lapack_complex_double*") double[] z,
                           int ldz );

public static native int LAPACKE_sstegr( int matrix_layout, @Cast("char") byte jobz, @Cast("char") byte range,
                           int n, FloatPointer d, FloatPointer e, float vl, float vu,
                           int il, int iu, float abstol,
                           IntPointer m, FloatPointer w, FloatPointer z, int ldz,
                           IntPointer isuppz );
public static native int LAPACKE_sstegr( int matrix_layout, @Cast("char") byte jobz, @Cast("char") byte range,
                           int n, FloatBuffer d, FloatBuffer e, float vl, float vu,
                           int il, int iu, float abstol,
                           IntBuffer m, FloatBuffer w, FloatBuffer z, int ldz,
                           IntBuffer isuppz );
public static native int LAPACKE_sstegr( int matrix_layout, @Cast("char") byte jobz, @Cast("char") byte range,
                           int n, float[] d, float[] e, float vl, float vu,
                           int il, int iu, float abstol,
                           int[] m, float[] w, float[] z, int ldz,
                           int[] isuppz );
public static native int LAPACKE_dstegr( int matrix_layout, @Cast("char") byte jobz, @Cast("char") byte range,
                           int n, DoublePointer d, DoublePointer e, double vl,
                           double vu, int il, int iu,
                           double abstol, IntPointer m, DoublePointer w, DoublePointer z,
                           int ldz, IntPointer isuppz );
public static native int LAPACKE_dstegr( int matrix_layout, @Cast("char") byte jobz, @Cast("char") byte range,
                           int n, DoubleBuffer d, DoubleBuffer e, double vl,
                           double vu, int il, int iu,
                           double abstol, IntBuffer m, DoubleBuffer w, DoubleBuffer z,
                           int ldz, IntBuffer isuppz );
public static native int LAPACKE_dstegr( int matrix_layout, @Cast("char") byte jobz, @Cast("char") byte range,
                           int n, double[] d, double[] e, double vl,
                           double vu, int il, int iu,
                           double abstol, int[] m, double[] w, double[] z,
                           int ldz, int[] isuppz );
public static native int LAPACKE_cstegr( int matrix_layout, @Cast("char") byte jobz, @Cast("char") byte range,
                           int n, FloatPointer d, FloatPointer e, float vl, float vu,
                           int il, int iu, float abstol,
                           IntPointer m, FloatPointer w, @Cast("lapack_complex_float*") FloatPointer z,
                           int ldz, IntPointer isuppz );
public static native int LAPACKE_cstegr( int matrix_layout, @Cast("char") byte jobz, @Cast("char") byte range,
                           int n, FloatBuffer d, FloatBuffer e, float vl, float vu,
                           int il, int iu, float abstol,
                           IntBuffer m, FloatBuffer w, @Cast("lapack_complex_float*") FloatBuffer z,
                           int ldz, IntBuffer isuppz );
public static native int LAPACKE_cstegr( int matrix_layout, @Cast("char") byte jobz, @Cast("char") byte range,
                           int n, float[] d, float[] e, float vl, float vu,
                           int il, int iu, float abstol,
                           int[] m, float[] w, @Cast("lapack_complex_float*") float[] z,
                           int ldz, int[] isuppz );
public static native int LAPACKE_zstegr( int matrix_layout, @Cast("char") byte jobz, @Cast("char") byte range,
                           int n, DoublePointer d, DoublePointer e, double vl,
                           double vu, int il, int iu,
                           double abstol, IntPointer m, DoublePointer w,
                           @Cast("lapack_complex_double*") DoublePointer z, int ldz,
                           IntPointer isuppz );
public static native int LAPACKE_zstegr( int matrix_layout, @Cast("char") byte jobz, @Cast("char") byte range,
                           int n, DoubleBuffer d, DoubleBuffer e, double vl,
                           double vu, int il, int iu,
                           double abstol, IntBuffer m, DoubleBuffer w,
                           @Cast("lapack_complex_double*") DoubleBuffer z, int ldz,
                           IntBuffer isuppz );
public static native int LAPACKE_zstegr( int matrix_layout, @Cast("char") byte jobz, @Cast("char") byte range,
                           int n, double[] d, double[] e, double vl,
                           double vu, int il, int iu,
                           double abstol, int[] m, double[] w,
                           @Cast("lapack_complex_double*") double[] z, int ldz,
                           int[] isuppz );

public static native int LAPACKE_sstein( int matrix_layout, int n, @Const FloatPointer d,
                           @Const FloatPointer e, int m, @Const FloatPointer w,
                           @Const IntPointer iblock, @Const IntPointer isplit,
                           FloatPointer z, int ldz, IntPointer ifailv );
public static native int LAPACKE_sstein( int matrix_layout, int n, @Const FloatBuffer d,
                           @Const FloatBuffer e, int m, @Const FloatBuffer w,
                           @Const IntBuffer iblock, @Const IntBuffer isplit,
                           FloatBuffer z, int ldz, IntBuffer ifailv );
public static native int LAPACKE_sstein( int matrix_layout, int n, @Const float[] d,
                           @Const float[] e, int m, @Const float[] w,
                           @Const int[] iblock, @Const int[] isplit,
                           float[] z, int ldz, int[] ifailv );
public static native int LAPACKE_dstein( int matrix_layout, int n, @Const DoublePointer d,
                           @Const DoublePointer e, int m, @Const DoublePointer w,
                           @Const IntPointer iblock, @Const IntPointer isplit,
                           DoublePointer z, int ldz, IntPointer ifailv );
public static native int LAPACKE_dstein( int matrix_layout, int n, @Const DoubleBuffer d,
                           @Const DoubleBuffer e, int m, @Const DoubleBuffer w,
                           @Const IntBuffer iblock, @Const IntBuffer isplit,
                           DoubleBuffer z, int ldz, IntBuffer ifailv );
public static native int LAPACKE_dstein( int matrix_layout, int n, @Const double[] d,
                           @Const double[] e, int m, @Const double[] w,
                           @Const int[] iblock, @Const int[] isplit,
                           double[] z, int ldz, int[] ifailv );
public static native int LAPACKE_cstein( int matrix_layout, int n, @Const FloatPointer d,
                           @Const FloatPointer e, int m, @Const FloatPointer w,
                           @Const IntPointer iblock, @Const IntPointer isplit,
                           @Cast("lapack_complex_float*") FloatPointer z, int ldz,
                           IntPointer ifailv );
public static native int LAPACKE_cstein( int matrix_layout, int n, @Const FloatBuffer d,
                           @Const FloatBuffer e, int m, @Const FloatBuffer w,
                           @Const IntBuffer iblock, @Const IntBuffer isplit,
                           @Cast("lapack_complex_float*") FloatBuffer z, int ldz,
                           IntBuffer ifailv );
public static native int LAPACKE_cstein( int matrix_layout, int n, @Const float[] d,
                           @Const float[] e, int m, @Const float[] w,
                           @Const int[] iblock, @Const int[] isplit,
                           @Cast("lapack_complex_float*") float[] z, int ldz,
                           int[] ifailv );
public static native int LAPACKE_zstein( int matrix_layout, int n, @Const DoublePointer d,
                           @Const DoublePointer e, int m, @Const DoublePointer w,
                           @Const IntPointer iblock, @Const IntPointer isplit,
                           @Cast("lapack_complex_double*") DoublePointer z, int ldz,
                           IntPointer ifailv );
public static native int LAPACKE_zstein( int matrix_layout, int n, @Const DoubleBuffer d,
                           @Const DoubleBuffer e, int m, @Const DoubleBuffer w,
                           @Const IntBuffer iblock, @Const IntBuffer isplit,
                           @Cast("lapack_complex_double*") DoubleBuffer z, int ldz,
                           IntBuffer ifailv );
public static native int LAPACKE_zstein( int matrix_layout, int n, @Const double[] d,
                           @Const double[] e, int m, @Const double[] w,
                           @Const int[] iblock, @Const int[] isplit,
                           @Cast("lapack_complex_double*") double[] z, int ldz,
                           int[] ifailv );

public static native int LAPACKE_sstemr( int matrix_layout, @Cast("char") byte jobz, @Cast("char") byte range,
                           int n, FloatPointer d, FloatPointer e, float vl, float vu,
                           int il, int iu, IntPointer m,
                           FloatPointer w, FloatPointer z, int ldz, int nzc,
                           IntPointer isuppz, IntPointer tryrac );
public static native int LAPACKE_sstemr( int matrix_layout, @Cast("char") byte jobz, @Cast("char") byte range,
                           int n, FloatBuffer d, FloatBuffer e, float vl, float vu,
                           int il, int iu, IntBuffer m,
                           FloatBuffer w, FloatBuffer z, int ldz, int nzc,
                           IntBuffer isuppz, IntBuffer tryrac );
public static native int LAPACKE_sstemr( int matrix_layout, @Cast("char") byte jobz, @Cast("char") byte range,
                           int n, float[] d, float[] e, float vl, float vu,
                           int il, int iu, int[] m,
                           float[] w, float[] z, int ldz, int nzc,
                           int[] isuppz, int[] tryrac );
public static native int LAPACKE_dstemr( int matrix_layout, @Cast("char") byte jobz, @Cast("char") byte range,
                           int n, DoublePointer d, DoublePointer e, double vl,
                           double vu, int il, int iu,
                           IntPointer m, DoublePointer w, DoublePointer z, int ldz,
                           int nzc, IntPointer isuppz,
                           IntPointer tryrac );
public static native int LAPACKE_dstemr( int matrix_layout, @Cast("char") byte jobz, @Cast("char") byte range,
                           int n, DoubleBuffer d, DoubleBuffer e, double vl,
                           double vu, int il, int iu,
                           IntBuffer m, DoubleBuffer w, DoubleBuffer z, int ldz,
                           int nzc, IntBuffer isuppz,
                           IntBuffer tryrac );
public static native int LAPACKE_dstemr( int matrix_layout, @Cast("char") byte jobz, @Cast("char") byte range,
                           int n, double[] d, double[] e, double vl,
                           double vu, int il, int iu,
                           int[] m, double[] w, double[] z, int ldz,
                           int nzc, int[] isuppz,
                           int[] tryrac );
public static native int LAPACKE_cstemr( int matrix_layout, @Cast("char") byte jobz, @Cast("char") byte range,
                           int n, FloatPointer d, FloatPointer e, float vl, float vu,
                           int il, int iu, IntPointer m,
                           FloatPointer w, @Cast("lapack_complex_float*") FloatPointer z, int ldz,
                           int nzc, IntPointer isuppz,
                           IntPointer tryrac );
public static native int LAPACKE_cstemr( int matrix_layout, @Cast("char") byte jobz, @Cast("char") byte range,
                           int n, FloatBuffer d, FloatBuffer e, float vl, float vu,
                           int il, int iu, IntBuffer m,
                           FloatBuffer w, @Cast("lapack_complex_float*") FloatBuffer z, int ldz,
                           int nzc, IntBuffer isuppz,
                           IntBuffer tryrac );
public static native int LAPACKE_cstemr( int matrix_layout, @Cast("char") byte jobz, @Cast("char") byte range,
                           int n, float[] d, float[] e, float vl, float vu,
                           int il, int iu, int[] m,
                           float[] w, @Cast("lapack_complex_float*") float[] z, int ldz,
                           int nzc, int[] isuppz,
                           int[] tryrac );
public static native int LAPACKE_zstemr( int matrix_layout, @Cast("char") byte jobz, @Cast("char") byte range,
                           int n, DoublePointer d, DoublePointer e, double vl,
                           double vu, int il, int iu,
                           IntPointer m, DoublePointer w, @Cast("lapack_complex_double*") DoublePointer z,
                           int ldz, int nzc, IntPointer isuppz,
                           IntPointer tryrac );
public static native int LAPACKE_zstemr( int matrix_layout, @Cast("char") byte jobz, @Cast("char") byte range,
                           int n, DoubleBuffer d, DoubleBuffer e, double vl,
                           double vu, int il, int iu,
                           IntBuffer m, DoubleBuffer w, @Cast("lapack_complex_double*") DoubleBuffer z,
                           int ldz, int nzc, IntBuffer isuppz,
                           IntBuffer tryrac );
public static native int LAPACKE_zstemr( int matrix_layout, @Cast("char") byte jobz, @Cast("char") byte range,
                           int n, double[] d, double[] e, double vl,
                           double vu, int il, int iu,
                           int[] m, double[] w, @Cast("lapack_complex_double*") double[] z,
                           int ldz, int nzc, int[] isuppz,
                           int[] tryrac );

public static native int LAPACKE_ssteqr( int matrix_layout, @Cast("char") byte compz, int n, FloatPointer d,
                           FloatPointer e, FloatPointer z, int ldz );
public static native int LAPACKE_ssteqr( int matrix_layout, @Cast("char") byte compz, int n, FloatBuffer d,
                           FloatBuffer e, FloatBuffer z, int ldz );
public static native int LAPACKE_ssteqr( int matrix_layout, @Cast("char") byte compz, int n, float[] d,
                           float[] e, float[] z, int ldz );
public static native int LAPACKE_dsteqr( int matrix_layout, @Cast("char") byte compz, int n,
                           DoublePointer d, DoublePointer e, DoublePointer z, int ldz );
public static native int LAPACKE_dsteqr( int matrix_layout, @Cast("char") byte compz, int n,
                           DoubleBuffer d, DoubleBuffer e, DoubleBuffer z, int ldz );
public static native int LAPACKE_dsteqr( int matrix_layout, @Cast("char") byte compz, int n,
                           double[] d, double[] e, double[] z, int ldz );
public static native int LAPACKE_csteqr( int matrix_layout, @Cast("char") byte compz, int n, FloatPointer d,
                           FloatPointer e, @Cast("lapack_complex_float*") FloatPointer z, int ldz );
public static native int LAPACKE_csteqr( int matrix_layout, @Cast("char") byte compz, int n, FloatBuffer d,
                           FloatBuffer e, @Cast("lapack_complex_float*") FloatBuffer z, int ldz );
public static native int LAPACKE_csteqr( int matrix_layout, @Cast("char") byte compz, int n, float[] d,
                           float[] e, @Cast("lapack_complex_float*") float[] z, int ldz );
public static native int LAPACKE_zsteqr( int matrix_layout, @Cast("char") byte compz, int n,
                           DoublePointer d, DoublePointer e, @Cast("lapack_complex_double*") DoublePointer z,
                           int ldz );
public static native int LAPACKE_zsteqr( int matrix_layout, @Cast("char") byte compz, int n,
                           DoubleBuffer d, DoubleBuffer e, @Cast("lapack_complex_double*") DoubleBuffer z,
                           int ldz );
public static native int LAPACKE_zsteqr( int matrix_layout, @Cast("char") byte compz, int n,
                           double[] d, double[] e, @Cast("lapack_complex_double*") double[] z,
                           int ldz );

public static native int LAPACKE_ssterf( int n, FloatPointer d, FloatPointer e );
public static native int LAPACKE_ssterf( int n, FloatBuffer d, FloatBuffer e );
public static native int LAPACKE_ssterf( int n, float[] d, float[] e );
public static native int LAPACKE_dsterf( int n, DoublePointer d, DoublePointer e );
public static native int LAPACKE_dsterf( int n, DoubleBuffer d, DoubleBuffer e );
public static native int LAPACKE_dsterf( int n, double[] d, double[] e );

public static native int LAPACKE_sstev( int matrix_layout, @Cast("char") byte jobz, int n, FloatPointer d,
                          FloatPointer e, FloatPointer z, int ldz );
public static native int LAPACKE_sstev( int matrix_layout, @Cast("char") byte jobz, int n, FloatBuffer d,
                          FloatBuffer e, FloatBuffer z, int ldz );
public static native int LAPACKE_sstev( int matrix_layout, @Cast("char") byte jobz, int n, float[] d,
                          float[] e, float[] z, int ldz );
public static native int LAPACKE_dstev( int matrix_layout, @Cast("char") byte jobz, int n, DoublePointer d,
                          DoublePointer e, DoublePointer z, int ldz );
public static native int LAPACKE_dstev( int matrix_layout, @Cast("char") byte jobz, int n, DoubleBuffer d,
                          DoubleBuffer e, DoubleBuffer z, int ldz );
public static native int LAPACKE_dstev( int matrix_layout, @Cast("char") byte jobz, int n, double[] d,
                          double[] e, double[] z, int ldz );

public static native int LAPACKE_sstevd( int matrix_layout, @Cast("char") byte jobz, int n, FloatPointer d,
                           FloatPointer e, FloatPointer z, int ldz );
public static native int LAPACKE_sstevd( int matrix_layout, @Cast("char") byte jobz, int n, FloatBuffer d,
                           FloatBuffer e, FloatBuffer z, int ldz );
public static native int LAPACKE_sstevd( int matrix_layout, @Cast("char") byte jobz, int n, float[] d,
                           float[] e, float[] z, int ldz );
public static native int LAPACKE_dstevd( int matrix_layout, @Cast("char") byte jobz, int n, DoublePointer d,
                           DoublePointer e, DoublePointer z, int ldz );
public static native int LAPACKE_dstevd( int matrix_layout, @Cast("char") byte jobz, int n, DoubleBuffer d,
                           DoubleBuffer e, DoubleBuffer z, int ldz );
public static native int LAPACKE_dstevd( int matrix_layout, @Cast("char") byte jobz, int n, double[] d,
                           double[] e, double[] z, int ldz );

public static native int LAPACKE_sstevr( int matrix_layout, @Cast("char") byte jobz, @Cast("char") byte range,
                           int n, FloatPointer d, FloatPointer e, float vl, float vu,
                           int il, int iu, float abstol,
                           IntPointer m, FloatPointer w, FloatPointer z, int ldz,
                           IntPointer isuppz );
public static native int LAPACKE_sstevr( int matrix_layout, @Cast("char") byte jobz, @Cast("char") byte range,
                           int n, FloatBuffer d, FloatBuffer e, float vl, float vu,
                           int il, int iu, float abstol,
                           IntBuffer m, FloatBuffer w, FloatBuffer z, int ldz,
                           IntBuffer isuppz );
public static native int LAPACKE_sstevr( int matrix_layout, @Cast("char") byte jobz, @Cast("char") byte range,
                           int n, float[] d, float[] e, float vl, float vu,
                           int il, int iu, float abstol,
                           int[] m, float[] w, float[] z, int ldz,
                           int[] isuppz );
public static native int LAPACKE_dstevr( int matrix_layout, @Cast("char") byte jobz, @Cast("char") byte range,
                           int n, DoublePointer d, DoublePointer e, double vl,
                           double vu, int il, int iu,
                           double abstol, IntPointer m, DoublePointer w, DoublePointer z,
                           int ldz, IntPointer isuppz );
public static native int LAPACKE_dstevr( int matrix_layout, @Cast("char") byte jobz, @Cast("char") byte range,
                           int n, DoubleBuffer d, DoubleBuffer e, double vl,
                           double vu, int il, int iu,
                           double abstol, IntBuffer m, DoubleBuffer w, DoubleBuffer z,
                           int ldz, IntBuffer isuppz );
public static native int LAPACKE_dstevr( int matrix_layout, @Cast("char") byte jobz, @Cast("char") byte range,
                           int n, double[] d, double[] e, double vl,
                           double vu, int il, int iu,
                           double abstol, int[] m, double[] w, double[] z,
                           int ldz, int[] isuppz );

public static native int LAPACKE_sstevx( int matrix_layout, @Cast("char") byte jobz, @Cast("char") byte range,
                           int n, FloatPointer d, FloatPointer e, float vl, float vu,
                           int il, int iu, float abstol,
                           IntPointer m, FloatPointer w, FloatPointer z, int ldz,
                           IntPointer ifail );
public static native int LAPACKE_sstevx( int matrix_layout, @Cast("char") byte jobz, @Cast("char") byte range,
                           int n, FloatBuffer d, FloatBuffer e, float vl, float vu,
                           int il, int iu, float abstol,
                           IntBuffer m, FloatBuffer w, FloatBuffer z, int ldz,
                           IntBuffer ifail );
public static native int LAPACKE_sstevx( int matrix_layout, @Cast("char") byte jobz, @Cast("char") byte range,
                           int n, float[] d, float[] e, float vl, float vu,
                           int il, int iu, float abstol,
                           int[] m, float[] w, float[] z, int ldz,
                           int[] ifail );
public static native int LAPACKE_dstevx( int matrix_layout, @Cast("char") byte jobz, @Cast("char") byte range,
                           int n, DoublePointer d, DoublePointer e, double vl,
                           double vu, int il, int iu,
                           double abstol, IntPointer m, DoublePointer w, DoublePointer z,
                           int ldz, IntPointer ifail );
public static native int LAPACKE_dstevx( int matrix_layout, @Cast("char") byte jobz, @Cast("char") byte range,
                           int n, DoubleBuffer d, DoubleBuffer e, double vl,
                           double vu, int il, int iu,
                           double abstol, IntBuffer m, DoubleBuffer w, DoubleBuffer z,
                           int ldz, IntBuffer ifail );
public static native int LAPACKE_dstevx( int matrix_layout, @Cast("char") byte jobz, @Cast("char") byte range,
                           int n, double[] d, double[] e, double vl,
                           double vu, int il, int iu,
                           double abstol, int[] m, double[] w, double[] z,
                           int ldz, int[] ifail );

public static native int LAPACKE_ssycon( int matrix_layout, @Cast("char") byte uplo, int n,
                           @Const FloatPointer a, int lda,
                           @Const IntPointer ipiv, float anorm, FloatPointer rcond );
public static native int LAPACKE_ssycon( int matrix_layout, @Cast("char") byte uplo, int n,
                           @Const FloatBuffer a, int lda,
                           @Const IntBuffer ipiv, float anorm, FloatBuffer rcond );
public static native int LAPACKE_ssycon( int matrix_layout, @Cast("char") byte uplo, int n,
                           @Const float[] a, int lda,
                           @Const int[] ipiv, float anorm, float[] rcond );
public static native int LAPACKE_dsycon( int matrix_layout, @Cast("char") byte uplo, int n,
                           @Const DoublePointer a, int lda,
                           @Const IntPointer ipiv, double anorm,
                           DoublePointer rcond );
public static native int LAPACKE_dsycon( int matrix_layout, @Cast("char") byte uplo, int n,
                           @Const DoubleBuffer a, int lda,
                           @Const IntBuffer ipiv, double anorm,
                           DoubleBuffer rcond );
public static native int LAPACKE_dsycon( int matrix_layout, @Cast("char") byte uplo, int n,
                           @Const double[] a, int lda,
                           @Const int[] ipiv, double anorm,
                           double[] rcond );
public static native int LAPACKE_csycon( int matrix_layout, @Cast("char") byte uplo, int n,
                           @Cast("const lapack_complex_float*") FloatPointer a, int lda,
                           @Const IntPointer ipiv, float anorm, FloatPointer rcond );
public static native int LAPACKE_csycon( int matrix_layout, @Cast("char") byte uplo, int n,
                           @Cast("const lapack_complex_float*") FloatBuffer a, int lda,
                           @Const IntBuffer ipiv, float anorm, FloatBuffer rcond );
public static native int LAPACKE_csycon( int matrix_layout, @Cast("char") byte uplo, int n,
                           @Cast("const lapack_complex_float*") float[] a, int lda,
                           @Const int[] ipiv, float anorm, float[] rcond );
public static native int LAPACKE_zsycon( int matrix_layout, @Cast("char") byte uplo, int n,
                           @Cast("const lapack_complex_double*") DoublePointer a, int lda,
                           @Const IntPointer ipiv, double anorm,
                           DoublePointer rcond );
public static native int LAPACKE_zsycon( int matrix_layout, @Cast("char") byte uplo, int n,
                           @Cast("const lapack_complex_double*") DoubleBuffer a, int lda,
                           @Const IntBuffer ipiv, double anorm,
                           DoubleBuffer rcond );
public static native int LAPACKE_zsycon( int matrix_layout, @Cast("char") byte uplo, int n,
                           @Cast("const lapack_complex_double*") double[] a, int lda,
                           @Const int[] ipiv, double anorm,
                           double[] rcond );

public static native int LAPACKE_ssyequb( int matrix_layout, @Cast("char") byte uplo, int n,
                            @Const FloatPointer a, int lda, FloatPointer s,
                            FloatPointer scond, FloatPointer amax );
public static native int LAPACKE_ssyequb( int matrix_layout, @Cast("char") byte uplo, int n,
                            @Const FloatBuffer a, int lda, FloatBuffer s,
                            FloatBuffer scond, FloatBuffer amax );
public static native int LAPACKE_ssyequb( int matrix_layout, @Cast("char") byte uplo, int n,
                            @Const float[] a, int lda, float[] s,
                            float[] scond, float[] amax );
public static native int LAPACKE_dsyequb( int matrix_layout, @Cast("char") byte uplo, int n,
                            @Const DoublePointer a, int lda, DoublePointer s,
                            DoublePointer scond, DoublePointer amax );
public static native int LAPACKE_dsyequb( int matrix_layout, @Cast("char") byte uplo, int n,
                            @Const DoubleBuffer a, int lda, DoubleBuffer s,
                            DoubleBuffer scond, DoubleBuffer amax );
public static native int LAPACKE_dsyequb( int matrix_layout, @Cast("char") byte uplo, int n,
                            @Const double[] a, int lda, double[] s,
                            double[] scond, double[] amax );
public static native int LAPACKE_csyequb( int matrix_layout, @Cast("char") byte uplo, int n,
                            @Cast("const lapack_complex_float*") FloatPointer a, int lda,
                            FloatPointer s, FloatPointer scond, FloatPointer amax );
public static native int LAPACKE_csyequb( int matrix_layout, @Cast("char") byte uplo, int n,
                            @Cast("const lapack_complex_float*") FloatBuffer a, int lda,
                            FloatBuffer s, FloatBuffer scond, FloatBuffer amax );
public static native int LAPACKE_csyequb( int matrix_layout, @Cast("char") byte uplo, int n,
                            @Cast("const lapack_complex_float*") float[] a, int lda,
                            float[] s, float[] scond, float[] amax );
public static native int LAPACKE_zsyequb( int matrix_layout, @Cast("char") byte uplo, int n,
                            @Cast("const lapack_complex_double*") DoublePointer a, int lda,
                            DoublePointer s, DoublePointer scond, DoublePointer amax );
public static native int LAPACKE_zsyequb( int matrix_layout, @Cast("char") byte uplo, int n,
                            @Cast("const lapack_complex_double*") DoubleBuffer a, int lda,
                            DoubleBuffer s, DoubleBuffer scond, DoubleBuffer amax );
public static native int LAPACKE_zsyequb( int matrix_layout, @Cast("char") byte uplo, int n,
                            @Cast("const lapack_complex_double*") double[] a, int lda,
                            double[] s, double[] scond, double[] amax );

public static native int LAPACKE_ssyev( int matrix_layout, @Cast("char") byte jobz, @Cast("char") byte uplo, int n,
                          FloatPointer a, int lda, FloatPointer w );
public static native int LAPACKE_ssyev( int matrix_layout, @Cast("char") byte jobz, @Cast("char") byte uplo, int n,
                          FloatBuffer a, int lda, FloatBuffer w );
public static native int LAPACKE_ssyev( int matrix_layout, @Cast("char") byte jobz, @Cast("char") byte uplo, int n,
                          float[] a, int lda, float[] w );
public static native int LAPACKE_dsyev( int matrix_layout, @Cast("char") byte jobz, @Cast("char") byte uplo, int n,
                          DoublePointer a, int lda, DoublePointer w );
public static native int LAPACKE_dsyev( int matrix_layout, @Cast("char") byte jobz, @Cast("char") byte uplo, int n,
                          DoubleBuffer a, int lda, DoubleBuffer w );
public static native int LAPACKE_dsyev( int matrix_layout, @Cast("char") byte jobz, @Cast("char") byte uplo, int n,
                          double[] a, int lda, double[] w );

public static native int LAPACKE_ssyevd( int matrix_layout, @Cast("char") byte jobz, @Cast("char") byte uplo, int n,
                           FloatPointer a, int lda, FloatPointer w );
public static native int LAPACKE_ssyevd( int matrix_layout, @Cast("char") byte jobz, @Cast("char") byte uplo, int n,
                           FloatBuffer a, int lda, FloatBuffer w );
public static native int LAPACKE_ssyevd( int matrix_layout, @Cast("char") byte jobz, @Cast("char") byte uplo, int n,
                           float[] a, int lda, float[] w );
public static native int LAPACKE_dsyevd( int matrix_layout, @Cast("char") byte jobz, @Cast("char") byte uplo, int n,
                           DoublePointer a, int lda, DoublePointer w );
public static native int LAPACKE_dsyevd( int matrix_layout, @Cast("char") byte jobz, @Cast("char") byte uplo, int n,
                           DoubleBuffer a, int lda, DoubleBuffer w );
public static native int LAPACKE_dsyevd( int matrix_layout, @Cast("char") byte jobz, @Cast("char") byte uplo, int n,
                           double[] a, int lda, double[] w );

public static native int LAPACKE_ssyevr( int matrix_layout, @Cast("char") byte jobz, @Cast("char") byte range, @Cast("char") byte uplo,
                           int n, FloatPointer a, int lda, float vl,
                           float vu, int il, int iu, float abstol,
                           IntPointer m, FloatPointer w, FloatPointer z, int ldz,
                           IntPointer isuppz );
public static native int LAPACKE_ssyevr( int matrix_layout, @Cast("char") byte jobz, @Cast("char") byte range, @Cast("char") byte uplo,
                           int n, FloatBuffer a, int lda, float vl,
                           float vu, int il, int iu, float abstol,
                           IntBuffer m, FloatBuffer w, FloatBuffer z, int ldz,
                           IntBuffer isuppz );
public static native int LAPACKE_ssyevr( int matrix_layout, @Cast("char") byte jobz, @Cast("char") byte range, @Cast("char") byte uplo,
                           int n, float[] a, int lda, float vl,
                           float vu, int il, int iu, float abstol,
                           int[] m, float[] w, float[] z, int ldz,
                           int[] isuppz );
public static native int LAPACKE_dsyevr( int matrix_layout, @Cast("char") byte jobz, @Cast("char") byte range, @Cast("char") byte uplo,
                           int n, DoublePointer a, int lda, double vl,
                           double vu, int il, int iu,
                           double abstol, IntPointer m, DoublePointer w, DoublePointer z,
                           int ldz, IntPointer isuppz );
public static native int LAPACKE_dsyevr( int matrix_layout, @Cast("char") byte jobz, @Cast("char") byte range, @Cast("char") byte uplo,
                           int n, DoubleBuffer a, int lda, double vl,
                           double vu, int il, int iu,
                           double abstol, IntBuffer m, DoubleBuffer w, DoubleBuffer z,
                           int ldz, IntBuffer isuppz );
public static native int LAPACKE_dsyevr( int matrix_layout, @Cast("char") byte jobz, @Cast("char") byte range, @Cast("char") byte uplo,
                           int n, double[] a, int lda, double vl,
                           double vu, int il, int iu,
                           double abstol, int[] m, double[] w, double[] z,
                           int ldz, int[] isuppz );

public static native int LAPACKE_ssyevx( int matrix_layout, @Cast("char") byte jobz, @Cast("char") byte range, @Cast("char") byte uplo,
                           int n, FloatPointer a, int lda, float vl,
                           float vu, int il, int iu, float abstol,
                           IntPointer m, FloatPointer w, FloatPointer z, int ldz,
                           IntPointer ifail );
public static native int LAPACKE_ssyevx( int matrix_layout, @Cast("char") byte jobz, @Cast("char") byte range, @Cast("char") byte uplo,
                           int n, FloatBuffer a, int lda, float vl,
                           float vu, int il, int iu, float abstol,
                           IntBuffer m, FloatBuffer w, FloatBuffer z, int ldz,
                           IntBuffer ifail );
public static native int LAPACKE_ssyevx( int matrix_layout, @Cast("char") byte jobz, @Cast("char") byte range, @Cast("char") byte uplo,
                           int n, float[] a, int lda, float vl,
                           float vu, int il, int iu, float abstol,
                           int[] m, float[] w, float[] z, int ldz,
                           int[] ifail );
public static native int LAPACKE_dsyevx( int matrix_layout, @Cast("char") byte jobz, @Cast("char") byte range, @Cast("char") byte uplo,
                           int n, DoublePointer a, int lda, double vl,
                           double vu, int il, int iu,
                           double abstol, IntPointer m, DoublePointer w, DoublePointer z,
                           int ldz, IntPointer ifail );
public static native int LAPACKE_dsyevx( int matrix_layout, @Cast("char") byte jobz, @Cast("char") byte range, @Cast("char") byte uplo,
                           int n, DoubleBuffer a, int lda, double vl,
                           double vu, int il, int iu,
                           double abstol, IntBuffer m, DoubleBuffer w, DoubleBuffer z,
                           int ldz, IntBuffer ifail );
public static native int LAPACKE_dsyevx( int matrix_layout, @Cast("char") byte jobz, @Cast("char") byte range, @Cast("char") byte uplo,
                           int n, double[] a, int lda, double vl,
                           double vu, int il, int iu,
                           double abstol, int[] m, double[] w, double[] z,
                           int ldz, int[] ifail );

public static native int LAPACKE_ssygst( int matrix_layout, int itype, @Cast("char") byte uplo,
                           int n, FloatPointer a, int lda,
                           @Const FloatPointer b, int ldb );
public static native int LAPACKE_ssygst( int matrix_layout, int itype, @Cast("char") byte uplo,
                           int n, FloatBuffer a, int lda,
                           @Const FloatBuffer b, int ldb );
public static native int LAPACKE_ssygst( int matrix_layout, int itype, @Cast("char") byte uplo,
                           int n, float[] a, int lda,
                           @Const float[] b, int ldb );
public static native int LAPACKE_dsygst( int matrix_layout, int itype, @Cast("char") byte uplo,
                           int n, DoublePointer a, int lda,
                           @Const DoublePointer b, int ldb );
public static native int LAPACKE_dsygst( int matrix_layout, int itype, @Cast("char") byte uplo,
                           int n, DoubleBuffer a, int lda,
                           @Const DoubleBuffer b, int ldb );
public static native int LAPACKE_dsygst( int matrix_layout, int itype, @Cast("char") byte uplo,
                           int n, double[] a, int lda,
                           @Const double[] b, int ldb );

public static native int LAPACKE_ssygv( int matrix_layout, int itype, @Cast("char") byte jobz,
                          @Cast("char") byte uplo, int n, FloatPointer a, int lda,
                          FloatPointer b, int ldb, FloatPointer w );
public static native int LAPACKE_ssygv( int matrix_layout, int itype, @Cast("char") byte jobz,
                          @Cast("char") byte uplo, int n, FloatBuffer a, int lda,
                          FloatBuffer b, int ldb, FloatBuffer w );
public static native int LAPACKE_ssygv( int matrix_layout, int itype, @Cast("char") byte jobz,
                          @Cast("char") byte uplo, int n, float[] a, int lda,
                          float[] b, int ldb, float[] w );
public static native int LAPACKE_dsygv( int matrix_layout, int itype, @Cast("char") byte jobz,
                          @Cast("char") byte uplo, int n, DoublePointer a, int lda,
                          DoublePointer b, int ldb, DoublePointer w );
public static native int LAPACKE_dsygv( int matrix_layout, int itype, @Cast("char") byte jobz,
                          @Cast("char") byte uplo, int n, DoubleBuffer a, int lda,
                          DoubleBuffer b, int ldb, DoubleBuffer w );
public static native int LAPACKE_dsygv( int matrix_layout, int itype, @Cast("char") byte jobz,
                          @Cast("char") byte uplo, int n, double[] a, int lda,
                          double[] b, int ldb, double[] w );

public static native int LAPACKE_ssygvd( int matrix_layout, int itype, @Cast("char") byte jobz,
                           @Cast("char") byte uplo, int n, FloatPointer a, int lda,
                           FloatPointer b, int ldb, FloatPointer w );
public static native int LAPACKE_ssygvd( int matrix_layout, int itype, @Cast("char") byte jobz,
                           @Cast("char") byte uplo, int n, FloatBuffer a, int lda,
                           FloatBuffer b, int ldb, FloatBuffer w );
public static native int LAPACKE_ssygvd( int matrix_layout, int itype, @Cast("char") byte jobz,
                           @Cast("char") byte uplo, int n, float[] a, int lda,
                           float[] b, int ldb, float[] w );
public static native int LAPACKE_dsygvd( int matrix_layout, int itype, @Cast("char") byte jobz,
                           @Cast("char") byte uplo, int n, DoublePointer a, int lda,
                           DoublePointer b, int ldb, DoublePointer w );
public static native int LAPACKE_dsygvd( int matrix_layout, int itype, @Cast("char") byte jobz,
                           @Cast("char") byte uplo, int n, DoubleBuffer a, int lda,
                           DoubleBuffer b, int ldb, DoubleBuffer w );
public static native int LAPACKE_dsygvd( int matrix_layout, int itype, @Cast("char") byte jobz,
                           @Cast("char") byte uplo, int n, double[] a, int lda,
                           double[] b, int ldb, double[] w );

public static native int LAPACKE_ssygvx( int matrix_layout, int itype, @Cast("char") byte jobz,
                           @Cast("char") byte range, @Cast("char") byte uplo, int n, FloatPointer a,
                           int lda, FloatPointer b, int ldb, float vl,
                           float vu, int il, int iu, float abstol,
                           IntPointer m, FloatPointer w, FloatPointer z, int ldz,
                           IntPointer ifail );
public static native int LAPACKE_ssygvx( int matrix_layout, int itype, @Cast("char") byte jobz,
                           @Cast("char") byte range, @Cast("char") byte uplo, int n, FloatBuffer a,
                           int lda, FloatBuffer b, int ldb, float vl,
                           float vu, int il, int iu, float abstol,
                           IntBuffer m, FloatBuffer w, FloatBuffer z, int ldz,
                           IntBuffer ifail );
public static native int LAPACKE_ssygvx( int matrix_layout, int itype, @Cast("char") byte jobz,
                           @Cast("char") byte range, @Cast("char") byte uplo, int n, float[] a,
                           int lda, float[] b, int ldb, float vl,
                           float vu, int il, int iu, float abstol,
                           int[] m, float[] w, float[] z, int ldz,
                           int[] ifail );
public static native int LAPACKE_dsygvx( int matrix_layout, int itype, @Cast("char") byte jobz,
                           @Cast("char") byte range, @Cast("char") byte uplo, int n, DoublePointer a,
                           int lda, DoublePointer b, int ldb, double vl,
                           double vu, int il, int iu,
                           double abstol, IntPointer m, DoublePointer w, DoublePointer z,
                           int ldz, IntPointer ifail );
public static native int LAPACKE_dsygvx( int matrix_layout, int itype, @Cast("char") byte jobz,
                           @Cast("char") byte range, @Cast("char") byte uplo, int n, DoubleBuffer a,
                           int lda, DoubleBuffer b, int ldb, double vl,
                           double vu, int il, int iu,
                           double abstol, IntBuffer m, DoubleBuffer w, DoubleBuffer z,
                           int ldz, IntBuffer ifail );
public static native int LAPACKE_dsygvx( int matrix_layout, int itype, @Cast("char") byte jobz,
                           @Cast("char") byte range, @Cast("char") byte uplo, int n, double[] a,
                           int lda, double[] b, int ldb, double vl,
                           double vu, int il, int iu,
                           double abstol, int[] m, double[] w, double[] z,
                           int ldz, int[] ifail );

public static native int LAPACKE_ssyrfs( int matrix_layout, @Cast("char") byte uplo, int n,
                           int nrhs, @Const FloatPointer a, int lda,
                           @Const FloatPointer af, int ldaf,
                           @Const IntPointer ipiv, @Const FloatPointer b,
                           int ldb, FloatPointer x, int ldx,
                           FloatPointer ferr, FloatPointer berr );
public static native int LAPACKE_ssyrfs( int matrix_layout, @Cast("char") byte uplo, int n,
                           int nrhs, @Const FloatBuffer a, int lda,
                           @Const FloatBuffer af, int ldaf,
                           @Const IntBuffer ipiv, @Const FloatBuffer b,
                           int ldb, FloatBuffer x, int ldx,
                           FloatBuffer ferr, FloatBuffer berr );
public static native int LAPACKE_ssyrfs( int matrix_layout, @Cast("char") byte uplo, int n,
                           int nrhs, @Const float[] a, int lda,
                           @Const float[] af, int ldaf,
                           @Const int[] ipiv, @Const float[] b,
                           int ldb, float[] x, int ldx,
                           float[] ferr, float[] berr );
public static native int LAPACKE_dsyrfs( int matrix_layout, @Cast("char") byte uplo, int n,
                           int nrhs, @Const DoublePointer a, int lda,
                           @Const DoublePointer af, int ldaf,
                           @Const IntPointer ipiv, @Const DoublePointer b,
                           int ldb, DoublePointer x, int ldx,
                           DoublePointer ferr, DoublePointer berr );
public static native int LAPACKE_dsyrfs( int matrix_layout, @Cast("char") byte uplo, int n,
                           int nrhs, @Const DoubleBuffer a, int lda,
                           @Const DoubleBuffer af, int ldaf,
                           @Const IntBuffer ipiv, @Const DoubleBuffer b,
                           int ldb, DoubleBuffer x, int ldx,
                           DoubleBuffer ferr, DoubleBuffer berr );
public static native int LAPACKE_dsyrfs( int matrix_layout, @Cast("char") byte uplo, int n,
                           int nrhs, @Const double[] a, int lda,
                           @Const double[] af, int ldaf,
                           @Const int[] ipiv, @Const double[] b,
                           int ldb, double[] x, int ldx,
                           double[] ferr, double[] berr );
public static native int LAPACKE_csyrfs( int matrix_layout, @Cast("char") byte uplo, int n,
                           int nrhs, @Cast("const lapack_complex_float*") FloatPointer a,
                           int lda, @Cast("const lapack_complex_float*") FloatPointer af,
                           int ldaf, @Const IntPointer ipiv,
                           @Cast("const lapack_complex_float*") FloatPointer b, int ldb,
                           @Cast("lapack_complex_float*") FloatPointer x, int ldx, FloatPointer ferr,
                           FloatPointer berr );
public static native int LAPACKE_csyrfs( int matrix_layout, @Cast("char") byte uplo, int n,
                           int nrhs, @Cast("const lapack_complex_float*") FloatBuffer a,
                           int lda, @Cast("const lapack_complex_float*") FloatBuffer af,
                           int ldaf, @Const IntBuffer ipiv,
                           @Cast("const lapack_complex_float*") FloatBuffer b, int ldb,
                           @Cast("lapack_complex_float*") FloatBuffer x, int ldx, FloatBuffer ferr,
                           FloatBuffer berr );
public static native int LAPACKE_csyrfs( int matrix_layout, @Cast("char") byte uplo, int n,
                           int nrhs, @Cast("const lapack_complex_float*") float[] a,
                           int lda, @Cast("const lapack_complex_float*") float[] af,
                           int ldaf, @Const int[] ipiv,
                           @Cast("const lapack_complex_float*") float[] b, int ldb,
                           @Cast("lapack_complex_float*") float[] x, int ldx, float[] ferr,
                           float[] berr );
public static native int LAPACKE_zsyrfs( int matrix_layout, @Cast("char") byte uplo, int n,
                           int nrhs, @Cast("const lapack_complex_double*") DoublePointer a,
                           int lda, @Cast("const lapack_complex_double*") DoublePointer af,
                           int ldaf, @Const IntPointer ipiv,
                           @Cast("const lapack_complex_double*") DoublePointer b, int ldb,
                           @Cast("lapack_complex_double*") DoublePointer x, int ldx,
                           DoublePointer ferr, DoublePointer berr );
public static native int LAPACKE_zsyrfs( int matrix_layout, @Cast("char") byte uplo, int n,
                           int nrhs, @Cast("const lapack_complex_double*") DoubleBuffer a,
                           int lda, @Cast("const lapack_complex_double*") DoubleBuffer af,
                           int ldaf, @Const IntBuffer ipiv,
                           @Cast("const lapack_complex_double*") DoubleBuffer b, int ldb,
                           @Cast("lapack_complex_double*") DoubleBuffer x, int ldx,
                           DoubleBuffer ferr, DoubleBuffer berr );
public static native int LAPACKE_zsyrfs( int matrix_layout, @Cast("char") byte uplo, int n,
                           int nrhs, @Cast("const lapack_complex_double*") double[] a,
                           int lda, @Cast("const lapack_complex_double*") double[] af,
                           int ldaf, @Const int[] ipiv,
                           @Cast("const lapack_complex_double*") double[] b, int ldb,
                           @Cast("lapack_complex_double*") double[] x, int ldx,
                           double[] ferr, double[] berr );






public static native int LAPACKE_ssysv( int matrix_layout, @Cast("char") byte uplo, int n,
                          int nrhs, FloatPointer a, int lda,
                          IntPointer ipiv, FloatPointer b, int ldb );
public static native int LAPACKE_ssysv( int matrix_layout, @Cast("char") byte uplo, int n,
                          int nrhs, FloatBuffer a, int lda,
                          IntBuffer ipiv, FloatBuffer b, int ldb );
public static native int LAPACKE_ssysv( int matrix_layout, @Cast("char") byte uplo, int n,
                          int nrhs, float[] a, int lda,
                          int[] ipiv, float[] b, int ldb );
public static native int LAPACKE_dsysv( int matrix_layout, @Cast("char") byte uplo, int n,
                          int nrhs, DoublePointer a, int lda,
                          IntPointer ipiv, DoublePointer b, int ldb );
public static native int LAPACKE_dsysv( int matrix_layout, @Cast("char") byte uplo, int n,
                          int nrhs, DoubleBuffer a, int lda,
                          IntBuffer ipiv, DoubleBuffer b, int ldb );
public static native int LAPACKE_dsysv( int matrix_layout, @Cast("char") byte uplo, int n,
                          int nrhs, double[] a, int lda,
                          int[] ipiv, double[] b, int ldb );
public static native int LAPACKE_csysv( int matrix_layout, @Cast("char") byte uplo, int n,
                          int nrhs, @Cast("lapack_complex_float*") FloatPointer a,
                          int lda, IntPointer ipiv,
                          @Cast("lapack_complex_float*") FloatPointer b, int ldb );
public static native int LAPACKE_csysv( int matrix_layout, @Cast("char") byte uplo, int n,
                          int nrhs, @Cast("lapack_complex_float*") FloatBuffer a,
                          int lda, IntBuffer ipiv,
                          @Cast("lapack_complex_float*") FloatBuffer b, int ldb );
public static native int LAPACKE_csysv( int matrix_layout, @Cast("char") byte uplo, int n,
                          int nrhs, @Cast("lapack_complex_float*") float[] a,
                          int lda, int[] ipiv,
                          @Cast("lapack_complex_float*") float[] b, int ldb );
public static native int LAPACKE_zsysv( int matrix_layout, @Cast("char") byte uplo, int n,
                          int nrhs, @Cast("lapack_complex_double*") DoublePointer a,
                          int lda, IntPointer ipiv,
                          @Cast("lapack_complex_double*") DoublePointer b, int ldb );
public static native int LAPACKE_zsysv( int matrix_layout, @Cast("char") byte uplo, int n,
                          int nrhs, @Cast("lapack_complex_double*") DoubleBuffer a,
                          int lda, IntBuffer ipiv,
                          @Cast("lapack_complex_double*") DoubleBuffer b, int ldb );
public static native int LAPACKE_zsysv( int matrix_layout, @Cast("char") byte uplo, int n,
                          int nrhs, @Cast("lapack_complex_double*") double[] a,
                          int lda, int[] ipiv,
                          @Cast("lapack_complex_double*") double[] b, int ldb );

public static native int LAPACKE_ssysvx( int matrix_layout, @Cast("char") byte fact, @Cast("char") byte uplo, int n,
                           int nrhs, @Const FloatPointer a, int lda,
                           FloatPointer af, int ldaf, IntPointer ipiv,
                           @Const FloatPointer b, int ldb, FloatPointer x,
                           int ldx, FloatPointer rcond, FloatPointer ferr,
                           FloatPointer berr );
public static native int LAPACKE_ssysvx( int matrix_layout, @Cast("char") byte fact, @Cast("char") byte uplo, int n,
                           int nrhs, @Const FloatBuffer a, int lda,
                           FloatBuffer af, int ldaf, IntBuffer ipiv,
                           @Const FloatBuffer b, int ldb, FloatBuffer x,
                           int ldx, FloatBuffer rcond, FloatBuffer ferr,
                           FloatBuffer berr );
public static native int LAPACKE_ssysvx( int matrix_layout, @Cast("char") byte fact, @Cast("char") byte uplo, int n,
                           int nrhs, @Const float[] a, int lda,
                           float[] af, int ldaf, int[] ipiv,
                           @Const float[] b, int ldb, float[] x,
                           int ldx, float[] rcond, float[] ferr,
                           float[] berr );
public static native int LAPACKE_dsysvx( int matrix_layout, @Cast("char") byte fact, @Cast("char") byte uplo, int n,
                           int nrhs, @Const DoublePointer a, int lda,
                           DoublePointer af, int ldaf, IntPointer ipiv,
                           @Const DoublePointer b, int ldb, DoublePointer x,
                           int ldx, DoublePointer rcond, DoublePointer ferr,
                           DoublePointer berr );
public static native int LAPACKE_dsysvx( int matrix_layout, @Cast("char") byte fact, @Cast("char") byte uplo, int n,
                           int nrhs, @Const DoubleBuffer a, int lda,
                           DoubleBuffer af, int ldaf, IntBuffer ipiv,
                           @Const DoubleBuffer b, int ldb, DoubleBuffer x,
                           int ldx, DoubleBuffer rcond, DoubleBuffer ferr,
                           DoubleBuffer berr );
public static native int LAPACKE_dsysvx( int matrix_layout, @Cast("char") byte fact, @Cast("char") byte uplo, int n,
                           int nrhs, @Const double[] a, int lda,
                           double[] af, int ldaf, int[] ipiv,
                           @Const double[] b, int ldb, double[] x,
                           int ldx, double[] rcond, double[] ferr,
                           double[] berr );
public static native int LAPACKE_csysvx( int matrix_layout, @Cast("char") byte fact, @Cast("char") byte uplo, int n,
                           int nrhs, @Cast("const lapack_complex_float*") FloatPointer a,
                           int lda, @Cast("lapack_complex_float*") FloatPointer af,
                           int ldaf, IntPointer ipiv,
                           @Cast("const lapack_complex_float*") FloatPointer b, int ldb,
                           @Cast("lapack_complex_float*") FloatPointer x, int ldx,
                           FloatPointer rcond, FloatPointer ferr, FloatPointer berr );
public static native int LAPACKE_csysvx( int matrix_layout, @Cast("char") byte fact, @Cast("char") byte uplo, int n,
                           int nrhs, @Cast("const lapack_complex_float*") FloatBuffer a,
                           int lda, @Cast("lapack_complex_float*") FloatBuffer af,
                           int ldaf, IntBuffer ipiv,
                           @Cast("const lapack_complex_float*") FloatBuffer b, int ldb,
                           @Cast("lapack_complex_float*") FloatBuffer x, int ldx,
                           FloatBuffer rcond, FloatBuffer ferr, FloatBuffer berr );
public static native int LAPACKE_csysvx( int matrix_layout, @Cast("char") byte fact, @Cast("char") byte uplo, int n,
                           int nrhs, @Cast("const lapack_complex_float*") float[] a,
                           int lda, @Cast("lapack_complex_float*") float[] af,
                           int ldaf, int[] ipiv,
                           @Cast("const lapack_complex_float*") float[] b, int ldb,
                           @Cast("lapack_complex_float*") float[] x, int ldx,
                           float[] rcond, float[] ferr, float[] berr );
public static native int LAPACKE_zsysvx( int matrix_layout, @Cast("char") byte fact, @Cast("char") byte uplo, int n,
                           int nrhs, @Cast("const lapack_complex_double*") DoublePointer a,
                           int lda, @Cast("lapack_complex_double*") DoublePointer af,
                           int ldaf, IntPointer ipiv,
                           @Cast("const lapack_complex_double*") DoublePointer b, int ldb,
                           @Cast("lapack_complex_double*") DoublePointer x, int ldx,
                           DoublePointer rcond, DoublePointer ferr, DoublePointer berr );
public static native int LAPACKE_zsysvx( int matrix_layout, @Cast("char") byte fact, @Cast("char") byte uplo, int n,
                           int nrhs, @Cast("const lapack_complex_double*") DoubleBuffer a,
                           int lda, @Cast("lapack_complex_double*") DoubleBuffer af,
                           int ldaf, IntBuffer ipiv,
                           @Cast("const lapack_complex_double*") DoubleBuffer b, int ldb,
                           @Cast("lapack_complex_double*") DoubleBuffer x, int ldx,
                           DoubleBuffer rcond, DoubleBuffer ferr, DoubleBuffer berr );
public static native int LAPACKE_zsysvx( int matrix_layout, @Cast("char") byte fact, @Cast("char") byte uplo, int n,
                           int nrhs, @Cast("const lapack_complex_double*") double[] a,
                           int lda, @Cast("lapack_complex_double*") double[] af,
                           int ldaf, int[] ipiv,
                           @Cast("const lapack_complex_double*") double[] b, int ldb,
                           @Cast("lapack_complex_double*") double[] x, int ldx,
                           double[] rcond, double[] ferr, double[] berr );






public static native int LAPACKE_ssytrd( int matrix_layout, @Cast("char") byte uplo, int n, FloatPointer a,
                           int lda, FloatPointer d, FloatPointer e, FloatPointer tau );
public static native int LAPACKE_ssytrd( int matrix_layout, @Cast("char") byte uplo, int n, FloatBuffer a,
                           int lda, FloatBuffer d, FloatBuffer e, FloatBuffer tau );
public static native int LAPACKE_ssytrd( int matrix_layout, @Cast("char") byte uplo, int n, float[] a,
                           int lda, float[] d, float[] e, float[] tau );
public static native int LAPACKE_dsytrd( int matrix_layout, @Cast("char") byte uplo, int n, DoublePointer a,
                           int lda, DoublePointer d, DoublePointer e, DoublePointer tau );
public static native int LAPACKE_dsytrd( int matrix_layout, @Cast("char") byte uplo, int n, DoubleBuffer a,
                           int lda, DoubleBuffer d, DoubleBuffer e, DoubleBuffer tau );
public static native int LAPACKE_dsytrd( int matrix_layout, @Cast("char") byte uplo, int n, double[] a,
                           int lda, double[] d, double[] e, double[] tau );

public static native int LAPACKE_ssytrf( int matrix_layout, @Cast("char") byte uplo, int n, FloatPointer a,
                           int lda, IntPointer ipiv );
public static native int LAPACKE_ssytrf( int matrix_layout, @Cast("char") byte uplo, int n, FloatBuffer a,
                           int lda, IntBuffer ipiv );
public static native int LAPACKE_ssytrf( int matrix_layout, @Cast("char") byte uplo, int n, float[] a,
                           int lda, int[] ipiv );
public static native int LAPACKE_dsytrf( int matrix_layout, @Cast("char") byte uplo, int n, DoublePointer a,
                           int lda, IntPointer ipiv );
public static native int LAPACKE_dsytrf( int matrix_layout, @Cast("char") byte uplo, int n, DoubleBuffer a,
                           int lda, IntBuffer ipiv );
public static native int LAPACKE_dsytrf( int matrix_layout, @Cast("char") byte uplo, int n, double[] a,
                           int lda, int[] ipiv );
public static native int LAPACKE_csytrf( int matrix_layout, @Cast("char") byte uplo, int n,
                           @Cast("lapack_complex_float*") FloatPointer a, int lda,
                           IntPointer ipiv );
public static native int LAPACKE_csytrf( int matrix_layout, @Cast("char") byte uplo, int n,
                           @Cast("lapack_complex_float*") FloatBuffer a, int lda,
                           IntBuffer ipiv );
public static native int LAPACKE_csytrf( int matrix_layout, @Cast("char") byte uplo, int n,
                           @Cast("lapack_complex_float*") float[] a, int lda,
                           int[] ipiv );
public static native int LAPACKE_zsytrf( int matrix_layout, @Cast("char") byte uplo, int n,
                           @Cast("lapack_complex_double*") DoublePointer a, int lda,
                           IntPointer ipiv );
public static native int LAPACKE_zsytrf( int matrix_layout, @Cast("char") byte uplo, int n,
                           @Cast("lapack_complex_double*") DoubleBuffer a, int lda,
                           IntBuffer ipiv );
public static native int LAPACKE_zsytrf( int matrix_layout, @Cast("char") byte uplo, int n,
                           @Cast("lapack_complex_double*") double[] a, int lda,
                           int[] ipiv );

public static native int LAPACKE_ssytri( int matrix_layout, @Cast("char") byte uplo, int n, FloatPointer a,
                           int lda, @Const IntPointer ipiv );
public static native int LAPACKE_ssytri( int matrix_layout, @Cast("char") byte uplo, int n, FloatBuffer a,
                           int lda, @Const IntBuffer ipiv );
public static native int LAPACKE_ssytri( int matrix_layout, @Cast("char") byte uplo, int n, float[] a,
                           int lda, @Const int[] ipiv );
public static native int LAPACKE_dsytri( int matrix_layout, @Cast("char") byte uplo, int n, DoublePointer a,
                           int lda, @Const IntPointer ipiv );
public static native int LAPACKE_dsytri( int matrix_layout, @Cast("char") byte uplo, int n, DoubleBuffer a,
                           int lda, @Const IntBuffer ipiv );
public static native int LAPACKE_dsytri( int matrix_layout, @Cast("char") byte uplo, int n, double[] a,
                           int lda, @Const int[] ipiv );
public static native int LAPACKE_csytri( int matrix_layout, @Cast("char") byte uplo, int n,
                           @Cast("lapack_complex_float*") FloatPointer a, int lda,
                           @Const IntPointer ipiv );
public static native int LAPACKE_csytri( int matrix_layout, @Cast("char") byte uplo, int n,
                           @Cast("lapack_complex_float*") FloatBuffer a, int lda,
                           @Const IntBuffer ipiv );
public static native int LAPACKE_csytri( int matrix_layout, @Cast("char") byte uplo, int n,
                           @Cast("lapack_complex_float*") float[] a, int lda,
                           @Const int[] ipiv );
public static native int LAPACKE_zsytri( int matrix_layout, @Cast("char") byte uplo, int n,
                           @Cast("lapack_complex_double*") DoublePointer a, int lda,
                           @Const IntPointer ipiv );
public static native int LAPACKE_zsytri( int matrix_layout, @Cast("char") byte uplo, int n,
                           @Cast("lapack_complex_double*") DoubleBuffer a, int lda,
                           @Const IntBuffer ipiv );
public static native int LAPACKE_zsytri( int matrix_layout, @Cast("char") byte uplo, int n,
                           @Cast("lapack_complex_double*") double[] a, int lda,
                           @Const int[] ipiv );

public static native int LAPACKE_ssytrs( int matrix_layout, @Cast("char") byte uplo, int n,
                           int nrhs, @Const FloatPointer a, int lda,
                           @Const IntPointer ipiv, FloatPointer b, int ldb );
public static native int LAPACKE_ssytrs( int matrix_layout, @Cast("char") byte uplo, int n,
                           int nrhs, @Const FloatBuffer a, int lda,
                           @Const IntBuffer ipiv, FloatBuffer b, int ldb );
public static native int LAPACKE_ssytrs( int matrix_layout, @Cast("char") byte uplo, int n,
                           int nrhs, @Const float[] a, int lda,
                           @Const int[] ipiv, float[] b, int ldb );
public static native int LAPACKE_dsytrs( int matrix_layout, @Cast("char") byte uplo, int n,
                           int nrhs, @Const DoublePointer a, int lda,
                           @Const IntPointer ipiv, DoublePointer b, int ldb );
public static native int LAPACKE_dsytrs( int matrix_layout, @Cast("char") byte uplo, int n,
                           int nrhs, @Const DoubleBuffer a, int lda,
                           @Const IntBuffer ipiv, DoubleBuffer b, int ldb );
public static native int LAPACKE_dsytrs( int matrix_layout, @Cast("char") byte uplo, int n,
                           int nrhs, @Const double[] a, int lda,
                           @Const int[] ipiv, double[] b, int ldb );
public static native int LAPACKE_csytrs( int matrix_layout, @Cast("char") byte uplo, int n,
                           int nrhs, @Cast("const lapack_complex_float*") FloatPointer a,
                           int lda, @Const IntPointer ipiv,
                           @Cast("lapack_complex_float*") FloatPointer b, int ldb );
public static native int LAPACKE_csytrs( int matrix_layout, @Cast("char") byte uplo, int n,
                           int nrhs, @Cast("const lapack_complex_float*") FloatBuffer a,
                           int lda, @Const IntBuffer ipiv,
                           @Cast("lapack_complex_float*") FloatBuffer b, int ldb );
public static native int LAPACKE_csytrs( int matrix_layout, @Cast("char") byte uplo, int n,
                           int nrhs, @Cast("const lapack_complex_float*") float[] a,
                           int lda, @Const int[] ipiv,
                           @Cast("lapack_complex_float*") float[] b, int ldb );
public static native int LAPACKE_zsytrs( int matrix_layout, @Cast("char") byte uplo, int n,
                           int nrhs, @Cast("const lapack_complex_double*") DoublePointer a,
                           int lda, @Const IntPointer ipiv,
                           @Cast("lapack_complex_double*") DoublePointer b, int ldb );
public static native int LAPACKE_zsytrs( int matrix_layout, @Cast("char") byte uplo, int n,
                           int nrhs, @Cast("const lapack_complex_double*") DoubleBuffer a,
                           int lda, @Const IntBuffer ipiv,
                           @Cast("lapack_complex_double*") DoubleBuffer b, int ldb );
public static native int LAPACKE_zsytrs( int matrix_layout, @Cast("char") byte uplo, int n,
                           int nrhs, @Cast("const lapack_complex_double*") double[] a,
                           int lda, @Const int[] ipiv,
                           @Cast("lapack_complex_double*") double[] b, int ldb );

public static native int LAPACKE_stbcon( int matrix_layout, @Cast("char") byte norm, @Cast("char") byte uplo, @Cast("char") byte diag,
                           int n, int kd, @Const FloatPointer ab,
                           int ldab, FloatPointer rcond );
public static native int LAPACKE_stbcon( int matrix_layout, @Cast("char") byte norm, @Cast("char") byte uplo, @Cast("char") byte diag,
                           int n, int kd, @Const FloatBuffer ab,
                           int ldab, FloatBuffer rcond );
public static native int LAPACKE_stbcon( int matrix_layout, @Cast("char") byte norm, @Cast("char") byte uplo, @Cast("char") byte diag,
                           int n, int kd, @Const float[] ab,
                           int ldab, float[] rcond );
public static native int LAPACKE_dtbcon( int matrix_layout, @Cast("char") byte norm, @Cast("char") byte uplo, @Cast("char") byte diag,
                           int n, int kd, @Const DoublePointer ab,
                           int ldab, DoublePointer rcond );
public static native int LAPACKE_dtbcon( int matrix_layout, @Cast("char") byte norm, @Cast("char") byte uplo, @Cast("char") byte diag,
                           int n, int kd, @Const DoubleBuffer ab,
                           int ldab, DoubleBuffer rcond );
public static native int LAPACKE_dtbcon( int matrix_layout, @Cast("char") byte norm, @Cast("char") byte uplo, @Cast("char") byte diag,
                           int n, int kd, @Const double[] ab,
                           int ldab, double[] rcond );
public static native int LAPACKE_ctbcon( int matrix_layout, @Cast("char") byte norm, @Cast("char") byte uplo, @Cast("char") byte diag,
                           int n, int kd,
                           @Cast("const lapack_complex_float*") FloatPointer ab, int ldab,
                           FloatPointer rcond );
public static native int LAPACKE_ctbcon( int matrix_layout, @Cast("char") byte norm, @Cast("char") byte uplo, @Cast("char") byte diag,
                           int n, int kd,
                           @Cast("const lapack_complex_float*") FloatBuffer ab, int ldab,
                           FloatBuffer rcond );
public static native int LAPACKE_ctbcon( int matrix_layout, @Cast("char") byte norm, @Cast("char") byte uplo, @Cast("char") byte diag,
                           int n, int kd,
                           @Cast("const lapack_complex_float*") float[] ab, int ldab,
                           float[] rcond );
public static native int LAPACKE_ztbcon( int matrix_layout, @Cast("char") byte norm, @Cast("char") byte uplo, @Cast("char") byte diag,
                           int n, int kd,
                           @Cast("const lapack_complex_double*") DoublePointer ab, int ldab,
                           DoublePointer rcond );
public static native int LAPACKE_ztbcon( int matrix_layout, @Cast("char") byte norm, @Cast("char") byte uplo, @Cast("char") byte diag,
                           int n, int kd,
                           @Cast("const lapack_complex_double*") DoubleBuffer ab, int ldab,
                           DoubleBuffer rcond );
public static native int LAPACKE_ztbcon( int matrix_layout, @Cast("char") byte norm, @Cast("char") byte uplo, @Cast("char") byte diag,
                           int n, int kd,
                           @Cast("const lapack_complex_double*") double[] ab, int ldab,
                           double[] rcond );

public static native int LAPACKE_stbrfs( int matrix_layout, @Cast("char") byte uplo, @Cast("char") byte trans, @Cast("char") byte diag,
                           int n, int kd, int nrhs,
                           @Const FloatPointer ab, int ldab, @Const FloatPointer b,
                           int ldb, @Const FloatPointer x, int ldx,
                           FloatPointer ferr, FloatPointer berr );
public static native int LAPACKE_stbrfs( int matrix_layout, @Cast("char") byte uplo, @Cast("char") byte trans, @Cast("char") byte diag,
                           int n, int kd, int nrhs,
                           @Const FloatBuffer ab, int ldab, @Const FloatBuffer b,
                           int ldb, @Const FloatBuffer x, int ldx,
                           FloatBuffer ferr, FloatBuffer berr );
public static native int LAPACKE_stbrfs( int matrix_layout, @Cast("char") byte uplo, @Cast("char") byte trans, @Cast("char") byte diag,
                           int n, int kd, int nrhs,
                           @Const float[] ab, int ldab, @Const float[] b,
                           int ldb, @Const float[] x, int ldx,
                           float[] ferr, float[] berr );
public static native int LAPACKE_dtbrfs( int matrix_layout, @Cast("char") byte uplo, @Cast("char") byte trans, @Cast("char") byte diag,
                           int n, int kd, int nrhs,
                           @Const DoublePointer ab, int ldab, @Const DoublePointer b,
                           int ldb, @Const DoublePointer x, int ldx,
                           DoublePointer ferr, DoublePointer berr );
public static native int LAPACKE_dtbrfs( int matrix_layout, @Cast("char") byte uplo, @Cast("char") byte trans, @Cast("char") byte diag,
                           int n, int kd, int nrhs,
                           @Const DoubleBuffer ab, int ldab, @Const DoubleBuffer b,
                           int ldb, @Const DoubleBuffer x, int ldx,
                           DoubleBuffer ferr, DoubleBuffer berr );
public static native int LAPACKE_dtbrfs( int matrix_layout, @Cast("char") byte uplo, @Cast("char") byte trans, @Cast("char") byte diag,
                           int n, int kd, int nrhs,
                           @Const double[] ab, int ldab, @Const double[] b,
                           int ldb, @Const double[] x, int ldx,
                           double[] ferr, double[] berr );
public static native int LAPACKE_ctbrfs( int matrix_layout, @Cast("char") byte uplo, @Cast("char") byte trans, @Cast("char") byte diag,
                           int n, int kd, int nrhs,
                           @Cast("const lapack_complex_float*") FloatPointer ab, int ldab,
                           @Cast("const lapack_complex_float*") FloatPointer b, int ldb,
                           @Cast("const lapack_complex_float*") FloatPointer x, int ldx,
                           FloatPointer ferr, FloatPointer berr );
public static native int LAPACKE_ctbrfs( int matrix_layout, @Cast("char") byte uplo, @Cast("char") byte trans, @Cast("char") byte diag,
                           int n, int kd, int nrhs,
                           @Cast("const lapack_complex_float*") FloatBuffer ab, int ldab,
                           @Cast("const lapack_complex_float*") FloatBuffer b, int ldb,
                           @Cast("const lapack_complex_float*") FloatBuffer x, int ldx,
                           FloatBuffer ferr, FloatBuffer berr );
public static native int LAPACKE_ctbrfs( int matrix_layout, @Cast("char") byte uplo, @Cast("char") byte trans, @Cast("char") byte diag,
                           int n, int kd, int nrhs,
                           @Cast("const lapack_complex_float*") float[] ab, int ldab,
                           @Cast("const lapack_complex_float*") float[] b, int ldb,
                           @Cast("const lapack_complex_float*") float[] x, int ldx,
                           float[] ferr, float[] berr );
public static native int LAPACKE_ztbrfs( int matrix_layout, @Cast("char") byte uplo, @Cast("char") byte trans, @Cast("char") byte diag,
                           int n, int kd, int nrhs,
                           @Cast("const lapack_complex_double*") DoublePointer ab, int ldab,
                           @Cast("const lapack_complex_double*") DoublePointer b, int ldb,
                           @Cast("const lapack_complex_double*") DoublePointer x, int ldx,
                           DoublePointer ferr, DoublePointer berr );
public static native int LAPACKE_ztbrfs( int matrix_layout, @Cast("char") byte uplo, @Cast("char") byte trans, @Cast("char") byte diag,
                           int n, int kd, int nrhs,
                           @Cast("const lapack_complex_double*") DoubleBuffer ab, int ldab,
                           @Cast("const lapack_complex_double*") DoubleBuffer b, int ldb,
                           @Cast("const lapack_complex_double*") DoubleBuffer x, int ldx,
                           DoubleBuffer ferr, DoubleBuffer berr );
public static native int LAPACKE_ztbrfs( int matrix_layout, @Cast("char") byte uplo, @Cast("char") byte trans, @Cast("char") byte diag,
                           int n, int kd, int nrhs,
                           @Cast("const lapack_complex_double*") double[] ab, int ldab,
                           @Cast("const lapack_complex_double*") double[] b, int ldb,
                           @Cast("const lapack_complex_double*") double[] x, int ldx,
                           double[] ferr, double[] berr );

public static native int LAPACKE_stbtrs( int matrix_layout, @Cast("char") byte uplo, @Cast("char") byte trans, @Cast("char") byte diag,
                           int n, int kd, int nrhs,
                           @Const FloatPointer ab, int ldab, FloatPointer b,
                           int ldb );
public static native int LAPACKE_stbtrs( int matrix_layout, @Cast("char") byte uplo, @Cast("char") byte trans, @Cast("char") byte diag,
                           int n, int kd, int nrhs,
                           @Const FloatBuffer ab, int ldab, FloatBuffer b,
                           int ldb );
public static native int LAPACKE_stbtrs( int matrix_layout, @Cast("char") byte uplo, @Cast("char") byte trans, @Cast("char") byte diag,
                           int n, int kd, int nrhs,
                           @Const float[] ab, int ldab, float[] b,
                           int ldb );
public static native int LAPACKE_dtbtrs( int matrix_layout, @Cast("char") byte uplo, @Cast("char") byte trans, @Cast("char") byte diag,
                           int n, int kd, int nrhs,
                           @Const DoublePointer ab, int ldab, DoublePointer b,
                           int ldb );
public static native int LAPACKE_dtbtrs( int matrix_layout, @Cast("char") byte uplo, @Cast("char") byte trans, @Cast("char") byte diag,
                           int n, int kd, int nrhs,
                           @Const DoubleBuffer ab, int ldab, DoubleBuffer b,
                           int ldb );
public static native int LAPACKE_dtbtrs( int matrix_layout, @Cast("char") byte uplo, @Cast("char") byte trans, @Cast("char") byte diag,
                           int n, int kd, int nrhs,
                           @Const double[] ab, int ldab, double[] b,
                           int ldb );
public static native int LAPACKE_ctbtrs( int matrix_layout, @Cast("char") byte uplo, @Cast("char") byte trans, @Cast("char") byte diag,
                           int n, int kd, int nrhs,
                           @Cast("const lapack_complex_float*") FloatPointer ab, int ldab,
                           @Cast("lapack_complex_float*") FloatPointer b, int ldb );
public static native int LAPACKE_ctbtrs( int matrix_layout, @Cast("char") byte uplo, @Cast("char") byte trans, @Cast("char") byte diag,
                           int n, int kd, int nrhs,
                           @Cast("const lapack_complex_float*") FloatBuffer ab, int ldab,
                           @Cast("lapack_complex_float*") FloatBuffer b, int ldb );
public static native int LAPACKE_ctbtrs( int matrix_layout, @Cast("char") byte uplo, @Cast("char") byte trans, @Cast("char") byte diag,
                           int n, int kd, int nrhs,
                           @Cast("const lapack_complex_float*") float[] ab, int ldab,
                           @Cast("lapack_complex_float*") float[] b, int ldb );
public static native int LAPACKE_ztbtrs( int matrix_layout, @Cast("char") byte uplo, @Cast("char") byte trans, @Cast("char") byte diag,
                           int n, int kd, int nrhs,
                           @Cast("const lapack_complex_double*") DoublePointer ab, int ldab,
                           @Cast("lapack_complex_double*") DoublePointer b, int ldb );
public static native int LAPACKE_ztbtrs( int matrix_layout, @Cast("char") byte uplo, @Cast("char") byte trans, @Cast("char") byte diag,
                           int n, int kd, int nrhs,
                           @Cast("const lapack_complex_double*") DoubleBuffer ab, int ldab,
                           @Cast("lapack_complex_double*") DoubleBuffer b, int ldb );
public static native int LAPACKE_ztbtrs( int matrix_layout, @Cast("char") byte uplo, @Cast("char") byte trans, @Cast("char") byte diag,
                           int n, int kd, int nrhs,
                           @Cast("const lapack_complex_double*") double[] ab, int ldab,
                           @Cast("lapack_complex_double*") double[] b, int ldb );

public static native int LAPACKE_stfsm( int matrix_layout, @Cast("char") byte transr, @Cast("char") byte side, @Cast("char") byte uplo,
                          @Cast("char") byte trans, @Cast("char") byte diag, int m, int n,
                          float alpha, @Const FloatPointer a, FloatPointer b,
                          int ldb );
public static native int LAPACKE_stfsm( int matrix_layout, @Cast("char") byte transr, @Cast("char") byte side, @Cast("char") byte uplo,
                          @Cast("char") byte trans, @Cast("char") byte diag, int m, int n,
                          float alpha, @Const FloatBuffer a, FloatBuffer b,
                          int ldb );
public static native int LAPACKE_stfsm( int matrix_layout, @Cast("char") byte transr, @Cast("char") byte side, @Cast("char") byte uplo,
                          @Cast("char") byte trans, @Cast("char") byte diag, int m, int n,
                          float alpha, @Const float[] a, float[] b,
                          int ldb );
public static native int LAPACKE_dtfsm( int matrix_layout, @Cast("char") byte transr, @Cast("char") byte side, @Cast("char") byte uplo,
                          @Cast("char") byte trans, @Cast("char") byte diag, int m, int n,
                          double alpha, @Const DoublePointer a, DoublePointer b,
                          int ldb );
public static native int LAPACKE_dtfsm( int matrix_layout, @Cast("char") byte transr, @Cast("char") byte side, @Cast("char") byte uplo,
                          @Cast("char") byte trans, @Cast("char") byte diag, int m, int n,
                          double alpha, @Const DoubleBuffer a, DoubleBuffer b,
                          int ldb );
public static native int LAPACKE_dtfsm( int matrix_layout, @Cast("char") byte transr, @Cast("char") byte side, @Cast("char") byte uplo,
                          @Cast("char") byte trans, @Cast("char") byte diag, int m, int n,
                          double alpha, @Const double[] a, double[] b,
                          int ldb );
public static native int LAPACKE_ctfsm( int matrix_layout, @Cast("char") byte transr, @Cast("char") byte side, @Cast("char") byte uplo,
                          @Cast("char") byte trans, @Cast("char") byte diag, int m, int n,
                          @ByVal @Cast("lapack_complex_float*") FloatPointer alpha,
                          @Cast("const lapack_complex_float*") FloatPointer a,
                          @Cast("lapack_complex_float*") FloatPointer b, int ldb );
public static native int LAPACKE_ctfsm( int matrix_layout, @Cast("char") byte transr, @Cast("char") byte side, @Cast("char") byte uplo,
                          @Cast("char") byte trans, @Cast("char") byte diag, int m, int n,
                          @ByVal @Cast("lapack_complex_float*") FloatBuffer alpha,
                          @Cast("const lapack_complex_float*") FloatBuffer a,
                          @Cast("lapack_complex_float*") FloatBuffer b, int ldb );
public static native int LAPACKE_ctfsm( int matrix_layout, @Cast("char") byte transr, @Cast("char") byte side, @Cast("char") byte uplo,
                          @Cast("char") byte trans, @Cast("char") byte diag, int m, int n,
                          @ByVal @Cast("lapack_complex_float*") float[] alpha,
                          @Cast("const lapack_complex_float*") float[] a,
                          @Cast("lapack_complex_float*") float[] b, int ldb );
public static native int LAPACKE_ztfsm( int matrix_layout, @Cast("char") byte transr, @Cast("char") byte side, @Cast("char") byte uplo,
                          @Cast("char") byte trans, @Cast("char") byte diag, int m, int n,
                          @ByVal @Cast("lapack_complex_double*") DoublePointer alpha,
                          @Cast("const lapack_complex_double*") DoublePointer a,
                          @Cast("lapack_complex_double*") DoublePointer b, int ldb );
public static native int LAPACKE_ztfsm( int matrix_layout, @Cast("char") byte transr, @Cast("char") byte side, @Cast("char") byte uplo,
                          @Cast("char") byte trans, @Cast("char") byte diag, int m, int n,
                          @ByVal @Cast("lapack_complex_double*") DoubleBuffer alpha,
                          @Cast("const lapack_complex_double*") DoubleBuffer a,
                          @Cast("lapack_complex_double*") DoubleBuffer b, int ldb );
public static native int LAPACKE_ztfsm( int matrix_layout, @Cast("char") byte transr, @Cast("char") byte side, @Cast("char") byte uplo,
                          @Cast("char") byte trans, @Cast("char") byte diag, int m, int n,
                          @ByVal @Cast("lapack_complex_double*") double[] alpha,
                          @Cast("const lapack_complex_double*") double[] a,
                          @Cast("lapack_complex_double*") double[] b, int ldb );

public static native int LAPACKE_stftri( int matrix_layout, @Cast("char") byte transr, @Cast("char") byte uplo, @Cast("char") byte diag,
                           int n, FloatPointer a );
public static native int LAPACKE_stftri( int matrix_layout, @Cast("char") byte transr, @Cast("char") byte uplo, @Cast("char") byte diag,
                           int n, FloatBuffer a );
public static native int LAPACKE_stftri( int matrix_layout, @Cast("char") byte transr, @Cast("char") byte uplo, @Cast("char") byte diag,
                           int n, float[] a );
public static native int LAPACKE_dtftri( int matrix_layout, @Cast("char") byte transr, @Cast("char") byte uplo, @Cast("char") byte diag,
                           int n, DoublePointer a );
public static native int LAPACKE_dtftri( int matrix_layout, @Cast("char") byte transr, @Cast("char") byte uplo, @Cast("char") byte diag,
                           int n, DoubleBuffer a );
public static native int LAPACKE_dtftri( int matrix_layout, @Cast("char") byte transr, @Cast("char") byte uplo, @Cast("char") byte diag,
                           int n, double[] a );
public static native int LAPACKE_ctftri( int matrix_layout, @Cast("char") byte transr, @Cast("char") byte uplo, @Cast("char") byte diag,
                           int n, @Cast("lapack_complex_float*") FloatPointer a );
public static native int LAPACKE_ctftri( int matrix_layout, @Cast("char") byte transr, @Cast("char") byte uplo, @Cast("char") byte diag,
                           int n, @Cast("lapack_complex_float*") FloatBuffer a );
public static native int LAPACKE_ctftri( int matrix_layout, @Cast("char") byte transr, @Cast("char") byte uplo, @Cast("char") byte diag,
                           int n, @Cast("lapack_complex_float*") float[] a );
public static native int LAPACKE_ztftri( int matrix_layout, @Cast("char") byte transr, @Cast("char") byte uplo, @Cast("char") byte diag,
                           int n, @Cast("lapack_complex_double*") DoublePointer a );
public static native int LAPACKE_ztftri( int matrix_layout, @Cast("char") byte transr, @Cast("char") byte uplo, @Cast("char") byte diag,
                           int n, @Cast("lapack_complex_double*") DoubleBuffer a );
public static native int LAPACKE_ztftri( int matrix_layout, @Cast("char") byte transr, @Cast("char") byte uplo, @Cast("char") byte diag,
                           int n, @Cast("lapack_complex_double*") double[] a );

public static native int LAPACKE_stfttp( int matrix_layout, @Cast("char") byte transr, @Cast("char") byte uplo,
                           int n, @Const FloatPointer arf, FloatPointer ap );
public static native int LAPACKE_stfttp( int matrix_layout, @Cast("char") byte transr, @Cast("char") byte uplo,
                           int n, @Const FloatBuffer arf, FloatBuffer ap );
public static native int LAPACKE_stfttp( int matrix_layout, @Cast("char") byte transr, @Cast("char") byte uplo,
                           int n, @Const float[] arf, float[] ap );
public static native int LAPACKE_dtfttp( int matrix_layout, @Cast("char") byte transr, @Cast("char") byte uplo,
                           int n, @Const DoublePointer arf, DoublePointer ap );
public static native int LAPACKE_dtfttp( int matrix_layout, @Cast("char") byte transr, @Cast("char") byte uplo,
                           int n, @Const DoubleBuffer arf, DoubleBuffer ap );
public static native int LAPACKE_dtfttp( int matrix_layout, @Cast("char") byte transr, @Cast("char") byte uplo,
                           int n, @Const double[] arf, double[] ap );
public static native int LAPACKE_ctfttp( int matrix_layout, @Cast("char") byte transr, @Cast("char") byte uplo,
                           int n, @Cast("const lapack_complex_float*") FloatPointer arf,
                           @Cast("lapack_complex_float*") FloatPointer ap );
public static native int LAPACKE_ctfttp( int matrix_layout, @Cast("char") byte transr, @Cast("char") byte uplo,
                           int n, @Cast("const lapack_complex_float*") FloatBuffer arf,
                           @Cast("lapack_complex_float*") FloatBuffer ap );
public static native int LAPACKE_ctfttp( int matrix_layout, @Cast("char") byte transr, @Cast("char") byte uplo,
                           int n, @Cast("const lapack_complex_float*") float[] arf,
                           @Cast("lapack_complex_float*") float[] ap );
public static native int LAPACKE_ztfttp( int matrix_layout, @Cast("char") byte transr, @Cast("char") byte uplo,
                           int n, @Cast("const lapack_complex_double*") DoublePointer arf,
                           @Cast("lapack_complex_double*") DoublePointer ap );
public static native int LAPACKE_ztfttp( int matrix_layout, @Cast("char") byte transr, @Cast("char") byte uplo,
                           int n, @Cast("const lapack_complex_double*") DoubleBuffer arf,
                           @Cast("lapack_complex_double*") DoubleBuffer ap );
public static native int LAPACKE_ztfttp( int matrix_layout, @Cast("char") byte transr, @Cast("char") byte uplo,
                           int n, @Cast("const lapack_complex_double*") double[] arf,
                           @Cast("lapack_complex_double*") double[] ap );

public static native int LAPACKE_stfttr( int matrix_layout, @Cast("char") byte transr, @Cast("char") byte uplo,
                           int n, @Const FloatPointer arf, FloatPointer a,
                           int lda );
public static native int LAPACKE_stfttr( int matrix_layout, @Cast("char") byte transr, @Cast("char") byte uplo,
                           int n, @Const FloatBuffer arf, FloatBuffer a,
                           int lda );
public static native int LAPACKE_stfttr( int matrix_layout, @Cast("char") byte transr, @Cast("char") byte uplo,
                           int n, @Const float[] arf, float[] a,
                           int lda );
public static native int LAPACKE_dtfttr( int matrix_layout, @Cast("char") byte transr, @Cast("char") byte uplo,
                           int n, @Const DoublePointer arf, DoublePointer a,
                           int lda );
public static native int LAPACKE_dtfttr( int matrix_layout, @Cast("char") byte transr, @Cast("char") byte uplo,
                           int n, @Const DoubleBuffer arf, DoubleBuffer a,
                           int lda );
public static native int LAPACKE_dtfttr( int matrix_layout, @Cast("char") byte transr, @Cast("char") byte uplo,
                           int n, @Const double[] arf, double[] a,
                           int lda );
public static native int LAPACKE_ctfttr( int matrix_layout, @Cast("char") byte transr, @Cast("char") byte uplo,
                           int n, @Cast("const lapack_complex_float*") FloatPointer arf,
                           @Cast("lapack_complex_float*") FloatPointer a, int lda );
public static native int LAPACKE_ctfttr( int matrix_layout, @Cast("char") byte transr, @Cast("char") byte uplo,
                           int n, @Cast("const lapack_complex_float*") FloatBuffer arf,
                           @Cast("lapack_complex_float*") FloatBuffer a, int lda );
public static native int LAPACKE_ctfttr( int matrix_layout, @Cast("char") byte transr, @Cast("char") byte uplo,
                           int n, @Cast("const lapack_complex_float*") float[] arf,
                           @Cast("lapack_complex_float*") float[] a, int lda );
public static native int LAPACKE_ztfttr( int matrix_layout, @Cast("char") byte transr, @Cast("char") byte uplo,
                           int n, @Cast("const lapack_complex_double*") DoublePointer arf,
                           @Cast("lapack_complex_double*") DoublePointer a, int lda );
public static native int LAPACKE_ztfttr( int matrix_layout, @Cast("char") byte transr, @Cast("char") byte uplo,
                           int n, @Cast("const lapack_complex_double*") DoubleBuffer arf,
                           @Cast("lapack_complex_double*") DoubleBuffer a, int lda );
public static native int LAPACKE_ztfttr( int matrix_layout, @Cast("char") byte transr, @Cast("char") byte uplo,
                           int n, @Cast("const lapack_complex_double*") double[] arf,
                           @Cast("lapack_complex_double*") double[] a, int lda );

public static native int LAPACKE_stgevc( int matrix_layout, @Cast("char") byte side, @Cast("char") byte howmny,
                           @Const IntPointer select, int n,
                           @Const FloatPointer s, int lds, @Const FloatPointer p,
                           int ldp, FloatPointer vl, int ldvl,
                           FloatPointer vr, int ldvr, int mm,
                           IntPointer m );
public static native int LAPACKE_stgevc( int matrix_layout, @Cast("char") byte side, @Cast("char") byte howmny,
                           @Const IntBuffer select, int n,
                           @Const FloatBuffer s, int lds, @Const FloatBuffer p,
                           int ldp, FloatBuffer vl, int ldvl,
                           FloatBuffer vr, int ldvr, int mm,
                           IntBuffer m );
public static native int LAPACKE_stgevc( int matrix_layout, @Cast("char") byte side, @Cast("char") byte howmny,
                           @Const int[] select, int n,
                           @Const float[] s, int lds, @Const float[] p,
                           int ldp, float[] vl, int ldvl,
                           float[] vr, int ldvr, int mm,
                           int[] m );
public static native int LAPACKE_dtgevc( int matrix_layout, @Cast("char") byte side, @Cast("char") byte howmny,
                           @Const IntPointer select, int n,
                           @Const DoublePointer s, int lds, @Const DoublePointer p,
                           int ldp, DoublePointer vl, int ldvl,
                           DoublePointer vr, int ldvr, int mm,
                           IntPointer m );
public static native int LAPACKE_dtgevc( int matrix_layout, @Cast("char") byte side, @Cast("char") byte howmny,
                           @Const IntBuffer select, int n,
                           @Const DoubleBuffer s, int lds, @Const DoubleBuffer p,
                           int ldp, DoubleBuffer vl, int ldvl,
                           DoubleBuffer vr, int ldvr, int mm,
                           IntBuffer m );
public static native int LAPACKE_dtgevc( int matrix_layout, @Cast("char") byte side, @Cast("char") byte howmny,
                           @Const int[] select, int n,
                           @Const double[] s, int lds, @Const double[] p,
                           int ldp, double[] vl, int ldvl,
                           double[] vr, int ldvr, int mm,
                           int[] m );
public static native int LAPACKE_ctgevc( int matrix_layout, @Cast("char") byte side, @Cast("char") byte howmny,
                           @Const IntPointer select, int n,
                           @Cast("const lapack_complex_float*") FloatPointer s, int lds,
                           @Cast("const lapack_complex_float*") FloatPointer p, int ldp,
                           @Cast("lapack_complex_float*") FloatPointer vl, int ldvl,
                           @Cast("lapack_complex_float*") FloatPointer vr, int ldvr,
                           int mm, IntPointer m );
public static native int LAPACKE_ctgevc( int matrix_layout, @Cast("char") byte side, @Cast("char") byte howmny,
                           @Const IntBuffer select, int n,
                           @Cast("const lapack_complex_float*") FloatBuffer s, int lds,
                           @Cast("const lapack_complex_float*") FloatBuffer p, int ldp,
                           @Cast("lapack_complex_float*") FloatBuffer vl, int ldvl,
                           @Cast("lapack_complex_float*") FloatBuffer vr, int ldvr,
                           int mm, IntBuffer m );
public static native int LAPACKE_ctgevc( int matrix_layout, @Cast("char") byte side, @Cast("char") byte howmny,
                           @Const int[] select, int n,
                           @Cast("const lapack_complex_float*") float[] s, int lds,
                           @Cast("const lapack_complex_float*") float[] p, int ldp,
                           @Cast("lapack_complex_float*") float[] vl, int ldvl,
                           @Cast("lapack_complex_float*") float[] vr, int ldvr,
                           int mm, int[] m );
public static native int LAPACKE_ztgevc( int matrix_layout, @Cast("char") byte side, @Cast("char") byte howmny,
                           @Const IntPointer select, int n,
                           @Cast("const lapack_complex_double*") DoublePointer s, int lds,
                           @Cast("const lapack_complex_double*") DoublePointer p, int ldp,
                           @Cast("lapack_complex_double*") DoublePointer vl, int ldvl,
                           @Cast("lapack_complex_double*") DoublePointer vr, int ldvr,
                           int mm, IntPointer m );
public static native int LAPACKE_ztgevc( int matrix_layout, @Cast("char") byte side, @Cast("char") byte howmny,
                           @Const IntBuffer select, int n,
                           @Cast("const lapack_complex_double*") DoubleBuffer s, int lds,
                           @Cast("const lapack_complex_double*") DoubleBuffer p, int ldp,
                           @Cast("lapack_complex_double*") DoubleBuffer vl, int ldvl,
                           @Cast("lapack_complex_double*") DoubleBuffer vr, int ldvr,
                           int mm, IntBuffer m );
public static native int LAPACKE_ztgevc( int matrix_layout, @Cast("char") byte side, @Cast("char") byte howmny,
                           @Const int[] select, int n,
                           @Cast("const lapack_complex_double*") double[] s, int lds,
                           @Cast("const lapack_complex_double*") double[] p, int ldp,
                           @Cast("lapack_complex_double*") double[] vl, int ldvl,
                           @Cast("lapack_complex_double*") double[] vr, int ldvr,
                           int mm, int[] m );

public static native int LAPACKE_stgexc( int matrix_layout, int wantq,
                           int wantz, int n, FloatPointer a,
                           int lda, FloatPointer b, int ldb, FloatPointer q,
                           int ldq, FloatPointer z, int ldz,
                           IntPointer ifst, IntPointer ilst );
public static native int LAPACKE_stgexc( int matrix_layout, int wantq,
                           int wantz, int n, FloatBuffer a,
                           int lda, FloatBuffer b, int ldb, FloatBuffer q,
                           int ldq, FloatBuffer z, int ldz,
                           IntBuffer ifst, IntBuffer ilst );
public static native int LAPACKE_stgexc( int matrix_layout, int wantq,
                           int wantz, int n, float[] a,
                           int lda, float[] b, int ldb, float[] q,
                           int ldq, float[] z, int ldz,
                           int[] ifst, int[] ilst );
public static native int LAPACKE_dtgexc( int matrix_layout, int wantq,
                           int wantz, int n, DoublePointer a,
                           int lda, DoublePointer b, int ldb, DoublePointer q,
                           int ldq, DoublePointer z, int ldz,
                           IntPointer ifst, IntPointer ilst );
public static native int LAPACKE_dtgexc( int matrix_layout, int wantq,
                           int wantz, int n, DoubleBuffer a,
                           int lda, DoubleBuffer b, int ldb, DoubleBuffer q,
                           int ldq, DoubleBuffer z, int ldz,
                           IntBuffer ifst, IntBuffer ilst );
public static native int LAPACKE_dtgexc( int matrix_layout, int wantq,
                           int wantz, int n, double[] a,
                           int lda, double[] b, int ldb, double[] q,
                           int ldq, double[] z, int ldz,
                           int[] ifst, int[] ilst );
public static native int LAPACKE_ctgexc( int matrix_layout, int wantq,
                           int wantz, int n,
                           @Cast("lapack_complex_float*") FloatPointer a, int lda,
                           @Cast("lapack_complex_float*") FloatPointer b, int ldb,
                           @Cast("lapack_complex_float*") FloatPointer q, int ldq,
                           @Cast("lapack_complex_float*") FloatPointer z, int ldz,
                           int ifst, int ilst );
public static native int LAPACKE_ctgexc( int matrix_layout, int wantq,
                           int wantz, int n,
                           @Cast("lapack_complex_float*") FloatBuffer a, int lda,
                           @Cast("lapack_complex_float*") FloatBuffer b, int ldb,
                           @Cast("lapack_complex_float*") FloatBuffer q, int ldq,
                           @Cast("lapack_complex_float*") FloatBuffer z, int ldz,
                           int ifst, int ilst );
public static native int LAPACKE_ctgexc( int matrix_layout, int wantq,
                           int wantz, int n,
                           @Cast("lapack_complex_float*") float[] a, int lda,
                           @Cast("lapack_complex_float*") float[] b, int ldb,
                           @Cast("lapack_complex_float*") float[] q, int ldq,
                           @Cast("lapack_complex_float*") float[] z, int ldz,
                           int ifst, int ilst );
public static native int LAPACKE_ztgexc( int matrix_layout, int wantq,
                           int wantz, int n,
                           @Cast("lapack_complex_double*") DoublePointer a, int lda,
                           @Cast("lapack_complex_double*") DoublePointer b, int ldb,
                           @Cast("lapack_complex_double*") DoublePointer q, int ldq,
                           @Cast("lapack_complex_double*") DoublePointer z, int ldz,
                           int ifst, int ilst );
public static native int LAPACKE_ztgexc( int matrix_layout, int wantq,
                           int wantz, int n,
                           @Cast("lapack_complex_double*") DoubleBuffer a, int lda,
                           @Cast("lapack_complex_double*") DoubleBuffer b, int ldb,
                           @Cast("lapack_complex_double*") DoubleBuffer q, int ldq,
                           @Cast("lapack_complex_double*") DoubleBuffer z, int ldz,
                           int ifst, int ilst );
public static native int LAPACKE_ztgexc( int matrix_layout, int wantq,
                           int wantz, int n,
                           @Cast("lapack_complex_double*") double[] a, int lda,
                           @Cast("lapack_complex_double*") double[] b, int ldb,
                           @Cast("lapack_complex_double*") double[] q, int ldq,
                           @Cast("lapack_complex_double*") double[] z, int ldz,
                           int ifst, int ilst );

public static native int LAPACKE_stgsen( int matrix_layout, int ijob,
                           int wantq, int wantz,
                           @Const IntPointer select, int n, FloatPointer a,
                           int lda, FloatPointer b, int ldb,
                           FloatPointer alphar, FloatPointer alphai, FloatPointer beta, FloatPointer q,
                           int ldq, FloatPointer z, int ldz,
                           IntPointer m, FloatPointer pl, FloatPointer pr, FloatPointer dif );
public static native int LAPACKE_stgsen( int matrix_layout, int ijob,
                           int wantq, int wantz,
                           @Const IntBuffer select, int n, FloatBuffer a,
                           int lda, FloatBuffer b, int ldb,
                           FloatBuffer alphar, FloatBuffer alphai, FloatBuffer beta, FloatBuffer q,
                           int ldq, FloatBuffer z, int ldz,
                           IntBuffer m, FloatBuffer pl, FloatBuffer pr, FloatBuffer dif );
public static native int LAPACKE_stgsen( int matrix_layout, int ijob,
                           int wantq, int wantz,
                           @Const int[] select, int n, float[] a,
                           int lda, float[] b, int ldb,
                           float[] alphar, float[] alphai, float[] beta, float[] q,
                           int ldq, float[] z, int ldz,
                           int[] m, float[] pl, float[] pr, float[] dif );
public static native int LAPACKE_dtgsen( int matrix_layout, int ijob,
                           int wantq, int wantz,
                           @Const IntPointer select, int n,
                           DoublePointer a, int lda, DoublePointer b, int ldb,
                           DoublePointer alphar, DoublePointer alphai, DoublePointer beta,
                           DoublePointer q, int ldq, DoublePointer z, int ldz,
                           IntPointer m, DoublePointer pl, DoublePointer pr, DoublePointer dif );
public static native int LAPACKE_dtgsen( int matrix_layout, int ijob,
                           int wantq, int wantz,
                           @Const IntBuffer select, int n,
                           DoubleBuffer a, int lda, DoubleBuffer b, int ldb,
                           DoubleBuffer alphar, DoubleBuffer alphai, DoubleBuffer beta,
                           DoubleBuffer q, int ldq, DoubleBuffer z, int ldz,
                           IntBuffer m, DoubleBuffer pl, DoubleBuffer pr, DoubleBuffer dif );
public static native int LAPACKE_dtgsen( int matrix_layout, int ijob,
                           int wantq, int wantz,
                           @Const int[] select, int n,
                           double[] a, int lda, double[] b, int ldb,
                           double[] alphar, double[] alphai, double[] beta,
                           double[] q, int ldq, double[] z, int ldz,
                           int[] m, double[] pl, double[] pr, double[] dif );
public static native int LAPACKE_ctgsen( int matrix_layout, int ijob,
                           int wantq, int wantz,
                           @Const IntPointer select, int n,
                           @Cast("lapack_complex_float*") FloatPointer a, int lda,
                           @Cast("lapack_complex_float*") FloatPointer b, int ldb,
                           @Cast("lapack_complex_float*") FloatPointer alpha,
                           @Cast("lapack_complex_float*") FloatPointer beta, @Cast("lapack_complex_float*") FloatPointer q,
                           int ldq, @Cast("lapack_complex_float*") FloatPointer z,
                           int ldz, IntPointer m, FloatPointer pl, FloatPointer pr,
                           FloatPointer dif );
public static native int LAPACKE_ctgsen( int matrix_layout, int ijob,
                           int wantq, int wantz,
                           @Const IntBuffer select, int n,
                           @Cast("lapack_complex_float*") FloatBuffer a, int lda,
                           @Cast("lapack_complex_float*") FloatBuffer b, int ldb,
                           @Cast("lapack_complex_float*") FloatBuffer alpha,
                           @Cast("lapack_complex_float*") FloatBuffer beta, @Cast("lapack_complex_float*") FloatBuffer q,
                           int ldq, @Cast("lapack_complex_float*") FloatBuffer z,
                           int ldz, IntBuffer m, FloatBuffer pl, FloatBuffer pr,
                           FloatBuffer dif );
public static native int LAPACKE_ctgsen( int matrix_layout, int ijob,
                           int wantq, int wantz,
                           @Const int[] select, int n,
                           @Cast("lapack_complex_float*") float[] a, int lda,
                           @Cast("lapack_complex_float*") float[] b, int ldb,
                           @Cast("lapack_complex_float*") float[] alpha,
                           @Cast("lapack_complex_float*") float[] beta, @Cast("lapack_complex_float*") float[] q,
                           int ldq, @Cast("lapack_complex_float*") float[] z,
                           int ldz, int[] m, float[] pl, float[] pr,
                           float[] dif );
public static native int LAPACKE_ztgsen( int matrix_layout, int ijob,
                           int wantq, int wantz,
                           @Const IntPointer select, int n,
                           @Cast("lapack_complex_double*") DoublePointer a, int lda,
                           @Cast("lapack_complex_double*") DoublePointer b, int ldb,
                           @Cast("lapack_complex_double*") DoublePointer alpha,
                           @Cast("lapack_complex_double*") DoublePointer beta,
                           @Cast("lapack_complex_double*") DoublePointer q, int ldq,
                           @Cast("lapack_complex_double*") DoublePointer z, int ldz,
                           IntPointer m, DoublePointer pl, DoublePointer pr, DoublePointer dif );
public static native int LAPACKE_ztgsen( int matrix_layout, int ijob,
                           int wantq, int wantz,
                           @Const IntBuffer select, int n,
                           @Cast("lapack_complex_double*") DoubleBuffer a, int lda,
                           @Cast("lapack_complex_double*") DoubleBuffer b, int ldb,
                           @Cast("lapack_complex_double*") DoubleBuffer alpha,
                           @Cast("lapack_complex_double*") DoubleBuffer beta,
                           @Cast("lapack_complex_double*") DoubleBuffer q, int ldq,
                           @Cast("lapack_complex_double*") DoubleBuffer z, int ldz,
                           IntBuffer m, DoubleBuffer pl, DoubleBuffer pr, DoubleBuffer dif );
public static native int LAPACKE_ztgsen( int matrix_layout, int ijob,
                           int wantq, int wantz,
                           @Const int[] select, int n,
                           @Cast("lapack_complex_double*") double[] a, int lda,
                           @Cast("lapack_complex_double*") double[] b, int ldb,
                           @Cast("lapack_complex_double*") double[] alpha,
                           @Cast("lapack_complex_double*") double[] beta,
                           @Cast("lapack_complex_double*") double[] q, int ldq,
                           @Cast("lapack_complex_double*") double[] z, int ldz,
                           int[] m, double[] pl, double[] pr, double[] dif );

public static native int LAPACKE_stgsja( int matrix_layout, @Cast("char") byte jobu, @Cast("char") byte jobv, @Cast("char") byte jobq,
                           int m, int p, int n,
                           int k, int l, FloatPointer a, int lda,
                           FloatPointer b, int ldb, float tola, float tolb,
                           FloatPointer alpha, FloatPointer beta, FloatPointer u, int ldu,
                           FloatPointer v, int ldv, FloatPointer q, int ldq,
                           IntPointer ncycle );
public static native int LAPACKE_stgsja( int matrix_layout, @Cast("char") byte jobu, @Cast("char") byte jobv, @Cast("char") byte jobq,
                           int m, int p, int n,
                           int k, int l, FloatBuffer a, int lda,
                           FloatBuffer b, int ldb, float tola, float tolb,
                           FloatBuffer alpha, FloatBuffer beta, FloatBuffer u, int ldu,
                           FloatBuffer v, int ldv, FloatBuffer q, int ldq,
                           IntBuffer ncycle );
public static native int LAPACKE_stgsja( int matrix_layout, @Cast("char") byte jobu, @Cast("char") byte jobv, @Cast("char") byte jobq,
                           int m, int p, int n,
                           int k, int l, float[] a, int lda,
                           float[] b, int ldb, float tola, float tolb,
                           float[] alpha, float[] beta, float[] u, int ldu,
                           float[] v, int ldv, float[] q, int ldq,
                           int[] ncycle );
public static native int LAPACKE_dtgsja( int matrix_layout, @Cast("char") byte jobu, @Cast("char") byte jobv, @Cast("char") byte jobq,
                           int m, int p, int n,
                           int k, int l, DoublePointer a,
                           int lda, DoublePointer b, int ldb,
                           double tola, double tolb, DoublePointer alpha,
                           DoublePointer beta, DoublePointer u, int ldu, DoublePointer v,
                           int ldv, DoublePointer q, int ldq,
                           IntPointer ncycle );
public static native int LAPACKE_dtgsja( int matrix_layout, @Cast("char") byte jobu, @Cast("char") byte jobv, @Cast("char") byte jobq,
                           int m, int p, int n,
                           int k, int l, DoubleBuffer a,
                           int lda, DoubleBuffer b, int ldb,
                           double tola, double tolb, DoubleBuffer alpha,
                           DoubleBuffer beta, DoubleBuffer u, int ldu, DoubleBuffer v,
                           int ldv, DoubleBuffer q, int ldq,
                           IntBuffer ncycle );
public static native int LAPACKE_dtgsja( int matrix_layout, @Cast("char") byte jobu, @Cast("char") byte jobv, @Cast("char") byte jobq,
                           int m, int p, int n,
                           int k, int l, double[] a,
                           int lda, double[] b, int ldb,
                           double tola, double tolb, double[] alpha,
                           double[] beta, double[] u, int ldu, double[] v,
                           int ldv, double[] q, int ldq,
                           int[] ncycle );
public static native int LAPACKE_ctgsja( int matrix_layout, @Cast("char") byte jobu, @Cast("char") byte jobv, @Cast("char") byte jobq,
                           int m, int p, int n,
                           int k, int l, @Cast("lapack_complex_float*") FloatPointer a,
                           int lda, @Cast("lapack_complex_float*") FloatPointer b,
                           int ldb, float tola, float tolb, FloatPointer alpha,
                           FloatPointer beta, @Cast("lapack_complex_float*") FloatPointer u, int ldu,
                           @Cast("lapack_complex_float*") FloatPointer v, int ldv,
                           @Cast("lapack_complex_float*") FloatPointer q, int ldq,
                           IntPointer ncycle );
public static native int LAPACKE_ctgsja( int matrix_layout, @Cast("char") byte jobu, @Cast("char") byte jobv, @Cast("char") byte jobq,
                           int m, int p, int n,
                           int k, int l, @Cast("lapack_complex_float*") FloatBuffer a,
                           int lda, @Cast("lapack_complex_float*") FloatBuffer b,
                           int ldb, float tola, float tolb, FloatBuffer alpha,
                           FloatBuffer beta, @Cast("lapack_complex_float*") FloatBuffer u, int ldu,
                           @Cast("lapack_complex_float*") FloatBuffer v, int ldv,
                           @Cast("lapack_complex_float*") FloatBuffer q, int ldq,
                           IntBuffer ncycle );
public static native int LAPACKE_ctgsja( int matrix_layout, @Cast("char") byte jobu, @Cast("char") byte jobv, @Cast("char") byte jobq,
                           int m, int p, int n,
                           int k, int l, @Cast("lapack_complex_float*") float[] a,
                           int lda, @Cast("lapack_complex_float*") float[] b,
                           int ldb, float tola, float tolb, float[] alpha,
                           float[] beta, @Cast("lapack_complex_float*") float[] u, int ldu,
                           @Cast("lapack_complex_float*") float[] v, int ldv,
                           @Cast("lapack_complex_float*") float[] q, int ldq,
                           int[] ncycle );
public static native int LAPACKE_ztgsja( int matrix_layout, @Cast("char") byte jobu, @Cast("char") byte jobv, @Cast("char") byte jobq,
                           int m, int p, int n,
                           int k, int l, @Cast("lapack_complex_double*") DoublePointer a,
                           int lda, @Cast("lapack_complex_double*") DoublePointer b,
                           int ldb, double tola, double tolb,
                           DoublePointer alpha, DoublePointer beta,
                           @Cast("lapack_complex_double*") DoublePointer u, int ldu,
                           @Cast("lapack_complex_double*") DoublePointer v, int ldv,
                           @Cast("lapack_complex_double*") DoublePointer q, int ldq,
                           IntPointer ncycle );
public static native int LAPACKE_ztgsja( int matrix_layout, @Cast("char") byte jobu, @Cast("char") byte jobv, @Cast("char") byte jobq,
                           int m, int p, int n,
                           int k, int l, @Cast("lapack_complex_double*") DoubleBuffer a,
                           int lda, @Cast("lapack_complex_double*") DoubleBuffer b,
                           int ldb, double tola, double tolb,
                           DoubleBuffer alpha, DoubleBuffer beta,
                           @Cast("lapack_complex_double*") DoubleBuffer u, int ldu,
                           @Cast("lapack_complex_double*") DoubleBuffer v, int ldv,
                           @Cast("lapack_complex_double*") DoubleBuffer q, int ldq,
                           IntBuffer ncycle );
public static native int LAPACKE_ztgsja( int matrix_layout, @Cast("char") byte jobu, @Cast("char") byte jobv, @Cast("char") byte jobq,
                           int m, int p, int n,
                           int k, int l, @Cast("lapack_complex_double*") double[] a,
                           int lda, @Cast("lapack_complex_double*") double[] b,
                           int ldb, double tola, double tolb,
                           double[] alpha, double[] beta,
                           @Cast("lapack_complex_double*") double[] u, int ldu,
                           @Cast("lapack_complex_double*") double[] v, int ldv,
                           @Cast("lapack_complex_double*") double[] q, int ldq,
                           int[] ncycle );

public static native int LAPACKE_stgsna( int matrix_layout, @Cast("char") byte job, @Cast("char") byte howmny,
                           @Const IntPointer select, int n,
                           @Const FloatPointer a, int lda, @Const FloatPointer b,
                           int ldb, @Const FloatPointer vl, int ldvl,
                           @Const FloatPointer vr, int ldvr, FloatPointer s,
                           FloatPointer dif, int mm, IntPointer m );
public static native int LAPACKE_stgsna( int matrix_layout, @Cast("char") byte job, @Cast("char") byte howmny,
                           @Const IntBuffer select, int n,
                           @Const FloatBuffer a, int lda, @Const FloatBuffer b,
                           int ldb, @Const FloatBuffer vl, int ldvl,
                           @Const FloatBuffer vr, int ldvr, FloatBuffer s,
                           FloatBuffer dif, int mm, IntBuffer m );
public static native int LAPACKE_stgsna( int matrix_layout, @Cast("char") byte job, @Cast("char") byte howmny,
                           @Const int[] select, int n,
                           @Const float[] a, int lda, @Const float[] b,
                           int ldb, @Const float[] vl, int ldvl,
                           @Const float[] vr, int ldvr, float[] s,
                           float[] dif, int mm, int[] m );
public static native int LAPACKE_dtgsna( int matrix_layout, @Cast("char") byte job, @Cast("char") byte howmny,
                           @Const IntPointer select, int n,
                           @Const DoublePointer a, int lda, @Const DoublePointer b,
                           int ldb, @Const DoublePointer vl, int ldvl,
                           @Const DoublePointer vr, int ldvr, DoublePointer s,
                           DoublePointer dif, int mm, IntPointer m );
public static native int LAPACKE_dtgsna( int matrix_layout, @Cast("char") byte job, @Cast("char") byte howmny,
                           @Const IntBuffer select, int n,
                           @Const DoubleBuffer a, int lda, @Const DoubleBuffer b,
                           int ldb, @Const DoubleBuffer vl, int ldvl,
                           @Const DoubleBuffer vr, int ldvr, DoubleBuffer s,
                           DoubleBuffer dif, int mm, IntBuffer m );
public static native int LAPACKE_dtgsna( int matrix_layout, @Cast("char") byte job, @Cast("char") byte howmny,
                           @Const int[] select, int n,
                           @Const double[] a, int lda, @Const double[] b,
                           int ldb, @Const double[] vl, int ldvl,
                           @Const double[] vr, int ldvr, double[] s,
                           double[] dif, int mm, int[] m );
public static native int LAPACKE_ctgsna( int matrix_layout, @Cast("char") byte job, @Cast("char") byte howmny,
                           @Const IntPointer select, int n,
                           @Cast("const lapack_complex_float*") FloatPointer a, int lda,
                           @Cast("const lapack_complex_float*") FloatPointer b, int ldb,
                           @Cast("const lapack_complex_float*") FloatPointer vl, int ldvl,
                           @Cast("const lapack_complex_float*") FloatPointer vr, int ldvr,
                           FloatPointer s, FloatPointer dif, int mm, IntPointer m );
public static native int LAPACKE_ctgsna( int matrix_layout, @Cast("char") byte job, @Cast("char") byte howmny,
                           @Const IntBuffer select, int n,
                           @Cast("const lapack_complex_float*") FloatBuffer a, int lda,
                           @Cast("const lapack_complex_float*") FloatBuffer b, int ldb,
                           @Cast("const lapack_complex_float*") FloatBuffer vl, int ldvl,
                           @Cast("const lapack_complex_float*") FloatBuffer vr, int ldvr,
                           FloatBuffer s, FloatBuffer dif, int mm, IntBuffer m );
public static native int LAPACKE_ctgsna( int matrix_layout, @Cast("char") byte job, @Cast("char") byte howmny,
                           @Const int[] select, int n,
                           @Cast("const lapack_complex_float*") float[] a, int lda,
                           @Cast("const lapack_complex_float*") float[] b, int ldb,
                           @Cast("const lapack_complex_float*") float[] vl, int ldvl,
                           @Cast("const lapack_complex_float*") float[] vr, int ldvr,
                           float[] s, float[] dif, int mm, int[] m );
public static native int LAPACKE_ztgsna( int matrix_layout, @Cast("char") byte job, @Cast("char") byte howmny,
                           @Const IntPointer select, int n,
                           @Cast("const lapack_complex_double*") DoublePointer a, int lda,
                           @Cast("const lapack_complex_double*") DoublePointer b, int ldb,
                           @Cast("const lapack_complex_double*") DoublePointer vl, int ldvl,
                           @Cast("const lapack_complex_double*") DoublePointer vr, int ldvr,
                           DoublePointer s, DoublePointer dif, int mm,
                           IntPointer m );
public static native int LAPACKE_ztgsna( int matrix_layout, @Cast("char") byte job, @Cast("char") byte howmny,
                           @Const IntBuffer select, int n,
                           @Cast("const lapack_complex_double*") DoubleBuffer a, int lda,
                           @Cast("const lapack_complex_double*") DoubleBuffer b, int ldb,
                           @Cast("const lapack_complex_double*") DoubleBuffer vl, int ldvl,
                           @Cast("const lapack_complex_double*") DoubleBuffer vr, int ldvr,
                           DoubleBuffer s, DoubleBuffer dif, int mm,
                           IntBuffer m );
public static native int LAPACKE_ztgsna( int matrix_layout, @Cast("char") byte job, @Cast("char") byte howmny,
                           @Const int[] select, int n,
                           @Cast("const lapack_complex_double*") double[] a, int lda,
                           @Cast("const lapack_complex_double*") double[] b, int ldb,
                           @Cast("const lapack_complex_double*") double[] vl, int ldvl,
                           @Cast("const lapack_complex_double*") double[] vr, int ldvr,
                           double[] s, double[] dif, int mm,
                           int[] m );

public static native int LAPACKE_stgsyl( int matrix_layout, @Cast("char") byte trans, int ijob,
                           int m, int n, @Const FloatPointer a,
                           int lda, @Const FloatPointer b, int ldb,
                           FloatPointer c, int ldc, @Const FloatPointer d,
                           int ldd, @Const FloatPointer e, int lde,
                           FloatPointer f, int ldf, FloatPointer scale, FloatPointer dif );
public static native int LAPACKE_stgsyl( int matrix_layout, @Cast("char") byte trans, int ijob,
                           int m, int n, @Const FloatBuffer a,
                           int lda, @Const FloatBuffer b, int ldb,
                           FloatBuffer c, int ldc, @Const FloatBuffer d,
                           int ldd, @Const FloatBuffer e, int lde,
                           FloatBuffer f, int ldf, FloatBuffer scale, FloatBuffer dif );
public static native int LAPACKE_stgsyl( int matrix_layout, @Cast("char") byte trans, int ijob,
                           int m, int n, @Const float[] a,
                           int lda, @Const float[] b, int ldb,
                           float[] c, int ldc, @Const float[] d,
                           int ldd, @Const float[] e, int lde,
                           float[] f, int ldf, float[] scale, float[] dif );
public static native int LAPACKE_dtgsyl( int matrix_layout, @Cast("char") byte trans, int ijob,
                           int m, int n, @Const DoublePointer a,
                           int lda, @Const DoublePointer b, int ldb,
                           DoublePointer c, int ldc, @Const DoublePointer d,
                           int ldd, @Const DoublePointer e, int lde,
                           DoublePointer f, int ldf, DoublePointer scale,
                           DoublePointer dif );
public static native int LAPACKE_dtgsyl( int matrix_layout, @Cast("char") byte trans, int ijob,
                           int m, int n, @Const DoubleBuffer a,
                           int lda, @Const DoubleBuffer b, int ldb,
                           DoubleBuffer c, int ldc, @Const DoubleBuffer d,
                           int ldd, @Const DoubleBuffer e, int lde,
                           DoubleBuffer f, int ldf, DoubleBuffer scale,
                           DoubleBuffer dif );
public static native int LAPACKE_dtgsyl( int matrix_layout, @Cast("char") byte trans, int ijob,
                           int m, int n, @Const double[] a,
                           int lda, @Const double[] b, int ldb,
                           double[] c, int ldc, @Const double[] d,
                           int ldd, @Const double[] e, int lde,
                           double[] f, int ldf, double[] scale,
                           double[] dif );
public static native int LAPACKE_ctgsyl( int matrix_layout, @Cast("char") byte trans, int ijob,
                           int m, int n,
                           @Cast("const lapack_complex_float*") FloatPointer a, int lda,
                           @Cast("const lapack_complex_float*") FloatPointer b, int ldb,
                           @Cast("lapack_complex_float*") FloatPointer c, int ldc,
                           @Cast("const lapack_complex_float*") FloatPointer d, int ldd,
                           @Cast("const lapack_complex_float*") FloatPointer e, int lde,
                           @Cast("lapack_complex_float*") FloatPointer f, int ldf,
                           FloatPointer scale, FloatPointer dif );
public static native int LAPACKE_ctgsyl( int matrix_layout, @Cast("char") byte trans, int ijob,
                           int m, int n,
                           @Cast("const lapack_complex_float*") FloatBuffer a, int lda,
                           @Cast("const lapack_complex_float*") FloatBuffer b, int ldb,
                           @Cast("lapack_complex_float*") FloatBuffer c, int ldc,
                           @Cast("const lapack_complex_float*") FloatBuffer d, int ldd,
                           @Cast("const lapack_complex_float*") FloatBuffer e, int lde,
                           @Cast("lapack_complex_float*") FloatBuffer f, int ldf,
                           FloatBuffer scale, FloatBuffer dif );
public static native int LAPACKE_ctgsyl( int matrix_layout, @Cast("char") byte trans, int ijob,
                           int m, int n,
                           @Cast("const lapack_complex_float*") float[] a, int lda,
                           @Cast("const lapack_complex_float*") float[] b, int ldb,
                           @Cast("lapack_complex_float*") float[] c, int ldc,
                           @Cast("const lapack_complex_float*") float[] d, int ldd,
                           @Cast("const lapack_complex_float*") float[] e, int lde,
                           @Cast("lapack_complex_float*") float[] f, int ldf,
                           float[] scale, float[] dif );
public static native int LAPACKE_ztgsyl( int matrix_layout, @Cast("char") byte trans, int ijob,
                           int m, int n,
                           @Cast("const lapack_complex_double*") DoublePointer a, int lda,
                           @Cast("const lapack_complex_double*") DoublePointer b, int ldb,
                           @Cast("lapack_complex_double*") DoublePointer c, int ldc,
                           @Cast("const lapack_complex_double*") DoublePointer d, int ldd,
                           @Cast("const lapack_complex_double*") DoublePointer e, int lde,
                           @Cast("lapack_complex_double*") DoublePointer f, int ldf,
                           DoublePointer scale, DoublePointer dif );
public static native int LAPACKE_ztgsyl( int matrix_layout, @Cast("char") byte trans, int ijob,
                           int m, int n,
                           @Cast("const lapack_complex_double*") DoubleBuffer a, int lda,
                           @Cast("const lapack_complex_double*") DoubleBuffer b, int ldb,
                           @Cast("lapack_complex_double*") DoubleBuffer c, int ldc,
                           @Cast("const lapack_complex_double*") DoubleBuffer d, int ldd,
                           @Cast("const lapack_complex_double*") DoubleBuffer e, int lde,
                           @Cast("lapack_complex_double*") DoubleBuffer f, int ldf,
                           DoubleBuffer scale, DoubleBuffer dif );
public static native int LAPACKE_ztgsyl( int matrix_layout, @Cast("char") byte trans, int ijob,
                           int m, int n,
                           @Cast("const lapack_complex_double*") double[] a, int lda,
                           @Cast("const lapack_complex_double*") double[] b, int ldb,
                           @Cast("lapack_complex_double*") double[] c, int ldc,
                           @Cast("const lapack_complex_double*") double[] d, int ldd,
                           @Cast("const lapack_complex_double*") double[] e, int lde,
                           @Cast("lapack_complex_double*") double[] f, int ldf,
                           double[] scale, double[] dif );

public static native int LAPACKE_stpcon( int matrix_layout, @Cast("char") byte norm, @Cast("char") byte uplo, @Cast("char") byte diag,
                           int n, @Const FloatPointer ap, FloatPointer rcond );
public static native int LAPACKE_stpcon( int matrix_layout, @Cast("char") byte norm, @Cast("char") byte uplo, @Cast("char") byte diag,
                           int n, @Const FloatBuffer ap, FloatBuffer rcond );
public static native int LAPACKE_stpcon( int matrix_layout, @Cast("char") byte norm, @Cast("char") byte uplo, @Cast("char") byte diag,
                           int n, @Const float[] ap, float[] rcond );
public static native int LAPACKE_dtpcon( int matrix_layout, @Cast("char") byte norm, @Cast("char") byte uplo, @Cast("char") byte diag,
                           int n, @Const DoublePointer ap, DoublePointer rcond );
public static native int LAPACKE_dtpcon( int matrix_layout, @Cast("char") byte norm, @Cast("char") byte uplo, @Cast("char") byte diag,
                           int n, @Const DoubleBuffer ap, DoubleBuffer rcond );
public static native int LAPACKE_dtpcon( int matrix_layout, @Cast("char") byte norm, @Cast("char") byte uplo, @Cast("char") byte diag,
                           int n, @Const double[] ap, double[] rcond );
public static native int LAPACKE_ctpcon( int matrix_layout, @Cast("char") byte norm, @Cast("char") byte uplo, @Cast("char") byte diag,
                           int n, @Cast("const lapack_complex_float*") FloatPointer ap,
                           FloatPointer rcond );
public static native int LAPACKE_ctpcon( int matrix_layout, @Cast("char") byte norm, @Cast("char") byte uplo, @Cast("char") byte diag,
                           int n, @Cast("const lapack_complex_float*") FloatBuffer ap,
                           FloatBuffer rcond );
public static native int LAPACKE_ctpcon( int matrix_layout, @Cast("char") byte norm, @Cast("char") byte uplo, @Cast("char") byte diag,
                           int n, @Cast("const lapack_complex_float*") float[] ap,
                           float[] rcond );
public static native int LAPACKE_ztpcon( int matrix_layout, @Cast("char") byte norm, @Cast("char") byte uplo, @Cast("char") byte diag,
                           int n, @Cast("const lapack_complex_double*") DoublePointer ap,
                           DoublePointer rcond );
public static native int LAPACKE_ztpcon( int matrix_layout, @Cast("char") byte norm, @Cast("char") byte uplo, @Cast("char") byte diag,
                           int n, @Cast("const lapack_complex_double*") DoubleBuffer ap,
                           DoubleBuffer rcond );
public static native int LAPACKE_ztpcon( int matrix_layout, @Cast("char") byte norm, @Cast("char") byte uplo, @Cast("char") byte diag,
                           int n, @Cast("const lapack_complex_double*") double[] ap,
                           double[] rcond );

public static native int LAPACKE_stprfs( int matrix_layout, @Cast("char") byte uplo, @Cast("char") byte trans, @Cast("char") byte diag,
                           int n, int nrhs, @Const FloatPointer ap,
                           @Const FloatPointer b, int ldb, @Const FloatPointer x,
                           int ldx, FloatPointer ferr, FloatPointer berr );
public static native int LAPACKE_stprfs( int matrix_layout, @Cast("char") byte uplo, @Cast("char") byte trans, @Cast("char") byte diag,
                           int n, int nrhs, @Const FloatBuffer ap,
                           @Const FloatBuffer b, int ldb, @Const FloatBuffer x,
                           int ldx, FloatBuffer ferr, FloatBuffer berr );
public static native int LAPACKE_stprfs( int matrix_layout, @Cast("char") byte uplo, @Cast("char") byte trans, @Cast("char") byte diag,
                           int n, int nrhs, @Const float[] ap,
                           @Const float[] b, int ldb, @Const float[] x,
                           int ldx, float[] ferr, float[] berr );
public static native int LAPACKE_dtprfs( int matrix_layout, @Cast("char") byte uplo, @Cast("char") byte trans, @Cast("char") byte diag,
                           int n, int nrhs, @Const DoublePointer ap,
                           @Const DoublePointer b, int ldb, @Const DoublePointer x,
                           int ldx, DoublePointer ferr, DoublePointer berr );
public static native int LAPACKE_dtprfs( int matrix_layout, @Cast("char") byte uplo, @Cast("char") byte trans, @Cast("char") byte diag,
                           int n, int nrhs, @Const DoubleBuffer ap,
                           @Const DoubleBuffer b, int ldb, @Const DoubleBuffer x,
                           int ldx, DoubleBuffer ferr, DoubleBuffer berr );
public static native int LAPACKE_dtprfs( int matrix_layout, @Cast("char") byte uplo, @Cast("char") byte trans, @Cast("char") byte diag,
                           int n, int nrhs, @Const double[] ap,
                           @Const double[] b, int ldb, @Const double[] x,
                           int ldx, double[] ferr, double[] berr );
public static native int LAPACKE_ctprfs( int matrix_layout, @Cast("char") byte uplo, @Cast("char") byte trans, @Cast("char") byte diag,
                           int n, int nrhs,
                           @Cast("const lapack_complex_float*") FloatPointer ap,
                           @Cast("const lapack_complex_float*") FloatPointer b, int ldb,
                           @Cast("const lapack_complex_float*") FloatPointer x, int ldx,
                           FloatPointer ferr, FloatPointer berr );
public static native int LAPACKE_ctprfs( int matrix_layout, @Cast("char") byte uplo, @Cast("char") byte trans, @Cast("char") byte diag,
                           int n, int nrhs,
                           @Cast("const lapack_complex_float*") FloatBuffer ap,
                           @Cast("const lapack_complex_float*") FloatBuffer b, int ldb,
                           @Cast("const lapack_complex_float*") FloatBuffer x, int ldx,
                           FloatBuffer ferr, FloatBuffer berr );
public static native int LAPACKE_ctprfs( int matrix_layout, @Cast("char") byte uplo, @Cast("char") byte trans, @Cast("char") byte diag,
                           int n, int nrhs,
                           @Cast("const lapack_complex_float*") float[] ap,
                           @Cast("const lapack_complex_float*") float[] b, int ldb,
                           @Cast("const lapack_complex_float*") float[] x, int ldx,
                           float[] ferr, float[] berr );
public static native int LAPACKE_ztprfs( int matrix_layout, @Cast("char") byte uplo, @Cast("char") byte trans, @Cast("char") byte diag,
                           int n, int nrhs,
                           @Cast("const lapack_complex_double*") DoublePointer ap,
                           @Cast("const lapack_complex_double*") DoublePointer b, int ldb,
                           @Cast("const lapack_complex_double*") DoublePointer x, int ldx,
                           DoublePointer ferr, DoublePointer berr );
public static native int LAPACKE_ztprfs( int matrix_layout, @Cast("char") byte uplo, @Cast("char") byte trans, @Cast("char") byte diag,
                           int n, int nrhs,
                           @Cast("const lapack_complex_double*") DoubleBuffer ap,
                           @Cast("const lapack_complex_double*") DoubleBuffer b, int ldb,
                           @Cast("const lapack_complex_double*") DoubleBuffer x, int ldx,
                           DoubleBuffer ferr, DoubleBuffer berr );
public static native int LAPACKE_ztprfs( int matrix_layout, @Cast("char") byte uplo, @Cast("char") byte trans, @Cast("char") byte diag,
                           int n, int nrhs,
                           @Cast("const lapack_complex_double*") double[] ap,
                           @Cast("const lapack_complex_double*") double[] b, int ldb,
                           @Cast("const lapack_complex_double*") double[] x, int ldx,
                           double[] ferr, double[] berr );

public static native int LAPACKE_stptri( int matrix_layout, @Cast("char") byte uplo, @Cast("char") byte diag, int n,
                           FloatPointer ap );
public static native int LAPACKE_stptri( int matrix_layout, @Cast("char") byte uplo, @Cast("char") byte diag, int n,
                           FloatBuffer ap );
public static native int LAPACKE_stptri( int matrix_layout, @Cast("char") byte uplo, @Cast("char") byte diag, int n,
                           float[] ap );
public static native int LAPACKE_dtptri( int matrix_layout, @Cast("char") byte uplo, @Cast("char") byte diag, int n,
                           DoublePointer ap );
public static native int LAPACKE_dtptri( int matrix_layout, @Cast("char") byte uplo, @Cast("char") byte diag, int n,
                           DoubleBuffer ap );
public static native int LAPACKE_dtptri( int matrix_layout, @Cast("char") byte uplo, @Cast("char") byte diag, int n,
                           double[] ap );
public static native int LAPACKE_ctptri( int matrix_layout, @Cast("char") byte uplo, @Cast("char") byte diag, int n,
                           @Cast("lapack_complex_float*") FloatPointer ap );
public static native int LAPACKE_ctptri( int matrix_layout, @Cast("char") byte uplo, @Cast("char") byte diag, int n,
                           @Cast("lapack_complex_float*") FloatBuffer ap );
public static native int LAPACKE_ctptri( int matrix_layout, @Cast("char") byte uplo, @Cast("char") byte diag, int n,
                           @Cast("lapack_complex_float*") float[] ap );
public static native int LAPACKE_ztptri( int matrix_layout, @Cast("char") byte uplo, @Cast("char") byte diag, int n,
                           @Cast("lapack_complex_double*") DoublePointer ap );
public static native int LAPACKE_ztptri( int matrix_layout, @Cast("char") byte uplo, @Cast("char") byte diag, int n,
                           @Cast("lapack_complex_double*") DoubleBuffer ap );
public static native int LAPACKE_ztptri( int matrix_layout, @Cast("char") byte uplo, @Cast("char") byte diag, int n,
                           @Cast("lapack_complex_double*") double[] ap );

public static native int LAPACKE_stptrs( int matrix_layout, @Cast("char") byte uplo, @Cast("char") byte trans, @Cast("char") byte diag,
                           int n, int nrhs, @Const FloatPointer ap,
                           FloatPointer b, int ldb );
public static native int LAPACKE_stptrs( int matrix_layout, @Cast("char") byte uplo, @Cast("char") byte trans, @Cast("char") byte diag,
                           int n, int nrhs, @Const FloatBuffer ap,
                           FloatBuffer b, int ldb );
public static native int LAPACKE_stptrs( int matrix_layout, @Cast("char") byte uplo, @Cast("char") byte trans, @Cast("char") byte diag,
                           int n, int nrhs, @Const float[] ap,
                           float[] b, int ldb );
public static native int LAPACKE_dtptrs( int matrix_layout, @Cast("char") byte uplo, @Cast("char") byte trans, @Cast("char") byte diag,
                           int n, int nrhs, @Const DoublePointer ap,
                           DoublePointer b, int ldb );
public static native int LAPACKE_dtptrs( int matrix_layout, @Cast("char") byte uplo, @Cast("char") byte trans, @Cast("char") byte diag,
                           int n, int nrhs, @Const DoubleBuffer ap,
                           DoubleBuffer b, int ldb );
public static native int LAPACKE_dtptrs( int matrix_layout, @Cast("char") byte uplo, @Cast("char") byte trans, @Cast("char") byte diag,
                           int n, int nrhs, @Const double[] ap,
                           double[] b, int ldb );
public static native int LAPACKE_ctptrs( int matrix_layout, @Cast("char") byte uplo, @Cast("char") byte trans, @Cast("char") byte diag,
                           int n, int nrhs,
                           @Cast("const lapack_complex_float*") FloatPointer ap,
                           @Cast("lapack_complex_float*") FloatPointer b, int ldb );
public static native int LAPACKE_ctptrs( int matrix_layout, @Cast("char") byte uplo, @Cast("char") byte trans, @Cast("char") byte diag,
                           int n, int nrhs,
                           @Cast("const lapack_complex_float*") FloatBuffer ap,
                           @Cast("lapack_complex_float*") FloatBuffer b, int ldb );
public static native int LAPACKE_ctptrs( int matrix_layout, @Cast("char") byte uplo, @Cast("char") byte trans, @Cast("char") byte diag,
                           int n, int nrhs,
                           @Cast("const lapack_complex_float*") float[] ap,
                           @Cast("lapack_complex_float*") float[] b, int ldb );
public static native int LAPACKE_ztptrs( int matrix_layout, @Cast("char") byte uplo, @Cast("char") byte trans, @Cast("char") byte diag,
                           int n, int nrhs,
                           @Cast("const lapack_complex_double*") DoublePointer ap,
                           @Cast("lapack_complex_double*") DoublePointer b, int ldb );
public static native int LAPACKE_ztptrs( int matrix_layout, @Cast("char") byte uplo, @Cast("char") byte trans, @Cast("char") byte diag,
                           int n, int nrhs,
                           @Cast("const lapack_complex_double*") DoubleBuffer ap,
                           @Cast("lapack_complex_double*") DoubleBuffer b, int ldb );
public static native int LAPACKE_ztptrs( int matrix_layout, @Cast("char") byte uplo, @Cast("char") byte trans, @Cast("char") byte diag,
                           int n, int nrhs,
                           @Cast("const lapack_complex_double*") double[] ap,
                           @Cast("lapack_complex_double*") double[] b, int ldb );

public static native int LAPACKE_stpttf( int matrix_layout, @Cast("char") byte transr, @Cast("char") byte uplo,
                           int n, @Const FloatPointer ap, FloatPointer arf );
public static native int LAPACKE_stpttf( int matrix_layout, @Cast("char") byte transr, @Cast("char") byte uplo,
                           int n, @Const FloatBuffer ap, FloatBuffer arf );
public static native int LAPACKE_stpttf( int matrix_layout, @Cast("char") byte transr, @Cast("char") byte uplo,
                           int n, @Const float[] ap, float[] arf );
public static native int LAPACKE_dtpttf( int matrix_layout, @Cast("char") byte transr, @Cast("char") byte uplo,
                           int n, @Const DoublePointer ap, DoublePointer arf );
public static native int LAPACKE_dtpttf( int matrix_layout, @Cast("char") byte transr, @Cast("char") byte uplo,
                           int n, @Const DoubleBuffer ap, DoubleBuffer arf );
public static native int LAPACKE_dtpttf( int matrix_layout, @Cast("char") byte transr, @Cast("char") byte uplo,
                           int n, @Const double[] ap, double[] arf );
public static native int LAPACKE_ctpttf( int matrix_layout, @Cast("char") byte transr, @Cast("char") byte uplo,
                           int n, @Cast("const lapack_complex_float*") FloatPointer ap,
                           @Cast("lapack_complex_float*") FloatPointer arf );
public static native int LAPACKE_ctpttf( int matrix_layout, @Cast("char") byte transr, @Cast("char") byte uplo,
                           int n, @Cast("const lapack_complex_float*") FloatBuffer ap,
                           @Cast("lapack_complex_float*") FloatBuffer arf );
public static native int LAPACKE_ctpttf( int matrix_layout, @Cast("char") byte transr, @Cast("char") byte uplo,
                           int n, @Cast("const lapack_complex_float*") float[] ap,
                           @Cast("lapack_complex_float*") float[] arf );
public static native int LAPACKE_ztpttf( int matrix_layout, @Cast("char") byte transr, @Cast("char") byte uplo,
                           int n, @Cast("const lapack_complex_double*") DoublePointer ap,
                           @Cast("lapack_complex_double*") DoublePointer arf );
public static native int LAPACKE_ztpttf( int matrix_layout, @Cast("char") byte transr, @Cast("char") byte uplo,
                           int n, @Cast("const lapack_complex_double*") DoubleBuffer ap,
                           @Cast("lapack_complex_double*") DoubleBuffer arf );
public static native int LAPACKE_ztpttf( int matrix_layout, @Cast("char") byte transr, @Cast("char") byte uplo,
                           int n, @Cast("const lapack_complex_double*") double[] ap,
                           @Cast("lapack_complex_double*") double[] arf );

public static native int LAPACKE_stpttr( int matrix_layout, @Cast("char") byte uplo, int n,
                           @Const FloatPointer ap, FloatPointer a, int lda );
public static native int LAPACKE_stpttr( int matrix_layout, @Cast("char") byte uplo, int n,
                           @Const FloatBuffer ap, FloatBuffer a, int lda );
public static native int LAPACKE_stpttr( int matrix_layout, @Cast("char") byte uplo, int n,
                           @Const float[] ap, float[] a, int lda );
public static native int LAPACKE_dtpttr( int matrix_layout, @Cast("char") byte uplo, int n,
                           @Const DoublePointer ap, DoublePointer a, int lda );
public static native int LAPACKE_dtpttr( int matrix_layout, @Cast("char") byte uplo, int n,
                           @Const DoubleBuffer ap, DoubleBuffer a, int lda );
public static native int LAPACKE_dtpttr( int matrix_layout, @Cast("char") byte uplo, int n,
                           @Const double[] ap, double[] a, int lda );
public static native int LAPACKE_ctpttr( int matrix_layout, @Cast("char") byte uplo, int n,
                           @Cast("const lapack_complex_float*") FloatPointer ap,
                           @Cast("lapack_complex_float*") FloatPointer a, int lda );
public static native int LAPACKE_ctpttr( int matrix_layout, @Cast("char") byte uplo, int n,
                           @Cast("const lapack_complex_float*") FloatBuffer ap,
                           @Cast("lapack_complex_float*") FloatBuffer a, int lda );
public static native int LAPACKE_ctpttr( int matrix_layout, @Cast("char") byte uplo, int n,
                           @Cast("const lapack_complex_float*") float[] ap,
                           @Cast("lapack_complex_float*") float[] a, int lda );
public static native int LAPACKE_ztpttr( int matrix_layout, @Cast("char") byte uplo, int n,
                           @Cast("const lapack_complex_double*") DoublePointer ap,
                           @Cast("lapack_complex_double*") DoublePointer a, int lda );
public static native int LAPACKE_ztpttr( int matrix_layout, @Cast("char") byte uplo, int n,
                           @Cast("const lapack_complex_double*") DoubleBuffer ap,
                           @Cast("lapack_complex_double*") DoubleBuffer a, int lda );
public static native int LAPACKE_ztpttr( int matrix_layout, @Cast("char") byte uplo, int n,
                           @Cast("const lapack_complex_double*") double[] ap,
                           @Cast("lapack_complex_double*") double[] a, int lda );

public static native int LAPACKE_strcon( int matrix_layout, @Cast("char") byte norm, @Cast("char") byte uplo, @Cast("char") byte diag,
                           int n, @Const FloatPointer a, int lda,
                           FloatPointer rcond );
public static native int LAPACKE_strcon( int matrix_layout, @Cast("char") byte norm, @Cast("char") byte uplo, @Cast("char") byte diag,
                           int n, @Const FloatBuffer a, int lda,
                           FloatBuffer rcond );
public static native int LAPACKE_strcon( int matrix_layout, @Cast("char") byte norm, @Cast("char") byte uplo, @Cast("char") byte diag,
                           int n, @Const float[] a, int lda,
                           float[] rcond );
public static native int LAPACKE_dtrcon( int matrix_layout, @Cast("char") byte norm, @Cast("char") byte uplo, @Cast("char") byte diag,
                           int n, @Const DoublePointer a, int lda,
                           DoublePointer rcond );
public static native int LAPACKE_dtrcon( int matrix_layout, @Cast("char") byte norm, @Cast("char") byte uplo, @Cast("char") byte diag,
                           int n, @Const DoubleBuffer a, int lda,
                           DoubleBuffer rcond );
public static native int LAPACKE_dtrcon( int matrix_layout, @Cast("char") byte norm, @Cast("char") byte uplo, @Cast("char") byte diag,
                           int n, @Const double[] a, int lda,
                           double[] rcond );
public static native int LAPACKE_ctrcon( int matrix_layout, @Cast("char") byte norm, @Cast("char") byte uplo, @Cast("char") byte diag,
                           int n, @Cast("const lapack_complex_float*") FloatPointer a,
                           int lda, FloatPointer rcond );
public static native int LAPACKE_ctrcon( int matrix_layout, @Cast("char") byte norm, @Cast("char") byte uplo, @Cast("char") byte diag,
                           int n, @Cast("const lapack_complex_float*") FloatBuffer a,
                           int lda, FloatBuffer rcond );
public static native int LAPACKE_ctrcon( int matrix_layout, @Cast("char") byte norm, @Cast("char") byte uplo, @Cast("char") byte diag,
                           int n, @Cast("const lapack_complex_float*") float[] a,
                           int lda, float[] rcond );
public static native int LAPACKE_ztrcon( int matrix_layout, @Cast("char") byte norm, @Cast("char") byte uplo, @Cast("char") byte diag,
                           int n, @Cast("const lapack_complex_double*") DoublePointer a,
                           int lda, DoublePointer rcond );
public static native int LAPACKE_ztrcon( int matrix_layout, @Cast("char") byte norm, @Cast("char") byte uplo, @Cast("char") byte diag,
                           int n, @Cast("const lapack_complex_double*") DoubleBuffer a,
                           int lda, DoubleBuffer rcond );
public static native int LAPACKE_ztrcon( int matrix_layout, @Cast("char") byte norm, @Cast("char") byte uplo, @Cast("char") byte diag,
                           int n, @Cast("const lapack_complex_double*") double[] a,
                           int lda, double[] rcond );

public static native int LAPACKE_strevc( int matrix_layout, @Cast("char") byte side, @Cast("char") byte howmny,
                           IntPointer select, int n, @Const FloatPointer t,
                           int ldt, FloatPointer vl, int ldvl,
                           FloatPointer vr, int ldvr, int mm,
                           IntPointer m );
public static native int LAPACKE_strevc( int matrix_layout, @Cast("char") byte side, @Cast("char") byte howmny,
                           IntBuffer select, int n, @Const FloatBuffer t,
                           int ldt, FloatBuffer vl, int ldvl,
                           FloatBuffer vr, int ldvr, int mm,
                           IntBuffer m );
public static native int LAPACKE_strevc( int matrix_layout, @Cast("char") byte side, @Cast("char") byte howmny,
                           int[] select, int n, @Const float[] t,
                           int ldt, float[] vl, int ldvl,
                           float[] vr, int ldvr, int mm,
                           int[] m );
public static native int LAPACKE_dtrevc( int matrix_layout, @Cast("char") byte side, @Cast("char") byte howmny,
                           IntPointer select, int n,
                           @Const DoublePointer t, int ldt, DoublePointer vl,
                           int ldvl, DoublePointer vr, int ldvr,
                           int mm, IntPointer m );
public static native int LAPACKE_dtrevc( int matrix_layout, @Cast("char") byte side, @Cast("char") byte howmny,
                           IntBuffer select, int n,
                           @Const DoubleBuffer t, int ldt, DoubleBuffer vl,
                           int ldvl, DoubleBuffer vr, int ldvr,
                           int mm, IntBuffer m );
public static native int LAPACKE_dtrevc( int matrix_layout, @Cast("char") byte side, @Cast("char") byte howmny,
                           int[] select, int n,
                           @Const double[] t, int ldt, double[] vl,
                           int ldvl, double[] vr, int ldvr,
                           int mm, int[] m );
public static native int LAPACKE_ctrevc( int matrix_layout, @Cast("char") byte side, @Cast("char") byte howmny,
                           @Const IntPointer select, int n,
                           @Cast("lapack_complex_float*") FloatPointer t, int ldt,
                           @Cast("lapack_complex_float*") FloatPointer vl, int ldvl,
                           @Cast("lapack_complex_float*") FloatPointer vr, int ldvr,
                           int mm, IntPointer m );
public static native int LAPACKE_ctrevc( int matrix_layout, @Cast("char") byte side, @Cast("char") byte howmny,
                           @Const IntBuffer select, int n,
                           @Cast("lapack_complex_float*") FloatBuffer t, int ldt,
                           @Cast("lapack_complex_float*") FloatBuffer vl, int ldvl,
                           @Cast("lapack_complex_float*") FloatBuffer vr, int ldvr,
                           int mm, IntBuffer m );
public static native int LAPACKE_ctrevc( int matrix_layout, @Cast("char") byte side, @Cast("char") byte howmny,
                           @Const int[] select, int n,
                           @Cast("lapack_complex_float*") float[] t, int ldt,
                           @Cast("lapack_complex_float*") float[] vl, int ldvl,
                           @Cast("lapack_complex_float*") float[] vr, int ldvr,
                           int mm, int[] m );
public static native int LAPACKE_ztrevc( int matrix_layout, @Cast("char") byte side, @Cast("char") byte howmny,
                           @Const IntPointer select, int n,
                           @Cast("lapack_complex_double*") DoublePointer t, int ldt,
                           @Cast("lapack_complex_double*") DoublePointer vl, int ldvl,
                           @Cast("lapack_complex_double*") DoublePointer vr, int ldvr,
                           int mm, IntPointer m );
public static native int LAPACKE_ztrevc( int matrix_layout, @Cast("char") byte side, @Cast("char") byte howmny,
                           @Const IntBuffer select, int n,
                           @Cast("lapack_complex_double*") DoubleBuffer t, int ldt,
                           @Cast("lapack_complex_double*") DoubleBuffer vl, int ldvl,
                           @Cast("lapack_complex_double*") DoubleBuffer vr, int ldvr,
                           int mm, IntBuffer m );
public static native int LAPACKE_ztrevc( int matrix_layout, @Cast("char") byte side, @Cast("char") byte howmny,
                           @Const int[] select, int n,
                           @Cast("lapack_complex_double*") double[] t, int ldt,
                           @Cast("lapack_complex_double*") double[] vl, int ldvl,
                           @Cast("lapack_complex_double*") double[] vr, int ldvr,
                           int mm, int[] m );

public static native int LAPACKE_strexc( int matrix_layout, @Cast("char") byte compq, int n, FloatPointer t,
                           int ldt, FloatPointer q, int ldq,
                           IntPointer ifst, IntPointer ilst );
public static native int LAPACKE_strexc( int matrix_layout, @Cast("char") byte compq, int n, FloatBuffer t,
                           int ldt, FloatBuffer q, int ldq,
                           IntBuffer ifst, IntBuffer ilst );
public static native int LAPACKE_strexc( int matrix_layout, @Cast("char") byte compq, int n, float[] t,
                           int ldt, float[] q, int ldq,
                           int[] ifst, int[] ilst );
public static native int LAPACKE_dtrexc( int matrix_layout, @Cast("char") byte compq, int n,
                           DoublePointer t, int ldt, DoublePointer q, int ldq,
                           IntPointer ifst, IntPointer ilst );
public static native int LAPACKE_dtrexc( int matrix_layout, @Cast("char") byte compq, int n,
                           DoubleBuffer t, int ldt, DoubleBuffer q, int ldq,
                           IntBuffer ifst, IntBuffer ilst );
public static native int LAPACKE_dtrexc( int matrix_layout, @Cast("char") byte compq, int n,
                           double[] t, int ldt, double[] q, int ldq,
                           int[] ifst, int[] ilst );
public static native int LAPACKE_ctrexc( int matrix_layout, @Cast("char") byte compq, int n,
                           @Cast("lapack_complex_float*") FloatPointer t, int ldt,
                           @Cast("lapack_complex_float*") FloatPointer q, int ldq,
                           int ifst, int ilst );
public static native int LAPACKE_ctrexc( int matrix_layout, @Cast("char") byte compq, int n,
                           @Cast("lapack_complex_float*") FloatBuffer t, int ldt,
                           @Cast("lapack_complex_float*") FloatBuffer q, int ldq,
                           int ifst, int ilst );
public static native int LAPACKE_ctrexc( int matrix_layout, @Cast("char") byte compq, int n,
                           @Cast("lapack_complex_float*") float[] t, int ldt,
                           @Cast("lapack_complex_float*") float[] q, int ldq,
                           int ifst, int ilst );
public static native int LAPACKE_ztrexc( int matrix_layout, @Cast("char") byte compq, int n,
                           @Cast("lapack_complex_double*") DoublePointer t, int ldt,
                           @Cast("lapack_complex_double*") DoublePointer q, int ldq,
                           int ifst, int ilst );
public static native int LAPACKE_ztrexc( int matrix_layout, @Cast("char") byte compq, int n,
                           @Cast("lapack_complex_double*") DoubleBuffer t, int ldt,
                           @Cast("lapack_complex_double*") DoubleBuffer q, int ldq,
                           int ifst, int ilst );
public static native int LAPACKE_ztrexc( int matrix_layout, @Cast("char") byte compq, int n,
                           @Cast("lapack_complex_double*") double[] t, int ldt,
                           @Cast("lapack_complex_double*") double[] q, int ldq,
                           int ifst, int ilst );

public static native int LAPACKE_strrfs( int matrix_layout, @Cast("char") byte uplo, @Cast("char") byte trans, @Cast("char") byte diag,
                           int n, int nrhs, @Const FloatPointer a,
                           int lda, @Const FloatPointer b, int ldb,
                           @Const FloatPointer x, int ldx, FloatPointer ferr,
                           FloatPointer berr );
public static native int LAPACKE_strrfs( int matrix_layout, @Cast("char") byte uplo, @Cast("char") byte trans, @Cast("char") byte diag,
                           int n, int nrhs, @Const FloatBuffer a,
                           int lda, @Const FloatBuffer b, int ldb,
                           @Const FloatBuffer x, int ldx, FloatBuffer ferr,
                           FloatBuffer berr );
public static native int LAPACKE_strrfs( int matrix_layout, @Cast("char") byte uplo, @Cast("char") byte trans, @Cast("char") byte diag,
                           int n, int nrhs, @Const float[] a,
                           int lda, @Const float[] b, int ldb,
                           @Const float[] x, int ldx, float[] ferr,
                           float[] berr );
public static native int LAPACKE_dtrrfs( int matrix_layout, @Cast("char") byte uplo, @Cast("char") byte trans, @Cast("char") byte diag,
                           int n, int nrhs, @Const DoublePointer a,
                           int lda, @Const DoublePointer b, int ldb,
                           @Const DoublePointer x, int ldx, DoublePointer ferr,
                           DoublePointer berr );
public static native int LAPACKE_dtrrfs( int matrix_layout, @Cast("char") byte uplo, @Cast("char") byte trans, @Cast("char") byte diag,
                           int n, int nrhs, @Const DoubleBuffer a,
                           int lda, @Const DoubleBuffer b, int ldb,
                           @Const DoubleBuffer x, int ldx, DoubleBuffer ferr,
                           DoubleBuffer berr );
public static native int LAPACKE_dtrrfs( int matrix_layout, @Cast("char") byte uplo, @Cast("char") byte trans, @Cast("char") byte diag,
                           int n, int nrhs, @Const double[] a,
                           int lda, @Const double[] b, int ldb,
                           @Const double[] x, int ldx, double[] ferr,
                           double[] berr );
public static native int LAPACKE_ctrrfs( int matrix_layout, @Cast("char") byte uplo, @Cast("char") byte trans, @Cast("char") byte diag,
                           int n, int nrhs,
                           @Cast("const lapack_complex_float*") FloatPointer a, int lda,
                           @Cast("const lapack_complex_float*") FloatPointer b, int ldb,
                           @Cast("const lapack_complex_float*") FloatPointer x, int ldx,
                           FloatPointer ferr, FloatPointer berr );
public static native int LAPACKE_ctrrfs( int matrix_layout, @Cast("char") byte uplo, @Cast("char") byte trans, @Cast("char") byte diag,
                           int n, int nrhs,
                           @Cast("const lapack_complex_float*") FloatBuffer a, int lda,
                           @Cast("const lapack_complex_float*") FloatBuffer b, int ldb,
                           @Cast("const lapack_complex_float*") FloatBuffer x, int ldx,
                           FloatBuffer ferr, FloatBuffer berr );
public static native int LAPACKE_ctrrfs( int matrix_layout, @Cast("char") byte uplo, @Cast("char") byte trans, @Cast("char") byte diag,
                           int n, int nrhs,
                           @Cast("const lapack_complex_float*") float[] a, int lda,
                           @Cast("const lapack_complex_float*") float[] b, int ldb,
                           @Cast("const lapack_complex_float*") float[] x, int ldx,
                           float[] ferr, float[] berr );
public static native int LAPACKE_ztrrfs( int matrix_layout, @Cast("char") byte uplo, @Cast("char") byte trans, @Cast("char") byte diag,
                           int n, int nrhs,
                           @Cast("const lapack_complex_double*") DoublePointer a, int lda,
                           @Cast("const lapack_complex_double*") DoublePointer b, int ldb,
                           @Cast("const lapack_complex_double*") DoublePointer x, int ldx,
                           DoublePointer ferr, DoublePointer berr );
public static native int LAPACKE_ztrrfs( int matrix_layout, @Cast("char") byte uplo, @Cast("char") byte trans, @Cast("char") byte diag,
                           int n, int nrhs,
                           @Cast("const lapack_complex_double*") DoubleBuffer a, int lda,
                           @Cast("const lapack_complex_double*") DoubleBuffer b, int ldb,
                           @Cast("const lapack_complex_double*") DoubleBuffer x, int ldx,
                           DoubleBuffer ferr, DoubleBuffer berr );
public static native int LAPACKE_ztrrfs( int matrix_layout, @Cast("char") byte uplo, @Cast("char") byte trans, @Cast("char") byte diag,
                           int n, int nrhs,
                           @Cast("const lapack_complex_double*") double[] a, int lda,
                           @Cast("const lapack_complex_double*") double[] b, int ldb,
                           @Cast("const lapack_complex_double*") double[] x, int ldx,
                           double[] ferr, double[] berr );

public static native int LAPACKE_strsen( int matrix_layout, @Cast("char") byte job, @Cast("char") byte compq,
                           @Const IntPointer select, int n, FloatPointer t,
                           int ldt, FloatPointer q, int ldq, FloatPointer wr,
                           FloatPointer wi, IntPointer m, FloatPointer s, FloatPointer sep );
public static native int LAPACKE_strsen( int matrix_layout, @Cast("char") byte job, @Cast("char") byte compq,
                           @Const IntBuffer select, int n, FloatBuffer t,
                           int ldt, FloatBuffer q, int ldq, FloatBuffer wr,
                           FloatBuffer wi, IntBuffer m, FloatBuffer s, FloatBuffer sep );
public static native int LAPACKE_strsen( int matrix_layout, @Cast("char") byte job, @Cast("char") byte compq,
                           @Const int[] select, int n, float[] t,
                           int ldt, float[] q, int ldq, float[] wr,
                           float[] wi, int[] m, float[] s, float[] sep );
public static native int LAPACKE_dtrsen( int matrix_layout, @Cast("char") byte job, @Cast("char") byte compq,
                           @Const IntPointer select, int n,
                           DoublePointer t, int ldt, DoublePointer q, int ldq,
                           DoublePointer wr, DoublePointer wi, IntPointer m, DoublePointer s,
                           DoublePointer sep );
public static native int LAPACKE_dtrsen( int matrix_layout, @Cast("char") byte job, @Cast("char") byte compq,
                           @Const IntBuffer select, int n,
                           DoubleBuffer t, int ldt, DoubleBuffer q, int ldq,
                           DoubleBuffer wr, DoubleBuffer wi, IntBuffer m, DoubleBuffer s,
                           DoubleBuffer sep );
public static native int LAPACKE_dtrsen( int matrix_layout, @Cast("char") byte job, @Cast("char") byte compq,
                           @Const int[] select, int n,
                           double[] t, int ldt, double[] q, int ldq,
                           double[] wr, double[] wi, int[] m, double[] s,
                           double[] sep );
public static native int LAPACKE_ctrsen( int matrix_layout, @Cast("char") byte job, @Cast("char") byte compq,
                           @Const IntPointer select, int n,
                           @Cast("lapack_complex_float*") FloatPointer t, int ldt,
                           @Cast("lapack_complex_float*") FloatPointer q, int ldq,
                           @Cast("lapack_complex_float*") FloatPointer w, IntPointer m, FloatPointer s,
                           FloatPointer sep );
public static native int LAPACKE_ctrsen( int matrix_layout, @Cast("char") byte job, @Cast("char") byte compq,
                           @Const IntBuffer select, int n,
                           @Cast("lapack_complex_float*") FloatBuffer t, int ldt,
                           @Cast("lapack_complex_float*") FloatBuffer q, int ldq,
                           @Cast("lapack_complex_float*") FloatBuffer w, IntBuffer m, FloatBuffer s,
                           FloatBuffer sep );
public static native int LAPACKE_ctrsen( int matrix_layout, @Cast("char") byte job, @Cast("char") byte compq,
                           @Const int[] select, int n,
                           @Cast("lapack_complex_float*") float[] t, int ldt,
                           @Cast("lapack_complex_float*") float[] q, int ldq,
                           @Cast("lapack_complex_float*") float[] w, int[] m, float[] s,
                           float[] sep );
public static native int LAPACKE_ztrsen( int matrix_layout, @Cast("char") byte job, @Cast("char") byte compq,
                           @Const IntPointer select, int n,
                           @Cast("lapack_complex_double*") DoublePointer t, int ldt,
                           @Cast("lapack_complex_double*") DoublePointer q, int ldq,
                           @Cast("lapack_complex_double*") DoublePointer w, IntPointer m, DoublePointer s,
                           DoublePointer sep );
public static native int LAPACKE_ztrsen( int matrix_layout, @Cast("char") byte job, @Cast("char") byte compq,
                           @Const IntBuffer select, int n,
                           @Cast("lapack_complex_double*") DoubleBuffer t, int ldt,
                           @Cast("lapack_complex_double*") DoubleBuffer q, int ldq,
                           @Cast("lapack_complex_double*") DoubleBuffer w, IntBuffer m, DoubleBuffer s,
                           DoubleBuffer sep );
public static native int LAPACKE_ztrsen( int matrix_layout, @Cast("char") byte job, @Cast("char") byte compq,
                           @Const int[] select, int n,
                           @Cast("lapack_complex_double*") double[] t, int ldt,
                           @Cast("lapack_complex_double*") double[] q, int ldq,
                           @Cast("lapack_complex_double*") double[] w, int[] m, double[] s,
                           double[] sep );

public static native int LAPACKE_strsna( int matrix_layout, @Cast("char") byte job, @Cast("char") byte howmny,
                           @Const IntPointer select, int n,
                           @Const FloatPointer t, int ldt, @Const FloatPointer vl,
                           int ldvl, @Const FloatPointer vr, int ldvr,
                           FloatPointer s, FloatPointer sep, int mm, IntPointer m );
public static native int LAPACKE_strsna( int matrix_layout, @Cast("char") byte job, @Cast("char") byte howmny,
                           @Const IntBuffer select, int n,
                           @Const FloatBuffer t, int ldt, @Const FloatBuffer vl,
                           int ldvl, @Const FloatBuffer vr, int ldvr,
                           FloatBuffer s, FloatBuffer sep, int mm, IntBuffer m );
public static native int LAPACKE_strsna( int matrix_layout, @Cast("char") byte job, @Cast("char") byte howmny,
                           @Const int[] select, int n,
                           @Const float[] t, int ldt, @Const float[] vl,
                           int ldvl, @Const float[] vr, int ldvr,
                           float[] s, float[] sep, int mm, int[] m );
public static native int LAPACKE_dtrsna( int matrix_layout, @Cast("char") byte job, @Cast("char") byte howmny,
                           @Const IntPointer select, int n,
                           @Const DoublePointer t, int ldt, @Const DoublePointer vl,
                           int ldvl, @Const DoublePointer vr, int ldvr,
                           DoublePointer s, DoublePointer sep, int mm,
                           IntPointer m );
public static native int LAPACKE_dtrsna( int matrix_layout, @Cast("char") byte job, @Cast("char") byte howmny,
                           @Const IntBuffer select, int n,
                           @Const DoubleBuffer t, int ldt, @Const DoubleBuffer vl,
                           int ldvl, @Const DoubleBuffer vr, int ldvr,
                           DoubleBuffer s, DoubleBuffer sep, int mm,
                           IntBuffer m );
public static native int LAPACKE_dtrsna( int matrix_layout, @Cast("char") byte job, @Cast("char") byte howmny,
                           @Const int[] select, int n,
                           @Const double[] t, int ldt, @Const double[] vl,
                           int ldvl, @Const double[] vr, int ldvr,
                           double[] s, double[] sep, int mm,
                           int[] m );
public static native int LAPACKE_ctrsna( int matrix_layout, @Cast("char") byte job, @Cast("char") byte howmny,
                           @Const IntPointer select, int n,
                           @Cast("const lapack_complex_float*") FloatPointer t, int ldt,
                           @Cast("const lapack_complex_float*") FloatPointer vl, int ldvl,
                           @Cast("const lapack_complex_float*") FloatPointer vr, int ldvr,
                           FloatPointer s, FloatPointer sep, int mm, IntPointer m );
public static native int LAPACKE_ctrsna( int matrix_layout, @Cast("char") byte job, @Cast("char") byte howmny,
                           @Const IntBuffer select, int n,
                           @Cast("const lapack_complex_float*") FloatBuffer t, int ldt,
                           @Cast("const lapack_complex_float*") FloatBuffer vl, int ldvl,
                           @Cast("const lapack_complex_float*") FloatBuffer vr, int ldvr,
                           FloatBuffer s, FloatBuffer sep, int mm, IntBuffer m );
public static native int LAPACKE_ctrsna( int matrix_layout, @Cast("char") byte job, @Cast("char") byte howmny,
                           @Const int[] select, int n,
                           @Cast("const lapack_complex_float*") float[] t, int ldt,
                           @Cast("const lapack_complex_float*") float[] vl, int ldvl,
                           @Cast("const lapack_complex_float*") float[] vr, int ldvr,
                           float[] s, float[] sep, int mm, int[] m );
public static native int LAPACKE_ztrsna( int matrix_layout, @Cast("char") byte job, @Cast("char") byte howmny,
                           @Const IntPointer select, int n,
                           @Cast("const lapack_complex_double*") DoublePointer t, int ldt,
                           @Cast("const lapack_complex_double*") DoublePointer vl, int ldvl,
                           @Cast("const lapack_complex_double*") DoublePointer vr, int ldvr,
                           DoublePointer s, DoublePointer sep, int mm,
                           IntPointer m );
public static native int LAPACKE_ztrsna( int matrix_layout, @Cast("char") byte job, @Cast("char") byte howmny,
                           @Const IntBuffer select, int n,
                           @Cast("const lapack_complex_double*") DoubleBuffer t, int ldt,
                           @Cast("const lapack_complex_double*") DoubleBuffer vl, int ldvl,
                           @Cast("const lapack_complex_double*") DoubleBuffer vr, int ldvr,
                           DoubleBuffer s, DoubleBuffer sep, int mm,
                           IntBuffer m );
public static native int LAPACKE_ztrsna( int matrix_layout, @Cast("char") byte job, @Cast("char") byte howmny,
                           @Const int[] select, int n,
                           @Cast("const lapack_complex_double*") double[] t, int ldt,
                           @Cast("const lapack_complex_double*") double[] vl, int ldvl,
                           @Cast("const lapack_complex_double*") double[] vr, int ldvr,
                           double[] s, double[] sep, int mm,
                           int[] m );

public static native int LAPACKE_strsyl( int matrix_layout, @Cast("char") byte trana, @Cast("char") byte tranb,
                           int isgn, int m, int n,
                           @Const FloatPointer a, int lda, @Const FloatPointer b,
                           int ldb, FloatPointer c, int ldc,
                           FloatPointer scale );
public static native int LAPACKE_strsyl( int matrix_layout, @Cast("char") byte trana, @Cast("char") byte tranb,
                           int isgn, int m, int n,
                           @Const FloatBuffer a, int lda, @Const FloatBuffer b,
                           int ldb, FloatBuffer c, int ldc,
                           FloatBuffer scale );
public static native int LAPACKE_strsyl( int matrix_layout, @Cast("char") byte trana, @Cast("char") byte tranb,
                           int isgn, int m, int n,
                           @Const float[] a, int lda, @Const float[] b,
                           int ldb, float[] c, int ldc,
                           float[] scale );
public static native int LAPACKE_dtrsyl( int matrix_layout, @Cast("char") byte trana, @Cast("char") byte tranb,
                           int isgn, int m, int n,
                           @Const DoublePointer a, int lda, @Const DoublePointer b,
                           int ldb, DoublePointer c, int ldc,
                           DoublePointer scale );
public static native int LAPACKE_dtrsyl( int matrix_layout, @Cast("char") byte trana, @Cast("char") byte tranb,
                           int isgn, int m, int n,
                           @Const DoubleBuffer a, int lda, @Const DoubleBuffer b,
                           int ldb, DoubleBuffer c, int ldc,
                           DoubleBuffer scale );
public static native int LAPACKE_dtrsyl( int matrix_layout, @Cast("char") byte trana, @Cast("char") byte tranb,
                           int isgn, int m, int n,
                           @Const double[] a, int lda, @Const double[] b,
                           int ldb, double[] c, int ldc,
                           double[] scale );
public static native int LAPACKE_ctrsyl( int matrix_layout, @Cast("char") byte trana, @Cast("char") byte tranb,
                           int isgn, int m, int n,
                           @Cast("const lapack_complex_float*") FloatPointer a, int lda,
                           @Cast("const lapack_complex_float*") FloatPointer b, int ldb,
                           @Cast("lapack_complex_float*") FloatPointer c, int ldc,
                           FloatPointer scale );
public static native int LAPACKE_ctrsyl( int matrix_layout, @Cast("char") byte trana, @Cast("char") byte tranb,
                           int isgn, int m, int n,
                           @Cast("const lapack_complex_float*") FloatBuffer a, int lda,
                           @Cast("const lapack_complex_float*") FloatBuffer b, int ldb,
                           @Cast("lapack_complex_float*") FloatBuffer c, int ldc,
                           FloatBuffer scale );
public static native int LAPACKE_ctrsyl( int matrix_layout, @Cast("char") byte trana, @Cast("char") byte tranb,
                           int isgn, int m, int n,
                           @Cast("const lapack_complex_float*") float[] a, int lda,
                           @Cast("const lapack_complex_float*") float[] b, int ldb,
                           @Cast("lapack_complex_float*") float[] c, int ldc,
                           float[] scale );
public static native int LAPACKE_ztrsyl( int matrix_layout, @Cast("char") byte trana, @Cast("char") byte tranb,
                           int isgn, int m, int n,
                           @Cast("const lapack_complex_double*") DoublePointer a, int lda,
                           @Cast("const lapack_complex_double*") DoublePointer b, int ldb,
                           @Cast("lapack_complex_double*") DoublePointer c, int ldc,
                           DoublePointer scale );
public static native int LAPACKE_ztrsyl( int matrix_layout, @Cast("char") byte trana, @Cast("char") byte tranb,
                           int isgn, int m, int n,
                           @Cast("const lapack_complex_double*") DoubleBuffer a, int lda,
                           @Cast("const lapack_complex_double*") DoubleBuffer b, int ldb,
                           @Cast("lapack_complex_double*") DoubleBuffer c, int ldc,
                           DoubleBuffer scale );
public static native int LAPACKE_ztrsyl( int matrix_layout, @Cast("char") byte trana, @Cast("char") byte tranb,
                           int isgn, int m, int n,
                           @Cast("const lapack_complex_double*") double[] a, int lda,
                           @Cast("const lapack_complex_double*") double[] b, int ldb,
                           @Cast("lapack_complex_double*") double[] c, int ldc,
                           double[] scale );

public static native int LAPACKE_strtri( int matrix_layout, @Cast("char") byte uplo, @Cast("char") byte diag, int n,
                           FloatPointer a, int lda );
public static native int LAPACKE_strtri( int matrix_layout, @Cast("char") byte uplo, @Cast("char") byte diag, int n,
                           FloatBuffer a, int lda );
public static native int LAPACKE_strtri( int matrix_layout, @Cast("char") byte uplo, @Cast("char") byte diag, int n,
                           float[] a, int lda );
public static native int LAPACKE_dtrtri( int matrix_layout, @Cast("char") byte uplo, @Cast("char") byte diag, int n,
                           DoublePointer a, int lda );
public static native int LAPACKE_dtrtri( int matrix_layout, @Cast("char") byte uplo, @Cast("char") byte diag, int n,
                           DoubleBuffer a, int lda );
public static native int LAPACKE_dtrtri( int matrix_layout, @Cast("char") byte uplo, @Cast("char") byte diag, int n,
                           double[] a, int lda );
public static native int LAPACKE_ctrtri( int matrix_layout, @Cast("char") byte uplo, @Cast("char") byte diag, int n,
                           @Cast("lapack_complex_float*") FloatPointer a, int lda );
public static native int LAPACKE_ctrtri( int matrix_layout, @Cast("char") byte uplo, @Cast("char") byte diag, int n,
                           @Cast("lapack_complex_float*") FloatBuffer a, int lda );
public static native int LAPACKE_ctrtri( int matrix_layout, @Cast("char") byte uplo, @Cast("char") byte diag, int n,
                           @Cast("lapack_complex_float*") float[] a, int lda );
public static native int LAPACKE_ztrtri( int matrix_layout, @Cast("char") byte uplo, @Cast("char") byte diag, int n,
                           @Cast("lapack_complex_double*") DoublePointer a, int lda );
public static native int LAPACKE_ztrtri( int matrix_layout, @Cast("char") byte uplo, @Cast("char") byte diag, int n,
                           @Cast("lapack_complex_double*") DoubleBuffer a, int lda );
public static native int LAPACKE_ztrtri( int matrix_layout, @Cast("char") byte uplo, @Cast("char") byte diag, int n,
                           @Cast("lapack_complex_double*") double[] a, int lda );

public static native int LAPACKE_strtrs( int matrix_layout, @Cast("char") byte uplo, @Cast("char") byte trans, @Cast("char") byte diag,
                           int n, int nrhs, @Const FloatPointer a,
                           int lda, FloatPointer b, int ldb );
public static native int LAPACKE_strtrs( int matrix_layout, @Cast("char") byte uplo, @Cast("char") byte trans, @Cast("char") byte diag,
                           int n, int nrhs, @Const FloatBuffer a,
                           int lda, FloatBuffer b, int ldb );
public static native int LAPACKE_strtrs( int matrix_layout, @Cast("char") byte uplo, @Cast("char") byte trans, @Cast("char") byte diag,
                           int n, int nrhs, @Const float[] a,
                           int lda, float[] b, int ldb );
public static native int LAPACKE_dtrtrs( int matrix_layout, @Cast("char") byte uplo, @Cast("char") byte trans, @Cast("char") byte diag,
                           int n, int nrhs, @Const DoublePointer a,
                           int lda, DoublePointer b, int ldb );
public static native int LAPACKE_dtrtrs( int matrix_layout, @Cast("char") byte uplo, @Cast("char") byte trans, @Cast("char") byte diag,
                           int n, int nrhs, @Const DoubleBuffer a,
                           int lda, DoubleBuffer b, int ldb );
public static native int LAPACKE_dtrtrs( int matrix_layout, @Cast("char") byte uplo, @Cast("char") byte trans, @Cast("char") byte diag,
                           int n, int nrhs, @Const double[] a,
                           int lda, double[] b, int ldb );
public static native int LAPACKE_ctrtrs( int matrix_layout, @Cast("char") byte uplo, @Cast("char") byte trans, @Cast("char") byte diag,
                           int n, int nrhs,
                           @Cast("const lapack_complex_float*") FloatPointer a, int lda,
                           @Cast("lapack_complex_float*") FloatPointer b, int ldb );
public static native int LAPACKE_ctrtrs( int matrix_layout, @Cast("char") byte uplo, @Cast("char") byte trans, @Cast("char") byte diag,
                           int n, int nrhs,
                           @Cast("const lapack_complex_float*") FloatBuffer a, int lda,
                           @Cast("lapack_complex_float*") FloatBuffer b, int ldb );
public static native int LAPACKE_ctrtrs( int matrix_layout, @Cast("char") byte uplo, @Cast("char") byte trans, @Cast("char") byte diag,
                           int n, int nrhs,
                           @Cast("const lapack_complex_float*") float[] a, int lda,
                           @Cast("lapack_complex_float*") float[] b, int ldb );
public static native int LAPACKE_ztrtrs( int matrix_layout, @Cast("char") byte uplo, @Cast("char") byte trans, @Cast("char") byte diag,
                           int n, int nrhs,
                           @Cast("const lapack_complex_double*") DoublePointer a, int lda,
                           @Cast("lapack_complex_double*") DoublePointer b, int ldb );
public static native int LAPACKE_ztrtrs( int matrix_layout, @Cast("char") byte uplo, @Cast("char") byte trans, @Cast("char") byte diag,
                           int n, int nrhs,
                           @Cast("const lapack_complex_double*") DoubleBuffer a, int lda,
                           @Cast("lapack_complex_double*") DoubleBuffer b, int ldb );
public static native int LAPACKE_ztrtrs( int matrix_layout, @Cast("char") byte uplo, @Cast("char") byte trans, @Cast("char") byte diag,
                           int n, int nrhs,
                           @Cast("const lapack_complex_double*") double[] a, int lda,
                           @Cast("lapack_complex_double*") double[] b, int ldb );

public static native int LAPACKE_strttf( int matrix_layout, @Cast("char") byte transr, @Cast("char") byte uplo,
                           int n, @Const FloatPointer a, int lda,
                           FloatPointer arf );
public static native int LAPACKE_strttf( int matrix_layout, @Cast("char") byte transr, @Cast("char") byte uplo,
                           int n, @Const FloatBuffer a, int lda,
                           FloatBuffer arf );
public static native int LAPACKE_strttf( int matrix_layout, @Cast("char") byte transr, @Cast("char") byte uplo,
                           int n, @Const float[] a, int lda,
                           float[] arf );
public static native int LAPACKE_dtrttf( int matrix_layout, @Cast("char") byte transr, @Cast("char") byte uplo,
                           int n, @Const DoublePointer a, int lda,
                           DoublePointer arf );
public static native int LAPACKE_dtrttf( int matrix_layout, @Cast("char") byte transr, @Cast("char") byte uplo,
                           int n, @Const DoubleBuffer a, int lda,
                           DoubleBuffer arf );
public static native int LAPACKE_dtrttf( int matrix_layout, @Cast("char") byte transr, @Cast("char") byte uplo,
                           int n, @Const double[] a, int lda,
                           double[] arf );
public static native int LAPACKE_ctrttf( int matrix_layout, @Cast("char") byte transr, @Cast("char") byte uplo,
                           int n, @Cast("const lapack_complex_float*") FloatPointer a,
                           int lda, @Cast("lapack_complex_float*") FloatPointer arf );
public static native int LAPACKE_ctrttf( int matrix_layout, @Cast("char") byte transr, @Cast("char") byte uplo,
                           int n, @Cast("const lapack_complex_float*") FloatBuffer a,
                           int lda, @Cast("lapack_complex_float*") FloatBuffer arf );
public static native int LAPACKE_ctrttf( int matrix_layout, @Cast("char") byte transr, @Cast("char") byte uplo,
                           int n, @Cast("const lapack_complex_float*") float[] a,
                           int lda, @Cast("lapack_complex_float*") float[] arf );
public static native int LAPACKE_ztrttf( int matrix_layout, @Cast("char") byte transr, @Cast("char") byte uplo,
                           int n, @Cast("const lapack_complex_double*") DoublePointer a,
                           int lda, @Cast("lapack_complex_double*") DoublePointer arf );
public static native int LAPACKE_ztrttf( int matrix_layout, @Cast("char") byte transr, @Cast("char") byte uplo,
                           int n, @Cast("const lapack_complex_double*") DoubleBuffer a,
                           int lda, @Cast("lapack_complex_double*") DoubleBuffer arf );
public static native int LAPACKE_ztrttf( int matrix_layout, @Cast("char") byte transr, @Cast("char") byte uplo,
                           int n, @Cast("const lapack_complex_double*") double[] a,
                           int lda, @Cast("lapack_complex_double*") double[] arf );

public static native int LAPACKE_strttp( int matrix_layout, @Cast("char") byte uplo, int n,
                           @Const FloatPointer a, int lda, FloatPointer ap );
public static native int LAPACKE_strttp( int matrix_layout, @Cast("char") byte uplo, int n,
                           @Const FloatBuffer a, int lda, FloatBuffer ap );
public static native int LAPACKE_strttp( int matrix_layout, @Cast("char") byte uplo, int n,
                           @Const float[] a, int lda, float[] ap );
public static native int LAPACKE_dtrttp( int matrix_layout, @Cast("char") byte uplo, int n,
                           @Const DoublePointer a, int lda, DoublePointer ap );
public static native int LAPACKE_dtrttp( int matrix_layout, @Cast("char") byte uplo, int n,
                           @Const DoubleBuffer a, int lda, DoubleBuffer ap );
public static native int LAPACKE_dtrttp( int matrix_layout, @Cast("char") byte uplo, int n,
                           @Const double[] a, int lda, double[] ap );
public static native int LAPACKE_ctrttp( int matrix_layout, @Cast("char") byte uplo, int n,
                           @Cast("const lapack_complex_float*") FloatPointer a, int lda,
                           @Cast("lapack_complex_float*") FloatPointer ap );
public static native int LAPACKE_ctrttp( int matrix_layout, @Cast("char") byte uplo, int n,
                           @Cast("const lapack_complex_float*") FloatBuffer a, int lda,
                           @Cast("lapack_complex_float*") FloatBuffer ap );
public static native int LAPACKE_ctrttp( int matrix_layout, @Cast("char") byte uplo, int n,
                           @Cast("const lapack_complex_float*") float[] a, int lda,
                           @Cast("lapack_complex_float*") float[] ap );
public static native int LAPACKE_ztrttp( int matrix_layout, @Cast("char") byte uplo, int n,
                           @Cast("const lapack_complex_double*") DoublePointer a, int lda,
                           @Cast("lapack_complex_double*") DoublePointer ap );
public static native int LAPACKE_ztrttp( int matrix_layout, @Cast("char") byte uplo, int n,
                           @Cast("const lapack_complex_double*") DoubleBuffer a, int lda,
                           @Cast("lapack_complex_double*") DoubleBuffer ap );
public static native int LAPACKE_ztrttp( int matrix_layout, @Cast("char") byte uplo, int n,
                           @Cast("const lapack_complex_double*") double[] a, int lda,
                           @Cast("lapack_complex_double*") double[] ap );

public static native int LAPACKE_stzrzf( int matrix_layout, int m, int n,
                           FloatPointer a, int lda, FloatPointer tau );
public static native int LAPACKE_stzrzf( int matrix_layout, int m, int n,
                           FloatBuffer a, int lda, FloatBuffer tau );
public static native int LAPACKE_stzrzf( int matrix_layout, int m, int n,
                           float[] a, int lda, float[] tau );
public static native int LAPACKE_dtzrzf( int matrix_layout, int m, int n,
                           DoublePointer a, int lda, DoublePointer tau );
public static native int LAPACKE_dtzrzf( int matrix_layout, int m, int n,
                           DoubleBuffer a, int lda, DoubleBuffer tau );
public static native int LAPACKE_dtzrzf( int matrix_layout, int m, int n,
                           double[] a, int lda, double[] tau );
public static native int LAPACKE_ctzrzf( int matrix_layout, int m, int n,
                           @Cast("lapack_complex_float*") FloatPointer a, int lda,
                           @Cast("lapack_complex_float*") FloatPointer tau );
public static native int LAPACKE_ctzrzf( int matrix_layout, int m, int n,
                           @Cast("lapack_complex_float*") FloatBuffer a, int lda,
                           @Cast("lapack_complex_float*") FloatBuffer tau );
public static native int LAPACKE_ctzrzf( int matrix_layout, int m, int n,
                           @Cast("lapack_complex_float*") float[] a, int lda,
                           @Cast("lapack_complex_float*") float[] tau );
public static native int LAPACKE_ztzrzf( int matrix_layout, int m, int n,
                           @Cast("lapack_complex_double*") DoublePointer a, int lda,
                           @Cast("lapack_complex_double*") DoublePointer tau );
public static native int LAPACKE_ztzrzf( int matrix_layout, int m, int n,
                           @Cast("lapack_complex_double*") DoubleBuffer a, int lda,
                           @Cast("lapack_complex_double*") DoubleBuffer tau );
public static native int LAPACKE_ztzrzf( int matrix_layout, int m, int n,
                           @Cast("lapack_complex_double*") double[] a, int lda,
                           @Cast("lapack_complex_double*") double[] tau );

public static native int LAPACKE_cungbr( int matrix_layout, @Cast("char") byte vect, int m,
                           int n, int k, @Cast("lapack_complex_float*") FloatPointer a,
                           int lda, @Cast("const lapack_complex_float*") FloatPointer tau );
public static native int LAPACKE_cungbr( int matrix_layout, @Cast("char") byte vect, int m,
                           int n, int k, @Cast("lapack_complex_float*") FloatBuffer a,
                           int lda, @Cast("const lapack_complex_float*") FloatBuffer tau );
public static native int LAPACKE_cungbr( int matrix_layout, @Cast("char") byte vect, int m,
                           int n, int k, @Cast("lapack_complex_float*") float[] a,
                           int lda, @Cast("const lapack_complex_float*") float[] tau );
public static native int LAPACKE_zungbr( int matrix_layout, @Cast("char") byte vect, int m,
                           int n, int k, @Cast("lapack_complex_double*") DoublePointer a,
                           int lda, @Cast("const lapack_complex_double*") DoublePointer tau );
public static native int LAPACKE_zungbr( int matrix_layout, @Cast("char") byte vect, int m,
                           int n, int k, @Cast("lapack_complex_double*") DoubleBuffer a,
                           int lda, @Cast("const lapack_complex_double*") DoubleBuffer tau );
public static native int LAPACKE_zungbr( int matrix_layout, @Cast("char") byte vect, int m,
                           int n, int k, @Cast("lapack_complex_double*") double[] a,
                           int lda, @Cast("const lapack_complex_double*") double[] tau );

public static native int LAPACKE_cunghr( int matrix_layout, int n, int ilo,
                           int ihi, @Cast("lapack_complex_float*") FloatPointer a,
                           int lda, @Cast("const lapack_complex_float*") FloatPointer tau );
public static native int LAPACKE_cunghr( int matrix_layout, int n, int ilo,
                           int ihi, @Cast("lapack_complex_float*") FloatBuffer a,
                           int lda, @Cast("const lapack_complex_float*") FloatBuffer tau );
public static native int LAPACKE_cunghr( int matrix_layout, int n, int ilo,
                           int ihi, @Cast("lapack_complex_float*") float[] a,
                           int lda, @Cast("const lapack_complex_float*") float[] tau );
public static native int LAPACKE_zunghr( int matrix_layout, int n, int ilo,
                           int ihi, @Cast("lapack_complex_double*") DoublePointer a,
                           int lda, @Cast("const lapack_complex_double*") DoublePointer tau );
public static native int LAPACKE_zunghr( int matrix_layout, int n, int ilo,
                           int ihi, @Cast("lapack_complex_double*") DoubleBuffer a,
                           int lda, @Cast("const lapack_complex_double*") DoubleBuffer tau );
public static native int LAPACKE_zunghr( int matrix_layout, int n, int ilo,
                           int ihi, @Cast("lapack_complex_double*") double[] a,
                           int lda, @Cast("const lapack_complex_double*") double[] tau );

public static native int LAPACKE_cunglq( int matrix_layout, int m, int n,
                           int k, @Cast("lapack_complex_float*") FloatPointer a,
                           int lda, @Cast("const lapack_complex_float*") FloatPointer tau );
public static native int LAPACKE_cunglq( int matrix_layout, int m, int n,
                           int k, @Cast("lapack_complex_float*") FloatBuffer a,
                           int lda, @Cast("const lapack_complex_float*") FloatBuffer tau );
public static native int LAPACKE_cunglq( int matrix_layout, int m, int n,
                           int k, @Cast("lapack_complex_float*") float[] a,
                           int lda, @Cast("const lapack_complex_float*") float[] tau );
public static native int LAPACKE_zunglq( int matrix_layout, int m, int n,
                           int k, @Cast("lapack_complex_double*") DoublePointer a,
                           int lda, @Cast("const lapack_complex_double*") DoublePointer tau );
public static native int LAPACKE_zunglq( int matrix_layout, int m, int n,
                           int k, @Cast("lapack_complex_double*") DoubleBuffer a,
                           int lda, @Cast("const lapack_complex_double*") DoubleBuffer tau );
public static native int LAPACKE_zunglq( int matrix_layout, int m, int n,
                           int k, @Cast("lapack_complex_double*") double[] a,
                           int lda, @Cast("const lapack_complex_double*") double[] tau );

public static native int LAPACKE_cungql( int matrix_layout, int m, int n,
                           int k, @Cast("lapack_complex_float*") FloatPointer a,
                           int lda, @Cast("const lapack_complex_float*") FloatPointer tau );
public static native int LAPACKE_cungql( int matrix_layout, int m, int n,
                           int k, @Cast("lapack_complex_float*") FloatBuffer a,
                           int lda, @Cast("const lapack_complex_float*") FloatBuffer tau );
public static native int LAPACKE_cungql( int matrix_layout, int m, int n,
                           int k, @Cast("lapack_complex_float*") float[] a,
                           int lda, @Cast("const lapack_complex_float*") float[] tau );
public static native int LAPACKE_zungql( int matrix_layout, int m, int n,
                           int k, @Cast("lapack_complex_double*") DoublePointer a,
                           int lda, @Cast("const lapack_complex_double*") DoublePointer tau );
public static native int LAPACKE_zungql( int matrix_layout, int m, int n,
                           int k, @Cast("lapack_complex_double*") DoubleBuffer a,
                           int lda, @Cast("const lapack_complex_double*") DoubleBuffer tau );
public static native int LAPACKE_zungql( int matrix_layout, int m, int n,
                           int k, @Cast("lapack_complex_double*") double[] a,
                           int lda, @Cast("const lapack_complex_double*") double[] tau );

public static native int LAPACKE_cungqr( int matrix_layout, int m, int n,
                           int k, @Cast("lapack_complex_float*") FloatPointer a,
                           int lda, @Cast("const lapack_complex_float*") FloatPointer tau );
public static native int LAPACKE_cungqr( int matrix_layout, int m, int n,
                           int k, @Cast("lapack_complex_float*") FloatBuffer a,
                           int lda, @Cast("const lapack_complex_float*") FloatBuffer tau );
public static native int LAPACKE_cungqr( int matrix_layout, int m, int n,
                           int k, @Cast("lapack_complex_float*") float[] a,
                           int lda, @Cast("const lapack_complex_float*") float[] tau );
public static native int LAPACKE_zungqr( int matrix_layout, int m, int n,
                           int k, @Cast("lapack_complex_double*") DoublePointer a,
                           int lda, @Cast("const lapack_complex_double*") DoublePointer tau );
public static native int LAPACKE_zungqr( int matrix_layout, int m, int n,
                           int k, @Cast("lapack_complex_double*") DoubleBuffer a,
                           int lda, @Cast("const lapack_complex_double*") DoubleBuffer tau );
public static native int LAPACKE_zungqr( int matrix_layout, int m, int n,
                           int k, @Cast("lapack_complex_double*") double[] a,
                           int lda, @Cast("const lapack_complex_double*") double[] tau );

public static native int LAPACKE_cungrq( int matrix_layout, int m, int n,
                           int k, @Cast("lapack_complex_float*") FloatPointer a,
                           int lda, @Cast("const lapack_complex_float*") FloatPointer tau );
public static native int LAPACKE_cungrq( int matrix_layout, int m, int n,
                           int k, @Cast("lapack_complex_float*") FloatBuffer a,
                           int lda, @Cast("const lapack_complex_float*") FloatBuffer tau );
public static native int LAPACKE_cungrq( int matrix_layout, int m, int n,
                           int k, @Cast("lapack_complex_float*") float[] a,
                           int lda, @Cast("const lapack_complex_float*") float[] tau );
public static native int LAPACKE_zungrq( int matrix_layout, int m, int n,
                           int k, @Cast("lapack_complex_double*") DoublePointer a,
                           int lda, @Cast("const lapack_complex_double*") DoublePointer tau );
public static native int LAPACKE_zungrq( int matrix_layout, int m, int n,
                           int k, @Cast("lapack_complex_double*") DoubleBuffer a,
                           int lda, @Cast("const lapack_complex_double*") DoubleBuffer tau );
public static native int LAPACKE_zungrq( int matrix_layout, int m, int n,
                           int k, @Cast("lapack_complex_double*") double[] a,
                           int lda, @Cast("const lapack_complex_double*") double[] tau );

public static native int LAPACKE_cungtr( int matrix_layout, @Cast("char") byte uplo, int n,
                           @Cast("lapack_complex_float*") FloatPointer a, int lda,
                           @Cast("const lapack_complex_float*") FloatPointer tau );
public static native int LAPACKE_cungtr( int matrix_layout, @Cast("char") byte uplo, int n,
                           @Cast("lapack_complex_float*") FloatBuffer a, int lda,
                           @Cast("const lapack_complex_float*") FloatBuffer tau );
public static native int LAPACKE_cungtr( int matrix_layout, @Cast("char") byte uplo, int n,
                           @Cast("lapack_complex_float*") float[] a, int lda,
                           @Cast("const lapack_complex_float*") float[] tau );
public static native int LAPACKE_zungtr( int matrix_layout, @Cast("char") byte uplo, int n,
                           @Cast("lapack_complex_double*") DoublePointer a, int lda,
                           @Cast("const lapack_complex_double*") DoublePointer tau );
public static native int LAPACKE_zungtr( int matrix_layout, @Cast("char") byte uplo, int n,
                           @Cast("lapack_complex_double*") DoubleBuffer a, int lda,
                           @Cast("const lapack_complex_double*") DoubleBuffer tau );
public static native int LAPACKE_zungtr( int matrix_layout, @Cast("char") byte uplo, int n,
                           @Cast("lapack_complex_double*") double[] a, int lda,
                           @Cast("const lapack_complex_double*") double[] tau );

public static native int LAPACKE_cunmbr( int matrix_layout, @Cast("char") byte vect, @Cast("char") byte side, @Cast("char") byte trans,
                           int m, int n, int k,
                           @Cast("const lapack_complex_float*") FloatPointer a, int lda,
                           @Cast("const lapack_complex_float*") FloatPointer tau,
                           @Cast("lapack_complex_float*") FloatPointer c, int ldc );
public static native int LAPACKE_cunmbr( int matrix_layout, @Cast("char") byte vect, @Cast("char") byte side, @Cast("char") byte trans,
                           int m, int n, int k,
                           @Cast("const lapack_complex_float*") FloatBuffer a, int lda,
                           @Cast("const lapack_complex_float*") FloatBuffer tau,
                           @Cast("lapack_complex_float*") FloatBuffer c, int ldc );
public static native int LAPACKE_cunmbr( int matrix_layout, @Cast("char") byte vect, @Cast("char") byte side, @Cast("char") byte trans,
                           int m, int n, int k,
                           @Cast("const lapack_complex_float*") float[] a, int lda,
                           @Cast("const lapack_complex_float*") float[] tau,
                           @Cast("lapack_complex_float*") float[] c, int ldc );
public static native int LAPACKE_zunmbr( int matrix_layout, @Cast("char") byte vect, @Cast("char") byte side, @Cast("char") byte trans,
                           int m, int n, int k,
                           @Cast("const lapack_complex_double*") DoublePointer a, int lda,
                           @Cast("const lapack_complex_double*") DoublePointer tau,
                           @Cast("lapack_complex_double*") DoublePointer c, int ldc );
public static native int LAPACKE_zunmbr( int matrix_layout, @Cast("char") byte vect, @Cast("char") byte side, @Cast("char") byte trans,
                           int m, int n, int k,
                           @Cast("const lapack_complex_double*") DoubleBuffer a, int lda,
                           @Cast("const lapack_complex_double*") DoubleBuffer tau,
                           @Cast("lapack_complex_double*") DoubleBuffer c, int ldc );
public static native int LAPACKE_zunmbr( int matrix_layout, @Cast("char") byte vect, @Cast("char") byte side, @Cast("char") byte trans,
                           int m, int n, int k,
                           @Cast("const lapack_complex_double*") double[] a, int lda,
                           @Cast("const lapack_complex_double*") double[] tau,
                           @Cast("lapack_complex_double*") double[] c, int ldc );

public static native int LAPACKE_cunmhr( int matrix_layout, @Cast("char") byte side, @Cast("char") byte trans,
                           int m, int n, int ilo,
                           int ihi, @Cast("const lapack_complex_float*") FloatPointer a,
                           int lda, @Cast("const lapack_complex_float*") FloatPointer tau,
                           @Cast("lapack_complex_float*") FloatPointer c, int ldc );
public static native int LAPACKE_cunmhr( int matrix_layout, @Cast("char") byte side, @Cast("char") byte trans,
                           int m, int n, int ilo,
                           int ihi, @Cast("const lapack_complex_float*") FloatBuffer a,
                           int lda, @Cast("const lapack_complex_float*") FloatBuffer tau,
                           @Cast("lapack_complex_float*") FloatBuffer c, int ldc );
public static native int LAPACKE_cunmhr( int matrix_layout, @Cast("char") byte side, @Cast("char") byte trans,
                           int m, int n, int ilo,
                           int ihi, @Cast("const lapack_complex_float*") float[] a,
                           int lda, @Cast("const lapack_complex_float*") float[] tau,
                           @Cast("lapack_complex_float*") float[] c, int ldc );
public static native int LAPACKE_zunmhr( int matrix_layout, @Cast("char") byte side, @Cast("char") byte trans,
                           int m, int n, int ilo,
                           int ihi, @Cast("const lapack_complex_double*") DoublePointer a,
                           int lda, @Cast("const lapack_complex_double*") DoublePointer tau,
                           @Cast("lapack_complex_double*") DoublePointer c, int ldc );
public static native int LAPACKE_zunmhr( int matrix_layout, @Cast("char") byte side, @Cast("char") byte trans,
                           int m, int n, int ilo,
                           int ihi, @Cast("const lapack_complex_double*") DoubleBuffer a,
                           int lda, @Cast("const lapack_complex_double*") DoubleBuffer tau,
                           @Cast("lapack_complex_double*") DoubleBuffer c, int ldc );
public static native int LAPACKE_zunmhr( int matrix_layout, @Cast("char") byte side, @Cast("char") byte trans,
                           int m, int n, int ilo,
                           int ihi, @Cast("const lapack_complex_double*") double[] a,
                           int lda, @Cast("const lapack_complex_double*") double[] tau,
                           @Cast("lapack_complex_double*") double[] c, int ldc );

public static native int LAPACKE_cunmlq( int matrix_layout, @Cast("char") byte side, @Cast("char") byte trans,
                           int m, int n, int k,
                           @Cast("const lapack_complex_float*") FloatPointer a, int lda,
                           @Cast("const lapack_complex_float*") FloatPointer tau,
                           @Cast("lapack_complex_float*") FloatPointer c, int ldc );
public static native int LAPACKE_cunmlq( int matrix_layout, @Cast("char") byte side, @Cast("char") byte trans,
                           int m, int n, int k,
                           @Cast("const lapack_complex_float*") FloatBuffer a, int lda,
                           @Cast("const lapack_complex_float*") FloatBuffer tau,
                           @Cast("lapack_complex_float*") FloatBuffer c, int ldc );
public static native int LAPACKE_cunmlq( int matrix_layout, @Cast("char") byte side, @Cast("char") byte trans,
                           int m, int n, int k,
                           @Cast("const lapack_complex_float*") float[] a, int lda,
                           @Cast("const lapack_complex_float*") float[] tau,
                           @Cast("lapack_complex_float*") float[] c, int ldc );
public static native int LAPACKE_zunmlq( int matrix_layout, @Cast("char") byte side, @Cast("char") byte trans,
                           int m, int n, int k,
                           @Cast("const lapack_complex_double*") DoublePointer a, int lda,
                           @Cast("const lapack_complex_double*") DoublePointer tau,
                           @Cast("lapack_complex_double*") DoublePointer c, int ldc );
public static native int LAPACKE_zunmlq( int matrix_layout, @Cast("char") byte side, @Cast("char") byte trans,
                           int m, int n, int k,
                           @Cast("const lapack_complex_double*") DoubleBuffer a, int lda,
                           @Cast("const lapack_complex_double*") DoubleBuffer tau,
                           @Cast("lapack_complex_double*") DoubleBuffer c, int ldc );
public static native int LAPACKE_zunmlq( int matrix_layout, @Cast("char") byte side, @Cast("char") byte trans,
                           int m, int n, int k,
                           @Cast("const lapack_complex_double*") double[] a, int lda,
                           @Cast("const lapack_complex_double*") double[] tau,
                           @Cast("lapack_complex_double*") double[] c, int ldc );

public static native int LAPACKE_cunmql( int matrix_layout, @Cast("char") byte side, @Cast("char") byte trans,
                           int m, int n, int k,
                           @Cast("const lapack_complex_float*") FloatPointer a, int lda,
                           @Cast("const lapack_complex_float*") FloatPointer tau,
                           @Cast("lapack_complex_float*") FloatPointer c, int ldc );
public static native int LAPACKE_cunmql( int matrix_layout, @Cast("char") byte side, @Cast("char") byte trans,
                           int m, int n, int k,
                           @Cast("const lapack_complex_float*") FloatBuffer a, int lda,
                           @Cast("const lapack_complex_float*") FloatBuffer tau,
                           @Cast("lapack_complex_float*") FloatBuffer c, int ldc );
public static native int LAPACKE_cunmql( int matrix_layout, @Cast("char") byte side, @Cast("char") byte trans,
                           int m, int n, int k,
                           @Cast("const lapack_complex_float*") float[] a, int lda,
                           @Cast("const lapack_complex_float*") float[] tau,
                           @Cast("lapack_complex_float*") float[] c, int ldc );
public static native int LAPACKE_zunmql( int matrix_layout, @Cast("char") byte side, @Cast("char") byte trans,
                           int m, int n, int k,
                           @Cast("const lapack_complex_double*") DoublePointer a, int lda,
                           @Cast("const lapack_complex_double*") DoublePointer tau,
                           @Cast("lapack_complex_double*") DoublePointer c, int ldc );
public static native int LAPACKE_zunmql( int matrix_layout, @Cast("char") byte side, @Cast("char") byte trans,
                           int m, int n, int k,
                           @Cast("const lapack_complex_double*") DoubleBuffer a, int lda,
                           @Cast("const lapack_complex_double*") DoubleBuffer tau,
                           @Cast("lapack_complex_double*") DoubleBuffer c, int ldc );
public static native int LAPACKE_zunmql( int matrix_layout, @Cast("char") byte side, @Cast("char") byte trans,
                           int m, int n, int k,
                           @Cast("const lapack_complex_double*") double[] a, int lda,
                           @Cast("const lapack_complex_double*") double[] tau,
                           @Cast("lapack_complex_double*") double[] c, int ldc );

public static native int LAPACKE_cunmqr( int matrix_layout, @Cast("char") byte side, @Cast("char") byte trans,
                           int m, int n, int k,
                           @Cast("const lapack_complex_float*") FloatPointer a, int lda,
                           @Cast("const lapack_complex_float*") FloatPointer tau,
                           @Cast("lapack_complex_float*") FloatPointer c, int ldc );
public static native int LAPACKE_cunmqr( int matrix_layout, @Cast("char") byte side, @Cast("char") byte trans,
                           int m, int n, int k,
                           @Cast("const lapack_complex_float*") FloatBuffer a, int lda,
                           @Cast("const lapack_complex_float*") FloatBuffer tau,
                           @Cast("lapack_complex_float*") FloatBuffer c, int ldc );
public static native int LAPACKE_cunmqr( int matrix_layout, @Cast("char") byte side, @Cast("char") byte trans,
                           int m, int n, int k,
                           @Cast("const lapack_complex_float*") float[] a, int lda,
                           @Cast("const lapack_complex_float*") float[] tau,
                           @Cast("lapack_complex_float*") float[] c, int ldc );
public static native int LAPACKE_zunmqr( int matrix_layout, @Cast("char") byte side, @Cast("char") byte trans,
                           int m, int n, int k,
                           @Cast("const lapack_complex_double*") DoublePointer a, int lda,
                           @Cast("const lapack_complex_double*") DoublePointer tau,
                           @Cast("lapack_complex_double*") DoublePointer c, int ldc );
public static native int LAPACKE_zunmqr( int matrix_layout, @Cast("char") byte side, @Cast("char") byte trans,
                           int m, int n, int k,
                           @Cast("const lapack_complex_double*") DoubleBuffer a, int lda,
                           @Cast("const lapack_complex_double*") DoubleBuffer tau,
                           @Cast("lapack_complex_double*") DoubleBuffer c, int ldc );
public static native int LAPACKE_zunmqr( int matrix_layout, @Cast("char") byte side, @Cast("char") byte trans,
                           int m, int n, int k,
                           @Cast("const lapack_complex_double*") double[] a, int lda,
                           @Cast("const lapack_complex_double*") double[] tau,
                           @Cast("lapack_complex_double*") double[] c, int ldc );

public static native int LAPACKE_cunmrq( int matrix_layout, @Cast("char") byte side, @Cast("char") byte trans,
                           int m, int n, int k,
                           @Cast("const lapack_complex_float*") FloatPointer a, int lda,
                           @Cast("const lapack_complex_float*") FloatPointer tau,
                           @Cast("lapack_complex_float*") FloatPointer c, int ldc );
public static native int LAPACKE_cunmrq( int matrix_layout, @Cast("char") byte side, @Cast("char") byte trans,
                           int m, int n, int k,
                           @Cast("const lapack_complex_float*") FloatBuffer a, int lda,
                           @Cast("const lapack_complex_float*") FloatBuffer tau,
                           @Cast("lapack_complex_float*") FloatBuffer c, int ldc );
public static native int LAPACKE_cunmrq( int matrix_layout, @Cast("char") byte side, @Cast("char") byte trans,
                           int m, int n, int k,
                           @Cast("const lapack_complex_float*") float[] a, int lda,
                           @Cast("const lapack_complex_float*") float[] tau,
                           @Cast("lapack_complex_float*") float[] c, int ldc );
public static native int LAPACKE_zunmrq( int matrix_layout, @Cast("char") byte side, @Cast("char") byte trans,
                           int m, int n, int k,
                           @Cast("const lapack_complex_double*") DoublePointer a, int lda,
                           @Cast("const lapack_complex_double*") DoublePointer tau,
                           @Cast("lapack_complex_double*") DoublePointer c, int ldc );
public static native int LAPACKE_zunmrq( int matrix_layout, @Cast("char") byte side, @Cast("char") byte trans,
                           int m, int n, int k,
                           @Cast("const lapack_complex_double*") DoubleBuffer a, int lda,
                           @Cast("const lapack_complex_double*") DoubleBuffer tau,
                           @Cast("lapack_complex_double*") DoubleBuffer c, int ldc );
public static native int LAPACKE_zunmrq( int matrix_layout, @Cast("char") byte side, @Cast("char") byte trans,
                           int m, int n, int k,
                           @Cast("const lapack_complex_double*") double[] a, int lda,
                           @Cast("const lapack_complex_double*") double[] tau,
                           @Cast("lapack_complex_double*") double[] c, int ldc );

public static native int LAPACKE_cunmrz( int matrix_layout, @Cast("char") byte side, @Cast("char") byte trans,
                           int m, int n, int k,
                           int l, @Cast("const lapack_complex_float*") FloatPointer a,
                           int lda, @Cast("const lapack_complex_float*") FloatPointer tau,
                           @Cast("lapack_complex_float*") FloatPointer c, int ldc );
public static native int LAPACKE_cunmrz( int matrix_layout, @Cast("char") byte side, @Cast("char") byte trans,
                           int m, int n, int k,
                           int l, @Cast("const lapack_complex_float*") FloatBuffer a,
                           int lda, @Cast("const lapack_complex_float*") FloatBuffer tau,
                           @Cast("lapack_complex_float*") FloatBuffer c, int ldc );
public static native int LAPACKE_cunmrz( int matrix_layout, @Cast("char") byte side, @Cast("char") byte trans,
                           int m, int n, int k,
                           int l, @Cast("const lapack_complex_float*") float[] a,
                           int lda, @Cast("const lapack_complex_float*") float[] tau,
                           @Cast("lapack_complex_float*") float[] c, int ldc );
public static native int LAPACKE_zunmrz( int matrix_layout, @Cast("char") byte side, @Cast("char") byte trans,
                           int m, int n, int k,
                           int l, @Cast("const lapack_complex_double*") DoublePointer a,
                           int lda, @Cast("const lapack_complex_double*") DoublePointer tau,
                           @Cast("lapack_complex_double*") DoublePointer c, int ldc );
public static native int LAPACKE_zunmrz( int matrix_layout, @Cast("char") byte side, @Cast("char") byte trans,
                           int m, int n, int k,
                           int l, @Cast("const lapack_complex_double*") DoubleBuffer a,
                           int lda, @Cast("const lapack_complex_double*") DoubleBuffer tau,
                           @Cast("lapack_complex_double*") DoubleBuffer c, int ldc );
public static native int LAPACKE_zunmrz( int matrix_layout, @Cast("char") byte side, @Cast("char") byte trans,
                           int m, int n, int k,
                           int l, @Cast("const lapack_complex_double*") double[] a,
                           int lda, @Cast("const lapack_complex_double*") double[] tau,
                           @Cast("lapack_complex_double*") double[] c, int ldc );

public static native int LAPACKE_cunmtr( int matrix_layout, @Cast("char") byte side, @Cast("char") byte uplo, @Cast("char") byte trans,
                           int m, int n,
                           @Cast("const lapack_complex_float*") FloatPointer a, int lda,
                           @Cast("const lapack_complex_float*") FloatPointer tau,
                           @Cast("lapack_complex_float*") FloatPointer c, int ldc );
public static native int LAPACKE_cunmtr( int matrix_layout, @Cast("char") byte side, @Cast("char") byte uplo, @Cast("char") byte trans,
                           int m, int n,
                           @Cast("const lapack_complex_float*") FloatBuffer a, int lda,
                           @Cast("const lapack_complex_float*") FloatBuffer tau,
                           @Cast("lapack_complex_float*") FloatBuffer c, int ldc );
public static native int LAPACKE_cunmtr( int matrix_layout, @Cast("char") byte side, @Cast("char") byte uplo, @Cast("char") byte trans,
                           int m, int n,
                           @Cast("const lapack_complex_float*") float[] a, int lda,
                           @Cast("const lapack_complex_float*") float[] tau,
                           @Cast("lapack_complex_float*") float[] c, int ldc );
public static native int LAPACKE_zunmtr( int matrix_layout, @Cast("char") byte side, @Cast("char") byte uplo, @Cast("char") byte trans,
                           int m, int n,
                           @Cast("const lapack_complex_double*") DoublePointer a, int lda,
                           @Cast("const lapack_complex_double*") DoublePointer tau,
                           @Cast("lapack_complex_double*") DoublePointer c, int ldc );
public static native int LAPACKE_zunmtr( int matrix_layout, @Cast("char") byte side, @Cast("char") byte uplo, @Cast("char") byte trans,
                           int m, int n,
                           @Cast("const lapack_complex_double*") DoubleBuffer a, int lda,
                           @Cast("const lapack_complex_double*") DoubleBuffer tau,
                           @Cast("lapack_complex_double*") DoubleBuffer c, int ldc );
public static native int LAPACKE_zunmtr( int matrix_layout, @Cast("char") byte side, @Cast("char") byte uplo, @Cast("char") byte trans,
                           int m, int n,
                           @Cast("const lapack_complex_double*") double[] a, int lda,
                           @Cast("const lapack_complex_double*") double[] tau,
                           @Cast("lapack_complex_double*") double[] c, int ldc );

public static native