// Targeted by JavaCPP version 1.5.1: DO NOT EDIT THIS FILE

package org.bytedeco.tesseract;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import org.bytedeco.leptonica.*;
import static org.bytedeco.leptonica.global.lept.*;

import static org.bytedeco.tesseract.global.tesseract.*;


/**
 * Base class for all tesseract APIs.
 * Specific classes can add ability to work on different inputs or produce
 * different outputs.
 * This class is mostly an interface layer on top of the Tesseract instance
 * class to hide the data types so that users of this class don't have to
 * include any other Tesseract headers.
 */
@Namespace("tesseract") @NoOffset @Properties(inherit = org.bytedeco.tesseract.presets.tesseract.class)
public class TessBaseAPI extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public TessBaseAPI(Pointer p) { super(p); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public TessBaseAPI(long size) { super((Pointer)null); allocateArray(size); }
    private native void allocateArray(long size);
    @Override public TessBaseAPI position(long position) {
        return (TessBaseAPI)super.position(position);
    }

  public TessBaseAPI() { super((Pointer)null); allocate(); }
  private native void allocate();

  /**
   * Returns the version identifier as a static string. Do not delete.
   */
  public static native @Cast("const char*") BytePointer Version();

  /**
   * If compiled with OpenCL AND an available OpenCL
   * device is deemed faster than serial code, then
   * "device" is populated with the cl_device_id
   * and returns sizeof(cl_device_id)
   * otherwise *device=nullptr and returns 0.
   */
  public static native @Cast("size_t") long getOpenCLDevice(@Cast("void**") PointerPointer device);
  public static native @Cast("size_t") long getOpenCLDevice(@Cast("void**") @ByPtrPtr Pointer device);

  /**
   * Writes the thresholded image to stderr as a PBM file on receipt of a
   * SIGSEGV, SIGFPE, or SIGBUS signal. (Linux/Unix only).
   */
  public static native void CatchSignals();

  /**
   * Set the name of the input file. Needed for training and
   * reading a UNLV zone file, and for searchable PDF output.
   */
  public native void SetInputName(@Cast("const char*") BytePointer name);
  public native void SetInputName(String name);
  /**
   * These functions are required for searchable PDF output.
   * We need our hands on the input file so that we can include
   * it in the PDF without transcoding. If that is not possible,
   * we need the original image. Finally, resolution metadata
   * is stored in the PDF so we need that as well.
   */
  public native @Cast("const char*") BytePointer GetInputName();
  // Takes ownership of the input pix.
  public native void SetInputImage(PIX pix);
  public native PIX GetInputImage();
  public native int GetSourceYResolution();
  public native @Cast("const char*") BytePointer GetDatapath();

  /** Set the name of the bonus output files. Needed only for debugging. */
  public native void SetOutputName(@Cast("const char*") BytePointer name);
  public native void SetOutputName(String name);

  /**
   * Set the value of an internal "parameter."
   * Supply the name of the parameter and the value as a string, just as
   * you would in a config file.
   * Returns false if the name lookup failed.
   * Eg SetVariable("tessedit_char_blacklist", "xyz"); to ignore x, y and z.
   * Or SetVariable("classify_bln_numeric_mode", "1"); to set numeric-only mode.
   * SetVariable may be used before Init, but settings will revert to
   * defaults on End().
   *
   * Note: Must be called after Init(). Only works for non-init variables
   * (init variables should be passed to Init()).
   */
  public native @Cast("bool") boolean SetVariable(@Cast("const char*") BytePointer name, @Cast("const char*") BytePointer value);
  public native @Cast("bool") boolean SetVariable(String name, String value);
  public native @Cast("bool") boolean SetDebugVariable(@Cast("const char*") BytePointer name, @Cast("const char*") BytePointer value);
  public native @Cast("bool") boolean SetDebugVariable(String name, String value);

  /**
   * Returns true if the parameter was found among Tesseract parameters.
   * Fills in value with the value of the parameter.
   */
  public native @Cast("bool") boolean GetIntVariable(@Cast("const char*") BytePointer name, IntPointer value);
  public native @Cast("bool") boolean GetIntVariable(String name, IntBuffer value);
  public native @Cast("bool") boolean GetIntVariable(@Cast("const char*") BytePointer name, int[] value);
  public native @Cast("bool") boolean GetIntVariable(String name, IntPointer value);
  public native @Cast("bool") boolean GetIntVariable(@Cast("const char*") BytePointer name, IntBuffer value);
  public native @Cast("bool") boolean GetIntVariable(String name, int[] value);
  public native @Cast("bool") boolean GetBoolVariable(@Cast("const char*") BytePointer name, @Cast("bool*") BoolPointer value);
  public native @Cast("bool") boolean GetBoolVariable(String name, @Cast("bool*") boolean[] value);
  public native @Cast("bool") boolean GetDoubleVariable(@Cast("const char*") BytePointer name, DoublePointer value);
  public native @Cast("bool") boolean GetDoubleVariable(String name, DoubleBuffer value);
  public native @Cast("bool") boolean GetDoubleVariable(@Cast("const char*") BytePointer name, double[] value);
  public native @Cast("bool") boolean GetDoubleVariable(String name, DoublePointer value);
  public native @Cast("bool") boolean GetDoubleVariable(@Cast("const char*") BytePointer name, DoubleBuffer value);
  public native @Cast("bool") boolean GetDoubleVariable(String name, double[] value);

  /**
   * Returns the pointer to the string that represents the value of the
   * parameter if it was found among Tesseract parameters.
   */
  public native @Cast("const char*") BytePointer GetStringVariable(@Cast("const char*") BytePointer name);
  public native String GetStringVariable(String name);

  /**
   * Print Tesseract parameters to the given file.
   */
  public native void PrintVariables(@Cast("FILE*") Pointer fp);

  /**
   * Get value of named variable as a string, if it exists.
   */
  public native @Cast("bool") boolean GetVariableAsString(@Cast("const char*") BytePointer name, STRING val);
  public native @Cast("bool") boolean GetVariableAsString(String name, STRING val);

  /**
   * Instances are now mostly thread-safe and totally independent,
   * but some global parameters remain. Basically it is safe to use multiple
   * TessBaseAPIs in different threads in parallel, UNLESS:
   * you use SetVariable on some of the Params in classify and textord.
   * If you do, then the effect will be to change it for all your instances.
   *
   * Start tesseract. Returns zero on success and -1 on failure.
   * NOTE that the only members that may be called before Init are those
   * listed above here in the class definition.
   *
   * The datapath must be the name of the tessdata directory.
   * The language is (usually) an ISO 639-3 string or nullptr will default to eng.
   * It is entirely safe (and eventually will be efficient too) to call
   * Init multiple times on the same instance to change language, or just
   * to reset the classifier.
   * The language may be a string of the form [~]<lang>[+[~]<lang>]* indicating
   * that multiple languages are to be loaded. Eg hin+eng will load Hindi and
   * English. Languages may specify internally that they want to be loaded
   * with one or more other languages, so the ~ sign is available to override
   * that. Eg if hin were set to load eng by default, then hin+~eng would force
   * loading only hin. The number of loaded languages is limited only by
   * memory, with the caveat that loading additional languages will impact
   * both speed and accuracy, as there is more work to do to decide on the
   * applicable language, and there is more chance of hallucinating incorrect
   * words.
   * WARNING: On changing languages, all Tesseract parameters are reset
   * back to their default values. (Which may vary between languages.)
   * If you have a rare need to set a Variable that controls
   * initialization for a second call to Init you should explicitly
   * call End() and then use SetVariable before Init. This is only a very
   * rare use case, since there are very few uses that require any parameters
   * to be set before Init.
   *
   * If set_only_non_debug_params is true, only params that do not contain
   * "debug" in the name will be set.
   */
  public native int Init(@Cast("const char*") BytePointer datapath, @Cast("const char*") BytePointer language, @Cast("tesseract::OcrEngineMode") int mode,
             @Cast("char**") PointerPointer configs, int configs_size,
             @Const StringGenericVector vars_vec,
             @Const StringGenericVector vars_values,
             @Cast("bool") boolean set_only_non_debug_params);
  public native int Init(@Cast("const char*") BytePointer datapath, @Cast("const char*") BytePointer language, @Cast("tesseract::OcrEngineMode") int mode,
             @Cast("char**") @ByPtrPtr BytePointer configs, int configs_size,
             @Const StringGenericVector vars_vec,
             @Const StringGenericVector vars_values,
             @Cast("bool") boolean set_only_non_debug_params);
  public native int Init(String datapath, String language, @Cast("tesseract::OcrEngineMode") int mode,
             @Cast("char**") @ByPtrPtr ByteBuffer configs, int configs_size,
             @Const StringGenericVector vars_vec,
             @Const StringGenericVector vars_values,
             @Cast("bool") boolean set_only_non_debug_params);
  public native int Init(@Cast("const char*") BytePointer datapath, @Cast("const char*") BytePointer language, @Cast("tesseract::OcrEngineMode") int mode,
             @Cast("char**") @ByPtrPtr byte[] configs, int configs_size,
             @Const StringGenericVector vars_vec,
             @Const StringGenericVector vars_values,
             @Cast("bool") boolean set_only_non_debug_params);
  public native int Init(String datapath, String language, @Cast("tesseract::OcrEngineMode") int mode,
             @Cast("char**") @ByPtrPtr BytePointer configs, int configs_size,
             @Const StringGenericVector vars_vec,
             @Const StringGenericVector vars_values,
             @Cast("bool") boolean set_only_non_debug_params);
  public native int Init(@Cast("const char*") BytePointer datapath, @Cast("const char*") BytePointer language, @Cast("tesseract::OcrEngineMode") int mode,
             @Cast("char**") @ByPtrPtr ByteBuffer configs, int configs_size,
             @Const StringGenericVector vars_vec,
             @Const StringGenericVector vars_values,
             @Cast("bool") boolean set_only_non_debug_params);
  public native int Init(String datapath, String language, @Cast("tesseract::OcrEngineMode") int mode,
             @Cast("char**") @ByPtrPtr byte[] configs, int configs_size,
             @Const StringGenericVector vars_vec,
             @Const StringGenericVector vars_values,
             @Cast("bool") boolean set_only_non_debug_params);
  public native int Init(@Cast("const char*") BytePointer datapath, @Cast("const char*") BytePointer language, @Cast("tesseract::OcrEngineMode") int oem);
  public native int Init(String datapath, String language, @Cast("tesseract::OcrEngineMode") int oem);
  public native int Init(@Cast("const char*") BytePointer datapath, @Cast("const char*") BytePointer language);
  public native int Init(String datapath, String language);
  // In-memory version reads the traineddata file directly from the given
  // data[data_size] array, and/or reads data via a FileReader.
  public native int Init(@Cast("const char*") BytePointer data, int data_size, @Cast("const char*") BytePointer language,
             @Cast("tesseract::OcrEngineMode") int mode, @Cast("char**") PointerPointer configs, int configs_size,
             @Const StringGenericVector vars_vec,
             @Const StringGenericVector vars_values,
             @Cast("bool") boolean set_only_non_debug_params, FileReader reader);
  public native int Init(@Cast("const char*") BytePointer data, int data_size, @Cast("const char*") BytePointer language,
             @Cast("tesseract::OcrEngineMode") int mode, @Cast("char**") @ByPtrPtr BytePointer configs, int configs_size,
             @Const StringGenericVector vars_vec,
             @Const StringGenericVector vars_values,
             @Cast("bool") boolean set_only_non_debug_params, FileReader reader);
  public native int Init(String data, int data_size, String language,
             @Cast("tesseract::OcrEngineMode") int mode, @Cast("char**") @ByPtrPtr ByteBuffer configs, int configs_size,
             @Const StringGenericVector vars_vec,
             @Const StringGenericVector vars_values,
             @Cast("bool") boolean set_only_non_debug_params, FileReader reader);
  public native int Init(@Cast("const char*") BytePointer data, int data_size, @Cast("const char*") BytePointer language,
             @Cast("tesseract::OcrEngineMode") int mode, @Cast("char**") @ByPtrPtr byte[] configs, int configs_size,
             @Const StringGenericVector vars_vec,
             @Const StringGenericVector vars_values,
             @Cast("bool") boolean set_only_non_debug_params, FileReader reader);
  public native int Init(String data, int data_size, String language,
             @Cast("tesseract::OcrEngineMode") int mode, @Cast("char**") @ByPtrPtr BytePointer configs, int configs_size,
             @Const StringGenericVector vars_vec,
             @Const StringGenericVector vars_values,
             @Cast("bool") boolean set_only_non_debug_params, FileReader reader);
  public native int Init(@Cast("const char*") BytePointer data, int data_size, @Cast("const char*") BytePointer language,
             @Cast("tesseract::OcrEngineMode") int mode, @Cast("char**") @ByPtrPtr ByteBuffer configs, int configs_size,
             @Const StringGenericVector vars_vec,
             @Const StringGenericVector vars_values,
             @Cast("bool") boolean set_only_non_debug_params, FileReader reader);
  public native int Init(String data, int data_size, String language,
             @Cast("tesseract::OcrEngineMode") int mode, @Cast("char**") @ByPtrPtr byte[] configs, int configs_size,
             @Const StringGenericVector vars_vec,
             @Const StringGenericVector vars_values,
             @Cast("bool") boolean set_only_non_debug_params, FileReader reader);

  /**
   * Returns the languages string used in the last valid initialization.
   * If the last initialization specified "deu+hin" then that will be
   * returned. If hin loaded eng automatically as well, then that will
   * not be included in this list. To find the languages actually
   * loaded use GetLoadedLanguagesAsVector.
   * The returned string should NOT be deleted.
   */
  public native @Cast("const char*") BytePointer GetInitLanguagesAsString();

  /**
   * Returns the loaded languages in the vector of STRINGs.
   * Includes all languages loaded by the last Init, including those loaded
   * as dependencies of other loaded languages.
   */
  public native void GetLoadedLanguagesAsVector(StringGenericVector langs);

  /**
   * Returns the available languages in the sorted vector of STRINGs.
   */
  public native void GetAvailableLanguagesAsVector(StringGenericVector langs);

  /**
   * Init only the lang model component of Tesseract. The only functions
   * that work after this init are SetVariable and IsValidWord.
   * WARNING: temporary! This function will be removed from here and placed
   * in a separate API at some future time.
   */
  public native int InitLangMod(@Cast("const char*") BytePointer datapath, @Cast("const char*") BytePointer language);
  public native int InitLangMod(String datapath, String language);

  /**
   * Init only for page layout analysis. Use only for calls to SetImage and
   * AnalysePage. Calls that attempt recognition will generate an error.
   */
  public native void InitForAnalysePage();

  /**
   * Read a "config" file containing a set of param, value pairs.
   * Searches the standard places: tessdata/configs, tessdata/tessconfigs
   * and also accepts a relative or absolute path name.
   * Note: only non-init params will be set (init params are set by Init()).
   */
  public native void ReadConfigFile(@Cast("const char*") BytePointer filename);
  public native void ReadConfigFile(String filename);
  /** Same as above, but only set debug params from the given config file. */
  public native void ReadDebugConfigFile(@Cast("const char*") BytePointer filename);
  public native void ReadDebugConfigFile(String filename);

  /**
   * Set the current page segmentation mode. Defaults to PSM_SINGLE_BLOCK.
   * The mode is stored as an IntParam so it can also be modified by
   * ReadConfigFile or SetVariable("tessedit_pageseg_mode", mode as string).
   */
  public native void SetPageSegMode(@Cast("tesseract::PageSegMode") int mode);

  /** Return the current page segmentation mode. */
  public native @Cast("tesseract::PageSegMode") int GetPageSegMode();

  /**
   * Recognize a rectangle from an image and return the result as a string.
   * May be called many times for a single Init.
   * Currently has no error checking.
   * Greyscale of 8 and color of 24 or 32 bits per pixel may be given.
   * Palette color images will not work properly and must be converted to
   * 24 bit.
   * Binary images of 1 bit per pixel may also be given but they must be
   * byte packed with the MSB of the first byte being the first pixel, and a
   * 1 represents WHITE. For binary images set bytes_per_pixel=0.
   * The recognized text is returned as a char* which is coded
   * as UTF8 and must be freed with the delete [] operator.
   *
   * Note that TesseractRect is the simplified convenience interface.
   * For advanced uses, use SetImage, (optionally) SetRectangle, Recognize,
   * and one or more of the Get*Text functions below.
   */
  public native @Cast("char*") BytePointer TesseractRect(@Cast("const unsigned char*") BytePointer imagedata,
                        int bytes_per_pixel, int bytes_per_line,
                        int left, int top, int width, int height);
  public native @Cast("char*") ByteBuffer TesseractRect(@Cast("const unsigned char*") ByteBuffer imagedata,
                        int bytes_per_pixel, int bytes_per_line,
                        int left, int top, int width, int height);
  public native @Cast("char*") byte[] TesseractRect(@Cast("const unsigned char*") byte[] imagedata,
                        int bytes_per_pixel, int bytes_per_line,
                        int left, int top, int width, int height);

  /**
   * Call between pages or documents etc to free up memory and forget
   * adaptive data.
   */
  public native void ClearAdaptiveClassifier();

  /**
   * \defgroup AdvancedAPI Advanced API
   * The following methods break TesseractRect into pieces, so you can
   * get hold of the thresholded image, get the text in different formats,
   * get bounding boxes, confidences etc.
   */
   /* @{ */

  /**
   * Provide an image for Tesseract to recognize. Format is as
   * TesseractRect above. Copies the image buffer and converts to Pix.
   * SetImage clears all recognition results, and sets the rectangle to the
   * full image, so it may be followed immediately by a GetUTF8Text, and it
   * will automatically perform recognition.
   */
  public native void SetImage(@Cast("const unsigned char*") BytePointer imagedata, int width, int height,
                  int bytes_per_pixel, int bytes_per_line);
  public native void SetImage(@Cast("const unsigned char*") ByteBuffer imagedata, int width, int height,
                  int bytes_per_pixel, int bytes_per_line);
  public native void SetImage(@Cast("const unsigned char*") byte[] imagedata, int width, int height,
                  int bytes_per_pixel, int bytes_per_line);

  /**
   * Provide an image for Tesseract to recognize. As with SetImage above,
   * Tesseract takes its own copy of the image, so it need not persist until
   * after Recognize.
   * Pix vs raw, which to use?
   * Use Pix where possible. Tesseract uses Pix as its internal representation
   * and it is therefore more efficient to provide a Pix directly.
   */
  public native void SetImage(PIX pix);

  /**
   * Set the resolution of the source image in pixels per inch so font size
   * information can be calculated in results.  Call this after SetImage().
   */
  public native void SetSourceResolution(int ppi);

  /**
   * Restrict recognition to a sub-rectangle of the image. Call after SetImage.
   * Each SetRectangle clears the recogntion results so multiple rectangles
   * can be recognized with the same image.
   */
  public native void SetRectangle(int left, int top, int width, int height);

  /**
   * In extreme cases only, usually with a subclass of Thresholder, it
   * is possible to provide a different Thresholder. The Thresholder may
   * be preloaded with an image, settings etc, or they may be set after.
   * Note that Tesseract takes ownership of the Thresholder and will
   * delete it when it it is replaced or the API is destructed.
   */
  public native void SetThresholder(ImageThresholder thresholder);

  /**
   * Get a copy of the internal thresholded image from Tesseract.
   * Caller takes ownership of the Pix and must pixDestroy it.
   * May be called any time after SetImage, or after TesseractRect.
   */
  public native PIX GetThresholdedImage();

  /**
   * Get the result of page layout analysis as a leptonica-style
   * Boxa, Pixa pair, in reading order.
   * Can be called before or after Recognize.
   */
  public native BOXA GetRegions(@Cast("Pixa**") PointerPointer pixa);
  public native BOXA GetRegions(@ByPtrPtr PIXA pixa);

  /**
   * Get the textlines as a leptonica-style
   * Boxa, Pixa pair, in reading order.
   * Can be called before or after Recognize.
   * If raw_image is true, then extract from the original image instead of the
   * thresholded image and pad by raw_padding pixels.
   * If blockids is not nullptr, the block-id of each line is also returned as an
   * array of one element per line. delete [] after use.
   * If paraids is not nullptr, the paragraph-id of each line within its block is
   * also returned as an array of one element per line. delete [] after use.
   */
  public native BOXA GetTextlines(@Cast("bool") boolean raw_image, int raw_padding,
                       @Cast("Pixa**") PointerPointer pixa, @Cast("int**") PointerPointer blockids, @Cast("int**") PointerPointer paraids);
  public native BOXA GetTextlines(@Cast("bool") boolean raw_image, int raw_padding,
                       @ByPtrPtr PIXA pixa, @ByPtrPtr IntPointer blockids, @ByPtrPtr IntPointer paraids);
  public native BOXA GetTextlines(@Cast("bool") boolean raw_image, int raw_padding,
                       @ByPtrPtr PIXA pixa, @ByPtrPtr IntBuffer blockids, @ByPtrPtr IntBuffer paraids);
  public native BOXA GetTextlines(@Cast("bool") boolean raw_image, int raw_padding,
                       @ByPtrPtr PIXA pixa, @ByPtrPtr int[] blockids, @ByPtrPtr int[] paraids);
  /*
     Helper method to extract from the thresholded image. (most common usage)
  */
  public native BOXA GetTextlines(@Cast("Pixa**") PointerPointer pixa, @Cast("int**") PointerPointer blockids);
  public native BOXA GetTextlines(@ByPtrPtr PIXA pixa, @ByPtrPtr IntPointer blockids);
  public native BOXA GetTextlines(@ByPtrPtr PIXA pixa, @ByPtrPtr IntBuffer blockids);
  public native BOXA GetTextlines(@ByPtrPtr PIXA pixa, @ByPtrPtr int[] blockids);

  /**
   * Get textlines and strips of image regions as a leptonica-style Boxa, Pixa
   * pair, in reading order. Enables downstream handling of non-rectangular
   * regions.
   * Can be called before or after Recognize.
   * If blockids is not nullptr, the block-id of each line is also returned as an
   * array of one element per line. delete [] after use.
   */
  public native BOXA GetStrips(@Cast("Pixa**") PointerPointer pixa, @Cast("int**") PointerPointer blockids);
  public native BOXA GetStrips(@ByPtrPtr PIXA pixa, @ByPtrPtr IntPointer blockids);
  public native BOXA GetStrips(@ByPtrPtr PIXA pixa, @ByPtrPtr IntBuffer blockids);
  public native BOXA GetStrips(@ByPtrPtr PIXA pixa, @ByPtrPtr int[] blockids);

  /**
   * Get the words as a leptonica-style
   * Boxa, Pixa pair, in reading order.
   * Can be called before or after Recognize.
   */
  public native BOXA GetWords(@Cast("Pixa**") PointerPointer pixa);
  public native BOXA GetWords(@ByPtrPtr PIXA pixa);

  /**
   * Gets the individual connected (text) components (created
   * after pages segmentation step, but before recognition)
   * as a leptonica-style Boxa, Pixa pair, in reading order.
   * Can be called before or after Recognize.
   * Note: the caller is responsible for calling boxaDestroy()
   * on the returned Boxa array and pixaDestroy() on cc array.
   */
  public native BOXA GetConnectedComponents(@Cast("Pixa**") PointerPointer cc);
  public native BOXA GetConnectedComponents(@ByPtrPtr PIXA cc);

  /**
   * Get the given level kind of components (block, textline, word etc.) as a
   * leptonica-style Boxa, Pixa pair, in reading order.
   * Can be called before or after Recognize.
   * If blockids is not nullptr, the block-id of each component is also returned
   * as an array of one element per component. delete [] after use.
   * If blockids is not nullptr, the paragraph-id of each component with its block
   * is also returned as an array of one element per component. delete [] after
   * use.
   * If raw_image is true, then portions of the original image are extracted
   * instead of the thresholded image and padded with raw_padding.
   * If text_only is true, then only text components are returned.
   */
  public native BOXA GetComponentImages(@Cast("tesseract::PageIteratorLevel") int level,
                             @Cast("bool") boolean text_only, @Cast("bool") boolean raw_image,
                             int raw_padding,
                             @Cast("Pixa**") PointerPointer pixa, @Cast("int**") PointerPointer blockids, @Cast("int**") PointerPointer paraids);
  public native BOXA GetComponentImages(@Cast("tesseract::PageIteratorLevel") int level,
                             @Cast("bool") boolean text_only, @Cast("bool") boolean raw_image,
                             int raw_padding,
                             @ByPtrPtr PIXA pixa, @ByPtrPtr IntPointer blockids, @ByPtrPtr IntPointer paraids);
  public native BOXA GetComponentImages(@Cast("tesseract::PageIteratorLevel") int level,
                             @Cast("bool") boolean text_only, @Cast("bool") boolean raw_image,
                             int raw_padding,
                             @ByPtrPtr PIXA pixa, @ByPtrPtr IntBuffer blockids, @ByPtrPtr IntBuffer paraids);
  public native BOXA GetComponentImages(@Cast("tesseract::PageIteratorLevel") int level,
                             @Cast("bool") boolean text_only, @Cast("bool") boolean raw_image,
                             int raw_padding,
                             @ByPtrPtr PIXA pixa, @ByPtrPtr int[] blockids, @ByPtrPtr int[] paraids);
  // Helper function to get binary images with no padding (most common usage).
  public native BOXA GetComponentImages(@Cast("const tesseract::PageIteratorLevel") int level,
                             @Cast("const bool") boolean text_only,
                             @Cast("Pixa**") PointerPointer pixa, @Cast("int**") PointerPointer blockids);
  public native BOXA GetComponentImages(@Cast("const tesseract::PageIteratorLevel") int level,
                             @Cast("const bool") boolean text_only,
                             @ByPtrPtr PIXA pixa, @ByPtrPtr IntPointer blockids);
  public native BOXA GetComponentImages(@Cast("const tesseract::PageIteratorLevel") int level,
                             @Cast("const bool") boolean text_only,
                             @ByPtrPtr PIXA pixa, @ByPtrPtr IntBuffer blockids);
  public native BOXA GetComponentImages(@Cast("const tesseract::PageIteratorLevel") int level,
                             @Cast("const bool") boolean text_only,
                             @ByPtrPtr PIXA pixa, @ByPtrPtr int[] blockids);

  /**
   * Returns the scale factor of the thresholded image that would be returned by
   * GetThresholdedImage() and the various GetX() methods that call
   * GetComponentImages().
   * Returns 0 if no thresholder has been set.
   */
  public native int GetThresholdedImageScaleFactor();

  /**
   * Runs page layout analysis in the mode set by SetPageSegMode.
   * May optionally be called prior to Recognize to get access to just
   * the page layout results. Returns an iterator to the results.
   * If merge_similar_words is true, words are combined where suitable for use
   * with a line recognizer. Use if you want to use AnalyseLayout to find the
   * textlines, and then want to process textline fragments with an external
   * line recognizer.
   * Returns nullptr on error or an empty page.
   * The returned iterator must be deleted after use.
   * WARNING! This class points to data held within the TessBaseAPI class, and
   * therefore can only be used while the TessBaseAPI class still exists and
   * has not been subjected to a call of Init, SetImage, Recognize, Clear, End
   * DetectOS, or anything else that changes the internal PAGE_RES.
   */
  public native PageIterator AnalyseLayout();
  public native PageIterator AnalyseLayout(@Cast("bool") boolean merge_similar_words);

  /**
   * Recognize the image from SetAndThresholdImage, generating Tesseract
   * internal structures. Returns 0 on success.
   * Optional. The Get*Text functions below will call Recognize if needed.
   * After Recognize, the output is kept internally until the next SetImage.
   */
  public native int Recognize(ETEXT_DESC monitor);

  /**
   * Methods to retrieve information after SetAndThresholdImage(),
   * Recognize() or TesseractRect(). (Recognize is called implicitly if needed.)
   */

//   #ifndef DISABLED_LEGACY_ENGINE
  /** Variant on Recognize used for testing chopper. */
  public native int RecognizeForChopTest(ETEXT_DESC monitor);
//   #endif

  /**
   * Turns images into symbolic text.
   *
   * filename can point to a single image, a multi-page TIFF,
   * or a plain text list of image filenames.
   *
   * retry_config is useful for debugging. If not nullptr, you can fall
   * back to an alternate configuration if a page fails for some
   * reason.
   *
   * timeout_millisec terminates processing if any single page
   * takes too long. Set to 0 for unlimited time.
   *
   * renderer is responible for creating the output. For example,
   * use the TessTextRenderer if you want plaintext output, or
   * the TessPDFRender to produce searchable PDF.
   *
   * If tessedit_page_number is non-negative, will only process that
   * single page. Works for multi-page tiff file, or filelist.
   *
   * Returns true if successful, false on error.
   */
  public native @Cast("bool") boolean ProcessPages(@Cast("const char*") BytePointer filename, @Cast("const char*") BytePointer retry_config,
                      int timeout_millisec, TessResultRenderer renderer);
  public native @Cast("bool") boolean ProcessPages(String filename, String retry_config,
                      int timeout_millisec, TessResultRenderer renderer);
  // Does the real work of ProcessPages.
  public native @Cast("bool") boolean ProcessPagesInternal(@Cast("const char*") BytePointer filename, @Cast("const char*") BytePointer retry_config,
                              int timeout_millisec, TessResultRenderer renderer);
  public native @Cast("bool") boolean ProcessPagesInternal(String filename, String retry_config,
                              int timeout_millisec, TessResultRenderer renderer);

  /**
   * Turn a single image into symbolic text.
   *
   * The pix is the image processed. filename and page_index are
   * metadata used by side-effect processes, such as reading a box
   * file or formatting as hOCR.
   *
   * See ProcessPages for desciptions of other parameters.
   */
  public native @Cast("bool") boolean ProcessPage(PIX pix, int page_index, @Cast("const char*") BytePointer filename,
                     @Cast("const char*") BytePointer retry_config, int timeout_millisec,
                     TessResultRenderer renderer);
  public native @Cast("bool") boolean ProcessPage(PIX pix, int page_index, String filename,
                     String retry_config, int timeout_millisec,
                     TessResultRenderer renderer);

  /**
   * Get a reading-order iterator to the results of LayoutAnalysis and/or
   * Recognize. The returned iterator must be deleted after use.
   * WARNING! This class points to data held within the TessBaseAPI class, and
   * therefore can only be used while the TessBaseAPI class still exists and
   * has not been subjected to a call of Init, SetImage, Recognize, Clear, End
   * DetectOS, or anything else that changes the internal PAGE_RES.
   */
  public native ResultIterator GetIterator();

  /**
   * Get a mutable iterator to the results of LayoutAnalysis and/or Recognize.
   * The returned iterator must be deleted after use.
   * WARNING! This class points to data held within the TessBaseAPI class, and
   * therefore can only be used while the TessBaseAPI class still exists and
   * has not been subjected to a call of Init, SetImage, Recognize, Clear, End
   * DetectOS, or anything else that changes the internal PAGE_RES.
   */
  public native MutableIterator GetMutableIterator();

  /**
   * The recognized text is returned as a char* which is coded
   * as UTF8 and must be freed with the delete [] operator.
   */
  public native @Cast("char*") BytePointer GetUTF8Text();

  /**
   * Make a HTML-formatted string with hOCR markup from the internal
   * data structures.
   * page_number is 0-based but will appear in the output as 1-based.
   * monitor can be used to
   *  cancel the recognition
   *  receive progress callbacks
   * Returned string must be freed with the delete [] operator.
   */
  public native @Cast("char*") BytePointer GetHOCRText(ETEXT_DESC monitor, int page_number);

  /**
   * Make a HTML-formatted string with hOCR markup from the internal
   * data structures.
   * page_number is 0-based but will appear in the output as 1-based.
   * Returned string must be freed with the delete [] operator.
   */
  public native @Cast("char*") BytePointer GetHOCRText(int page_number);

  /**
   * Make an XML-formatted string with Alto markup from the internal
   * data structures.
   */
  public native @Cast("char*") BytePointer GetAltoText(ETEXT_DESC monitor, int page_number);


  /**
   * Make an XML-formatted string with Alto markup from the internal
   * data structures.
   */
  public native @Cast("char*") BytePointer GetAltoText(int page_number);

  /**
   * Make a TSV-formatted string from the internal data structures.
   * page_number is 0-based but will appear in the output as 1-based.
   * Returned string must be freed with the delete [] operator.
   */
  public native @Cast("char*") BytePointer GetTSVText(int page_number);

  /**
   * Make a box file for LSTM training from the internal data structures.
   * Constructs coordinates in the original image - not just the rectangle.
   * page_number is a 0-based page index that will appear in the box file.
   * Returned string must be freed with the delete [] operator.
   */
  public native @Cast("char*") BytePointer GetLSTMBoxText(int page_number);

  /**
   * The recognized text is returned as a char* which is coded in the same
   * format as a box file used in training.
   * Constructs coordinates in the original image - not just the rectangle.
   * page_number is a 0-based page index that will appear in the box file.
   * Returned string must be freed with the delete [] operator.
   */
  public native @Cast("char*") BytePointer GetBoxText(int page_number);

  /**
   * The recognized text is returned as a char* which is coded in the same
   * format as a WordStr box file used in training.
   * page_number is a 0-based page index that will appear in the box file.
   * Returned string must be freed with the delete [] operator.
   */
  public native @Cast("char*") BytePointer GetWordStrBoxText(int page_number);

  /**
   * The recognized text is returned as a char* which is coded
   * as UNLV format Latin-1 with specific reject and suspect codes.
   * Returned string must be freed with the delete [] operator.
   */
  public native @Cast("char*") BytePointer GetUNLVText();

  /**
   * Detect the orientation of the input image and apparent script (alphabet).
   * orient_deg is the detected clockwise rotation of the input image in degrees
   * (0, 90, 180, 270)
   * orient_conf is the confidence (15.0 is reasonably confident)
   * script_name is an ASCII string, the name of the script, e.g. "Latin"
   * script_conf is confidence level in the script
   * Returns true on success and writes values to each parameter as an output
   */
  public native @Cast("bool") boolean DetectOrientationScript(IntPointer orient_deg, FloatPointer orient_conf,
                                 @Cast("const char**") PointerPointer script_name, FloatPointer script_conf);
  public native @Cast("bool") boolean DetectOrientationScript(IntPointer orient_deg, FloatPointer orient_conf,
                                 @Cast("const char**") @ByPtrPtr BytePointer script_name, FloatPointer script_conf);
  public native @Cast("bool") boolean DetectOrientationScript(IntBuffer orient_deg, FloatBuffer orient_conf,
                                 @Cast("const char**") @ByPtrPtr ByteBuffer script_name, FloatBuffer script_conf);
  public native @Cast("bool") boolean DetectOrientationScript(int[] orient_deg, float[] orient_conf,
                                 @Cast("const char**") @ByPtrPtr byte[] script_name, float[] script_conf);

  /**
   * The recognized text is returned as a char* which is coded
   * as UTF8 and must be freed with the delete [] operator.
   * page_number is a 0-based page index that will appear in the osd file.
   */
  public native @Cast("char*") BytePointer GetOsdText(int page_number);

  /** Returns the (average) confidence value between 0 and 100. */
  public native int MeanTextConf();
  /**
   * Returns all word confidences (between 0 and 100) in an array, terminated
   * by -1.  The calling function must delete [] after use.
   * The number of confidences should correspond to the number of space-
   * delimited words in GetUTF8Text.
   */
  public native IntPointer AllWordConfidences();

// #ifndef DISABLED_LEGACY_ENGINE
  /**
   * Applies the given word to the adaptive classifier if possible.
   * The word must be SPACE-DELIMITED UTF-8 - l i k e t h i s , so it can
   * tell the boundaries of the graphemes.
   * Assumes that SetImage/SetRectangle have been used to set the image
   * to the given word. The mode arg should be PSM_SINGLE_WORD or
   * PSM_CIRCLE_WORD, as that will be used to control layout analysis.
   * The currently set PageSegMode is preserved.
   * Returns false if adaption was not possible for some reason.
   */
  public native @Cast("bool") boolean AdaptToWordStr(@Cast("tesseract::PageSegMode") int mode, @Cast("const char*") BytePointer wordstr);
  public native @Cast("bool") boolean AdaptToWordStr(@Cast("tesseract::PageSegMode") int mode, String wordstr);
// #endif  //  ndef DISABLED_LEGACY_ENGINE

  /**
   * Free up recognition results and any stored image data, without actually
   * freeing any recognition data that would be time-consuming to reload.
   * Afterwards, you must call SetImage or TesseractRect before doing
   * any Recognize or Get* operation.
   */
  public native void Clear();

  /**
   * Close down tesseract and free up all memory. End() is equivalent to
   * destructing and reconstructing your TessBaseAPI.
   * Once End() has been used, none of the other API functions may be used
   * other than Init and anything declared above it in the class definition.
   */
  public native void End();

  /**
   * Clear any library-level memory caches.
   * There are a variety of expensive-to-load constant data structures (mostly
   * language dictionaries) that are cached globally -- surviving the Init()
   * and End() of individual TessBaseAPI's.  This function allows the clearing
   * of these caches.
   **/
  public static native void ClearPersistentCache();

  /**
   * Check whether a word is valid according to Tesseract's language model
   * @return 0 if the word is invalid, non-zero if valid.
   * \warning temporary! This function will be removed from here and placed
   * in a separate API at some future time.
   */
  public native int IsValidWord(@Cast("const char*") BytePointer word);
  public native int IsValidWord(String word);
  // Returns true if utf8_character is defined in the UniCharset.
  public native @Cast("bool") boolean IsValidCharacter(@Cast("const char*") BytePointer utf8_character);
  public native @Cast("bool") boolean IsValidCharacter(String utf8_character);


  public native @Cast("bool") boolean GetTextDirection(IntPointer out_offset, FloatPointer out_slope);
  public native @Cast("bool") boolean GetTextDirection(IntBuffer out_offset, FloatBuffer out_slope);
  public native @Cast("bool") boolean GetTextDirection(int[] out_offset, float[] out_slope);

  /** Sets Dict::letter_is_okay_ function to point to the given function. */
  public native void SetDictFunc(DictFunc f);

  /** Sets Dict::probability_in_context_ function to point to the given
   * function.
   */
  public native void SetProbabilityInContextFunc(ProbabilityInContextFunc f);

  /**
   * Estimates the Orientation And Script of the image.
   * @return true if the image was processed successfully.
   */
  public native @Cast("bool") boolean DetectOS(OSResults arg0);

  /**
   * Return text orientation of each block as determined by an earlier run
   * of layout analysis.
   */
  public native void GetBlockTextOrientations(@Cast("int**") PointerPointer block_orientation,
                                  @Cast("bool**") PointerPointer vertical_writing);
  public native void GetBlockTextOrientations(@ByPtrPtr IntPointer block_orientation,
                                  @Cast("bool**") @ByPtrPtr BoolPointer vertical_writing);
  public native void GetBlockTextOrientations(@ByPtrPtr IntBuffer block_orientation,
                                  @Cast("bool**") @ByPtrPtr boolean[] vertical_writing);
  public native void GetBlockTextOrientations(@ByPtrPtr int[] block_orientation,
                                  @Cast("bool**") @ByPtrPtr BoolPointer vertical_writing);
  public native void GetBlockTextOrientations(@ByPtrPtr IntPointer block_orientation,
                                  @Cast("bool**") @ByPtrPtr boolean[] vertical_writing);
  public native void GetBlockTextOrientations(@ByPtrPtr IntBuffer block_orientation,
                                  @Cast("bool**") @ByPtrPtr BoolPointer vertical_writing);
  public native void GetBlockTextOrientations(@ByPtrPtr int[] block_orientation,
                                  @Cast("bool**") @ByPtrPtr boolean[] vertical_writing);


//   #ifndef DISABLED_LEGACY_ENGINE

  /** Sets Wordrec::fill_lattice_ function to point to the given function. */
  

  /** Find lines from the image making the BLOCK_LIST. */
  public native BLOCK_LIST FindLinesCreateBlockList();

  /**
   * Delete a block list.
   * This is to keep BLOCK_LIST pointer opaque
   * and let go of including the other headers.
   */
  public static native void DeleteBlockList(BLOCK_LIST block_list);

  /** Returns a ROW object created from the input row specification. */
  public static native ROW MakeTessOCRRow(float baseline, float xheight,
                               float descender, float ascender);

  /** Returns a TBLOB corresponding to the entire input image. */
  public static native TBLOB MakeTBLOB(PIX pix);

  /**
   * This method baseline normalizes a TBLOB in-place. The input row is used
   * for normalization. The denorm is an optional parameter in which the
   * normalization-antidote is returned.
   */
  public static native void NormalizeTBLOB(TBLOB tblob, ROW row, @Cast("bool") boolean numeric_mode);

  /** This method returns the features associated with the input image. */
  public native void GetFeaturesForBlob(TBLOB blob, INT_FEATURE_STRUCT int_features,
                            IntPointer num_features, IntPointer feature_outline_index);
  public native void GetFeaturesForBlob(TBLOB blob, INT_FEATURE_STRUCT int_features,
                            IntBuffer num_features, IntBuffer feature_outline_index);
  public native void GetFeaturesForBlob(TBLOB blob, INT_FEATURE_STRUCT int_features,
                            int[] num_features, int[] feature_outline_index);

  /**
   * This method returns the row to which a box of specified dimensions would
   * belong. If no good match is found, it returns nullptr.
   */
  public static native ROW FindRowForBox(BLOCK_LIST blocks, int left, int top,
                              int right, int bottom);

  /**
   * Method to run adaptive classifier on a blob.
   * It returns at max num_max_matches results.
   */
  public native void RunAdaptiveClassifier(TBLOB blob,
                               int num_max_matches,
                               IntPointer unichar_ids,
                               FloatPointer ratings,
                               IntPointer num_matches_returned);
  public native void RunAdaptiveClassifier(TBLOB blob,
                               int num_max_matches,
                               IntBuffer unichar_ids,
                               FloatBuffer ratings,
                               IntBuffer num_matches_returned);
  public native void RunAdaptiveClassifier(TBLOB blob,
                               int num_max_matches,
                               int[] unichar_ids,
                               float[] ratings,
                               int[] num_matches_returned);
// #endif  // ndef DISABLED_LEGACY_ENGINE

  /** This method returns the string form of the specified unichar. */
  public native @Cast("const char*") BytePointer GetUnichar(int unichar_id);

  /** Return the pointer to the i-th dawg loaded into tesseract_ object. */
  public native @Const Dawg GetDawg(int i);

  /** Return the number of dawgs loaded into tesseract_ object. */
  public native int NumDawgs();

  public native Tesseract tesseract();

  public native @Cast("tesseract::OcrEngineMode") int oem();

  public native void InitTruthCallback(@Cast("tesseract::TruthCallback*") TruthCallback4 cb);

  public native void set_min_orientation_margin(double margin);
}
