/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.javacc;

import java.io.File;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.mojo.javacc.AbstractPreprocessorMojo;
import org.codehaus.mojo.javacc.GrammarInfo;
import org.codehaus.mojo.javacc.JJTree;

@Mojo(name="jjtree", defaultPhase=LifecyclePhase.GENERATE_SOURCES)
public class JJTreeMojo
extends AbstractPreprocessorMojo {
    @Parameter(property="javacc.jdkVersion")
    private String jdkVersion;
    @Parameter(property="javacc.buildNodeFiles")
    private Boolean buildNodeFiles;
    @Parameter(property="javacc.multi")
    private Boolean multi;
    @Parameter(property="javacc.nodeDefaultVoid")
    private Boolean nodeDefaultVoid;
    @Parameter(property="javacc.nodeClass")
    private String nodeClass;
    @Parameter(property="javacc.nodeFactory")
    private String nodeFactory;
    @Parameter(property="javacc.nodePackage")
    private String nodePackage;
    private String nodePrefix;
    @Parameter(property="javacc.nodeScopeHook")
    private Boolean nodeScopeHook;
    @Parameter(property="javacc.nodeUsesParser")
    private Boolean nodeUsesParser;
    @Parameter(property="javacc.isStatic", alias="javacc.staticOption")
    private Boolean isStatic;
    @Parameter(property="javacc.trackTokens")
    private Boolean trackTokens;
    @Parameter(property="javacc.visitor")
    private Boolean visitor;
    @Parameter(property="javacc.visitorDataType")
    private String visitorDataType;
    @Parameter(property="javacc.visitorReturnType")
    private String visitorReturnType;
    @Parameter(property="javacc.visitorException")
    private String visitorException;
    @Parameter(property="javacc.sourceDirectory", defaultValue="${basedir}/src/main/jjtree")
    private File sourceDirectory;
    @Parameter(property="javacc.outputDirectory", defaultValue="${project.build.directory}/generated-sources/jjtree")
    private File outputDirectory;
    @Parameter(property="javacc.timestampDirectory", defaultValue="${project.build.directory}/generated-sources/jjtree-timestamp")
    private File timestampDirectory;
    @Parameter(property="javacc.lastModGranularityMs", defaultValue="0")
    private int staleMillis;
    @Parameter
    private String[] includes;
    @Parameter
    private String[] excludes;

    @Override
    protected File getSourceDirectory() {
        return this.sourceDirectory;
    }

    @Override
    protected String[] getIncludes() {
        if (this.includes != null) {
            return this.includes;
        }
        return new String[]{"**/*.jjt", "**/*.JJT"};
    }

    @Override
    protected String[] getExcludes() {
        return this.excludes;
    }

    @Override
    protected File getOutputDirectory() {
        return this.outputDirectory;
    }

    @Override
    protected File getTimestampDirectory() {
        return this.timestampDirectory;
    }

    @Override
    protected int getStaleMillis() {
        return this.staleMillis;
    }

    @Override
    protected void processGrammar(GrammarInfo grammarInfo) throws MojoExecutionException, MojoFailureException {
        File jjtFile = grammarInfo.getGrammarFile();
        String nodePackageName = grammarInfo.resolvePackageName(this.nodePackage);
        File nodeDirectory = nodePackageName != null ? new File(nodePackageName.replace('.', File.separatorChar)) : new File(grammarInfo.getParserDirectory());
        nodeDirectory = new File(this.getOutputDirectory(), nodeDirectory.getPath());
        JJTree jjtree = this.newJJTree();
        jjtree.setInputFile(jjtFile);
        jjtree.setOutputDirectory(nodeDirectory);
        jjtree.setNodePackage(nodePackageName);
        jjtree.run();
        this.createTimestamp(grammarInfo);
    }

    protected JJTree newJJTree() {
        JJTree jjtree = new JJTree();
        jjtree.setLog(this.getLog());
        jjtree.setJdkVersion(this.jdkVersion);
        jjtree.setStatic(this.isStatic);
        jjtree.setBuildNodeFiles(this.buildNodeFiles);
        jjtree.setMulti(this.multi);
        jjtree.setNodeDefaultVoid(this.nodeDefaultVoid);
        jjtree.setNodeClass(this.nodeClass);
        jjtree.setNodeFactory(this.nodeFactory);
        jjtree.setNodePrefix(this.nodePrefix);
        jjtree.setNodeScopeHook(this.nodeScopeHook);
        jjtree.setNodeUsesParser(this.nodeUsesParser);
        jjtree.setTrackTokens(this.trackTokens);
        jjtree.setVisitor(this.visitor);
        jjtree.setVisitorDataType(this.visitorDataType);
        jjtree.setVisitorReturnType(this.visitorReturnType);
        jjtree.setVisitorException(this.visitorException);
        return jjtree;
    }

    @Override
    protected void addCompileSourceRoot() {
    }
}

