/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.sonar;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.InvalidPluginDescriptorException;
import org.apache.maven.plugin.MavenPluginManager;
import org.apache.maven.plugin.PluginContainerException;
import org.apache.maven.plugin.PluginDescriptorParsingException;
import org.apache.maven.plugin.PluginResolutionException;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.codehaus.mojo.sonar.MavenPluginManagerHelper;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.Logger;

@Component(role=MavenPluginManagerHelper.class)
public class DefaultMavenPluginManagerHelper
implements MavenPluginManagerHelper {
    @Requirement
    private Logger logger;
    @Requirement
    protected MavenPluginManager mavenPluginManager;
    private Method setupPluginRealm;
    private Method getPluginDescriptor;
    private Method getRepositorySession;

    public DefaultMavenPluginManagerHelper() {
        try {
            for (Method m : MavenPluginManager.class.getMethods()) {
                if ("setupPluginRealm".equals(m.getName())) {
                    this.setupPluginRealm = m;
                    continue;
                }
                if (!"getPluginDescriptor".equals(m.getName())) continue;
                this.getPluginDescriptor = m;
            }
        }
        catch (SecurityException e) {
            this.logger.warn("unable to find MavenPluginManager.setupPluginRealm() method", (Throwable)e);
        }
        try {
            for (Method m : MavenSession.class.getMethods()) {
                if (!"getRepositorySession".equals(m.getName())) continue;
                this.getRepositorySession = m;
                break;
            }
        }
        catch (SecurityException e) {
            this.logger.warn("unable to find MavenSession.getRepositorySession() method", (Throwable)e);
        }
    }

    @Override
    public PluginDescriptor getPluginDescriptor(Plugin plugin, MavenSession session) throws PluginResolutionException, PluginDescriptorParsingException, InvalidPluginDescriptorException {
        try {
            Object repositorySession = this.getRepositorySession.invoke((Object)session, new Object[0]);
            List remoteRepositories = session.getCurrentProject().getRemotePluginRepositories();
            return (PluginDescriptor)this.getPluginDescriptor.invoke((Object)this.mavenPluginManager, plugin, remoteRepositories, repositorySession);
        }
        catch (IllegalArgumentException e) {
            this.logger.warn("IllegalArgumentException during MavenPluginManager.getPluginDescriptor() call", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            this.logger.warn("IllegalAccessException during MavenPluginManager.getPluginDescriptor() call", (Throwable)e);
        }
        catch (InvocationTargetException e) {
            Throwable target = e.getTargetException();
            if (target instanceof PluginResolutionException) {
                throw (PluginResolutionException)target;
            }
            if (target instanceof PluginDescriptorParsingException) {
                throw (PluginDescriptorParsingException)target;
            }
            if (target instanceof InvalidPluginDescriptorException) {
                throw (InvalidPluginDescriptorException)target;
            }
            if (target instanceof RuntimeException) {
                throw (RuntimeException)target;
            }
            if (target instanceof Error) {
                throw (Error)target;
            }
            this.logger.warn("Exception during MavenPluginManager.getPluginDescriptor() call", (Throwable)e);
        }
        return null;
    }

    @Override
    public void setupPluginRealm(PluginDescriptor pluginDescriptor, MavenSession session, ClassLoader parent, List<String> imports) throws PluginResolutionException, PluginContainerException {
        try {
            this.setupPluginRealm.invoke((Object)this.mavenPluginManager, pluginDescriptor, session, parent, imports, null);
        }
        catch (IllegalArgumentException e) {
            this.logger.warn("IllegalArgumentException during MavenPluginManager.setupPluginRealm() call", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            this.logger.warn("IllegalAccessException during MavenPluginManager.setupPluginRealm() call", (Throwable)e);
        }
        catch (InvocationTargetException e) {
            Throwable target = e.getTargetException();
            if (target instanceof PluginResolutionException) {
                throw (PluginResolutionException)target;
            }
            if (target instanceof PluginContainerException) {
                throw (PluginContainerException)target;
            }
            if (target instanceof RuntimeException) {
                throw (RuntimeException)target;
            }
            if (target instanceof Error) {
                throw (Error)target;
            }
            this.logger.warn("Exception during MavenPluginManager.setupPluginRealm() call", (Throwable)e);
        }
    }
}

