/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.fonts.fop.fonts.truetype;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;

public class FontFileReader {
    private final int fsize;
    private int current;
    private final byte[] file;

    public FontFileReader(InputStream in) throws IOException {
        this.file = IOUtils.toByteArray((InputStream)in);
        this.fsize = this.file.length;
        this.current = 0;
    }

    public void seekSet(long offset) throws IOException {
        if (offset > (long)this.fsize || offset < 0L) {
            throw new EOFException("Reached EOF, file size=" + this.fsize + " offset=" + offset);
        }
        this.current = (int)offset;
    }

    public void skip(long add) throws IOException {
        this.seekSet((long)this.current + add);
    }

    public int getCurrentPos() {
        return this.current;
    }

    public int getFileSize() {
        return this.fsize;
    }

    byte read() throws IOException {
        if (this.current >= this.fsize) {
            throw new EOFException("Reached EOF, file size=" + this.fsize);
        }
        byte ret = this.file[this.current++];
        return ret;
    }

    public final byte readTTFByte() throws IOException {
        return this.read();
    }

    public final int readTTFUByte() throws IOException {
        byte buf = this.read();
        if (buf < 0) {
            return 256 + buf;
        }
        return buf;
    }

    public final short readTTFShort() throws IOException {
        int ret = (this.readTTFUByte() << 8) + this.readTTFUByte();
        short sret = (short)ret;
        return sret;
    }

    public final int readTTFUShort() throws IOException {
        int ret = (this.readTTFUByte() << 8) + this.readTTFUByte();
        return ret;
    }

    public final void writeTTFUShort(long pos, int val) throws IOException {
        if (pos + 2L > (long)this.fsize) {
            throw new EOFException("Reached EOF");
        }
        byte b1 = (byte)(val >> 8 & 0xFF);
        byte b2 = (byte)(val & 0xFF);
        int fileIndex = (int)pos;
        this.file[fileIndex] = b1;
        this.file[fileIndex + 1] = b2;
    }

    public final short readTTFShort(long pos) throws IOException {
        long cp = this.getCurrentPos();
        this.seekSet(pos);
        short ret = this.readTTFShort();
        this.seekSet(cp);
        return ret;
    }

    public final int readTTFUShort(long pos) throws IOException {
        long cp = this.getCurrentPos();
        this.seekSet(pos);
        int ret = this.readTTFUShort();
        this.seekSet(cp);
        return ret;
    }

    public final int readTTFLong() throws IOException {
        long ret = this.readTTFUByte();
        ret = (ret << 8) + (long)this.readTTFUByte();
        ret = (ret << 8) + (long)this.readTTFUByte();
        ret = (ret << 8) + (long)this.readTTFUByte();
        return (int)ret;
    }

    public final long readTTFULong() throws IOException {
        long ret = this.readTTFUByte();
        ret = (ret << 8) + (long)this.readTTFUByte();
        ret = (ret << 8) + (long)this.readTTFUByte();
        ret = (ret << 8) + (long)this.readTTFUByte();
        return ret;
    }

    public final String readTTFString() throws IOException {
        int i = this.current;
        while (this.file[i++] != 0) {
            if (i < this.fsize) continue;
            throw new EOFException("Reached EOF, file size=" + this.fsize);
        }
        byte[] tmp = new byte[i - this.current - 1];
        System.arraycopy(this.file, this.current, tmp, 0, i - this.current - 1);
        return new String(tmp, "ISO-8859-1");
    }

    public final String readTTFString(int len) throws IOException {
        if (len + this.current > this.fsize) {
            throw new EOFException("Reached EOF, file size=" + this.fsize);
        }
        byte[] tmp = new byte[len];
        System.arraycopy(this.file, this.current, tmp, 0, len);
        this.current += len;
        String encoding = tmp.length > 0 && tmp[0] == 0 ? "UTF-16BE" : "ISO-8859-1";
        return new String(tmp, encoding);
    }

    public final String readTTFString(int len, int encodingID) throws IOException {
        if (len + this.current > this.fsize) {
            throw new EOFException("Reached EOF, file size=" + this.fsize);
        }
        byte[] tmp = new byte[len];
        System.arraycopy(this.file, this.current, tmp, 0, len);
        this.current += len;
        String encoding = "UTF-16BE";
        return new String(tmp, encoding);
    }

    public byte[] getBytes(int offset, int length) throws IOException {
        if (offset + length > this.fsize) {
            throw new IOException("Reached EOF");
        }
        byte[] ret = new byte[length];
        System.arraycopy(this.file, offset, ret, 0, length);
        return ret;
    }

    public byte[] getAllBytes() {
        return this.file;
    }
}

