/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.warm.flow.ui.convert;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.dromara.warm.flow.core.FlowEngine;
import org.dromara.warm.flow.core.entity.Node;
import org.dromara.warm.flow.core.entity.Skip;
import org.dromara.warm.flow.core.enums.NodeType;
import org.dromara.warm.flow.core.enums.SkipType;
import org.dromara.warm.flow.core.utils.StringUtils;
import org.dromara.warm.flow.ui.convert.BetweenNodeConvert;
import org.dromara.warm.flow.ui.convert.EndNodeConvert;
import org.dromara.warm.flow.ui.convert.NodeConvertAbstract;
import org.dromara.warm.flow.ui.convert.ParallelNodeConvert;
import org.dromara.warm.flow.ui.convert.SerialNodeConvert;
import org.dromara.warm.flow.ui.convert.StartNodeConvert;

public class NodeConvertUtil {
    private static Map<String, NodeConvertAbstract> nodeConvertMap = new ConcurrentHashMap<String, NodeConvertAbstract>();

    public static List<Node> convert(List<Map<String, Object>> jsonArray, String startNodeId, String endNodeId) {
        ArrayList<Node> seaflowNodeList = new ArrayList<Node>();
        if (StringUtils.isEmpty((String)startNodeId)) {
            startNodeId = (String)jsonArray.get(0).get("nodeId");
        }
        if (StringUtils.isEmpty((String)endNodeId)) {
            endNodeId = (String)jsonArray.get(jsonArray.size() - 1).get("nodeId");
        }
        String nextNodeId = null;
        for (int i = 0; i < jsonArray.size(); ++i) {
            Map<String, Object> node = jsonArray.get(i);
            String type = (String)node.get("nodeType");
            if (i + 1 < jsonArray.size()) {
                Map<String, Object> nextNode = jsonArray.get(i + 1);
                nextNodeId = (String)nextNode.get("nodeId");
                if (NodeType.isGateWay((Integer)NodeType.getKeyByValue((String)((String)nextNode.get("nodeType")))).booleanValue() && NodeType.isGateWay((Integer)NodeType.getKeyByValue((String)type)).booleanValue()) {
                    String emptyNodeCode = UUID.randomUUID().toString();
                    Node emptyNode = FlowEngine.newNode();
                    emptyNode.setNodeCode(emptyNodeCode);
                    emptyNode.setNodeType(NodeType.BETWEEN.getKey());
                    emptyNode.setPermissionFlag("auto");
                    ArrayList<Skip> emptySkip = new ArrayList<Skip>();
                    Skip emSkip = FlowEngine.newSkip();
                    emSkip.setSkipType(SkipType.PASS.getKey());
                    emSkip.setNextNodeCode(nextNodeId);
                    emptySkip.add(emSkip);
                    emptyNode.setSkipList(emptySkip);
                    seaflowNodeList.add(emptyNode);
                    nextNodeId = emptyNodeCode;
                }
            } else {
                nextNodeId = null;
            }
            NodeConvertAbstract nodeConvert = nodeConvertMap.get(type);
            if (nodeConvert == null) continue;
            List<Node> convert = nodeConvert.convert(node, startNodeId, endNodeId, nextNodeId);
            seaflowNodeList.addAll(convert);
        }
        return seaflowNodeList;
    }

    static {
        nodeConvertMap.put(NodeType.START.getValue(), new StartNodeConvert());
        nodeConvertMap.put(NodeType.BETWEEN.getValue(), new BetweenNodeConvert());
        nodeConvertMap.put(NodeType.SERIAL.getValue(), new SerialNodeConvert());
        nodeConvertMap.put(NodeType.PARALLEL.getValue(), new ParallelNodeConvert());
        nodeConvertMap.put(NodeType.END.getValue(), new EndNodeConvert());
    }
}

