/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.elements;

import java.net.InetSocketAddress;
import org.eclipse.californium.elements.Definition;
import org.eclipse.californium.elements.DtlsEndpointContext;
import org.eclipse.californium.elements.EndpointContext;
import org.eclipse.californium.elements.EndpointContextMatcher;
import org.eclipse.californium.elements.EndpointContextUtil;
import org.eclipse.californium.elements.MapBasedEndpointContext;
import org.eclipse.californium.elements.RelaxedDtlsEndpointContextMatcher;
import org.eclipse.californium.elements.StrictDtlsEndpointContextMatcher;
import org.eclipse.californium.elements.UdpEndpointContext;
import org.eclipse.californium.elements.rule.LoggingRule;
import org.eclipse.californium.elements.util.Bytes;
import org.eclipse.californium.elements.util.ExpectedExceptionWrapper;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class DtlsEndpointContextMatcherTest {
    private static final InetSocketAddress ADDRESS = new InetSocketAddress(0);
    private static final String SCOPE = "californium.eclipseprojects.io";
    @Rule
    public ExpectedException exception = ExpectedExceptionWrapper.none();
    @Rule
    public LoggingRule logging = new LoggingRule();
    private EndpointContext connectorContext;
    private EndpointContext scopedConnectorContext;
    private EndpointContext relaxedMessageContext;
    private EndpointContext scopedRelaxedMessageContext;
    private EndpointContext strictMessageContext;
    private EndpointContext scopedStrictMessageContext;
    private EndpointContext noneCriticalMessageContext;
    private EndpointContext scopedNoneCriticalMessageContext;
    private EndpointContext strictNoneCriticalMessageContext;
    private EndpointContext scopedStrictNoneCriticalMessageContext;
    private EndpointContext differentMessageContext;
    private EndpointContext scopedDifferentMessageContext;
    private EndpointContext unsecureMessageContext;
    private EndpointContextMatcher relaxedMatcher;
    private EndpointContextMatcher strictMatcher;

    @Before
    public void setup() {
        Bytes session = new Bytes("session".getBytes());
        Bytes newSession = new Bytes("new-session".getBytes());
        this.relaxedMatcher = new RelaxedDtlsEndpointContextMatcher();
        this.strictMatcher = new StrictDtlsEndpointContextMatcher();
        this.connectorContext = new DtlsEndpointContext(ADDRESS, null, null, session, 1, "CIPHER", 100L);
        this.scopedConnectorContext = new DtlsEndpointContext(ADDRESS, SCOPE, null, session, 1, "CIPHER", 100L);
        this.relaxedMessageContext = new DtlsEndpointContext(ADDRESS, null, null, session, 2, "CIPHER", 200L);
        this.scopedRelaxedMessageContext = new DtlsEndpointContext(ADDRESS, SCOPE, null, session, 2, "CIPHER", 200L);
        this.strictMessageContext = new DtlsEndpointContext(ADDRESS, null, null, session, 1, "CIPHER", 100L);
        this.scopedStrictMessageContext = new DtlsEndpointContext(ADDRESS, SCOPE, null, session, 1, "CIPHER", 100L);
        this.differentMessageContext = new DtlsEndpointContext(ADDRESS, null, null, newSession, 1, "CIPHER", 100L);
        this.scopedDifferentMessageContext = new DtlsEndpointContext(ADDRESS, SCOPE, null, newSession, 1, "CIPHER", 100L);
        this.unsecureMessageContext = new UdpEndpointContext(ADDRESS);
        this.noneCriticalMessageContext = new MapBasedEndpointContext(ADDRESS, null, new MapBasedEndpointContext.Attributes().add(DtlsEndpointContext.KEY_AUTO_HANDSHAKE_TIMEOUT, (Object)30000));
        this.scopedNoneCriticalMessageContext = new MapBasedEndpointContext(ADDRESS, SCOPE, null, new MapBasedEndpointContext.Attributes().add(DtlsEndpointContext.KEY_AUTO_HANDSHAKE_TIMEOUT, (Object)30000));
        this.strictNoneCriticalMessageContext = new MapBasedEndpointContext(ADDRESS, null, new MapBasedEndpointContext.Attributes().add(DtlsEndpointContext.KEY_SESSION_ID, (Object)session).add(DtlsEndpointContext.KEY_EPOCH, (Object)1).add(DtlsEndpointContext.KEY_CIPHER, (Object)"CIPHER").add(DtlsEndpointContext.KEY_AUTO_HANDSHAKE_TIMEOUT, (Object)30000));
        this.scopedStrictNoneCriticalMessageContext = new MapBasedEndpointContext(ADDRESS, SCOPE, null, new MapBasedEndpointContext.Attributes().add(DtlsEndpointContext.KEY_SESSION_ID, (Object)session).add(DtlsEndpointContext.KEY_EPOCH, (Object)1).add(DtlsEndpointContext.KEY_CIPHER, (Object)"CIPHER").add(DtlsEndpointContext.KEY_AUTO_HANDSHAKE_TIMEOUT, (Object)30000));
    }

    @Test
    public void testRelaxedWithConnectionEndpointContext() {
        this.logging.setLoggingLevel("ERROR", EndpointContextUtil.class);
        MatcherAssert.assertThat((Object)this.relaxedMatcher.isToBeSent(this.relaxedMessageContext, this.connectorContext), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)this.relaxedMatcher.isToBeSent(this.scopedRelaxedMessageContext, this.connectorContext), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)this.relaxedMatcher.isToBeSent(this.differentMessageContext, this.connectorContext), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)this.relaxedMatcher.isToBeSent(this.scopedDifferentMessageContext, this.connectorContext), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)this.relaxedMatcher.isToBeSent(this.unsecureMessageContext, this.connectorContext), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)this.relaxedMatcher.isToBeSent(this.noneCriticalMessageContext, this.connectorContext), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)this.relaxedMatcher.isToBeSent(this.scopedNoneCriticalMessageContext, this.connectorContext), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)this.relaxedMatcher.isToBeSent(this.strictNoneCriticalMessageContext, this.connectorContext), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)this.relaxedMatcher.isToBeSent(this.scopedStrictNoneCriticalMessageContext, this.connectorContext), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void testRelaxedWithScopedConnectionEndpointContext() {
        this.logging.setLoggingLevel("ERROR", EndpointContextUtil.class);
        MatcherAssert.assertThat((Object)this.relaxedMatcher.isToBeSent(this.relaxedMessageContext, this.scopedConnectorContext), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)this.relaxedMatcher.isToBeSent(this.scopedRelaxedMessageContext, this.scopedConnectorContext), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)this.relaxedMatcher.isToBeSent(this.strictMessageContext, this.scopedConnectorContext), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)this.relaxedMatcher.isToBeSent(this.scopedStrictMessageContext, this.scopedConnectorContext), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)this.relaxedMatcher.isToBeSent(this.differentMessageContext, this.scopedConnectorContext), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)this.relaxedMatcher.isToBeSent(this.scopedDifferentMessageContext, this.scopedConnectorContext), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)this.relaxedMatcher.isToBeSent(this.unsecureMessageContext, this.scopedConnectorContext), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)this.relaxedMatcher.isToBeSent(this.noneCriticalMessageContext, this.scopedConnectorContext), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)this.relaxedMatcher.isToBeSent(this.scopedNoneCriticalMessageContext, this.scopedConnectorContext), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)this.relaxedMatcher.isToBeSent(this.strictNoneCriticalMessageContext, this.scopedConnectorContext), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)this.relaxedMatcher.isToBeSent(this.scopedStrictNoneCriticalMessageContext, this.scopedConnectorContext), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void testStrictWithConnectionEndpointContext() {
        this.logging.setLoggingLevel("ERROR", EndpointContextUtil.class);
        MatcherAssert.assertThat((Object)this.strictMatcher.isToBeSent(this.strictMessageContext, this.connectorContext), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)this.strictMatcher.isToBeSent(this.scopedStrictMessageContext, this.connectorContext), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)this.strictMatcher.isToBeSent(this.relaxedMessageContext, this.connectorContext), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)this.strictMatcher.isToBeSent(this.scopedRelaxedMessageContext, this.connectorContext), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)this.strictMatcher.isToBeSent(this.unsecureMessageContext, this.connectorContext), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)this.strictMatcher.isToBeSent(this.noneCriticalMessageContext, this.connectorContext), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)this.strictMatcher.isToBeSent(this.scopedNoneCriticalMessageContext, this.connectorContext), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)this.strictMatcher.isToBeSent(this.strictNoneCriticalMessageContext, this.connectorContext), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)this.strictMatcher.isToBeSent(this.scopedStrictNoneCriticalMessageContext, this.connectorContext), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void testStrictWithScopedConnectionEndpointContext() {
        this.logging.setLoggingLevel("ERROR", EndpointContextUtil.class);
        MatcherAssert.assertThat((Object)this.strictMatcher.isToBeSent(this.strictMessageContext, this.scopedConnectorContext), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)this.strictMatcher.isToBeSent(this.scopedStrictMessageContext, this.scopedConnectorContext), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)this.strictMatcher.isToBeSent(this.relaxedMessageContext, this.scopedConnectorContext), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)this.strictMatcher.isToBeSent(this.scopedRelaxedMessageContext, this.scopedConnectorContext), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)this.strictMatcher.isToBeSent(this.differentMessageContext, this.scopedConnectorContext), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)this.strictMatcher.isToBeSent(this.scopedDifferentMessageContext, this.scopedConnectorContext), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)this.strictMatcher.isToBeSent(this.unsecureMessageContext, this.scopedConnectorContext), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)this.strictMatcher.isToBeSent(this.noneCriticalMessageContext, this.scopedConnectorContext), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)this.strictMatcher.isToBeSent(this.scopedNoneCriticalMessageContext, this.scopedConnectorContext), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)this.strictMatcher.isToBeSent(this.strictNoneCriticalMessageContext, this.scopedConnectorContext), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)this.strictMatcher.isToBeSent(this.scopedStrictNoneCriticalMessageContext, this.scopedConnectorContext), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void testRelaxedWithoutConnectionEndpointContext() {
        MatcherAssert.assertThat((Object)this.relaxedMatcher.isToBeSent(this.relaxedMessageContext, null), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)this.relaxedMatcher.isToBeSent(this.scopedRelaxedMessageContext, null), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)this.relaxedMatcher.isToBeSent(this.differentMessageContext, null), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)this.relaxedMatcher.isToBeSent(this.scopedDifferentMessageContext, null), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)this.relaxedMatcher.isToBeSent(this.unsecureMessageContext, null), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)this.relaxedMatcher.isToBeSent(this.noneCriticalMessageContext, null), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)this.relaxedMatcher.isToBeSent(this.scopedNoneCriticalMessageContext, null), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)this.relaxedMatcher.isToBeSent(this.strictNoneCriticalMessageContext, null), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)this.relaxedMatcher.isToBeSent(this.scopedStrictNoneCriticalMessageContext, null), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void testStrictWithoutConnectionEndpointContext() {
        MatcherAssert.assertThat((Object)this.strictMatcher.isToBeSent(this.strictMessageContext, null), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)this.strictMatcher.isToBeSent(this.scopedStrictMessageContext, null), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)this.strictMatcher.isToBeSent(this.relaxedMessageContext, null), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)this.strictMatcher.isToBeSent(this.scopedRelaxedMessageContext, null), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)this.strictMatcher.isToBeSent(this.unsecureMessageContext, null), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)this.strictMatcher.isToBeSent(this.noneCriticalMessageContext, null), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)this.strictMatcher.isToBeSent(this.scopedNoneCriticalMessageContext, null), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)this.strictMatcher.isToBeSent(this.strictNoneCriticalMessageContext, null), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)this.strictMatcher.isToBeSent(this.scopedStrictNoneCriticalMessageContext, null), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void testAddNewEntries() {
        MapBasedEndpointContext context = MapBasedEndpointContext.addEntries((EndpointContext)this.strictMessageContext, (MapBasedEndpointContext.Attributes)new MapBasedEndpointContext.Attributes().add(DtlsEndpointContext.KEY_AUTO_HANDSHAKE_TIMEOUT, (Object)30000));
        MatcherAssert.assertThat((Object)context.getPeerAddress(), (Matcher)CoreMatchers.is((Object)this.strictMessageContext.getPeerAddress()));
        MatcherAssert.assertThat((Object)context.getVirtualHost(), (Matcher)CoreMatchers.is((Object)this.strictMessageContext.getVirtualHost()));
        MatcherAssert.assertThat((Object)context.getPeerIdentity(), (Matcher)CoreMatchers.is((Object)this.strictMessageContext.getPeerIdentity()));
        MatcherAssert.assertThat((Object)((Integer)context.get(DtlsEndpointContext.KEY_AUTO_HANDSHAKE_TIMEOUT)), (Matcher)CoreMatchers.is((Object)30000));
        context = MapBasedEndpointContext.addEntries((EndpointContext)this.scopedStrictMessageContext, (MapBasedEndpointContext.Attributes)new MapBasedEndpointContext.Attributes().add(DtlsEndpointContext.KEY_AUTO_HANDSHAKE_TIMEOUT, (Object)30000));
        MatcherAssert.assertThat((Object)context.getPeerAddress(), (Matcher)CoreMatchers.is((Object)this.scopedStrictMessageContext.getPeerAddress()));
        MatcherAssert.assertThat((Object)context.getVirtualHost(), (Matcher)CoreMatchers.is((Object)this.scopedStrictMessageContext.getVirtualHost()));
        MatcherAssert.assertThat((Object)context.getPeerIdentity(), (Matcher)CoreMatchers.is((Object)this.scopedStrictMessageContext.getPeerIdentity()));
        MatcherAssert.assertThat((Object)((Integer)context.get(DtlsEndpointContext.KEY_AUTO_HANDSHAKE_TIMEOUT)), (Matcher)CoreMatchers.is((Object)30000));
    }

    @Test
    public void testAddContainedEntries() {
        MapBasedEndpointContext context = MapBasedEndpointContext.addEntries((EndpointContext)this.noneCriticalMessageContext, (MapBasedEndpointContext.Attributes)new MapBasedEndpointContext.Attributes().add(DtlsEndpointContext.KEY_AUTO_HANDSHAKE_TIMEOUT, (Object)60000));
        MatcherAssert.assertThat((Object)context.getPeerAddress(), (Matcher)CoreMatchers.is((Object)this.noneCriticalMessageContext.getPeerAddress()));
        MatcherAssert.assertThat((Object)context.getVirtualHost(), (Matcher)CoreMatchers.is((Object)this.noneCriticalMessageContext.getVirtualHost()));
        MatcherAssert.assertThat((Object)context.getPeerIdentity(), (Matcher)CoreMatchers.is((Object)this.noneCriticalMessageContext.getPeerIdentity()));
        MatcherAssert.assertThat((Object)((Integer)context.get(DtlsEndpointContext.KEY_AUTO_HANDSHAKE_TIMEOUT)), (Matcher)CoreMatchers.is((Object)60000));
    }

    @Test
    public void testAddWithUnsupportedType() {
        this.exception.expect(IllegalArgumentException.class);
        this.exception.expectMessage("is not supported");
        Definition FAIL = new Definition("F", Float.class);
        MapBasedEndpointContext.Attributes attributes = new MapBasedEndpointContext.Attributes();
        attributes.add(FAIL, (Object)Float.valueOf(1.0f));
    }
}

