/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.elements;

import java.net.InetSocketAddress;
import java.security.Principal;
import org.eclipse.californium.elements.AddressEndpointContext;
import org.eclipse.californium.elements.DtlsEndpointContext;
import org.eclipse.californium.elements.EndpointContext;
import org.eclipse.californium.elements.EndpointContextMatcher;
import org.eclipse.californium.elements.PrincipalEndpointContextMatcher;
import org.eclipse.californium.elements.util.Bytes;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Before;
import org.junit.Test;

public class PrincipalEndpointContextMatcherTest {
    private static final InetSocketAddress ADDRESS = new InetSocketAddress(0);
    private Principal principal1;
    private Principal principal2;
    private Principal principal3;
    private EndpointContext connectionContext;
    private EndpointContext messageContext;
    private EndpointContext differentMessageContext;
    private EndpointContext unsecureMessageContext;
    private EndpointContextMatcher matcher;

    @Before
    public void setup() {
        Bytes session = new Bytes("session".getBytes());
        this.principal1 = new TestPrincipal("P1");
        this.principal2 = new TestPrincipal("P1");
        this.principal3 = new TestPrincipal("P3");
        this.connectionContext = new DtlsEndpointContext(ADDRESS, null, this.principal1, session, 1, "CIPHER", 100L);
        this.messageContext = new AddressEndpointContext(ADDRESS, this.principal2);
        this.differentMessageContext = new AddressEndpointContext(ADDRESS, this.principal3);
        this.unsecureMessageContext = new AddressEndpointContext(ADDRESS, null);
        this.matcher = new PrincipalEndpointContextMatcher();
    }

    @Test
    public void testWithConnectionEndpointContext() {
        MatcherAssert.assertThat((Object)this.matcher.isToBeSent(this.messageContext, this.connectionContext), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)this.matcher.isToBeSent(this.differentMessageContext, this.connectionContext), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)this.matcher.isToBeSent(this.unsecureMessageContext, this.connectionContext), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void testWithoutConnectionEndpointContext() {
        MatcherAssert.assertThat((Object)this.matcher.isToBeSent(this.messageContext, null), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)this.matcher.isToBeSent(this.differentMessageContext, null), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)this.matcher.isToBeSent(this.unsecureMessageContext, null), (Matcher)CoreMatchers.is((Object)true));
    }

    private static class TestPrincipal
    implements Principal {
        private final String name;

        public TestPrincipal(String name) {
            this.name = name;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public int hashCode() {
            return this.name.hashCode();
        }

        @Override
        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || !(other instanceof Principal)) {
                return false;
            }
            return this.name.equals(((Principal)other).getName());
        }
    }
}

