/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.elements;

import java.net.InetSocketAddress;
import org.eclipse.californium.elements.EndpointContext;
import org.eclipse.californium.elements.EndpointContextMatcher;
import org.eclipse.californium.elements.EndpointContextUtil;
import org.eclipse.californium.elements.TcpEndpointContext;
import org.eclipse.californium.elements.TcpEndpointContextMatcher;
import org.eclipse.californium.elements.rule.LoggingRule;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class TcpEndpointContextMatcherTest {
    private static final InetSocketAddress ADDRESS = new InetSocketAddress(0);
    @Rule
    public LoggingRule logging = new LoggingRule();
    private EndpointContext connectorContext;
    private EndpointContext messageContext;
    private EndpointContext differentMessageContext;
    private EndpointContextMatcher matcher;

    @Before
    public void setup() {
        long time = System.currentTimeMillis();
        this.connectorContext = new TcpEndpointContext(ADDRESS, "ID1", time);
        this.messageContext = new TcpEndpointContext(ADDRESS, "ID1", time);
        this.differentMessageContext = new TcpEndpointContext(ADDRESS, "ID2", System.currentTimeMillis());
        this.matcher = new TcpEndpointContextMatcher();
    }

    @Test
    public void testWithConnectorEndpointContext() {
        this.logging.setLoggingLevel("ERROR", EndpointContextUtil.class);
        MatcherAssert.assertThat((Object)this.matcher.isToBeSent(this.messageContext, this.connectorContext), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)this.matcher.isToBeSent(this.differentMessageContext, this.connectorContext), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void testWithoutConnectorEndpointContext() {
        this.logging.setLoggingLevel("ERROR", EndpointContextUtil.class);
        MatcherAssert.assertThat((Object)this.matcher.isToBeSent(this.messageContext, null), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)this.matcher.isToBeSent(this.differentMessageContext, null), (Matcher)CoreMatchers.is((Object)false));
    }
}

