/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.elements;

import java.net.InetSocketAddress;
import org.eclipse.californium.elements.EndpointContext;
import org.eclipse.californium.elements.EndpointContextMatcher;
import org.eclipse.californium.elements.EndpointContextUtil;
import org.eclipse.californium.elements.TlsEndpointContext;
import org.eclipse.californium.elements.TlsEndpointContextMatcher;
import org.eclipse.californium.elements.rule.LoggingRule;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class TlsEndpointContextMatcherTest {
    private static final InetSocketAddress ADDRESS = new InetSocketAddress(0);
    @Rule
    public LoggingRule logging = new LoggingRule();
    private EndpointContext connectorContext;
    private EndpointContext messageContext;
    private EndpointContext differentMessageContext;
    private EndpointContextMatcher matcher;

    @Before
    public void setup() {
        long time = System.currentTimeMillis();
        this.connectorContext = new TlsEndpointContext(ADDRESS, null, "ID1", "S1", "C1", time);
        this.messageContext = new TlsEndpointContext(ADDRESS, null, "ID1", "S1", "C1", time);
        this.differentMessageContext = new TlsEndpointContext(ADDRESS, null, "ID2", "S2", "C1", System.currentTimeMillis());
        this.matcher = new TlsEndpointContextMatcher();
    }

    @Test
    public void testWithConnectorEndpointContext() {
        this.logging.setLoggingLevel("ERROR", EndpointContextUtil.class);
        MatcherAssert.assertThat((Object)this.matcher.isToBeSent(this.messageContext, this.connectorContext), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)this.matcher.isToBeSent(this.differentMessageContext, this.connectorContext), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void testWithoutConnectorEndpointContext() {
        this.logging.setLoggingLevel("ERROR", EndpointContextUtil.class);
        MatcherAssert.assertThat((Object)this.matcher.isToBeSent(this.messageContext, null), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)this.matcher.isToBeSent(this.differentMessageContext, null), (Matcher)CoreMatchers.is((Object)false));
    }
}

