/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.elements;

import java.net.InetSocketAddress;
import org.eclipse.californium.elements.AddressEndpointContext;
import org.eclipse.californium.elements.DtlsEndpointContext;
import org.eclipse.californium.elements.EndpointContext;
import org.eclipse.californium.elements.EndpointContextMatcher;
import org.eclipse.californium.elements.EndpointContextUtil;
import org.eclipse.californium.elements.UdpEndpointContext;
import org.eclipse.californium.elements.UdpEndpointContextMatcher;
import org.eclipse.californium.elements.rule.LoggingRule;
import org.eclipse.californium.elements.util.Bytes;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class UdpEndpointContextMatcherTest {
    private static final InetSocketAddress ADDRESS = new InetSocketAddress(5683);
    private static final InetSocketAddress CHANGED_ADDRESS = new InetSocketAddress(5684);
    private static final InetSocketAddress MULTICAST_ADDRESS = new InetSocketAddress("224.0.1.187", 5683);
    @Rule
    public LoggingRule logging = new LoggingRule();
    private EndpointContext connectorContext;
    private EndpointContext addressContext;
    private EndpointContext messageContext;
    private EndpointContext multicastContext;
    private EndpointContext changedAddressContext;
    private EndpointContext secureMessageContext;
    private EndpointContextMatcher matcher;

    @Before
    public void setup() {
        Bytes session = new Bytes("session".getBytes());
        this.connectorContext = new UdpEndpointContext(ADDRESS);
        this.addressContext = new AddressEndpointContext(ADDRESS);
        this.messageContext = new UdpEndpointContext(ADDRESS);
        this.multicastContext = new UdpEndpointContext(MULTICAST_ADDRESS);
        this.changedAddressContext = new UdpEndpointContext(CHANGED_ADDRESS);
        this.secureMessageContext = new DtlsEndpointContext(ADDRESS, null, null, session, 1, "CIPHER", 100L);
        this.matcher = new UdpEndpointContextMatcher(true);
    }

    @Test
    public void testSending() {
        this.logging.setLoggingLevel("ERROR", EndpointContextUtil.class);
        MatcherAssert.assertThat((Object)this.matcher.isToBeSent(this.addressContext, this.connectorContext), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)this.matcher.isToBeSent(this.messageContext, this.connectorContext), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)this.matcher.isToBeSent(this.secureMessageContext, this.connectorContext), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)this.matcher.isToBeSent(this.multicastContext, this.connectorContext), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void testResponse() {
        this.logging.setLoggingLevel("ERROR", EndpointContextUtil.class);
        MatcherAssert.assertThat((Object)this.matcher.isResponseRelatedToRequest(this.messageContext, this.messageContext), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)this.matcher.isResponseRelatedToRequest(this.messageContext, this.secureMessageContext), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)this.matcher.isResponseRelatedToRequest(this.secureMessageContext, this.messageContext), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)this.matcher.isResponseRelatedToRequest(this.addressContext, this.messageContext), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)this.matcher.isResponseRelatedToRequest(this.messageContext, this.addressContext), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)this.matcher.isResponseRelatedToRequest(this.messageContext, this.changedAddressContext), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)this.matcher.isResponseRelatedToRequest(this.changedAddressContext, this.messageContext), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)this.matcher.isResponseRelatedToRequest(this.multicastContext, this.messageContext), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)this.matcher.isResponseRelatedToRequest(this.multicastContext, this.changedAddressContext), (Matcher)CoreMatchers.is((Object)true));
    }
}

