/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.elements.auth;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import org.eclipse.californium.elements.auth.RawPublicKeyIdentity;
import org.eclipse.californium.elements.util.JceProviderUtil;
import org.eclipse.californium.elements.util.TestCertificatesTools;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.Test;

public class RawPublicKeyIdentityTest {
    private static final String URI_PREFIX = "ni:///sha-256;";
    private static KeyPair ecKeyPair;
    private static KeyPair ed25519KeyPair;
    private static KeyPair ed448KeyPair;

    @BeforeClass
    public static void init() throws IOException {
        KeyPairGenerator generator;
        JceProviderUtil.init();
        try {
            generator = KeyPairGenerator.getInstance("EC");
            ecKeyPair = generator.generateKeyPair();
        }
        catch (NoSuchAlgorithmException e) {
            Assume.assumeNoException((String)"vm's without EC are not usable for CoAP!", (Throwable)e);
        }
        try {
            generator = KeyPairGenerator.getInstance("OID.1.3.101.112");
            ed25519KeyPair = generator.generateKeyPair();
        }
        catch (NoSuchAlgorithmException generator2) {
            // empty catch block
        }
        try {
            generator = KeyPairGenerator.getInstance("OID.1.3.101.113");
            ed448KeyPair = generator.generateKeyPair();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
    }

    @Test
    public void testGetNameReturnsNamedInterfaceUri() {
        RawPublicKeyIdentity id = new RawPublicKeyIdentity(ecKeyPair.getPublic());
        RawPublicKeyIdentityTest.assertThatNameIsValidNamedInterfaceUri(id.getName());
    }

    @Test
    public void testGetSubjectInfoReturnsEncodedKey() {
        RawPublicKeyIdentity id = new RawPublicKeyIdentity(ecKeyPair.getPublic());
        Assert.assertArrayEquals((byte[])id.getKey().getEncoded(), (byte[])id.getSubjectInfo());
    }

    @Test
    public void testConstructorCreatesEcPublicKeyFromSubjectInfo() throws GeneralSecurityException {
        byte[] subjectInfo = ecKeyPair.getPublic().getEncoded();
        RawPublicKeyIdentity principal = new RawPublicKeyIdentity(subjectInfo, ecKeyPair.getPublic().getAlgorithm());
        MatcherAssert.assertThat((Object)principal.getKey(), (Matcher)CoreMatchers.is((Object)ecKeyPair.getPublic()));
        principal = new RawPublicKeyIdentity(subjectInfo);
        MatcherAssert.assertThat((Object)principal.getKey(), (Matcher)CoreMatchers.is((Object)ecKeyPair.getPublic()));
        TestCertificatesTools.assertSigning("RPK", ecKeyPair.getPrivate(), principal.getKey(), "SHA256withECDSA");
    }

    @Test
    public void testConstructorCreatesEd25519PublicKeyFromSubjectInfo() throws GeneralSecurityException {
        Assume.assumeNotNull((Object[])new Object[]{"Ed25519 not supported by vm!", ed25519KeyPair});
        byte[] subjectInfo = ed25519KeyPair.getPublic().getEncoded();
        RawPublicKeyIdentity principal = new RawPublicKeyIdentity(subjectInfo, ed25519KeyPair.getPublic().getAlgorithm());
        MatcherAssert.assertThat((Object)principal.getKey(), (Matcher)CoreMatchers.is((Object)ed25519KeyPair.getPublic()));
        principal = new RawPublicKeyIdentity(subjectInfo);
        MatcherAssert.assertThat((Object)principal.getKey(), (Matcher)CoreMatchers.is((Object)ed25519KeyPair.getPublic()));
        TestCertificatesTools.assertSigning("RPK", ed25519KeyPair.getPrivate(), principal.getKey(), "ED25519");
    }

    @Test
    public void testConstructorCreatesEd448PublicKeyFromSubjectInfo() throws GeneralSecurityException {
        Assume.assumeNotNull((Object[])new Object[]{"Ed448 is not supported by vm!", ed448KeyPair});
        byte[] subjectInfo = ed448KeyPair.getPublic().getEncoded();
        RawPublicKeyIdentity principal = new RawPublicKeyIdentity(subjectInfo, ed448KeyPair.getPublic().getAlgorithm());
        MatcherAssert.assertThat((Object)principal.getKey(), (Matcher)CoreMatchers.is((Object)ed448KeyPair.getPublic()));
        principal = new RawPublicKeyIdentity(subjectInfo);
        MatcherAssert.assertThat((Object)principal.getKey(), (Matcher)CoreMatchers.is((Object)ed448KeyPair.getPublic()));
        TestCertificatesTools.assertSigning("RPK", ed448KeyPair.getPrivate(), principal.getKey(), "ED448");
    }

    private static void assertThatNameIsValidNamedInterfaceUri(String name) {
        Assert.assertTrue((boolean)name.startsWith(URI_PREFIX));
        String hash = name.substring(URI_PREFIX.length());
        Assert.assertFalse((boolean)hash.endsWith("="));
        Assert.assertFalse((boolean)hash.contains("+"));
        Assert.assertFalse((boolean)hash.contains("/"));
        Assert.assertFalse((boolean)hash.endsWith("\n"));
        Assert.assertFalse((boolean)hash.endsWith("\r"));
    }
}

