/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.elements.util;

import org.eclipse.californium.elements.util.Bytes;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;

public class BytesTest {
    @Test
    public void testBytesEquals() {
        byte[] data = new byte[]{0, 1, 2, 3};
        Bytes basic = new Bytes(data);
        TestBytes test = new TestBytes(data, 32, true, false);
        MatcherAssert.assertThat((Object)basic, (Matcher)CoreMatchers.is((Object)((Object)test)));
        MatcherAssert.assertThat((Object)((Object)test), (Matcher)CoreMatchers.is((Object)basic));
    }

    @Test
    public void testBytesNotEquals() {
        byte[] data = new byte[]{0, 1, 2, 3};
        Bytes basic = new Bytes(data);
        TestBytes test = new TestBytes(data, 32, true, true);
        MatcherAssert.assertThat((Object)basic, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.is((Object)((Object)test))));
        MatcherAssert.assertThat((Object)((Object)test), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.is((Object)basic)));
    }

    @Test
    public void testBytesNotCloned() {
        byte[] data = new byte[]{0, 1, 2, 3};
        Bytes basic = new Bytes(data);
        data[0] = (byte)(data[0] + 1);
        Assert.assertArrayEquals((byte[])data, (byte[])basic.getBytes());
    }

    @Test
    public void testBytesCloned() {
        byte[] data = new byte[]{0, 1, 2, 3};
        Bytes basic = new Bytes(data, 32, true);
        data[0] = (byte)(data[0] + 1);
        Assert.assertNotEquals((long)data[0], (long)basic.getBytes()[0]);
    }

    private static class TestBytes
    extends Bytes {
        private TestBytes(byte[] data, int maxLength, boolean copy, boolean useClassInEquals) {
            super(data, maxLength, copy, useClassInEquals);
        }
    }
}

