/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.elements.util;

import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.californium.elements.assume.TimeAssume;
import org.eclipse.californium.elements.rule.TestTimeRule;
import org.eclipse.californium.elements.util.LeastRecentlyUsedCache;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

public class LeastRecentlyUsedCacheTest {
    private static final long THRESHOLD_MILLIS = 300L;
    @Rule
    public TestTimeRule time = new TestTimeRule();
    LeastRecentlyUsedCache<Integer, String> cache;

    @Test
    public void testGetFailsWhenExpired() throws InterruptedException {
        int capacity = 5;
        int numberOfSessions = 1;
        this.givenACacheWithEntries(capacity, 300L, numberOfSessions);
        this.cache.setEvictingOnReadAccess(true);
        String eldest = (String)this.cache.getEldest();
        Integer key = Integer.valueOf(eldest);
        MatcherAssert.assertThat((Object)this.cache.get((Object)key), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        this.time.setTestTimeShift(400L, TimeUnit.MILLISECONDS);
        MatcherAssert.assertThat((Object)this.cache.get((Object)key), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void testGetSucceedsEvenExpired() throws InterruptedException {
        int capacity = 5;
        int numberOfSessions = 1;
        this.givenACacheWithEntries(capacity, 300L, numberOfSessions);
        this.cache.setEvictingOnReadAccess(false);
        String eldest = (String)this.cache.getEldest();
        Integer key = Integer.valueOf(eldest);
        MatcherAssert.assertThat((Object)this.cache.get((Object)key), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        MatcherAssert.assertThat((Object)this.cache.get((Object)key), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        this.time.setTestTimeShift(400L, TimeUnit.MILLISECONDS);
        MatcherAssert.assertThat((Object)this.cache.get((Object)key), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void testUpdate() throws InterruptedException {
        int capacity = 5;
        int numberOfSessions = 1;
        TimeAssume assume = new TimeAssume(this.time);
        this.givenACacheWithEntries(capacity, 300L, numberOfSessions);
        this.cache.setEvictingOnReadAccess(true);
        this.cache.setUpdatingOnReadAccess(false);
        String eldest = (String)this.cache.getEldest();
        Integer key = Integer.valueOf(eldest);
        this.time.setFixedTestTime(true);
        assume.sleep(150L);
        MatcherAssert.assertThat((Object)this.cache.get((Object)key), assume.inTime(CoreMatchers.is((Matcher)CoreMatchers.notNullValue())));
        MatcherAssert.assertThat((Object)this.cache.update((Object)key), assume.inTime(CoreMatchers.is((Object)true)));
        assume.sleep(200L);
        MatcherAssert.assertThat((Object)this.cache.get((Object)key), assume.inTime(CoreMatchers.is((Matcher)CoreMatchers.notNullValue())));
        MatcherAssert.assertThat((Object)this.cache.update((Object)key), assume.inTime(CoreMatchers.is((Object)true)));
        assume.sleep(150L);
        MatcherAssert.assertThat((Object)this.cache.get((Object)key), assume.inTime(CoreMatchers.is((Matcher)CoreMatchers.notNullValue())));
        assume.sleep(200L);
        MatcherAssert.assertThat((Object)this.cache.get((Object)key), assume.inTime(CoreMatchers.is((Matcher)CoreMatchers.nullValue())));
    }

    @Test
    public void testRemoveExpiredEntriesWithLimit() throws InterruptedException {
        int capacity = 10;
        int numberOfSessions = 10;
        TimeAssume assume = new TimeAssume(this.time);
        this.givenACacheWithEntries(capacity, 300L, numberOfSessions);
        this.cache.setEvictingOnReadAccess(false);
        this.cache.setUpdatingOnReadAccess(true);
        this.time.setFixedTestTime(true);
        assume.sleep(150L);
        MatcherAssert.assertThat((Object)this.cache.get((Object)2), assume.inTime(CoreMatchers.is((Matcher)CoreMatchers.notNullValue())));
        MatcherAssert.assertThat((Object)this.cache.get((Object)8), assume.inTime(CoreMatchers.is((Matcher)CoreMatchers.notNullValue())));
        MatcherAssert.assertThat((Object)this.cache.get((Object)5), assume.inTime(CoreMatchers.is((Matcher)CoreMatchers.notNullValue())));
        assume.sleep(200L);
        MatcherAssert.assertThat((Object)this.cache.removeExpiredEntries(3), (Matcher)CoreMatchers.is((Object)3));
        MatcherAssert.assertThat((Object)this.cache.removeExpiredEntries(10), (Matcher)CoreMatchers.is((Object)4));
        MatcherAssert.assertThat((Object)this.cache.removeExpiredEntries(1), (Matcher)CoreMatchers.is((Object)0));
        assume.sleep(200L);
        MatcherAssert.assertThat((Object)this.cache.removeExpiredEntries(10), (Matcher)CoreMatchers.is((Object)3));
        MatcherAssert.assertThat((Object)this.cache.removeExpiredEntries(1), (Matcher)CoreMatchers.is((Object)0));
    }

    @Test
    public void testRemoveExpiredEntriesWithoutLimit() throws InterruptedException {
        int capacity = 10;
        int numberOfSessions = 10;
        TimeAssume assume = new TimeAssume(this.time);
        this.givenACacheWithEntries(capacity, 300L, numberOfSessions);
        this.cache.setEvictingOnReadAccess(false);
        this.cache.setUpdatingOnReadAccess(true);
        this.time.setFixedTestTime(true);
        assume.sleep(150L);
        MatcherAssert.assertThat((Object)this.cache.get((Object)2), assume.inTime(CoreMatchers.is((Matcher)CoreMatchers.notNullValue())));
        MatcherAssert.assertThat((Object)this.cache.get((Object)8), assume.inTime(CoreMatchers.is((Matcher)CoreMatchers.notNullValue())));
        MatcherAssert.assertThat((Object)this.cache.get((Object)5), assume.inTime(CoreMatchers.is((Matcher)CoreMatchers.notNullValue())));
        assume.sleep(200L);
        MatcherAssert.assertThat((Object)this.cache.removeExpiredEntries(0), (Matcher)CoreMatchers.is((Object)7));
        MatcherAssert.assertThat((Object)this.cache.removeExpiredEntries(0), (Matcher)CoreMatchers.is((Object)0));
        assume.sleep(200L);
        MatcherAssert.assertThat((Object)this.cache.removeExpiredEntries(0), (Matcher)CoreMatchers.is((Object)3));
        MatcherAssert.assertThat((Object)this.cache.removeExpiredEntries(0), (Matcher)CoreMatchers.is((Object)0));
    }

    @Test
    public void testIteratorWhenExpired() throws InterruptedException {
        int capacity = 5;
        int numberOfSessions = 5;
        TimeAssume assume = new TimeAssume(this.time);
        this.givenACacheWithEntries(capacity, 300L, numberOfSessions);
        this.cache.setEvictingOnReadAccess(true);
        this.time.setFixedTestTime(true);
        assume.sleep(150L);
        Iterator valuesIterator = this.cache.valuesIterator();
        this.cache.setUpdatingOnReadAccess(true);
        this.assertNext(valuesIterator, assume);
        this.cache.setUpdatingOnReadAccess(false);
        this.assertNext(valuesIterator, assume);
        this.cache.setUpdatingOnReadAccess(true);
        this.assertNext(valuesIterator, assume);
        this.cache.setUpdatingOnReadAccess(false);
        this.assertNext(valuesIterator, assume);
        this.cache.setUpdatingOnReadAccess(true);
        this.assertNext(valuesIterator, assume);
        assume.sleep(170L, 100L);
        valuesIterator = this.cache.valuesIterator();
        this.assertNext(valuesIterator, assume);
        this.assertNext(valuesIterator, assume);
        this.assertNext(valuesIterator, assume);
        Assert.assertFalse((boolean)valuesIterator.hasNext());
    }

    @Test
    public void testIteratorOnRemove() throws InterruptedException {
        int capacity = 5;
        int numberOfSessions = 5;
        this.givenACacheWithEntries(capacity, 300L, numberOfSessions);
        this.cache.setEvictingOnReadAccess(false);
        Iterator valuesIterator = this.cache.valuesIterator();
        this.cache.remove((Object)2);
        this.cache.remove((Object)4);
        MatcherAssert.assertThat(valuesIterator.next(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        MatcherAssert.assertThat(valuesIterator.next(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        MatcherAssert.assertThat(valuesIterator.next(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        MatcherAssert.assertThat((Object)valuesIterator.hasNext(), (Matcher)CoreMatchers.is((Object)false));
    }

    private void assertNext(Iterator<String> iterator, TimeAssume assume) {
        String value = iterator.hasNext() ? iterator.next() : null;
        MatcherAssert.assertThat((Object)value, assume.inTime(CoreMatchers.is((Matcher)CoreMatchers.notNullValue())));
    }

    @Test
    public void testIteratorTimestamped() throws InterruptedException {
        int capacity = 5;
        int numberOfSessions = 5;
        LeastRecentlyUsedCache clone = new LeastRecentlyUsedCache(3, 0L);
        this.givenACacheWithEntries(capacity, 300L, numberOfSessions);
        this.cache.setEvictingOnReadAccess(false);
        this.cache.remove((Object)2);
        this.assertOrder(this.cache, false);
        Iterator valuesIterator = this.cache.timestampedIterator();
        LeastRecentlyUsedCache.Timestamped timestamped = (LeastRecentlyUsedCache.Timestamped)valuesIterator.next();
        MatcherAssert.assertThat((String)"missing 1.", (Object)timestamped, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        LeastRecentlyUsedCache.Timestamped first = timestamped;
        int id = capacity + 1;
        Assert.assertTrue((boolean)clone.put((Object)id++, timestamped.getValue(), timestamped.getLastUpdate()));
        timestamped = (LeastRecentlyUsedCache.Timestamped)valuesIterator.next();
        MatcherAssert.assertThat((String)"missing 2.", (Object)timestamped, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertTrue((boolean)clone.put((Object)id++, timestamped.getValue(), timestamped.getLastUpdate()));
        timestamped = (LeastRecentlyUsedCache.Timestamped)valuesIterator.next();
        MatcherAssert.assertThat((String)"missing 3.", (Object)timestamped, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertTrue((boolean)clone.put((Object)id++, timestamped.getValue(), timestamped.getLastUpdate()));
        timestamped = (LeastRecentlyUsedCache.Timestamped)valuesIterator.next();
        MatcherAssert.assertThat((String)"missing 4.", (Object)timestamped, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        MatcherAssert.assertThat((Object)clone.size(), (Matcher)CoreMatchers.is((Object)3));
        this.assertOrder((LeastRecentlyUsedCache<Integer, String>)clone, false);
        Assert.assertTrue((boolean)clone.put((Object)id++, first.getValue(), first.getLastUpdate()));
        Assert.assertTrue((boolean)clone.put((Object)id++, timestamped.getValue(), timestamped.getLastUpdate()));
        Assert.assertFalse((boolean)clone.put((Object)id++, first.getValue(), first.getLastUpdate()));
        MatcherAssert.assertThat((Object)clone.size(), (Matcher)CoreMatchers.is((Object)3));
        this.assertOrder((LeastRecentlyUsedCache<Integer, String>)clone, false);
    }

    @Test
    public void testPutNewTimestamped() throws InterruptedException {
        int capacity = 5;
        int numberOfSessions = 5;
        this.givenACacheWithEntries(capacity, 300L, numberOfSessions);
        this.cache.setEvictingOnReadAccess(false);
        this.cache.setUpdatingOnReadAccess(false);
        this.time.addTestTimeShift(600L, TimeUnit.MILLISECONDS);
        LeastRecentlyUsedCache.Timestamped first = this.cache.getTimestamped((Object)0);
        long time = first.getLastUpdate();
        int id = capacity + 1;
        Assert.assertTrue((boolean)this.cache.put((Object)id, (Object)"new1", time));
        Assert.assertFalse((boolean)this.cache.put((Object)(id + 1), (Object)"new2", time - 1L));
        Assert.assertTrue((boolean)this.cache.put((Object)(id + 1), (Object)"new3", time + 1L));
        this.assertOrder(this.cache, false);
        MatcherAssert.assertThat((Object)this.cache.getTimestamped((Object)0), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        MatcherAssert.assertThat((Object)this.cache.getTimestamped((Object)id), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        MatcherAssert.assertThat((Object)this.cache.getTimestamped((Object)(id + 1)), (Matcher)CoreMatchers.is((Object)new LeastRecentlyUsedCache.Timestamped((Object)"new3", time + 1L)));
        LeastRecentlyUsedCache.Timestamped middle = this.cache.getTimestamped((Object)3);
        Assert.assertTrue((boolean)this.cache.put((Object)(id += 2), (Object)"new4", middle.getLastUpdate()));
        this.assertOrder(this.cache, false);
        Assert.assertTrue((boolean)this.cache.put((Object)(id + 1), (Object)"new5", middle.getLastUpdate() - 1L));
        this.assertOrder(this.cache, false);
        Assert.assertTrue((boolean)this.cache.put((Object)(id + 2), (Object)"new6", middle.getLastUpdate() + 1L));
        this.assertOrder(this.cache, false);
        MatcherAssert.assertThat((Object)this.cache.getTimestamped((Object)id), (Matcher)CoreMatchers.is((Object)new LeastRecentlyUsedCache.Timestamped((Object)"new4", middle.getLastUpdate())));
        MatcherAssert.assertThat((Object)this.cache.getTimestamped((Object)(id + 1)), (Matcher)CoreMatchers.is((Object)new LeastRecentlyUsedCache.Timestamped((Object)"new5", middle.getLastUpdate() - 1L)));
        MatcherAssert.assertThat((Object)this.cache.getTimestamped((Object)(id + 2)), (Matcher)CoreMatchers.is((Object)new LeastRecentlyUsedCache.Timestamped((Object)"new6", middle.getLastUpdate() + 1L)));
        LeastRecentlyUsedCache.Timestamped last = this.cache.getTimestamped((Object)4);
        Assert.assertTrue((boolean)this.cache.put((Object)(id += 3), (Object)"new7", last.getLastUpdate()));
        this.assertOrder(this.cache, false);
        Assert.assertTrue((boolean)this.cache.put((Object)(id + 1), (Object)"new8", last.getLastUpdate() - 1L));
        this.assertOrder(this.cache, false);
        Assert.assertTrue((boolean)this.cache.put((Object)(id + 2), (Object)"new9", last.getLastUpdate() + 1L));
        this.assertOrder(this.cache, false);
        MatcherAssert.assertThat((Object)this.cache.getTimestamped((Object)id), (Matcher)CoreMatchers.is((Object)new LeastRecentlyUsedCache.Timestamped((Object)"new7", last.getLastUpdate())));
        MatcherAssert.assertThat((Object)this.cache.getTimestamped((Object)(id + 1)), (Matcher)CoreMatchers.is((Object)new LeastRecentlyUsedCache.Timestamped((Object)"new8", last.getLastUpdate() - 1L)));
        MatcherAssert.assertThat((Object)this.cache.getTimestamped((Object)(id + 2)), (Matcher)CoreMatchers.is((Object)new LeastRecentlyUsedCache.Timestamped((Object)"new9", last.getLastUpdate() + 1L)));
    }

    @Test
    public void testPutUpdatedTimestamped() throws InterruptedException {
        int capacity = 5;
        int numberOfSessions = 5;
        this.givenACacheWithEntries(capacity, 300L, numberOfSessions);
        this.cache.setEvictingOnReadAccess(false);
        this.cache.setUpdatingOnReadAccess(false);
        this.time.addTestTimeShift(600L, TimeUnit.MILLISECONDS);
        LeastRecentlyUsedCache.Timestamped first = this.cache.getTimestamped((Object)0);
        long time = first.getLastUpdate();
        Assert.assertTrue((boolean)this.cache.put((Object)0, (Object)"new1", time));
        Assert.assertTrue((boolean)this.cache.put((Object)0, (Object)"new2", time - 1L));
        Assert.assertTrue((boolean)this.cache.put((Object)0, (Object)"new3", time + 1L));
        this.assertOrder(this.cache, false);
        MatcherAssert.assertThat((Object)this.cache.getTimestamped((Object)0), (Matcher)CoreMatchers.is((Object)new LeastRecentlyUsedCache.Timestamped((Object)"new3", time + 1L)));
        LeastRecentlyUsedCache.Timestamped middle = this.cache.getTimestamped((Object)3);
        Assert.assertTrue((boolean)this.cache.put((Object)3, (Object)"new4", middle.getLastUpdate()));
        this.assertOrder(this.cache, false);
        Assert.assertTrue((boolean)this.cache.put((Object)3, (Object)"new5", middle.getLastUpdate() - 1L));
        this.assertOrder(this.cache, false);
        Assert.assertTrue((boolean)this.cache.put((Object)3, (Object)"new6", middle.getLastUpdate() + 1L));
        this.assertOrder(this.cache, false);
        MatcherAssert.assertThat((Object)this.cache.getTimestamped((Object)3), (Matcher)CoreMatchers.is((Object)new LeastRecentlyUsedCache.Timestamped((Object)"new6", middle.getLastUpdate() + 1L)));
        LeastRecentlyUsedCache.Timestamped last = this.cache.getTimestamped((Object)4);
        Assert.assertTrue((boolean)this.cache.put((Object)4, (Object)"new7", last.getLastUpdate()));
        this.assertOrder(this.cache, false);
        Assert.assertTrue((boolean)this.cache.put((Object)4, (Object)"new8", last.getLastUpdate() - 1L));
        this.assertOrder(this.cache, false);
        Assert.assertTrue((boolean)this.cache.put((Object)4, (Object)"new9", last.getLastUpdate() + 1L));
        this.assertOrder(this.cache, false);
        MatcherAssert.assertThat((Object)this.cache.getTimestamped((Object)4), (Matcher)CoreMatchers.is((Object)new LeastRecentlyUsedCache.Timestamped((Object)"new9", last.getLastUpdate() + 1L)));
    }

    @Test
    public void testFindUniqueFailsWhenExpired() throws InterruptedException {
        int capacity = 5;
        int numberOfSessions = 3;
        this.givenACacheWithEntries(capacity, 300L, numberOfSessions);
        this.cache.setEvictingOnReadAccess(true);
        final String eldest = (String)this.cache.getEldest();
        LeastRecentlyUsedCache.Predicate<String> predicate = new LeastRecentlyUsedCache.Predicate<String>(){

            public boolean accept(String value) {
                return eldest.equals(value);
            }
        };
        MatcherAssert.assertThat((Object)this.cache.find((LeastRecentlyUsedCache.Predicate)predicate), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        this.time.setTestTimeShift(400L, TimeUnit.MILLISECONDS);
        MatcherAssert.assertThat((Object)this.cache.find((LeastRecentlyUsedCache.Predicate)predicate), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void testFindUniqueSucceedsEvenExpired() throws InterruptedException {
        int capacity = 5;
        int numberOfSessions = 3;
        this.givenACacheWithEntries(capacity, 300L, numberOfSessions);
        this.cache.setEvictingOnReadAccess(false);
        final String eldest = (String)this.cache.getEldest();
        LeastRecentlyUsedCache.Predicate<String> predicate = new LeastRecentlyUsedCache.Predicate<String>(){

            public boolean accept(String value) {
                return eldest.equals(value);
            }
        };
        MatcherAssert.assertThat((Object)this.cache.find((LeastRecentlyUsedCache.Predicate)predicate), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        this.time.setTestTimeShift(400L, TimeUnit.MILLISECONDS);
        MatcherAssert.assertThat((Object)this.cache.find((LeastRecentlyUsedCache.Predicate)predicate), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void testFindNoneUniqueSucceedsEvenFirstEvicted() throws InterruptedException {
        int capacity = 5;
        int numberOfSessions = 3;
        TimeAssume assume = new TimeAssume(this.time);
        this.givenACacheWithEntries(capacity, 300L, numberOfSessions);
        this.cache.setEvictingOnReadAccess(true);
        this.time.setFixedTestTime(true);
        assume.sleep(150L);
        SkipFirsts predicate = new SkipFirsts(1);
        String value = (String)this.cache.find((LeastRecentlyUsedCache.Predicate)predicate, false);
        MatcherAssert.assertThat((Object)value, assume.inTime(CoreMatchers.is((Matcher)CoreMatchers.notNullValue())));
        assume.sleep(175L);
        EvictionCounter counter = new EvictionCounter();
        this.cache.addEvictionListener((LeastRecentlyUsedCache.EvictionListener)counter);
        predicate = new SkipFirsts(0);
        MatcherAssert.assertThat((Object)this.cache.find((LeastRecentlyUsedCache.Predicate)predicate, false), assume.inTime(CoreMatchers.is((Object)value)));
        MatcherAssert.assertThat((Object)counter.count, (Matcher)CoreMatchers.is((Object)1));
    }

    @Test
    public void testStoreAddsNewValueIfCapacityNotReached() {
        int capacity = 10;
        this.givenACacheWithEntries(capacity, 0L, capacity - 1);
        MatcherAssert.assertThat((Object)this.cache.remainingCapacity(), (Matcher)CoreMatchers.is((Object)1));
        String eldest = (String)this.cache.getEldest();
        String newValue = "50";
        Assert.assertTrue((boolean)this.cache.put((Object)50, (Object)newValue));
        MatcherAssert.assertThat((Object)this.cache.get((Object)Integer.valueOf(eldest)), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        MatcherAssert.assertThat((Object)this.cache.remainingCapacity(), (Matcher)CoreMatchers.is((Object)0));
    }

    @Test
    public void testStoreEvictsEldestStaleEntry() {
        int capacity = 10;
        this.givenACacheWithEntries(capacity, 0L, capacity);
        MatcherAssert.assertThat((Object)this.cache.remainingCapacity(), (Matcher)CoreMatchers.is((Object)0));
        String eldest = (String)this.cache.getEldest();
        String newValue = "50";
        Assert.assertTrue((boolean)this.cache.put((Object)Integer.valueOf(newValue), (Object)newValue));
        MatcherAssert.assertThat((Object)this.cache.get((Object)Integer.valueOf(eldest)), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void testStoreFailsIfCapacityReached() {
        int capacity = 10;
        int numberOfSessions = 10;
        this.givenACacheWithEntries(capacity, 30000L, numberOfSessions);
        MatcherAssert.assertThat((Object)this.cache.remainingCapacity(), (Matcher)CoreMatchers.is((Object)0));
        String eldest = (String)this.cache.getEldest();
        String newValue = "50";
        Integer key = Integer.valueOf(newValue);
        Assert.assertFalse((boolean)this.cache.put((Object)key, (Object)newValue));
        MatcherAssert.assertThat((Object)this.cache.get((Object)key), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        MatcherAssert.assertThat((Object)this.cache.get((Object)Integer.valueOf(eldest)), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void testContinuousEviction() {
        int capacity = 10;
        this.givenACacheWithEntries(capacity, 0L, 0);
        MatcherAssert.assertThat((Object)this.cache.remainingCapacity(), (Matcher)CoreMatchers.is((Object)capacity));
        final AtomicInteger evicted = new AtomicInteger(0);
        this.cache.addEvictionListener((LeastRecentlyUsedCache.EvictionListener)new LeastRecentlyUsedCache.EvictionListener<String>(){

            public void onEviction(String evictedSession) {
                evicted.incrementAndGet();
            }
        });
        int noOfSessions = 1000;
        for (int i = 0; i < noOfSessions; ++i) {
            Integer key = i + 1000;
            String value = String.valueOf(key);
            Assert.assertTrue((boolean)this.cache.put((Object)key, (Object)value));
        }
        MatcherAssert.assertThat((Object)evicted.get(), (Matcher)CoreMatchers.is((Object)(noOfSessions - capacity)));
        MatcherAssert.assertThat((Object)this.cache.remainingCapacity(), (Matcher)CoreMatchers.is((Object)0));
    }

    private void assertOrder(LeastRecentlyUsedCache<Integer, String> cache, boolean print) {
        int index = 0;
        Iterator valuesIterator = cache.timestampedIterator();
        Long time = null;
        long last = 0L;
        while (valuesIterator.hasNext()) {
            LeastRecentlyUsedCache.Timestamped entry = (LeastRecentlyUsedCache.Timestamped)valuesIterator.next();
            if (time == null) {
                last = entry.getLastUpdate();
                time = last;
                if (print) {
                    System.out.println("start: " + time);
                }
            } else {
                long now = entry.getLastUpdate();
                MatcherAssert.assertThat((String)("order violation position " + index + " , value " + (String)entry.getValue()), (Object)now, (Matcher)CoreMatchers.is((Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(last))));
                last = now;
            }
            if (print) {
                long diff = entry.getLastUpdate() - time;
                System.out.println((String)entry.getValue() + ": " + diff);
            }
            ++index;
        }
    }

    private void givenACacheWithEntries(int capacity, long expirationThresholdMillis, int noOfEntries) {
        this.cache = new LeastRecentlyUsedCache(capacity, capacity, expirationThresholdMillis, TimeUnit.MILLISECONDS);
        for (int i = 0; i < noOfEntries; ++i) {
            this.cache.put((Object)i, (Object)Integer.toString(i));
        }
    }

    private static class EvictionCounter
    implements LeastRecentlyUsedCache.EvictionListener<String> {
        private int count;

        private EvictionCounter() {
        }

        public void onEviction(String value) {
            ++this.count;
        }
    }

    private static class SkipFirsts
    implements LeastRecentlyUsedCache.Predicate<String> {
        private int skipCount;

        private SkipFirsts(int skipCount) {
            this.skipCount = skipCount;
        }

        public boolean accept(String value) {
            return this.skipCount-- <= 0;
        }
    }
}

