/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.elements.util;

import java.net.InetSocketAddress;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.eclipse.californium.elements.Definition;
import org.eclipse.californium.elements.Definitions;
import org.eclipse.californium.elements.MapBasedEndpointContext;
import org.eclipse.californium.elements.rule.TestTimeRule;
import org.eclipse.californium.elements.util.Bytes;
import org.eclipse.californium.elements.util.ClockUtil;
import org.eclipse.californium.elements.util.DataStreamReader;
import org.eclipse.californium.elements.util.DatagramReader;
import org.eclipse.californium.elements.util.DatagramWriter;
import org.eclipse.californium.elements.util.SerializationUtil;
import org.eclipse.californium.elements.util.TestConditionTools;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class SerializationUtilTest {
    private static final long MILLISECOND_IN_NANOS = TimeUnit.MILLISECONDS.toNanos(1L);
    @Rule
    public TestTimeRule time = new TestTimeRule();
    DatagramWriter writer;
    DatagramReader reader;

    @Before
    public void setUp() throws Exception {
        this.writer = new DatagramWriter();
    }

    @Test
    public void testStrings() {
        String write = "Hallo!";
        SerializationUtil.write((DatagramWriter)this.writer, (String)write, (int)8);
        this.swap();
        String read = SerializationUtil.readString((DataStreamReader)this.reader, (int)8);
        Assert.assertEquals((Object)write, (Object)read);
    }

    @Test
    public void testNullStrings() {
        String write = null;
        SerializationUtil.write((DatagramWriter)this.writer, write, (int)8);
        this.swap();
        String read = SerializationUtil.readString((DataStreamReader)this.reader, (int)8);
        Assert.assertEquals(write, (Object)read);
    }

    @Test
    public void testEmptyStrings() {
        String write = "";
        SerializationUtil.write((DatagramWriter)this.writer, (String)write, (int)8);
        this.swap();
        String read = SerializationUtil.readString((DataStreamReader)this.reader, (int)8);
        Assert.assertEquals((Object)write, (Object)read);
    }

    @Test
    public void testAddressIpv4() {
        InetSocketAddress write = new InetSocketAddress("192.168.1.5", 5683);
        SerializationUtil.write((DatagramWriter)this.writer, (InetSocketAddress)write);
        this.swap();
        InetSocketAddress read = SerializationUtil.readAddress((DataStreamReader)this.reader);
        Assert.assertEquals((Object)write, (Object)read);
    }

    @Test
    public void testAddressUnresolved() {
        InetSocketAddress write = new InetSocketAddress("non-existing.host", 11111);
        SerializationUtil.write((DatagramWriter)this.writer, (InetSocketAddress)write);
        this.swap();
        InetSocketAddress read = SerializationUtil.readAddress((DataStreamReader)this.reader);
        Assert.assertEquals((Object)write, (Object)read);
    }

    @Test
    public void testAddressIpv6() {
        InetSocketAddress write = new InetSocketAddress("[2001::1]", 5684);
        SerializationUtil.write((DatagramWriter)this.writer, (InetSocketAddress)write);
        this.swap();
        InetSocketAddress read = SerializationUtil.readAddress((DataStreamReader)this.reader);
        Assert.assertEquals((Object)write, (Object)read);
    }

    @Test
    public void testEndpointContextAttributes() {
        Definitions test = MapBasedEndpointContext.ATTRIBUTE_DEFINITIONS;
        Definition K1 = new Definition("K1", String.class, test);
        Definition K2 = new Definition("K2", Integer.class, test);
        Definition K3 = new Definition("K3", Long.class, test);
        Definition K4 = new Definition("K4", Bytes.class, test);
        Definition K5 = new Definition("K5", Boolean.class, test);
        Definition K6 = new Definition("K6", InetSocketAddress.class, test);
        InetSocketAddress dummy = new InetSocketAddress(0);
        InetSocketAddress address = new InetSocketAddress("192.168.0.1", 5683);
        MapBasedEndpointContext.Attributes writeAttributes = new MapBasedEndpointContext.Attributes();
        writeAttributes.add(K1, (Object)"String");
        writeAttributes.add(K2, (Object)10);
        writeAttributes.add(K3, (Object)1000L);
        writeAttributes.add(K4, (Object)new Bytes("bytes".getBytes()));
        writeAttributes.add(K5, (Object)true);
        writeAttributes.add(K6, (Object)address);
        MapBasedEndpointContext context = new MapBasedEndpointContext(dummy, null, writeAttributes);
        Map write = context.entries();
        SerializationUtil.write((DatagramWriter)this.writer, (Map)write);
        this.swap();
        MapBasedEndpointContext.Attributes readAttributes = SerializationUtil.readEndpointContexAttributes((DataStreamReader)this.reader, (Definitions)test);
        context = new MapBasedEndpointContext(dummy, null, readAttributes);
        Map read = context.entries();
        Assert.assertEquals((Object)write, (Object)read);
        Assert.assertEquals((Object)writeAttributes, (Object)readAttributes);
    }

    @Test
    public void testNanotimeSynchronizationMark() {
        long timePassed = ClockUtil.nanoRealtime();
        SerializationUtil.writeNanotimeSynchronizationMark((DatagramWriter)this.writer);
        timePassed = ClockUtil.nanoRealtime() - timePassed;
        this.swap();
        timePassed -= ClockUtil.nanoRealtime();
        long delta = SerializationUtil.readNanotimeSynchronizationMark((DataStreamReader)this.reader);
        MatcherAssert.assertThat((Object)delta, (Matcher)CoreMatchers.is(TestConditionTools.inRange(-MILLISECOND_IN_NANOS, (timePassed += ClockUtil.nanoRealtime()) + MILLISECOND_IN_NANOS)));
    }

    @Test
    public void testNanotimeSynchronizationMarkWithTimeshift() {
        long timePassed = ClockUtil.nanoRealtime();
        SerializationUtil.writeNanotimeSynchronizationMark((DatagramWriter)this.writer);
        timePassed = ClockUtil.nanoRealtime() - timePassed;
        this.time.addTestTimeShift(10L, TimeUnit.MILLISECONDS);
        this.swap();
        timePassed -= ClockUtil.nanoRealtime();
        long delta = SerializationUtil.readNanotimeSynchronizationMark((DataStreamReader)this.reader);
        MatcherAssert.assertThat((Object)delta, (Matcher)CoreMatchers.is(TestConditionTools.inRange(9L * MILLISECOND_IN_NANOS, (timePassed += ClockUtil.nanoRealtime()) + 11L * MILLISECOND_IN_NANOS)));
    }

    private void swap() {
        this.reader = new DatagramReader(this.writer.toByteArray());
    }
}

