/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.elements.util;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.security.auth.x500.X500Principal;
import org.eclipse.californium.elements.util.JceProviderUtil;
import org.eclipse.californium.elements.util.SslContextUtil;
import org.eclipse.californium.elements.util.TestCertificatesTools;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.IsNull;
import org.junit.Assume;
import org.junit.Test;

public class SslContextUtilTrustTest {
    public static final String TRUST_STORE_PASSWORD_HEX = "726F6F7450617373";
    public static final String TRUST_P12_LOCATION = "classpath://certs/trustStore.p12";
    public static final String TRUST_PEM_LOCATION = "classpath://certs/trustStore.pem";
    public static final char[] TRUST_STORE_WRONG_PASSWORD = "wrongPass".toCharArray();
    public static final String ALIAS_CA = "ca";
    public static final String ALIAS_MISSING = "missing";
    public static final X500Principal DN_CA = new X500Principal("C=CA, L=Ottawa, O=Eclipse IoT, OU=Californium, CN=cf-ca");
    public static final X500Principal DN_CA2 = new X500Principal("C=CA, L=Ottawa, O=Eclipse IoT, OU=Californium, CN=cf-ca2");
    public static final X500Principal DN_CA_RSA = new X500Principal("C=CA, L=Ottawa, O=Eclipse IoT, OU=Californium, CN=cf-ca-rsa");
    public static final X500Principal DN_ROOT = new X500Principal("C=CA, L=Ottawa, O=Eclipse IoT, OU=Californium, CN=cf-root");

    @Test
    public void testLoadTrustedCertificates() throws IOException, GeneralSecurityException {
        Certificate[] trustedCertificates = SslContextUtil.loadTrustedCertificates((String)"classpath://certs/trustStore.jks", null, (char[])TestCertificatesTools.TRUST_STORE_PASSWORD);
        MatcherAssert.assertThat((Object)trustedCertificates, (Matcher)CoreMatchers.is((Matcher)IsNull.notNullValue()));
        MatcherAssert.assertThat((Object)trustedCertificates.length, (Matcher)CoreMatchers.is((Object)5));
        MatcherAssert.assertThat((Object)trustedCertificates[0], (Matcher)CoreMatchers.is((Matcher)Matchers.instanceOf(X509Certificate.class)));
        MatcherAssert.assertThat((Object)trustedCertificates[0].getPublicKey(), (Matcher)CoreMatchers.is((Matcher)IsNull.notNullValue()));
        X509Certificate x509 = (X509Certificate)trustedCertificates[0];
        MatcherAssert.assertThat((Object)x509.getSubjectX500Principal(), (Matcher)CoreMatchers.anyOf((Matcher)CoreMatchers.is((Object)DN_CA), (Matcher)CoreMatchers.is((Object)DN_CA2), (Matcher)CoreMatchers.is((Object)DN_CA_RSA), (Matcher)CoreMatchers.is((Object)DN_ROOT)));
    }

    @Test
    public void testLoadFilteredTrustedCertificates() throws IOException, GeneralSecurityException {
        Certificate[] trustedCertificates = SslContextUtil.loadTrustedCertificates((String)"classpath://certs/trustStore.jks", (String)ALIAS_CA, (char[])TestCertificatesTools.TRUST_STORE_PASSWORD);
        MatcherAssert.assertThat((Object)trustedCertificates, (Matcher)CoreMatchers.is((Matcher)IsNull.notNullValue()));
        MatcherAssert.assertThat((Object)trustedCertificates.length, (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat((Object)trustedCertificates[0], (Matcher)CoreMatchers.is((Matcher)Matchers.instanceOf(X509Certificate.class)));
        X509Certificate x509 = (X509Certificate)trustedCertificates[0];
        MatcherAssert.assertThat((Object)x509.getSubjectX500Principal(), (Matcher)CoreMatchers.is((Object)DN_CA));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testLoadFilteredTrustedCertificatesNotFound() throws IOException, GeneralSecurityException {
        SslContextUtil.loadTrustedCertificates((String)"classpath://certs/trustStore.jks", (String)ALIAS_MISSING, (char[])TestCertificatesTools.TRUST_STORE_PASSWORD);
    }

    @Test(expected=IOException.class)
    public void testLoadTrustedCertificatesNoFile() throws IOException, GeneralSecurityException {
        SslContextUtil.loadTrustedCertificates((String)"classpath://certs/trustStore.jksno-file", null, (char[])TestCertificatesTools.TRUST_STORE_PASSWORD);
    }

    @Test(expected=NullPointerException.class)
    public void testLoadTrustedCertificatesNullUri() throws IOException, GeneralSecurityException {
        SslContextUtil.loadTrustedCertificates(null, null, (char[])TestCertificatesTools.TRUST_STORE_PASSWORD);
    }

    @Test(expected=NullPointerException.class)
    public void testLoadTrustedCertificatesNoPassword() throws IOException, GeneralSecurityException {
        SslContextUtil.loadTrustedCertificates((String)"classpath://certs/trustStore.jks", null, null);
    }

    @Test(expected=IOException.class)
    public void testLoadTrustedCertificatesWrongPassword() throws IOException, GeneralSecurityException {
        SslContextUtil.loadTrustedCertificates((String)"classpath://certs/trustStore.jks", null, (char[])TRUST_STORE_WRONG_PASSWORD);
    }

    @Test
    public void testLoadTrustedCertificatesSingleParameterWithoutAlias() throws IOException, GeneralSecurityException {
        Certificate[] trustedCertificates = SslContextUtil.loadTrustedCertificates((String)"classpath://certs/trustStore.jks#726F6F7450617373#");
        MatcherAssert.assertThat((Object)trustedCertificates, (Matcher)CoreMatchers.is((Matcher)IsNull.notNullValue()));
        MatcherAssert.assertThat((Object)trustedCertificates.length, (Matcher)CoreMatchers.is((Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0))));
        MatcherAssert.assertThat((Object)trustedCertificates[0], (Matcher)CoreMatchers.is((Matcher)Matchers.instanceOf(X509Certificate.class)));
        MatcherAssert.assertThat((Object)trustedCertificates[0].getPublicKey(), (Matcher)CoreMatchers.is((Matcher)IsNull.notNullValue()));
    }

    @Test
    public void testLoadTrustedCertificatesSingleParameter() throws IOException, GeneralSecurityException {
        Certificate[] trustedCertificates = SslContextUtil.loadTrustedCertificates((String)"classpath://certs/trustStore.jks#726F6F7450617373#ca");
        MatcherAssert.assertThat((Object)trustedCertificates, (Matcher)CoreMatchers.is((Matcher)IsNull.notNullValue()));
        MatcherAssert.assertThat((Object)trustedCertificates.length, (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat((Object)trustedCertificates[0], (Matcher)CoreMatchers.is((Matcher)Matchers.instanceOf(X509Certificate.class)));
        X509Certificate x509 = (X509Certificate)trustedCertificates[0];
        MatcherAssert.assertThat((Object)x509.getSubjectX500Principal(), (Matcher)CoreMatchers.is((Object)DN_CA));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testLoadTrustedCertificatesSingleParameterError() throws IOException, GeneralSecurityException {
        SslContextUtil.loadTrustedCertificates((String)"classpath://certs/trustStore.jks#726F6F7450617373");
    }

    @Test
    public void testLoadTrustManager() throws IOException, GeneralSecurityException {
        TrustManager[] manager = SslContextUtil.loadTrustManager((String)"classpath://certs/trustStore.jks", null, (char[])TestCertificatesTools.TRUST_STORE_PASSWORD);
        MatcherAssert.assertThat((Object)manager, (Matcher)CoreMatchers.is((Matcher)IsNull.notNullValue()));
        MatcherAssert.assertThat((Object)manager.length, (Matcher)CoreMatchers.is((Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0))));
        MatcherAssert.assertThat((Object)manager[0], (Matcher)CoreMatchers.is((Matcher)Matchers.instanceOf(X509TrustManager.class)));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testLoadTrustManagerCertificateNotFound() throws IOException, GeneralSecurityException {
        SslContextUtil.loadTrustManager((String)"classpath://certs/trustStore.jks", (String)ALIAS_MISSING, (char[])TestCertificatesTools.TRUST_STORE_PASSWORD);
    }

    @Test
    public void testCreateTrustManager() throws IOException, GeneralSecurityException {
        Certificate[] trustedCertificates = SslContextUtil.loadTrustedCertificates((String)"classpath://certs/trustStore.jks", null, (char[])TestCertificatesTools.TRUST_STORE_PASSWORD);
        TrustManager[] manager = SslContextUtil.createTrustManager((String)"test", (Certificate[])trustedCertificates);
        MatcherAssert.assertThat((Object)manager, (Matcher)CoreMatchers.is((Matcher)IsNull.notNullValue()));
        MatcherAssert.assertThat((Object)manager.length, (Matcher)CoreMatchers.is((Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0))));
        MatcherAssert.assertThat((Object)manager[0], (Matcher)CoreMatchers.is((Matcher)Matchers.instanceOf(X509TrustManager.class)));
    }

    @Test(expected=NullPointerException.class)
    public void testCreateTrustManagerNullCertificates() throws IOException, GeneralSecurityException {
        SslContextUtil.createTrustManager((String)"test", null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testCreateTrustManagerEmptyCertificates() throws IOException, GeneralSecurityException {
        SslContextUtil.createTrustManager((String)"test", (Certificate[])new Certificate[0]);
    }

    @Test
    public void testLoadP12TrustedCertificates() throws IOException, GeneralSecurityException {
        Assume.assumeTrue((String)"requires strong encryption", (boolean)JceProviderUtil.hasStrongEncryption());
        Certificate[] trustedCertificates = SslContextUtil.loadTrustedCertificates((String)TRUST_P12_LOCATION, null, (char[])TestCertificatesTools.TRUST_STORE_PASSWORD);
        MatcherAssert.assertThat((Object)trustedCertificates, (Matcher)CoreMatchers.is((Matcher)IsNull.notNullValue()));
        MatcherAssert.assertThat((Object)trustedCertificates.length, (Matcher)CoreMatchers.is((Object)5));
        X509Certificate x509 = (X509Certificate)trustedCertificates[0];
        MatcherAssert.assertThat((Object)x509.getPublicKey(), (Matcher)CoreMatchers.is((Matcher)IsNull.notNullValue()));
        MatcherAssert.assertThat((Object)x509.getSubjectX500Principal(), (Matcher)CoreMatchers.anyOf((Matcher)CoreMatchers.is((Object)DN_CA), (Matcher)CoreMatchers.is((Object)DN_CA2), (Matcher)CoreMatchers.is((Object)DN_CA_RSA), (Matcher)CoreMatchers.is((Object)DN_ROOT)));
    }

    @Test
    public void testLoadP12TrustedCertificatesWithAlias() throws IOException, GeneralSecurityException {
        Assume.assumeTrue((String)"requires strong encryption", (boolean)JceProviderUtil.hasStrongEncryption());
        Certificate[] trustedCertificates = SslContextUtil.loadTrustedCertificates((String)TRUST_P12_LOCATION, (String)ALIAS_CA, (char[])TestCertificatesTools.TRUST_STORE_PASSWORD);
        MatcherAssert.assertThat((Object)trustedCertificates, (Matcher)CoreMatchers.is((Matcher)IsNull.notNullValue()));
        MatcherAssert.assertThat((Object)trustedCertificates.length, (Matcher)CoreMatchers.is((Object)1));
        X509Certificate x509 = (X509Certificate)trustedCertificates[0];
        MatcherAssert.assertThat((Object)x509.getPublicKey(), (Matcher)CoreMatchers.is((Matcher)IsNull.notNullValue()));
        MatcherAssert.assertThat((Object)x509.getSubjectX500Principal(), (Matcher)CoreMatchers.is((Object)DN_CA));
    }

    @Test
    public void testLoadP12TrustManager() throws IOException, GeneralSecurityException {
        Assume.assumeTrue((String)"requires strong encryption", (boolean)JceProviderUtil.hasStrongEncryption());
        TrustManager[] manager = SslContextUtil.loadTrustManager((String)TRUST_P12_LOCATION, null, (char[])TestCertificatesTools.TRUST_STORE_PASSWORD);
        MatcherAssert.assertThat((Object)manager, (Matcher)CoreMatchers.is((Matcher)IsNull.notNullValue()));
        MatcherAssert.assertThat((Object)manager.length, (Matcher)CoreMatchers.is((Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0))));
        MatcherAssert.assertThat((Object)manager[0], (Matcher)CoreMatchers.is((Matcher)Matchers.instanceOf(X509TrustManager.class)));
    }

    @Test
    public void testLoadP12TrustManagerWithAlias() throws IOException, GeneralSecurityException {
        Assume.assumeTrue((String)"requires strong encryption", (boolean)JceProviderUtil.hasStrongEncryption());
        TrustManager[] manager = SslContextUtil.loadTrustManager((String)TRUST_P12_LOCATION, (String)ALIAS_CA, (char[])TestCertificatesTools.TRUST_STORE_PASSWORD);
        MatcherAssert.assertThat((Object)manager, (Matcher)CoreMatchers.is((Matcher)IsNull.notNullValue()));
        MatcherAssert.assertThat((Object)manager.length, (Matcher)CoreMatchers.is((Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0))));
        MatcherAssert.assertThat((Object)manager[0], (Matcher)CoreMatchers.is((Matcher)Matchers.instanceOf(X509TrustManager.class)));
    }

    @Test
    public void testLoadPemTrustedCertificates() throws IOException, GeneralSecurityException {
        Certificate[] trustedCertificates = SslContextUtil.loadTrustedCertificates((String)TRUST_PEM_LOCATION, null, null);
        MatcherAssert.assertThat((Object)trustedCertificates, (Matcher)CoreMatchers.is((Matcher)IsNull.notNullValue()));
        MatcherAssert.assertThat((Object)trustedCertificates.length, (Matcher)CoreMatchers.is((Object)5));
        X509Certificate x509 = (X509Certificate)trustedCertificates[0];
        MatcherAssert.assertThat((Object)x509.getPublicKey(), (Matcher)CoreMatchers.is((Matcher)IsNull.notNullValue()));
        MatcherAssert.assertThat((Object)x509.getSubjectX500Principal(), (Matcher)CoreMatchers.anyOf((Matcher)CoreMatchers.is((Object)DN_CA), (Matcher)CoreMatchers.is((Object)DN_CA2), (Matcher)CoreMatchers.is((Object)DN_CA_RSA), (Matcher)CoreMatchers.is((Object)DN_ROOT)));
    }

    @Test
    public void testLoadPemTrustManager() throws IOException, GeneralSecurityException {
        TrustManager[] manager = SslContextUtil.loadTrustManager((String)TRUST_PEM_LOCATION, null, null);
        MatcherAssert.assertThat((Object)manager, (Matcher)CoreMatchers.is((Matcher)IsNull.notNullValue()));
        MatcherAssert.assertThat((Object)manager.length, (Matcher)CoreMatchers.is((Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0))));
        MatcherAssert.assertThat((Object)manager[0], (Matcher)CoreMatchers.is((Matcher)Matchers.instanceOf(X509TrustManager.class)));
    }
}

